--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Interfaces;
with Ada.Strings.Unbounded;
with System;

package Low_Level_Network.Types is

   type Network_Address_Type is array (1 .. 4) of Interfaces.Unsigned_8;

   type Ethernet_Interface_Type is record
      Name : Ada.Strings.Unbounded.Unbounded_String;
      Address : Network_Address_Type;
   end record;
   type Interfaces_Array is array (Positive range <>)
     of Ethernet_Interface_Type;

   type Interface_String is array (1 .. 16) of Character;
   type Address_Field is array (1 .. 14) of Interfaces.Unsigned_8;
   type Address_Req_Type is record
      Interface_Name : Interface_String;
      Length : Interfaces.Unsigned_8;
      Family : Interfaces.Unsigned_8;
      Address : Address_Field;
   end record;
   for Address_Req_Type use record
      Interface_Name at 0 range 0 .. 127;
      Length at 16 range 0 .. 7;
      Family at 16 range 8 .. 15;
      Address at 18 range 0 .. 111;
   end record;
   for Address_Req_Type'Size use 256;

   type Address_Req_Array is array (Positive range <>) of Address_Req_Type;

   type Ifconf_Type is record
      Length : Integer;
      Req_Address : System.Address;
   end record;

end Low_Level_Network.Types;
