--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Shell_Commands;
with Get_Command;
with Help;
with Launch_Command;
with Send_Order_Command;
with Set_Command;
with Load_Command;
with Sleep_Command;
with Wait_Command;
with Echo_Command;
with Group_Command;

function Exec_Command (Shell_Line : String) return String is
   Command : Shell_Commands.Command_Type;
begin
   Command := Shell_Commands.Find (Shell_Line);
   case Command is
      when Shell_Commands.Get =>
         return Get_Command.Get (Shell_Line);
      when Shell_Commands.Help =>
         return Help (Shell_Line);
      when Shell_Commands.Launch =>
         return Launch_Command.Launch (Shell_Line);
      when Shell_Commands.Send_Order =>
         return Send_Order_Command.Send_Order
              (Shell_Line);
      when Shell_Commands.Set =>
         return Set_Command.Set (Shell_Line);
      when Shell_Commands.Load =>
         return Load_Command.Load (Shell_Line);
      when Shell_Commands.Sleep =>
         return Sleep_Command.Sleep (Shell_Line);
      when Shell_Commands.Wait =>
         return Wait_Command.Wait (Shell_Line);
      when Shell_Commands.Echo =>
         return Echo_Command.Set_Echo (Shell_Line);
      when Shell_Commands.Dump =>
         --  System.Garlic.Partitions.Dump_Partition_Table;
         null;
         return "<result cmd=""dump"" status=""OK""><msg>dump done " &
           "on shell screen</msg></result>";
      when Shell_Commands.Group =>
         return Group_Command.Group (Shell_Line);
      when Shell_Commands.Special_Domi =>
         return Send_Order_Command.Special_Domi (Shell_Line);
   end case;
end Exec_Command;
