/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * LV2 bridging helper library
 *
 * Copyright (C) 2007-2011 NASPRO Bridge it development team
 *
 * See the COPYING file for license conditions.
 */

#include "internal.h"

_NABRIT_DEF nabrit_pluglib
nabrit_pluglib_new(nabrit_bridge bridge, const char *filename)
{
	struct _nabrit_pluglib pluglib;
	nabrit_pluglib ret;
	nacore_list_elem elem;
	char unlock;

	pluglib.plugins = nacore_list_new(_nabrit_plugin_get_size);
	if (pluglib.plugins == NULL)
		return NULL;

	pluglib.filename	= filename;
	pluglib.opaque		= NULL;

	unlock = nabrit_bridge_begin_op(bridge) == 0;

	elem = nacore_list_append(bridge->pluglibs, NULL, &pluglib);
	if (elem == NULL)
	  {
		if (unlock)
			nabrit_bridge_end_op(bridge);
		nacore_list_free(pluglib.plugins, NULL, NULL);
		errno = ENOMEM;
		return NULL;
	  }

	ret = nacore_list_elem_get_value(bridge->pluglibs, elem);

	if (unlock)
		nabrit_bridge_end_op(bridge);

	return ret;
}

typedef struct
  {
	nacore_op_with_msg_cb	 free_cb;
	void			*free_opaque;
	nacore_msg_context	 msg_context;
	void			*msg_opaque;
  } plugin_free_data_t;

static void
plugin_free_cb(void *value, void *opaque)
{
	nabrit_plugin p;
	plugin_free_data_t *o;
	nacore_msg_context ctx;

	p = (nabrit_plugin)value;
	o = (plugin_free_data_t *)opaque;

	ctx = nacore_msg_status_begin(o->msg_context, o->msg_opaque,
				      "Unloading plugin %s", p->descriptor.URI);

	o->free_cb(p, ctx, o->msg_opaque, o->free_opaque);

	nacore_msg_status_end(ctx, nacore_msg_result_ok);
}

_NABRIT_DEF void
nabrit_pluglib_free_plugins(nabrit_bridge bridge, nabrit_pluglib pluglib,
			    nacore_op_with_msg_cb free_cb, void *free_opaque,
			    nacore_msg_context msg_context, void *msg_opaque)
{
	plugin_free_data_t opaque;
	nacore_msg_context ctx;
	char unlock;

	opaque.free_cb		= free_cb;
	opaque.free_opaque	= free_opaque;
	opaque.msg_opaque	= msg_opaque;

	ctx = nacore_msg_status_begin(msg_context , msg_opaque ,
				      "Unloading plugins");
	opaque.msg_context = ctx;

	unlock = nabrit_bridge_begin_op(bridge) == 0;

	nacore_list_free(pluglib->plugins,
			 (free_cb != NULL) ? plugin_free_cb : NULL, &opaque);

	if (unlock)
		nabrit_bridge_end_op(bridge);

	nacore_msg_status_end(ctx, nacore_msg_result_ok);
}

_NABRIT_DEF const char *
nabrit_pluglib_get_filename(nabrit_pluglib pluglib)
{
	return pluglib->filename;
}

_NABRIT_DEF void *
nabrit_pluglib_get_opaque(nabrit_pluglib pluglib)
{
	return pluglib->opaque;
}

_NABRIT_DEF void
nabrit_pluglib_set_opaque(nabrit_pluglib pluglib, void *opaque)
{
	pluglib->opaque = opaque;
}

NACORE_PRIVATE size_t
_nabrit_pluglib_get_size(const void *value, void *opaque)
{
	return sizeof(struct _nabrit_pluglib);
}
