/*
 * NASPRO - NASPRO Architecture for Sound Processing
 * LADSPA bridge
 *
 * Copyright (C) 2007-2010 Stefano D'Angelo <zanga.mail@gmail.com>
 *
 * See the COPYING file for license conditions.
 */

#include <stdio.h>

#include "dyn-manifest.h"

#include <NASPRO/core/lib.h>

#include "pluglib.h"
#include "lv2api.h"

/* TODO: Until a serious rescan/automagical discovery policy emerges, we perform
 *       discovery only once at initialization time. */

static char inited = 0;
static char descs_ok = 0;

int
lv2_dyn_manifest_open(LV2_Dyn_Manifest_Handle *handle,
                      const LV2_Feature *const *features)
{
	static char called = 0;

	if (called)
		return -1;
	called = 1;
	
	if (!inited)
	  {
		_naladspa_pluglib_load_all();
		descs_ok = _naladspa_lv2api_generate_descs() >= 0;
		inited = 1;
	  }

	*handle = NULL;

	if (_naladspa_pluglib_desc_tree == NULL)
		return -1;

	called = 0;

	return 0;
}

static void __attribute__((destructor))
fini()
{
	_naladspa_pluglib_unload_all();
	_naladspa_lv2api_free_descs();
}

static void
print_subject(void *content, void *data)
{
	nacore_manifest_print_subject_triple(
		(struct nacore_descriptor *)content, (FILE *)data);
}

int
lv2_dyn_manifest_get_subjects(LV2_Dyn_Manifest_Handle handle, FILE *fp)
{
	if (descs_ok == 0)
		return 0;

	nacore_manifest_print_subject_prefixes(fp);

	nacore_avl_tree_for_each(_naladspa_pluglib_desc_tree, print_subject,
				 (void *)fp);

	return 0;
}

int
lv2_dyn_manifest_get_data(LV2_Dyn_Manifest_Handle handle, FILE *fp,
			  const char *uri)
{
	struct nacore_descriptor *d;

	if (descs_ok == 0)
		return 0;

	d = (struct nacore_descriptor *)nacore_avl_tree_find(
		_naladspa_pluglib_desc_tree, (void *)uri);
	if (d == NULL)
		return -1;

	nacore_manifest_print_data(d, fp, "ladspa");
	
	return 0;
}

void
lv2_dyn_manifest_close(LV2_Dyn_Manifest_Handle handle)
{
}
