/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2011 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

/*
   Title: NASPRO core

   *Version*: 0.2.91, *API*: 3.1.0.

   About:

     <NASPRO core at http://naspro.atheme.org/naspro-core/> is the portable
     runtime library at the bottom of the <NASPRO Sound PROcessing Architecture
     at http://naspro.atheme.org/>.

     It abstracts away some platform- and compiler-specific features, implements
     a small collection of abstract data types and provides a couple of useful
     APIs to help with software development in general.

     It is written in C99 and is almost entirely reentrant and thread-safe.

   Supported platforms/compilers:

     It should work on all POSIX-1.2008-compliant platforms, assuming that
     malloc() and free() are thread-safe and errno is thread-local.

     It does also work on Windows XP or later, 32 and 64 bit versions.

     It has only been built and tested using the <GCC at http://gcc.gnu.org/>
     compiler, for which it has special support and whose version is supposed to
     be >= 2.95. Adding support for other compilers, if needed at all, should be
     relatively easy.

   API conventions:

     * All functions are thread-safe and reentrant, unless otherwise specified;
     * All strings are null-terminated and UTF-8 encoded according to the
       Unicode 6.0 standard and without BOM (byte-order-mark) characters, unless
       otherwise specified;
     * No function does input validation, hence, in case the API is misused in
       this sense, the results are undefined.

   Runtime dependencies:

     * Standard C and math libraries.

   Build-time dependencies:

     * An environment capable of running Autotools-based build systems;
     * (optional) <GNU Autoconf at http://www.gnu.org/software/autoconf/> >=
       2.61, <GNU Automake at http://www.gnu.org/software/automake/> and
       <GNU Libtool at http://www.gnu.org/software/libtool/> to regenerate the
       build system;
     * (optional) <Natural Docs at http://www.naturaldocs.org/> >= 1.5 to
       regenerate the build system and/or the documentation.

   Usage:

      Just include <NASPRO/core/lib.h> in your source files and use the
      <pkg-config at http://pkg-config.freedesktop.org/> tool to retrieve
      compiler and linker flags (package name: nacore-3).
 */

#ifndef _NASPRO_CORE_LIB_H
#define _NASPRO_CORE_LIB_H

#include <stddef.h>
#include <stdarg.h>
#include <inttypes.h>
#include <errno.h>

#include <math.h>

#include <NASPRO/core/cc.h>

#ifdef _NACORE_INTERNAL_H
# define _NACORE_DEF		NACORE_PUBLIC NACORE_EXPORT
#else
# define _NACORE_DEF		NACORE_PUBLIC NACORE_IMPORT
#endif

#include <NASPRO/core/types.h>
#include <NASPRO/core/mutex.h>
#include <NASPRO/core/list.h>
#include <NASPRO/core/avl.h>
#include <NASPRO/core/string.h>
#include <NASPRO/core/msg.h>
#include <NASPRO/core/env.h>
#include <NASPRO/core/dl.h>
#include <NASPRO/core/fs.h>

#endif
