/*  $Id: institution_codes.inc 607542 2020-05-05 14:51:12Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Jonathan Kans et al.
 *
 * File Description:
 *   Built-in copy of institution_codes.txt.
 *
 */

static const char* const kInstitutionCollectionCodeList[] = {
"# $Id: institution_codes.inc 607542 2020-05-05 14:51:12Z ivanov $",
"A\ts\tArnold Arboretum, Harvard University\t\t\t",
"AA\ts\tMinistry of Science, Academy of Sciences\t\t\t",
"AAC\tc\tArignar Anna College\t\t\t",
"AAH\ts\tArnold Arboretum, Harvard University\t\t\t",
"AAMU\ts\tAlabama Agricultural and Mechanical University\t\t\t",
"AAPI\ts\tPlant Industry Laboratory\t\t\t",
"AAR\ts\tReliquae Aaronsohnianae\t\t\t",
"AARI\ts\tAnatolian Agricultural Research Institute\t\t\t",
"AAS\ts\tBritish Antarctic Survey\t\t\t",
"AASU\ts\tArmstrong State University\t\t\t",
"AAU\ts\tUniversity of Aarhus, Institute of Biological Sciences\t\t\t",
"AAU<ETH>\ts\tAddis Ababa University, Department of Biology\t\t\t",
"AAU<ETH>:A\ts\tAddis Ababa University, Department of Biology, Amphibian collection\t\t",
"AAUB\ts\tAnhui Agricultural University, Department of Basic Courses\t\t\t",
"AAUF\ts\tAnhui Agricultural University, Forest Utilization Faculty\t\t\t",
"ABB\tc\tAsian Bacterial Bank\t\t\t",
"ABD\ts\tUniversity of Aberdeen, Plant and Soil Science Department\t\t\t",
"ABDAM\ts\tAberdeen Art Gallery and Museum\t\t\t",
"ABDC\ts\tAba Institute for Drug Control\t\t\t",
"ABDF\ts\tUniversity of Aberdeen, Forestry Department\t\t\t",
"ABDH\ts\tUnited Arab Emirates University, Department of Biology\t\t\t",
"ABDM\ts\tMarischal College, University of Aberdeen\t\t\t",
"ABFM\ts\tThe Barnes Foundation Arboretum\t\t\t",
"ABH\ts\tUniversidad de Alicante, Centro Iberoamericano de la Biodiversidad (CIBIO)\t\t\t",
"ABI\ts\tCentre ORSTOM d'Adiopodoume\t\t\t",
"ABKMI\tc\tDepartment of Applied Biology, Faculty of science\t\t\t",
"ABL\ts\tAdviesbureau voor Bryologie en Lichenologie\t\t\t",
"ABN\ts\tRadley College\t\t\t",
"ABO\ts\tAboyne Castle\t\t\t",
"ABRC\tb\tArabidopsis Biological Resource Center\t\t\t",
"ABRIICC\tc\tABRIICC Agricultural Biotechnology Research Institute of Iran Culture collection\t\t\t",
"ABRN\ts\tCentre for Ecology and Hydrology\t\t\t",
"ABS<UK>\tsc\tAberystwyth University, Institute of Biological, Environmental and Rural Sciences\t\t\t",
"ABS<USA>\ts\tArchbold Biological Station\t\t\t",
"ABSH\ts\tSouthern Illinois Universitiy, Department of Plant Biology\t\t\t",
"ABSL\ts\tUniversity of Minnesota, American Bryological and Lichenological Society\t\t\t",
"ABSM\ts\tDuke University, Botany Department\t\t\t",
"ABT\ts\tLaboratoire de Biologie Vegetale et d'Ecologie Forestiere\t\t\t",
"ABTC\ts\tAustralian Biological Tissue Collection, South Australian Museum\tSAMA:ABTC\t\t",
"ABTRI\tc\tApex Biotechnology Training and Research Institute\t\t\t",
"ABU<NGA>\ts\tAhmadu Bello University Herbarium\t\t\t",
"AC\ts\tAmherst College\t\t\t",
"ACA\ts\tAgricultural University of Athens\t\t\t",
"ACA-DC\tc\tGreek Coordinated Collections of Microorganisms\t\t\t",
"ACAD\ts\tAcadia University, K. C. Irving Environmental Science Centre & Harriet Irving Botanical Gardens\t\t\t",
"ACAD<AUS>\tsb\tAustralian Centre for Ancient DNA\t\t\t",
"ACAM\tc\tThe Australian Collection of Antarctic Microorganisms, Cooperative Research Center for the Antarctic and Southern Ocean Environment\t\t\t",
"ACAP\ts\tAquaculture Center of Aomori Prefecture\t\t\t",
"ACBC\ts\tAgriculture Canada Research Station\t\t\t",
"ACBR\tc\tAustrian Center of Biological Resources and Applied Mycology\t\t\t",
"ACBV\ts\tAgriculture Canada Research Station, The Aphids of British Columbia\t\t\t",
"ACC\ts\tOak Hill Park Museum\t\t\t",
"ACCC\tc\tAgricultural Culture Collection of China\t\t\t",
"ACD\ts\tAlemaya University of Agriculture\t\t\t",
"ACE<CHN>\ts\tAnhui College of Education, Biology Department\t\t\t",
"ACE<EGY>\ts\tArachnid Collection of Egypt\t\t\t",
"ACH\tc\tNational Mycology Reference Centre, SA Pathology\t\t\t",
"ACHE\ts\tInstitute of Terrestrial Ecology\t\t\t",
"ACK\ts\tAgriculture and Agri-Food Canada, substation of Lethbridge Research Centre\t\t\t",
"ACM\tc\tAustralian Collection of Microorganisms\t\t\t",
"ACM<CHN>\ts\tAnhui College of Traditional Chinese Medicine, Chinese Materia Medica Department\t\t\t",
"ACNB\ts\tAgriculture Canada Research Station\t\t\t",
"ACNS\ts\tAgriculture Canada Nova Scotia\t\t\t",
"ACOI\tc\tCoimbra Collection of Algae\t\t\t",
"ACOR\ts\tUniversidad Nacional de Cordoba\t\t\t",
"ACSSI\tc\tAlgal Collection of Soil Science Institute\t\t\t",
"ACTC\ts\tAustin College\t\t\t",
"ACU\ts\tAbilene Christian University\t\t\t",
"ACUNHC\ts\tAbilene Christian University, Natural History Collection\t\t\t",
"AD\ts\tState Herbarium of South Australia\t\t\t",
"ADA\ts\tHerbarium, Department of Agriculture, South Australia\t\t\t",
"ADMONT\ts\tBenediktinerstift Admont\t\t\t",
"ADO\ts\tKirikkale University, Biology Department\t\t\t",
"ADR\ts\tAdrian College, Biology Department\t\t\t",
"ADRZ\ts\tRudjer Boskovic Institute (Herbarium Adriaticum)\t\t\t",
"ADSH\ts\tArachnology Division\t\t\t",
"ADT\ts\tAntarctic Division\t\t\t",
"ADU\ts\tUniversity of Adelaide, Botany Department\t\t\t",
"ADUG\ts\tGeology Department, University of Adelaide\t\t\t",
"ADUZ\ts\tZoology Department, University of Adelaide\t\t\t",
"ADW\ts\tUniversity of Adelaide\t\t\t",
"AEF\ts\tUniversity of Ankara, Department of Pharmaceutical Botany\t\t\t",
"AEI\ts\tAmerican Entomological Institute\tAEIC\t\t",
"AEIC\ts\tAmerican Entomological Institute\tAEI\t\t",
"AES\ts\tHerbarium, Agricultural and Forestry Experiment Station, University of Alaska\t\t\t",
"AESB\ts\tAgriculture Experiment Station\t\t\t",
"AF\ts\tAlpine Fungarium\t\t\t",
"AFAQ\ts\tAmateur Fisheries Association of Queensland\t\t\t",
"AFES\ts\tMaritimes Forest Research Centre\t\t\t",
"AFGMC\ts\tAlaska Department of Fish and Game\t\t\t",
"AFR\ts\tFundacao Jardim Botanico de Pocos de Caldas\t\t\t",
"AFS\ts\tAmerican Fern Society Herbarium\t\t\t",
"AFSDU\ts\tSuleyman Demirel University, Agricultural Faculty\t\t\t",
"AFTC\ts\tAlaska Frozen Tissue Collection\t\t\t",
"AGRITEC\tb\tAGRITEC, Ltd.\t\t\t",
"AGRL\ts\tLethbridge Research Station\t\t\t",
"AGU\ts\tAstrakhan State University\t\t\t",
"AGUAT\ts\tUniversidad de San Carlos\t\t\t",
"AGUCH\ts\tFacultad de Ciencias Agronomicas de la Universidad de Chile\t\t\t",
"AH\ts\tUniversidad de Alcala, Departamento de Biologia Vegetal\t\t\t",
"AHBC\ts\tDixie College\t\t\t",
"AHF\ts\tAllan Hancock Foundation, University of Southern California\t\t\t",
"AHFH\ts\tUniversity of Southern California\t\t\t",
"AHLDA\tc\tAnimal Health Division Culture Collection\t\t\t",
"AHMA\ts\tAgharkar Research Institute, Maharashtra Association for the Cultivation of Science, Botany Group\t\t\t",
"AHN\tc\tAnaerobe Reference Laboratory, Helsinki Collection\t\t\t",
"AHNU\ts\tAnhui Normal University Conservation Genetics Lab\t\t\t",
"AHP\ts\tAmerican Herbal Pharmacopoeia\t\t\t",
"AHS\ts\tAustin High School\t\t\t",
"AHU\tc\tAHU Culture Collection\t\t\t",
"AHUC\ts\tUniversity of California, Agronomy and Range Science Department\t\t\t",
"AIB\ts\tAnhui Institute of Biology\t\t\t",
"AIBU\ts\tAbant Izzet Baysal Ueniversitesi, Biyoloji Boeluemue\t\t\t",
"AICH\ts\tAichi Kyoiku University, Biology Department\t\t\t",
"AIM\ts\tAuckland Institute and Museum\tAMNZ\t\t",
"AIMS\ts\tAustralian Institute of Marine Science\t\t\t",
"AIS\ts\tAcademie imperial des Sciences\t\t\t",
"AISIY\ts\tArmenian Institute for the Scientific Investigation of Cattle Breeding and Veterinary, Department of Meadows and Pastures\t\t\t",
"AIX\ts\tMuseum d'Histoire Naturelle d'Aix-en-Provence\tMHNAIX\t\t",
"AJ\tc\tCentral Research Laboratories\t\t\t",
"AJBC\ts\tAtkins Jardin Botanico de Cienfuegos\t\t\t",
"AJOU\ts\tAjou University, Biological Sciences Department\t\t\t",
"AJU\ts\tUniversidade Tiradentes\t\t\t",
"AK\ts\tAuckland War Memorial Museum\t\t\t",
"AKPM\ts\tAkita Prefectural Museum\t\t\t",
"AKSU\ts\tAksaray University\t\t\t",
"AKU<JPN>\tc\tFaculty of Agriculture\t\t\t",
"AKU<NZ>\ts\tUniversity of Auckland, School of Biological Sciences\t\t\t",
"AL\ts\tUniversite d'Alger\t\t\t",
"ALA<USA-AK>\ts\tHerbarium, University of Alaska Museum of the North\t\t\t",
"ALA<USA-AL>\ts\tUniversity of Alabama Museum of Natural History\t\t\t",
"ALAJ\ts\tHerbarium, University of Alaska SE\t\t\t",
"ALAM\ts\tAdams State College, Biology Department\t\t\t",
"ALB\ts\tCivico Museo Archeologico e di Scienze Naturali Federico Eusebio\t\t\t",
"ALBA\ts\tUniversidad de Castilla, La Mancha, Departamento de Ciencia y Tecnologia Agroforestal\t\t\t",
"ALBC\ts\tAlbion College, Biology Department\t\t\t",
"ALBORZ\ts\tScience and Research Branch, Islamic Azad University, Tehran, Iran\t\t\t",
"ALBU\ts\tRocky Mountain Forest and Range Experiment Station\t\t\t",
"ALCB\ts\tUniversidade Federal da Bahia, Campus Universitario de Ondina\t\t\t",
"ALCP\tc\tAlgotheque du Laboratoire de Cryptogamie\tMNHN:ALCP\t\t",
"ALD\ts\tAlderney Society and Museum\t\t\t",
"ALEX\ts\tUniversity of Alexandria, Department of Botany\t\t\t",
"ALF\ts\tCampus International de Baillarguet, Departement d'Elevage et de Medecine Veterinaire\t\t\t",
"ALGOBANK\tc\tALGOBANK\tAC<FRA>\t\t",
"ALGU\ts\tUniversidade do Algarve\t\t\t",
"ALIRU\tc\tAustralian Legume Inoculants Research Unit\t\t\t",
"ALK\ts\tAlnwick Scientific and Mechanical Institution\t\t\t",
"ALM<GBR>\ts\tArt Gallery and Museum, Central Library\t\t\t",
"ALMA\ts\tAlma College, Biology Department\t\t\t",
"ALME\ts\tEstacion Experimental de Zonas Aridas\t\t\t",
"ALN\ts\tAlnwick Botanical Society\t\t\t",
"ALNHS\ts\tNatural Heritage Section-ALDCNR\t\t\t",
"ALT\ts\tCurtis Museum\t\t\t",
"ALTA\ts\tUniversity of Alberta, Biological Sciences Department\t\t\t",
"ALTB\ts\tUniversity of Barnaul, Altai State University\t\t\t",
"ALU\ts\tAlabama Museum of Natural History\t\t\t",
"ALUH\ts\tAlzahra University\t\t\t",
"AM\tsb\tAustralian Museum\tAMS\t\t",
"AM:Arachnology\ts\tAustralian Museum, Invertebrate Collections: Arachnology\t\t",
"AM:EBU\tsb\tAustralian Museum, Evolutionary Biology Unit Tissue Collection\t\t",
"AM:Entomology\ts\tAustralian Museum, Invertebrate Collections: Entomology\t\t",
"AM:Herpetology\ts\tAustralian Museum, Vertebrate Collections: Herpetology\t\t",
"AM:Ichthyology\ts\tAustralian Museum, Vertebrate Collections: Ichthyology\t\t",
"AM:Malacology\ts\tAustralian Museum, Invertebrate Collections: Malacology\t\t",
"AM:Mammalogy\ts\tAustralian Museum, Vertebrate Collections: Mammalogy\t\t",
"AM:Marine_Invertebrates\ts\tAustralian Museum, Invertebrate Collections: Marine and other invertebrates\t\t",
"AM:Mineralogy\ts\tAustralian Museum, Earth Sciences: Mineralogy and Petrology Collection\t\t",
"AM:Ornithology\ts\tAustralian Museum, Vertebrate Collections: Ornithology\t\t",
"AM:Palaeontology\ts\tAustralian Museum, Palaeontology Collection\t\t",
"AM<ARG>\ts\tAcatushun Museum at the Estancia Haberton\t\t\t",
"AM<BLG>\ts\tAsenovgrad Paleontology Museum\t\t\t",
"AMAL\ts\tAnniston Museum of Natural History\t\t\t",
"AMAZ\ts\tUniversidad Nacional de la Amazonia Peruana\t\t\t",
"AMB\ts\tAssociazione Micologica Bresadola\t\t\t",
"AMC\tc\tDepartment of Biologics Research\t\t\t",
"AMCC\ts\tAmbrose Monell Cryo Collection, American Museum of Natural History\t\t\t",
"AMCL\ts\tMacapa, Museu Territorial de Historia Natural \"Angelo Moreira da Costa Lima\"\t\t\t",
"AMD\ts\tHugo de Vries-Laboratory, University of Amsterdam\t\t http://data.biodiversitydata.nl/naturalis/specimen/AMD.\t",
"AMDE\ts\tBrathay Field Centre for Exploration and Field Studies\t\t\t",
"AMES\ts\tHarvard University\t\t\t",
"AMF\ts\tMarine Science Museum, Fukushima (Aquamarine Fukushima)\t\t\t",
"AMG\ts\tAlbany Museum\tAMGS\t\t",
"AMGS\ts\tAlbany Museum\t\t\t",
"AMH\ts\tAgharkar Research Institute, Mycology and Plant Pathology Department\t\t\t",
"AMMRL\tc\tAustralian National Reference Laboratory in Medical Mycology\t\t\t",
"AMMS\ts\tAcademy of Military Medical Sciences\t\t\t",
"AMNH\tsb\tAmerican Museum of Natural History\t\t\t",
"AMNH:Fish\ts\tAmerican Museum of Natural History, Ichthyology Collection\t\t",
"AMNH:FM\ts\tAmerican Museum of Natural History, Fossil Mammal Collection\thttp://www.amnh.org/our-research/paleontology/collections/fossil-mammals/",
"AMNH:Herp\ts\tAmerican Museum of Natural History, Herpetology collection\t\t",
"AMNH:M\ts\tAmerican Museum of Natural History, Mammal collection\t\t",
"AMNH:ORN\ts\tAmerican Museum of Natural History, Ornithology Collection\t\t",
"AMNH:R\ts\tAmerican Museum of Natural History, Reptile Collection\t\t",
"AMNH<ISL>\ts\tIcelandic Institute of Natural History, Akureyri Division\t\t\t",
"AMNZ\ts\tAuckland Institute and Museum\tAIM\t\t",
"AMO\ts\tHerbario AMO\t\t\t",
"AMP<AUS>\tc\tAustralian Mycological Panel\t\t\t",
"AMP<GBR>\ts\tAmpleforth College\t\t\t",
"AMS\ts\tAustralian Museum\tAM\t\t",
"AMS:R\ts\tAustralian Museum, Reptile collection\t\t",
"AMUZ\ts\tAligarh Muslim University\t\t\t",
"AMWH\ts\tAmway Herbarium\t\t\t",
"ANA\ts\tOrange County Department of Agriculture\t\t\t",
"ANACC<AUS>\tc\tAustralian National Algae Culture Collection\tCS\t\t",
"ANC\ts\tUniversita di Ancona, Dipartimento di Biotecnologie Agrarie ed Ambientali\t\t\t",
"ANCB\ts\tMuseo Nacional de Historia Natural, La Paz\t\t\t",
"AND\ts\tSlezske zemske muzeum Opava, Arboretum Nopvy Dvur, Dendrology Department\t\t\t",
"ANDA\ts\tAndalas University\t\t\t",
"ANDES\ts\tUniversidad de Los Andes\t\t\t",
"ANDES:A\ts\tUniversidad de Los Andes, Amphibian Collection\t\t",
"ANDES:O\ts\tUniversidad de Los Andes, Ornithology Collection\t\t",
"ANDES:T\tsb\tUniversidad de Los Andes, Tissue Collection\t\t",
"ANES\ts\tAnadolu University, Biology Department\t\t\t",
"ANFC\ts\tAustralian National Fish Collection\t\t\t",
"ANFM\ts\tAssociazione Naturalisti Forlivesi Pro Museo\t\t\t",
"ANG\ts\tArboretum de la Maulevrie\t\t\t",
"ANGU\ts\tInstituto Nacional de Tecnologia Agropecuaria\t\t\t",
"ANGUC\ts\tUniversite Catholiques de l'Ouest\t\t\t",
"ANH\ts\tAndong National University, School of Bioresource Science\t\t\t",
"ANHC\ts\tArkansas Natural Heritage Commission Herbarium\t\t\t",
"ANIC\ts\tAustralian National Insect Collection\t\t\t",
"ANK\ts\tAnkara Ueniversitesi, Biyoloji Boeluemue\t\t\t",
"ANKO\ts\tForest Research Institute, Turkey\t\t\t",
"ANLW\ts\tAmt Der Niederosterreichischen Landsregierung\t\t\t",
"ANMR\tc\tAsian Network on Microbial Researches\t\t\t",
"ANSM\ts\tUniversidad Autonoma Agraria Antonio Narro, Departamento de Botanica\t\t\t",
"ANSP\ts\tAcademy of Natural Sciences of Drexel University\tANSP\t\t",
"ANSP:FISH\ts\tAcademy of Natural Sciences of Drexel University, Ichthyology Collection\t\t",
"ANSP:HRP\ts\tAcademy of Natural Sciences of Drexel University, Herpetology collection\t\t",
"ANSP:Malacology\ts\tAcademy of Natural Sciences of Drexel University, Malacology Collection\t\t",
"ANSP:MAM\ts\tAcademy of Natural Sciences of Drexel University, Mammal collection\t\t",
"ANSP:ORN\ts\tAcademy of Natural Sciences of Drexel University, Ornithology collection\t\t",
"ANTU\ts\tChangbai Mountain National Nature Reserve Administration Bureau\t\t\t",
"ANU<AUS>\ts\tAustralian National University\tANU<AUS>,ANU<AUST>\t\t",
"ANU<CHN>\ts\tAnhui University, Biology Department\t\t\t",
"ANUB\ts\tAnhui Normal University, Biology Department\t\t\t",
"ANUC\ts\tAustralian National University, Chemistry Department\t\t\t",
"ANUG\ts\tAnhui Normal University, Geography Department\t\t\t",
"ANUH\ts\tAcharya Nagarjuna University\t\t\t",
"ANVL\ts\tAssociation des Naturalistes de la Vallee du Loing et du Massif de Fontainebleau\t\t\t",
"ANWC\ts\tAustralian National Wildlife Collection\t\t\t",
"AO\ts\tMuseo Regionale di Scienze Naturali della Valle d'Aosta\t\t\t",
"AORI\ts\tAtmosphere and Ocean Research Institute\t\t\t",
"APCC\tc\tAntarctic Protistan Culture Collection (Woods Hole Oceanographic Institution)\t\t\t",
"APCR\ts\tArkansas Tech University, Biological Sciences Department\t\t\t",
"APEI\ts\tAgriculture Canada Research Station\t\t\t",
"APH\ts\tSociety of Apothecaries\t\t\t",
"APHA\tsc\tAnimal and Plant Health Agency\tVLA\t\t",
"APHI\ts\tU.S. Department of Agriculture, Animal and Plant Health Inspection Service\t\t\t",
"APIY\ts\tAbovian Pedagogical Institute, Botany Department\t\t\t",
"APM\ts\tAlgonquin Provincial Park, Algonquin Visitor Centre\t\t\t",
"APMJ\ts\tAomori Prefectural Museum\t\t\t",
"APP\ts\tParco Nazionale del Gran Sasso e Monti della Laga - Universita di Camerino, Centro Richerche Floristiche dell'Appennino\t\t\t",
"APSC\ts\tAustin Peay State University, Biology Department\t\t\t",
"AQC\ts\tAquinas College, Biology Department\t\t\t",
"AQP\ts\tEstudios Fitogeograficos del Peru\t\t\t",
"AQUAMEB\tc\tCulture Collection of Microalgae and Cyanobacteria, Bursa Technical University\t\t\t",
"AQUI\ts\tUniversita degli Studi di L'Aquila, Dipartimento di Scienze Ambientali\t\t\t",
"AR\ts\tPomor State University\t\t\t",
"ARAGO\ts\tUniversite Pierre et Marie Curie\t\t\t",
"ARAN\ts\tAlto de Zorroaga s.n., Departamento de Botanica\t\t\t",
"ARB\ts\tSalahiddin University, Biology Department\t\t\t",
"ARBH\ts\tArbroath Scientific and Natural History Society\t\t\t",
"ARC<ARG>\ts\tUniversidad Nacional del Comahue, Facultad de Ciencias Agrarias\t\t\t",
"ARC<CAN>\ts\tAtlantic Reference Centre\tARCM\t\t",
"ARC<USA-NC>\tc\tAlgal Resources Collection\t\t\t",
"ARCH\ts\tArchbold Biological Station\t\t\t",
"ARCM\ts\tAtlantic Reference Centre\tARC\t\t",
"ARER\ts\tAssociazione Romana di Entomologia\t\t\t",
"ARG\ts\tArgotti Botanic Garden\t\t\t",
"ARIZ\ts\tUniversity of Arizona, Department of Plant Sciences\t\t\t",
"ARK\ts\tUniversity of Arkansas\t\t\t",
"ARKH\ts\tChingan State Nature Reserve\t\t\t",
"ARM\ts\tCounty Museum\t\t\t",
"ARMFN\ts\tArmagh Field Naturalists' Society\t\t\t",
"ARRI\ts\tAyurveda Regional Research Institute\t\t\t",
"ARRIAM\tc\tAll-Russia Research Institute for Agricultural Microbiology\t\t\t",
"ARSEF\tc\tARS Collection of Entomopathogenic Fungi\t\t\t",
"ARTH\ts\tArtvin Coruh University\t\t\t",
"ARUN\ts\tBotanical Survey of India, Arunachal Pradesh Regional Centre\t\t\t",
"ARWESP\ts\tArboretum Wespelaar\t\t\t",
"AS<DEU>\ts\tPaleontological Collection\t\t\t",
"AS<PRY>\ts\tJardin Botanico\t\t\t",
"ASAY\ts\tAcademy of Science of Armenia\t\t\t",
"ASC\ts\tNorthern Arizona University, Biological Sciences Department\t\t\t",
"ASCC\ts\tAdams State College Collection\t\t\t",
"ASCU\ts\tAgricultural Scientific Collections Unit\t\t\t",
"ASDM\ts\tArizona-Sonora Museum\t\t\t",
"ASE\ts\tUniversidade Federal de Sergipe, Departamento de Biologia\t\t\t",
"ASH\ts\tNational Institute of Deserts Flora and Fauna\t\t\t",
"ASIB\tc\tAlgensammlung am Institut fur Botanik\t\t\t",
"ASINC\tb\tAgricultural Science Institute of North-Central Vietnam\t\t\t",
"ASIO\ts\tAcademia Sinica Institute of Oceanology\t\t\t",
"ASIZB\ts\tAcademia Sinica Institute of Zoology, Beijing\t\t\t",
"ASIZP\ts\tAcademia Sinica Institute of Zoology, Ichthyology Collection\tASIZP<TWN>\t\t",
"ASIZT\ts\tAcademia Sinica Institute of Zoology, Taipei\t\t\t",
"ASM\ts\tArts and Science University\t\t\t",
"ASNHC\ts\tAngelo State Natural History Collection\t\t\t",
"ASNHC:Birds\ts\tAngelo State Natural History Collection, Ornithology Collection\t\t",
"ASNHC:Mammals\ts\tAngelo State Natural History Collection, Mammalogy Collection\t\t",
"ASNHC:Reptiles\ts\tAngelo State Natural History Collection, Herpetology Collection\t\t",
"ASSAM\ts\tBotanical Survey of India, Eastern Circle\t\t\t",
"ASSL\ts\tAcademy of Sciences\t\t\t",
"AST\ts\tUniversity of Aston\t\t\t",
"ASTC\ts\tStephen F. Austin State University, Biology Department\t\t\t",
"ASTN\ts\tAshton-under-Lyne Linnean Botanical Society\t\t\t",
"ASTU\ts\tAssiut University\t\t\t",
"ASU\ts\tSchool of Life Sciences, Arizona State University\t\t\t",
"ASUA\ts\tAin Shams University\t\t\t",
"ASUF\ts\tRocky Mountain Research Station, USDA Forest Service\t\t\t",
"ASUMC\ts\tArizona State University, Mammal Collection\t\t\t",
"ASUMZ\ts\tArkansas State University, Collection of Recent Mammals\t\t\t",
"ASUT\ts\tFrank M. Hasbrouck Insect Collection\t\t\t",
"ASW\ts\tSouth Valley University, Botany Department\t\t\t",
"ASW<AUT>\tc\tCulture Collection of Algae at the University of Vienna\t\t\t",
"ATA\ts\tAtatuerk Ueniversitesi\t\t\t",
"ATCC\tcb\tAmerican Type Culture Collection\t\thttps://www.atcc.org/Products/All/&spec;.aspx\t",
"ATCH\ts\tChinese Academy of Tropical Agricultural Sciences\t\t\t",
"ATH\ts\tGoulandris Natural History Museum\t\t\t",
"ATHU\ts\tNational and Kapodistrian University of Athens, Biology Department\t\t\t",
"ATHUM\tsc\tATHUM Culture Collection of Fungi\t\t\t",
"ATSC<AUS>\tb\tAustralian Tree Seed Centre\t\t\t",
"ATU\tc\tDepartment of of Biotechnology University of Tokyo\t\t\t",
"AU\ts\tXiamen University, Biology Department\t\t\t",
"AUA\ts\tAuburn University, Biological Sciences Department\t\t\t",
"AUB\ts\tAndrews University\t\t\t",
"AUBH\ts\tAthabasca University\t\t\t",
"AUBL\ts\tMuseum of Natural History, Beirut\t\t\t",
"AUBSN\ts\tAll-Union Botanical Society\t\t\t",
"AUCE\ts\tEl Azhar University\t\t\t",
"AUEM\ts\tAuburn University Entomological Museum\t\t\t",
"AUEZ\ts\tAichi University of Education, Zoological collection\t\t\t",
"AUG\ts\tAugustana College, Biology Department\t\t\t",
"AUGD\ts\tDepartment of Geology and Petroleum Geology\t\t\t",
"AUGIE\ts\tAugustana College\t\t\t",
"AUH\ts\tAgriculture University Herbarium\t\t\t",
"AUM\ts\tAuburn University Museum\t\t\t",
"AUM:Fish\ts\tAuburn University Museum, Fish collection\t\t",
"AUMC<EGY>\tc\tAssiut University Mycological Centre Culture Collection\t\t\t",
"AUMH\ts\tAgricultural University of Georgia\t\t\t",
"AUR\ts\tMuseum des Volcans\t\t\t",
"AURO\ts\tAuroville Foundation\t\t\t",
"AUSPGRIS\tb\tAustralian Plant Genetic Resource Information Service\t\t\t",
"AUT\ts\tMuseum d'Histoire Naturelle\t\t\t",
"AUV\ts\tAndhra University\t\t\t",
"AUW\ts\tAcadia University, Wildlife Museum\t\t\t",
"AV\ts\tMuseum Requien\t\t\t",
"AVCH\ts\tCity of Alexandria\t\t\t",
"AVE\ts\tUniversidade de Aveiro, Departamento de Biologia\t\t\t",
"AVU\ts\tVrije Universiteit, Department of Systematic Botany\t\t\t",
"AWC\ts\tArizona Western College\t\t\t",
"AWH\ts\tDr. Henri Van Heurck Museum\t\t\t",
"AWL\ts\tAbitibi Paper Company\t\t\t",
"AWQC\tc\tAustralian Water Quality Centre\t\t\t",
"AWRI\tc\tThe Australian Wine Research Institute\t\t\t",
"AYBY\ts\tBuckinghamshire County Museum Technical Centre\t\t\t",
"AYDN\ts\tAdnan Menderes University, Department of Biology\t\t\t",
"AYR\ts\tSouth Ayrshire Council\t\t\t",
"AZ\ts\tMuseu Carlos Machado, Natural History Department\t\t\t",
"AZAN\ts\tAkademia Nauk Azerbaijana-Bulgarian Academy of Science of Azerbaijan\t\t\t",
"AZB\ts\tHerbario Ruy Telles Palhinha - Universidade Dos Acores\t\t\t",
"AZTI\tsc\tAZTI Tecnalia\t\t\t",
"AZU\ts\tUniversidade dos Acores, Departamento de Ciencias Agrarias\t\t\t",
"AZUS\ts\tCitrus College, Biological Sciences Department\t\t\t",
"B\ts\tBerlin Botanic Garden and Botanical Museum (Herbarium Berolinense)\tBGBM\thttp://herbarium.bgbm.org/object/B\t",
"BA\ts\tMuseo Argentino de Ciencias Naturales Bernardino Rivadavia\t\t\t",
"BAA\ts\tUniversidad de Buenos Aires, Facultad de Agronomia\t\t\t",
"BAAC\ts\tMusee de Beni Abbes\t\t\t",
"BAB\ts\tInstituto Nacional de Tecnologia Agropecuaria, Instituto de Recursos Biologicos\t\t\t",
"BABY\ts\tB. A. Bennett Herbarium, Yukon Government\t\t\t",
"BAC<CHN>\ts\tBeijing Agricultural College\t\t\t",
"BAC<UK>\ts\tBacup Natural History Society\t\t\t",
"BACA\tc\tBank of Algae and Cyanobacteria of the Azores\t\t\t",
"BACC\tc\tBrucella AFSSA Culture Collection\t\t\t",
"BACH\ts\tBotswana College of Agriculture\t\t\t",
"BACP\ts\tCEFYBO, Unidad Botanica\t\t\t",
"BAE\ts\tWillis Museum and Art Gallery\t\t\t",
"BAF\ts\tUniversidad de Buenos Aires, Facultad de Farmacia y Bioquimica\t\t\t",
"BAFC\tsc\tUniversidad de Buenos Aires, Departamento de Ciencias Biologicas\t\t\t",
"BAG\ts\tMinistry of Agriculture\t\t\t",
"BAH<BRZ>\ts\tEmpresa Baiana de Desenvolvimento Agricola\t\t\t",
"BAH<GRM>\ts\tBiologische Anstalt Helgoland Marine Station\t\t\t",
"BAI\ts\tInstituto Forestal Nacional (IFONA), Centro Forestal Castelar\t\t\t",
"BAIL\ts\tConservatoire Botanique National de Bailleul\t\t\t",
"BAJ\ts\tInstituto Municipal de Botanica, Parque Pte. Dr. Nicolas Avellaneda\t\t\t",
"BAK\ts\tAzerbaijan National Academy of Sciences (ANAS)\t\t\t",
"BAL\ts\tINTA, EEA Balcarce, Catedra de Botanica Agricola\t\t\t",
"BALT\ts\tTowson University, Department of Biological Sciences\t\t\t",
"BAMU\ts\tDr. Babasaheb Ambedkar Marathwada University\t\t\t",
"BAN\ts\tBanaras Hindu University, Botany Department\t\t\t",
"BANG\ts\tUniversite de Bangui\t\t\t",
"BAP\ts\tOxford Botanic Garden\t\t\t",
"BAR\ts\tUniversity of the West Indies, Department of Biological and Chemical Sciences\t\t\t",
"BARC\ts\tBeltsville Agricultural Research Center\t\t\t",
"BARO\ts\tMaharaja Sayajirao University of Baroda, Botany Department\t\t\t",
"BART\ts\tBartlett Arboretum\t\t\t",
"BAS<BGR>\ts\tBulgarian Academy of Science\t\t\t",
"BAS<CHE>\ts\tHerbarium, Botanisches Institut, Universitat Basel\t\t\t",
"BASBG\ts\tUniversitaet Basel, Basler Botanische Gesellschaft\t\t\t",
"BASSA\ts\tMuseo Civico, Bassano del Grappa\t\t\t",
"BASU\ts\tBu-Ali Sina University\t\t\t",
"BAT\ts\tBagshaw Museum\t\t\t",
"BATA\ts\tInstituto Nacional de Desarollo Forestal\t\t\t",
"BATH\ts\tBath Natural History Society\t\t\t",
"BATHG\ts\tGeology Museum\t\t\t",
"BATU\ts\tBatumi Botanical Garden, Botany Department\t\t\t",
"BAU\ts\tBeijing Agricultural University\t\t\t",
"BAV\ts\tSlovenskej akademie vied\t\t\t",
"BAY\ts\tMuseum d'Histoire Naturelle de Bayonne\t\t\t",
"BAYLU\ts\tBaylor University, Biology Department\t\t\t",
"BB<ARG>\ts\tUniversidad Nacional del Sur, Departamento de Agronomia\t\t\t",
"BB<USA-WY>\ts\tBuffalo Bill Museum\t\t\t",
"BBB\ts\tUniversidad Nacional del Sur, Departamento de Biologia, Bioquimica y Farmacia\t\t\t",
"BBF\ts\tConservatoire Botanique National de Midi-Pyrenees, Conservatoire botanique pyreneen\t\t\t",
"BBG\ts\tBirmingham Botanical Gardens\t\t\t",
"BBH\ts\tNational Science and Technology Development Agency\t\t\t",
"BBLF\tc\tInstitut fur Pflanzenschutz im Forst\t\t\t",
"BBLM\ts\tBoise District Bureau of Land Management\t\t\t",
"BBNP\ts\tBig Bend National Park\t\t\t",
"BBPP\tc\tBacteriology Branch, Plant Pathology and Microbiology Division, Department of Agricultural Science\t\t\t",
"BBS\ts\tUniversity of Suriname\t\t\t",
"BBSUK\ts\tNational Museum and Gallery, Department of Biodiversity and Systematic Biology\t\t\t",
"BC\ts\tInstitut Botanic de Barcelona\t\t\t",
"BCB\ts\tUniversitat Autonoma de Barcelona, Unitat de Botanica\t\t\t",
"BCC<ESP>\ts\tUniversitat de Barcelona, Departament de Biologia Vegetal (Unitat de Botanica)\t\t\t",
"BCC<THA>\tc\tBIOTEC Culture Collection\t\t\t",
"BCCDC\tc\tBC Centre for Disease Control\t\t\t",
"BCCM/DCG\tc\tBelgian Coordinated Collections of Microorganisms / DCG Diatoms Collection\tDCG\t\t",
"BCCM/GENECORNER\tc\tBelgian Coordinated Collections of Microorganisms / GeneCorner Plasmid Collection\tBCCM/LMBP,GeneCorner,LMBP\t\t",
"BCCM/IHEM\tc\tBelgian Coordinated Collections of Microorganisms / IHEM Fungi collection: Human & Animal Health\tIHEM\t\t",
"BCCM/ITM\tc\tBelgian Coordinated Collections of Microorganisms / ITM Mycobacteria Collection\tITM\t\t",
"BCCM/LMG\tc\tBelgian Coordinated Collections of Microorganisms/ LMG Bacteria Collection\tLMG\thttp://bccm.belspo.be/catalogues/lmg-strain-details?NUM=\t",
"BCCM/MUCL\tc\tBelgian Coordinated Collections of Microorganisms / MUCL Agro-food & Environmental Fungal Collection\tMUCL\t\t",
"BCCM/ULC\tc\tBelgian Coordinated Collections of Microorganisms / ULC Cyanobacteria Collection\tULC\thttp://bccm.belspo.be/catalogues/ulc-strain-details?ACCESSION_NUMBER=\t",
"BCCN\tc\tBrucella Culture Collection\t\t\t",
"BCCUSP\tc\tBrazilian Cyanobacteria Collection - University of Sao Paulo\t\t\t",
"BCF\ts\tUniversitat de Barcelona, Laboratori de Botanica\t\t\t",
"BCFH\ts\tBureau of Commercial Fisheries\t\t\t",
"BCH\ts\tBerry College\t\t\t",
"BCK\ts\tAlexandria State Dendrological Park\t\t\t",
"BCKN\ts\tBlackburn Museum and Art Gallery\t\t\t",
"BCL\ts\tBates College, Biology Department\t\t\t",
"BCM<SPN>\ts\tCampus Universitario de Tafira, Departamento de Biologia\t\t\t",
"BCM<USA-NY>\ts\tBrooklyn Children's Museum\t\t\t",
"BCMEX\ts\tUniversidad Autonoma de Baja California, Reg. MX-HR-007-BC\t\t\t",
"BCMM\ts\tBeijing College of Traditional Chinese Medicine\t\t\t",
"BCN\ts\tUniversitat de Barcelona\t\t\t",
"BCNP\ts\tBryce Canyon National Park\t\t\t",
"BCPM\ts\tBritish Columbia Provincial Museum\t\t\t",
"BCRC\tc\tBioresource Collection and Research Center\tCCRC\thttps://catalog.bcrc.firdi.org.tw/BcrcContent?bid=\t",
"BCRJ\tc\tRio de Janeiro Cell Bank (Banco de Celulas do Rio de Janeiro)\t\t\t",
"BCRU\ts\tUniversidad Nacional del Comahue, Departamento de Botanica\t\t\t",
"BCTC\ts\tBirmingham Central Technical College\t\t\t",
"BCU\ts\tChulalongkorn University, Botany Department\t\t\t",
"BCUE\ts\tDepartment of Biology, Ch'ongju University of Education\t\t\t",
"BCUZ\ts\tBasque Country University, Laboratory of Zoology\t\t\t",
"BCW\ts\tBedford College, University of London\t\t\t",
"BCWL\ts\tBiological Control of Weeds Laboratory-Europe\t\t\t",
"BCWS\ts\tBurgundy Center for Wildlife Studies\t\t\t",
"BDD\ts\tUniversity of Bradford, Biology Department\t\t\t",
"BDI\ts\tPutnam Museum of History and Natural Science, Natural History Department\t\t\t",
"BDIARI\tsc\tBahri Dagdas International Agricultural Research Institute\t\t\t",
"BDK\ts\tNorth Hertfordshire Museums Service, Natural History Department\t\t\t",
"BDLU\ts\tLaurentian University\t\t\t",
"BDMU\ts\tMcMaster University\t\t\t",
"BDNF\ts\tBeaverhead-Deerlodge National Forest\t\t\t",
"BDPA\ts\tArboretum, Bolestraszyce - Zamek, Department of Physiography\t\t\t",
"BDUC\ts\tUniversity of Calgary\t\t\t",
"BDUN\tc\tDepartment of Botany, University of Nottingham\t\t\t",
"BDUW\ts\tUniversity of Waterloo\t\t\t",
"BDUZ\tc\tBiological Sciences\t\t\t",
"BDWC\ts\tUniversity of Windsor\t\t\t",
"BDWL\ts\tWilfred Laurier University\t\t\t",
"BDWR\ts\tBridgewater College, Biology Department\t\t\t",
"BEAN\ts\tBridge of Allan Museum\t\t\t",
"BED\ts\tBedford Public Library\t\t\t",
"BEDF\ts\tNew England Wild Flower Society\t\t\t",
"BEG\tc\tInternational Bank for the Glomeromycota\tIBG\t\t",
"BEGO\ts\tBeth Gordon Institute\t\t\t",
"BEI\ts\tAmerican University of Beirut, Biology Department\t\t\t",
"BEI<USA>\tc\tBiodefense and Emerging Infections Research Resources\t\t\t",
"BEL\ts\tUlster Museum, Botany Department\t\t\t",
"BELC\ts\tBeloit College, Biology Department\t\t\t",
"BELUM\ts\tUlster Museum, Belfast\t\t\t",
"BELZ\ts\tZapovednik Belogorje State Nature Reserve\t\t\t",
"BENH\ts\tBritish Entomological and Natural History Society\t\t\t",
"BENIN\ts\tUniversite National du Benin\t\t\t",
"BENN\ts\tBennington College\t\t\t",
"BEO\ts\tNatural History Museum, Botany Department\t\t\t",
"BEOU\ts\tUniversity of Belgrade, Faculty of Biology\t\t\t",
"BER\ts\tOrto Botanico de Bergamo \"Lorenzo Rota\"\t\t\t",
"BEREA\ts\tBerea College, Biology Department\t\t\t",
"BERN\ts\tUniversity of Bern\t\t\t",
"BESA\ts\tMuseum d'Histoire naturelle de Besancon\t\t\t",
"BESM\ts\tBvumbwe Experiment Station\t\t\t",
"BEV\ts\tBorough of Beverley Art Gallery and Museum\t\t\t",
"BEX\ts\tBexhill Museum\t\t\t",
"BFBI\ts\tBiologisches Forschunsstation Burgenland\t\t\t",
"BFD\ts\tBedfordshire Natural History Society\t\t\t",
"BFDL\ts\tForest Products Laboratory\t\t\t",
"BFIC\ts\tMuseum National d'Histoire Naturelle\t\t\t",
"BFRIRS\ts\tBangladesh Fisheries Research Institute\t\t\t",
"BFRS\ts\tBlodgett Forest Research Station\t\t\t",
"BFT\ts\tQueen's University, Botany Department\t\t\t",
"BFUS\ts\tUniversity of Sofia, Biology Faculty\t\t\t",
"BFY\ts\tJohn Innes Horticultural Institution\t\t\t",
"BG\ts\tUniversity of Bergen, Botanical Museum\t\t\t",
"BGAAS\ts\tBotanical Garden of the Armenian Academy of Sciences, Flora and Vegetation Department\t\t\t",
"BGH\ts\tUniversity of Malakand\t\t\t",
"BGHan\ts\tBundesanstalf fuer Geowissenschaften und Rohstoffe\t\t\t",
"BGIV\tc\tBanco de Glomeromycota In Vitro (Bank of Glomeromycota In Vitro)\t\t\t",
"BGM\ts\tBath Geology Museum (now the Royal Literary and Scientific Institution)\t\t\t",
"BGR\ts\tBundesanstalt fur Geowissenschaften und Rohstoffe\t\t\t",
"BGS\ts\tBritish Geological Survey\t\t\t",
"BGSC\tc\tBacillus Genetic Stock Center\t\t\t",
"BGSU\ts\tBowling Green State University, Biological Sciences Department\t\t\t",
"BH\ts\tCornell University, Department of Plant Biology\t\t\t",
"BHAG\ts\tT. M. Bhagalpur University, Botany Department\t\t\t",
"BHAV\ts\tCentral Salt and Marine Chemicals Research Institute\t\t\t",
"BHCB\ts\tUniversidade Federal de Minas Gerais, Departamento de Botanica\t\t\t",
"BHD\ts\tWilliamson Art Gallery and Museum\t\t\t",
"BHDL\ts\tWirral Central Area Reference Library\t\t\t",
"BHDS\ts\tBirkenhead School\t\t\t",
"BHM<UK>\ts\tUniversity of Birmingham, Birmingham Natural Society\t\t\t",
"BHM<USA-SD>\ts\tBlack Hills Museum of Natural History\t\t\t",
"BHMG\ts\tInstituto Agronomico\t\t\t",
"BHMH\ts\tUniversidade Federal de Minas Gerais, Museu de Historia Natural\t\t\t",
"BHO\ts\tOhio University, Environmental and Plant Biology Department\t\t\t",
"BHPL\ts\tIndian Institute of Science Education and Research-Bhopal\t\t\t",
"BHSC\ts\tBlack Hills State University, Biology Department\t\t\t",
"BHU\ts\tHumboldt-Universitaet zu Berlin, Institut fuer Biologie\t\t\t",
"BHUPM\ts\tMuseum fur Naturkunde, Institut fur Palaontologie\t\t\t",
"BHUPP\ts\tBanaras Hindu University, Mycology and Plant Pathology Department\t\t\t",
"BHZB\ts\tFundacao Zoo-Botanica de Belo Horizonte\t\t\t",
"BI\ts\tIstituto Ortobotanico\t\t\t",
"BIA\ts\tBritish Institute of Archaeology\t\t\t",
"BIDA\ts\tBoise State University\t\t\t",
"BIE\ts\tInstituto di Entomologia\t\t\t",
"BIEL\ts\tUniversitaet Bielefeld, Abteilung Oekologie\t\t\t",
"BIGU\ts\tUniversidad de San Carlos de Guatemala, Departamento de Botanica\t\t\t",
"BIL\ts\tForest Research Institute, Natural Forest Department\t\t\t",
"BILAS\ts\tInstitute of Botany\t\t\t",
"BIM\ts\tBirmingham Natural History and Microscopical Society\t\t\t",
"BIM<BLR>\tc\tBelarus National Academy of Sciences, Institute of microbiology\t\t\t",
"BING\ts\tState University of New York, Biological Sciences Department\t\t\t",
"BIO\ts\tUniversidad del Pais Vasco/EHU, Departamento de Biologia Vegetal y Ecologia (Botanica)\t\t\t",
"BioCC\tc\tBioCC BioCen Culture Collection\t\t\t",
"BIOT\ts\tRegional Center for Tropical Biology\t\t\t",
"BIOUG<CAN>\ts\tBiodiversity Institute of Ontario, University of Guelph\tBIO,UOG:BIO\t\t",
"BIRA\ts\tBirmingham Museums and Art Gallery, Curatorial Services\t\t\t",
"BIRDI\tb\tBiotechnology Research & Development Institute Vietnam\t\t\t",
"BIRM\ts\tUniversity of Birmingham\t\t\t",
"BISH\ts\tBishop Museum, Department of Natural Sciences\t\t\t",
"BITU\ts\tDepartment of Biology, Faculty of Science, Toyama University\t\t\t",
"BIUB\ts\tMongolian Academy of Sciences\t\t\t",
"BJ\ts\tBi Jie University\t\t\t",
"BJA\ts\tUniversity of Burundi, Biology Department\t\t\t",
"BJFC\ts\tBeijing Forestry University\tBJFU\t\t",
"BJM\ts\tBeijing Natural History Museum\t\t\t",
"BJRI<BGD>\tb\tGene bank at Bangladesh Jute Research Institute\t\t\t",
"BJTC\ts\tCapital Normal University, Biology Department\t\t\t",
"BK\ts\tBangkok Herbarium\t\t\t",
"BKF\ts\tThe Forest Herbarium\t\t\t",
"BKL\ts\tBrooklyn Botanic Garden\t\t\t",
"BKNU\ts\tKunsan National University\t\t\t",
"BLA\ts\tFundacao Estadual de Pesquisa Agropecuaria\t\t\t",
"BLAT\ts\tSt. Xavier's College, Botany Department\t\t\t",
"BLCU\ts\tBee Biology and Systematics Laboratory\t\t\t",
"BLFU\ts\tUniversity of the Free State, Department of Botany and Genetics\t\t\t",
"BLGA\ts\tBurgenlandisches Landesmuseum\t\t\t",
"BLH\ts\tCranbrook Institute of Science\t\t\t",
"BLIH\ts\tBiological Laboratory Imperial Household of Japan\t\t\t",
"BLMAR\ts\tBureau of Land Management Arcata Field Office\t\t\t",
"BLMCAR\ts\tCarson City Field Office Bureau of Land Management\t\t\t",
"BLMLK\ts\tBureau of Land Management\t\t\t",
"BLMPR\ts\tBureau of Land Management, Prineville Field Office\t\t\t",
"BLMRD\ts\tRedding Bureau of Land Management Field Office\t\t\t",
"BLT\ts\tBelfast Natural History and Philosophical Society\t\t\t",
"BLUZ\ts\tMuseo de Biologia\t\t\t",
"BLWG\tc\tBayerische Landesanstalt fur Weinbau und Gartenbau\t\t\t",
"BLY\ts\tHarvey Institute, Barnsley Naturalist and Scientific Society\t\t\t",
"BM\ts\tThe Natural History Museum, Herbarium\t\t\t",
"BM<GBR-BRISTOL>\ts\tBristol Museum\t\t\t",
"BMARI\tb\tBandaranayake Memorial Ayurvedic Research Institute\t\t\t",
"BMB\ts\tBooth Museum of Natural History\tBMBN<UK>\t\t",
"BMBN<UK>\ts\tBooth Museum of Natural History\tBMB\t\t",
"BMCC\tc\tBrittany Microbe Culture collection\t\t\t",
"BMFM-UNAM\tc\tCulture Collection of Fungal Pathogens Strains from the Basic Mycology Laboratory of the Department of Microbiology and Parasitology, Faculty of Medicine, UNAM\t\t\t",
"BMGB\ts\tBarbados Museum and Historical Society\t\t\t",
"BMH\ts\tBournemouth Natural Science Society Museum, herbarium\t\t\t",
"BMHP\ts\tBermuda Department of Agriculture and Fisheries\t\t\t",
"BMKB\ts\tBrunei Museum\tBM<BRN>\t\t",
"BMM\ts\tBuergermeister Mueller, Museum\t\t\t",
"BMNH\ts\tNatural History Museum, London\tNHMUK\t\t",
"BMNH:BOT\ts\tNatural History Museum, London, Plants collection\t\t",
"BMNH:ENT\ts\tNatural History Museum, London, Entomology collection\t\t",
"BMNH:ZOO\ts\tNatural History Museum, London, Zoological Collection\t\t",
"BMNHC\ts\tBurpee Museum of Natural History\tBURP\t\t",
"BMPS\ts\tBristol Museum and Philosophical Society\t\t\t",
"BMR\ts\tBureau of Mineral Resources\t\t\t",
"BMRP\ts\tBurpee Museum Rockford Paleontology\t\t\t",
"BMSA\ts\tNational Museum Bloemfontein\t\t\t",
"BMSC\ts\tBuffalo Museum of Science\t\t\t",
"BMSC<CAN>\ts\tBamfield Marine Science Centre\t\t\t",
"BMUK\ts\tBolton Museum\t\t\t",
"BNA<ESP>\tc\tBanco Espanol de Algas (Spanish Bank of Algae)\tBNA\t\t",
"BNA<GBR>\ts\tBritish (Empire) Naturalists' Association\t\t\t",
"BNBE\ts\tYMCA Hostel\t\t\t",
"BNFF\ts\tBanff Museum\t\t\t",
"BNFH\ts\tU.S. Forest Service, Bitterroot National Forest\t\t\t",
"BNH\ts\tNassau Botanical Gardens, Department of Agriculture\t\t\t",
"BNHD\ts\tBengal Natural History Museum\t\t\t",
"BNHM<CHN>\ts\tBeijing Natural History Museum\t\t\t",
"BNHM<IND>\ts\tBombay Natural History Museum\t\t\t",
"BNHS\ts\tBombay Natural History Society\t\t\t",
"BNI\tc\tBernhard Nocht Institute for Tropical Medicine\t\t\t",
"BNL\ts\tBundesamt fur Naturschutz\t\t\t",
"BNM\tc\tBanco Nacional Microorganismos (National Bank of Microorganisms)\t\t\t",
"BNP\ts\tBanff Park Museum\t\t\t",
"BNPL\ts\tBrighton Public Library\t\t\t",
"BNRH\ts\tBuffelskloof Nature Reserve\t\t\t",
"BNU\ts\tBeijing Normal University, Biology Department\t\t\t",
"BO\ts\tHerbarium Bogoriense (Research Centre for Biology)\t\t\t",
"BOC\ts\tBingham Oceanographic Collection\tYPM\t\t",
"BOCH\ts\tRuhr-Universitaet Bochum, Spezielle Botanik\t\t\t",
"BOD\ts\tUniversity of Oxford\t\t\t",
"BOG\ts\tUniversidad de La Salle\t\t\t",
"BOGOS<DEU>\tb\tBotanical Garden of Osnabruck University\t\t\t",
"BOIS\ts\tRocky Mountain Research Station\t\t\t",
"BOL\ts\tBolus Herbarium, University of Cape Town\t\t\t",
"BOLO\ts\tUniversita di Bologna\t\t\t",
"BOLV\ts\tNacional Forestal Martin Cardenas\t\t\t",
"BON\ts\tBolton Museum, Art Gallery and Aquarium\t\t\t",
"BONB\ts\tBolton Botanical Society\t\t\t",
"BONL\ts\tBolton Linnean Society\t\t\t",
"BONN\ts\tBotanisches Institut und Botanischer Garten der Universitaet Bonn\t\t\t",
"BOON\ts\tAppalachian State University, Biology Department\t\t\t",
"BOR\ts\tGuermonprez Museum\t\t\t",
"BORD\ts\tJardin Botanique de la Ville de Bordeaux\t\t\t",
"BORH\ts\tUniversiti Malaysia Sabah\t\t\t",
"BORN\ts\tInstitute for Tropical Biology and Conservation, Borneensis\t\t\t",
"BOROK\tc\tThe Collection of algae\t\t\t",
"BOSC\ts\tBoston State College, Biology Department\t\t\t",
"BOTU\ts\tUniversidade Estadual Paulista, Departamento de Botanica\t\t\t",
"BOUM\ts\tMuseum d'Histoire Naturelle de Bourges\t\t\t",
"BOZ\ts\tNaturmuseum Suedtirol/Museo Scienze Naturali Alto Adige\t\t\t",
"BP\ts\tHungarian Natural History Museum, Botanical Department\t\t\t",
"BPBM\ts\tBernice P. Bishop Museum\tBISHOP\t\t",
"BPBM:Fish\ts\tBernice P. Bishop Museum, Fish Collection\t\t",
"BPBM:IZ\ts\tBernice P. Bishop Museum, Invertebrate Zoology\t\t",
"BPI\tsc\tU.S. National Fungus Collections, Systematic Botany and Mycology Laboratory\t\thttp://nt.ars-grin.gov/fungaldatabases/specimens/new_rptSpecimenOneRec.cfm?thisrec=BPI+&spec;\t",
"BPI<ZAF>\ts\tBernard Price Institute for Palaeontological Research\t\t\t",
"BPIC\tc\tBenaki Phytopathological Institute Collection\t\t\t",
"BPL\ts\tMuseum of Barnstaple & North Devon\t\t\t",
"BPM\ts\tBeipiao Paleontological Museum\t\t\t",
"BPPT-ESC\tc\tBPPT Ethanol-Single Cell Protein-Fructose Syrup Technical Unit\t\t\t",
"BPS\ts\tCalifornia Department of Food and Agriculture\t\t\t",
"BPU\ts\tEoetvoes Lorand University, Department of Plant Taxonomy and Ecology\t\t\t",
"BR<BEL>\ts\tBotanic Garden Meise\t\t\t",
"BR<BRA>\tc\tJohanna Dobereiner Biological Resouce Center (CRB-JD)\t\t\t",
"BRA\ts\tSlovak National Museum, Botany Department\t\t\t",
"BRAD\ts\tUniversity of Bradford, Biology Department\t\t\t",
"BRBA\ts\tUniversidade Federal do Oeste da Bahia\t\t\t",
"BRC\ts\tBotanical Record Club\t\t\t",
"BRCC\tc\tUSDA-ARS Rhizobium Germplasm Resource Collection\t\t\t",
"BRCH\ts\tBotanical Research Center\t\t\t",
"BRE\ts\tUniversite\t\t\t",
"BREE\ts\tBraintree and Bocking Natural History Club\t\t\t",
"BREG\ts\tVorarlberger Naturschau\t\t\t",
"BREM\ts\tUbersee-Museum Bremen\t\t\t",
"BRFL\ts\tCity of Birmingham Reference Library\t\t\t",
"BRFM<FRA>\tc\tBanque de Ressources Fongiques de Marseille\t\t\t",
"BRG\ts\tUniversity of Guyana, Biology Department\t\t\t",
"BRGE\ts\tLaboratoire de Genetique des Plantes Superieures\t\t\t",
"BRH\ts\tMinistry of Natural Resources, Local Government, and the Environment\t\t\t",
"BRI\ts\tBrisbane Botanic Gardens Mt Coot-tha\t\t\t",
"BRIP\tsc\tThe Plant Pathology Herbarium, Department of Agriculture, Fisheries and Forestry\t\t\t",
"BRIST\ts\tUniversity of Bristol, Botany Department\t\t\t",
"BRISTM\ts\tBristol Museum and Art Gallery\t\t\t",
"BRIT\ts\tBotanical Research Institute of Texas\t\t\t",
"BRIU\ts\tUniversity of Queensland, Botany Department\t\t\t",
"BRL\ts\tBristol City Library\t\t\t",
"BRLU\ts\tUniversite Libre de Bruxelles\t\t\t",
"BRM\ts\tAlfred-Wegener-Institut fuer Polar- und Meeresforschung\t\t\t",
"BRMI\ts\tBirmingham and Midland Institute\t\t\t",
"BRN\ts\tSexey's School\t\t\t",
"BRNL\ts\tMendel University of Agriculture and Forestry, Department of Forest Botany, Dendrology, and Typology\t\t\t",
"BRNM\ts\tMoravian Museum\t\t\t",
"BRNU\ts\tMasaryk University, Department of Botany\t\t\t",
"BROC\ts\tState University of New York, Biological Sciences Department\t\t\t",
"BRPP\ts\tBotanica Royal Park of Palm Hills\t\t\t",
"BRS\ts\tAgriculture and Agri-Food Canada\t\t\t",
"BRSL\ts\tWroclaw University, Botany Department\t\t\t",
"BRSMG\ts\tDepartment of Geology\t\t\t",
"BRSN\ts\tUniversity of Wales, Bangor Research Unit\t\t\t",
"BRSU\ts\tBryansk State University\t\t\t",
"BRTN\ts\tBrighton Natural History Society\t\t\t",
"BRU\ts\tBrown University\t\t\t",
"BRUN\ts\tBrunei Forestry Centre\t\t\t",
"BRV\ts\tColecciones paleontologicas del Departamento de Geociencias de la Universidad Nacional de Colombia\t\t\t",
"BRVU\ts\tVrije Universiteit Brussel\t\t\t",
"BRWK\ts\tBerwick-upon-Tweed Museum\t\t\t",
"BRY\ts\tBrigham Young University\t\t\t",
"BSA\ts\tBotanical Survey of India, Central Circle\t\t\t",
"BSB\ts\tFreie Universitaet Berlin, Institut fuer Biologie - Systematische Botanik und Pflanzengeographie\t\t\t",
"BSC\ts\tCentro Oriental de Ecosistemas y Biodiversidad\t\t\t",
"BSCA\ts\tAnza-Borrego Desert State Park\t\t\t",
"BSCVC\ts\tBemidji State University, Vertebrate Collections\t\t\t",
"BSD\ts\tBotanical Survey of India, Northern Circle\t\t\t",
"BSE\ts\tMoyse's Hall Museum\t\t\t",
"BSHC\ts\tBotanical Survey of India, Sikkim Himalayan Circle\t\t\t",
"BSI\ts\tBotanical Survey of India, Western Circle, Ministry of Environment and Forests\t\t\t",
"BSID\ts\tBotanical Survey of India\t\t\t",
"BSIP\ts\tMinistry of Natural Resources, Department of Forests, Environment, and Conservation\t\t\t",
"BSIS\ts\tBotanical Survey of India, Industrial Section\t\t\t",
"BSJO\ts\tBotanical Survey of India, Arid Zone Circle\t\t\t",
"BSKU\ts\tKochi University\t\t\t",
"BSL\ts\tBotanical Society of London\t\t\t",
"BSM\ts\tBerliner Staatisches Museum\t\t\t",
"BSMB\tc\tBacteriology and Soil Microbiology Branch\t\t\t",
"BSMP\ts\tDepartment of Agriculture, Bureau of Science\t\t\t",
"BSN\ts\tBoston University, Biology Department\t\t\t",
"BSNH\ts\tBoston Society of Natural History\t\t\t",
"BSNS\ts\tBuffalo Society of Natural Sciences\t\t\t",
"BSNS:Herpetology\ts\tBuffalo Society of Natural Sciences, Herpetology collection\t\t",
"BSNS:Ornithology\ts\tBuffalo Society of Natural Sciences, Ornithology collection\t\t",
"BSPG\ts\tBayerische Staatssammlung fur Palaontologie und  Geologie\tBS,BSP\t\t",
"BSRA\ts\tUniversity of Basrah, Biology Department\t\t\t",
"BSRM\ts\tBiological Station Reference Museum at Porto Novo\t\t\t",
"BST\ts\tBelfast Naturalists' Field Club\t\t\t",
"BSTN\ts\tBoothstown Botanical Society\t\t\t",
"BSU\ts\tBelgorod State University, Department of Botany\t\t\t",
"BSUH\ts\tBall State University, Biology Department\t\t\t",
"BSUMC\ts\tBall State University, Mammal Collection\t\t\t",
"BTCC<BULG>\tc\tBulgarian Type Culture Collection\t\t\t",
"BTCC<INDO>\tc\tBiotechnology Culture Collection Institution Pusat Penelitian dan Pengembangan Bioteknologi-LIPI\t\t\t",
"BTH\ts\tMuseum, Bath Royal Literary and Scientific Institution\t\t\t",
"BTJW\ts\tBridger Teton National Forest\t\t\t",
"BTN\ts\tBooth Museum of Natural History\t\t\t",
"BTT\ts\tBurton-upon-Trent Natural History and Archaeological Society\t\t\t",
"BTU\ts\tTechnische Universitaet Berlin\t\t\t",
"BU\ts\tBrock University\t\t\t",
"BUA\ts\tUniversity of Baghdad, Plant Protection Department\t\t\t",
"BUAG\ts\tUniversity of Agronomical Sciences and Veterinary Medicine, Botany and Plant Physiology Department\t\t\t",
"BUC\ts\tGradina Botanica D. Brandza\t\t\t",
"BUCA\ts\tInstitute of Biology, Romanian Academy\t\t\t",
"BUCF\ts\tForest Research and Management Institute\t\t\t",
"BUCM\ts\tInstitute of Biology Bucharest, Romanian Academy (Mycology Herbarium)\t\t\t",
"BUCSAV\tc\tBiologicky Ustav\t\t\t",
"BUE\ts\tUniversity of Baghdad, Biology Department\t\t\t",
"BUEN\ts\tProteccion de la Naturaleza\t\t\t",
"BUF\ts\tBuffalo Museum of Science\t\t\t",
"BUH\ts\tUniversity of Baghdad, Biology Department\t\t\t",
"BUHGC\ts\tBarton-on-Humber Grammar School\t\t\t",
"BUHR\ts\tBaysgarth Museum\t\t\t",
"BUL\ts\tNatural History Museum of Zimbabwe\t\t\t",
"BULQ\ts\tBishop's University\t\t\t",
"BULU\ts\tUludag University, Biology Department\t\t\t",
"BUNH\ts\tUniversity of Baghdad\t\t\t",
"BUNS\ts\tUniversity of Novi Sad, Department of Biology and Ecology\t\t\t",
"BUPL\ts\tBucknell University, Biology Department\t\t\t",
"BUQ\tc\tUniversity of Balochistan, Quetta\t\t\t",
"BURD\ts\tUniversity of Burdwan, Botany Department\t\t\t",
"BURI\ts\tBanasthali University\t\t\t",
"BURP\ts\tBurpee Museum of Natural History\tBMNHC\t\t",
"BUS\ts\tUniversity of Miami, Biology Department\t\t\t",
"BUT\ts\tButler University\t\t\t",
"BUTC\ts\tBoston University\t\t\t",
"BVC\ts\tBuena Vista College\t\t\t",
"BVS\ts\tTransylvania University of Brasov\t\t\t",
"BYBS\ts\tBungay Botanical Society\t\t\t",
"BYDG\ts\tTechnical-Agriculture Academy, Department of Botany and Ecology\t\t\t",
"BYU\ts\tMonte L. Bean Life Science Museum\t\t\t",
"BZ\ts\tHerbarium Bogoriense\t\t\t",
"BZCM\ts\tBozhou Vocational and Technical College\t\t\t",
"BZF\ts\tForest Research and Development Center and Nature Conservation\t\t\t",
"BZM\ts\tMuseum fur Naturkunde, Berlin\t\t\t",
"BZT\ts\tBiological Institute Titograd\t\t\t",
"C\ts\tNatural History Museum of Denmark\t\t\t",
"CA\ts\tChicago Academy of Sciences\tCA\t\t",
"CA: Mammal\ts\tChicago Academy of Sciences,  Mammalogy Collection\t\t",
"CA:Bird\ts\tChicago Academy of Sciences, Ornithology Collection\t\t",
"CA:Fish\ts\tChicago Academy of Sciences,  Ichthyology collection\t\t",
"CA:HERP\ts\tChicago Academy of Sciences, Herpetology collection\t\t",
"CAB\tc\tYeast Collection of Department of Microbiology, Stellenbosch University\t\t\t",
"CABI\tc\tCABI Genetic Resource Collection\tIMI\thttp://194.203.77.76/grc/DisplayResults.asp?strGRCNumber=#S#\t",
"CACA\ts\tCarlsbad Caverns National Park\t\t\t",
"CACC<CHN>\tc\tChina Antibiotic Culture Collection Center\t\t\t",
"CACS\ts\tChicago Academy of Sciences, Department of Biology\t\t\t",
"CAEN<FRA>\ts\tJardin Botanique de la Ville de Caen\t\t\t",
"CAES\ts\tConnecticut Agriculture Experiment Station\t\t\t",
"CAF\ts\tChinese Academy of Forestry\t\t\t",
"CAFB\ts\tNorthern Forestry Centre, Canadian Forest Service\t\t\t",
"CAG\ts\tUniversita di Cagliari\t\t\t",
"CAH\ts\tUniversity of Zimbabwe, Biological Sciences Department\t\t\t",
"CAHS\ts\tCrispus Attucks High School\t\t\t",
"CAHUP\ts\tUniversity of the Philippines Los Banos\t\t\t",
"CAI\ts\tCairo University, Botany Department\t\t\t",
"CAIA\ts\tAin Shams University, Department of Botany\t\t\t",
"CAIH\ts\tDesert Research Center, Mataria, Plant Ecology\t\t\t",
"CAIM<EGY>\ts\tAgricultural Research Center\t\t\t",
"CAIM<MEX>\tc\tCollection of Aquatic Important Microorganisms\t\t\t",
"CAIRC\ts\tNational Research Centre, Plant Chemistry and Systematics Department\t\t\t",
"CAIRCC\tc\tCAIRCC\t\t\t",
"CAIRNS\ts\tc/o North Queensland Naturalists' Club\t\t\t",
"CAL\ts\tBotanical Survey of India\t\t\t",
"CALI\ts\tUniversity of Calicut, Botany Department\t\t\t",
"CALP\ts\tUniversity of the Philippines at Los Banos\t\t\t",
"CALU\tc\tCollection of Algae in Leningrad, St. Petersburg, State University\t\t\t",
"CALVIN\ts\tCalvin College\t\t\t",
"CAM<AUST>\ts\tCentral Australian Museum\t\t\t",
"CAM<UK>\ts\tSt. John's College\t\t\t",
"CAME\ts\tUniversita di Camerino, Dipartimento de Botanica ed Ecologia\t\t\t",
"CAMS<ZAF>\tc\tCentre for Applied Mycological Studies\t\t\t",
"CAMU\tc\tCollection of Algae at Bohdan Khmelnytskyi Melitop&#1086;l State Pedagogical University\t\t\t",
"CAMU<USA>\ts\tCameron University, Department of Biological Sciences\t\t\t",
"CAN\ts\tCanadian Museum of Nature, Vascular Plant Section\t\t\t",
"CANA\ts\tCanadian Museum of Nature, Phycology Section\t\t\t",
"CANB\ts\tAustralian National Herbarium, Canberra\t\t\t",
"CANI\ts\tCanisius College, Biology Department\t\t\t",
"CANL\ts\tCanadian Museum of Nature, Lichenology Section\t\t\t",
"CANM\ts\tCanadian Museum of Nature, Bryology Section\t\t\t",
"CANT\ts\tSouth China Agricultural University, Forestry Department\t\t\t",
"CANTE\tsb\tJardin Botanico El Charco del Ingenio\t\t\t",
"CANTY\ts\tCanterbury Museum\t\t\t",
"CANU\ts\tUniversity of Canterbury, Department of Plant and Microbial Sciences\t\t\t",
"CAPM\tc\tCollection of Animal Pathogenic Microorganisms\t\t\t",
"CAR\ts\tMuseo de Historia Natural La Salle, Departamento de Botanica\t\t\t",
"CARAN\ts\tHerbarium Carautanum\t\t\t",
"CARD\ts\tCaribbean Agricultural Research Institute\t\t\t",
"CARE\ts\tCaribbean Epidemiology Centre\t\t\t",
"CARI\ts\tCukurova Agricultural Research Institute\t\t\t",
"CARL\ts\tCarleton College, Biology Department\t\t\t",
"CARM\ts\tCarmarthen County Museum\t\t\t",
"CARS\ts\tUniversity of Surinam, Center for Agricultural Research\t\t\t",
"CART\ts\tCarthage College, Biology Department\t\t\t",
"CAS\ts\tCalifornia Academy of Sciences\t\t\t",
"CAS-IU\ts\tCalifornia Academy of Science, Indiana University Collection\t\t\t",
"CAS-SU\ts\tCalifornia Academy of Sciences, Stanford University Collection\tCAS(SU)\t\t",
"CAS:ANTH\ts\tCalifornia Academy of Sciences, Anthropology Collection\t\t",
"CAS:BOT\ts\tCalifornia Academy of Sciences, Botany Collection\t\t",
"CAS:DIA\ts\tCalifornia Academy of Sciences, Diatom collection\t\t",
"CAS:DS\ts\tCalifornia Academy of Sciences, Dudley Stanford Collection\t\t",
"CAS:EGG\ts\tCalifornia Academy of Sciences, Egg & Nest Collection\t\t",
"CAS:ENT\ts\tCalifornia Academy of Sciences, Entomology collection\t\t",
"CAS:HERP\ts\tCalifornia Academy of Sciences, Herpetology collection\thttp://researcharchive.calacademy.org/research/herpetology/catalog/index.asp?xAction=getrec&close=true&CatalogNo=CAS+",
"CAS:ICH\ts\tCalifornia Academy of Sciences, Ichthyology collection\t\t",
"CAS:IU\ts\tCalifornia Academy of Sciences, Indiana University fish collection\t\t",
"CAS:IZ\ts\tCalifornia Academy of Sciences, Invertebrate Zoology collection\t\t",
"CAS:MAM\ts\tCalifornia Academy of Sciences, Mammalogy Collection\t\t",
"CAS:ORN\ts\tCalifornia Academy of Sciences, Ornithology Collection\t\t",
"CAS:SU\ts\tCalifornia Academy of Sciences, Stanford University Collection of fish\t\t",
"CAS:SUA\ts\tCalifornia Academy of Sciences, Stanford University Collection of amphibians\t\t",
"CAS:SUR\ts\tCalifornia Academy of Sciences, Stanford University Collection of reptiles\t\t",
"CAS:TYPE\ts\tCalifornia Academy of Sciences, Entomology Type Collection\t\t",
"CASM\ts\tChicago Academy of Sciences, Museum of Natural History\t\t\t",
"CASMB\ts\tCentre of Advanced Study in Marine Biology\t\t\t",
"CASS\ts\tChinese Academy of Sciences, Shenyang\t\t\t",
"CAT\ts\tUniversita di Catania, Dipartimento di Botanica e Orto Botanico\t\t\t",
"CATA\ts\tCatalina Island Conservancy\t\t\t",
"CATH\ts\tCatholicate College\t\t\t",
"CATIE\ts\tTropical Agricultural Research and Training Center (CATIE), Plant Production Department\t\t\t",
"CAU\ts\tChina Agricultural University\t\t\t",
"CAUP<COL>\ts\tUniversidad del Cauca\t\t\t",
"CAUP<CZH>\tc\tCollection of Algae of Charles University, Prague\t\t\t",
"CAUSC\ts\tUniversidade Federal de Santa Catarina Centro de Agrarias\t\t\t",
"CAVA\ts\tUniversity of California at Berkeley\t\t\t",
"CAWC\ts\tConservation Commission of the Northern Territory\tNTM\t\t",
"CAY\ts\tInstitut de Recherche pour le Developpement (IRD)\t\t\t",
"CAYM\ts\tNational Trust for the Cayman Islands\t\t\t",
"CB<AUST>\tc\tThe CB Rhizobium Collection\t\t\t",
"CB<CZE>\ts\tJihoceske Muzeum\t\t\t",
"CBAS\tc\tBacteria Collection of Environmemt and Health (Colecao de Bacterias do Ambiente e Saude)\t\t\t",
"CBC\ts\tCentre for Biodiversity Conservation\t\t\t",
"CBD<ITA>\ts\tCollezione Ittiologica Balma-Delmastro\t\t\t",
"CBD<USA>\tc\tUSF Center for Biological Defense\tUSF:CBD\t\t",
"CBF\ts\tColeccion Boliviana de Fauna\tCBFC\t\t",
"CBFS\ts\tUniversity of South Bohemia, Department of Botany\t\t\t",
"CBG\ts\tAustralian National Botanic Gardens\t\t\t",
"CBM\ts\tNatural History Museum and Institute\t\t\t",
"CBM:ZC\ts\tNatural History Museum and Institute, Zoological Collection\t\t",
"CBM:ZF\ts\tNatural History Museum and Institute, Zoology Fish\t\t",
"CBMAI\tc\tBrazilian Collection of Microorganisms from the Environment and Industry (Colecao Brasileira de Microrganismos de Ambiente e Industria)\t\t\t",
"CBNM\ts\tCedar Breaks National Monument\t\t\t",
"CBNSA\ts\tConservatoire botanique national Sud-Atlantique\t\t\t",
"CBPF\ts\tConservatoire Botanique Pierre Fabre\t\t\t",
"CBS\tsc\tWesterdijk Fungal Biodiversity Institute\t\thttp://www.wi.knaw.nl/collections/BioloMICS.aspx?Fields=All&ExactMatch=T&Table=CBS+strain+database&Name=CBS+\t",
"CBSIZA\ts\tCaspian Biological Station Institute of Zoology\t\t\t",
"CBTCCCAS\tc\tThe Cell Bank of Type Culture Collection of Chinese Academy of Sciences\t\t\t",
"CBU<CAN>\ts\tCape Breton University\t\t\t",
"CBU<SKOR>\ts\tChungbuk National University, School of Life Science\t\t\t",
"CBY\ts\tRoyal Museum and Art Gallery\t\t\t",
"CC\tc\tCSIRO Canberra Rhizobium Collection\t\t\t",
"CCA-Marburg\tc\t Culture Collection of Algae at the University of Marburg\t\t\t",
"CCAC<BRA>\ts\tUniversidade Federal do Ceara, Centro Ciencias Agrarias\t\t\t",
"CCAC<DEU>\tc\tCulture Collection of Algae at the University of Cologne\t\t\t",
"CCALA\tc\tCulture Collection of Autotrophic Organisms\t\t\t",
"CCAP\tc\tCulture Collection of Algae and Protozoa\t\thttps://www.ccap.ac.uk/strain_info.php?Strain_No=\t",
"CCARM\tc\tCulture Collection of Antimirobial Resistant Microorganisms\t\t\t",
"CCAU\ts\tCentral China Agricultural University\t\t\t",
"CCB<BRZ>\tc\tColecao de Culturas de Basidiomicetos\t\t\t",
"CCB<IND>\ts\tCentral College, Bangalore\t\t\t",
"CCBAS\tc\tCulture Collection of Basidiomycetes\t\t\t",
"CCBAU\tc\tCulture Collection, Beijing Agricultural University\t\t\t",
"CCC\tc\tCulture Collection of Clavicipitaceae\t\t\t",
"CCC<IND>\tc\tCyanobacterial Culture Collection, National Centre for Conservation and Utilisation of Blue Green Algae\t\t\t",
"CCCC\ts\tCarthage College\t\t\t",
"CCCIEB\tc\tCulture Collections of Microorgansisms of Center of Genetic Engineering and Biotechnology\t\t\t",
"CCCM\tc\tCanadian Center for the Culture of Microorganisms\t\t\t",
"CCCR\ts\tFederal University of Tocantins\t\t\t",
"CCCryo<DEU>\tc\tCulture Collection of Cryophilic Algae\t\t\t",
"CCCS\tc\tCulture Collection of Ciliates and their Symbionts\t\t\t",
"CCCT\tc\t Coleccion Chilena de Cultivos Tipo-CCCT/UFRO\t\t\t",
"CCCZ\ts\tUniversity of Malawi\t\t\t",
"CCDB<BRA>\ts\tCrustacean Collection of the Department of Biology\tUSP:CCDB\t\t",
"CCDM<CHN>\tc\tCulture Collection of Department of Microbiology\t\t\t",
"CCDM<CZH>\tc\tCulture Collection of Dairy Microorganisms Laktoflora\t\t\t",
"CCDMBI\tc\tCulture Collection, Department of Microbiology\t\t\t",
"CCEB\tc\tCulture Collection of Entomogenous Bacteria\t\t\t",
"CCEC\ts\tMuseum, Centre de Conservation et d'Etude des Collections\t\t\t",
"CCF<CUB>\tc\tColleccion de Cuttivos Finlay\t\t\t",
"CCF<CZE>\tc\tCulture Collection of Fungi\t\t\t",
"CCFC\tc\tCanadian Collection of Fungal Cultures\t\t\t",
"CCFEE\tc\tCulture Collection of Fungi From Extreme Environments\t\t\t",
"CCFHE\ts\tCornwall College of Further and Higher Education, Natural Sciences Department\t\t\t",
"CCFL\ts\tChad National Museum\t\t\t",
"CCFVB\tc\tFacultat de Veterinaria, Universitat Autonoma de Barcelona\t\t\t",
"CCG<CHN>\ts\tChengdu College of Geology\tCHG\t\t",
"CCG<GHN>\ts\tUniversity of Cape Coast, Botany Department\t\t\t",
"CCGB\tc\tCulture Collection of Bacillus and Related Genera (Instituto Oswaldo Cruz)\t\t\t",
"CCGVCC\tc\tChina Centre for General Viruses Culture Collection\t\t\t",
"CCH\ts\tUniversity of Arizona South, Agricultural Extension Service\t\t\t",
"CChRGM\tc\tChilean Collection of Microbial Genetic Resources\tRGM\t\t",
"CCIAL\tc\tCultures Cells for Institute Adolfo Lutz\t\t\t",
"CCIBSO\tc\tCulture Collection IBSO\t\t\t",
"CCIBt\tc\tCulture Collection at the Institute of Botany, Sao Paulo\t\t\t",
"CCIM\tc\tCulture Collection of Industrial Microorganisms\t\t\t",
"CCM\tc\tCzech Collection of Microorganisms\tCCM<CZE>\t\t",
"CCM-A\tc\tColeccion de Cultivos Microbianos\t\t\t",
"CCM-CIBE\tc\tEscuela Superior Politecnica del Litoral\t\t\t",
"CCM<CHN>\ts\tChangchun College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t\t",
"CCM<USA-MT>\ts\tCarter County Museum\t\t\t",
"CCMA-UFSCar\tc\tCulture Collection of Freshwater Microalgae\t\t\t",
"CCMAC\tc\tCulture Collection of Macromycetes (Basidiomycotina and Ascomycotina)\t\t\t",
"CCMCU\tc\tCulture Collection of Microorganisms\t\t\t",
"CCMF\tc\tUniversity of Portsmouth\t\t\t",
"CCMGE\ts\tChernyshev Central Museum of Geological Explorations,Collections of the Department of Herpetology, Zoological Institute of the Russian Academy of Sciences\t\t\t",
"CCMH\ts\tConcordia College\t\t\t",
"CCMI\tc\tCulture Collection of Industrial Microorganisms\t\t\t",
"CCML\ts\tColeccion Ictiologica del Departamento de Ciencias Marinas de la Universidad de la Laguna\t\t\t",
"CCMM\tc\tMoroccan Coordinated Collections of Microorganisms\t\t\t",
"CCMP\tc\tProvasoli-Guillard National Center for Marine Algae and Microiota\t\t\t",
"CCNH\ts\tCentral Michigan University, Center for Cultural and Natural History\t\t\t",
"CCNL\ts\tConnecticut College, Botany Department\t\t\t",
"CCNP\ts\tCarlsbad, Carlsbad Caverns National Park\t\t\t",
"CCNP<POL>\tc\tCulture Collection of Northern Poland\t\t\t",
"CCNU\ts\tCentral China Normal University, Biology Department\t\t\t",
"CCO\ts\tCarleton University, Biology Department\t\t\t",
"CCOS<CHE>\tc\tCulture Collection of Switzerland\t\t\t",
"CCPF\tc\tCollection of Phytopathogenic Fungi\t\t\t",
"CCR\ts\tChichester District Museum\t\t\t",
"CCRI\tc\tCollection du Centre de Recherche en Infectiologie\t\t\t",
"CCRI<IND>\tscb\tThe Central Coffee Research Institute\t\t\t",
"CCSIIA\tc\tCulture Collection of Sichuan Industrial Institute Antibiotics\t\t\t",
"CCSRL\ts\tCentro Studi e Ricerche Ligabue\t\t\t",
"CCSU\ts\tCentral Connecticut State University, Biological Sciences Department\t\t\t",
"CCT\tc\tColecao de Culturas Tropical\t\t\t",
"CCTCC\tc\tChina Center for Type Culture Collection\t\t\t",
"CCTM\tc\tCentre de Collection de Type Microbien, Institut de Microbiologie, Universite de Lausanne\t\t\t",
"CCTR\tc\tCulture Collection Trutnov\t\t\t",
"CCTS\ts\tUniversidade Federal de Sao Carlos - campus Sorocaba\t\t\t",
"CCTU\tc\tCulture Collection of Tabriz University\t\t\t",
"CCUF\ts\tUniversidade Federal de Alagoas, Centro de Ciencias Biologicas\t\t\t",
"CCUG\tc\tCulture Collection, University of Goteborg, Department of Clinical Bacteriology\t\thttps://www.ccug.se/default.cfm?page=search_record.cfm&db=mc&s_tests=1&ccugno=\t",
"CCVC\ts\tCentenary College, Vertebrate Collection\t\t\t",
"CCVCC\tc\tChina Center For Virus Culture Collection\t\t\t",
"CCW\ts\tCasper College\t\t\t",
"CCY<NLD>\tc\tCulture Collection Yerseke, Department of Marine Microbiology\t\t\t",
"CCY<SVK>\tc\tCulture Collection of Yeasts, Slovak Academy of Sciences, Institute of Chemistry\t\t\t",
"CDA<CAN>\tc\tCanadian Department of Agriculture\t\t\t",
"CDA<USA-CA>\ts\tCalifornia Department of Food and Agriculture\t\t\t",
"CDBB\tc\tColeccion Nacional de Cepas Microbianas y Cultivos Celulares\t\t\t",
"CDBI\ts\tChengdu Institute of Biology\t\t\t",
"CDC\tc\tCenters for Disease Control and Prevention\t\t\t",
"CDC<CHN>\ts\tChangdu Institute for Drug Control\t\t\t",
"CDCM\ts\tChengdu College of Traditional Chinese Medicine\t\t\t",
"CDFM\ts\tCardiff Museum\t\t\t",
"CDFN\ts\tCanadian Forest Service - Atlantic\t\t\t",
"CDN\ts\tWhitgift School\t\t\t",
"CDRI\ts\tCentral Drug Research Institute\t\t\t",
"CDRS\ts\tInvertebrate Collection\t\t\t",
"CDS\ts\tCharles Darwin Research Station, Botany Department\t\t\t",
"CEAM\ts\tCentro de Entomologica y Acarologia\t\t\t",
"CEB\ts\tTadulako University\t\t\t",
"CEB<FRA>\tc\tCentre d'Etudes du Bouchet\t\t\t",
"CEBU\ts\tUniversity of San Carlos, Biology Department\t\t\t",
"CECT\tc\tColeccion Espanola de Cultivos Tipo\t\t\t",
"CEDD\ts\tInternational Center for Ethnomedicine and Drug Development\t\t\t",
"CEDiT\ts\tCentre of Excellence for Dinophyte Taxonomy\t\t\t",
"CEEF\ts\tEscuela Nacional de Ciencias Forestales\t\t\t",
"CEET\ts\tEl Colegio de la Frontera Sur, Colleccion de Insectos Asociados a Plantas Cultivadas en la Frontera Sur\t\t\t",
"CEL\ts\tUniversity of Illinois, Crop Sciences Department\t\t\t",
"CELM\ts\tColeccion Entomologica \"Luis Maria Murillo\"\t\t\t",
"CELMS\tc\tCollection of Environmental and Laboratory Microbial Strains\t\t\t",
"CEMBP\ts\tCentre of Excellence in Marine Biology\t\t\t",
"CEN\ts\tGenetic Resources and Biotechnology (CENARGEN), EMBRAPA\t\t\t",
"CENA<BRZ>\ts\tCentro de Energia Nuclear na Agricultura, Universidade de Sao Paulo\t\t\t",
"CENA<NIC>\ts\tCentro Nacional de Proteccion Vegetal\t\t\t",
"CENACUMI\tc\tCentro Nacional de Cultivos Microbianos (National Center For Microbial Cultures)\t\t\t",
"CENG\ts\tCentro Experimental de Nueva Guinea\t\t\t",
"CEP\tc\tEntomopathogenic Fungal Culture Collection of Argentina\t\t\t",
"CEPEC\ts\tCEPEC, CEPLAC\t\t\t",
"CEPH\tb\tFoundation Jean Dausset (CEPH)\t\t\t",
"CEPIM\tc\tCentro per gli Enterobatteri Patogeni per l'Italia Meridionale\t\t\t",
"CEPM\tc\tCEPM- Centre d'Etudes sur le Polymorphisme des Micro-organismes\t\t\t",
"CERL/BIC\ts\tUnited States Army, Biological Inventory Collection\t\t\t",
"CERMES\ts\tCentre for Resource Management and Environmental Studies, University of the West Indies\t\t\t",
"CES\ts\tThe Centre for Ecological Sciences,  Indian Institute of Science\t\t\t",
"CESJ\ts\tUniversidade Federal de Juiz de Fora, Departamento de Botanica\t\t\t",
"CESK\ts\tMuzeum Teainska\t\t\t",
"CEST\ts\tCentral Experiment Station\t\t\t",
"CET\ts\tCentro de Estudios Tropicales\t\t\t",
"CETESB\tc\tSetor de Pesquisa Tecnologica de Sistemas de Tratamento de Efluentes Domesticos\t\t\t",
"CEU\ts\tCollage of Eastern Utah\t\t\t",
"CFB\ts\tNorthern Forestry Centre, Canadian Forest Service\t\t\t",
"CFBH\ts\tCelio F.B. Haddad Herpetological Collection, Departamento de  Zoologia, Universidade Estadual Paulista\t\t\t",
"CFBP\tc\tFrench Collection for Plant-associated Bacteria\tCFBP\t\t",
"CFCC\tcb\tChina Forestry Culture Collection Center\t\t\t",
"CFI\ts\tGenetic Resources and Biotechnology (CENARGEN), EMBRAPA\t\t\t",
"CFIA\ts\tCanadian Food Inspection Agency\t\t\t",
"CFMR\tsc\tUSDA Forest Service, Center for Forest Mycology Research\tFPL\thttps://www.fpl.fs.fed.us/search/mycologysearch_action.php?sorting_rule=1u&phrasesAndKeywords02=\t",
"CFN\ts\tClifton College, Biology Department\t\t\t",
"CFNL\ts\tUniversidad Autonoma de Nuevo Leon\t\t\t",
"CFQ\tc\tCepario de la Facultad de Quimica\t\t\t",
"CFRB\ts\tChinese Academy of Forestry, Forest Research Institute\t\t\t",
"CFS\ts\tCanadian Forest Service, Pacific Forest Research Centre\t\t\t",
"CFSHB\ts\tNorth Coast Regional Botanic Gardens\t\t\t",
"CFUA\ts\tUniversidad Austral de Chile\t\t\t",
"CG\tc\tEmbrapa Collection of Fungi of Invertebrates\t\t\t",
"CGC\tb\tCaenorhabditis Genetics Center\t\t\t",
"CGE\ts\tCambridge University, Department of Plant Sciences\t\t\t",
"CGEC\ts\tChina Entomological Research Institute\t\t\t",
"CGG\ts\tCambridge University Botanic Garden\t\t\t",
"CGH\ts\tNational Museum of Prague\t\t\t",
"CGMCC\tc\tChina General Microbiological Culture Collection Center\tAS\t\t",
"CGMS\ts\tUniversidade Federal de Mato Grosso do Sul, Departamento de Biologia\t\t\t",
"CGN\ts\tCentre for Genetic Resources, The Netherlands\t\t\t",
"CGRIS\tb\tChinese Crop Germplasm Resources Information Network\t\t\t",
"CGSC\tc\tE. coli Genetic Stock Center\t\t\t",
"CH\ts\tCirculo Herpetologico de Panama\t\t\t",
"CH-AG\tc\tCollection de Recherche\t\t\t",
"CHA\ts\tHebei Agrotechnical Teachers College\t\t\t",
"CHAB\ts\tFar East Forestry Research Institute\t\t\t",
"CHAF\ts\tChaffey College, Biology Department\t\t\t",
"CHAM\ts\tI.N.T.A., E.E.A. La Rioja\t\t\t",
"CHAP\ts\tUniversidad Autonoma Chapingo\t\t\t",
"CHAPA\ts\tColegio de Postgraduados, Botanica, IRENAT\t\t\t",
"CHARL\ts\tCharleston Museum\t\t\t",
"CHBG\ts\tChristchurch Botanic Gardens\t\t\t",
"CHBY\ts\tMuseum d'Histoire Naturelle de Chambery\t\t\t",
"CHE\ts\tSociete Nationale des Sciences Naturelles et Mathematiques de Cherbourg\t\t\t",
"CHEB\ts\tRegional Museum Cheb\t\t\t",
"CHEL\ts\tChelsea Physic Garden\t\t\t",
"CHELB\ts\tCheltenham College for Boys\t\t\t",
"CHEP\ts\tEscuela Superior Politecnica del Chimborazo\t\t\t",
"CHER\ts\tYu. Fedcovich Chernivtsi State University, Botany Department\t\t\t",
"CHFD\ts\tChelmsford and Essex Museum\t\t\t",
"CHI\ts\tUniversity of Illinois, Biological Sciences Department\t\t\t",
"CHIA\ts\tNational Chiayi Agricultural College, Forestry Department\t\t\t",
"CHIC\ts\tChicago Botanic Garden, Research Department\t\t\t",
"CHINM\ts\tInstituto Nacional de Microbiologia\t\t\t",
"CHIOC\ts\tHelminthological Collection of Oswaldo Cruz Institute (Coleccion. Helmintologica del Instituto Oswaldo Cruz)\t\t\t",
"CHIP\ts\tInstituto de Historia Natural, Departamento de Botanica\t\t\t",
"CHIS\ts\tAcademy of Sciences of Moldova\t\t\t",
"CHISA\ts\tUniversity of Agriculture\t\t\t",
"CHL\ts\tCheltenham Grammar School\t\t\t",
"CHM<UK>\ts\tCheltenham Art Gallery and Museum\t\t\t",
"CHM<USA-SC>\ts\tCharleston Museum\t\t\t",
"CHNCB\ts\tCentre d'Historia Natural de la Conca de Barbera\t\t\t",
"CHOCO\ts\tUniversidad Tecnologica del Choco\t\t\t",
"CHOM\ts\tOkresni muzeum Chomutov\t\t\t",
"CHPU\ts\tChelyabinsk State Pedagogical University, Botany Department\t\t\t",
"CHR\ts\tAllan Herbarium\tLCR:CHR\t https://scd.landcareresearch.co.nz/Specimen/CHR_\t",
"CHRB\ts\tRutgers University - Cook College\t\t\t",
"CHRG\ts\tGrosvenor Museum\t\t\t",
"CHSC\ts\tCalifornia State University, Chico\t\t\t",
"CHT\ts\tCheltenham College\t\t\t",
"CHUG\ts\tGaryounis University, Botany Department\t\t\t",
"CHULA\tc\tMicrobiology Department Faculty of Science\t\t\t",
"CHUNB\ts\tUniversity of Brasilia Herpetological Collection\t\t\t",
"CHUR\ts\tBuendner Natur-Museum\t\t\t",
"CI\ts\tCarnegie Institution of Washington, Plant Biology Department\t\t\t",
"CIAN<MEX-AG>\ts\tInstituto Nacional de Investigaciones Forestales, Agricolas y Pecuarias (INIFAP)\t\t\t",
"CIAN<MEX-CO>\ts\tCentro de Investigaciones Agricolas Nortoeste\t\t\t",
"CIAT\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture)\t\t\t",
"CIAT:Bean\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Bean Collection\t\t",
"CIAT:Cassava\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Cassava Collection\t\t",
"CIAT:Forage\tb\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Forages Collection\t\t",
"CIAT:Rhizobium\tc\tCentro Internacional de Agricultura Tropical (International Center for Tropical Agriculture), CIAT Rhizobium Collection\t\t",
"CIB<CHN>\ts\tChengdu Institute of Biology\t\t\t",
"CIB<MEX-LaPaz>\ts\tCentro de Investigaciones Biologicas del Noroeste, S.C. (Mexico)\t\t\t",
"CIB<MEX-Veracruz>\ts\tUniversidad Veracruzana\t\t\t",
"CIBC\ts\tInternational Institute of Biological Control\t\t\t",
"CIBIO\ts\tCentro de Investigacao em Biodiversidade e Recursos Geneticos\t\t\t",
"CIBM\ts\tCentro Invest. Biol. Noroeste\t\t\t",
"CIC\ts\tAlbertson College of Idaho, Biology Department\t\t\t",
"CICC\tc\tChina Center for Industrial Culture Collection\t\t\t",
"CICCM\tc\tCawthron Institute Culture Collection of Micro-algae\t\t\t",
"CICESE\ts\tCentro de Investigacion Cientifica y de Educacion Superior de Ensenada\t\t\t",
"CICIM\tc\tCulture and Information Centre of Industrial Microorganisms of China's Univeristies\t\t\t",
"CICIMAR\ts\tCentro Interdisciplinario de Ciencias Marinas\t\t\t",
"CICV\tc\tCentro de Investigaciones en Ciencias Veterinarias\t\t\t",
"CICY\ts\tCentro de Investigacion Cientifica de Yucatan, A.C. (CICY)\t\t\t",
"CIDA\ts\tAlbertson College, Museum of Natural History\t\t\t",
"CIECRO\ts\tCounty Record Office, Cambridgeshire\t\t\t",
"CIES\tc\tCentro de Investigacion, Experimentacion y Servicios del  Champinon\t\t\t",
"CIFE\ts\tCentral Institute of Fisheries Education\t\t\t",
"CIIDIR\ts\tInstituto Politecnico Nacional\t\t\t",
"CIJC\ts\tMuzeului Judetean Covasna, Collection of Insects\t\t\t",
"CIMAP\ts\tCentral Institute of Medicinal and Aromatic Plants\t\t\t",
"CIMAR\ts\tUniversidad Catolica de Valparaiso, Centro de Investigaciones del Mar\t\t\t",
"CIMI\ts\tCentro Interdisciplinario de Investigacion para el Desarrollo Integral Regional (CIIDIR) IPN-Michoacan\t\t\t",
"CIMMYT\tscb\tInternational Maize and Wheat Improvement Center\t\t\t",
"CIMNH\ts\tAlbertson College of Idaho, Orma J. Smith Museum of Natural History\t\t\t",
"CIMSC\tc\tCollezione Instituto di Microbiologia\t\t\t",
"CINC\ts\tUniversity of Cincinnati, Biological Sciences Department\t\t\t",
"CIP\tc\tPasteur Institute Collection, Biological Resource Center of Pasteur Institute (CRBIP)\tCIP<FRA>\t\t",
"CIP<COL>\ts\tCentro de Investigaciones Pesqueras\t\t\t",
"CIP<ECU>\tc\tInternational Potato Center\t\t\t",
"CIP<PER>\tb\tCentro Internacional de las Papas\t\t\t",
"CIPDE\tc\tCollection of Insect Pathogens, Dept. of Entomology\t\t\t",
"CIPT\tc\tCollection Institut Pasteur Tuberculose\t\t\t",
"CIQR\ts\tEl Colegio de la Frontera Sur\t\t\t",
"CIR\ts\tRoyal Agricultural College\t\t\t",
"CIRAD\tsb\t Centre de Cooperation Internationale en Recherche Agronomique pour le Developpement\t\t\t",
"CIRUV\ts\tColeccion Ictiologica de Referencia de la Universidad del Valle\t\t\t",
"CIS<CHN>\ts\tAcademia Sinica and State Planning Commission\t\t\t",
"CIS<USA-CA>\ts\tCalifornia Insect Survey\t\t\t",
"CIS<USA-MI>\ts\tCranbrook Institute of Science\tCISM\t\t",
"CISM<MEX>\tc\tVerticillium dahliae from cotton\t\t\t",
"CISM<THAI>\tc\tNifTAL Rhizobium Collection (Asia Center)\t\t\t",
"CIT\ts\tCitrus Research Institute\t\t\t",
"CITA\ts\tThe Citadel, Biology Department\t\t\t",
"CIUC\ts\tCentro Interdipartimentale dell'Universita Museo di Storia Naturale e del Territorio\t\t\t",
"CIZ\ts\tCentro de Investigaciones Zoologicas\t\t\t",
"CKE\ts\tCalke Abbey\t\t\t",
"CL\ts\tBabes-Bolyai University\t\t\t",
"CLA\ts\tUniversitatea de Stiinte Agricole si Medicina Veterinara\t\t\t",
"CLARK\ts\tDr. Charles F. and Wilhelmina Husser Clark Herbarium\t\t\t",
"CLCB\ts\tLaboratorul de Ecologie\t\t\t",
"CLCC\ts\tAugustana University College\t\t\t",
"CLD\ts\tCleveland Literary and Philosophical Society\t\t\t",
"CLE\ts\tTullie House Museum\t\t\t",
"CLEMS\ts\tClemson University, Biological Sciences Department\t\t\t",
"CLEP\tc\tColecao de Leptospira\t\t\t",
"CLEV\ts\tCleveland Museum of Natural History\t\t\t",
"CLEY\ts\tCoastal Ecology Research Station\t\t\t",
"CLF\ts\tInstitut des Universitaires et Musee Lecoq\t\t\t",
"CLI\ts\tLiterary and Philosophical Institution of Chatham\t\t\t",
"CLIB\tc\tCollection de Levures d'Interet Biotechnologique Collection of Yeasts of Biotechnological Interest\t\t\t",
"CLIOC<BRA>\tc\tColecao de Leishmania do Instituto Oswaldo Cruz\tIOC:CL\t\t",
"CLM\ts\tCleveland Museum of Natural History, Botany Department\t\t\t",
"CLMP\ts\tDepartment of Conservation & Land Management\t\t\t",
"CLNP\ts\tCrater Lake National Park\t\t\t",
"CLOE\ts\tClitheroe Castle Museum\t\t\t",
"CLP\ts\tForest Products Research and Development Institute, Department of Science and Technology\t\t\t",
"CLQCA\tc\tColeccion de Levaduras quito catolica\t\t\t",
"CLR\ts\tAll Saint's Church, Colchester Borough Council\t\t\t",
"CLU\ts\tUniversita della Calabria\t\t\t",
"CM\ts\tCarnegie Museum of Natural History\tCMNH<USA-PA>\t\t",
"CM-IEA\ts\tUniversidad Autonoma de Tamaulipas (Mexico)\t\t\t",
"CM-MBM-UAC\ts\tColeccion Mastozoologica Universidad  Autonoma de Campeche\tCM-MBM-UAC,CMMBMUAC\t\t",
"CM-UFMG\tc\tCollection of Microorganisms, DNA and Cells of Universidade Federal de Minas Gerais (UFMG) (Colecao de Micro-organismos, DNA e Celulas da UFMG)\t\t\t",
"CM-UMSNH\ts\tUniversidad de Michoacan (Mexico)\t\t\t",
"CM:Herps\ts\tCarnegie Museum of Natural History, Herpetology Collection\t\t",
"CM:M\ts\tCarnegie Museum of Natural History, Section of Mammals\t\t",
"CM:O\ts\tCarnegie Museum of Natural History, Section of Birds\t\t",
"CM:VertPaleo\ts\tCarnegie Museum of Natural History, Vertebrate Paleontology Collection\t\t",
"CM<CHN>\ts\tChongqing Museum\t\t\t",
"CMA\ts\tCrayford Manor House Adult Education Centre\t\t\t",
"CMAA\tc\tCulture Collection of Agriculture and Environmental Importance\t\t\t",
"CMBG\ts\tCoastal Maine Botanical Gardens\t\t\t",
"CMBGCAS\tc\tCollection of Marine Biological Germplasm\t\t\t",
"CMBK\ts\tThe City Museum and Art Gallery, Department of Natural History\t\t\t",
"CMBY\ts\tCamberley Museum\t\t\t",
"CMC<MEX>\ts\tColeccion Mastozoologica del Centro de Investigacion en Biodiversidad y Conservacion,Universidad Autonoma del Estado de Morelos\t\t\t",
"CMC<NZ>\ts\tCanterbury Museum\tCMNZ\t\t",
"CMC<USA-MI>\ts\tCentral Michigan University, Department of Biology\t\t\t",
"CMCC\tc\tNational Center for Medical Culture Collections\t\t\t",
"CMCNA\ts\tMuseo de Ciencias Naturales y Antropologicas \"Prof. A. Serrano\"\t\t\t",
"CMEI\ts\tClements' Museum of Exotic Insects\t\t\t",
"CMFRI\ts\tCentral Marine Fisheries Research Institute\tFMRI\t\t",
"CMGP\ts\tCentral Museum of Geological Prospecting\t\t\t",
"CMH\ts\tCanadian Museum of History\t\t\t",
"CMIZASDPRK\ts\tCustody Museum\t\t\t",
"CMKKU\tc\tClinical Diagnostic Microbiology Srinagarind Hospital, Faculty of Medicine\t\t\t",
"CML\ts\tUniversidad Nacional de Tucuman, Coleccion de Mamiferos Lillo (Argentina)\t\t\t",
"CML<BRA>\tc\tColecao Micologica de Lavras\t\t\t",
"CMM\ts\tBradford Art Galleries and Museums, Natural Sciences Department\t\t\t",
"CMM<BRA>\tc\tCulture Collection of Phytopathogenic Fungi  (Colecao de Culturas de Fungos Fitopatogenicos Prof. Maria Menezes)\t\t\t",
"CMMC\tc\tChina Marine Microbe Collection\t\t\t",
"CMMED<USA-HI>\tc\tCenter for Marine Microbial Ecology & Diversity Collection\t\t\t",
"CMMEX\ts\tUniversidad Autonoma de Baja California\t\t\t",
"CMMF\ts\tCercle des Mycologues de Montreal Fungarium\t\t\t",
"CMMI\ts\tChinese Academy of Traditional Medicine\t\t\t",
"CMML\ts\tCenter for Environmental Management of Military Lands (CEMML)\t\t\t",
"CMN\ts\tCanadian Museum of Nature\tNMC<CAN>\t\t",
"CMN:Annelid\ts\tCanadian Museum of Nature, Annelid Collection\t\t",
"CMN:Bird\ts\tCanadian Museum of Nature, Bird Collection\t\t",
"CMN:Crustacean\ts\tCanadian Museum of Nature, Crustacean Collection\t\t",
"CMN:Fish\ts\tCanadian Museum of Nature, Fish Collection\t\t",
"CMN:GenInvert\ts\tCanadian Museum of Nature, General Invertebrate Collextion\t\t",
"CMN:Herp\ts\tCanadian Museum of Nature, Amphibian and Reptile Collection\t\t",
"CMN:Insect\ts\tCanadian Museum of Nature, Insect Collection\t\t",
"CMN:Mammal\ts\tCanadian Museum of Nature, Mammal Collection\t\t",
"CMN:Mollusc\ts\tCanadian Museum of Nature, Mollusc Collection\t\t",
"CMN:Parasite\ts\tCanadian Museum of Nature, Parasite Collection\t\t",
"CMNAR\ts\tCanadian Museum of Nature, Amphibian and Reptile Collection\t\t\t",
"CMNC\ts\tCanadian Museum of Nature, Neotropical Cerambycidae Collection\t\t\t",
"CMNFI\ts\tCanadian Museum of Nature, Fish Collection\t\t\t",
"CMNH\ts\tThe Cleveland Museum of Natural History\t\t\t",
"CMNH:Birds\ts\tThe Cleveland Museum of Natural History, Birds Collection\t\t",
"CMNS\ts\tMuseum of Natural History, Shanghai\t\t\t",
"CMNZ\ts\tCanterbury Museum\t\t\t",
"CMPH\ts\tColegio de Postgraduados\t\t\t",
"CMPR\ts\tCentre for Medicinal Plants Research\t\t\t",
"CMPUJ\tc\tColeccion de Microorganismos de la Pontificia Universidad Javeriana (Collection Microorganisms of the Pontificia Universidad Javeriana)\tCMDM-PUJ\t\t",
"CMS\ts\tChristian Missionary Society College\t\t\t",
"CMSK\ts\tCity Museum, Sheffield\t\t\t",
"CMSU\ts\tCentral Missouri State University\t\t\t",
"CMU\ts\tChiang Mai University\t\t\t",
"CMUB\ts\tChiang Mai University\t\t\t",
"CMUH\ts\tCentral Mindanao University\t\t\t",
"CMUT\ts\tChiang Mai University\t\t\t",
"CMV\ts\tCentre Marie-Victorin\t\t\t",
"CMW\tc\tForestry and Agricultural Biotechnology Institute, University of Pretoria, Pretoria\t\t\t",
"CMY\ts\tR. G. Kar Medical College, Botany Department\t\t\t",
"CN<FR>\ts\tUniversite de Caen\t\t\t",
"CN<UK>\tc\tWellcome Collection of Bacteria, Burroughs Wellcome Research Laboratories\t\t\t",
"CNARP\ts\tCentre National d' Application de Recherches Pharmaceutiques\t\t\t",
"CNC\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes\tCNCI\t\t",
"CNC:Arachnida\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Arachnida (Mites, Ticks, Spiders)\t\t",
"CNC:Coleoptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Coleoptera (Beetles)\t\t",
"CNC:Diptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Diptera (Flies)\t\t",
"CNC:Hemiptera\t\tCanadian National Collection of Insects, Arachnids, and Nematodes, \t\t",
"CNC:Hymenoptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Hymenoptera (Sawflies, Parasitic Wasps, Ants, Wasps, Bees)\t\t",
"CNC:Lepidoptera\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Lepidoptera (Butterflies, Moths)\t\t",
"CNC:Miscellaneous\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Miscellaneous Insect Orders\t\t",
"CNC:Nematoda\ts\tCanadian National Collection of Insects, Arachnids, and Nematodes, Nematoda (Roundworms)\t\t",
"CNCI\ts\tCanadian National Collection Insects\tCNC\t\t",
"CNCM\tc\tCollection Nationale de Cultures de Microorganismes\t\t\t",
"CNCTC\tc\tCzech National Collection of Type Cultures\t\t\t",
"CNE\ts\tVictoria Jubilee Museum\t\t\t",
"CNEN-LABPC\tc\tLaboratorio de Pocos de Caldas\t\t\t",
"CNF\ts\tCroatian Mycological Society\t\t\t",
"CNH\ts\tCanakkale Onsekiz Mart University\t\t\t",
"CNHM<CRO>\ts\tCroatian Natural History Museum, Botany Department\t\t\t",
"CNHM<USA-OH>\ts\tCincinnati Museum of Natural History\t\t\t",
"CNHM<USA-OH>:ORNITH\ts\tCincinnati Museum of Natural History, Ornithology collection\t\t",
"CNHS\ts\tCroydon Natural History and Scientific Society\t\t\t",
"CNM\ts\tCheltenham Naturalists' Association\t\t\t",
"CNM-CM\tc\tFilamentous fungus collection of the Spanish National Center for Microbiology\t\t\t",
"CNM<ESP>\ts\tCentro Nacional de Microbiologia\t\t\t",
"CNMC\ts\tColorado National Monument\t\t\t",
"CNMS\ts\tColombo National Museum\t\t\t",
"CNMT\ts\tHerbario Centro-Norte-Mato-Grossense\t\t\t",
"CNPO\ts\tEmbrapa Pecuaria Sul\t\t\t",
"CNPS\ts\tCentro Nacional de Pesquisas da Soja\t\t\t",
"CNPSO\tc\tCulture Collection of Diazotrophic and Plant Growth Promoting Bacteria of Embrapa Soja\t\t\t",
"CNR\tsc\tPlant Protection of the National Research Council of Italy\t\t\t",
"CNR<UKR>\ts\tCrimean Natural Reserve\t\t\t",
"CNRO\ts\tCentre National de Recherches Oceanographiques\t\t\t",
"CNRS\ts\tCentre National de la Recherche Scientifique\t\t\t",
"CNRZ\tc\tCentre National de Recherches Zootechniques\t\t\t",
"CNS<AUS>\ts\tAustralian Tropical Herbarium\t\t\t",
"CNSF\ts\tCentre National de Semences Forestieres\t\t\t",
"CNU<CHN>\ts\tCapital Normal University, College of Life Sciences\t\t\t",
"CNU<KOR-TJ>\ts\tChungnam National University\t\t\t",
"CNU<KOR>\ts\tChonbuk National University\t\t\t",
"CNUFC\tsc\tChonnam National University Fungal Collection\t\t\t",
"CNUK\ts\tChungnam National University\t\t\t",
"CNUMH\ts\tChungnam National University, Mycological Herbarium\t\t\t",
"CNWGRGL\tb\tChinese National Waterfowl Germplasm Resources Gene Library\t\t\t",
"CO\ts\tMuseum National d'Histoire Naturelle, Department of Marine Biology\t\t\t",
"COA\ts\tHerbario, Universidad de Cordoba - Jardin Botanico de Cordoba\t\t\t",
"COA<USA-ME>\ts\tCollege of the Atlantic, Museum\t\t\t",
"COA<USA-ME>:Birds\ts\tCollege of the Atlantic, Museum, Birds collection\t\t",
"COA<USA-ME>:Eggs\ts\tCollege of the Atlantic, Museum, Eggs Collection\t\t",
"COA<USA-ME>:Herps\ts\tCollege of the Atlantic, Museum, Herpetology Collection\t\t",
"COA<USA-ME>:Mammal\ts\tCollege of the Atlantic, Museum, Mammals collection\t\t",
"COAD\tc\tColecao Octavio de Almeida Drumond\t\t\t",
"COAH\ts\tHerbario Amazonico Colombiano (Instituto Amazonico de Investigaciones Cientificas SINCHI)\tCOAH<IH>\t\t",
"COCA\ts\tComision Tecnico Consultiva de Coeficientes de Agostadero (COTECOCA)\t\t\t",
"COCAZ\ts\tCoconino National Forest Herbarium\t\t\t",
"COCH\ts\tUniversidad Mayor de San Simon, Departamento de Botanica\t\t\t",
"COCO\ts\tColorado College, Biology Department\t\t\t",
"CODAGEM\ts\tUniversidad Autonoma del Estado de Mexico\t\t\t",
"CODIMAR\tc\tCentro de Investigaciones Biologicas del Noroeste (CIBNOR), Marine Dinoflagellate Collection\t\t\t",
"COFC\ts\tUniversidad de Cordoba, Departamento de Biologia Vegetal\t\t\t",
"COI\ts\tUniversity of Coimbra\t\t\t",
"COL\ts\tUniversidad Nacional de Colombia\t\t\t",
"COLG\ts\tColumbus State University, Biology Department\t\t\t",
"COLO\ts\tUniversity of Colorado\t\t\t",
"COLOM\ts\tColorado State Museum\t\t\t",
"COM\ts\tColombo Museum\t\t\t",
"CON\ts\tBristol, Clifton and West of England Zoological Society's Gardens\t\t\t",
"CONC\ts\tUniversidad de Concepcion, Departamento de Botanica\t\t\t",
"CONN\ts\tUniversity of Connecticut, Department of Ecology and Evolutionary Biology\t\t\t",
"CONV\ts\tConverse College, Biology Department\t\t\t",
"COP<VEN>\ts\tColeccion Ornitologica Phelps\t\t\t",
"COR\ts\tUniversidade Federal de Mato Grosso do Sul, Departamento de Ciencias do Ambiente\t\t\t",
"CORB\ts\tCorchester School\t\t\t",
"CORBIDI\ts\tCentro de Ornitologia y Biodiversidad\t\t\t",
"CORD\ts\tIMBIV-Museo Botanico\t\t\t",
"CORIELL\tcb\tCoriell Institute for Medical Research\t\thttp://ccr.coriell.org/Sections/Search/Search.aspx?q=&spec;\t",
"CORO\ts\tIUTAG, Departamento de Investigacion\t\t\t",
"CORT\ts\tState University of New York College at Cortland, Biological Sciences Department\t\t\t",
"CORU\ts\tUniversidad Veracruzana, Campus Cordoba\t\t\t",
"COV\ts\tHerbert Art Gallery and Museum\t\t\t",
"COVY\ts\tCoventry and District Natural History Society\t\t\t",
"CP\ts\tRoyal Veterinary and Agricultural University, Plant Biology Department\t\t\t",
"CPAC\tc\tCentro de Pesquisas Agropecuarias do Cerrado\t\t\t",
"CPAP<BRA-Belem>\ts\tCentro de Pesquisas Agropecuarias do Tropico Umido\t\t\t",
"CPAP<BRA-Corumba>\ts\tHerbario, Centro de Pesquisas Agropecuarias do Pantanal, EMBRAPA\t\t\t",
"CPATU\ts\tCentro de Pesquisa Agroflorestal da Amazonia Oriental-Embrapa\t\t\t",
"CPB\ts\tNational Institute for the Control of Pharmaceutical and Biological Products\t\t\t",
"CPC\tc\tCulture collection of Pedro Crous\t\t\t",
"CPCC\tc\tCanadian Phycological Culture Centre\tUTCC\t\t",
"CPCC<CHN>\tc\tChina Pharmaceutical Culture Collection\t\t\t",
"CPDC\ts\tCentro de Pesquisas do Cacau\t\t\t",
"CPF\ts\tKwaZulu-Natal Nature Conservation Service\t\t\t",
"CPH\ts\tUniversity of the Pacific, Biological Sciences Department\t\t\t",
"CPHS\tc\tWHO/FAO/OIE Collaborating Centre for Reference and Research on Leptospirosis, Western Pacific Region\t\t\t",
"CPM\ts\tChristoffel Park Museum\t\t\t",
"CPMM\ts\tDr. Alvaro de Castro Provincial Museum\t\t\t",
"CPNP\ts\tCuc Phuong National Park\t\t\t",
"CPPIPP\tc\tCollection of Plant Pathogens\t\t\t",
"CPPLIP\ts\tCentro de Pesquisas Paleontologias Llewellyn Ivor Price\t\t\t",
"CPRC\ts\tCaribbean Primate Research Center Museum\t\t\t",
"CPRR\tc\tLaboratorio de Doenca de Chagas\t\t\t",
"CPS<USA-WA>\ts\tUniversity of Puget Sound, Slater Museum of Natural History\t\t\t",
"CPS<USA-WY/CO>\ts\tWyoming-Colorado Paleontological Society\t\t\t",
"CPSC\ts\tUniversity of Puget Sound\t\t\t",
"CPSU\ts\tCalifornia Polytechnic State University, San Luis Obispo\t\t\t",
"CPU\ts\tChina Pharmaceutical University\t\t\t",
"CPUH\ts\tCareer Point University Hamirpur\t\t\t",
"CPUN\ts\tUniversidad Nacional de Cajamarca, Departamento de Biologia\t\t\t",
"CPUP\ts\tCalifornia Polytechnic University\t\t\t",
"CPZ\tc\tCentro Panamericano de Zoonosis\t\t\t",
"CQBG\ts\tChongqing Botanical Garden\t\t\t",
"CQNM\ts\tChongqing Natural History Museum\t\t\t",
"CR\ts\tMuseo Nacional de Costa Rica\t\t\t",
"CRA-COLMIA<ITA>\tc\tCollezione Nazionale di Microrganismi di interesse Agrario ed Industriale ed Ambientale - COL.MIA\t\t\t",
"CRA-OLI\tb\tCentro di Ricerca per l'Olivicoltura e l'Industria Olearia\t\t\t",
"CRA-PAV<ITA>\tc\tCentro di Ricerca per la Patologia Vegetale\tISPaVe\t\t",
"CRAF\ts\tUniversity of Craiova, Phytopathology Department\t\t\t",
"CRAI\ts\tUniversity of Craiova\t\t\t",
"CRBF\tc\tCollection de genomes d'organismes symbiotiques\t\t\t",
"CRBK\ts\tCranbrook School\t\t\t",
"CRBO\tc\tCentre de Ressource Biologique Oenologique\tIOEB\t\t",
"CRBY\ts\tCrosby Library\t\t\t",
"CRC\tc\tChlamydomonas Resource Center\t\t\t",
"CRCA\ts\tInstituto dos Cereais\t\t\t",
"CRCM\ts\tWashington State University, Charles R. Conner Museum\t\t\t",
"CRCM:Bird\ts\tWashington State University, Charles R. Conner Museum, bird collection\t\t",
"CRCM:Mammal\ts\tWashington State University, Charles R. Conner Museum, Mammal Collection\t\t",
"CRD\ts\tInstituto Politecnico Nacional, Coleccion Cientifica de Fauna Silvestre (Mexico)\t\t\t",
"CRE<CRI>\ts\tCosta Rica Expeditions\t\t\t",
"CRE<USA-CA>\ts\tUniversity of Southern California\t\t\t",
"CREA-AA\tc\t Consiglio per la ricerca in agricoltura e lanalisi delleconomia agraria - Centro di Ricerca Agricoltura e Ambiente\tCRA-CIN\t\t",
"CREG\ts\tInstituto Tecnologico Agropecuario de Jalisco\t\t\t",
"CRGF\tc\tCollection de Recursos Geneticos Fungicos, Instituto de Ecologia y Systematica\t\t\t",
"CRH\ts\tCentre de Recherche en Hydrobiologie\t\t\t",
"CRI\ts\tUniversidade do Extremo Sul Catarinense, Bairro Universitario\t\t\t",
"CRIFC\ts\tCentral Research Institute for Field Crops in Turkey\t\t\t",
"CRK\ts\tUniversity College, Plant Science Department\t\t\t",
"CRL\tc\tCentro de Referencia Para Lactobacilos\t\t\t",
"CRLA\ts\tCrater Lake National Park, Museum and Archives Collections\t\t\t",
"CRMC\ts\tCollege of the Redwoods, Mendocino Coast Campus, Biological Sciences Department\t\t\t",
"CRMM\ts\tObservatoire PELAGIS -UMS 3462- University of la Rochelle-CNRS\t\t\t",
"CRO\ts\tWellington College\t\t\t",
"CRP\ts\tI.N.T.A., E.E.A. Bariloche\t\t\t",
"CRRHA\ts\tCentre Regional de Recherches en Hydrobiologie Appliquee\t\t\t",
"CS<AUS>\tc\tAustralian National Algae Culture Collection, ANACC\tANNAC\t\t",
"CS<FRA>\ts\tMusee des Dinosaures d'Esperaza (Aude)\t\t\t",
"CS<USA-CO>\ts\tColorado State University herbarium\t\t\t",
"CSAEG\tc\tCulture Collection of Phytopathogenic Fungi  at the Colegio Superior Agropecuario del Estado de Guerrero\t\t\t",
"CSAT\ts\tColegio de Postgraduados, Campus Tabasco\t\t\t",
"CSAU\ts\tNational Agrarian University, Southern Branch \"Crimean Agrotechnological University\", Department of Botany, Plant Physiology and Genetics\t\t\t",
"CSB\ts\tSt. John's University/College of Saint Benedict, Biology Department\t\t\t",
"CSC\ts\tColegio del Sagrado Corazon\t\t\t",
"CSC-CLCH\tc\tCentro Substrati Cellulari, Cell Lines Collection and Hybridomas\t\t\t",
"CSCA\ts\tCalifornia State Collection of Arthropods\t\t\t",
"CSCC\tc\tCSIRO Starter Culture Collection\t\t\t",
"CSCCE\ts\tChadron State College, Entomology Collection\tCSCC\t\t",
"CSCCV\ts\tChadron State College, Collection of Vertebrates\t\t\t",
"CSCN\ts\tChadron State College\t\t\t",
"CSCS<PHL>\ts\tCebu State College of Science and Technology, Agricultural Biology Laboratory\t\t\t",
"CSCS<USA-CA>\ts\tCalifornia State University, Turlock\t\t\t",
"CSDS\ts\tDesert Studies Center\t\t\t",
"CSFI\ts\tCentral-South Forestry University\t\t\t",
"CSGP\ts\tServicos Geologicos de Portugal\t\t\t",
"CSGT\ts\tCollegio San Giuseppe\t\t\t",
"CSH\ts\tShanghai Chenshan Botanical Garden\t\t\t",
"CSIR\tc\tCouncil for Scientific and Industrial Research\t\t\t",
"CSIRO\ts\tCommonwealth Science & Industrial Research Organization\t\t\t",
"CSIRO:Ichthyology\ts\tCommonwealth Science & Industrial Research Organization, Australian National Fish Collection\t\t",
"CSJ\ts\tColegio de San Jose, Museo de Historia Natural, Medellin\t\t\t",
"CSLA\ts\tCalifornia State University,Los Angeles\t\t\t",
"CSLB\ts\tCalifornia State University at Long Beach\t\t\t",
"CSMA\tc\tCentro di Studio dei Microorganismi Autotrofi - CNR\t\t\t",
"CSPM\ts\tColegio Lasalle Palma de Mallorca\t\t\t",
"CSPU\ts\tCalifornia State Polytechnic University, Biological Sciences Department\t\t\t",
"CSPUP\ts\tCalifornia State Polytechnic University, Pomona\t\t\t",
"CSR\ts\tCaucasus State Nature Biosphere Reserve\t\t\t",
"CSRS\ts\tCentre Suisse de Recherches Scientifiques en Cote d'Ivoire\t\t\t",
"CSTIU\ts\tFaculty of Science, University of Tokyo\t\t\t",
"CSU<USA-CO>\ts\tColorado State University\tCSUC\t\t",
"CSU<USA-OK>\ts\tUniversity of Central Oklahoma, Biology Department\t\t\t",
"CSUC\ts\tCalifornia State University, Chico, Vertebrate Museum\t\t\t",
"CSUC:Birds\ts\tCalifornia State University, Chico, Vertebrate Museum, Ornithology Collection\t\t",
"CSUCI\ts\tCalifornia State University Channel Islands\t\t\t",
"CSUF\ts\tCalifornia State University, Fresno\t\t\t",
"CSUH\ts\tChelyabinsk State University\t\t\t",
"CSULB\ts\tCalifornia State University, Long Beach\t\t\t",
"CSULB:Mammals\ts\tCalifornia State University, Long Beach, Mammala collection\t\t",
"CSUN\ts\tCalifornia State University, Northridge\t\t\t",
"CSUNIV\ts\tCharleston Southern University\t\t\t",
"CSUR\tc\tCollection de Souches de l'Unite des Rickettsies\t\t\t",
"CSUSB\ts\tCalifornia State University, San Bernardino\t\t\t",
"CSUTC\ts\tColorado State University, Mammalogy Teaching Collection\t\t\t",
"CSVFC\ts\tCaradoc and Severn Valley Field Club\t\t\t",
"CT\ts\tUniversity of Cape Town, Botany Department\t\t\t",
"CTBS\ts\tUniversidade Federal de Santa Catarina\t\t\t",
"CTC\ts\tChongqing Normal University\t\t\t",
"CTES\ts\tInstituto de Botanica del Nordeste\t\t\t",
"CTESN\ts\tUniversidad Nacional del Nordeste\t\t\t",
"CTM<TUN>\tc\tCentre de Biotechnologie de Sfax culture collection\t\t\t",
"CTN\ts\tFree Library and Museum\t\t\t",
"CTNRC\ts\tThai National Reference Collections\t\t\t",
"CTR\ts\tCharles T. Ramsden historical collection\t\t\t",
"CTS\ts\tChongqing Teachers College\t\t\t",
"CTY\ts\tCanterbury Literary and Philosophical Institution\t\t\t",
"CU\tsb\tCornell University\t\t\t",
"CUAC\ts\tClemson University\t\t\t",
"CUBK\ts\tDepartment of Biology, Chonbuk National University\t\t\t",
"CUC\tc\tCepario de la Universidad de Concepcion de Chile\t\t\t",
"CUE\ts\tCairo University\t\t\t",
"CUETM\tc\tCollection Unite Ecotoxicologie Microbienne, INSERM\t\t\t",
"CUFH\ts\tCumhuriyet University, Biology Department\t\t\t",
"CUG\ts\tCollection Universite Poitiers\t\t\t",
"CUH\ts\tCalcutta University, Botany Department\t\t\t",
"CUHK\tsc\tBiology Department, Chinese University of Hong Kong\t\t\t",
"CUI\ts\tCentral College, Iowa\t\t\t",
"CUIC\ts\tCornell University, Invertebrate Collections\t\t\t",
"CUMV\ts\tCornell University Museum of Vertebrates\tCUVC<USA-NY>\t\t",
"CUMV:Amph\ts\tCornell University Museum of Vertebrates, Amphibian Collection\t\t",
"CUMV:Bird\ts\tCornell University Museum of Vertebrates, Bird Collection\t\t",
"CUMV:Fish\ts\tCornell University Museum of Vertebrates, Fish Collection\t\t",
"CUMV:Mamm\ts\tCornell University Museum of Vertebrates, Mammal Collection\t\t",
"CUMV:Rept\ts\tCornell University Museum of Vertebrates, Reptile Collection\t\t",
"CUMZ<CAN>\ts\tCarleton University, Museum of Zoology\t\t\t",
"CUMZ<CMR>\ts\tCameroon University, Museum of Zoology\t\t\t",
"CUMZ<THA>\ts\tChulalongkorn University Museum of Natural History\tCUB\t\t",
"CUMZ<THA>:R\ts\tChulalongkorn University Museum of Natural History, Reptile Collection\t\t",
"CUMZ<UK>\ts\tCambridge University, Museum of Zoology\t\t\t",
"CUNRC\ts\tUniversidad Nacional de Rio Cuarto, Coleccion de Mamiferos (Argentina)\t\t\t",
"CUP\ts\tCornell University, Plant Pathology Herbarium\t\t\t",
"CUP<CHN>\ts\tCatholic University of Peking\t\t\t",
"CUP<CZE>\ts\tCharles University\t\t\t",
"CURLA\ts\tCentro Universitario Regional del Litoral Atlantico\t\t\t",
"CUS\ts\tCusino Wildlife Research Station, Natural Resources Department\t\t\t",
"CUSC\ts\tClemson University, Vertebrate Collections\t\t\t",
"CUVC<COL>\ts\tUniversidad del Valle, Departamento de Biologia\t\t\t",
"CUW\ts\tClark University, Biology Department\t\t\t",
"CUWM\ts\tClark University\t\t\t",
"CUZ\ts\tUniversidad Nacional San Antonio Abad del Cusco\t\t\t",
"CV\ts\tMunicipal Museum of Chungking\t\t\t",
"CVCC<CHN-1>\tc\tCenter for Veterinary Culture Collection\t\t\t",
"CVCC<CHN-2>\tc\tChina Veterinary Culture Collection\t\t\t",
"CVCM\tc\tCentro Venezolano de Colecciones de Microorganismos\t\t\t",
"CVCW\ts\tClinch Valley College, University of Virginia, Biology Department\t\t\t",
"CVM\ts\tCity Museum, Natural History Department\t\t\t",
"CVRD\ts\tReserva Natural da Vale do Rio Doce\t\t\t",
"CVUL\ts\tUniversite Laval, Collection de Vertebres\t\t\t",
"CVULA\ts\tColeccion Vertebrados, Facultad de Ciencias, La Hechicera, Universidad de los Andes\t\t\t",
"CWB\ts\tKharkov State University\t\t\t",
"CWC\ts\tCentral Wyoming College\t\t\t",
"CWDR\ts\tCawdor Castle\t\t\t",
"CWU\ts\tV. N. Karasin National University\t\t\t",
"CY\tc\tCentre des Yersinia\t\t\t",
"CYN\ts\tChipstead Valley Primary School\t\t\t",
"CYP\ts\tMinistry of Agriculture, Natural Resources and Environment, Forestry Department\t\t\t",
"CZ-IICT\ts\tCentro de Zoologia, Instituto de Investigacao Cientifica Tropical\t\t\t",
"CZAA\ts\tCatedra de Zoologia Agricola\t\t\t",
"CZACC\ts\tColeccion Zoologia, Academia de Ciencias de Cuba\t\t\t",
"CZCEN\ts\tColeccion Zoologica de la Facultad de Ciencias Exactas y Naturales\t\t\t",
"CZH\ts\tHanshan Normal University\t\t\t",
"CZIP\ts\tUniversidad de Magallanes, Instituto de la Patagonia (Chile)\t\t\t",
"CZL\ts\tCentro de Zoologia\t\t\t",
"CZRMA\ts\tColeccion Zoologica Regional (Mammalia) del Instituto de Historia Natural y Ecologia\t\t\t",
"CZUAA\ts\tUniversidad Autonoma de Aguascalientes (Mexico)\t\t\t",
"CZUG\ts\tUniversidad de Guadalajara,Centro de Estudios en Zoologia, Entomologia\t\t\t",
"DABUH\ts\tUniversity of Helsinki, Department of Applied Biology\t\t\t",
"DABZ\ts\tDepartment of Agriculture, Zimbabwe\t\t\t",
"DACB\ts\tBangladesh National Herbarium\t\t\t",
"DACL\ts\tLondon Research Centre\t\t\t",
"DACT\tc\tDept. Agricult. Chem. Technol.\t\t\t",
"DAFE\tc\tDepartment of Agriculture, Food and Environment\t\t\t",
"DAFH\ts\tDepartment of Agriculture and Fisheries\t\t\t",
"DAG\ts\tMountain Botanical Garden of the  Dagestan Scientific Centre\t\t\t",
"DAKAR\ts\tUniversite Cheikh Anta Diop, Departement de Biologie Vegetale\t\t\t",
"DAL\ts\tDalhousie University, Biology Department\t\t\t",
"DANV\ts\tUmweltamt Darmstadt\t\t\t",
"DAO\ts\tAgriculture and Agri-Food Canada\t\t\t",
"DAOM\tsc\tNational Mycological Herbarium, Agriculture and Agri-Food Canada\tCCFC,DAOMC\t\t",
"DAR\tc\tPlant Pathology Herbarium\t\t\t",
"DARI\ts\tInsect Collection, New South Wales Department of Agriculture\t\t\t",
"DAS\ts\tAgriculture and Agri-Food Canada (Saskatoon Research Centre)\t\t\t",
"DASF\ts\tDepartment of Agriculture, Stock and Fisheries\t\t\t",
"DAU\ts\tUniversity of Daugavpils\t\t\t",
"DAV\ts\tUniversity of California, Plant Biology\t\t\t",
"DAVFP\ts\tPacific Forestry Centre, Canadian Forest Service\t\t\t",
"DAVH\ts\tUniversity of California, Environmental Horticulture Department\t\t\t",
"DAWES\ts\tThe Dawes Arboretum\t\t\t",
"DB\tcb\tDominik Begerow culture collection\t\t\t",
"DBAI\ts\tInstituto de Ciencias Biologicas\t\t\t",
"DBAU\ts\tUniversidade Santa Ursula\t\t\t",
"DBC\ts\tUniversity College, Botany Department\t\t\t",
"DBCUCH\ts\tUniversidad de Chile, Departamento de Biologia Celular y Genetica\t\t\t",
"DBEV\ts\tUniversity of Antananarivo\t\t\t",
"DBFFEUCS\ts\tDepartamento de Biologia de la Faculdad de Filosofia y Educacion de la Universidad de Chile\t\t\t",
"DBG\ts\tSam Mitchel Herbarium of Fungi, Denver Botanic Gardens\t\t\t",
"DBKKU1\tc\tDepartment of Biology, Faculty of Science\t\t\t",
"DBM\tc\tDepartment of Biochemistry and Microbiology\t\t\t",
"DBMU\tc\tBoonchird lab, Department of Biotechnology, Mahidol University\t\t\t",
"DBMU2\tc\tPanbangred lab, Department of Biotechnology, Mahidol University\t\t\t",
"DBN\ts\tNational Botanic Gardens\t\t\t",
"DBS\tc\tDepartment of Biological Culture Collection\t\t\t",
"DBSE\ts\tUniversidade Federale Sergipe\t\t\t",
"DBSNU\ts\tDepartment of Biology, Shaanxi Normal University\t\t\t",
"DBUA\tc\tZoological Collection of the Biology Department, University of the Azores\t\t\t",
"DBUM-IPT\tc\tDepartment of Biochemistry, Faculty of Medicine, University of Malaya\t\t\t",
"DBUP\tc\tAlgal Culture Collection\t\t\t",
"DBV\tc\tDivision of Standardisation\t\t\t",
"DBVPG\tc\tIndustrial Yeasts Collection\t\t\t",
"DBY\ts\tCity of Derby Museum and Art Gallery\t\t\t",
"DCBU\ts\tUniversidade Federal de Sao Carlos\t\t\t",
"DCCBC\tcb\tDunaliella Culture Collection at Brooklyn College\t\t\t",
"DCDS\ts\tDipartimento di Coltivazione e Difesa delle Specie Legnose dell'Universita, Sezione Entomologia Agraria\t\t\t",
"DCH\ts\tDavidson College, Biology Department\t\t\t",
"DCMB\ts\tUniversidade do Amazonas\t\t\t",
"DCMD\ts\tDerby City Museum and Art Gallery\t\t\t",
"DCMP\ts\tUniversidade Federal do Parana\t\t\t",
"DCN-UNRC\ts\tDepartamento de Ciencias Naturales, Universidad Nacional de Rio Cuarto\t\t\t",
"DCPC\ts\tDominicusCirillus[deceased]\t\t\t",
"DCR\ts\tDoncaster Museum and Art Gallery\t\t\t",
"DD\ts\tForest Research Institute, Indian Council of Forestry Research and Education, Systematic Botany Discipline\t\t\t",
"DDFF\ts\tDepartamento de Defensa Fitossanitarista\t\t\t",
"DDMS\ts\tFundacao Universidade Federal da Grande Dourados\t\t\t",
"DE\ts\tDebrecen University, Botany Department\t\t\t",
"DE-CSIRO\tc\tCSIRO Insect Pathogen Culture Collection\t\t\t",
"DEBU\ts\tOntario Insect Collection, University of Guelph\tUOG:DEBU\t\t",
"DECA\ts\tAgnes Scott College, Biology Department\t\t\t",
"DECV\ts\tDouglas Ecological Consultants\t\t\t",
"DEE\ts\tMcManus Galleries, Natural History Department\t\t\t",
"DEES\ts\tUniversidade de Sao Paulo, Piracicaba\t\t\t",
"DEFS\ts\tUniversidade de Sao Paulo\t\t\t",
"DEI\ts\tSenckenberg Deutsches Entomologisches Institut\t\t\t",
"DEIB\ts\tDeutsches Entomologisches Institut\t\t\t",
"DEK\ts\tNorthern Illinois University, Biological Sciences Department\t\t\t",
"DELS\ts\tUniversity of Delaware, Plant Science Department\t\t\t",
"DELTA\ts\tDelta Waterfowl and Wetlands Research Station\t\t\t",
"DEN\ts\tDenison University, Biology Department\t\t\t",
"DENA\ts\tWatt Institute\t\t\t",
"DEND\ts\tUniversity of Zagreb\t\t\t",
"DENF\ts\tGrand Mesa-Uncompahgre-Gunnison Natonal Forests\t\t\t",
"DERM\ts\tIntermountain Experiment Station\t\t\t",
"DES\tsb\tDesert Botanical Garden, Research Department\t\t\t",
"DEV\ts\tSt. Joseph's College\t\t\t",
"DEVA\ts\tDeath Valley National Park\t\t\t",
"DEWV\ts\tDavis and Elkins College, Biology and Environmental Science Department\t\t\t",
"DEZA\ts\tDipartimento di Entomologia e Zoologia Agraria dell'Universita\t\t\t",
"DEZC\ts\tDipartimento di Entomologia e Zoologia Applicate all'Ambiente \"Carlo Vidano\"\t\t\t",
"DFCZ\ts\tForest Research Institute, Malawi\t\t\t",
"DFD\ts\tDartford Borough Museum\t\t\t",
"DFEC<CHN>\ts\tDesert Forestry Experimental Centre\t\t\t",
"DFEC<USA-NY>\ts\tDepartment of Forestry and Environmental Science, State University of New York\t\t\t",
"DFF\tc\tForest Pathology Culture Collection, Pacific Forest Research Centre\t\t\t",
"DFLC\ts\tEscola Superior de Agricultura\t\t\t",
"DFP\tc\tDFP Culture Collection\t\t\t",
"DFRU\ts\tUniversity of New Brunswick\t\t\t",
"DFS\ts\tDumfries and Galloway Natural History and Antiquarian Society\t\t\t",
"DFSM\ts\tDumfries Museum\t\t\t",
"DFV\ts\tDivision of Fisheres\t\t\t",
"DGBU\ts\tDepartment of Geology, Pusan National University\t\t\t",
"DGN\ts\tDarlington Museum\t\t\t",
"DGR\tb\tDivision of Genomic Resources, University of New Mexico\t\t\t",
"DGR:Bird\ts\tDivision of Genomic Resources, University of New Mexico, bird tissue collection\t\t",
"DGR:Ento\ts\tDivision of Genomic Resources, University of New Mexico, entomology tissue collection\t\t",
"DGR:Fish\ts\tDivision of Genomic Resources, University of New Mexico, fish tissue collection\t\t",
"DGR:Herp\ts\tDivision of Genomic Resources, University of New Mexico, herpetology tissue collection\t\t",
"DGR:Mamm\ts\tDivision of Genomic Resources, University of New Mexico, mammal tissue collection\t\t",
"DGS\ts\tThe Manx Museum\t\t\t",
"DGU\ts\tDaegu University\t\t\t",
"DGUB\tc\tDepartment of Genetics, University of Bratislava\t\t\t",
"DH\ts\tHobart and William Smith Colleges, Biology Department\t\t\t",
"DHISUB\ts\tDepartment of Hydrobiology and Ichthyology, Sofia Univiversity\t\t\t",
"DHL\ts\tUniversity of Louisville, Biology Department\t\t\t",
"DHM\ts\tUniversity of Durham, Botany Department\t\t\t",
"DHMB\ts\tDepartment of Harbours and Marine\t\t\t",
"DHNS\ts\tDunbartonshire Natural History Society\t\t\t",
"DI\ts\tUniversite de Bourgogne, Laboratoire de Phytobiologie Cellulaire\t\t\t",
"DIA\ts\tMuseu do Dundo\t\t\t",
"DIAM\ts\tUniversidade Federal dos Vales do Jequitinhonha e Mucuri\t\t\t",
"DIN\ts\tMuseum National d'Histoire Naturelle, Laboratoire Maritime\t\t\t",
"DINH\ts\tDelta Institute of Natural History\t\t\t",
"DINO\ts\tDinosaur National Monument\t\t\t",
"DIS\ts\tDinamation International Society\t\t\t",
"DISCA\ts\tEstacion Biologica de Rancho Grande, Ministerio del Ambiente y Recursos Naturales Renovables\t\t\t",
"DISKO\ts\tDanish Arctic Station\t\t\t",
"DiSTA<ITA>\ts\tPhytoplasma Collection University of Bologna\tDiSTA\t\t",
"DIX\ts\tDixie College, Natural History Museum\t\t\t",
"DKG\ts\tJuniper Hall Field Centre\t\t\t",
"DLF\ts\tStetson University, Biology Department\t\t\t",
"DLU\ts\tDa Lat University\t\t\t",
"DLY\ts\tDudley and Midland Geological and Scientific Society and Field Club\t\t\t",
"DM<NZ>\ts\tDominion Museum\t\t\t",
"DM<USA-UT>\ts\tThe Dinosaur Museum\t\t\t",
"DMB\ts\tDurban Museum\t\t\t",
"DMBC\ts\tDominick Moth and Butterfly Collection\t\t\t",
"DMBUK\tc\tDepartment of Microbiology, Univeristy of Kelaniya\t\t\t",
"DMCCUS\tc\tSchool of Biological Sciences Culture Collection\t\t\t",
"DMCU\tc\tMicrobiology Department, Faculty of Science\t\t\t",
"DMDC\ts\tDouala Museum\t\t\t",
"DMFS\ts\tCrichton Royal Institution Museum\t\t\t",
"DMHN\ts\tThe University of Newcastle\t\t\t",
"DMIV\tc\tDepartment of Microbiology and Immunology\t\t\t",
"DMKKU2\tc\tDepartment of Microbiology, Faculty of Medical Science\t\t\t",
"DMKU\tc\tDepartment of Microbiology Kasetsart University\t\t\t",
"DMMU3\tc\tDepartment of Microbiology, Faculty of Medicine Siriraj Hospital\tDMMU3\t\t",
"DMMZ\tc\tDepartment of Medical Microbiology, University of Zurich\t\t\t",
"DMNH<USA-DE>\ts\tDelaware Museum of Natural History\t\t\t",
"DMNH<USA-DE>:Bird\ts\tDelaware Museum of Natural History, Birds collection\t\t",
"DMNH<USA-OH>\ts\tDayton Museum of Natural History, Biology Department\t\t\t",
"DMNS\ts\tDenver Museum of Nature and Science\tDMNH<USA-CO>,DNHC\t\t",
"DMNS:Bird\ts\tDenver Museum of Nature and Science, Ornithology Collections\t\t",
"DMNS:Mamm\ts\tDenver Museum of Nature and Science, Mammology Collection\thttps://arctos.database.museum/guid/DMNS:Mamm:",
"DMNS:Para\ts\tDenver Museum of Nature and Science, Parasite collection\thttps://arctos.database.museum/guid/DMNS:Para:",
"DMPMC\tc\tDepartment of Microbiology, University of Western Australia\t\t\t",
"DMSA\ts\tDurban Museum\tDMSA\t\t",
"DMSC\ts\tMedicinal Plants Research Institute, Department of Medical Sciences\t\t\t",
"DMSP\ts\tDavis Mountains State Park\t\t\t",
"DMSRDE\tc\tDMSRDE Culture Collection\t\t\t",
"DMST\tc\tCulture Collection for Medical Microorganism, Department of Medical Sciences\t\t\t",
"DMTH\ts\tBritannia Royal Naval College\t\t\t",
"DMU\ts\tMithila University, Botany Department\t\t\t",
"DMUIJ\tc\tDepartment of Microbiology, Jakarta Pusat\t\t\t",
"DMUP\tc\tMicrobiology and Biophysics Charles University\t\t\t",
"DMUR\tc\tDepartment of Mycology\t\t\t",
"DMVB\tc\tDepartment of Microbiology, Veterinary Branch of National Strain Collection\t\t\t",
"DNA\ts\tDepartment of Land Resource Management\tNT\t\t",
"DNAP\ts\tDepartment of Primary Industry and Fisheries\t\t\t",
"DNATAX\tb\tDNA-TAX\t\t\t",
"DNHM<CHN>\ts\tDalian Museum of Natural History\t\t\t",
"DNHM<USA-UT>\ts\tDinosaur Natural History Museum\t\t\t",
"DNMNH\ts\tDitsong National Museum of Natural History\tTM<ZAF>,TMSA<ZAF>\t\t",
"DNMNH:AC\ts\tDitsong National Museum of Natural History, Archaeozoology Collection\t\t",
"DNMNH:BC\ts\tDitsong National Museum of Natural History, Bird Collection\t\t",
"DNMNH:EC\ts\tDitsong National Museum of Natural History, Entomology Collection\t\t",
"DNMNH:HC\ts\tDitsong National Museum of Natural History, Herpetology Collection\t\t",
"DNMNH:IC\ts\tDitsong National Museum of Natural History, Invertebrate Collection\t\t",
"DNMNH:MC\ts\tDitsong National Museum of Natural History, Mammal Collection\t\t",
"DNPM\ts\tSetor de Paleontologia do Departamento Nacional de Producao Mineral\t\t\t",
"DNS\ts\tDundee Naturalists' Society\t\t\t",
"DNZ\ts\tDonetsk Botanical Garden of the National Academy of Sciences of Ukraine\t\t\t",
"DO\ts\tSociete d'Agriculture Sciences et Arts\t\t\t",
"DOA\tc\tDepartment Of Agriculture, Thailand\t\t\t",
"DOMO\ts\tCollegio Mellerio Rosmini\t\t\t",
"DOR\ts\tDorset County Museum\t\t\t",
"DORC\ts\tDorset County Museum\t\t\t",
"DORCM\ts\tDorset Royal County Museum\t\t\t",
"DORT\ts\tBotanischer Garten Rombergpark, Stadt Dortmund\t\t\t",
"DOV\ts\tDelaware State University, Department of Agriculture and Natural Resources\t\t\t",
"DPBA\ts\tDepartamento de Patologia Vegetal\t\t\t",
"DPC\tc\tDairy Products Research Center Culture Collection Teagasc\t\t\t",
"DPIC\ts\tBelo Horizonte, Instituto de Ciencias Biologicas\t\t\t",
"DPIH\ts\tDepartment of Primary Industry (formerly DAHT)\t\t\t",
"DPIQM\ts\tDepartment of Primary Industries\tQPIM\t\t",
"DPMWA\ts\tDorthy Page Museum of Wasilla\t\t\t",
"DPNC\ts\tDenison Pequotsepos Nature Center\t\t\t",
"DPPC\ts\tDepartment of Agriculture, Taiwan\t\t\t",
"DPU\ts\tDePauw University, Botany and Bacteriology Department\t\t\t",
"DPUA\tc\tDepartamento de Patologia/ICB\t\t\t",
"DPUH\ts\tUniversity of Duhok\t\t\t",
"DPUP\ts\tUniversidade Federal de Maringa\t\t\t",
"DQTC\ts\tDaqing Teachers College, Biology Department\t\t\t",
"DR\ts\tTechnische Universitaet Dresden\t\t\t",
"DRK\ts\tDrake University\t\t\t",
"DS\ts\tCalifornia Academy of Sciences, Botany Department\t\t\t",
"DSC<USA-MS>\ts\tDelta State University, Biological Sciences Department\t\t\t",
"DSC<USA-NY>\tc\tDicty Stock Center\t\t\t",
"DSEC\ts\tUniversidade Federal da Paraiba\t\t\t",
"DSIR\ts\tDepartment of Scientific and Industrial Research\t\t\t",
"DSM\tc\tDeutsche Sammlung von Mikroorganismen und Zellkulturen GmbH\tDSMZ\thttps://www.dsmz.de/collection/catalogue/details/culture/DSM-\t",
"DSM<TZA>\ts\tUniversity of Dar es Salaam, Botany Department\t\t\t",
"DSMZ\tc\tDeutsche Sammlung von Mikroorganismen und Zellkulture\t\thttps://www.dsmz.de/catalogues/details/culture/PV-\t",
"DSP\ts\tFitzsimon's Snake Park\t\t\t",
"DSSC<USA-CA>\tb\tDrosophila Species Stock Center\t\t\t",
"DSU\ts\tDnipropetrovsk National University, Department of Geobotany, Soil, and Ecology\t\t\t",
"DSY\ts\tDewsbury Museum\t\t\t",
"DTE\ts\tCentro de Investigaciones Cientificas y Transferencia de Tecnologia a la Produccion (CICyTTP-CONICET)\t\t\t",
"DTIC\ts\tDepartamento Parasitologia\t\t\t",
"DTN\ts\tDarlington and Teesdale Naturalists' Field Club\t\t\t",
"DTO\tc\tDepartment of Applied and Industrial Mycology\t\t\t",
"DU\ts\tDuke University Vertebrate Collection\t\t\t",
"DUB\ts\tNational Botanic Gardens\t\t\t",
"DUBN\ts\tDublin Naturalists' Field Club\t\t\t",
"DUE\ts\tUniversity of Dundee\t\t\t",
"DUF\ts\tUniversity of Dicle, Biological Department, Botany\t\t\t",
"DUGAND\ts\tUniversidad del Atlantico\t\t\t",
"DUH\ts\tUniversity of Delhi, Botany Department\t\t\t",
"DUIS\ts\tUniversitaet Duisburg, Fachbereich 6, Botanik\t\t\t",
"DUKE\ts\tDuke University, Biology Department\t\t\t",
"DUL\ts\tUniversity of Minnesota, Biology Department\t\t\t",
"DUM<IND>\tc\tDelhi University Mycological Herbarium\t\t\t",
"DUM<TUR>\ts\tZooligical Museum of Science and Art Faculty\t\t\t",
"DUOF\ts\tDuzce University\t\t\t",
"DUP\ts\tDumlupinar University\t\t\t",
"DUR\ts\tSoutheastern Oklahoma State University, Biological Sciences Department\t\t\t",
"DUSS\ts\tUniversitaet Duesseldorf\t\t\t",
"DVBID\tc\tDivision Vector-Borne Infectious Diseases\t\t\t",
"DVCC\ts\tDiablo Valley College\t\t\t",
"DVM\ts\tDiablo Valley College, Biology Department\t\t\t",
"DVNM\ts\tDeath Valley National Monument\t\t\t",
"DVPR\ts\tUniversidade Tecnologica Federal do Parana\t\t\t",
"DVR\ts\tDover Corporation Museum\t\t\t",
"DVZUT\ts\tDepartment of Vertebrate Zoology\t\t\t",
"DWC\ts\tWest Chester University, Biology Department\t\t\t",
"DWN\ts\tDarwen Library\t\t\t",
"DWP\ts\tDisney Wilderness Preserve/The Nature Conservancy\t\t\t",
"DWT\tc\tWood Technology and Forest Research Division\t\t\t",
"DWU\ts\tDakota Wesleyan University, Biology Department\t\t\t",
"DZCU\ts\tCalcutta University\t\t\t",
"DZIB\ts\tUniversidade Estadual de Campinas\t\t\t",
"DZKU\ts\tDepartment of Biology, Shaanxi Normal University\t\t\t",
"DZMU\ts\tDepartment of Zoology, Monash University\t\t\t",
"DZS\ts\tDevizes Museum\t\t\t",
"DZSASP\ts\tDepartamento de Zoologia, Secretaria da Agricultura\t\t\t",
"DZSJRP\ts\tDepartmento de Zoologia e Botanica, Universidade Estadual Paulista\t\t\t",
"DZUC\ts\tDepartamento de Zoologia da Universidade de Coimbra\t\t\t",
"DZUFRGS\ts\tDepartamento de Zoologia da Universidade Federal do Rio Grande do Sul\t\t\t",
"DZUH\ts\tDepartamento de Zoologia, Universidad de Havana\t\t\t",
"DZUL\ts\tDepartamento de Zoologia, Universidad de La Laguna\t\t\t",
"DZUP\ts\tUniversidade Federal do Parana, Museu de Entomologia Pe. Jesus Santiago Moure\t\t\t",
"DZVMLP\ts\tDepartamento Cientifico de Zoologia de Vertebrados\t\t\t",
"DZVU\ts\tUniversidad de Uruguay\t\t\t",
"E\tsb\tRoyal Botanic Garden Edinburgh\t\thttp://data.rbge.org.uk/herb/E\t",
"EA\ts\tNational Museums of Kenya\t\t\t",
"EAA\ts\tEstonian Agricultural University\t\t\t",
"EAC\ts\tUniversidade Federal do Ceara, Departamento de Biologia\t\t\t",
"EAD\ts\tEnvironment Agency- Abu Dhabi\t\t\t",
"EAFM\ts\tInstituto Federal de Educacao, Ciencia e Tecnologia do Amazonas\t\t\t",
"EALA\ts\tJardin Botanique d'Eala\t\t\t",
"EAN\ts\tUniversidade Federal da Paraiba, Campus III - CCA, Departamento de Fitotecnia\t\t\t",
"EAP\ts\tEscuela Agricola Panamericana\t\t\t",
"EAPZ\ts\tEscuela Agricola Panamericana\t\t\t",
"EAR\ts\tEarlham College, Biology Department\t\t\t",
"EATRO\tc\tUganda Trypanosomiasis Research Organization\t\t\t",
"EBA\ts\tEdinburgh Academy Field Centre\t\t\t",
"EBCC\ts\tUniversidad Nacional Autonoma de Mexico, Estacion de Biologia \"Chamela\"\t\t\t",
"EBD\ts\tEstacion Biologica de Donana\t\t\t",
"EBE\ts\tEastbourne Museum\t\t\t",
"EBF\ts\tHubei Forestry Institute\t\t\t",
"EBH\ts\tBotanical Society of Edinburgh\t\t\t",
"EBL\ts\tEcosystem Research and Development Bureau\t\t\t",
"EBMC\ts\tUniversidad de Chile\t\t\t",
"EBMTV\ts\tEstacion de Biologia Marina del Instituto Tecnologico de Veracruz\t\t\t",
"EBNHS\ts\tEdinburgh Natural History Society\t\t\t",
"EBRG\ts\tMuseo de la Estacion Biologia de Rancho Grande\t\t\t",
"EBUAP\ts\tLaboratorio de Herpetologia, Escuela de Biologia, Benemerita Universidad Autonoma de Puebla\t\t\t",
"EBUM\ts\tUniversidad Michoacana de San Nicolas de Hidalgo\t\t\t",
"EBV\ts\tLaboratoire de Biologie Generale et de Botanique\t\t\t",
"ECACC\tc\tEuropean Collection of Authenticated Cell Cultures\t\t\t",
"ECENT\ts\tEast Central University\t\t\t",
"ECH\ts\tElmira College\t\t\t",
"ECK\ts\tBuffalo State College\t\t\t",
"ECM\ts\tHubei College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t\t",
"ECNB\ts\tEscuela Nacional Ciencias\t\t\t",
"ECOCHM\ts\tColeccion de Mamiferos del Museo de Zoologia-ECOSUR\t\t\t",
"ECOL\ts\tCollection du Laborataire d'Ecologie\t\t\t",
"ECOMAR<FRA>\ts\tECOMAR lab University of Reunion\t\t\t",
"ECON\ts\tHarvard University\t\t\t",
"ECOSCM\ts\tColeccion Mastozoologica de El Colegio de la Frontera Sur, Unidad San  Cristobal\tECO-SC-M\t\t",
"ECOSUR\ts\tEl Colegio de la Frontera Sur (Mexico)\t\t\t",
"ECOT\ts\tEcoTarium Worcester Historical Museum\t\t\t",
"ECRC\tc\tE. coli Reference Center\t\t\t",
"ECSC\ts\tEast Central University, Biology Department\t\t\t",
"ECSFI\ts\tEast China Sea Fisheries Institute\t\t\t",
"ECT\ts\tEmbrapa\t\t\t",
"ECU\ts\tEdith Cowan University\t\t\t",
"ECUAMZ\ts\tUniversidad Estatal Amazonica\t\t\t",
"ECUH\ts\tEast Carolina University\t\t\t",
"ECWP\ts\tEmirates Centre for Wildlife Propagation\t\t\t",
"EDC\ts\tHubei Institute for Drug Control\t\t\t",
"EDH\ts\tPlinian Society\t\t\t",
"EDNC\ts\tRaleigh, North Carolina Department of Agriculture\t\t\t",
"EDTU\ts\tTrakya Universitesi\t\t\t",
"EEBP\ts\tEstacao Experimental de Biologia e Piscicultura de Pirassununga\t\t\t",
"EELM\ts\tEstacion Experimental Agricola de la Molina\t\t\t",
"EERU\ts\tEconomic Entomology  Research Unit\t\t\t",
"EFC\ts\tEscola de Florestas\t\t\t",
"EFCC\ts\tEpping Forest Conservation Centre\t\t\t",
"EFH\ts\tForestry Commission\t\t\t",
"EFM\ts\tEpping Forest Museum, Corporation of London\t\t\t",
"EFWM\ts\tDepartment of Entomology\t\t\t",
"EGE\tsc\tEge University\t\t\t",
"EGE-MACC\tc\tEge - Microalgae Culture Collection\t\t\t",
"EGH\ts\tUniversity of Edinburgh\t\t\t",
"EGHB\ts\tUniversity of Edinburgh\t\t\t",
"EGHF\ts\tUniversity of Edinburgh, Forestry and Natural Resources Department\t\t\t",
"EGNP\ts\tHomestead, Everglades National Park\t\t\t",
"EGR\ts\tEszterhazy Karoly College, Botany Department\t\t\t",
"EHCV\ts\tEmory and Henry College, Biology Department\t\t\t",
"EHH\ts\tUniversite d'Etat d'Haiti\t\t\t",
"EI\ts\tUniversidade Federal Rural do Rio de Janeiro\t\t\t",
"EIDM\ts\tEID Mediterranee\t\t\t",
"EIF\ts\tUniversidad de Chile, Departamento de Silvicultura\t\t\t",
"EIHU\ts\tEntomological Institute, Hokkaido University\tSEHU\t\t",
"EINS\ts\tEcuadorian Institute of Natural Sciences\t\t\t",
"EISC\ts\tShaanxi Agricultural University, Entomological Institute\t\t\t",
"EIU\ts\tEastern Illinois University, Biological Sciences Department\t\t\t",
"EJ\ts\t?Ein Yabrud collection catalogue entries at The Hebrew University\t\t\t",
"EKU\ts\tEastern Kentucky University\t\t\t",
"EKY\ts\tEastern Kentucky University, Biological Sciences Department\t\t\t",
"ELCAK\ts\tEntomological Laboratory, College of Agriculture\t\t\t",
"ELH\ts\tBureau of Land Management, Eagle Lake Field Office\t\t\t",
"ELM\ts\tEast London Museum\t\t\t",
"ELMF\ts\tAugusta, Maine Forest Service\t\t\t",
"ELN\ts\tElgin Museum\t\t\t",
"ELRG\ts\tCentral Washington University, Biological Sciences Department\t\t\t",
"ELS\ts\tAldenham School, Biology Department\t\t\t",
"ELVE\ts\tNational Station for Plant Breeding\t\t\t",
"EM\ts\tUniversidade Federal de Ouro Preto\t\t\t",
"EMA\ts\tSichuan School of Chinese Materia Medica\t\t\t",
"EMAG\ts\tErnst-Moritz Arndt Collection, Museum der Stadt Greifswald\t\t\t",
"EMAU\ts\tErnst-Moritz-Arndt-Universitat Greifswald\t\t\t",
"EMBT\ts\tDepartment of Agriculture, Thailand\t\t\t",
"EMC\ts\tEastern Michigan University, Biology Department\t\t\t",
"EMCC\tc\tEgypt Microbial Culture Collection\t\t\t",
"EMEC\ts\tEssig Museum of Entomology, University of California at Berkeley\t\thttps://essigdb.berkeley.edu/cgi/eme_query?table=eme&bnhm_id=EMEC209800&one=T\t",
"EMEC:EMEC\ts\tEssig Museum of Entomology, University of California at Berkeley, Essig Museum of Entomology\thttps://essigdb.berkeley.edu/cgi/eme_query?table=eme&bnhm_id=EMEC71410&one=T",
"EMEC:UCIS\ts\tEssig Museum of Entomology, University of California at Berkeley, University of California Insect Survey\thttps://essigdb.berkeley.edu/cgi/eme_query?table=eme&bnhm_id=UCIS133938&one=T",
"EMET\ts\tFaculty of Agriculture, Entomology Museum\t\t\t",
"EMIT\ts\tEntomological Museum of Isparta, Turkey\t\t\t",
"EMMA\ts\tUniversidad Politecnica de Madrid, Unidad Docente Botanica, Departamento Silvopascicultura\t\t\t",
"EMNH\ts\tThe Everhart Museum of Natural History, Science & Art\t\t\t",
"EMPARN\tc\tEmpresa de Pesquisa Agropecuaria do Rio Grande do Norte\t\t\t",
"EMU\ts\tEastern Michigan University, T. L. Hankinson Vertebrate Museum\t\t\t",
"EMUS\ts\tUtah State University\t\t\t",
"ENAG\ts\tUniversidad Nacional Agraria, Departamento de Ciencias Basicas\t\t\t",
"ENCB-IPN\tc\tColeccion de cultivos de la Escuela Nacional de Ciencias Biologicas\t\t\t",
"ENCB<MEX-Ensenada>\ts\tUniversidad de Autonoma de Baja California\t\t\t",
"ENCB<MEX-Mexico City>\ts\tInstituto Politecnico Nacional\t\t\t",
"ENG\ts\tRoyal Holloway College, University of London, Botany Department\t\t\t",
"ENIH\ts\tNational Institute of Health\t\t\t",
"ENLC\ts\tEastern Nevada Landscape Coalition\t\t\t",
"ENMU\ts\tEastern New Mexico University, Natural History Museum\t\t\t",
"ENP\ts\tEverglades National Park\t\t\t",
"ENS\ts\tHubei College for Nationalities, Forestry Department\t\t\t",
"ENSA\ts\tEcole Nationale Superieure Agronomique\t\t\t",
"ENSJ\ts\tEscuela Normal Superior de Jalisco\t\t\t",
"ENT\ts\tHerbarium, Ministry of Natural Resources, Uganda\t\t\t",
"ENTOMOFOR\ts\tCollection of necrophagous Fauna of the Forensic Entomology Laboratory (Basque Country University)\t\t\t",
"EONJ\ts\tUpsala College, Biology Department\t\t\t",
"EOSC\ts\tEastern Oregon University, Biology Department\t\t\t",
"EOSCVM\ts\tEastern Oregon State College, Vertebrate Museum\t\t\t",
"EOSTS\ts\tOfficial Seed Testing Station, Agricultural Scientific Services, Department of Agriculture and Fisheries for Scotland\t\t\t",
"EPAL\ts\tEntomology Collection, Punjab Agricultural University\t\t\t",
"EPF\ts\tEspace Pierres Folles\t\t\t",
"EPHR\ts\tSnow College, Biology Department\t\t\t",
"EPM\ts\tEpsom College Museum\t\t\t",
"EPN\ts\tEscuela Polytecnica Nacional\tEPNC\t\t",
"EPRL\ts\tUniversity of Puerto Rico\t\t\t",
"EPU\ts\tCentre de Formation et de Recherche en Conservation Forestiere\t\t\t",
"ER\ts\tUniversitaet Erlangen-Nuernberg, Geobotanik\t\t\t",
"ERA\ts\tUniversidad Nacional de Entre Rios, Botanica Sistematica\t\t\t",
"ERAEP\tc\tRadiation Ecology Section, Biological Science Division, Office of Atomic Energy for Peace\t\t\t",
"ERCB\ts\tYerevan State University, Botany Department\t\t\t",
"ERCH\ts\tErciyes University\t\t\t",
"ERCULE\tc\tEuropean Rumen Ciliate Culture Collection, Rowett Research Institute\t\t\t",
"ERD\ts\tEnrique Rubio Dominguez Herbarium\t\t\t",
"ERE\ts\tInstitute of Botany of the National Academy of Sciences of Armenia, Department of Plant Taxonomy and Geography\t\t\t",
"EREM\ts\tInstitute of Botany of the National Academy of Sciences of Armenia, Mycology Department\t\t\t",
"ERH\ts\tBorough of Erith Museum\t\t\t",
"ERHM\ts\tYerevan State University, Botany Department\t\t\t",
"ERSAF<ITA>\ts\tRegional Agency for Agriculture and Forestry Services\t\t\t",
"ERZ\ts\tFuerstin-Eugenie-Institut fuer Arzneipflanzenforschung\t\t\t",
"ESA\ts\tUniversidade de Sao Paulo, Departamento de Botanica\t\t\t",
"ESAL\ts\tUniversidade Federal de Lavras, Departamento de Biologia\t\t\t",
"ESAP\tc\tInstituto Zimotecnico-Z\t\t\t",
"ESEC\ts\tEntomological Society of Egypt\t\t\t",
"ESK\ts\tSeker Enstituesue\t\t\t",
"ESN\ts\tEcole des Sciences de Niamey\t\t\t",
"ESNHS\ts\tScottish Natural History Society\t\t\t",
"ESRC\ts\tNova Scotia Department Natural Resources\t\t\t",
"ESRN\ts\tEscola Superior de Agricultura\t\t\t",
"ESS\ts\tUniversitaet Essen\t\t\t",
"ESSE\ts\tAnadolu University\t\t\t",
"ESUG\ts\tUniversity of Guam\tUGG,UGM\t\t",
"ESUW\ts\tUniversity of Wyoming Insect Museum and Gallery\t\t\t",
"ET\ts\tEast Texas State University\t\t\t",
"ETH<CHE>\tc\tKultursammlungen der Eidgenosische Technische Hochschule\t\t\t",
"ETH<ETH>\ts\tAddis Ababa University\t\t\t",
"ETHZ\ts\tEidgenoessische Technische Hochschule-Zentrum\t\t\t",
"ETL\ts\tLake Forest College\t\t\t",
"ETNH\ts\tJarvis Christian College\t\t\t",
"ETON\ts\tEton College Museum; Hincks Herbarium\t\t\t",
"ETST\ts\tTexas A&M University, Biology Department\t\t\t",
"ETSU\ts\tEast Tennessee State University, Biological Sciences Department\t\t\t",
"EU\ts\tHubei University, Biology Department\t\t\t",
"EUB\ts\tLaboratory of Biology, Faculty of Science, Ehime University\t\t\t",
"EUMJ\ts\tEhime University\t\t\t",
"EUQ\ts\tDepartment of Entomology, Queensland University\t\t\t",
"EUSL\tc\tEastern University\t\t\t",
"EVA\tc\tEuropean Virus Archive\t\t\t",
"EVCV\ts\tErster Vorarlberger Coleopterische Verein\t\t\t",
"EVE\ts\tThe Evergreen State College\t\t\t",
"EVMU\ts\tEverhart Museum, Natural History Department\t\t\t",
"EWH\ts\tEwha Womans University\t\t\t",
"EWM\ts\tElizabeth Winston Mize Herbarium\t\t\t",
"EWNHM\ts\tEwha Womens University, Natural History Museum\t\t\t",
"EWU\ts\tEastern Washington University\t\t\t",
"EX\tc\tThe Culture Collection of Extremophilic Fungi\t\t\t",
"EXN\ts\tExton Hall\t\t\t",
"EXR\ts\tUniversity of Exeter, Biological Sciences Department\t\t\t",
"F\ts\tField Museum of Natural History, Botany Department\tFMNH:F\t\t",
"FAA\ts\tUniversidad Nacional del Centro de la Provincia de Buenos Aires\t\t\t",
"FABR\ts\tHarmas de J. H. Fabre\t\t\t",
"FACHB\tc\tFreshwater Algae Culture Collection\t\t\t",
"FACS\ts\tFujian Agricultural College\t\t\t",
"FAK\ts\tDepartment of Fisheries, Faculty of Agriculture\t\t\t",
"FAKOU\ts\tFaculty of Agriculture, Kochi Univerisity\t\t\t",
"FAKU\ts\tKyoto University\t\t\t",
"FAN\ts\tMuseum of Fanjingshan National Nature Reserve\t\t\t",
"FAR\ts\tUniversity of Tarbiat-Moaallem, Biology Department\t\t\t",
"FARM\ts\tLongwood University, Department of Natural Sciences\t\t\t",
"FAU\ts\tFlorida Atlantic University, Biological Sciences Department\t\t\t",
"FAUC\ts\tUniversidad de Caldas, Departamento de Recursos Naturales\t\t\t",
"FAUN\ts\tUniversidad de Narino\t\t\t",
"FAVU\ts\tUniversidade Federal do Rio Grande do Sul, Faculdade Agronomia e Veterenaria\t\t\t",
"FB\ts\tAlbert-Ludwigs Universitaet, Institut fuer Biologie II\t\t\t",
"FBA\ts\tFreshwater Biological Association\t\t\t",
"FBC\ts\tUniversity of Sierra Leone, Fourah Bay College, Botany Department\t\t\t",
"FBCS\ts\tUniversidad Autonoma de Baja California Sur, Museo de Historia Natural\t\t\t",
"FBGMU\tc\tFaculty of Biology Gadjah Mada University\t\t\t",
"FBMN\ts\tMuseum fur Naturkunde\t\t\t",
"FBQ\ts\tFisheries Branch, Departement of Primary Industries\t\t\t",
"FBUB\ts\tUniversitat Bielefeld\t\t\t",
"FBWA\ts\tForstlichen Bundsversuchsanstalt\t\t\t",
"FC-DPV\ts\tDepartmento de Paleontologia, Facultad de Ciencias\t\t\t",
"FCAB\ts\tPontificia Universidade Catolica do Rio de Janeiro, Nucleo Interdisciplinar de Meio Ambiente\t\t\t",
"FCBP\tc\tFirst Fungal Culture Bank of Pakistan\t\t\t",
"FCDA\ts\tFresno County Department of Agriculture\t\t\t",
"FCL<POL>\tc\tFungal Culture Collection of Lublin (at Biochemistry Dept., UMCS)\t\t\t",
"FCLR\ts\tFundacion Cientifica Los Roques\t\t\t",
"FCM\ts\tFacultad de Ciencias Marinas\t\t\t",
"FCME\ts\tUniversidad Nacional Autonoma de Mexico, Ciudad Universitaria, Departamento de Biologia\t\t\t",
"FCMM\ts\tUniversidad Nacional Autonoma de Mexico, Facultad de Ciencias\t\t\t",
"FCNI\ts\tForest Commission of N.S.W.\t\t\t",
"FCO\ts\tUniversidad de Oviedo, Departamento de Biologia de Organismos y Sistemas\t\t\t",
"FCP\ts\tFergusson College\t\t\t",
"FCQ\ts\tUniversidad Nacional de Asuncion, Departamento de Botanica, Direccion de Investigacion\t\t\t",
"FCRM\ts\tFisheries College Reference Museum\t\t\t",
"FCT\tc\tFCT (Forestry Commission Tasmania)\t\t\t",
"FCTH\ts\tForestry Commission of Tasmania\t\t\t",
"FCU\ts\tFukien Christian University\t\t\t",
"FCUG\tc\tFungal Cultures University of Goteborg\t\t\t",
"FCUL\ts\tFaculty of Sciences, University of Lisbon\t\t\t",
"FCUL:PCS_cicada\ts\tFaculty of Sciences, University of Lisbon, Cicada collection\t\t",
"FDA\tsc\tUS Food and Drug Administration\t\t\t",
"FDC\tc\tForsyth Dental Center\t\t\t",
"FDG\ts\tGuyana Forestry Commission\t\t\t",
"FDLW\ts\tUniversity of Wisconsin Center, Biology Department\t\t\t",
"FDNR\ts\tFlorida Department of Natural Resources\t\t\t",
"FDUC\ts\tFairleigh Dickinson University [collection transferred to FSCA].\t\t\t",
"FDVC\ts\tDe La Villa, Francisco\t\t\t",
"FEN\ts\tLycee Felix Esclangon, Region PACA\t\t\t",
"FER\ts\tUniversita de Ferrara, Dipartimento di Biologia - Sezione di Botanica\t\t\t",
"FERM\tc\tPatent and Bio-Resource Center, National Institute of Advanced Industrial Science and Technology (AIST)\t\t\t",
"FEUH\ts\tFar Eastern University, Manila\t\t\t",
"FEZA\ts\tUniversidad Nacional Autonoma de Mexico, Carrera de Biologia\t\t\t",
"FFB\ts\tAtlantic Forestry Centre, Canadian Forest Service\t\t\t",
"FFBNM\ts\tFlorissant Fossil Beds National Monument\t\t\t",
"FFCL\ts\tNossa Senhora do Patrocinia\t\t\t",
"FFR\ts\tForfar Museum and Art Gallery, Meffan Institute\t\t\t",
"FFS\ts\tUniversity of Stellenbosch (Williams Herbarium)\t\t\t",
"FFSUC\ts\tFaculty of Forestry Sciences\t\t\t",
"FG\ts\tPalaontologische Hauptsammlung der Bergakadmie\t\t\t",
"FGC\ts\tGrassland Research Institute, Chinese Academy of Agricultural Sciences\t\t\t",
"FGG\ts\tFaculty of Geology and Geophysis\t\t\t",
"FGGUB\ts\tFacultatea de Geologie si Geofisca\t\t\t",
"FGIC\ts\tFrancois Genier\t\t\t",
"FGSC\tc\tFungal Genetics Stock Center\t\t\t",
"FH\ts\tThe Farlow Herbarium, Harvard University Herbaria\t\t\t",
"FHI\ts\tForestry Research Institute of Nigeria\t\t\t",
"FHK\ts\tDivisional Forest Office\t\t\t",
"FHKS\ts\tFort Hays State University\t\t\t",
"FHKSC\ts\tFort Hays State University\t\t\t",
"FHL\ts\tFriday Harbor Laboratories, University of Washington\t\t\t",
"FHMU\ts\tFungal Herbarium of Hainan Medical University\t\t\t",
"FHO\ts\tUniversity of Oxford, Daubeny Herbarium\t\t\t",
"FHSM\ts\tFort Hays Sternberg Museum\t\t\t",
"FHSM:HERP\ts\tFort Hays Sternberg Museum, Herps Collection\t\t",
"FHSM:I\ts\tFort Hays Sternberg Museum, Fish collection\t\t",
"FHSM:M\ts\tFort Hays Sternberg Museum, Mammals Collection\t\t",
"FI\ts\tMuseo di Storia Naturale dell'Universita\t\t\t",
"FIAF\ts\tUniversita degli Studi di Firenze, Dipartimento di Biologia Vegetale\t\t\t",
"FICB\ts\tForest Research Centre\t\t\t",
"FIDS\ts\tGreat Lakes Forest Research Laboratory, Forest Insect and Disease Survey\t\t\t",
"FIEC\ts\tFreshwater Institute\t\t\t",
"FIOC\ts\tFundacao Instituto Oswaldo Cruz\t\t\t",
"FIOC:ColTryp\tc\tFundacao Instituto Oswaldo Cruz, Collection of Trypanosoma from Wild and Domestic Mammals and Vectors\t\t",
"Fiocruz/COLPROT\tc\tColecao de Protozoarios da FIOCRUZ\t\t\t",
"FIP\ts\tFlorida Institute of Paleontology\t\t\t",
"FIPF\ts\tUniversita di Firenze\t\t\t",
"FIPIA\ts\tInstitut Teknologi Bandung, Jurusan Biologi\t\t\t",
"FIRDI\tc\tFood Industry Research and Development Institute\t\t\t",
"FJFC\ts\tFujian Forestry College\t\t\t",
"FJSI\ts\tFujian Institute of Subtropical Botany\t\t\t",
"FKE\ts\tFolk Museum\t\t\t",
"FKEN\ts\tFolkestone Natural History Society\t\t\t",
"FLACC\tc\tFree-Living Amoebae Culture Collection\t\t\t",
"FLAS\ts\tFlorida Museum of Natural History Herbarium\t\t\t",
"FLC\ts\tFort Lewis College\t\t\t",
"FLD\ts\tFort Lewis College, Biology Department\t\t\t",
"FLH\ts\tFinger Lakes Community College\t\t\t",
"FLIN\ts\tFlinders University\t\t\t",
"FLK\ts\tFalkirk District Council Museum\t\t\t",
"FLOR\ts\tUniversidade Federal de Santa Catarina, Departamento de Botanica\t\t\t",
"FLSP\ts\tOscar Scherer State Park\t\t\t",
"FM<CHN-Beijing>\ts\tFan Memorial Institute of Biology\t\t\t",
"FM<CHN-Fujian>\ts\tDepartment of Nature, Fujian Province Museum\t\t\t",
"FMB\ts\tInstituto Alexander von Humboldt\t\t\t",
"FMC\ts\tNorth Museum of Natural History and Science\t\t\t",
"FMH\ts\tGoddard College\t\t\t",
"FMJ\tc\tFaculty of Medicine, Juntendo University\t\t\t",
"FML\ts\tFundacion Miguel Lillo\t\t\t",
"FMM\ts\tMuzeum Beskyd\t\t\t",
"FMNH\ts\tField Museum of Natural History\tCMNH<USA-IL>\t\t",
"FMNH:ARTH\ts\tField Museum of Natural History, Arthropod Collection\t\t",
"FMNH:AVES\ts\tField Museum of Natural History, Ornithology Collection\t\t",
"FMNH:F\ts\tField Museum of Natural History, Botany Department\t\t",
"FMNH:HERP\ts\tField Museum of Natural History, Herpetology Collection\t\t",
"FMNH:ICHTHY\ts\tField Museum of Natural History, Ichthyology Collection\t\t",
"FMNH:INVRT\ts\tField Museum of Natural History, Invertebrate Collection\t\t",
"FMNH:MAMM\ts\tField Museum of Natural History, Mammal Collection\t\t",
"FMNH<FIN>\ts\tFinnish Museum of Natural History\t\t\t",
"FMP\ts\tFujian Academy of Traditional Chinese Medicine and Pharmacology\t\t\t",
"FMPC\ts\tFairbanks Museum and Planetarium Collection\t\t\t",
"FMR\tc\tFacultad de Medicina\t\t\t",
"FMSS\ts\tParque Zoological Nacional \"Finca Modelo\", Natural History Museum\t\t\t",
"FMUH\ts\tFrancis Marion University\t\t\t",
"FNCC\tc\tFood and Nutrition Culture Collection\t\t\t",
"FNFR\ts\tFishlake National Forest\t\t\t",
"FNLO\ts\tFremont National Forest\t\t\t",
"FNM\ts\tFries Natuurmuseum\t\t\t",
"FNML\ts\tFries Natuurhistorisch Museum\t\t\t",
"FNP\ts\tFundy National Park\t\t\t",
"FNPS\ts\tSouth Florida Collections Management Center, Everglades National Park\t\t\t",
"FNU<CHN>\ts\tFujian Normal University\t\t\t",
"FNU<JPN>\ts\tNagasaki University - Fisheries\t\t\t",
"FOF\ts\tNational University of Laos\t\t\t",
"FOR\ts\tForssa Museum of Natural History\t\t\t",
"FOSJ\ts\tFisheries and Oceans Biological Station\t\t\t",
"FPDB\ts\tUniversidad de Puerto Rico, Departamento de Ciencias Marinas\t\t\t",
"FPF\ts\tRocky Mountain Research Station, USDA Forest Service\t\t\t",
"FPI\ts\tMedicinal Plant Herbarium, Faculty of Pharmacy, O.A.U\t\t\t",
"FPM\ts\tFukui Prefectural Museum\t\t\t",
"FPRL\ts\tBuilding Research Establishment\t\t\t",
"FQH\ts\tFort Qu'Appelle Herbarium\t\t\t",
"FR\tsb\tForschungsinstitut Senckenberg\t\t\t",
"FRC\ts\tInstitute of Forest Genetics and Tree Breeding\t\t\t",
"FRC<USA-PA>\tc\tFusarium Research Center\t\t\t",
"FRCL\ts\tFisheries Research Centre\t\t\t",
"FRCS\ts\tForest Research Centre\t\t\t",
"FRDC\tb\tFruit Tree Research & Development Center of ThuaThien-Hue-Vietnam\t\t\t",
"FRI<AUST>\ts\tAustralian National Herbarium, Division of Forestry and Forest Products, CSIRO\t\t\t",
"FRI<JPN>\tc\tFood Research Institute, Ministry of Agriculture, Forestry and Fisheries\t\t\t",
"FRI<SVK>\tc\tFood Research Institute, Bratislava, Slovakia\t\t\t",
"FRIHP\ts\tFisheries Research Institute of Hunan Province\t\t\t",
"FRIM\ts\tForest Research Institute, Malaysia\t\t\t",
"FRLC\ts\tForest Insect and Disease Survey Reference Collection\t\t\t",
"FRLH\ts\tFoundation for Revitalisation of Local Health Traditions, Research Department\t\t\t",
"FRLM\ts\tFaculty of Fisheries, Mie University\t\t\t",
"FRM\ts\tFriends University, Fellow-Reeve Museum of History and Science\t\t\t",
"FRNZ\ts\tForest Research Institute, New Zealand\t\t\t",
"FRP\ts\tPalmengarten\t\t\t",
"FRR\tc\tFood Science Australia, Ryde\t\thttp://www.foodscience.csiro.au/cgi-bin/rilax/search.pl?stpos=0&stype=AND&query=\t",
"FRS\ts\tFalconer Museum\t\t\t",
"FRSKU\ts\tKyoto University, Fisheries Research Station\t\t\t",
"FRU\ts\tNational Academy of Science, Kyrgyzstan, Laboratory of Flora\t\t\t",
"FSAG\ts\tFaculte des Sciences Agronomiques de Gembloux\t\t\t",
"FSC<CAN>\tc\tFredericton Stock Culture Collection\t\t\t",
"FSC<USA-CA>\ts\tCalifornia State University, Fresno\t\t\t",
"FSCA\ts\tFlorida State Collection of Arthropods, Florida Department of  Agriculture and Consumer Services, Division of Plant Industry\t\t\t",
"FSCL\ts\tFlorida Southern College, Biology Department\t\t\t",
"FSFRL\ts\tFar Seas Fisheries Research Laboratory\t\t\t",
"FSIU\ts\tLaboratory of Fisheries, Department of Oceanography\t\t\t",
"FSL\ts\tCollections de la Faculte des Sciences de Lyon\t\t\t",
"FSLF\ts\tRocky Mountain Forest and Range Experiment Station\t\t\t",
"FSMC\ts\tFlorida State Museum\tFSM\t\t",
"FSP-USP\ts\tFaculdade de Saude Publica, Universidade de Sao Paulo\t\t\t",
"FSSR\ts\tForest Service, USDA, Biological and Physical Resources Unit\t\t\t",
"FSU\ts\tFlorida State University, Department of Biological Science\t\t\t",
"FSUM\ts\tFlorida State University Museum\tFSU\t\t",
"FSUMC\ts\tFrostburg State University, Mammal Collection\t\t\t",
"FSUNS\ts\tFaculty of Science, The University of Novi Sad\t\t\t",
"FT\ts\tCentro Studi Erbario Tropicale, Universita degli Studi di Firenze\t\t\t",
"FTCC\tc\tFood Technology Culture Collection\t\t\t",
"FTCMU\tc\tDepartment of Food Science and Technology, Faculty of Agriculture\t\t\t",
"FTG\tsb\tFairchild Tropical Botanic Garden\t\t\t",
"FTI\tc\tCentro de Biotecnologia e Quimica-CEBIQ\t\t\t",
"FTK\tc\tForintek Culture Collection of Wood-Inhabiting Fungi\t\t\t",
"FTOH\ts\tForestry Training Institute, Olmotonyi\t\t\t",
"FTS\ts\tFuzhou Teachers College, Biology Department\t\t\t",
"FTU\ts\tUniversity of Central Florida, Biology Department\t\t\t",
"FU<CHN>\ts\tFudan University, Department of Biology\t\t\t",
"FU<JPN>\ts\tKyushu University, Department of Forest and Forest Products Sciences\t\t\t",
"FUB\ts\tFrei Universitat\t\t\t",
"FUE\ts\tFukuoka University of Education\t\t\t",
"FUEL\ts\tUniversidade Estadual de Londrina, Departamento de Biologia Animal e Vegetal\t\t\t",
"FUGR\ts\tFurman University, Biology Department\t\t\t",
"FUH\ts\tFirat Ueniversitesi\t\t\t",
"FUK\ts\tFukui Botanical Garden\t\t\t",
"FULD\ts\tVerein fuer Naturkunde in Osthessen\t\t\t",
"FUMH\ts\tFerdowsi University\t\t\t",
"FUMT\ts\tUniversity of Tokyo\t\t\t",
"FUNED\ts\tFundacao Ezequiel Dias, Belo Horizonte\t\t\t",
"FURB\ts\tUniversidade Regional de Blumenau\t\t\t",
"FUS\ts\tFudan University, Biology Department\t\t\t",
"FUSC\tc\tFlinders University Smut Collection\t\t\t",
"FVCC\ts\tFlathead Valley Community College, Biology Department\t\t\t",
"FW\ts\tTexas Christian University, Biology Department\t\t\t",
"FWM\ts\tFort Worth Museum of Science and History\t\t\t",
"FWMSH\ts\tFort Worth Museum of Science & History\t\t\t",
"FWRI\ts\tFlorida Fish and Wildlife Research Institute\t\t\t",
"FWRI:Ichthyology\ts\tFlorida Fish and Wildlife Research Institute, Ichthyology Collection\t\t",
"FWRI:Invertebrate\ts\tFlorida Fish and Wildlife Research Institute, Invertebrate Collection\t\t",
"FWRI:SEAMAP\tc\tFlorida Fish and Wildlife Research Institute, SEAMAP Ichthyoplankton Collection\thttp://research.myfwc.com/features/view_article.asp?id=30937",
"FWVA\ts\tFairmont State University, Biology Department\t\t\t",
"G\ts\tConservatoire et Jardin botaniques de la Ville de Geneve\t\t\t",
"GA\ts\tUniversity of Georgia, Plant Biology Department\t\t\t",
"GAB\ts\tNational Museum, Monuments, and Art Gallery\t\t\t",
"GABAS\ts\tCentre d'Etude et de Conservation des Resources Vegetales\t\t\t",
"GAC\ts\tGuangxi Agricultural University, Forestry Department\t\t\t",
"GACP\ts\tGuizhou Agricultural College, Department of Plant Protection\t\t\t",
"GADI\ts\tGrootfontein Agricultural Development Institute\t\t\t",
"GAES\ts\tGeorgia Agricultural Experiment Station\t\t\t",
"GAFS\ts\tGanzhou Forestry School\t\t\t",
"GAI\ts\tFolk Museum\t\t\t",
"GALW\ts\tNational University of Ireland, Galway, Botany Department\t\t\t",
"GAM<USA-GA>\ts\tUniversity of Georgia\t\t\t",
"GAM<VEN>\tc\tGrupo Actinomicetales Merida Facultad de Medicina\t\t\t",
"GAP\ts\tConservatoire Botanique National Alpin\t\t\t",
"GARIN\ts\tI. N. Garin Society for Studying of the Flora of the Yaroslavl oblast\t\t\t",
"GAS\ts\tGeorgia Southern University, Department of Biology\t\t\t",
"GAT\ts\tLeibniz Institute of Plant Genetics and Crop Plant Research (IPK)\t\t\t",
"GAUA\ts\tGuangxi University\t\t\t",
"GAUBA\ts\tAustralian National University, Division of Botany and Zoology\t\t\t",
"GAUF\ts\tGansu Agricultural University\t\t\t",
"GAW\ts\tEastern Botanical Society of Glasgow\t\t\t",
"GAZI\ts\tGazi Ueniversitesi, Biyoloji Boeluemue\t\t\t",
"GB\ts\tGoteborg University, Department of Plant and Environmental Sciences\t\t\t",
"GBFM\ts\tUniversidad de Panama\t\t\t",
"GBG<SWE>\tb\tGotheburg Botanical Garden\t\t\t",
"GBH\ts\tHerbarium of Geo. B. Hinton\t\t\t",
"GBNM\ts\tGlacier Bay National Park and Preserve Museum\t\t\t",
"GBS\tc\tGinseng Genetic Resource Bank\t\t\t",
"GBY\ts\tGrimsby Arts and Natural History\t\t\t",
"GC<GHN>\ts\tUniversity of Ghana, Botany Department\t\t\t",
"GC<USA-MD>\ts\tGoucher College\t\t\t",
"GCL\tc\tCentral Laboratories\t\t\t",
"GCM<GHN>\ts\tUniversity College of Ghana\t\t\t",
"GCM<PAK>\ts\tGovernment College, Department of Zoology\t\t\t",
"GCNP\ts\tGrand Canyon National Park\t\t\t",
"GCRL\ts\tGulf Coast Research Laboratory\t\t\t",
"GCSU\ts\tGeorgia College and State University\t\t\t",
"GCTP\ts\tGlobal Colosseum\t\t\t",
"GCU\ts\tGachon University\t\t\t",
"GDA\ts\tUniversidad de Granada\t\t\t",
"GDAC\ts\tUniversidad de Granada, Departamento de Biologia Vegetal, Botanica\t\t\t",
"GDB\ts\tHerbarium de Gerard de Belair\t\t\t",
"GDGM\ts\tGuangdong Institute of Microbiology\t\t\t",
"GDMA\ts\tMedical University of Gdansk, Department of Biology and Pharmaceutical Botany\t\t\t",
"GDMCC\tc\tGuangdong Microbial Culture Collection Center\t\t\t",
"GDMM\ts\tGuangdong Institute of Chinese Materia Medica\t\t\t",
"GDMP\ts\tGuangdong Medical and Pharmaceutical College, Pharmacy Department\t\t\t",
"GDOR\ts\tMuseo Civico di Storia Naturale Giacomo Doria\t\t\t",
"GE\ts\tUniversita di Genova\t\t\t",
"GEIC\ts\tGuangdong Entomology Institute\t\t\t",
"GENT\ts\tGent University, Biology Department\t\t\t",
"GEO\ts\tEmory University, Biology Department\t\t\t",
"GES\ts\tGesneriad Research Foundation\t\t\t",
"GESU\ts\tState University of New York, Biology Department\t\t\t",
"GF\ts\tGuizhou Academy of Forestry\t\t\t",
"GFBI\ts\tGymnasium der Franziskaner in Bozen [= Bolzano]\t\t\t",
"GFC\ts\tUniversity of Great Falls, Biology Department\t\t\t",
"GFCC\tc\tGoa University Fungus Culture Collection and Research Unit\tGUFCC\t\t",
"GFJP\ts\tUniversidade do Estado de Minas Gerais\t\t\t",
"GFND\ts\tUniversity of North Dakota, Biology Department\t\t\t",
"GFRC\ts\tGolestan Fisheries Research Centre\t\t\t",
"GFS\ts\tGuizhou Forestry School\t\t\t",
"GFT\ts\tGrumeti Fund Tanzania\t\t\t",
"GFW\ts\tErnst-Moritz-Arndt-Universitaet, Botanisches Institut und Botanischer Garten\t\t\t",
"GGB\ts\tGesneriad Gardens\t\t\t",
"GGM\ts\tGosudarstvennyi Geologicheskii Musei - State Geological Museum\t\t\t",
"GGO\ts\tUniversity of Strathclyde, Biology Department\t\t\t",
"GGW\ts\tBotanical Society of Glasgow\t\t\t",
"GH\ts\tHarvard University (The Gray Herbarium)\t\t\t",
"GHD\ts\tShipley Art Gallery and Saltwell Tower Museum\t\t\t",
"GHG\ts\tCouncil for Geosciences\t\t\t",
"GHPG\ts\tHarold Porter National Botanical Garden\t\t\t",
"GHRI\ts\tGuy Harvey Research Institute\t\t\t",
"GHS\ts\tGeorge Heriot's School, Biology Department\t\t\t",
"GI\ts\tJustus-Liebig-Universitat Giessen\t\t\t",
"GI-SPS\ts\tGeological Institute, Section of Palaeontology and Stratigraphy\t\t\t",
"GIFU<JPN>\ts\tHerbarium of Gifu Pharmaceutical University\t\t\t",
"GILAN\ts\tAgricultural and Natural Resources Research Center of Gilan\t\t\t",
"GINCO\ts\tGlomeromycota in vivo and in vitro collection (Agriculture and Agri-Food Canada)\t\t\t",
"GIUV\ts\tGeological Institute, University of Vienna\t\t\t",
"GJO\ts\tUniversalmuseum Joanneum\t\t\t",
"GKAR\ts\tKaroo National Botanical Garden\t\t\t",
"GL\ts\tUniversity of Glasgow, Botany Department\t\t\t",
"GLA\ts\tGeorge Landis Arboretum\t\t\t",
"GLAC\ts\tGlacier National Park, Glacier Collection\t\t\t",
"GLAHM\ts\tUniversity of Glasgow, Hunterian Museum\t\t\t",
"GLAM\ts\tArt Gallery and Museum, Natural History Department\t\t\t",
"GLANH\ts\tHunterian Museum\t\t\t",
"GLEN\ts\tRappahannock Community College\t\t\t",
"GLFR\ts\tGreat Lakes Forest Research Centre\t\t\t",
"GLG\ts\tTrinity College\t\t\t",
"GLLB\ts\tLaurel Bank School\t\t\t",
"GLM\ts\tStaatliches Museum fuer Naturkunde Goerlitz\t\t\t",
"GLMC\tc\tCulture collection of Senckenberg Museum of Natural  History Gorlitz\t\t\t",
"GLNP\ts\tGlacier National Park\t\t\t",
"GLO\ts\tNatural History Society of Glasglow\t\t\t",
"GLOW\ts\tLowveld National Botanical Garden\t\t\t",
"GLR\ts\tGloucester City Museum and Art Gallery\t\t\t",
"GLW\ts\tAndersonian Naturalists' Society\t\t\t",
"GM\ts\tMuseum of Southeastern Moravia\t\t\t",
"GMACC\tc\tLaboratory of Molecular Genetics and Breeding of Edible Mushrooms\t\t\t",
"GMAU\ts\tGeological Museum of Amsterdam University\t\t\t",
"GMB\ts\tGuizhou Medical University\t\t\t",
"GMBL\ts\tCollege of Charleston\t\t\t",
"GMC\ts\tGuangxi Medical College\t\t\t",
"GMCE\ts\tGrosvenor Museum\t\t\t",
"GMDRC\ts\tGranite Mountains Desert Research Center\t\t\t",
"GMH\ts\tSammlung Jacobi des Geiseltalmuseum Halle\t\t\t",
"GMHH\ts\tGeological Museum of Heilongjang Province\t\t\t",
"GML<USA-IL>\ts\tGorgas Memorial Laboratory\t\t\t",
"GML<USA-MO>\ts\tGaylord Memorial Laboratory Museum\t\t\t",
"GMNGZ\ts\tGlasgow Museum and Art Galleries\t\t\t",
"GMNH-PV\ts\tPaleo-Vertebrate Collection\t\t\t",
"GMNH<CHE>\ts\tMuseum d'Histoire Naturelle\t\t\t",
"GMNH<USA-GA>\ts\tGeorgia Museum of Natural History\t\t\t",
"GMNHJ\ts\tGunma Museum of Natural History\t\t\t",
"GMNP\ts\tGros Morne National Park\t\t\t",
"GMS\ts\tHopkins Marine Station, Stanford University, Biological Sciences Department\t\t\t",
"GMU\ts\tN. P. Ogariov Mordovia State University, Department of Botany and Plant Physiology\t\t\t",
"GMUF\ts\tGeorge Mason University, Department of Environmental Science and Policy 5F2\t\t\t",
"GMUG\ts\tUniversitat Gottingen, Geologisches-Palaatologisches Museum\t\t\t",
"GMUM\ts\tInstitut fuer Palaeontologie und Geologisches Museum der Universitat\t\t\t",
"GMUV\ts\tGeological Museum, University of Vienna\t\t\t",
"GNA\ts\tGannan Arboretum of Jiangxi\t\t\t",
"GNDUH\ts\tGuru Nanak Dev University\t\t\t",
"GNE\tc\tGenentech\t\t\t",
"GNHM\ts\tGoulandris Natural History Museum\t\t\t",
"GNHNA\ts\tGallery of Natural History and Native Art\t\t\t",
"GNHS\ts\tGuildford Natural History Society\t\t\t",
"GNM<SWE>\ts\tGothenburg Museum of Natural History (Goteborgs Naturhistoriska Museum)\t\t\t",
"GNNU\ts\tNanling Herbarium, Gannan Normal University\t\t\t",
"GNU\ts\tGuangxi Normal University, Biology Department\t\t\t",
"GNUB\ts\tGuizhou Normal University, Biology Department\t\t\t",
"GNUC\ts\tGyeongsang National University, Biology Department\t\t\t",
"GNUG\ts\tGuizhou Normal University, Geography Department\t\t\t",
"GO\ts\tPhilosophical Society\t\t\t",
"GOD\ts\tCharterhouse School Museum\t\t\t",
"GOE<DEU>\ts\tInstitut und Museum fuer Geologie und Palaeontologie\t\t\t",
"GOE<GBR>\ts\tGoole Scientific Society\t\t\t",
"GOET\ts\tHerbarium Universitat Gottingen\t\t\t",
"GOFS\ts\tFree State National Botanical Garden\t\t\t",
"GOPU\ts\tGaziosmanpasa University\t\t\t",
"GOW\ts\tClydebank High School\t\t\t",
"GP\ts\tInstituto de Geociencias, Universidade de Sao Paulo\t\t\t",
"GPA\ts\tGrande Prairie Regional College, Science Department\t\t\t",
"GPI\ts\tGeologisch-Palaeontologisches Institut\t\t\t",
"GPIH\ts\tGeologisch-Palaeontologiches Institut der Universitt Haemburg\t\t\t",
"GPIM\ts\tLehreinheit Palaeontologisches, Institut fuer Geowissenschaften\t\t\t",
"GPIT\ts\tInstitut und Museum fur Geologie und Palaontologie, Universitat Tubingen\t\t\t",
"GPM\ts\tGifu prefectural Museum\t\t\t",
"GPM:B\ts\tGifu prefectural Museum, Gifu prefectural Museum herbarium\t\t",
"GPM:Z\ts\tGifu prefectural Museum, Gifu prefectural Museum Zoological collection\t\t",
"GPMK\ts\tGeologisch-Palaontologisches Institut und Museum\t\t\t",
"GPPT\ts\tPlant Protection Institute\t\t\t",
"GR\ts\tUniversite J. Fourier - Grenoble I, Botanique\t\t\t",
"GRA\ts\tAlbany Museum (Selmar Schonland Herbarium)\t\t\t",
"GRCAMC\ts\tGrand Canyon National Park Museum Collection\t\t\t",
"GRCH\ts\tColgate University, Biology Department\t\t\t",
"GREE\ts\tUniversity of Northern Colorado, Department of Biological Sciences\t\t\t",
"GRI\ts\tGrinnell College, Biology Department\t\t\t",
"GRIF\ts\tGriffith University\t\t\t",
"GRJC\ts\tGrand Rapids Junior College\t\t\t",
"GRK\ts\tMcLean Museum and Art Gallery\t\t\t",
"GRM\ts\tMuseum d'Histoire Naturelle de Grenoble\t\t\t",
"GRMP\ts\tCentral Geological Research Museum\t\t\t",
"GRO\ts\tState University of Groningen, Department of Plant Biology\t\t\t",
"GRPM\ts\tPublic Museum of Grand Rapids\t\t\t",
"GRSM\ts\tGreat Smoky Mountains National Park\t\t\t",
"GRSU\ts\tYanka Kupala Grodno State University, Department of Botany\t\t\t",
"GRSW\ts\tDesert Ecological Research Unit\t\t\t",
"GRTE\ts\tGrand Teton National Park\t\t\t",
"GSAT\ts\tThe Geological Survey of Alabama\t\t\t",
"GSC\ts\tGeological Survey of Canada\t\t\t",
"GSDNM\ts\tGreat Sand Dunes National Monument\t\t\t",
"GSFS\ts\tGansu Forestry School\t\t\t",
"GSI\ts\tGeological Survey of India\t\t\t",
"GSM\ts\tGeologic Museum\t\t\t",
"GSMNP\ts\tGreat Smoky Mountains National Park\t\t\t",
"GSN\ts\tGeological Survey of Nambia\t\t\t",
"GSO\ts\tGlasgow Society of Field Naturalists'\t\t\t",
"GSP\ts\tGeological Survey of Portugal\t\t\t",
"GSU\ts\tF. Scorina Gomel State University, Department of Botany and Plant Physiology\t\t\t",
"GSW\ts\tGeorgia Southwestern State University, Biology Department\t\t\t",
"GTC\tc\tGifu Type Culture Collection\tGTC-GIFU\t\t",
"GTC-GIFU\tc\tGifu Type Culture Collection (GTC), Gifu University Culture Collection (GIFU)\tGTC\t\t",
"GTM\ts\tGrantham Museum\t\t\t",
"GTNP\ts\tGrand Teton National Park\t\t\t",
"GTV\ts\tGregorio T. Velasquez Phycological Herbarium\t\t\t",
"GU\ts\tGotland University, Department of Biology\t\t\t",
"GU-IITG\ts\tGauhati University- Indian Institute of Technology Guwahati\t\t\t",
"GUA\ts\tDIVEA, DEP, FEEMA, FEEMA\t\t\t",
"GUAD\ts\tInstitut National de la Recherche Agronomique and Parc National de Guadeloupe\t\t\t",
"GUADA\ts\tUniversidad Autonoma de Guadalajara\t\t\t",
"GUAM\ts\tUniversity of Guam, Biology Department\t\t\t",
"GUAT\ts\tHerbario Ulises Roja\t\t\t",
"GUAY\ts\tUniversidad de Guayaquil\t\t\t",
"GUBH\ts\tGauhati University\t\t\t",
"GUBIOTJT\tc\tFreshwater microalgae collection and culture laboratory\t\t\t",
"GUCM\ts\tGuangzhou University of Chinese Medicine\t\t\t",
"GUH\ts\tHNB Garhwal University, Botany Department\t\t\t",
"GUL\ts\tSuleyman Demirel University\t\t\t",
"GUM\ts\tGlasgow University Museum (Hunter Museum)\t\t\t",
"GUM<IRN>\ts\tGuilan University Mycological Herbarium\t\t\t",
"GUMACC\tc\tGotheburg University Marine Algal Culture Collection\t\t\t",
"GUYN\ts\tFundacion Jardin Botanico del Orinoco\t\t\t",
"GVF\ts\tGeorge Vanderbilt Foundation\t\t\t",
"GVSC\ts\tGrand Valley State University, Biology Department\t\t\t",
"GW\ts\tWest of Scotland College of Agriculture, Botany Department\t\t\t",
"GWJ\ts\tGaowangjie National Nature Reserve\t\t\t",
"GXCM\ts\tGuangxi Traditional Chinese Medicine University, Pharmacy Department\t\t\t",
"GXDC\ts\tGuangxi Institute for Drug Control\t\t\t",
"GXEM\ts\tGuangxi Institute of Ethnomedicine\t\t\t",
"GXF\ts\tGuangxi Institute of Forest Survey and Design\t\t\t",
"GXFI\ts\tGuangxi Forestry Institute\t\t\t",
"GXFS\ts\tGuangxi Forestry School\t\t\t",
"GXMG\ts\tGuangxi Medicinal Botanic Garden\t\t\t",
"GXMI\ts\tGuangxi Institute of Traditional Medical and Pharmaceutical Sciences\t\t\t",
"GXNM\ts\tGuangxi Natural History Museum, Herbarium\t\t\t",
"GXSP\ts\tGuangxi School of Pharmacy\t\t\t",
"GZAC\ts\tGuizhou Agricultural College, College of Life Science\t\t\t",
"GZCC\tc\tGuizhou Culture Collection\t\t\t",
"GZM\ts\tGiessener Zoologisches Museum\t\t\t",
"GZTM\ts\tGuizhou Institute of Traditional Chinese Medicine\t\t\t",
"GZU\ts\tKarl-Franzens-Universitat Graz\t\t\t",
"GZUH\ts\tGuizhou University Herbarium\t\t\t",
"H\ts\tUniversity of Helsinki\t\t\t",
"H-GSP\ts\tHoward University-Geological Survey of Pakistan Project\t\t\t",
"HA\ts\tUniversidad del Azuay, Escuela de Biologia del Medio Ambiente\t\t\t",
"HABA\ts\tAcademia de Ciencias Medicas, Fisicas y Naturales de La Habana\t\t\t",
"HABAYC\ts\tUniversity of Mary Hardin-Baylor, Biology Department\t\t\t",
"HABE\ts\tInstituto de Biologia, Departamento de Ecologia\t\t\t",
"HABIT\ts\tUniversidade Estadual do Maranhao/UEMA\t\t\t",
"HAC\ts\tInstituto de Ecologia y Sistematica\t\t\t",
"HACC<CUB>\ts\tAcademia de Ciencias Camaguey\t\t\t",
"HACC<IND>\tc\tResearch Laboratories of Hindustan Antibiotics, Ltd.\t\t\t",
"HACW\ts\tDepartment of Fishery, Huazhong Agriculture Collection\t\t\t",
"HAF\ts\tHainan Forestry Institute\t\t\t",
"HAG\ts\tUniversidad Nacional Amazonica de Madre de Dios (UNAMAD)\t\t\t",
"HAH\ts\tHoyt Arboretum\t\t\t",
"HAI\ts\tUniversity of Haifa\t\t\t",
"HAJB\ts\tJardin Botanico Nacional\t\t\t",
"HAJU\ts\tHerbario Dr. Armando Jesus Urquiola\t\t\t",
"HAK\ts\tHokkaido University, Faculty of Fisheries\t\t\t",
"HAKS\ts\tHakgala Botanic Gardens\t\t\t",
"HAL\ts\tMartin-Luther-Universitat\t\t\t",
"HALA\ts\tUniversity of Alabama, Biological Sciences Department\t\t\t",
"HALE\ts\tHaleakala National Park\t\t\t",
"HALLE\ts\tZoologisches Institut der Martin-Luther Universitaet\t\t\t",
"HALLST\ts\tBotanische Station\t\t\t",
"HALN\ts\tState Agency for Environmental Protection Saxony-Anhalt\t\t\t",
"HALX\ts\tHalifax Literary and Philosophical Society\t\t\t",
"HAM\ts\tRoyal Botanical Gardens\t\t\t",
"HAMAB\ts\tInstituto de Pesquisas Cientificas e Tecnologicas do Estado do Amapa\t\t\t",
"HAMBI\tc\tHAMBI Culture Collection\t\t\t",
"HAMU\ts\tUniversity of Newcastle upon Tyne\t\t\t",
"HAN\ts\tUniversitaet Hannover\t\t\t",
"HANC\ts\tNational Aquarium of Cuba\t\t\t",
"HANU\ts\tHarbin Normal University, Biology Department\t\t\t",
"HAO\ts\tUniversidad Privada Antenor Orrego\t\t\t",
"HAQ\ts\tInstitut der Technische Hochschule (RWTH), Institut fuer Biologie I\t\t\t",
"HARG\ts\tUniversity of Hargeisa\t\t\t",
"HARRAN\ts\tHerbarium of Harran University\t\t\t",
"HAS\ts\tFundacao Zoobotanica do Rio Grande do Sul\t\t\t",
"HASSI\ts\tUniversidade Estadual Paulista\t\t\t",
"HAST\ts\tResearch Center for Biodiversity, Academia Sinica\t\t\t",
"HASU\ts\tUniversidade do Vale do Rio dos Sinos - CCS/ Centro 2\t\t\t",
"HAU\ts\tAlzahra University\t\t\t",
"HAUH\ts\tHaryana Agricultural University\t\t\t",
"HAVI\ts\tEastern Mennonite University, Biology Department\t\t\t",
"HAVO\ts\tHawaii Volcanoes National Park\t\t\t",
"HAW\ts\tUniversity of Hawaii, Botany Department\t\t\t",
"HAX\ts\tBelle Vue Museum\t\t\t",
"HB\ts\tHerbarium Bradeanum\t\t\t",
"HBA\ts\tNational Botanic Garden of Latvia\t\t\t",
"HBARC\ts\tBhabha Atomic Research Centre\t\t\t",
"HBAU\ts\tHebei Agricultural University\t\t\t",
"HBAUD\ts\tHebei Agricultural University, Handan Branch\t\t\t",
"HBBS\ts\tMuseo Civico di Scienze Naturali\t\t\t",
"HBC\ts\tHenry Brockhouse Collection\t\t\t",
"HBDC\ts\tHebei Institute for Drug Control\t\t\t",
"HBFC\ts\tHebei Forestry College, Basic Courses Department\t\t\t",
"HBFH\ts\tHarbor Branch Oceanographic Institution, Marine Botany Department\t\t\t",
"HBG\ts\tInstitut fuer Allgemeine Botanik\t\t\t",
"HBG<JPN>\tb\tHiroshima Botanical Garden\t\t\t",
"HBI\ts\tInstitute of Hydrobiology, Chinese Academy of Sciences, Phycology Department\t\t\t",
"HBIL\ts\tInstitut d'Estudis Ilerdencs\t\t\t",
"HBNU\ts\tHebei Normal University, Biology Department\t\t\t",
"HBOM\ts\tHarbor Branch Oceanographic Museum\tHBOI\t\t",
"HBR\ts\tHerbario Barbosa Rodrigues\t\t\t",
"HBRA\ts\tUniversidade Federal do Para, Campus Braganca\t\t\t",
"HBSH\ts\tHighlands Biological Station\t\t\t",
"HBUM\ts\tCollege of Life Sciences Hebei Univesity, Baoding\t\t\t",
"HC\ts\tHangchow Christian College\t\t\t",
"HCAT\ts\tUniversity of Tabriz, Landscape Department\t\t\t",
"HCB\ts\tUniversidade de Santa Cruz do Sul, Departamento de Biologia\t\t\t",
"HCCA\ts\tHastings College\t\t\t",
"HCCN\ts\tNational Institute of Agricultural Science and Technology\t\t\t",
"HCCV\ts\tHastings College, Collection of Vertebrates\t\t\t",
"HCDAL\ts\tUniversidade Regional do Cariri\t\t\t",
"HCEN\ts\tUniversidad Nacional del Centro del Peru\t\t\t",
"HCF\ts\tUniversidade Tecnologica Federal do Parana\t\t\t",
"HCH\ts\tLewis-Clark State College, Natural Sciences Department\t\t\t",
"HCHM\ts\tHope College, Biology Department\t\t\t",
"HCIB\ts\tCentro de Investigaciones Biologicas del Noroeste, S. C.\t\t\t",
"HCIO\ts\tIndian Agricultural Research Institute\t\t\t",
"HCJS\ts\tVale S/A\t\t\t",
"HCMS\ts\tHampshire County Council Museums Service\t\t\t",
"HCMZ\ts\tHope College\t\t\t",
"HCNGB\ts\tChina National GeneBank\t\t\t",
"HCOA\ts\tCollege of the Atlantic, Herbarium\t\t\t",
"HCOM\ts\tCentre d'Oceanologie de Marseille - University of Aix-Marseille II\t\t\t",
"HCP\ts\tUniversidade Federal Rural da Amazonia\t\t\t",
"HCT\ts\tTaiwan Forestry Research Institute (Heng-Chun Branch Station)\t\t\t",
"HCTR\ts\tHoogstraal Center for Tick Research\t\t\t",
"HDCF\ts\tDepartment of Forestry Science\t\t\t",
"HDD\ts\tTolson Museum, Natural History Department\t\t\t",
"HDELTA\ts\tUniversidade Federal do Piaui\t\t\t",
"HDJF\ts\tHerbario Dendrologico Jeanine Felfili Universidade Federal dos Vales do Jequitinhonha e Mucuri\t\t\t",
"HDOA\ts\tHawaii Department of Agriculture\t\t\t",
"HDSM\ts\tUniversity of Massachusetts Dartmouth\t\t\t",
"HDTC\ts\tHuddersfield Technical College\t\t\t",
"HEAC\ts\tHenan Agricultural University\t\t\t",
"HEB\ts\tHebden Bridge Literary and Scientific Society\t\t\t",
"HEBI\ts\tHenan Academy of Sciences\t\t\t",
"HECM\ts\tHenan College of Traditional Chinese Medicine\t\t\t",
"HEFG\ts\tl'Ecole de Faune de Garoua\t\t\t",
"HEH\ts\tEscuela Nacional de Ciencias Forestales, Departamento de Investigacion Forestal Aplicada\t\t\t",
"HEID\ts\tUniversitaet Heidelberg, Heidelberger Institut fuer Pflanzenwissenschaften\t\t\t",
"HEL\ts\tUniversity of Helsinki, Section of Botany\t\t\t",
"HEM\ts\tUniversidad de Ciencias y Artes de Chiapas\t\t\t",
"HEMS\ts\tHaslemere Educational Museum\t\t\t",
"HENA\ts\tEscuela Nacional de Agricultura\t\t\t",
"HEND\ts\tHenderson State University, Biology Department\t\t\t",
"HENNU\ts\tHenan Normal University\t\t\t",
"HENU\ts\tHenan Normal University, Biology Department\t\t\t",
"HEPH\ts\tJardim Botanico de Brasilia\t\t\t",
"HER<CAN>\tc\tFelix d'Herelle Reference Center for Bacterial Viruses (Bacteriophage)\t\t\t",
"HER<ZAF>\ts\tHermanus Botanical Society\t\t\t",
"HERBAM\ts\tUniversidade do Estado de Mato Grosso\t\t\t",
"HERT\ts\tFundacao Universidade Estadual do Ceara\t\t\t",
"HERZ\ts\tHerzen State Pedagogical University of Russia, Department of Botany\t\t\t",
"HERZU\ts\tUniversidad del Zulia\t\t\t",
"HEUS\ts\tUniversidad de Sucre\t\t\t",
"HF\ts\tHerbario Profa. Normelia Vasconcelos, Universidade Federal do Para\t\t\t",
"HFB\ts\tHainan Forestry Bureau\t\t\t",
"HFBG\ts\tForestry Botanical Garden of Heilongjiang\t\t\t",
"HFC\ts\tHerbario Fernando Cardoso da Silva, Embrapa Florestas\t\t\t",
"HFCC\tc\tFlagellate Culture Collection, University of Cologne\t\t\t",
"HFD\ts\tHereford Museum\t\t\t",
"HFLA\ts\tSapienza University of Rome - Scuola di Specializzazione in Beni Naturali e Territoriali\t\t\t",
"HFN\ts\tHerbarium Frisicum\t\t\t",
"HFP\tc\tHokkaido Forest Products Research Institute\t\t\t",
"HFR\ts\tFinnish Forest Research Institute\t\t\t",
"HFRI\ts\tHunan Forestry Research Institute\t\t\t",
"HFSL\ts\tCentro de Ensino, Faculdade Sao Lucas Ltda.\t\t\t",
"HFU\ts\tHerbarium of Fayoum University\t\t\t",
"HFV\ts\tUniversidad Austral de Chile, Instituto de Produccion y Sanidad Vegetal\t\t\t",
"HFX\ts\tBankfield Museum and Art Gallery\t\t\t",
"HG\ts\tUniversidad de la Guajira\t\t\t",
"HGAS\ts\tGuizhou Academy of Sciences, Plant Taxonomy Group\t\t\t",
"HGCRL\ts\tGulf Coast Research Laboratory\t\t\t",
"HGI\ts\tUniversitat de Girona, Unitat de Biologia Vegetal\t\t\t",
"HGM\ts\tHunan Geological Museum\t\t\t",
"HGOM\ts\tUniversidad Autonoma del Estado de Hidalgo\t\t\t",
"HGS\ts\tPublic Museum and Art Gallery, St. John's Place\t\t\t",
"HGTC\ts\tHuanggang Teachers College, Biology Department\t\t\t",
"HGU\ts\tKhakass State University\t\t\t",
"HGV\ts\tHerbario de Glomeromycota de Venezuela\t\t\t",
"HH\ts\tInstituto de Investigaciones de la Amazonia Peruana\t\t\t",
"HHBG\ts\tHangzhou Botanical Garden\t\t\t",
"HHC\ts\tUniversity of Helsinki, Horticulture Department\t\t\t",
"HHE\ts\tHouHe National Nature Reserve\t\t\t",
"HHH\ts\tHartwick College\t\t\t",
"HHM\ts\tCollyer's School\t\t\t",
"HHNNR\ts\tHunan Hupingshan National Nature Reserve\t\t\t",
"HHU\ts\tHallym University\t\t\t",
"HHUA\ts\tUniversidad Nacional de Huanuco Hermilio Valdizan\t\t\t",
"HHUF\ts\tHirosaki University, Laboratory of Plant Pathology\t\t\t",
"HIB\ts\tWuhan Institute of Botany\t\t\t",
"HIBG\ts\tHiroshima Botanical Garden\t\t\t",
"HIC\ts\tUniversity of Kentucky, Department of Entomology, Hymenoptera Institute Collection\t\t\t",
"HIFP\ts\tFrench Institute\t\t\t",
"HILL\ts\tSir Harold Hillier Gardens\t\t\t",
"HIMC\ts\tInner Mongolia University\t\t\t",
"HIN\ts\tHitchin Priory\t\t\t",
"HIP\ts\tUniversidad de Magallanes\t\t\t",
"HIPC\ts\tInstituto Superior Pedagogico Jose Marti, Departamento de Biologia\t\t\t",
"HIPE\ts\tJardim Botanico Municipal \"Max Habliztel\" de Sao Jose\t\t\t",
"HIRO\ts\tHiroshima University, Biological Science Department\t\t\t",
"HIRU\ts\tOkayama University of Science\t\t\t",
"HISA\ts\tUniversidade Estadual Paulista\t\t\t",
"HITBC\ts\tXishuangbanna Tropical Botanical Garden, Chinese Academy of Sciences\t\t\t",
"HIUW\ts\tHygiene-Institut der Universitaet\t\t\t",
"HIWNT\ts\tHampshire and Isle of Wight Naturalists' Trust Ltd.\t\t\t",
"HJ\ts\tUniversidade Federal de Jatai\t\t\t",
"HJBC\ts\tJardin Botanico Culiacan\t\t\t",
"HJBG\ts\tJardin botanique de Guyane\t\t\t",
"HJBL\ts\tEscuela Nacional de Ciencias Forestales\t\t\t",
"HJBS\ts\tFundacio Jardi Botanic de Soller\t\t\t",
"HK\ts\tAgriculture, Fisheries, and Conservation Department\t\t\t",
"HKAS\ts\tCryptogamic Herbarium of Kunming Institute of Botany, Chinese Academy of Sciences\tKUN-HKAS\t\t",
"HKBU\ts\tHong Kong Baptist University, Biology Department\t\t\t",
"HKFRS\ts\tHong Kong Fisheries Research Station\t\t\t",
"HKGL\ts\tNaturwissenschaftliche Sammlungen des Kantons Glarus\t\t\t",
"HKI\tc\tHans-Knoll Institute\t\t\t",
"HKM\ts\tUniversity of Comoros\t\t\t",
"HKS\ts\tResearch Center of Agricultural and Natural Resources Kurdistan Province\t\t\t",
"HKU\ts\tUniversity of Hong Kong, Ecology and Biodiversity Department\t\t\t",
"HKUCC\tc\tThe University of Hong Kong Culture Collection\t\t\t",
"HL\ts\tHoughton Lake Wildlife Research Station, Natural Resources Department\t\t\t",
"HL<NLD>\tsb\tHortus Botanicus Leiden\t\t\t",
"HLA\ts\tHarold L. Lyon Arboretum\t\t\t",
"HLCM\ts\tHeilongjiang College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t\t",
"HLD\ts\tHessisches Landesmuseum\t\t\t",
"HLDG\ts\tLas Cruces Biological Station, Organization for Tropical Studies\t\t\t",
"HLL\ts\tQueen's Gardens, College of Higher Education, Natural Science Department\t\t\t",
"HLMA\ts\tTown Docks Museum, Hull City Corporation\t\t\t",
"HLMD\ts\tHessisches Landesmuseum Darmstadt\t\t\t",
"HLNM\ts\tHeilongjiang Provincial Museum\t\t\t",
"HLO\ts\tVlastivedne Muzeum v Hlohovci\t\t\t",
"HLSD\ts\tHillsdale College\t\t\t",
"HLU\ts\tUniversity of Hull, Botany Department\t\t\t",
"HLUC\ts\tUniversita degli Studi della Basilicata, Dipartimento di Biologia Difesa e Biotecnologie Agroforestali\t\t\t",
"HLUL\ts\tUniversity of Hull\t\t\t",
"HLX\ts\tOvenden Naturalists' Society\t\t\t",
"HM<DEU>\ts\tHumbolt Museum\t\t\t",
"HM<USA-NE>\ts\tHastings Museum\t\t\t",
"HMAR\ts\tUniversidade Federal do Ceara\t\t\t",
"HMAS\tsc\tInstitute of Microbiology, Academia Sinica\t\t\t",
"HMC\ts\tJardin Botanico de Las Tunas\t\t\t",
"HME\ts\tHaslemere Educational Museum\t\t\t",
"HMGBH\ts\tGiardini Botanici Hanbury / Hanbury Botanic Gardens\t\t\t",
"HMH\ts\tHoebarth Museum Horn\t\t\t",
"HMIM\ts\tJardi Botanic Marimurtra\t\t\t",
"HMJAU\tsc\tHerbarium of Mycology of Jilin Agricultural University\t\t\t",
"HMLN\ts\tDistrict Museum\t\t\t",
"HMM\ts\tHorsham Museum\t\t\t",
"HMMNH\ts\tMacedonian Museum of Natural History\t\t\t",
"HMN\ts\tHumbolt Museum fur Naturkunde, East Berlin\t\t\t",
"HMNH\ts\tHayashibara Museum of Natural History\t\t\t",
"HMNR\ts\tMordovian State Nature Reserve\t\t\t",
"HMNS\ts\tHouston Museum of Natural Science\t\t\t",
"HMNT\ts\tHancock Museum, Newcastle University\t\t\t",
"HMP\ts\tHornonitrianske muzeum, Department of Natural History\t\t\t",
"HMS\ts\tEmbrapa Gado de Corte\t\t\t",
"HMUG\ts\tHunterian Museum\t\t\t",
"HMUT\ts\tHerbarium Mycologicum Universitatis Tarimensis\t\t\t",
"HN\ts\tNational Center for Natural Sciences and Technology, Botany Department\t\t\t",
"HNBU\ts\tInstitut de l'Environnement et de Recherche Agricola (INERA)\t\t\t",
"HNCMB\tc\tHungarian National Collection of Medical Bacteria\t\t\t",
"HND\ts\tCentre d'Etude et de Recherche de Djibouti (CERD)\t\t\t",
"HNG\ts\tUniversite. Gamal Abdel Nasser de Conakry\t\t\t",
"HNH\ts\tDartmouth College, Biological Sciences Department\t\t\t",
"HNHH\ts\tHeilongjiang Natural History Museum\t\t\t",
"HNHM<HUN>\ts\tHungarian Natural History Museum (Termeszettudomanyi Muzeum)\t\t\t",
"HNHM<HUN>:CGR\ts\tHungarian Natural History Museum (Termeszettudomanyi Muzeum), Collection of Genetic Resources\t\t",
"HNHM<HUN>:Moll\ts\tHungarian Natural History Museum (Termeszettudomanyi Muzeum), Mollusca Collection\t\t",
"HNHM<KOR>\ts\tHannam University, Department of Biology\t\t\t",
"HNHPS\ts\tHunan Hupingshan National Nature Reserve\t\t\t",
"HNHR\ts\tUniversity of California, Hastings Natural History Reservation\t\t\t",
"HNIP\ts\tHanoi College of Pharmacy\t\t\t",
"HNL\ts\tConseil National des Sciences\t\t\t",
"HNM\ts\tEcole Normale Superieure de Nouakchott\t\t\t",
"HNMN\ts\tUniversidad Centroamericana\t\t\t",
"HNN\ts\tHorniman Museum of Natural History\t\t\t",
"HNNU\ts\tHunan Normal University, Botany Department\t\t\t",
"HNPGBI\ts\tSeed and Plant Improvement Institute\t\t\t",
"HNR\ts\tHeilongjiang Academy of Sciences\t\t\t",
"HNT\ts\tHuntington Botanical Gardens\t\t\t",
"HNTS\ts\tVlastivedne muzeum\t\t\t",
"HNU<CHN>\ts\tHunan Normal University\t\t\t",
"HNU<VNM>\ts\tVietnam National University, Department of Botany\t\t\t",
"HNUB\ts\tNortheastern University, Biology Department\t\t\t",
"HNUE\ts\tHanoi National University of Education\t\t\t",
"HNUL\ts\tNorthwestern University Inc.\t\t\t",
"HNUP\ts\tMaringa State University\t\t\t",
"HNWP\ts\tNorthwest Plateau Institute of Biology, Chinese Academy of Sciences\t\t\t",
"HNWU\ts\tNebraska Wesleyan University, Biology Department\t\t\t",
"HO\ts\tTasmanian Museum & Art Gallery\t\t\t",
"HOH\ts\tUniversitaet Hohenheim (210)\t\t\t",
"HOL\ts\tHolden Arboretum\t\t\t",
"HOLZ\ts\tPaleontological Collection\t\t\t",
"HOMP\ts\tOkresni muzeum Pribram Brezove Hory\t\t\t",
"HON\ts\tSichuan Grassland Research Institute\t\t\t",
"HOXA\ts\tEstacion biologica del Jardin Botanico de Missouri\t\t\t",
"HPAN\ts\tUniversity of the State of Mato Grosso, UNEMAT\t\t\t",
"HPBR\ts\tUniversidade Regional Integrada do Alto Uruguai e das Missoes\t\t\t",
"HPC\ts\tHoward Payne University, Biology Department\t\t\t",
"HPD\ts\tHampstead Scientific Society\t\t\t",
"HPDL\ts\tHampstead Public Library\t\t\t",
"HPH\ts\tMonroe County Department of Parks\t\t\t",
"HPL\ts\tJardim Botanico Plantarum\t\t\t",
"HPM\ts\tHouston Museum of Natural Science\t\t\t",
"HPNP\ts\tPumat National Park\t\t\t",
"HPP\ts\tUniversity of Helsinki, Plant Biology Department\t\t\t",
"HPPR\ts\tInstituto Superior Pedagogico de Pinar del Rio, Departamento de Biologia\t\t\t",
"HPSU\ts\tPortland State University, Biology Department\t\t\t",
"HPU\ts\tHigh Point University, Biology Department\t\t\t",
"HPU<USA-HI>\ts\tHawaii Pacific University\t\t\t",
"HPUJ\ts\tPontificia Universidad Javeriana\t\t\t",
"HPVC\ts\tUniversidad Pedagogico Felix Varela,, Departamento de Biologia\t\t\t",
"HR\ts\tMuzeum Vychodnich Cech\t\t\t",
"HRB\ts\tIBGE\t\t\t",
"HRCB\ts\tUniversidade Estadual Paulista\t\t\t",
"HREC\ts\tHopland Research & Extension Center\t\t\t",
"HRJ\ts\tUniversidade do Estado do Rio de Janeiro, Departamento de Biologia Animal e Vegetal\t\t\t",
"HRP\ts\tUniversidad Nacional de La Patagonia, Departamento Biologia General\t\t\t",
"HSB\ts\tUniversidad Mayor Real y Pontificia de San Francisco Xavier de Chuquisaca\t\t\t",
"HSBU\ts\tShahid Beheshti University\t\t\t",
"HSC\ts\tHumboldt State University, Biological Sciences Department\t\t\t",
"HSCC\tc\tCulture Collection of the Research and Development Department\t\t\t",
"HSI\ts\tUniversity of Helsinki, Silviculture Department\t\t\t",
"HSIB\ts\tShanxi Institute of Biology, Botany Department\t\t\t",
"HSIC\ts\tMinistry of Natural Resources, Solomon Islands\t\t\t",
"HSM\ts\tChrist's Hospital, Biology Department\t\t\t",
"HSMC\ts\tWhyte Thorne Botanic Garden\t\t\t",
"HSNU\ts\tEast China Normal University, Biology Department\t\t\t",
"HSP\ts\tInstituto Cientifico Michael Owen Dillon\t\t\t",
"HSS\ts\tDevelopment, Technological and Investigacion Service, Forest Production Department\t\t\t",
"HSTM\ts\tUniversidade Federal do Oeste do Para\t\t\t",
"HSU<USA-CA>\ts\tHumboldt State University\t\t\t",
"HSU<USA-CA>:Amphibian\ts\tHumboldt State University, Amphibian Collection\t\t",
"HSU<USA-CA>:Birds\ts\tHumboldt State University, Birds collection\t\t",
"HSU<USA-CA>:Mammal\ts\tHumboldt State University, Mammals collection\t\t",
"HSU<USA-CA>:Reptile\ts\tHumboldt State University, Reptile collection\t\t",
"HSU<USA-TX>\ts\tHardin-Simmons University, Biology Department\t\t\t",
"HSUCV\ts\tHardin-Simmons University, Collection of Vertebrates\t\t\t",
"HSUD\ts\tStation of Nature Research and Environmental Education\t\t\t",
"HSUE\ts\tNatural History Museum, Addis Ababa\t\t\t",
"HSUMZ\ts\tHenderson State University, Museum of Zoology\t\t\t",
"HSUVM\ts\tHumboldt State University Vertebrate Museum\t\t\t",
"HSUVM:Bird\ts\tHumboldt State University Vertebrate Museum, Bird Collection\t\t",
"HSUVM:Herp\ts\tHumboldt State University Vertebrate Museum, Herpetology Collection\t\t",
"HSUVM:Mamm\ts\tHumboldt State University Vertebrate Museum, Mammal collection\t\t",
"HT\ts\tHerbario Tropical S.A.S.\t\t\t",
"HTC\ts\tHangzhou Normal College, Biology Department\t\t\t",
"HTD\ts\tCollege Natural History Society\t\t\t",
"HTE\ts\tQueen Ethelburga's School\t\t\t",
"HTGN\ts\tNorris Museum and Library\t\t\t",
"HTIN\ts\tUniversidad Nacional Agraria de la Selva\t\t\t",
"HTN\ts\tHitchin Museum\t\t\t",
"HTO\ts\tUniversidade Federal do Tocantins, Nucleo de Estudos Ambientais\t\t\t",
"HTTU\ts\tTennessee Technological University, Biology Department\t\t\t",
"HTU\ts\tUniversity of Taiz, Biology Department\t\t\t",
"HTW\ts\tUniversidad Nacional de la Patagonia San Juan Bosco\t\t\t",
"HU\ts\tUniversity of Zhejiang\t\t\t",
"HUA\ts\tUniversidad de Antioquia, Centro de Investigaciones\t\t\t",
"HUAA\ts\tUniversidad Autonoma de Aquascalientes, Departamento de Biologia\t\t\t",
"HUAL\ts\tUniversidad de Almeria, Departamento de Biologia Vegetal y Ecologia\t\t\t",
"HUAM\ts\tUniversidade Federal do Amazonas\t\t\t",
"HUAP\ts\tHerbario, Universidad Autonoma de Puebla\tBUAP\t\t",
"HUAZ\ts\tUniversidad de la Amazonia\t\t\t",
"HUB\ts\tHacettepe University, Botany Department\t\t\t",
"HUBE\ts\tGolden West College, Biology/Life Sciences Department\t\t\t",
"HUBO\ts\tUniversita degli Studi di Bologna\t\t\t",
"HUC\ts\tUniversidad de Cordoba, Departamento de Biologia\t\t\t",
"HUCM\ts\tHunan College of Traditional Chinese Medicine, Department of Chinese Materia Medica\t\t\t",
"HUCP\ts\tPontifica Universidade Catolica do Parana, Departamento de Ciencias Biologicas\t\t\t",
"HUCS\ts\tUniversity of  Caxias do Sul\t\t\t",
"HUDC\ts\tHoward University, Biology Department\t\t\t",
"HUE\ts\tHunan Education College, Biology Department\t\t\t",
"HUEF\ts\tHacettepe Ueniversitesi\t\t\t",
"HUEFS\ts\tUniversidade Estadual de Feira de Santana, Departamento de Ciencias Biologicas\t\t\t",
"HUEG\ts\tUniversidade Estadual de Goias\t\t\t",
"HUEM\ts\tUniversidade Estadual de Maringa, Departamento de Biologia\t\t\t",
"HUESB\ts\tUniversidade Estadual do Sudoeste da Bahia-Campus de Jequie\t\t\t",
"HUESBVC\ts\tUniversidade Estadual do Sudoeste da Bahia-Vitoria  da Conquista\t\t\t",
"HUF\ts\tHunan Forestry School\t\t\t",
"HUFABC\ts\tUniversidade Federal do ABC\t\t\t",
"HUFSJ\ts\tUniversidade Federal de Sao Joao del-Rei\t\t\t",
"HUFSP\ts\tUniversidade Federal de Sao Paulo\t\t\t",
"HUFU\ts\tUniversidade Federal de Uberlandia, Instituto de Biologia\t\t\t",
"HUHE\ts\tHaramaya University\t\t\t",
"HUI\ts\tUniversity of Isfahan\t\t\t",
"HUIC\ts\tHacettepe University Ichthyological Collection\t\t\t",
"HUIF\ts\tHunan Forestry Institute\t\t\t",
"HUIRB\ts\tFundacao de Integracao, Desenvolvimento e Educacao do Noroeste do Estado do Rio Grande do Sul - FIDENE / Universidade Regional do Noroeste do Estado do Rio Grande do Sul - UNIJUI\t\t\t",
"HUJ\ts\tHebrew University of Jerusalem\t\t\t",
"HUJ:INV\ts\tHebrew University of Jerusalem, Invertebrate collection\t\t",
"HUJ:R\ts\tHebrew University of Jerusalem, Reptie collection\t\t",
"HUKUK\tc\tCulture Collection of Animal Cells\t\t\t",
"HUL\ts\tFine Arts Museum\t\t\t",
"HULE\ts\tUniversidad Nacional Autonoma de Nicaragua, Departamento de Biologia\t\t\t",
"HUM\ts\tHumbolt University Zoologischen Museum\t\t\t",
"HUMC\ts\tUniversidade de Mogi das Cruzes\t\t\t",
"HUMO\ts\tUniversidad Autonoma del Estado de Morelos, Centro de Educacion Ambiental e Investigacion Sierra de Huautla\t\t\t",
"HUMP\ts\tMuzeum v Humpolci\t\t\t",
"HUMZ\ts\tHokkaido University, Laboratory of Marine Zoology\t\t\t",
"HUMZ<IRN>\ts\tUniversity of Mazandaran\t\t\t",
"HUNEB\ts\tUniversidade do Estado da Bahia\t\t\t",
"HUNI\ts\tUniversidade Federal do Estado do Rio de Janeiro\t\t\t",
"HUNST\ts\tHunan University of Science and Technology\t\t\t",
"HUNT\ts\tHuntington University\t\t\t",
"HUP\ts\tHazara University\t\t\t",
"HUPG\ts\tState University of Ponta Grossa, Departamento de Biologia\t\t\t",
"HUQ\ts\tUniversidad del Quindio\t\t\t",
"HURB\ts\tUniversidade Federal do Reconcavo da Bahia\t\t\t",
"HURG\ts\tUniversidade do Rio Grande, Departamento de Ciencias Morfo-Biologicas\t\t\t",
"HUS\ts\tSiauliai University\t\t\t",
"HUSA\ts\tUniversidad Nacional de San Agustin de Arequipa, Facultad de Ciencias Biologicas y Agropecuarias, Area de Biomedicas\t\t\t",
"HUSC\ts\tUniversidade Santa Cecilia - UNISANTA\t\t\t",
"HUSEC<DEU>\tc\tKonsiliarlabor fur Hamolytisch-Uramisches Syndrom\t\t\t",
"HUST\ts\tHunan University of Science and Technology, School of Life Sciences\t\t\t",
"HUT<JPN>\tc\tHUT Culture Collection\t\t\t",
"HUT<PER>\ts\tHerbarium Truxillense, Universidad Nacional de La Libertad-Trujillo\t\t\t",
"HUTB\ts\tHainan University\t\t\t",
"HUTI\ts\tUniversidad Tecnologica Indoamerica\t\t\t",
"HUTM\ts\tHunan Academy of Traditional Chinese Medicine and Pharmacy\t\t\t",
"HUTO\ts\tFundacao Universidade do Tocantins , UNITINS\t\t\t",
"HUTPL\ts\tUniversidad Tecnica Particular De Loja\t\t\t",
"HUVA\ts\tUniversidade Estadual Vale do Acarau\t\t\t",
"HVASF\ts\tUniversidade Federal do Vale do Sao Francisco\t\t\t",
"HVAT\ts\tUniversity of Vale do Taquari - Univates\t\t\t",
"HVR\ts\tUniversidade de Tras-os-Montes e Alto Douro\t\t\t",
"HWA\ts\tSouthwest Agricultural University, Department of Biological Basic Courses\t\t\t",
"HWB\ts\tHarrow School, Biology Department\t\t\t",
"HWBA\ts\tBenedictine College, Biology Department\t\t\t",
"HWD\ts\tHollinwood Botanists' and Field Naturalists' Society\t\t\t",
"HWML<USA>\ts\tHoward W. Manter Laboratory of Parasitology\tUNSM:HWML\t\t",
"HXBH\ts\tFundacao CETEC\t\t\t",
"HXC\ts\tHendrix College, Biology Department\t\t\t",
"HY\ts\tOsmania University, Botany Department\t\t\t",
"HYD\ts\tHeywood and District Botanical Society\t\t\t",
"HYO\ts\tMuseum of Nature and Human Activities\t\t\t",
"HYOGO\ts\tMuseum of Nature and Human Activities\t\t\t",
"HZI<DEU>\tc\tHelmholtz Zentrum fur Infektionsforschung (Helmholtz Centre for Infection Research)\t\t\t",
"HZM\ts\tMuseum of Natural History (Hrvatski Zooloski Muzej)\t\t\t",
"HZMZ\ts\tHrvatski Narodni Zooloski Muzej\t\t\t",
"HZTC\ts\tHanzhong Teachers College, Biology Department\t\t\t",
"HZU\ts\tZhejiang University\t\t\t",
"I\ts\t\"Alexandru Ioan Cuza\" University\t\t\t",
"IA\ts\tUniversity of Iowa, Department of Biological Sciences\t\t\t",
"IAA\ts\tInstituto Antarctico Argentinao, Direccion Nacional del Antartico\t\t\t",
"IAAA\ts\tInstituto do Acucar e do Alcool\t\t\t",
"IABH\ts\tAl-Bayt University, Biology Department\t\t\t",
"IABHU<JPN>\tscb\tInstitute for Amphibian Biology, Graduate School of Science, Hiroshima University\t\t\t",
"IAC\ts\tInstituto Agronomico de Campinas\t\t\t",
"IACC\ts\tInstituto Agronomico de Campinas\t\t\t",
"IACM\ts\tInstituto Agronomico\t\t\t",
"IADIZA-CM\ts\tInstituto Argentino de Investigaciones de las Zonas Aridas\t\t\t",
"IAFB\tc\tCulture Collection of Industrial Microorganisms, Prof. Wac&#322;aw D&#261;browski Institute of Agricultural and Food Biotechnology\t\t\t",
"IAGB\ts\tBotanical Garden \"Anastasie Fatu\" of Iasi\t\t\t",
"IAL<BRA-Bahia>\ts\tHerbario, Centro Nacional de Pesquisa de Mandioca e Fruticultura, EMBRAPA\t\t\t",
"IAL<BRA-SaoPaulo>\tc\tSecao de Colecao de Culturas\t\t\t",
"IALCEL\tc\tSecao de Culturas Celulares\t\t\t",
"IALMIC\tc\tMicoteca do Insituto Adolfo Lutz\t\t\t",
"IAM\tc\tIAM Culture Collection, Center for Cellular and Molecular Research\t\t\t",
"IAM<RUS>\ts\tNational Alliance of Shidlovskiy \"Ice Age\", Ice Age Museum\t\t\t",
"IAN\ts\tEmbrapa Amazonia Oriental\t\t\t",
"IAPG\ts\tInstitute of Animal Physiology and Genetics, Academy of Sciences of the Czech Republic\t\t\t",
"IARI\tsb\tIndian Agricultural Research Institute\t\t\t",
"IASI\ts\tUniversitatea Agronomica, Disciplina de Botanica\t\t\t",
"IAUGH\ts\tIslamic Azad University Garmsar\t\t\t",
"IAUH\ts\tIslamic Azad University (Avicenna Herbarium)\t\t\t",
"IAUM\ts\tIslamic Azad University of Mashhad\t\t\t",
"IAUNT\ts\tIslamica Azad University, North Tehran Branch\t\t\t",
"IAV\tsb\tInstitut Agronomique et Veterinaire Hassan II, Departement d'Ecologie Vegetale\t\t\t",
"IAVH\tsb\tInstituto de Ivestigacion de los Recursos Biologicos Alexander von Humboldt\t\t\t",
"IAVH:A\tsb\tInstituto de Ivestigacion de los Recursos Biologicos Alexander von Humboldt, Ornithological Collection\t\t",
"IAVH:CT\tsb\tInstituto de Ivestigacion de los Recursos Biologicos Alexander von Humboldt, Tissue Collection\t\t",
"IB\ts\tUniversitat Innsbruck\t\t\t",
"IBA<ESP>\ts\tInstituto Asturiano de Taxonomia y Ecologia Vegetal\t\t\t",
"IBA<POL>\tc\tCollection of Microorganisms Producing Antibiotics\t\t\t",
"IBAAN\ts\tAKE-ASSI HERBARIUM, Institut Botanique Ake-Assi d'Andokoi\t\t\t",
"IBAR\ts\tIbaraki University (Herbarium of Systematic Mycology)\t\t\t",
"IBAUNC\ts\tUniversidad Nacional de Cuyo, Instituto de Biologia Animal\tIBMUNC\t\t",
"IBBS\ts\tInsitute of Biology and Soil Science, Russian Academy of Sciences\t\t\t",
"IBE\ts\tInstitute for Botanical Exploration\t\t\t",
"IBE<ESP>\ts\tInstitut de Biologia Evolutiva, (CSIC-UPF)\t\t\t",
"IBEF\ts\tMuseum of the Izumi Board of Education\t\t\t",
"IBF\ts\tTiroler Landesmuseum Ferdinandeum\t\t\t",
"IBGE\ts\tReserva Ecologica do IBGE\t\t\t",
"IBH\ts\tUniversidad Nacional Autonoma de Mexico, Instituto de Biologia\t\t\t",
"IBI\ts\tInstituto Biologico, Laboratorio de Micologia\t\t\t",
"IBIR\ts\tInstitutul Agronomic\t\t\t",
"IBIW\ts\tI. D. Papanin Institute for Biology of Inland Waters\t\t\t",
"IBK\ts\tGuangxi Institute of Botany\t\t\t",
"IBK<UKR>\tc\tMushroom Culture Collection of the M.G. Kholodny Institute of Botany\t\t\t",
"IBL<ISR>\ts\tIndependent Biological Laboratories\t\t\t",
"IBL<POL>\ts\tForest Research Institute, Poland\t\thttp://www.ibles.pl/\t",
"IBL<PRT>\tc\tBotanical Institute, Lisbon Faculty of Sciences\t\t\t",
"IBL<USA-MD>\tc\tInsect Biocontrol Laboratory (USDA-ARS, Beltsville)\t\t\t",
"IBLP\ts\tInstytut Badawczy Lesnictwa\t\t\t",
"IBMUNC\ts\tUniversidad Nacional de Cuyo, Instituto de Biologia Animal\tIBAUNC\t\t",
"IBP\ts\tInstituto de Biologia do Parana\t\t\t",
"IBPPM\tc\tInstitute of Biochemistry and Physiology of Plants and Microorganisms of the Russian Academy of Sciences\t\t\t",
"IBRC\tsc\tIranian Biological Resource Center\t\t\t",
"IBRG\ts\tMacquarie University Indigenous Bioresources Research Group (IBRG)\t\t\t",
"IBRP<BRA>\ts\tInstituto Biologico de Ribeirao Preto\t\t\t",
"IBRP<JPN>\ts\tInstitute for Breeding Research, Tokyo University of Agriculture\t\t\t",
"IBS\ts\tIrish Biogeographical Society\t\t\t",
"IBSBF\tc\tBiological Institute Culture Collection of Phytopathogenic Bacteria\t\t\t",
"IBSC\ts\tSouth China Botanical Garden\t\t\t",
"IBSD\ts\tDinghushan Biosphere Reserve\t\t\t",
"IBSP\ts\tInstituto Biologico de Sao Paulo\t\t\t",
"IBT\tc\tIBT Culture Collection of Fungi, Mycology Group, Technical University of Denmark\t\t\t",
"IBTS\ts\tInstitutul de Biologie, Tr. Savulescu\t\t\t",
"IBUG\ts\tUniversidad de Guadalajara\t\t\t",
"IBUNAM\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico\tUNAM\t\t",
"IBUNAM:CFB\tb\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion de Fotocolectas Biologicas\t\t",
"IBUNAM:CNAC\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Acaros\t\t",
"IBUNAM:CNAN\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Aracnidos\t\t",
"IBUNAM:CNAR\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Anfibios y Reptiles\t\t",
"IBUNAM:CNAV\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Aves\t\t",
"IBUNAM:CNCR\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Crustaceos\t\t",
"IBUNAM:CNHE\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Helmintos\t\t",
"IBUNAM:CNIN\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Insectos\t\t",
"IBUNAM:CNMA\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Mamiferos\t\t",
"IBUNAM:CNMO\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Moluscos\t\t",
"IBUNAM:CNPE\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Coleccion Nacional de Peces\t\t",
"IBUNAM:MEXU\ts\tInstituto de Biologia, Universidad Nacional Autonoma de Mexico, Herbario Nacional\t\t",
"IBUNAM<CNIN>\ts\tColeccion Nacional de Insectos, Universidad Nacional Autonoma de Mexico\tIBUNAM:CNIN\t\t",
"IBUP\ts\tInstitute of Biology\t\t\t",
"IBUS\ts\tUniversidade Federal do Rio de Janeiro\t\t\t",
"IBUT\ts\tInstituto Butanta\t\t\t",
"IBY\ts\tBotanical Institute of Guangxi\t\t\t",
"ICA\ts\tInstituto Colombiano Agropecuario, Tibaitata\t\t\t",
"ICAR\ts\tICAR-Central Arid Zone Research Institute\t\t\t",
"ICARDA<SYR>\tsb\tInternational Center for Agricultural Research in the Dry Areas\t\t\t",
"ICBB\tc\tICBB Culture Collection for Microorganisms and Cell Culture\t\t\t",
"ICBR\ts\tInternational Centre for Bamboo and Rattan\t\t\t",
"ICBU\ts\tBishop's University, Natural History Museum\t\t\t",
"ICCF\tc\tCollection of Industrial Microorganisms\t\t\t",
"ICEB\ts\tEurouniversity\t\t\t",
"ICEL\ts\tIcelandic Institute of Natural History\t\t\t",
"ICESI\ts\tHerbario Icesi, Universidad ICESI\t\t\t",
"ICF\ts\tINIFAP\t\t\t",
"ICFC\tc\tIIB-INTECH Collection of Fungal Cultures\t\t\t",
"ICGC\ts\tIstituto Calasanzio\t\t\t",
"ICH\ts\tIranian Research Organization for Science and Technology (IROST)\t\t\t",
"ICHUM\ts\tInvertebrate Collection of the Hokkaido University Museum\t\t\t",
"ICI\tc\tImperial Chemical Industries Ltd.\t\t\t",
"ICIS\ts\tIdaho Museum of Natural History\t\t\t",
"ICM\ts\tInstituto de Ciencias del Mar\tICMD\t\t",
"ICMP\tc\tInternational Collection of Microorganisms from Plants\tPDDCC \thttp://scd.landcareresearch.co.nz/Specimen/ICMP_&spec;\t",
"ICN<BRA>\ts\tUniversidade Federal do Rio Grande do Sul, Departamento de Botanica\t\t\t",
"ICN<COL>\tsb\tInstituto de Ciencias Naturales, Museo de Historia Natural\t\t\t",
"ICN<COL>:Aves\tsb\tInstituto de Ciencias Naturales, Museo de Historia Natural, Ornithological collection\t\t",
"ICP\ts\tIslamia College, University of Peshawar, Botany Department\t\t\t",
"ICPB\tc\tInternational Collection of Phytopathogenic Bacteria\t\t\t",
"ICPPB\ts\tInternational Collection of Plant Pathogenic Bacteria\t\t\t",
"ICPR\ts\tBiological Control Research Institute\t\t\t",
"ICRC\ts\tInsect Control and Research\t\t\t",
"ICRG\ts\tInstitute of Entomology\t\t\t",
"ICRI\ts\tZhonghan (Sun Yat-Sen) University, Research Institute of Entomology\t\t\t",
"ICRISAT\tb\tInternational Crops Research for the Semi-Arid Tropics\t\t\t",
"ICS-CC<ZAF>\tc\tInfection Control Services , National Health Laboratory Service 3\t\t\t",
"ICST\ts\tImperial College of Science, Technology & Medicine, Department of Biological Sciences\t\t\t",
"ICUI\ts\tUniversity of Iowa\t\t\t",
"ICVI\ts\tThe Volcani Center\t\t\t",
"ID\ts\tUniversity of Idaho, Biological Sciences Department\t\t\t",
"IDAC\tcb\tThe International Depositary Authority of Canada\t\t\t",
"IDB\tsb\tKoltzov Institute of Developmental Biology Russian Academy of Sciences\t\t\t",
"IDEA\ts\tInstituto de Agronomia\t\t\t",
"IDF\ts\tUniversity of Idaho\t\t\t",
"IDS\ts\tIdaho State University, Biological Sciences Department\t\t\t",
"IE\tsc\tCepario de Hongos del Instituto de Ecologia\t\t\t",
"IEA\ts\tInstituto DI Entomologia Agraria\t\t\t",
"IEAB\ts\tIstituto di Entomologia Agraria dell'Universita\t\t\t",
"IEAM\ts\tIstituto di Entomologia dell'Universita degli Studi [= Istituto di Entomologia Agraria dell'Universita, Milan]\t\t\t",
"IEAP\ts\tIstituto di Entomologia Agraria dell'Universita\t\t\t",
"IEAPM\tc\tInstituto de Estudos do Mar \"Almirante Paulo Moreira\"\t\t\t",
"IEAS\ts\tInstitute of Entomology\t\t\t",
"IEAU\ts\tIstituto di Entomologia Agraria dell'Universita\t\t\t",
"IEB\ts\tInstituto de Ecologia, A.C.\t\t\t",
"IEBC\tc\tInternational Entomopathogenic Bacillus Centre (WHO)\t\t\t",
"IEBR\ts\tInstitute of Ecology and Biological Resources\t\t\t",
"IEC\ts\tCentre D'Etude sur les Ressources Vegetales\t\t\t",
"IECA\ts\tCzech Academy of Science, Institute of Entomology\t\t\t",
"IEEUACH\ts\tUniversidad Austral de Chile, Instituto de Ecologia y Evolucion\t\t\t",
"IEGG\ts\tUniversita di Bologna, Istituto di Entomologia \"Guido Grandi\"\t\t\t",
"IEGM\tc\tRegional Specialized Collection of Alkanotrophic Microorganisms\t\t\t",
"IEI\ts\tInstitut d'Estudis Ilerdencs\t\t\t",
"IEM\tc\tCzech National Collection of Type Cultures\t\t\t",
"IEME\ts\tInstitute for Evolution, Morphology, and Ecology of Animals\t\t\t",
"IEMM\ts\tInstituto de Ecologia\t\t\t",
"IENU\ts\tIstituto di Entomologia, Universita degli Studi\t\t\t",
"IEPA\ts\tIstituto di Entomologia Agraria dell'Universita\t\t\t",
"IER\ts\tInstitut d'Economie Rurale\t\t\t",
"IEUC\ts\tIstituto di Entomologia Agraria dell'Universita Cattolica\t\t\t",
"IEUP\ts\tIstituto di Entomologia, Universita degli Studi\t\t\t",
"IEVB\ts\tInstitut de Zoologie [Institut Ed. Van Beneden]\t\t\t",
"IFAM\tc\tInstitut fur Allgemeine Mikrobiologie\t\t\t",
"IFAN\ts\tInstitut Fondamental d'Afrique Noire\t\t\t",
"IFBM\tc\tStreptokokken Sammlung\t\t\t",
"IFE\ts\tObafemi Awolowo University, Botany Department\t\t\t",
"IFFB\ts\tInstitut fuer Forstenentomologie und Forstschutz\t\t\t",
"IFG<USA-CA>\ts\tInstitute of Forest Genetics\t\t\t",
"IFGD\ts\tIdaho Fish and Game\t\t\t",
"IFGH\ts\tIdaho Fish and Game Department\t\t\t",
"IFGP\ts\tPacific Southwest Research Station, USDA Forest Service\t\t\t",
"IFI\ts\tImperial Fisheries Institute\t\t\t",
"IFM<AUS>\tc\tIFM Quality Services Pty Ltd\t\t\t",
"IFM<JPN>\tc\tResearch Center for Pathogenic Fungi and Microbial Toxicoses, Chiba University\t\t\t",
"IFO\tc\tInstitute for Fermentation\t\t\t",
"IFP\ts\tInstitute of Applied Ecology, Academia Sinica\t\t\t",
"IFRD\ts\tResearch Institute of Resource Insects\t\t\t",
"IFRDCC\tc\tInternational Fungal Research and Development Culture Collection\t\t\t",
"IFREMER\ts\tInstitut Francais pour l'Etude de la Mer\t\t\t",
"IFRI\ts\tIndian Forest Research Institute\t\t\t",
"IFRPD\tc\tInstitute of Food Research and Product Development, Kasetsart University\t\t\t",
"IFSA\ts\tInstituto Florestal\t\t\t",
"IG\ts\tInstitute of Geology\t\t\t",
"IGA\ts\tWetland Herbarium, Northeast Institute of Geography and Agroecology, Chinese Academy of Sciences\t\t\t",
"IGB<ISR>\tsb\tIsrael Plant Gene Bank\t\t\t",
"IGC\tc\tPortuguese Yeast Culture Collection\t\t\t",
"IGCAGS\ts\tInstitute of geology, Chinese Academy of Geological Science\t\t\t",
"IGCU\ts\tInstituto de Geologia, Ciudad Universitaria\t\t\t",
"IGESALQ\tc\tColecao Microorganismos\t\t\t",
"IGF\ts\tInstituto di Geologia e Paleontologia\t\t\t",
"IGGDC\ts\tInstitute of Geology and Geophysics, Chinese Academy of Sciences\t\t\t",
"IGL\ts\tInstitute fuer Geowissenschaften Leoben\t\t\t",
"IGM<MEX>\ts\tInstituto de Geologia\t\t\t",
"IGM<MNG>\ts\tGeological Institute, Mongolian Academy of Sciences\t\t\t",
"IGPH\ts\tInstitut fuer Geologie und Palaeontologie der Universitat Hannover\t\t\t",
"IGUS\ts\tUniversitat des Saarlandes\t\t\t",
"IGWH\ts\tInstitut fuer Geowissenschaften aus dem Martin-Lurther- Universitat\t\t\t",
"IH\ts\tInstituto de Segunda Ensenanza de La Habana\t\t\t",
"IHASW\ts\tInstitute of Hydrobiology, Academia Sinica\t\t\t",
"IHB\ts\tInstitute of Hydrobiology, Chinese Academy of Sciences\t\t\t",
"IHCAS\ts\tMuseum of Institute of Hydrobiology, Chainese Academy of Sciences\t\t\t",
"IHUG\ts\tInstitut fuer Hygiene der Iniversitaet\t\t\t",
"IIBM-UNAM\tc\tIndustrial Culture Collection\t\t\t",
"IIBUV\ts\tInvestigaciones Biologicas de la Universidad Veracruzana (Mexico)\t\t\t",
"IICT\ts\tCentro de Zoologia do I.I.C.T.\t\t\t",
"IID\tc\tLaboratory Culture Collection\t\t\t",
"IIES\ts\tInstituto Investigaciones Entomologicas Salta\t\t\t",
"IITA\tb\tInternational Institute of Tropical Agriculture\t\t\t",
"IJ\ts\tInstitute of Jamaica\t\t\t",
"IJFM\tc\tInstituto Jaime Ferran de Microbiologia Consejo Superior de Investigaciones Cientificas\t\t\t",
"IJSM\ts\tInstitute of Jamaica, Natural History Museum\t\t\t",
"IK\ts\tZoological Institute, Ukrainian Academy of Sciences\t\t\t",
"ILCA\ts\tInternational Livestock Research Institute\t\t\t",
"ILF\ts\tIflracombe Museum\t\t\t",
"ILH\ts\tIowa Lakeside Laboratory\t\t\t",
"ILL\tsc\tUniversity of Illinois, Plant Biology Department\t\t\t",
"ILLS\ts\tIllinois Natural History Survey\t\t\t",
"ILMA\ts\tIstituto Leonardo Murialdo\t\t\t",
"ILPLA\ts\tMuseo de La Plata, Instituto de Limnologia\t\t\t",
"IM<CUB>\ts\tInstituto de Segunda Ensenanza de Matanzas\t\t\t",
"IM<IND>\ts\tIndian Museum\t\t\t",
"IMAGE\tb\tThe I.M.A.G.E Consortium\t\t\t",
"IMARPE\ts\tInstituto del Mar del Peru\t\t\t",
"IMAS\tc\tInstitute for Marine and Antarctic Studies\t\t\t",
"IMAU\tc\tInner Mongolia Agricultural University, Key Laboratory of Dairy Biotechnology and Engineering\t\t\t",
"IMC\ts\tSichuan Academy of Traditional Chinese Medicine and Pharmacy\tIMPC\t\t",
"IMCC\tc\tInha Microbe Culture Collection, Inha University\t\t\t",
"IMCN\ts\tInstituto Vallecaucano de Investigaciones Cientificas\t\t\t",
"IMD\tc\tIndustrial Microbiology Dublin\t\t\t",
"IMD<CHN>\ts\tInstitute of Medicinal Plant Development, Chinese Academy of Medical Sciences\t\t\t",
"IMDC\ts\tInner Mongolia Institute for Drug Control\t\t\t",
"IMDY\ts\tChinese Academy of Medical Sciences, Yunnan Branch\t\t\t",
"IMET\tc\tNational Kurturensammlung fuer Mikroorganismen\t\t\t",
"IMFA\ts\tInner Mongolia Academy of Forestry\t\t\t",
"IMI\tsc\tCABI Genetic Resource Collection\tCABI,CMI\thttp://www.herbimi.info/herbimi/specimen.htm?imi=&spec;\t",
"IML\ts\tInstituto Miguel Lillo\t\t\t",
"IMLA\ts\tFundacion e Instituto Miguel Lillo\t\t\t",
"IMM<CHN-Bejing>\ts\tChinese Academy of Medical Science\t\t\t",
"IMM<CHN-Hohhot>\ts\tInner Mongolian Museum\t\t\t",
"IMMH\tc\tCollection of Animal Viruses\t\t\t",
"IMMIB\tc\tCulture Collection of the Institute of Medical Microbiology and Immunology of the University of Bonn\t\t\t",
"IMPC\ts\tSichuan Academy of Traditional Chinese Medicine and Pharmacy\tIMC\t\t",
"IMPH\ts\tInstitute of Medicinal Plants, ACECR\t\t\t",
"IMRU\tc\tWaksman Institute of Microbiology\t\t\t",
"IMS<TZA>\ts\tInstitute of Marine Sciences\t\t\t",
"IMS<USA-NC>\ts\tUniversity of North Carolina at Chapel Hill\t\t\t",
"IMSNU\tc\tInstitute of Microbiology, Seoul National University\t\t\t",
"IMSSM\ts\tInstituto Mexicano del Seguro Social\t\t\t",
"IMT<BRA>\tc\tMicoteca do Instituto de Medicina Tropical de Sao Paulo\t\t\t",
"IMT<JPN>\ts\tImperial Museum\t\t\t",
"IMTU\ts\tInstitute of Medicine, Community Medicine Department\t\t\t",
"IMUFRJ\tc\tInstituto de Microbiologia of Universidade Federal do Rio de Janeiro\t\t\t",
"IMUR\tc\tInstitute of Mycology, University of Recife, Recife\t\t\t",
"IMVS\tc\tIMVS Culture Collection\t\t\t",
"IMYZA\tc\tInstituto de Microbiologia y Zoologia Agricola\t\t\t",
"IN\ts\tInfoBoss Cyber Herbarium\t\t\t",
"INA<PRT>\ts\tInstituto Nun'Alvres, Departamento de Biologia\t\t\t",
"INA<RUS>\tc\tCulture Collection of the Institute of New Antibiotics\t\t\t",
"InaCC\tc\tIndonesian Culture Collection, Research Center for Biology, Indonesian Institute of Sciences\t\t\t",
"INALI\ts\tInstituto Limnologia\t\t\t",
"iNAT\ts\tiNaturalist\t\thttps://www.inaturalist.org/observations/\t",
"INB\ts\tInstituto Nacional de Biodiversidad, Departamento de Botanica\t\t\t",
"INBC\ts\tInstituto Nacional de Biodiversidad (INBio)\t\t\t",
"INBIO\ts\tNational Biodiversity Institute, Costa Rica\t\t\t",
"INBP\ts\tInventorio Biologico Nacional [Museo Nacional de Historia Natural del Paraguay]\t\t\t",
"INC\ts\tInstituto Nacional de Cultura, Museo de Ciencias Naturales (Panama)\t\t\t",
"INCQS\tc\tFundacao Oswaldo Cruz-FIOCRUZ\t\t\t",
"IND\ts\tIndiana University, Department of Biology\t\t\t",
"IND-AN\ts\tAmphibian Collection\t\t\t",
"IND-M\ts\tLa Unidad de Investigacion \"Federico Medem\"-Inderena (Colombia)\t\t\t",
"INDRE\tc\tPathogen Fungi and Actinomycetes Collection\t\t\t",
"INEGI\ts\tInstituto Nacional de Estadistica Geografia e Informatica, Departamento de Botanica\t\t\t",
"INEP\ts\tInstitute of the Industrial Ecology Problems of the North of Kola Science Center of the Russian Academy of Sciences.\t\t\t",
"INER\ts\tIstituto Nazionale di Entomologia\t\t\t",
"INF\ts\tInyo National Forest\t\t\t",
"INFYB\ts\tInstituto Nacional de Farmacologia y Bromatologia, Farmacobotanica\t\t\t",
"INGU\ts\tIngush State University\t\t\t",
"INH\ts\tInstitut National d'Horticulture, Departement de Sciences Biologiques\t\t\t",
"INH<ECU>\ts\tInstituto Nacional de Higiene\t\t\t",
"INHM\ts\tIraq Natural History Museum\t\t\t",
"INHS\ts\tIllinois Natural History Survey\t\t\t",
"INIA\ts\tInstituto Nacional de Investigaciones Forestales y Agropecurias\t\t\t",
"INIA<CHL>\tsb\tEl Instituto de Investigaciones Agropecuarias\t\t\t",
"INIA<ESP>\tb\tInstituto Nacional de Investigacion y Tecnologia Agraria y Alimentaria\t\t\t",
"INIBP\ts\tInstituto Nacional de Investigaciones Biologico Pesqueras\t\t\t",
"INIDA\ts\tInstituto Nacional de Investigacao e Desenvolvimento Agrario - Cape Verde\t\t\t",
"INIDEP\ts\tInstituto Nacional de Investigacion y Desarrollo Pesquero\t\t\t",
"INIF\tc\tColeccion de Microhongos\t\t\t",
"INIFAT\tc\tINIFAT Fungus Collection\t\t\t",
"INIP\ts\tInstituto Nacional de Investigacao das Pescas\t\t\t",
"INIR\ts\tColeccion de Termitas Mexicanas\t\t\t",
"INLA\ts\tINIA Subestacion Experimental Control Biologico La Cruz\t\t\t",
"INM<JPN>\ts\tIbaraki Nature Museum\t\t\t",
"INMI\tc\tInstitute of Microbiology, Russian Academy of Sciences\t\t\t",
"INPA\ts\tInstituto Nacional de Pesquisas da Amazonia\t\t\t",
"INPA:CR\ts\tInstituto Nacional de Pesquisas da Amazonia, Crustacea Collection\t\t",
"INPA:H\ts\tInstituto Nacional de Pesquisas da Amazonia, Collection of Amphibians and Reptiles\t\t",
"INPA:ICT\ts\tInstituto Nacional de Pesquisas da Amazonia, \t\t",
"INPA:LMM\tc\tInstituto Nacional de Pesquisas da Amazonia, Laboratorio de Micologia Medica Divisao de Microbiologia e Nutricao\t\t",
"INPC\ts\tNational Pusa Collections\t\t\t",
"INRA\tb\tInstitut National de la Recherche Agronomique\t\t\t",
"INRA:CGAB\tcb\tInstitut National de la Recherche Agronomique, Collection of Germplasms of Agaricus bisporus\t\t",
"INU\ts\tInonu University\t\t\t",
"INV\ts\tInverness Museum and Art Gallery\t\t\t",
"INVA\ts\tInvergordon Academy\t\t\t",
"INVAM\tc\tInternational Culture Collection of (Vesicular) Arbuscular Mycorrhizal Fungi\t\t\t",
"INVEMAR\ts\tInstituto de Investigaciones Marinas de Punta de Betin\t\t\t",
"IO<BRA>\ts\tInstituto Oceanografico da Universidade de Sao Paulo\t\t\t",
"IO<PRT>\ts\tInstituto de Oceanografia da Universidade de Lisboa\t\t\t",
"IOAN\ts\tShirshov Institute of Oceanography\t\t\t",
"IOC\tc\tColecao de Culturas de Fungos do Instituto Oswaldo Cruz\t\t\t",
"IOCAS\ts\tInstitute of Oceanology, Chinese Academy of Sciences\t\t\t",
"IOEB\tc\tCentre de ressources biologiques oenologiques\tCRBO\t\t",
"IOH\ts\tAcademia de Ciencias\t\t\t",
"IOLR\ts\tIsrael Oceanographic & Limnological Research, Ltd. The National Institute of Oceanography\t\t\t",
"IOM\ts\tInstitute of Oceanology, Academy of Sciences\t\t\t",
"IOPM\ts\tIzu Oceanic Park Museum\t\t\t",
"IORD\ts\tTakai University, Institute of Oceanic Research and Development\t\t\t",
"IOS\ts\tInstitute of Oceanographic Sciences\t\t\t",
"IOUSP\tc\tMarine Microalgae Culture Collection\t\t\t",
"IOWA\ts\tUniversity of Iowa, Museum of Natural History\t\t\t",
"IP\tc\tDepartment of Insect Pathology, Institute of Entomology\t\t\t",
"IPA\ts\tEmpresa Pernambucana de Pesquisa Agropecuaria, IPA\t\t\t",
"IPA:germplasm bank\tb\tEmpresa Pernambucana de Pesquisa Agropecuaria, IPA, \t\t",
"IPAE<RUS>\ts\tInstitute of Plant and Animal Ecology Ural Branch of Russian Academy of Sciences\t\t\t",
"IPB<BRA>\ts\tInstituto Paranaense de Botanica\t\t\t",
"IPB<DEU>\ts\tInstitut fuer Palaeontologie\t\t\t",
"IPBIR\tb\tIntegrated Primate Biomaterials and Information Resource\t\t\t",
"IPCN\ts\tInstituto Patagonico de Ciencias Naturales\t\t\t",
"IPE\ts\tInstituto Pirenaico de Ecologia\t\t\t",
"IPEE RAS\ts\tA.N. Severtzov Institute of Ecology and Evolution, Russian Academy of Sciences\t\t\t",
"IPEF\ts\tInstitut fuer Pflanzenschutzforschung\t\t\t",
"IPFUB\ts\tInstitute for Paleontology of the Freie Universitat\t\t\t",
"IPGR<BGR>\tb\tInstitute for Plant Genetic Resources\t\t\t",
"IPHG\ts\tInstitut fur Palaeontologie und Historische Geologie\t\t\t",
"IPK\tsb\tLeibniz Institute of Plant Genetics and Crop Plant Research\t\t\t",
"IPKUP\ts\tPaleontologiscsky Institute\t\t\t",
"IPLA\tc\tInstituto de Productos Lacteos de Asturias\t\t\t",
"IPMB<DEU>\ts\tInstitut fur Pharmazie und Molekulare Biotechnologie\t\t\t",
"IPMC\ts\tInstitut Paleontologic Dr. M. Crusfafont Sabadell\t\t\t",
"IPMGO\ts\tInstitut fur Paleontologie und Museum, Gottingen Universitat\t\t\t",
"IPMY\ts\tUniversidad Pedagogica Libertador, Nucleo Maracay, Departamento de Biologia\t\t\t",
"IPN\ts\tInstituto Politecnico Nacional\t\t\t",
"IPO\ts\tPlant Research International\t\t\t",
"IPPAS\tc\tCulture Collection of Microalgae IPPAS\tIPPRAS\t\t",
"IPRN\ts\tInstituto de Pesquisas de Recursos Naturais Renovaveis\t\t\t",
"IPS\ts\tIpswich Museum\t\t\t",
"IPSLI\ts\tIpswich Literary Institute\t\t\t",
"IPSM\ts\tIpswich Museum\t\t\t",
"IPSN\ts\tInstituto de Paleontologia de Sabadella\t\t\t",
"IPT\tc\tAgrupamento de Biotecnologia, Culture Collection of Microorganisms\t\t\t",
"IPTB\ts\tInstituto de Pesquisas Tecnologicas\t\t\t",
"IPUW\ts\tInstitut fuer Palaeontologie der Universitaet Wien\t\t\t",
"IPW\ts\tInstutut fuer Palaeontologie der Uinversitaet Wurzburg\t\t\t",
"IQW\ts\tSenckenberg Forschungsinstitut und Naturmuseen\t\t\t",
"IRAG\ts\tInstitut National de la Recherche Agronomique de Antilles et Guyane\t\t\t",
"IRAI\ts\tParque da Ciencia Newton Freire Maia\t\t\t",
"IRAN\tsc\tIranian Research Institute of Plant Protection, Department of Botany\t\t\t",
"IRAQ\ts\tIraq Natural History Museum\t\t\t",
"IRBR\ts\tUniversidad de Oriente, Departamento de Biologia\t\t\t",
"IRCW\ts\tMadison, University of Wisconsin\t\t\t",
"IRD\ts\tInstitut de Recherche pour le Developpement\t\t\t",
"IRDA\ts\tAgriculture Department\t\t\t",
"IREC\ts\tInstitut de Recherches Entomologique de la Caribe\t\t\t",
"IRGC\tb\tInternational Rice Genebank Collection\t\t\t",
"IRK\ts\tSiberian Institute of Plant Physiology and Biochemistry\t\t\t",
"IRKU\ts\tIrkutsk State University, Department of Botany and Genetics\t\t\t",
"IRP\ts\tIsle Royale National Park\t\t\t",
"IRRI\tsb\tInternational Rice Research Institute\t\t\t",
"IRSAC\ts\tInstitute de Recherche Scientific en Afrique Centrale\t\t\t",
"IRSC\ts\tInstitut de Recherches Scientifiques au Congo\t\t\t",
"IRSM\ts\tInstitut Recherche Scientifique de Madagascar\t\t\t",
"IRSN\ts\tInstitut Royal des Sciences Naturelles de Belgique\t\t\t",
"IRSNB\ts\tInstitut Royal des Sciences Naturelles de Belgique\t\t\t",
"IRVC\ts\tUniversity of California, UCI Arboretum Mail\t\t\t",
"IS\ts\tUniversity of Molise, Department of Science and Technology for Environment and Territory\t\t\t",
"ISAB\ts\tIstituto Sant'Antonio dei Padri Francescani\t\t\t",
"ISAR\ts\tAcademy of Science\t\t\t",
"ISB\ts\tInstitute of Spelology \"Emile Racovita\"\t\t\t",
"ISBB\ts\tInstitutul de Stiinte Biologice\t\t\t",
"ISBC\ts\tInstitute of Soil Biology, Academy of Science of the Czech Republic\t\t\t",
"ISBC:CMF\tcb\tInstitute of Soil Biology, Academy of Science of the Czech Republic, Collection of Microscopic Fungi\t\t",
"ISC<FRA>\tc\tInternational Salmonella Centre (W.H.O.)\t\t\t",
"ISC<USA-IA>\ts\tIowa State University, Botany Department\t\t\t",
"ISCM\ts\tInstitut Scientifique Cheripen\t\t\t",
"ISE\ts\tUniversidade Federal de Sergipe, Campus Professor Alberto Carvalho\t\t\t",
"ISEA\ts\tInstitute of Systematics and Evolution of Animals\t\t\t",
"ISEAK\ts\tInstytut Systematyki i Ewolucji Zwierz\t\t\t",
"ISEM\ts\tInstitut des Sciences de l'Evolution Montpellier \t\t\t\t",
"ISER\ts\tInstitutul Speologie Emil G. Racovita\t\t\t",
"ISH\ts\tInstitut fuer Seefischerei\t\t\t",
"ISI\ts\tGeological Museum, Indian Statistical Institute\t\t\t",
"ISIS\ts\tNaturforschende Gesellschaft Isis\t\t\t",
"ISKW\ts\tIshikawa Museum of Natural History\t\t\t",
"ISL\ts\tQuaid-I-Azam University, Biological Sciences Department\t\t\t",
"ISM\ts\tIllinois State Museum\tISMS\t\t",
"ISM:Aves\ts\tIllinois State Museum, Ornithology collection\t\t",
"ISM:Fish\ts\tIllinois State Museum, Ichthyology Collection\t\t",
"ISM:HERP\ts\tIllinois State Museum, Herpetology collection\t\t",
"ISM:Mammals\ts\tIllinois State Museum, Mammalogy Collection\t\t",
"ISMAR\ts\tConsiglio Nazionale delle Ricerche, Istituto di Scienze  Marine\t\t\t",
"ISMC\ts\tIndiana Department of Natural Resources\t\t\t",
"ISNHC\ts\tState Historical Society of Iowa\t\t\t",
"ISNP\ts\tIstituto Sperimentale per la Nutrizione delle Piante\t\t\t",
"ISP\tc\tInternational Cooperative Project for Description and Deposition of Type Cultures\t\t\t",
"ISPaVe\tc\tIstituto Sperimentale per la Patologia Vegetale\tCRA-PAV\t\t",
"ISRA\ts\tRoyal Academy\t\t\t",
"ISRI\tc\tIndonesian Sugar Research Institute, Pusat Penelitian Perkebunan Gula Indonesia\t\t\t",
"ISS\tc\tInstitute of Soil Science Collection of Bacteria\t\t\t",
"ISTC\ts\tUniversity of Northern Iowa, Biology Department\t\t\t",
"ISTE\ts\tUniversity of Istanbul, Department of Pharmaceutical Botany\t\t\t",
"ISTF\ts\tIstanbul University, Botany Department\t\t\t",
"ISTO\ts\tUniversity of Istanbul, Orman Fakueltesi\t\t\t",
"ISTPM\ts\tInstitut Scientifique et Technique des Peches Maritimes\t\t\t",
"ISU<USA-IL>\ts\tIllinois State University, Biological Sciences Department\t\t\t",
"ISU<USA-IL>:Birds\ts\tIllinois State University, Biological Sciences Department, Birds Collection\t\t",
"ISU<USA-IL>:Mammal\ts\tIllinois State University, Biological Sciences Department, Mammals Collection\t\t",
"ISU<USA-IN>\ts\tIndiana State University\t\t\t",
"ISUC\ts\tNormal, Illinois State University\t\t\t",
"ISUI\ts\tIowa State University\t\t\t",
"ISUVC\ts\tIndiana State University\t\t\t",
"ISZA\ts\tIstituto Sperimentale per la Zoologia Agraria\t\t\t",
"ISZP\ts\tInstitute of Systematic Zoology\t\t\t",
"ITAE\ts\tIstituto Tecnico Agrario Enologico\t\t\t",
"ITAL\tc\tBanco de Fermentos Lacticos\t\t\t",
"ITALSL\tc\tSecao de Leite e Derivados\t\t\t",
"ITALSM\tc\tSecao de Microbiologia\t\t\t",
"ITBCC\tc\tInstitute of Technology Bandung Culture Collection\t\t\t",
"ITBCZ\ts\tInstitute of Tropical Biology Collection of Zoology\tITBZC\t\t",
"ITBZC\ts\tInstitute of Tropical Biology, Zoology Collection\tITBCZ\t\t",
"ITC\tb\tInternational Transit Centre\t\t\t",
"ITCC<IND>\tc\tIndian Type Culture Collection\t\t\t",
"ITCC<ITA>\ts\tIstituto Tecnico Stattale \"Camillo Cavour\"\t\t\t",
"ITCO\ts\tIstituto Tecnico Commerciale \"Oronzio Gabriele Costa\"\t\t\t",
"ITCV\ts\tInstituto Tecnologico de Ciudad Victoria, Departamento de Micologia\t\t\t",
"ITD\tc\tColeccion de Cepas Microbianas\t\t\t",
"ITDI\tc\tIndustrial Technology Development Institute\t\t\t",
"ITEM\tc\tInstitute of Toxins and Mycotoxins from Plant Parasites\t\t\t",
"ITG\tc\tITG\t\t\t",
"ITH\tc\tW.H.O./F.A.O. Collaborating Centre for Reference and Research on Leptospirosis\t\t\t",
"ITHA\ts\tInstituut voor Tropische Hygiene\t\t\t",
"ITIC\ts\tUniversidad de El Salvador, Escuela de Biologia\t\t\t",
"ITLJ\ts\tNational Institute of Agro-environmental Sciences\t\t\t",
"ITMH\ts\tMuhimbili University of Health and Allied Sciences\t\t\t",
"ITMM\ts\tInstituto Tecnologico de Monterrey\t\t\t",
"ITT\ts\tInstituto Technologico de Ciudad Victoria\t\t\t",
"IU\ts\tIndiana University\t\t\t",
"IUI\ts\tInha University, Biology Department\t\t\t",
"IUIC\ts\tIndiana University\t\t\t",
"IUK\ts\tUniversite de Kinshasa, Departement de Biologie\t\t\t",
"IUM\ts\tIwate University, Biology Department\t\t\t",
"IUP\ts\tIndiana University of Pennsylvania, Biology Department\t\t\t",
"IUQ\ts\tLaboratorio de Ictiologia\t\t\t",
"IUVV\ts\tInstitut Universiatire de la Vigne et du Vin\t\t\t",
"IVAU\ts\tInstituut Voor Aardwetenschappen\t\t\t",
"IVB\ts\tInstitute of  Vertebrate Biology, Academy of Sciences of the Czech Republic\t\t\t",
"IVF\ts\tChinese Academy of Agricultural Sciences\t\t\t",
"IVGU\ts\tIvanovo State University\t\t\t",
"IVIC\ts\tInstituto Venezolano de Investigaciones Cientificas\t\t\t",
"IVPP\ts\tInstitute of Vertebrate Paleontology and Paleoanthropology\tIVPP AS\t\t",
"IZ<BRA>\tc\tDepartamento de Tecnologia Rural\t\t\t",
"IZ<CUB>\ts\tInstituto de Zoologia\t\t\t",
"IZ<KAZ>\ts\tInstitute of Zoology\t\t\t",
"IZ<TUR>\ts\tAegean Agricultural Research Institute, Department of Plant Genetic Resources\t\t\t",
"IZA\ts\tUniversita di l'Aguila, Instituto di Zoologia\t\t\t",
"IZAC<ARG>\ts\tUniversidad Nacional de La Rioja-Sede Chamical\t\t\t",
"IZAC<CUB>\ts\tAcademia de Ciencias de Cuba, Instituto de Zoologia\t\t\t",
"IZAS\ts\tInstitut Zoologii Akademii Nauk Ukraini - Institute of Zoology of the Academy of Sciences of Ukraine\t\t\t",
"IZASK\ts\tInstitue of Zoology of the Kazakh Academy of Sciences\t\t\t",
"IZBE\ts\tInstitute of Zoology and Botany\t\t\t",
"IZBT\ts\tL'Institut de Zoologie et Botanique de Tartu\t\t\t",
"IZCAS\ts\tInstitute of Zoology, Chinese Academy of Sciences\tZMIOZ\t\t",
"IZCR\ts\tIstituto di Zoologia\t\t\t",
"IZEF\ts\tEge Universitesi, Farmasotik Botanik Kursusu\t\t\t",
"IZET-UCV<VEN>\ts\tInstituto de Zoologia y Ecologia Tropical\t\t\t",
"IZGAS\ts\tGeorgian Academy of Sciences, Insititute of Zoology\t\t\t",
"IZPAN\ts\tZoological Institute, Polish Academy of Sciences\t\t\t",
"IZPC\ts\tUniversidade do Porto\t\t\t",
"IZSI\ts\tIstituto di Zoologia\t\t\t",
"IZSSA\tc\tCollection of Experimental Zooprophylactic Institute of Sardinia (Istituto Zooprofilattico Sperimentale della Sardegna \"G.Pegreffi\", Sassari))\t\t\t",
"IZTA\ts\tUniversidad Nacional Autonoma de Mexico, Iztacala, Jefatura de Biologia\t\t\t",
"IZUA\ts\tUniversidad Austral de Chile, Instituto de Zoologia\t\t\t",
"IZUC\ts\tUniversidad de Concepcion, Instituto de Zoologia\t\t\t",
"IZUCS\ts\tUniversita DI Cagliari\t\t\t",
"IZUE\ts\tUniversitat -Erlangen-Nurnberg\t\t\t",
"IZUG\ts\tIstituto di Zoologia dell'Universita\t\t\t",
"IZUI\ts\tInstitut fuer Zoologie der Universitat Innsbruck\t\t\t",
"IZUM\ts\tIstituto di Zoologia dell'Universita\t\t\t",
"IZUP\ts\tIstituto di Zoologia dell'Universita\t\t\t",
"IZUW\ts\tInstitut fuer Zoologie der Universitat Wien\t\t\t",
"IZW\ts\tInstitut Zoologii\t\t\t",
"IZWU\ts\tPaleozology Department, Institute of Zoology, Worclaw University\t\t\t",
"J\ts\tUniversity of the Witwatersrand, Botany Department\t\t\t",
"JA\ts\tConsejeria de Medio Ambiente (Junta de Andalucia), Direccion General de Gestion del Medio Natural\t\t\t",
"JAC\ts\tUniversity of Jodhpur, Botany Department\t\t\t",
"JACA\ts\tInstituto Pirenaico de Ecologia, C.S.I.C.\t\t\t",
"JAEN\ts\tUniversidad de Jaen, Botanica\t\t\t",
"JAS\ts\tJiangxi Academy of Sciences\t\t\t",
"JATH\ts\tUniversity of Szeged\t\t\t",
"JAUM\ts\tJardin Botanico Joaquin Antonio Uribe\t\t\t",
"JAY\ts\tFondation Cognacq-Jay\t\t\t",
"JAZUH\ts\tJazan University\t\t\t",
"JBAG\ts\tJardin Botanico Atlantico, Ayuntamiento de Gijon\t\t\t",
"JBB\ts\tJardin Botanico Jose Celestino Mutis\t\t\t",
"JBC<MEX>\tb\tFrancisco Javier Clavijero Botanic Garden\tXAL\t\t",
"JBCC\ts\tAlaska State Museum\t\t\t",
"JBCVC\tsb\tJardin Botanico Canario Viera y Clavijo\t\t\t",
"JBG\ts\tJohannesburg Botanic Garden\t\t\t",
"JBGP\ts\tJardin Botanico Guillermo Pineres\t\t\t",
"JBL\ts\tJardin Botanico Lankester, Universidad de Costa Rica\t\t\t",
"JBN\ts\tJardin Botanico Nacional\t\t\t",
"JBRI\tc\tJeju Biodiversity Research Institute\t\t\t",
"JBSD\ts\tJardin Botanico Nacional Dr. Rafael M. Moscoso\t\t\t",
"JBVN\ts\tJardin Botanique de la Ville de Nice, Service des Espaces Verts\t\t\t",
"JBVPF\tsb\tJardin botanique de la Ville de Paris\t\t\t",
"JBWM\ts\tJ.B. Wallis Museum of Entomology\t\t\t",
"JCB\ts\tIndian Institute of Science (IISc)\t\t\t",
"JCE\ts\tJiangxi College of Education, Biology Department\t\t\t",
"JCM\tc\tJapan Collection of Microorganisms\t\thttps://www.jcm.riken.jp/cgi-bin/jcm/jcm_number?JCM=\t",
"JCRB\tc\tJapanese Collection of Research Bioresources Cell Bank\t\t\t",
"JCT\tc\tJames Cook Townsville\t\t\t",
"JE\ts\tHerbarium Haussknecht, Jena\t\t\t",
"JEF\ts\tIndiana University Southeast, Biology Department\t\t\t",
"JEL\tc\tJoyce E. Longcore Chytrid Collection at the University of Maine\t\t\t",
"JEL<LVA>\ts\tLatvian Agricultural Academy, Plant Protection Department\t\t\t",
"JEPS\ts\tUniversity of California, Jepson Herbarium\t\t\t",
"JES\ts\tHerbarium Jorge Espinoza Salas, Universidad Autonoma Chapingo\t\t\t",
"JESSUP\ts\tWilliam Jessup University\t\t\t",
"JESW\ts\tJohn Evelyn Society's Museum\t\t\t",
"JF\ts\tJonkershoek Forestry Research Centre, Environment Affairs Department\t\t\t",
"JFBM\ts\tJames Ford Bell Museum of Natural History\t\t\t",
"JGSU\ts\tJinggangshan University\t\t\t",
"JHH\ts\tNew York State Herbarium\t\t\t",
"JHS\ts\tRegional Research Institute\t\t\t",
"JHWU\ts\tWittenberg University, Biology Department\t\t\t",
"JIC\tb\tJohn Innes Centre\t\t\t",
"JII\ts\tJohn Innes Institute\t\t\t",
"JIU\ts\tJishou University, Biology Department\t\t\t",
"JJF\ts\tJiujiang Forestry Institute\t\t\t",
"JJT\ts\tJiujiang Teachers College, Biology Department\t\t\t",
"JJU\ts\tJeonju University\t\t\t",
"JLAU\ts\tJiIin Agricultural University\t\t\t",
"JLDC\ts\tJilin Institute for Drug Control\t\t\t",
"JLFC\ts\tForestry College of Beihua University, Forestry Department\t\t\t",
"JLMP\ts\tJilin Academy of Traditional Chinese Medicine and Materia Medica\t\t\t",
"JM\ts\tJura Museum, Eichstatt\t\t\t",
"JME\ts\tJura-Museum Eichstatt\t\t\t",
"JMH\ts\tLos Alamos Nature Center (Pajarito Environmental Education Center)\t\t\t",
"JMM\ts\tEarlham College, Joseph Moore Museum\t\t\t",
"JMRC\tc\tJena Microbial Resource Collection\t\thttp://www.jmrc.uni-jena.de/data.php?fsu=\t",
"JMRC:SF\tc\tJena Microbial Resource Collection, Subcollection Fungi\t\t",
"JMSMC\ts\tJiamusi Medical College, Department of Pharmacy\t\t\t",
"JMUH\ts\tJames Madison University, Department of Biology\t\t\t",
"JN\ts\tJinggang Mountain Nature Reserve\t\t\t",
"JNR\ts\tJiulian Mountain Nature Reserve, Administration Department\t\t\t",
"JNU<CHN>\ts\tJi Nan University\t\t\t",
"JNU<KOR>\ts\tChonbuk National University, Faculty of Biological Sciences\t\t\t",
"JNUB\ts\tJeju National University\t\t\t",
"JOE\ts\tUniversity of Joensuu, Biology Department\t\t\t",
"JOI\ts\tUniversidade da Regiao de Joinville\t\t\t",
"JOMU\ts\tJohn Muir National Historic Site\t\t\t",
"JONK\ts\tJonkershoek Herbarium\t\t\t",
"JOTR\ts\tJoshua Tree National Park\t\t\t",
"JP\ts\tPhyletisches Museum Jena\tPMIG,PMJ\t\t",
"JPB\ts\tUniversidade Federal da Paraiba, Cidade Universitaria, Departamento de Sistematica e Ecologia\t\t\t",
"JPMP\ts\tJanus Pannonius Museum\t\t\t",
"JPU\ts\tJanus Pannonius University, Botany Department\t\t\t",
"JRAU\ts\tUniversity of Johannesburg, Department of Botany and Plant Biotechnology\t\t\t",
"JROH\ts\tJasper Ridge Biological Preserve, Stanford University\t\t\t",
"JRY\ts\tJersey College for Girls\t\t\t",
"JSHC\ts\tJay S. Haft Collection\t\t\t",
"JSMI\ts\tJiangsu Marine Fisheries Research Institute\t\t\t",
"JSMPE\ts\tJoint Soviet Mongolian Paleontolgical Expedition\tJRMPE\t\t",
"JSPC<CHN>\ts\tShandong University, Biology Department\t\t\t",
"JSPC<CZE>\ts\tJ. Rusek Collection\t\t\t",
"JSU\ts\tJacksonville State University, Biology Department\t\t\t",
"JSY\ts\tMuseum and Art Gallery of La Societe Jersiaise\t\t\t",
"JTNM\ts\tJoshua Tree National Monument\t\t\t",
"JTPC\ts\tColorado Entomological Museum (formerly John T. Polhemus collection)\t\t\t",
"JU\ts\tJinan University\t\t\t",
"JUA\ts\tUniversidad Nacional de Jujuy, Facultad de Ciencias Agrarias\t\t\t",
"JUFL\ts\tJacksonville University\t\t\t",
"JUG\ts\tJiwaji University, Botany Department\t\t\t",
"JUJ\ts\tHebei Agricultural University\t\t\t",
"JVR\ts\tUniversidad Nacional\t\t\t",
"JXAU\ts\tJiangxi Agricultural University, Forestry Department\t\t\t",
"JXCM\ts\tJiangxi College of Traditional Chinese Medicine, Pharmacy Department\t\t\t",
"JXF\ts\tJiangxi Forestry Institute\t\t\t",
"JXM\ts\tJiangxi Institute of Materia Medica\t\t\t",
"JXU\ts\tJiangxi University, Biology Department\t\t\t",
"JYV\ts\tUniversity of Jyvaeskylae, Natural History Department\t\t\t",
"K\tsb\tRoyal Botanic Gardens, Kew\t\thttp://specimens.kew.org/herbarium/K\t",
"K(M)\ts\tMycology Collection of Kew Royal Botanical Gardens\t\t\t",
"KA\ts\tVytautas Magnus University\t\t\t",
"KABA\ts\tUniversity of Kabul\t\t\t",
"KAC\tc\tKalmar Algae Collection\t\t\t",
"KACC\tc\tKorean Agricultural Culture Collection\t\t\t",
"KAG\ts\tKagoshima University Museum\t\t\t",
"KAGS\ts\tKagoshima University, Biology Department\t\t\t",
"KAI\ts\tHenan University, Biology Department\t\t\t",
"KAM\ts\tKamchatka Branch of Pacific Geographical Institute\t\t\t",
"KAMA\ts\tYokohama University\t\t\t",
"KANA\ts\tKanazawa University\t\t\t",
"KAND\ts\tKandalaksha State Nature Reserve\t\t\t",
"KANU\ts\tUniversity of Kansas\t\t\t",
"KAR\ts\tUniversity of Tehran, Horticulture Department\t\t\t",
"KARI\ts\tKenya Agricultural Research Institute\t\t\t",
"KARS\ts\tKawanda Agricultural Research Station\t\t\t",
"KAS\ts\tUniversitaet Gesamthochschule Kassel, Morphologie und Systematik der Pflanzen\t\t\t",
"KASH\ts\tUniversity of Kashmir\t\t\t",
"KASSEL\ts\tNaturkundemuseum im Ottoneum\t\t\t",
"KATH\ts\tDepartment of Plant Resources\t\t\t",
"KATO\ts\tKaradeniz Technical University, Department of Forest Botany\t\t\t",
"KATO:Fungi\ts\tKaradeniz Technical University, Department of Forest Botany, Fungi collection\t\t",
"KAUM\ts\tKagoshima University Museum\t\t\t",
"KAUM:I\ts\tKagoshima University Museum, Ichthyology Collection\t\t",
"KAW\ts\tKawanda Research Station, Department of Agriculture\t\t\t",
"KAZ\ts\tKazan State University\t\t\t",
"KB\ts\tNational Biological Resources Center, Department of Biological Sciences\t\t\t",
"KBAI\ts\tKuban Agricultural State University, Department of Biology and Ecology\t\t\t",
"KBFH\ts\tKurdistan Botanical Foundation\t\t\t",
"KBG<JPN>\tb\tKyoto Botanical Garden\t\t\t",
"KBHG\ts\tH. M. Berbekov Kabardian-Balkarian State University, Department of Botany\t\t\t",
"KBM\ts\tBalaton Museum\t\t\t",
"KBP MSU\tc\tYeast collection of the Soil Biology Department in Lomonosov Moscow State University\t\t\t",
"KBRYO\ts\tCentre College of Kentucky\t\t\t",
"KBSMS\ts\tKellogg Biological Station, Michigan State University\t\t\t",
"KBT\ts\tStewarty Museum\t\t\t",
"KCCM\tc\tKorean Culture Center of Microorganisms, Department of Food Engineering\t\t\t",
"KCFS\ts\tKing's College\t\t\t",
"KCK\ts\tDick Institute\t\t\t",
"KCLB\tc\tKorean Cell Line Bank\t\t\t",
"KCOM\tc\tKorean Collection for Oral Microbiology\t\t\t",
"KCS\ts\tUniversity of London, King's College, Botany Department\t\t\t",
"KCSU\ts\tKarachay-Circassian State University\t\t\t",
"KCTC\tc\tKorean Collection for Type Cultures\t\thttps://kctc.kribb.re.kr/En/jsearch/j_sview.aspx?sn=\t",
"KDL\ts\tKendal Museum\t\t\t",
"KDR\ts\tBewdley Museum\t\t\t",
"KE\ts\tKent State University, Biological Sciences Department\t\t\t",
"KEF\ts\tKunming Edible Fungi Institute\t\t\t",
"KEI\ts\tUniversity of Transkei, Botany Department\t\t\t",
"KEIB\ts\tKatedra Ekologii i Biogeografii\t\t\t",
"KEIU\ts\tKorea University\t\t\t",
"KEM\ts\tUniversity of Kemerovo, Department of Botany\t\t\t",
"KEMC\tc\tKorea Environmental Microorganism Center, Kyonggi University\tKEMB\t\t",
"KEMH\tc\tKEMH/PMH Culture collection\t\t\t",
"KEN\ts\tLongwood Gardens, Horticulture Department\t\t\t",
"KEND\ts\tKendal Natural History Society\t\t\t",
"KEP\ts\tForest Research Institute Malaysia\t\t\t",
"KESC\ts\tKeene State College, Department of Biology\t\t\t",
"KEVO\ts\tUniversity of Turku\t\t\t",
"KF\ts\tKerman University of Medical Sciences\t\t\t",
"KFBG\ts\tKadoorie Farm and Botanic Garden\t\t\t",
"KFCC\tc\tKorean Federation of Culture Collection\t\t\t",
"KFI\ts\tHongnung Arboretum, Silviculture Department\t\t\t",
"KFRA\ts\tKlamath Falls Resource Area, BLM\t\t\t",
"KFRI\ts\tKerala Forest Research Institute\t\t\t",
"KFRS\ts\tKanudi Fisheries Research Station\t\t\t",
"KFTA\ts\tSaint Petersburg State S. M. Kirov Forest Technology Academy, Botany and Dendrology Department\t\t\t",
"KFUH\ts\tKing Faisal University, Chemistry and Botany Department\t\t\t",
"KG\ts\tInternational Phytochemistry Research and Production Institute\t\t\t",
"KGU\ts\tGeology and Mineralogy Museum\t\t\t",
"KGY\ts\tCliffe Castle Art Gallery and Museum\t\t\t",
"KH\ts\tKorea National Arboretum\t\t\t",
"KHA\ts\tInstitute for Water and Ecology Problems, Far East Branch, Russian Academy of Sciences, Laboratory of Plant Ecology\t\t\t",
"KHAU\ts\tKhuzestan Agricultural Sciences and Natural Resources University\t\t\t",
"KHD\ts\tKathryn Kalmbach Herbarium of Vascular Plants, Denver Botanic Gardens\t\t\t",
"KHER\ts\tKherson Pedagogical University, Botany Department\t\t\t",
"KHF\ts\tForest Research and Education Institute, Soba\t\t\t",
"KHMM\ts\tKultur Historisches Museum\t\t\t",
"KHMS\ts\tMuzeum `umavy\t\t\t",
"KHOR\ts\tPamir Biological Institute\t\t\t",
"KHU\ts\tUniversity of Khartoum, Botany Department\t\t\t",
"KHUG\ts\tAussenstelle der Universitaet\t\t\t",
"KHUS\ts\tKyung Hee University, Biology Department\t\t\t",
"KIEL\ts\tChristian-Albrechts-Universitaet Kiel\t\t\t",
"KIFB\ts\tKorean Institute of Freshwater Biology\t\t\t",
"KIOM\ts\tKorea Institute of Oriental Medicine\t\t\t",
"KIP\ts\tInstitut National pour l'Etude et la Recherche Agronomique\t\t\t",
"KIRI\ts\tUniversity of Rhode Island, Department of Biological Sciences\t\t\t",
"KIS\ts\tUniversite de Kisangani\t\t\t",
"KISA\ts\tInstitut Congolais  pour la Conservation de la Nature\t\t\t",
"KIT\tc\tLaboratorium voor Tropische Hygiene\t\t\t",
"KIUJ\ts\tKyusu University\t\t\t",
"KIZ\ts\tKunming Institute of Zoology, Chinese Academy of Sciences\t\t\t",
"KKFC<THA>\ts\tKasetsart  University Kamphaengsaen campus Fungus Collection\t\t\t",
"KKM\ts\tKirkleatham Museum\t\t\t",
"KKU\ts\t Khon Kaen University Herbarium, Department of Biology\t\t\t",
"KKUA\ts\tKhon Kaen University\t\t\t",
"KKUK\ts\tKon-Kuk University\t\t\t",
"KL\ts\tLandesmuseum fuer Kaernten\t\t\t",
"KLA\ts\tHerbarium, Department of Agriculture, Malaysia\t\t\t",
"KLE\ts\tUniversity of Keele, Biological Sciences Department\t\t\t",
"KLGU\ts\tKaliningrad State University, Department of Botany and Plant Ecology\t\t\t",
"KLH\ts\tK. E. Tsiolkovsky Kaluga State Pedagogical University, Department of Botany and Ecology\t\t\t",
"KLN\ts\tLynn Museum and Art Gallery\t\t\t",
"KLU\ts\tUniversity of Malaya\t\t\t",
"KM<CAN>\ts\tKelowna Museum\t\t\t",
"KM<CZE>\ts\tSprava Krkonoaskeho narodniho parku\t\t\t",
"KM<POL>\ts\tMuzeum Przyrodnicze Uniwersytetu Jagiellonskiego\t\t\t",
"KM<RUS>\ts\tKotel'nich Museum\t\t\t",
"KMG\ts\tMcGregor Museum\t\t\t",
"KMK<MOL>\ts\tKraevedscheskii Musei Kishineva - Museum of Regional Study\t\t\t",
"KMK<ZAF>\ts\tKaffarian Museum\t\t\t",
"KMKV\ts\tKarlovarske muzeum\t\t\t",
"KMM\tc\tG.B. Elyakov Pacific Institute of Bioorganic Chemistry of the Far Eastern Branch of the Russian Academy of Sciences (PIBOC FEB RAS) Collection of Marine Microorganisms\t\t\t",
"KMMA\ts\tRoyal Museum for Central Africa\tRMCA\t\t",
"KMMCC\tc\tKorea Marine Microalgae Culture Center\t\t\t",
"KMN\ts\tAdger Museum of Natural History and Botanical Garden, Botany Department\t\t\t",
"KMNH\ts\tKitakyushu Museum and Institute of Natural History, Botany Department\t\t\t",
"KMU\ts\tKarl-Marx-Universitat Leipzeg\t\t\t",
"KMV\ts\tKunming Municipal Museum\t\t\t",
"KMVC\ts\tKrajske Muzeum Vychodnich Cech\t\t\t",
"KNFY\ts\tKlamath National Forest, Resources Department\t\t\t",
"KNH\ts\tKongju National University\t\t\t",
"KNHM\ts\tThe Educational Science Museum [=Kuwait Natural History Museum?]\t\t\t",
"KNHM<UKR>\ts\tKharkov Natural History Museum\t\t\t",
"KNK\ts\tNorthern Kentucky University, Department of Biological Sciences\t\t\t",
"KNL\ts\tKinneil Museum\t\t\t",
"KNOX\ts\tKnox College, Department of Biology\t\t\t",
"KNP\ts\tSkukuza  Biological Reference, South African National Parks\t\t\t",
"KNU\ts\tKyungpook National University, Biology Department\t\t\t",
"KNUC\ts\tKangweon National University\t\t\t",
"KNUH\ts\tKyung-Nam University, Biology Department\t\t\t",
"KNWR\ts\tKenai National Wildlife Refuge\t\t\t",
"KNWR:Ento\ts\tKenai National Wildlife Refuge, Entomology Collection\t\t",
"KNWR:Herb\ts\tKenai National Wildlife Refuge, Herbarium\t\t",
"KNY\ts\tLiterary and Scientific Institution of Kilkenny\t\t\t",
"KNYA\ts\tSelcuk Ueniversitesi, Biyoloji Boeluemue\t\t\t",
"KO\ts\tP. J. Safarik University\t\t\t",
"KOCH\ts\tKochi University, Department of Natural Environmental Science\t\t\t",
"KOELN\ts\tUniversitaet Koeln, Arbeitsgruppe Geobotanik und Phytotaxonomie\t\t\t",
"KOLABIC\ts\tKorean Lichen & Allied Bioresource Center\tKoLRI\t\t",
"KONL\ts\tBodensee-Naturmuseum\t\t\t",
"KOPRI\tc\tKorean Polar Research Institute\t\t\t",
"KOPRI:KCCPM\tc\tKorean Polar Research Institute, KOPRI Culture Collection of Polar Microorganisms\t\t",
"KOR\ts\tInstitute of Dendrology\t\t\t",
"KOS\tc\tCollection of Salmonella Microorganisms\t\t\t",
"KPABG\ts\tPolar-Alpine Botanical Garden-Institute, Department of Flora and Vegetation\t\t\t",
"KPBG\ts\tKings Park and Botanic Garden, Botanic Gardens and Parks Authority\t\t\t",
"KPE\ts\tKyungpook Earth, Kyungpook National University\t\t\t",
"KPM\ts\tKanagawa Prefectural Museum of Natural History\t\t\t",
"KPM-NI\ts\tKanagawa Prefectural Museum of Natural History\t\t\t",
"KPMC\ts\tKalamazoo, Kalamazoo Public Museum\t\t\t",
"KR\ts\tStaatliches Museum fuer Naturkunde Karlsruhe\t\t\t",
"KRA\ts\tJagiellonian University\t\t\t",
"KRAM\ts\tPolish Academy of Sciences, Department of Plant Systematics\t\t\t",
"KRAS\ts\tKrasnoyarsk State Pedagogical University, Department of Botany\t\t\t",
"KRB\ts\tKebun Raya Bogor\t\t\t",
"KRDY\ts\tKirkcaldy Museum and Art Gallery\t\t\t",
"KRF\ts\tV. N. Sukachev Institute of Forest and Wood\t\t\t",
"KRG\ts\tWestfield Museum\t\t\t",
"KRIB\ts\tKorea Research Institute of Bioscience and Biotechnology, Plant Diversity Research Center\t\t\t",
"KRMS\ts\tSternwarte Kremsmuenster, Stift\t\t\t",
"KRP\tsb\tKebun Raya Purwodadi (Purwodadi Botanic Gardens, Indonesia)\t\t\t",
"KRSF\ts\tKoronivia Research Station\t\t\t",
"KRSU\ts\tKrasnoyarsk State University, Department of Biogeocoenology\t\t\t",
"KSAN\ts\tKimberley South African National Parks Herbarium\t\t\t",
"KSBS\ts\tLawrence, University of Kansas, State Biological Survey of Kansas\t\t\t",
"KSC\ts\tKansas State University\t\t\t",
"KSEM\ts\tKansas Snow Entomological Museum\t\t\t",
"KSHS\ts\tKochi Senior High School\t\t\t",
"KSK\ts\tFitz Part Museum and Art Gallery\t\t\t",
"KSM\ts\tNational Science Museum\t\t\t",
"KSNHM\ts\tNatural History Museum, Kishiwada City\t\t\t",
"KSO\ts\tTweedside Physical and Antiquarian Society Museum\t\t\t",
"KSP\ts\tPittsburg State University, Biology Department\t\t\t",
"KSPI\ts\tKostanay State Pedagogical Institute\t\t\t",
"KSRV\ts\tKhosrov State Reserve\t\t\t",
"KSTC\ts\tEmporia State University\t\t\t",
"KSU\ts\tKing Saud University, Botany and Microbiology Department\tKSUP\t\t",
"KSUC\ts\tKansas State University\tKSU\t\t",
"KSUP\ts\tKing Saud University\t\t\t",
"KTC\ts\tPedagogical University, Botany Department\t\t\t",
"KTG\ts\tKettering and District Naturalists' Society and Field Club\t\t\t",
"KTU\ts\tUniversity of Silesia, Department of Plant Systematics\t\t\t",
"KTUH\ts\tKuwait University, Botany and Microbiology Department\t\t\t",
"KU\ts\tUniversity of Kansas Natural History Museum\tKUMNA,KUNHM,KUVP,UK\t\t",
"KU-MACC\tc\tKobe University Macroalgal Culture Collection\t\t\t",
"KU:H\ts\tUniversity of Kansas Natural History Museum, Herpetology Collection\t\t",
"KU:I\ts\tUniversity of Kansas Natural History Museum, Ichthyology collection\thttps://ichthyology.specify.ku.edu/specify/bycatalog/KUI/&spec;/",
"KU:IP\ts\tUniversity of Kansas Natural History Museum, Invertebrate Paleontology Collection\t\t",
"KU:IT\tsb\tUniversity of Kansas Natural History Museum, Ichthyology tissue collection\t\t",
"KU:IZ\ts\tUniversity of Kansas Natural History Museum, Invertebrate Zoology Collection\t\t",
"KU:M\ts\tUniversity of Kansas Natural History Museum, Mammology Collection\t\t",
"KU:O\ts\tUniversity of Kansas Natural History Museum, Ornithology Collection\t\t",
"KU:PB\ts\tUniversity of Kansas Natural History Museum, Paleobotany Collection\t\t",
"KU:VP\ts\tUniversity of Kansas Natural History Museum, Vertebrate Paleontology Collection\t\t",
"KU<CHN>\ts\tKwangsi University\t\t\t",
"KUBH\ts\tUniversity of Kerala\t\t\t",
"KUBL\ts\tYoshida College, Biological Laboratory\t\t\t",
"KUEC\ts\tKyushu University Entomology Collection\t\t\t",
"KUEL\ts\tKyushu University, Entomology Laboratory\t\t\t",
"KUFC\tc\tKasetsart University Fungus Collection\t\t\t",
"KUFF\ts\tDepartment of Forest Biology, Faculty of Forestry at Kasetsart University\t\t\t",
"KUFS\ts\tKabul University\t\t\t",
"KUH\ts\tUniversity of Karachi, Botany Department\t\t\t",
"KUHE\ts\tKyoto University, Graduate School of Human and Environmental Studies\t\t\t",
"KUIC\ts\tKagoshima University\t\t\t",
"KUKENS\tc\tCentre for Research and Application of Culture Collections of Microorganisms\t\t\t",
"KUKI\ts\tKurukshetra University\t\t\t",
"KUM\ts\tResource Management Support Center\t\t\t",
"KUMA\ts\tKumamoto University, Biology Department\t\t\t",
"KUMCC\tc\tKunming Institute of Botany Culture Collection\t\t\t",
"KUMF\ts\tKasetsart University Museum of Fisheries\t\t\t",
"KUN\ts\tKunming Institute of Botany, Chinese Academy of Sciences\t\t\t",
"KUNE\ts\tKunming Institute of Ecology, Academia Sinica\t\t\t",
"KUO\ts\tKuopio Natural History Museum\t\t\t",
"KURS\ts\tKursk State University, Department of Botany\t\t\t",
"KUS\ts\tKorea University, Biology Department\t\t\t",
"KUU\ts\tUniversity of Science and Technology\t\t\t",
"KUW\ts\tKakatiya University\t\t\t",
"KUZ<JPN>\ts\tZoological Collection of the Kyoto University\t\t\t",
"KUZC\ts\tKyushu University, Zoological Collection\t\t\t",
"KVCH\ts\tKivach Nature Reserve\t\t\t",
"KW\ts\tNational Academy of Sciences of Ukraine\t\t\t",
"KWHA\ts\tUkrainian National Academy of Sciences\t\t\t",
"KWHU\ts\tO. V. Fomin Botanical Garden of National Taras Schevchenko University of Kiev\t\t\t",
"KWNU\ts\tKangwon National University, Biology Department\t\t\t",
"KWP\ts\tKenelm W. Philip Collection, University of Alaska Museum of the North\t\t\t",
"KWP:Ento\ts\tKenelm W. Philip Collection, University of Alaska Museum of the North, Lepidoptera collection\t\t",
"KY\ts\tUniversity of Kentucky\t\t\t",
"KYM\ts\tUniversity of Helsinki, Kymenlaakso Society of Naturalists\t\t\t",
"KYO\ts\tKyoto University, Botany Department\t\t\t",
"KYUM<JPN>\ts\tKyushu University Museum\t\t\t",
"L\tsb\tNational Herbarium of the Netherlands (NHN)\t\t\t",
"LA\ts\tUniversity of California\t\t\t",
"LABCC\tc\tLactic acid bacteria culture collection\t\t\t",
"LAC\ts\tXian Institute of Lacquer\t\t\t",
"LACM\ts\tNatural History Museum of Los Angeles County\t\t\t",
"LACM:Crustacea\ts\tNatural History Museum of Los Angeles County, Crustacea Department\t\t",
"LACM:Echinoderms\ts\tNatural History Museum of Los Angeles County, Echinoderms Department\t\t",
"LACM:Entomology\ts\tNatural History Museum of Los Angeles County, Entomology Department\t\t",
"LACM:Herpetology\ts\tNatural History Museum of Los Angeles County, Section of Herpetology\t\t",
"LACM:Ichthyology\ts\tNatural History Museum of Los Angeles County, Ichthyology Department\t\t",
"LACM:Malacology\ts\tNatural History Museum of Los Angeles County, Malacology Department\t\t",
"LACM:Mammalogy\ts\tNatural History Museum of Los Angeles County, Mammalogy Department\t\t",
"LACM:Ornithology\ts\tNatural History Museum of Los Angeles County, Ornithology Department\t\t",
"LAE\ts\tPapua New Guinea Forest Research Institute\t\t\t",
"LAF\ts\tUniversity of Louisiana at Lafayette, Biology Department\t\t\t",
"LAGO\ts\tPacific Northwest Forest and Range Experiment Station\t\t\t",
"LAGU\ts\tAsociacion Jardin Botanico La Laguna, Urbanizacion Plan de La Laguna\t\t\t",
"LAH\ts\tUniversity of the Punjab, Botany Department\t\t\t",
"LAJC\ts\tOtero Junior College, Biology Department\t\t\t",
"LAM\ts\tNatural History Museum of Los Angeles County, Botanical Studies\t\t\t",
"LAME\ts\tLake Mead National Recreation Area\t\t\t",
"LAMU\ts\tLamar University, Biology Department\t\t\t",
"LAN\ts\tLancing College, Biology Department\t\t\t",
"LANC\ts\tUniversity of Lancaster, Department of Biological Sciences\t\t\t",
"LAPC\ts\tPierce College, Life Sciences Department\t\t\t",
"LAPL\ts\tLapland State Biosphere Reserve\t\t\t",
"LARRI\ts\tLiving Aquatic Resources Research Institute\t\t\t",
"LASCA\ts\tThe Los Angeles County Arboretum\t\t\t",
"LAT\ts\tSaint Vincent College, Biology Department\t\t\t",
"LATV\ts\tUniversity of Latvia, Laboratory of Botany\t\t\t",
"LAU\ts\tMusee et Jardins Botaniques Cantonaux\t\t\t",
"LAUN\ts\tLaunceston College\t\t\t",
"LAUS\ts\tLaunceston Museum\t\t\t",
"LAV\ts\tDauntsey's School\t\t\t",
"LAVO\ts\tLassen Volcanic National Park\t\t\t",
"LBC\ts\tForestry Herbarium University of the Philippines at Los Banos\t\t\t",
"LBG<CHE>\tc\tInstitute for Agricultural Bacteriology and Fermentation Biology\t\t\t",
"LBG<CHN>\ts\tLushan Botanical Garden\t\t\t",
"LBIT\ts\tLaboratoire de Biologie des Insectes\t\t\t",
"LBL\ts\tM. Curie-Sklodowska University, Department of Botany and Mycology Institute of Biology and Biochemistry\t\t\t",
"LBLC\ts\tM. Curie-Sklodowska University\t\t\t",
"LBM<BRA>\tc\tLaboratorio de Biologia Molecula Depto de Biologia Celular\t\t\t",
"LBM<JPN>\ts\tLake Biwa Museum\t\t\t",
"LBN\ts\tLembaga Biologi Nasional\t\t\t",
"LBP\ts\tLaboratorio de Biologia e Genetica de Peixes\t\t\t",
"LBRP\ts\tLaboratorio de Biodiversidade de Recursos Pesqueiros\t\t\t",
"LBUCH\ts\tLaboratorio de Biologia\t\t\t",
"LBV\ts\tCENAREST\t\t\t",
"LC\ts\tLewis & Clark College\t\t\t",
"LCC<CAN>\tc\tLabatt Culture Collection, Technology Development\t\t\t",
"LCC<POL>\tc\tUniversity of Warmia and Mazury in Olsztyn\t\t\t",
"LCDI\ts\tLuther College, Biology Department\t\t\t",
"LCEU\ts\tLane Community College\t\t\t",
"LCF\ts\tI.N.T.A.\t\t\t",
"LCFM\ts\tMusee dHistoire Naturelle\tMHNC\t\t",
"LCG\ts\tLeamington College for Girls\t\t\t",
"LCH\ts\tLetchworth Museum and Art Gallery\t\t\t",
"LCM\ts\tUniversidad de Chile, Laboratorio de Citogenetica de Mamiferos\t\t\t",
"LCMI\ts\tLoyola College\t\t\t",
"LCN\ts\tLincoln City and County Museum\t\t\t",
"LCO\ts\tInternational Red Locust Control Organization for Central and Southern Africa\t\t\t",
"LCP\tc\tFungal Strain Collection, Laboratory of Cryptogamy\t\t\t",
"LCR\ts\tRatcliffe College\t\t\t",
"LCS\ts\tInternational Red Locust Control Service\t\t\t",
"LCU\ts\tCatholic University of America\t\t\t",
"LCVA\ts\tLakeland College, Environmental Sciences Department\t\t\t",
"LD\ts\tBotanical Museum, Lunds University\t\t\t",
"LDL\ts\tLudlow Museum\t\t\t",
"LDM\ts\tLatvian Natural Histotry Museum, department of Entomology\t\t\t",
"LDPC\ts\tL. Deharveng, Universite Paul Sabatier\t\t\t",
"LDS\ts\tUniversity of Leeds\t\t\t",
"LDSN\ts\tLeeds Naturalists' Club\t\t\t",
"LDSP\ts\tLeeds Philosophical and Literary Society Museum\t\t\t",
"LE<BRA>\tc\tServico de Microbiologia e Imunologia\t\t\t",
"LE<RUS>\ts\tV. L. Komarov Botanical Institute\t\t\t",
"LEA\ts\tUniversity of Lethbridge, Biological Sciences Department\t\t\t",
"LEB<ESP>\ts\tUniversidad de Leon, Departamento de Biologia, Botanica\t\t\t",
"LEB<LVA>\ts\tEntomological Society of Latvia\t\t\t",
"LEC\ts\tUniversita degli Studi di Lecce, Dipartimento di Biologia\t\t\t",
"LECB\ts\tSaint Petersburg State University, Botany Department\t\t\t",
"LEDLIE\ts\tPatricia Ledlie Herbarium\t\t\t",
"LEF\ts\tEconomic Forestry Institute of Liaoning Province\t\t\t",
"LEH\ts\tLehigh University\t\t\t",
"LEI\ts\tLeicester Literary and Philosophical Society\t\t\t",
"LEISHCRYOBANK\tc\tInternational Cryobank of Leishmania\t\t\t",
"LEIUG\ts\tDepartment of Geology Leicester University\t\t\t",
"LEMA\ts\tUniversite du Maine\t\t\t",
"LEMQ\ts\tLyman Entomological Museum, McGill University,\tLEM\t\t",
"LEMT\ts\tEge University, Lodos Entomological Museum\t\t\t",
"LENUD\ts\tLenin University of Dagestan, Botany Department\t\t\t",
"LEP\ts\tAll-Union Institute for Plant Protection\t\t\t",
"LES\ts\tLeeds City Museum, Natural History Department\t\t\t",
"LET\ts\tLetchworth Naturalist's Society\t\t\t",
"LEUN\ts\tBischoefliches Gymnasium Josephinum\t\t\t",
"LEV\ts\tMinistry of Agriculture and Fisheries, Plant Protection Centre\t\t\t",
"LEYN\ts\tLeyton Reference Library\t\t\t",
"LFBKU\ts\tLaboratory of Fishery Biology\t\t\t",
"LFCC\ts\tLord Fairfax Community College, Natural Resources Department\t\t\t",
"LFG\ts\tCentre de Recherche de la Nature, des Forets et du Bois\t\t\t",
"LFM\ts\tMerseyside County Museums (formerly Liverpool Free Museum)\t\t\t",
"LG\ts\tUniversite de Liege, Departement de Botanique\t\t\t",
"LGBG\ts\tLewis Ginter Botanical Garden\t\t\t",
"LGBH\ts\tLoughborough Public Library\t\t\t",
"LGC\ts\tLaboratorio de Genetica da Conservacao\t\t\t",
"LGEMA<BRA>\ts\tLaboratorio de Genetica e Evolucao Molecular de Aves, Universidade de Sao Paulo\t\t\t",
"LGHF\ts\tUniversite de Liege\t\t\t",
"LGICT\ts\tLaboratoire de Geologie de l'Institut Catholique de Toulouse\t\t\t",
"LGM\ts\tLeningrad School of Mines\t\t\t",
"LGM-USP\tc\tDepartamento de Microbiologia Lab. de Genetica de Microrganismos\t\t\t",
"LGMF\tc\tCulture Collection of Laboratory of Genetics of Microorganisms, Federal University of Parana\t\t\t",
"LGO\ts\tColumbia University\t\t\t",
"LGPUT\ts\tLaboratory of Geology and Palaeontology\t\t\t",
"LGU\ts\tLeningrad State University\t\t\t",
"LHMS<ZAF >\tb\tLeslie Hill Molecular Systematics Laboratory\t\t\t",
"LHT\ts\tLahti City Museum\t\t\t",
"LI\ts\tBiology Centre of the Upper Austrian State Museum\t\t\t",
"LI:EVAR\ts\tBiology Centre of the Upper Austrian State Museum, Evertebrata Varia (Invertebrates other than Insects)\t\t",
"LI:INS\ts\tBiology Centre of the Upper Austrian State Museum, Insect collection\t\t",
"LI:VERT\ts\tBiology Centre of the Upper Austrian State Museum, Vertebrate collection\t\t",
"LIA\tc\tCryobank of Microorganisms\t\t\t",
"LIAIP\ts\tLaboratory of Ichthyology\t\t\t",
"LIB\ts\tUniversity of Liberia\t\t\t",
"LICPP\ts\tThe Crown Prince's Palace\t\t\t",
"LIG\ts\tSociedade de Geografia de Lisboa\t\t\t",
"LIH-UNAM\tc\tCulture Collection of Histoplasma capsulatum Strains from the Fungal Immunology Laboratory of the Department of Microbiology and Parasitology, Faculty of Medicine, UNAM\t\t\t",
"LIHUBA\ts\tUniversidad de Buenos Aires, Laboratorio de Investigaciones Herpetologicas\t\t\t",
"LIL\ts\tFundacion Miguel Lillo\t\t\t",
"LILLE\ts\tInstitut Catholique de Lille, Laboratoire de Biologie Vegetale\t\t\t",
"LIM\ts\tSeveroceske muzeum\t\t\t",
"LIMFC\ts\tLimerick Field Club\t\t\t",
"LIMK\ts\tLimerick Museum\t\t\t",
"LIMO\ts\tUniversite de Limoges\t\t\t",
"LIN-SB\tc\tLimnological Institute, Siberian Branch, Russian Academy of Sciences\t\t\t",
"LINC\ts\tLincoln University, Plant Sciences Group\t\t\t",
"LINCO\ts\tLinfield College\t\t\t",
"LINF\ts\tShanxi Normal University, Biology Department\t\t\t",
"LINHM\ts\tLong Island Natural History Museum\t\t\t",
"LINN\ts\tLinnean Society of London\t\t\t",
"LIP\ts\tUniversite de Lille, Departement de Botanique\t\t\t",
"LIPIMC\tc\tLembaga Ilmu Pengetahuan Indonesia, Indonesian Institute for Sciences\t\t\t",
"LIPP\tc\tLeptospirotheque\t\t\t",
"LIRP\ts\tLaboratorio de Ictiologia, Faculdade de Filosofia\t\t\t",
"LISC\ts\tInstituto de Investigacao Cientifica Tropical\t\t\t",
"LISE\ts\tEstacao Agronomica Nacional\t\t\t",
"LISFA\ts\tInstituto Nacional de Investigacao Agraria, Departamento Ecologia, Recursos Naturais e Ambiente\t\t\t",
"LISI\ts\tInstituto Superior de Agronomia\t\t\t",
"LISJC\ts\tJardim-Museu Agricola Tropical\t\t\t",
"LISM\ts\tMissao de Estudos Agronomicos do Ultramar\t\t\t",
"LISU\ts\tMuseu Nacional de Historia Natural\t\t\t",
"LISVA\ts\tMinisterio da Educacao\t\t\t",
"LIT\ts\tOblastni muzeum v Litomericich\t\t\t",
"LIUSP<BRA>\ts\tLaboratorio de Ictiogenetica, Universidade de Sao Paulo\t\t\t",
"LIV\ts\tLiverpool Museum\t\t\t",
"LIVC\ts\tLiverpool Botanic Garden\t\t\t",
"LIVCM\ts\tLiverpool County Museum\t\t\t",
"LIVNFC\ts\tLiverpool Naturalists' Field Club\t\t\t",
"LIVU\ts\tHartley Botanical Laboratories\t\t\t",
"LJC\tc\tColeccion de fitopatogenos de cultivos horticolas\t\t\t",
"LJF\ts\tSlovenian Forestry Institute\t\t\t",
"LJM\ts\tPrirodoslovni Muzej Slovenije\t\t\t",
"LJS\ts\tScientific Research Centre\t\t\t",
"LJU\ts\tUniversity of Ljubljana, Botany Department\t\t\t",
"LKHD\ts\tLakehead University, Biology Department\t\t\t",
"LL\ts\tUniversity of Texas at Austin, Plant Resources Center\t\t\t",
"LLANOS\ts\tUniversidad de los Llanos\t\t\t",
"LLC\ts\tOur Lady of the Lake University, Biology Department\t\t\t",
"LLN\ts\tLincolnshire Naturalists' Union\t\t\t",
"LLO\ts\tLloyd Library and Museum\t\t\t",
"LM\ts\tSeccao de Botanica e Ecologia\t\t\t",
"LMA\ts\tNational Institute of Agronomic Research, Botany Department\t\t\t",
"LMAD\ts\tLobbecke Museum und Aquazoo\t\t\t",
"LMC\ts\tInstituto de Investigacao Cientifica de Mozambique\t\t\t",
"LMCH\tc\tLaboratoire de Microbiologie\t\t\t",
"LMD\tc\tLaboratorium voor Microbiologie der Landbouwhogeschool\t\t\t",
"LMJ<MOZ>\ts\tCentro de Investigacao Cientifica Algodoeira, Botanical Department\t\t\t",
"LMKG\ts\tLandesmuseum fur Karnten\t\t\t",
"LMND\ts\tLandessammlungen fur Naturkunde\tLNMD\t\t",
"LMNH\ts\tMuseum d'Histoire naturelle\t\t\t",
"LMO\ts\tLandesmuseum Natur und Mensch\t\t\t",
"LMRZ\ts\tLivingstone Museum\t\t\t",
"LMS\tc\tCarolina Biological Supply Company\t\t\t",
"LMSZ\ts\tLatvian University, Museum of Systemic Zoology\t\t\t",
"LMU\ts\tEduardo Mondlane University, Department of Biological Sciences\t\t\t",
"LMZG\ts\tLocal Museum\t\t\t",
"LNAF\ts\tLiaoning Academy of Forestry\t\t\t",
"LNAU\ts\tLuhansk National Agrarian University\t\t\t",
"LNCM\ts\tLiaoning College of Traditional Chinese Medicine\t\t\t",
"LNCN\ts\tLincoln Memorial University\t\t\t",
"LNHS\ts\tLondon Natural History Society\t\t\t",
"LNKD\ts\tLandessammlung fur Naturkunde\tLNK\t\t",
"LNMO\ts\tOldenburg, Landesmuseum Natur und Mensch\t\t\t",
"LNNU\ts\tLiaoning Normal University, Biology Department\t\t\t",
"LNPV<FRA>\tc\t Laboratoire National de la Protection des Vegetaux\t\t\t",
"LO\ts\tType Collection\t\t\t",
"LOB\ts\tCalifornia State University, Biological Sciences Department\t\t\t",
"LOC\ts\tOccidental College, Biology Department\t\t\t",
"LOCK\tc\tCentre of Industrial Microorganisms Collection\t\t\t",
"LOD\ts\tLodz University, Department of Geobotany and Plant Ecology\t\t\t",
"LOJA\ts\tUniversidad Nacional de Loja, Departamento de Botanica y Ecologia\t\t\t",
"LOMA\ts\tLa Sierra University, Biology Department\t\t\t",
"LON\ts\tLembaga Oseanologie Nasional\t\t\t",
"LOU\ts\tC.I.T.A.-Xunta de Galicia\t\t\t",
"LP<ARG>\ts\tMuseo de La Plata, Herbario\t\t\t",
"LP<RUS>\ts\tLaboratory of Palaeontology\t\t\t",
"LPA\ts\tJardin Botanico Canario Viera y Clavijo, Unidad Asociada al CSIC\t\t\t",
"LPAG\ts\tUniversidad Nacional de La Plata, Area de Botanica\t\t\t",
"LPB\ts\tHerbario Nacional de Bolivia\t\t\t",
"LPC\ts\tHerbarium of the Division Ficologia Museo de La Plata\t\t\t",
"LPD\ts\tLaboratorio de Botanica de la Direccion de Agricultura\t\t\t",
"LPFU\ts\tLehrstuhl fur Palaontologie\t\t\t",
"LPL\ts\tThe University\t\t\t",
"LPN\ts\tLittlehampton Museum\t\t\t",
"LPS\ts\tUniversidad Nacional de La Plata, Instituto de Botanica Carlos Spegazzini\t\t\t",
"LPSC\tc\tLa Plata Spegazzini Collection\t\t\t",
"LPSNU\ts\tLiupanshui Normal University\t\t\t",
"LPSP\ts\tLumus Pond State Park, Whale Wallow Nature Center\t\t\t",
"LPUB\ts\tLaboratorul de Paleontologie\t\t\t",
"LPUP\ts\tLaboratoire de Parasitologie\t\t\t",
"LPVM\ts\tLaboratoire de Paleontologie des Vertebres et de Paleontologie\t\t\t",
"LPVPH\ts\tLaboratoire de Paleontologie des Vertebres et de Paleontologie Humaine\t\t\t",
"LR\ts\tMuseum d'Histoire Naturelle\t\t\t",
"LRL\ts\tHistoric Society of Lancashire and Cheshire\t\t\t",
"LRS\ts\tAgriculture Research Center, Land Resource Sciences Section\t\t\t",
"LRTE\ts\tLa Retraite (Convent School)\t\t\t",
"LRU\ts\tUniversity of Arkansas at Little Rock, Biology Department\t\t\t",
"LS<CUB>\ts\tColegio de La Salle\t\t\t",
"LS<GBR>\ts\tLinnean Society of London\tLSUK\t\t",
"LSA\ts\tLytham St. Annes Public Library\t\t\t",
"LSAM\ts\tLouisiana State Arthropod Museum\t\t\t",
"LSC\ts\tLyndon State College, Natural Sciences Department\t\t\t",
"LSCR\ts\tOrganization for Tropical Studies, La Selva Biological Station\t\t\t",
"LSDC\ts\tLiangshan Institute for Drug Control\t\t\t",
"LSHB\tc\tLondon School of Hygiene and Tropical Medicine, Biochemistry Department\tLSH\t\t",
"LSHI\ts\tUniversite Nationale du Zaire\t\t\t",
"LSN\ts\tLord Wandsworth College Natural History Museum\t\t\t",
"LSP\ts\tLake Superior Provincial Park\t\t\t",
"LSR\ts\tLeicestershire Museums Service\t\t\t",
"LSRFC\ts\tLeicestershire Flora Committee\t\t\t",
"LSSC\ts\tLake Superior State College\t\t\t",
"LSTM\tc\tDepartment of Parasitology\t\t\t",
"LSU\ts\tLouisiana State University, Biological Sciences Department\tLSUM\t\t",
"LSUHC\ts\tLa Sierra University, Herpetological Collection\t\t\t",
"LSUM\ts\tLouisiana State University, Biological Sciences Department\tLSU\t\t",
"LSUMZ\ts\tLouisiana State University, Musuem of Zoology\tLSUMNS\t\t",
"LSUMZ:FrozenTissue\ts\tLouisiana State University, Musuem of Zoology, Frozen Tissue Collection\t\t",
"LSUMZ:Herpetology\ts\tLouisiana State University, Musuem of Zoology, Herpetology Collection\t\t",
"LSUMZ:Ichthyology\ts\tLouisiana State University, Musuem of Zoology, Ichthyology Collection\t\t",
"LSUMZ:Mammalogy\ts\tLouisiana State University, Musuem of Zoology, Mammal Collection\t\t",
"LSUMZ:Ornithology\ts\tLouisiana State University, Musuem of Zoology, Bird Collection\t\t",
"LSUS\ts\tMuseum of Life Sciences, Louisiana State University\t\t\t",
"LT\ts\tUniversite de Montreal\t\t\t",
"LTB\ts\tLa Trobe University, Botany Department\t\t\t",
"LTCC-IOC\tc\tLeishmania Type Culture Collection\t\t\t",
"LTH\ts\tMuseum of Louth Naturalists' Antiquity and Literary Society\t\t\t",
"LTHP\ts\tLouth Public Library\t\t\t",
"LTI\tc\tCryobank of Microorganisms-Destructors\t\t\t",
"LTM\ts\tTekovske muzeum\t\t\t",
"LTN\ts\tLuton Museum and Art Gallery\t\t\t",
"LTR\ts\tUniversity of Leicester, Biology Department\t\t\t",
"LTU\ts\tLouisiana Tech University\t\t\t",
"LU<CHN>\ts\tLingnan University\t\t\t",
"LU<RUS>\ts\tSt. Petersburg University\t\t\t",
"LUA\ts\tInstituto de Investigacao Agronomica\t\t\t",
"LUAI\ts\tex-Centro Nacional de Investigacao Cientifica (CNIC)\t\t\t",
"LUB\ts\tNaturhistorisches Museum zu Luebeck\t\t\t",
"LUBA\ts\tInstituto Superior de Ciencias da Educacao\t\t\t",
"LUBEE\tb\tLubee Bat Conservancy\t\t\t",
"LUCAS\ts\tFrancesc de Lucas i Alcover\t\t\t",
"LUCCA\ts\tComune di Lucca\t\t\t",
"LUCH\ts\tMusee du Pays de Luchon\t\t\t",
"LUD\ts\tLudlow Natural History Society\t\t\t",
"LUG\ts\tMuseo cantonale di storia naturale\t\t\t",
"LUGO\ts\tUniversidad de Satniago de Compostela, Departamento de Produccion Vegetal\t\t\t",
"LUH\ts\tUniversity of Lagos, Department of Botany\t\t\t",
"LUH<NLD>\tc\tLeiden University Medical Center\t\t\t",
"LUKI\ts\tInstitut National pour l'Etude et la Recherche Agronomiques\t\t\t",
"LUNZ\ts\tLincoln University Entomology Research Museum\t\t\t",
"LUQ\ts\tLaval University\t\t\t",
"LUS\ts\tLushan Botanical Garden\t\t\t",
"LUSC\ts\tUniversidade do Estado de Santa Catarina\t\t\t",
"LUW\ts\tLandbouwuniversiteit Wageningen, Department of Entomology\t\t\t",
"LUX\ts\tMusee national d'histoire naturelle\t\t\t",
"LV\ts\tCatholic University of Leuven, Laboratory of Plant Systematics\t\t\t",
"LVNP\ts\tLassen Volcanic National Park\t\t\t",
"LVP-GSC\ts\tLaboratory of Vertebrate Paleontology\t\t\t",
"LW\ts\tIvan Franko National University of Lviv, Botany Department\t\t\t",
"LWA\ts\tAgricultural Experiment Station\t\t\t",
"LWD\ts\tMuseum Dzieduszyckich\t\t\t",
"LWG\ts\tNational Botanical Research Institute\t\t\t",
"LWI\ts\tCentre de Recherche en Sciences Naturelles (CRSN/Lwiro)\t\t\t",
"LWKS\ts\tInstitute of Ecology of the Carpathians\t\t\t",
"LWL<DEU>\ts\tLWL-Museum fuer Naturkunde\t\t\t",
"LWL<DEU>:DNA\tb\tLWL-Museum fuer Naturkunde, LWL-DNA- und Gewebearchiv\t\t",
"LWS\ts\tMuseum of Natural History, Lviv\t\t\t",
"LWSM\ts\tLewes Museum, Ann of Cleves House\t\t\t",
"LWU\ts\tUniversity of Lucknow, Botany Department\t\t\t",
"LY\tsc\tUniversite Claude Bernard\t\t\t",
"LYAC\ts\tLaiyang Agricultural College, Department of Basic Courses\t\t\t",
"LYCC\tc\tLallemand Yeast Culture Collection\t\t\t",
"LycoCC\tc\tThe Lycoming College Culture Collection\t\t\t",
"LYD\ts\tMpumalanga Parks Board\t\t\t",
"LYJB\ts\tJardin Botanique de Lyon\t\t\t",
"LYN\ts\tLynchburg College, Biology Department\t\t\t",
"LZ\ts\tUniversitaet Leipzig\t\t\t",
"LZAH\ts\tLanzhou Institute of Animal Science, Chinese Academy of Agricultural Sciences\t\t\t",
"LZD\ts\tLanzhou Institute of Desert Research, Academia Sinica\t\t\t",
"LZFD\ts\tLaboratoire Zoologique\t\t\t",
"LZLP\ts\tUniversidade de Lisboa\t\t\t",
"LZU\ts\tLanzhou University\t\t\t",
"LZUH\ts\tLaboratoire de Zoologie, Universite de Hanoi\t\t\t",
"M\ts\tBotanische Staatssammlung Muenchen\t\t\t",
"MA\ts\tReal Jardin Botanico\t\t\t",
"MA:Algae\ts\tReal Jardin Botanico, Algae collection\t\t",
"MA:Fungi\ts\tReal Jardin Botanico, Fungi collection\t\t",
"MA:FunHist\ts\tReal Jardin Botanico, Historical fungi colleciton\t\t",
"MA:Hepat\ts\tReal Jardin Botanico, Liverwort collection\t\t",
"MA:Lichen\ts\tReal Jardin Botanico, Lichen collection\t\t",
"MA:Musci\ts\tReal Jardin Botanico, Bryophyte collection\t\t",
"MAA\ts\tEscuela Tecnica Superior de Ingenieros Agronomos, Departamento de Produccion Vegetal\t\t\t",
"MAAS\ts\tNatuurhistorisch Museum Maastricht, Botany Department\t\t\t",
"MAB\ts\tMusee Anne de Beaujeu\t\t\t",
"MAC\ts\tInstituto do Meio Ambiente\t\t\t",
"MACA\ts\tParque da Reserva de Siac Pai van Coloane Island\t\t\t",
"MACB\ts\tUniversidad Complutense, Departamento de Biologia Vegetal 1\t\t\t",
"MACF\ts\tCalifornia State University, Biological Science Department\t\t\t",
"MACN\ts\tMuseo Argentino de Ciencias Naturales Bernardino Rivadavia\tMACN-RN,MACNCH\t\t",
"MACO\ts\tMarlborough College, Biology Department\tMBH\t\t",
"MAD<IND>\ts\tMadras Museum\t\t\t",
"MAD<USA-WI>\ts\tForest Products Laboratory\t\t\t",
"MADJ\ts\tJardim Botanico da Madeira\t\t\t",
"MADM\ts\tMuseu Municipal do Funchal\t\t\t",
"MADS\ts\tMuseu de Historia Natural do Seminario do Funchal\t\t\t",
"MAF\ts\tUniversidad Complutense, Departamento de Biologia Vegetal II\t\t\t",
"MAFF\tc\tMAFF Genebank, Ministry of Agriculture Forestry and Fisheries\t\t\t",
"MAFF<FJI>\ts\tColo-i-Suva Silvicultural Station\t\t\t",
"MAFI\ts\tMagyar Allami Foeldtani Intezet, Budapest - Hungarian Geological Survey\t\t\t",
"MAFST\ts\tInstituto Forestal de la Moncloa\t\t\t",
"MAG\ts\tInstitute of Biological Problems of the North\t\t\t",
"MAGB\ts\tNational Museum and Art Gallery, Gaberone\t\t\t",
"MAGD\ts\tNorthern Territory Museum of Arts and Sciences\t\t\t",
"MAGNT<AUS>\ts\tMuseums and Art Galleries of the Northern Territory\tNTM<AUS>\t\t",
"MAGNT<AUS>:A\ts\tMuseums and Art Galleries of the Northern Territory, Arachnid Collection\t\t",
"MAGNT<AUS>:C\ts\tMuseums and Art Galleries of the Northern Territory, Cnidarian Collection\t\t",
"MAGNT<AUS>:Cr\ts\tMuseums and Art Galleries of the Northern Territory, Crustacean Collection\t\t",
"MAGNT<AUS>:D\ts\tMuseums and Art Galleries of the Northern Territory, Minor Invertebrate Collection\t\t",
"MAGNT<AUS>:E\ts\tMuseums and Art Galleries of the Northern Territory, Ascidian Collection\t\t",
"MAGNT<AUS>:G\ts\tMuseums and Art Galleries of the Northern Territory, Bryozoan Collection\t\t",
"MAGNT<AUS>:I\ts\tMuseums and Art Galleries of the Northern Territory, Insect Collection\t\t",
"MAGNT<AUS>:M\ts\tMuseums and Art Galleries of the Northern Territory, Myriapod Collection\t\t",
"MAGNT<AUS>:N\ts\tMuseums and Art Galleries of the Northern Territory, Pycnogonid Collection\t\t",
"MAGNT<AUS>:P\ts\tMuseums and Art Galleries of the Northern Territory, Malacology Collection\t\t",
"MAGNT<AUS>:Q\ts\tMuseums and Art Galleries of the Northern Territory, Echinoderm Collection\t\t",
"MAGNT<AUS>:R\ts\tMuseums and Art Galleries of the Northern Territory, Herpetology Collection\t\t",
"MAGNT<AUS>:S\ts\tMuseums and Art Galleries of the Northern Territory, Fish Collection\t\t",
"MAGNT<AUS>:T\ts\tMuseums and Art Galleries of the Northern Territory, Bird Collection\t\t",
"MAGNT<AUS>:U\ts\tMuseums and Art Galleries of the Northern Territory, Mammal Collection\t\t",
"MAGNT<AUS>:W\ts\tMuseums and Art Galleries of the Northern Territory, Annelid Collection\t\t",
"MAGNT<AUS>:Z\ts\tMuseums and Art Galleries of the Northern Territory, Poriferan Collection\t\t",
"MAH\ts\tDepartment of Agricultural Research\t\t\t",
"MAIA\ts\tInstituto Nacional de Investigaciones Agrarias, Departamento de Ecologia\t\t\t",
"MAIC\ts\tMediterranean Agronomic Institute of Chania, Department of Natural Products\t\t\t",
"MAINE\ts\tUniversity of Maine, Department of Biological Sciences\t\t\t",
"MAIS\ts\tInstitut d'Elevage et de Medecine Veterinaire des Pays Tropicaux, Departement de Botanique\t\t\t",
"MAK\ts\tTokyo Metropolitan University, Makino Herbarium\t\t\t",
"MAKAR\ts\tInstitut Planina i More\t\t\t",
"MAKFUNGI\ts\tMacedonian Collection of Fungi,Institute of Biology\tFungi Macedonici\t\t",
"MAL\ts\tBotanic Gardens of Malawi\t\t\t",
"MALA\ts\tMalaspina University, Biology Department\t\t\t",
"MALC\ts\tMuseu Municipal de la Vila d'Alcover\t\t\t",
"MALS\ts\tManti-LaSal National Forest\t\t\t",
"MAMU\ts\tUniversity of Sydney, Macleay Museum\t\t\t",
"MAN\ts\tUniversitas Cenderawasih\t\t\t",
"MANCH\ts\tUniversity of Manchester\t\t\t",
"MAND\ts\tAgricultural College and Research Institute\t\t\t",
"MANK\ts\tMinnesota State University-Mankato, Department of Biological Sciences\t\t\t",
"MAO\tc\tMircen Afrique Ouest\t\t\t",
"MAO<MYT>\ts\tConservatoire Botanique National de Mascarin (Mayotte)\t\t\t",
"MAPR\ts\tUniversity of Puerto Rico, Mayagueez Campus, Biology Department\t\t\t",
"MAR\tc\tGrasslands Rhizobium Collection\t\t\t",
"MAR<BRA>\ts\tUniversidade Federal do Maranhao\t\t\t",
"MARDI\ts\tMalaysian Agricultural Research and Development Institute\tMDI\t\t",
"MARE\ts\tMarmara University, Department of Pharmaceutical Botany\t\t\t",
"MARI\ts\tMari State University\t\t\t",
"MARK\ts\tCadi Ayyad University\t\t\t",
"MARO\ts\tMarylhurst College\t\t\t",
"MARS\ts\tUniversite de Provence Centre St-Charles, case 4\t\t\t",
"MARSSJ\ts\tUniversite Paul Cezanne\t\t\t",
"MARY\ts\tUniversity of Maryland\t\t\t",
"MASE\ts\tMaseru Experiment Station\t\t\t",
"MASS\ts\tUniversity of Massachusetts, Biology Department\t\t\t",
"MATSU\ts\tEhime University, Forestry Department\t\t\t",
"MAU\ts\tMauritius Sugar Industry Research Institute\t\t\t",
"MAUAM\ts\tUniversidad Autonoma de Madrid\t\t\t",
"MAY\ts\tAdygean State University, Department of Botany\t\t\t",
"MAZHAR\ts\tMazhar Botanical Garden\t\t\t",
"MB\ts\tIndonesian Biodiversity Research Center\t\t\t",
"MB<DEU-Berlin>\ts\tMuseum of Natural History of Humboldt-University\t\t\t",
"MB<DEU-Marburg>\ts\tPhilipps-Universitaet, Spezielle Botanik\t\t\t",
"MB<PRT>\ts\tMuseu Nacional de Histo&#769;ria e da Cie&#770;ncia de Lisboa, Universidade de Lisboa\t\t\t",
"MBA\ts\tEnvironmental Protection Agency\t\t\t",
"MBAB\ts\tMuseo Biblioteca Archivio\t\t\t",
"MBAC\ts\tMuseo del Dipartimento di Biologia Animale dell'Universita\t\t\t",
"MBAP\ts\tMuseo del Dipartimento di Biologia Animale dell'Universita\t\t\t",
"MBBJ\ts\tMuseum Zoologicum Bogoriense, Entomology Collection\t\t\t",
"MBC\tsb\tMontgomery Botanical Center\tMBC<USA>\t\t",
"MBCG\ts\tMuseo di Scienze Naturali \"Enrico Caffi\"\t\t\t",
"MBCSC\ts\tMarine Biodiversity Collection of South China Sea, Chinese Academy of Sciences\t\t\t",
"MBCSC:Fish\ts\tMarine Biodiversity Collection of South China Sea, Chinese Academy of Sciences, Fish Collection\t\t",
"MBG\ts\tFachberich Geowissenschaften\t\t\t",
"MBIC\tc\tMarine Biotechnology Institute Culture Collection\t\t\t",
"MBK\ts\tKochi Prefectural Makino Botanical Garden, Botany Department\t\t\t",
"MBL\ts\tMuseu Nacional de Historia Natural\t\t\t",
"MBLUZ\ts\tMuseo de Biologia de la Universidad del Zulia\t\t\t",
"MBM<BRA>\ts\tMuseu Botanico Municipal\t\t\t",
"MBM<USA-CA>\ts\tSan Jose State University, Museum of Birds and Mammals\t\t\t",
"MBM<USA-NV>\ts\tMarjorie Barrick Museum\t\t\t",
"MBML\ts\tMuseu de Biologia Mello Leitao\t\t\t",
"MBML:Anfibios\ts\tMuseu de Biologia Mello Leitao, Anfibios Collection\t\t",
"MBML:Aves\ts\tMuseu de Biologia Mello Leitao, Aves collection\t\t",
"MBML:Mamiferos\ts\tMuseu de Biologia Mello Leitao, Mamiferos collection\t\t",
"MBML:Peixes\ts\tMuseu de Biologia Mello Leitao, Peixes Collection\t\t",
"MBML:Repteis\ts\tMuseu de Biologia Mello Leitao, Repteis Collection\t\t",
"MBMU\tc\tInstitute of Molecular Biology and Genetics (IMBG), Mahidol University\t\t\t",
"MBR\ts\tMuseo Argention de Ciencias Naturales \"Bernardino Rivadavia\"\t\t\t",
"MBS\ts\tManchester Banksian Society\t\t\t",
"MBSL\ts\tRoyal Medico-Botanical Society\t\t\t",
"MBSN\ts\tMuseo Brembano di Scienze Naturali\t\t\t",
"MBUCV\ts\tMuseo de Biologia de la Universidad Central de Venezuela\tCBFC,MBUC\t\t",
"MBY\ts\tMuseum Biologi Yogyakarta\t\t\t",
"MBZH\ts\tMuseo y Biblioteca de la Zoologia\t\t\t",
"MC\ts\tAvery Island Archives\t\t\t",
"MCA\ts\tMuhlenberg College, Biology Department\t\t\t",
"MCAS\ts\tMuseo Civico Archeologico e di Scienze Naturali \"F. Eusebio\"\t\t\t",
"MCBR\ts\tMuseo Civico \"Baldassarre Romano\"\t\t\t",
"MCC\tc\tNational Centre for Microbial Resource (Microbial Culture Collection)\tMCC\t\t",
"MCC-UPLB\tc\tMicrobial Culture Collection\t\t\t",
"MCCA\ts\tUniversidade Federal de Minas Gerais\t\t\t",
"MCCB\ts\tMuseo Civico \"Craveri\"\t\t\t",
"MCCC\tc\tMarine Culture Collection of China\t\t\t",
"MCCC<USA>\ts\tMendocino College Coast Center\t\t\t",
"MCCI\ts\tMuseo Civico di Storia Natural de Carmognola\t\t\t",
"MCCM<DEU>\tc\tMedical Culture Collection Marburg\t\t\t",
"MCCM<IND>\ts\tMadras Christian College\t\t\t",
"MCD\ts\tMuzeul Civilizatiei Dacice si Romane Deva\t\t\t",
"MCDNL\ts\tMcDaniel College\t\t\t",
"MCES\ts\tMuseum of the Center for Entomological Studies\t\t\t",
"MCF\ts\tSts. Cyril and Methodius University\t\t\t",
"MCF-PVPH\ts\tMuseo Carmen Funes\t\t\t",
"MCFB\ts\tMuseo de la Cienica Fundacion\t\t\t",
"MCFM\ts\tMuseo Civico \"Francesco Mina Palumbo\"\t\t\t",
"MCFS\ts\tMuseo Civico di Storia Naturale, Ferrara\t\t\t",
"MCG\ts\tMuseo Civico DI Storia Naturale 'Giacomo Doria'\t\t\t",
"MCGMK\ts\tMcGregor Memorial Museum\t\t\t",
"MCGS\ts\tMuseo Civico \"Giuseppe Scarabelli\"\t\t\t",
"MCIZ\ts\tMuseo Cambria, Istituto di Zoologia dell'Universita\t\t\t",
"MCJ\ts\tMissouri Southern State College, Biology Department\t\t\t",
"MCLSBB\ts\tMuseo Colegio La Salle Bonanova de Barcelona\t\t\t",
"MCM<CAN>\ts\tHamilton College, McMaster University, Biology Department\t\t\t",
"MCM<FRA>\ts\tInstitut de Paleontologie, Museum d'Histoire naturelle\t\t\t",
"MCM<IND>\tc\tMACS Collection of Microorganisms\t\t\t",
"MCM<PRT>\ts\tMuseu Carlos Machado\t\t\t",
"MCMC\ts\tMuseo de Historia Natural de la Ciudad de Mexico\t\t\t",
"MCMJ\ts\tMc Master University\t\t\t",
"MCMS\ts\tMuseo Civico di Storia Naturale, Morgegno\t\t\t",
"MCN\ts\tMcNeese State University, Biology Department\t\t\t",
"MCNA\ts\tMuseo de Ciencias naturals de Alava\t\t\t",
"MCNB\ts\tNatural Sciences Museum of Barcelona (Museu de Ciencies Naturals de Barcelona)\t\t\t",
"MCNC\ts\tMuseo de Ciencias Naturales\t\t\t",
"MCNG\ts\tMuseo de Ciencias Naturales de la UNELLEZ en Guanare\t\t\t",
"MCNPV\ts\tFundacao Zoobotanica do Rio Grande do Sul\tMCN\t\t",
"MCNS\ts\tUniversidad Nacional de Salta, Facultad de Ciencias Naturales\t\t\t",
"MCNV\ts\tMuseo Civico di Storia Naturale, Venice\t\t\t",
"MCNZ\ts\tPorto Alegre, Museu de Ciencias Naturais da Fundacao Zoo-Botanica do Rio Grande do Sul\t\t\t",
"MCP<BRA>\ts\tMuseu de Ciencias e Tecnologia, Pontificia Universidade Catolica do Rio Grande do Sul\tMCPPV \t\t",
"MCP<USA-MA>\ts\tMassachusetts College of Pharmacy and Allied Health Sciences, Biological Sciences Department\t\t\t",
"MCPM\ts\tMilwaukee City Public Museum\t\t\t",
"MCPPV\ts\tMuseu de Ciencias e Tecnologia\tMCP<BRA>\t\t",
"MCR\ts\tManchester Literary and Philosophical Society\t\t\t",
"MCRA\ts\tSezione Archeologia, Storia e Scienze Naturali\t\t\t",
"MCRBS\ts\tManchester Botanical and Horticultural Society\t\t\t",
"MCSB\ts\tMuseo Civico di Scienze Naturali\t\t\t",
"MCSC\ts\tColorado Springs, May Natural History Museum\t\t\t",
"MCSF\ts\tMuseo Civico di Scienze Naturali\t\t\t",
"MCSG\ts\tMuseo Civico di Storia Naturale, Grosseto\t\t\t",
"MCSN<ITA-Genova>\ts\tMuseo Civico di Storia Naturale \"Giacomo Doria\"\t\t\t",
"MCSN<ITA-Verona>\ts\tMuseo Civico di Storia Naturale, Verona\t\t\t",
"MCSNC\ts\tMuseo Civico di Storia Naturale, Carmagnola\tMSNC\t\t",
"MCSNIO\ts\tMuseo Civico di Scienze Naturali di Induno Olona\t\t\t",
"MCST\ts\tMuseo Civico di Storia Naturale, Trieste\t\t\t",
"MCT\ts\tMichigan Technological University, Biological Sciences Department\t\t\t",
"MCTC\ts\tCryptogamic Herbarium, Michigan Technological University\t\t\t",
"MCTP\ts\tMuseu de Ciencias\t\t\t",
"MCVE\ts\tMuseo di Storia Naturale di Venezia\t\t\t",
"MCVM\ts\tMuseo Civico, Villa Mirabello\t\t\t",
"MCW\ts\tMilton College, Biology Department\t\t\t",
"MCZ\ts\tMuseum of Comparative Zoology, Harvard University\tMCZC\t\t",
"MCZ:Cryo\ts\tMuseum of Comparative Zoology, Harvard University, Cryogenic Collection\t\t",
"MCZ:Ent\ts\tMuseum of Comparative Zoology, Harvard University, Entomology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:Ent:",
"MCZ:Herp\ts\tMuseum of Comparative Zoology, Harvard University, Herpetology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:Herp:",
"MCZ:Ich\ts\tMuseum of Comparative Zoology, Harvard University, Ichthyology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:Fish:",
"MCZ:IP\ts\tMuseum of Comparative Zoology, Harvard University, Invertebrate Paleontology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:IP:",
"MCZ:IZ\ts\tMuseum of Comparative Zoology, Harvard University, Invertebrate Zoology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:IZ:",
"MCZ:Mala\ts\tMuseum of Comparative Zoology, Harvard University, Malacology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:Mala:",
"MCZ:Mamm\ts\tMuseum of Comparative Zoology, Harvard University, Mammalogy Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:Mamm:",
"MCZ:Orn\ts\tMuseum of Comparative Zoology, Harvard University, Ornithology Collection\thttp://mczbase.mcz.harvard.edu/guid/MCZ:Bird:",
"MCZ:PORa\ts\tMuseum of Comparative Zoology, Harvard University, Porifera collection\t\t",
"MCZR\ts\tMuseo Civico di Zoologia\t\t\t",
"MD<AGO>\ts\tMuseu Regional do Dundo\t\t\t",
"MD<DEU>\ts\tMuseum Donaueschingen\t\t\t",
"MDC\tc\tMicrobial Depository Center (National Microbial Culture Collection of the Republic of Armenia)\t\t\t",
"MDE\ts\tMusee des Dinosaures in Esperaza\t\t\t",
"MDFW\ts\tMassachusetts Division of Fisheries and Wildlife\t\t\t",
"MDH<GBR>\ts\tDorman Museum\t\t\t",
"MDH<USA-MI>\tc\tMichigan Department of Health\t\t\t",
"MDI\ts\tMalaysian Agricultural Research and Development Institute\tMARDI\t\t",
"MDKY\ts\tMorehead State University, Biological and Environmental Sciences Department\t\t\t",
"MDLA\ts\tMuseu do Dundo\t\t\t",
"MDM\ts\tMifune Dinosaur Museum\t\t\t",
"MDNR\ts\tManitoba Conservation\t\t\t",
"MDP\ts\tMuseum de Poligny\t\t\t",
"MDRG\ts\tMuseum voor Dierkunde, Rijksuniversiteit\t\t\t",
"MDTN\ts\tMiddleton Botanical Society\t\t\t",
"MDUG\ts\tUniversidad Guanajuato, Museo Alfredo Duges\t\t\t",
"MDZAU\ts\tMuseum Deptartment of Zoology\t\t\t",
"MECB\ts\tUniversidade Federal de Pelotas, Museu Entomologico Ceslau Biezanko\t\t\t",
"MECG\ts\tMedical Entomology Collection Gallery\t\t\t",
"MECN\ts\tMuseo Ecuadoriano de Ciencias Naturales\tDHMECN\t\t",
"MEDEL\ts\tUniversidad Nacional de Colombia - Sede de Medellin, Departamento de Biologia\t\t\t",
"MEFLG\ts\tMuseo Entomologico Francisco Luis Gallego\t\t\t",
"MEL\ts\tRoyal Botanic Gardens Victoria\t\t\t",
"MELG\ts\tGeology Department, University of Melbourne\t\t\t",
"MELIT\ts\tBogdan Khmel'nysckyi State Pedagogical University of Melitopol'\t\t\t",
"MELU\ts\tUniversity of Melbourne\t\t\t",
"MEM\ts\tUniversity of Memphis, Biology Department\t\t\t",
"MEMO\ts\tInstituto Tecnologico y de Estudios Superiores de Monterrey, Departamento de Recursos Naturales\t\t\t",
"MEN\ts\tUNCuyo, Catedra de Botanica Agricola, Departamento de Ciencias Biologicas\t\t\t",
"MENDE\ts\tMusee Ignon-Fabre\t\t\t",
"MEPAN\ts\tMuseum of Evolution, Polish Academy of Sciences\t\t\t",
"MER\ts\tUniversidad de Los Andes\t\t\t",
"MERC\ts\tUniversidad de Los Andes, Centro Jardin Botanico\t\t\t",
"MERCA\ts\tMercer Arboretum and Botanic Gardens\t\t\t",
"MERF\ts\tUniversidad de Los Andes, Facultad de Farmacia\t\t\t",
"MERL\ts\tInstituto Argentino de Investigaciones de las Zonas Aridas (CRICYTME)\t\t\t",
"MESA\ts\tMesa State College, Biology Department\t\t\t",
"METZ\ts\tMusee de la Cour d'Or - Metz Metropole\t\t\t",
"MEUC\ts\tUniversidad de Chile\t\t\t",
"MEX\ts\tMuseo de Historia Natural de la Ciudad de Mexico\t\t\t",
"MEXU\ts\tHerbario Nacional de Mexico, Universidad Nacional Autonoma de Mexico\tIBUNAM:MEXU\t\t",
"MFA\ts\tMuseo Provincial de Ciencias Naturales Florentino Ameghino, Seccion Botanica\t\t\t",
"MFA-ZV-M\ts\tMuseo Florentino Ameghino, Coleccion de Mastozoologia (Argentina)\t\t\t",
"MFAP\ts\tArchaeology and Palaeontology\t\t\t",
"MFB\ts\tSouthern Research Station\t\t\t",
"MFC\tc\tMatsushima Fungus Collection\t\t\t",
"MFGC\tc\tMargot Forde Germplasm Centre, AgResearch GrasslandsWar\t\t\t",
"MFLB\ts\tMarine Fisheries Laboratory\t\t\t",
"MFLU\tsc\tMae Fah Laung University Herbarium\tMFLU<THA>\t\t",
"MFLUCC\tc\tMae Fah Luang University Culture Collection\t\t\t",
"MfN<DEU>\ts\tMuseum fur Naturkunde\t\t\t",
"MFNB\ts\tMuseo Friulano di Storia Naturale\t\t\t",
"MFP\ts\tMuseo Felipe Poey\t\t\t",
"MFRU\ts\tMalawi Fisheries Research Unit\t\t\t",
"MFS\ts\tMuseo dei Fisiocritici\t\t\t",
"MFSN\ts\tMuseo Friulano di Storia Naturale of Udine\t\t\t",
"MFU\ts\tMuseo Friulano di Storia Naturale\t\t\t",
"MFUM\ts\tMuseum of Ferdowsi University of Mashhad\t\t\t",
"MFUW\ts\tChinzombo Research Station, Chinzombo Wildlife Research Station\t\t\t",
"MFW\ts\tMuseum Freriks\t\t\t",
"MG<BRA>\ts\tMuseu Paraense Emilio Goeldi, Departamento de Botanica\t\t\t",
"MG<CHN>\ts\tMuseum of Zoology\t\t\t",
"MGA\ts\tInstituto Pedagogico de Varones\t\t\t",
"MGAB\ts\tMuzeul de Istorie Naturala \"Grigore Antipa\"\t\t\t",
"MGAP\ts\tMuseu Anchieta\tMAPA\t\t",
"MGB\ts\tMuseo de Geologia (del Seminario Diocesano) de Barcelona\t\t\t",
"MGC\ts\tUniversidad de Malaga, Departamento de Biologia Vegetal\t\t\t",
"MGDL\ts\tMuseum d'Histoire Naturalle du Grand-Duchy de Luxembourg\t\t\t",
"MGF\ts\tMuseum George Frey\t\t\t",
"MGFT\ts\tMuseum G. Frey\t\t\t",
"MGH\ts\tMuseum Godeffroy\t\t\t",
"MGHF\ts\tMuseo Geologico H. Fuenzalida\t\t\t",
"MGHNL\ts\tMusee Guimet d'Histoire Naturelle de Lyon\t\t\t",
"MGHSJ\ts\tMatuyama Girl's High School\t\t\t",
"MGI\ts\tGeological Institute of the Mongolian Academy of Sciences\t\t\t",
"MGL\ts\tMusee Geologique de Lausanne\t\t\t",
"MGR\ts\tUniversity of Michigan\t\t\t",
"MGRI\ts\tMoscow Geological Prospecting Institute\t\t\t",
"MGS\ts\tUpper Silesian Museum, Department of Natural History\t\t\t",
"MGSI\ts\tMuseum of the Geological Survey of Iran\t\t\t",
"MGSP\ts\tMuseum of the Geological Survey of Portugal\t\t\t",
"MGUG\ts\tMuseum fuer Geologie und Palaontologie der Georg-August-Universitat\t\t\t",
"MGUH\ts\tMuseum Geologicum Universitatis Hafniensis\t\t\t",
"MGUP\ts\tMuseo Geologico della Universita Pisa\t\t\t",
"MGUV\ts\tMuseo del Departamento de Geologia, Universidad de Valencia\t\t\t",
"MGUWR\ts\tInstitute of Geological Sciences, University of Wroclaw\t\t\t",
"MH<CHE>\ts\tNaturhistorisches Museum, Basel\t\t\t",
"MH<IND>\ts\tTamil Nadu Agricultural University\t\t\t",
"MHA\ts\tMain Botanical Garden of the Russian Academy of Sciences\t\t\t",
"MHES\ts\tMuseo de Historia Natural de El Salvador\t\t\t",
"MHH\tc\tInstitute of Virology\t\t\t",
"MHL\ts\tMildenhall and District Museum\t\t\t",
"MHM\ts\tMalham Tarn Field Centre\t\t\t",
"MHMN\ts\tMuseu Historic Municipal de Novelda\t\t\t",
"MHNA\ts\tMuseum d'Histoire Naturelle d'Autun\t\t\t",
"MHNB\ts\tMuseum d'Histoire Naturelle de Bale\t\t\t",
"MHNC<CHE>\ts\tMusee d'Histoire Naturelle - La Chaux-de-Fonds\tLCFM\t\t",
"MHNC<CHL>\ts\tMuseo de Historia Natural de Concepcion (Chile)\t\t\t",
"MHNCSJ\ts\tMuseo de Historia Natural\t\t\t",
"MHNES\ts\tMuseo de Historia Natural de El Salvador\t\t\t",
"MHNG\ts\tNatural History Museum of Geneva\t\t\t",
"MHNG:Herp\ts\tNatural History Museum of Geneva, Herpetology collection\t\t",
"MHNG:Invertebrate\ts\tNatural History Museum of Geneva, Invertebrate collection\t\t",
"MHNH\ts\tMuseo Nacional de Historia Natural de Cuba\tMNHNCU\t\t",
"MHNI\ts\tMuseu Hist. Naturales Universidade Federal Minas Gerais\t\t\t",
"MHNJP\ts\tUniversidad Nacional Mayor de San Marcos\tMNHNJP\t\t",
"MHNL\ts\tMusee Guimet d'Histoire Naturelle de Lyon\t\t\t",
"MHNLR\ts\tMuseum d'Histoire Naturelle\tMHNR\t\t",
"MHNLS\ts\tColeccion de Mastozoologia, Museo de Historia Natural de La Salle\t\t\t",
"MHNM\ts\tMuseo Nacional de Historia Natural y Antropologia\t\t\t",
"MHNM<MOZ>\ts\tMuseum of Natiral History, Maputo\t\t\t",
"MHNN<CHE>\ts\tNeuchatel Musee d'Histoire Naturel\t\t\t",
"MHNN<FRA>\ts\tMusee d'Histoire Naturalle\t\t\t",
"MHNNICE\ts\tMueusm d'Histoire Naturelle de Nice\t\t\t",
"MHNP\ts\tMuseum d'Histoire Naturelle Perpignan\t\t\t",
"MHNSM\ts\tMuseo de Historia Natural, Universidad Nacional Mayor de San Marcos\t\t\t",
"MHNT\ts\tMuseum d'Histoire Naturelle Toulouse\t\t\t",
"MHNUNC\ts\tDepartamento de Ictiologia del Museo de Historia Natural de la Universidad Nacional de Colombia\t\t\t",
"MHNV\ts\tMuseo de Historia Natural de Valparaiso\t\t\t",
"MHP\ts\tFort Hays State University, Sternberg Museum of Natural History\t\t\t",
"MHU\ts\tMakerere University, Botany Department\t\t\t",
"MHUA\ts\tMuseo de Herpetologia de la Universidad de Antioquia\t\t\t",
"MHV\ts\tMusee de Haute Volta\t\t\t",
"MHWK\ts\tMuch Wenlock Museum\t\t\t",
"MHYAU\ts\tYunnan Agricultural University\t\t\t",
"MI\ts\tUniversita degli Studi di Milano, Dipartimento di Biologia\t\t\t",
"MIB\ts\tUniversity of Milano - Bicocca, Department of Biotechnology and Biosciences\t\t\t",
"MIB:ZPL\ts\tUniversity of Milano - Bicocca, Department of Biotechnology and Biosciences, ZooPlantLab\t\t",
"MIC\ts\tMar Ivanios College (Zoology museum)\t\t\t",
"MICG\ts\tUniversidad de San Carlos de Guatemala\t\t\t",
"MICH\ts\tUniversity of Michigan\t\thttp://quod.lib.umich.edu/h/herb4ic/x-mich10007/MICH&spec;\t",
"MICKKU\tc\tMICKKU Culture Collection\t\t\t",
"MID\ts\tMiddlebury College, Biology Department\t\t\t",
"MIE\ts\tMie Prefectural Museum\t\t\t",
"MII\ts\tMuseum of Irish Industry\t\t\t",
"MIKU\ts\tMarine Biological Institute, Kyoto University\t\t\t",
"MIL\ts\tMilwaukee Public Museum\t\t\t",
"MIM\ts\tMinusinsk N. M. Martjanov Regional Museum\t\t\t",
"MIMB\ts\tMuseum of the Institute of Marine Biology\t\t\t",
"MIMM\ts\tMauritius Institute\t\t\t",
"MIN\ts\tUniversity of Minnesota (J. F. Bell Museum of Natural History)\t\t\t",
"MINC\ts\tUniversidad Politecnica\t\t\t",
"MINI\ts\tMuzeul de Istoria Naturala\t\t\t",
"MIPV\ts\tUniversita degli Studi di Milano, Laboratorio di Micologia e Batteriologia Fitopathologica\t\t\t",
"MIRR\ts\tMuseu Integrado de Roraima\t\t\t",
"MISR\ts\tMacaulay Land Use Research Institute\t\t\t",
"MISS\ts\tUniversity of Mississippi, Department of Biology\t\t\t",
"MISSA\ts\tMississippi State University, Department of Biological Sciences\t\t\t",
"MISU\ts\tMinot State University\t\t\t",
"MIT\tc\tMassachusetts Institute of Technology\t\t\t",
"MIWG\ts\tMuseum of he Isle of Wight Geology\t\t\t",
"MIZA\ts\tMuseuo del Instituto de Zoologia Agricola\t\t\t",
"MIZL\ts\tMusee de l'Institut de Zoologie\t\t\t",
"MIZT\ts\tUniversita di Torino\t\t\t",
"MJ\ts\tMuzeum Vysociny\t\t\t",
"MJCM\ts\tMuseo de Ciencias Naturales y Antropologicas \"Prof. Juan C.Moyano\" (Argentina)\t\t\t",
"MJG<ARG>\ts\tMuseo Jorge Gerhold\t\t\t",
"MJG<AUT>\ts\tLandesmuseum Joanneum\tLMJ<AUT>\t\t",
"MJG<DEU>\ts\tMainz University herbarium, Johannes Gutenberg-Universitat\t\t\t",
"MJH\ts\tMuzeul Judetean Hunedoara\t\t\t",
"MJMO\ts\tUniversidad Centro Occidental, Decanato de Agronomia\t\t\t",
"MJS\ts\tXiaolongshan Forestry Experiment Bureau\t\t\t",
"MJSD\ts\tMuseum-Jardin des Sciences\t\t\t",
"MK\ts\tNational Museum of Kenya\tNMKE\t\t",
"MKMEL\ts\tHerbarium Melovskiorum\t\t\t",
"MKNDC\ts\tInstitute of Biology\t\t\t",
"MKNH\ts\tInstitute of Biology\t\t\t",
"ML\ts\tMusee de Lectoure\t\t\t",
"MLAV\ts\tMusees de Laval\t\t\t",
"MLGU\ts\tInstitut National pour l'Etude et la Recherche  Agronomiques\t\t\t",
"MLLD\tc\tMicrobiological Research Laboratory, Soil and Water Section, Department of Land Development\t\t\t",
"MLMJI\tc\tDepartment of Plant Protection, Faculty of Agricultural Production\t\t\t",
"MLP\ts\tMuseo de La Plata\tMLPA\t\t",
"MLRU\tc\tMicrobiology Laboratory, Department of Biology, Faculty of Science\t\t\t",
"MLS<AUS>\ts\tMarine Laboratory Sydney\t\t\t",
"MLS<COL>\ts\tMuseo del Instituto de La Salle\t\t\t",
"MLS<GBR>\ts\tLathallan Preparatory School\t\t\t",
"MLSU\ts\tSt. Petersburg State University, Zoology Museum\t\t\t",
"MLUH\ts\tMartin Luther Universitat\tMLU\t\t",
"MLY\ts\tArboretum Mlynany\t\t\t",
"MLZ\ts\tMoore Laboratory of Zoology, Occidental College\t\t\t",
"MLZ:Bird\ts\tMoore Laboratory of Zoology, Occidental College, Bird Collection\t\t",
"MLZ:Mamm\ts\tMoore Laboratory of Zoology, Occidental College, Mammal Collection\t\t",
"MM<CAN>\ts\tManitoba Museum\t\t\t",
"MM<COL>\ts\tMuseo del Mar\t\t\t",
"MM<DEU>\ts\tMagdeburg Museum\t\t\t",
"MM<FRA>\ts\tUniversity of Montpellier\t\t\t",
"MMBC\ts\tMoravske Muzeum [Moravian Museum]\tMMB\t\t",
"MMBF\ts\tMicoteca Mario Barreto Figueiredo\t\t\t",
"MMBS\ts\tMukaishima Marine Biological Station\t\t\t",
"MMCC\tc\tMalaysian Agricultural Research and Development, MARDI Microbial Culture Collection\t\t\t",
"MMCHPV\ts\tMuseo Municipal El Chocon\t\t\t",
"MMCM\ts\tMuseum of Malawi\t\t\t",
"MMF\ts\tMuseu Municipal do Funchal\t\t\t",
"MMG\ts\tMuseo Marino de la Isla de Gorgona\t\t\t",
"MMGMK\ts\tMagyar Mezogazdasagi Muzeum es Konyvtar (The Museum and Library of Hungarian Agriculture)\t\t\t",
"MMH\ts\tMunicipal Museum\t\t\t",
"MMH<FRA>\ts\tMuseums of Montbeliard\t\t\t",
"MMI\ts\tRegionalni muzeum\t\t\t",
"MMK\ts\tMcGregor Museum\t\t\t",
"MMKZ\ts\tAlexander McGregor Memorial Museum\t\t\t",
"MML\tc\tMedical Microbiological Laboratory\t\t\t",
"MMMN\ts\tManitoba Museum of Man and Nature, Botany Department\t\t\t",
"MMMZ\ts\tMutare Museum\t\t\t",
"MMNH<MNG>\ts\tMongolian Museum of Natural History\t\t\t",
"MMNH<USA-MN>\ts\tBell Museum of Natural History\t\t\t",
"MMNH<USA-MN>:Bird\ts\tBell Museum of Natural History, Bird collection\t\t",
"MMNHS\ts\tMacedonian Museum of Natural History\t\t\t",
"MMNS\ts\tMississippi Museum of Natural Science\t\t\t",
"MMP\ts\tMuseo de Mar del Plata (Argentina)\t\t\t",
"MMRF\tc\tMarine Microbial Reference Facility\t\t\t",
"MMS\ts\tMontshire Museum of Science\t\t\t",
"MMTT\ts\tIran National Museum of Natural History\t\t\t",
"MMUE\ts\tMuseum of Manchester University\t\t\t",
"MMUS\ts\tMacleay Museum, University of Sydney\t\t\t",
"MN\ts\tMuseu Nacional, Universidade Federal do Rio de Janeiro\tMNRJ\t\t",
"MNA\ts\tMuseum of Northern Arizona\t\t\t",
"MNA<ITA>\ts\tThe Museo Nazionale dell'Antartide  (Italian National Antarctic  Museum in Genoa).\t\t\t",
"MNAV\ts\tMuseo Naturalistico-Archeologico\t\t\t",
"MNCE\ts\tMuseu de Historia Natural Capao da Embuia\t\t\t",
"MNCN\tsb\tMuseo Nacional de Ciencias Naturales\tMNMS\t\t",
"MNCN:ADN\tsb\tMuseo Nacional de Ciencias Naturales, Coleccion de Tejidos y ADN\t\t",
"MNCN:Ent\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de entomologia\t\t",
"MNCN:Herpeto\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de anfibios y reptiles\t\t",
"MNCN:ICTIO\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de ictiologia\t\t",
"MNCN:Inverte\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de invertebrados\t\t",
"MNCN:Malac\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de malacologia\t\t",
"MNCN:Mam\ts\tMuseo Nacional de Ciencias Naturales, Colession de mamiferos\t\t",
"MNCN:Ornit\ts\tMuseo Nacional de Ciencias Naturales, Coleccion de aves\t\t",
"MNCR\ts\tMuseo Nacional de Costa Rica\t\t\t",
"MND\ts\tMuseum Natura Docet\t\t\t",
"MNDG\ts\tMuseo Nacional \"David J. Guzman\"\t\t\t",
"MNE\ts\tMaidstone Museum and Art Gallery\t\t\t",
"MNES\ts\tUniversidad Nacional de Misiones\t\t\t",
"MNFD\ts\tMuseum fuer Naturkunde\t\t\t",
"MNG\ts\tSammlung Eisfeld des Museums der Natur Gotha\t\t\t",
"MNGA\ts\tMuzeul National de Istorie Natural \"Grigore Antipa\"\t\t\t",
"MNGC\ts\tMuseo Nacional de Historia Natural, Guatemala City\t\t\t",
"MNH\ts\tMuseo de Ciencias Naturales de Tenerife\t\t\t",
"MNH<USA>\ts\tMissouri Department of Conservation\t\t\t",
"MNHCI\ts\tMuseu de Historia Natural Capao da Imbuia\tMNHCI\t\t",
"MNHM<DEU>\ts\tNaturhistorisches Museum Mainz/Landessammlung fuer Naturkunde Rheinland-Pfalz\t\t\t",
"MNHM<USA-CO>\ts\tJohn May Museum of Natural History\t\t\t",
"MNHN\ts\tMuseum National d'Histoire Naturelle\t\t\t",
"MNHN:ALCP\tsc\tMuseum National d'Histoire Naturelle, Microalgae\t\t",
"MNHN:AR\ts\tMuseum National d'Histoire Naturelle, Arachnids: Spiders\thttps://science.mnhn.fr/institution/mnhn/collection/ar/item/ar",
"MNHN:CEU\ts\tMuseum National d'Histoire Naturelle, Unicellular eukaryotes\t\t",
"MNHN:CH\ts\tMuseum National d'Histoire Naturelle, Chimiotheque\t\t",
"MNHN:CX\ts\tMuseum National d'Histoire Naturelle, Extractotheque\t\t",
"MNHN:EA\ts\tMuseum National d'Histoire Naturelle, Apterygota and springtails\t\t",
"MNHN:EC\ts\tMuseum National d'Histoire Naturelle, Insects - Coleoptera\t\t",
"MNHN:ED\ts\tMuseum National d'Histoire Naturelle, Insects - Diptera\t\t",
"MNHN:EH\ts\tMuseum National d'Histoire Naturelle, Insects - Hemiptera\t\t",
"MNHN:EL\ts\tMuseum National d'Histoire Naturelle, Insects - Lepidoptera\t\t",
"MNHN:EO\ts\tMuseum National d'Histoire Naturelle, Insects - Orthoptera\t\t",
"MNHN:EP\ts\tMuseum National d'Histoire Naturelle, Insects - Small orders & Odonates\t\t",
"MNHN:EY\ts\tMuseum National d'Histoire Naturelle, Insects - Hymenoptera\t\t",
"MNHN:IA\ts\tMuseum National d'Histoire Naturelle, Annelids, Polychaetes and Sipuncula\t\t",
"MNHN:IB\ts\tMuseum National d'Histoire Naturelle, Bryozoans Brachiopods\t\t",
"MNHN:IC\ts\tMuseum National d'Histoire Naturelle, Ichtyologie\t\t",
"MNHN:IE\ts\tMuseum National d'Histoire Naturelle, Echinoderms\t\t",
"MNHN:IK\ts\tMuseum National d'Histoire Naturelle, Cnidarians\t\t",
"MNHN:IM\ts\tMuseum National d'Histoire Naturelle, Molluscs\t\t",
"MNHN:IN\ts\tMuseum National d'Histoire Naturelle, Nematodes\t\t",
"MNHN:IP\ts\tMuseum National d'Histoire Naturelle, Porifera\t\t",
"MNHN:IR\ts\tMuseum National d'Histoire Naturelle, Protists\t\t",
"MNHN:IT\ts\tMuseum National d'Histoire Naturelle, Tunicates/ascidians\t\t",
"MNHN:IU\ts\tMuseum National d'Histoire Naturelle, Crustaceans\t\t",
"MNHN:LCP\ts\tMuseum National d'Histoire Naturelle, Laboratory of Cryptogamy\t\t",
"MNHN:M\ts\tMuseum National d'Histoire Naturelle, Mammal\t\t",
"MNHN:MY\ts\tMuseum National d'Histoire Naturelle, Myriapods\t\t",
"MNHN:P\ts\tMuseum National d'Histoire Naturelle, Vascular plants\t https://science.mnhn.fr/institution/mnhn/collection/p/item/p",
"MNHN:PMC\tc\tMuseum National d'Histoire Naturelle, Cyanobacteria\t\t",
"MNHN:RA\ts\tMuseum National d'Histoire Naturelle, Reptiles and amphibians\t\t",
"MNHN:RF\tsc\tMuseum National d'Histoire Naturelle, Fungal strains\t\t",
"MNHN:RS\ts\tMuseum National d'Histoire Naturelle, Arachnids : Scorpions\t\t",
"MNHN:TCCV\ts\tMuseum National d'Histoire Naturelle, Frozen vertebrates tissues & cells\t\t",
"MNHN:ZA\ts\tMuseum National d'Histoire Naturelle, Vertebrates - Others\t\t",
"MNHN:ZO\ts\tMuseum National d'Histoire Naturelle, Birds\t\t",
"MNHN<CUB>\ts\tMuseo Nacional de Historia Natural, Departamento de Colecciones\t\t\t",
"MNHN<URY>\ts\tMuseo Nacional de Historia  Natural de Montevideo\t\t\t",
"MNHNCH\ts\tMuseo Nacional de Historia Natural de Chile\tMNHN ,MNHNC\t\t",
"MNHNCU\ts\tMuseo Nacional de Historia Natural, Havana\tMNHC\t\t",
"MNHNJP\ts\tUniversidad Nacional Mayor de San Marcos\tMHNJP\t\t",
"MNHNLES\ts\tMuseum National d'Histoire Naturelle Lesotho\t\t\t",
"MNHNM\ts\tMuseo Nacional de Historia Natural, Mexico City\t\t\t",
"MNHNP\ts\tMuseo Nacional de Historia Natural del Paraguay\t\t\t",
"MNHNSD\ts\tMuseo Nacional de Historia Natural, Santo Domingo\tMHND\t\t",
"MNHNUL\ts\tMuseu Nacional de Historia Natural de Universidade de Lisboa\t\t\t",
"MNHP\ts\tPrinceton University\t\t\t",
"MNHS\ts\tManchester Natural History Society\t\t\t",
"MNK\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\"\t\t\t",
"MNK:A\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\", Amphibian Collection\t\t",
"MNK:R\ts\tMuseo de Historia Natural \"Noel Kempff Mercado\", Reptile Collection\t\t",
"MNKNU\ts\tMuseum of Nature, V.N. Karazin Kharkiv National University\t\t\t",
"MNKS\ts\tMilton Keynes Development Corporation\t\t\t",
"MNMB\ts\tMagyar Nenzeti Museum\t\t\t",
"MNN\ts\tMusee National du Niger\t\t\t",
"MNNC\ts\tMuseo Nacional de Historia Natural, Santiago\t\t\t",
"MNNHN\ts\tMuseum National d'Historie Naturelle\t\t\t",
"MNNIT\tc\tMotilal Nehru National Institute of Technology\t\t\t",
"MNNW\ts\tMuseum fuer Naturkunde\t\t\t",
"MNRJ\ts\tMuseu Nacional/Universidade Federal de Rio de Janeiro\tMN\t\t",
"MNSB\ts\tMuseum of Natural Sciences\t\t\t",
"MNSL\ts\tMuseum of Natural Sciences\t\t\t",
"MNUFR\ts\tMongolian National University\t\t\t",
"MNVD\ts\tMuseum fur Naturkunde und Vorgeschichte Dessau\t\t\t",
"MNVL\ts\tMuseum d'Histoire Naturelle de Ville de Lille\t\t\t",
"MNZ\ts\tMuseum of New Zealand Te Papa Tongarewa\t\t\t",
"MO\ts\tMissouri Botanical Garden\t\t\t",
"MOAR\ts\tMorris Arboretum, University of Pennsylvania, Botany Department\t\t\t",
"MOBR\ts\tEstacion de Investigaciones Marinas de Margarita, Fundacion La Salle de Ciencias Naturales\t\t\t",
"MOC\ts\tWestern Oregon University, Biology Department\t\t\t",
"MOD\ts\tUniversita degli Studi di Modena e Reggio Emilia, Dipartimento de Biologia Animale\t\t\t",
"MODNR\ts\tDivision of State Parks, Department of Natural Resources\t\t\t",
"MOFUNG\ts\tMuseu Oceanogr. Fundacao Univerdidade Rio Grande\t\t\t",
"MOG\ts\tNational Range Agency\t\t\t",
"MOL\ts\tUniversidad Nacional Agraria La Molina, Departamento Academico de Biologia\t\t\t",
"MOLA\tc\tMicrobial Observatory of the Laboratoire Arago\t\t\t",
"MOM\ts\tMusee Oceanographique Monaco\tMONA\t\t",
"MONT\ts\tMontana State University\t\t\t",
"MONTU\ts\tUniversity of Montana\t\t\t",
"MONZ\ts\tMuseum of New Zealand\t\t\t",
"MOR<USA-IL>\ts\tMorton Arboretum, Research Department\t\t\t",
"MOR<USA-MT>\ts\tMuseum of the Rockies\t\t\t",
"MOS\ts\tCollege of Agriculture and Forestry\t\t\t",
"MOSG\ts\tMuzeul Orasului Sf. Gheorghe\t\t\t",
"MOSI\ts\tMuseum of Science and Industry\t\t\t",
"MOSM\ts\tAll-Russian Research Institute of Medicinal and Aromatic Plants\t\t\t",
"MOSN\ts\tMuseo Ornitologico e di Scienze Naturali\t\t\t",
"MOSP\ts\tMoscow State Pedagogical University, Botany Department\t\t\t",
"MOSS\ts\tUniversidade Federal Rural do Semi-Arido\t\t\t",
"MOT\ts\tMote Marine Laboratory\t\t\t",
"MOTH\ts\tMuseum of the Hemispheres\t\t\t",
"MOUFPE\ts\tOceanographic Museum of the Federal University of Pernambuco\t\t\t",
"MOVC\ts\tCornell College, Biology Department\t\t\t",
"MOVI\ts\tMuseu Oceanografico do Vale do Itajai\t\t\t",
"MP<CZE>\ts\tVychodoceske muzeum Pardubice\t\t\t",
"MP<USA-NY>\ts\tMohonk Preserve, Inc.\t\t\t",
"MPA\ts\tEcole National Superieure Agronomique, Biologie et Pathologie Vegetales\t\t\t",
"MPC\ts\tMonterey Peninsula College, Life Science Museum\t\t\t",
"MPCA\ts\tMuseo Provincial \"Carlos Ameghino\"\t\t\t",
"MPCNyO\ts\tMuseo Provincial de Ciencias Naturales, Puerto Madryn\t\t\t",
"MPCRM\ts\tMuseo Paleontologico Cittadino della Rocca\t\t\t",
"MPE\ts\tF. R. Long Herbarium\t\t\t",
"MPEF-PV\ts\tMuso Paleontologico Egidio Fergulio\t\t\t",
"MPEG\ts\tMuseu Paraense Emilio Goeldi\t\t\t",
"MPEP\ts\tMusee de Paleontologie et de l'evolution\t\t\t",
"MPGB\ts\tMuseum of Portuguese Guinea\t\t\t",
"MPH\ts\tShahid Behershti University\t\t\t",
"MPKV\tc\tBiological Nitrogen Fixation Project College of Agriculture\t\t\t",
"MPL\ts\tMusee de Port Louis\t\t\t",
"MPLN\ts\tMuseo Provinciale di Storia Naturale\t\t\t",
"MPM\ts\tMilwaukee Public Museum\t\t\t",
"MPM<JPN>\ts\tMeguro Parasitological Museum\t\t\t",
"MPMP\ts\tNational Museum of the Philippines\t\t\t",
"MPN\ts\tMassey University, Ecology Group\t\t\t",
"MPPD\ts\tUniversity of Minnesota, Plant Pathology Department\t\t\t",
"MPPE\ts\tPaletnologica ed Etnologico dei Padri Francescani\t\t\t",
"MPR\ts\tMount Makulu Pasture Research Station\t\t\t",
"MPSC\ts\tMuseu de Paleontologia de Santana do Cariri\t\t\t",
"MPSN\ts\tMuseo Provinciale di Scienze Naturali\t\t\t",
"MPSP\ts\tMuseu Paulista\t\t\t",
"MPSU\tc\tDepartment of Microbiology, Songkla University\t\t\t",
"MPT\ts\tMuseuo Provincial de Teurel\t\t\t",
"MPU\ts\tUniversite Montpellier II\t\t\t",
"MPUC\ts\tPontificia Universidade Catolica do Rio Grande do Sul, Laboratorio de Botanica\t\t\t",
"MPUM\ts\tMuseo Paleontologia Universita degli Studi di Milano\t\t\t",
"MPUN\ts\tMuseo Paleontologicom\t\t\t",
"MPUNR\ts\tDepartamento de Geologia, Universidad de Chile\t\t\t",
"MPV\ts\tMuseo Paleontologico Municipal de Valencia\t\t\t",
"MPZ\ts\tMuseo Paleontologico de la Universidad de Zaragoza\t\t\t",
"MQ\ts\tGansu Institute of Desert Control\t\t\t",
"MQU\ts\tMacquarie University\t\t\t",
"MRA\ts\tMuseo Requieu\t\t\t",
"MRA<USA-VA>\tc\tMalaria Research and Reference Reagent Resource Center\t\t\t",
"MRAC\ts\tMusee Royal de l'Afrique Centrale\tKMMA,MRCA,RMCA\t\t",
"MRC<TUR>\tc\tTUBITAK Marmara Research Center Culture Collection\t\t\t",
"MRC<USA-MT>\ts\tRocky Mountain Research Station\t\t\t",
"MRC<ZAF>\tc\tNational Research Institute for Nutritional Diseases\t\t\t",
"MRCA\ts\tMusee Royal de l'Afrique Centrale\tMRAC\t\t",
"MRCN\ts\tMuseu Rio-Grandense de Ciencias Naturais\t\t\t",
"MRD\ts\tMoorhead State University, Biology Department\t\t\t",
"MRF\ts\tMuseum of Histoire naturelle\t\t\t",
"MRGS\ts\tMuseu do Rio Grande do Sul\t\t\t",
"MRGT\ts\tBorbas Vince Herbarium, Friends of Hungarian Rose- and Hawthorn-friends Society\t\t\t",
"MRI\ts\tMurray Royal Institution\t\t\t",
"MRNP\ts\tMount Rainier National Park\t\t\t",
"MRSC\ts\tMount Makulu Central Research Station\t\t\t",
"MRSH\ts\tMatopos Research Station\t\t\t",
"MRSN\ts\tMuseo Regionale di Scienze Naturali\t\t\t",
"MRSN<USA>\tc\tMultidrug Resistant Organism Repository and Surveillance Network\t\t\t",
"MRSP\ts\tMuseo Regionale di Scienze Naturali, St. Pierre\t\t\t",
"MRST\ts\tMuseo Regionale di Storia Naturale, Terrasini\t\t\t",
"MS\ts\tUniversita di Messina, Dipartimento di Scienze Botaniche\t\t\t",
"MSA\ts\tMuseum of Science and Art\t\t\t",
"MSB\ts\tMuseum of Southwestern Biology\t\t\t",
"MSB:Bird\ts\tMuseum of Southwestern Biology, Bird Collection\thttp://arctos.database.museum/SpecimenDetail.cfm?GUID=",
"MSB:Fishes\ts\tMuseum of Southwestern Biology, Fish Collection\t\t",
"MSB:Herp\ts\tMuseum of Southwestern Biology, Herpetology Collection\t\t",
"MSB:Mamm\ts\tMuseum of Southwestern Biology, Mammal Collection\thttp://arctos.database.museum/SpecimenDetail.cfm?GUID=",
"MSB:Para\ts\tMuseum of Southwestern Biology, Parasitology Collection\thttp://arctos.database.museum/SpecimenDetail.cfm?GUID=",
"MSB<BGR>\ts\tMuseum Sophia\t\t\t",
"MSB<DEU>\ts\tLudwig-Maximilians-Universitaet\t\t\t",
"MSC\ts\tMichigan State University, Botany and Plant Pathology Department\t\t\t",
"MSCL\tc\tMicrobial Strain Collection of Latvia\t\t\t",
"MSCMU\tc\tMicrobiology Section, Chiang Mai University (MSCMU)\t\t\t",
"MSCW\ts\tMississippi University for Women\t\t\t",
"MSDB\ts\tMuseo di Storia Naturale \"Don Bosco\"\t\t\t",
"MSDS\tc\tMicrobiology Section, Biological Science Division, Department of Science Services\t\t\t",
"MSE\ts\tAngus Museums\t\t\t",
"MSEM\ts\tMuseu Geologic del Seminari de Barcelona\t\t\t",
"MSEN\ts\tMontrose Natural History and Antiquarian Society\t\t\t",
"MSF\ts\tSauriermuseum Frick\t\t\t",
"MSGP\ts\tNusee des Services Geologiques du Portugal\t\t\t",
"MSI\tsc\tMarine Science Institute, University of the Philippines\t\t\t",
"MSI:PMS-ICBG\tc\tMarine Science Institute, University of the Philippines, Philippine Mollusk Symbiont-International Cooperative Biodiversity Group\t\t",
"MSIE\ts\tMuseum of Shanghai\t\t\t",
"MSINR\ts\tMuseum Sichuan Institute of Natural Resources\t\t\t",
"MSIR\ts\tMauritius Sugar Industry\t\t\t",
"MSJC\ts\tSt. Joseph's College, Natural History Museum\t\t\t",
"MSK\ts\tNational Academy of Sciences of Belarus, Flora and Systematic Laboratory\t\t\t",
"MSKH\ts\tCentral Botanical Garden\t\t\t",
"MSKU\ts\tBelarusian State University, Botany Department\t\t\t",
"MSL\ts\tRoyal Medical Society of London\t\t\t",
"MSLH\ts\tChinese University of Hong Kong, Marine Sciences Laboratory\tMSLKHC\t\t",
"MSLY\ts\tMossley Botanical Society\t\t\t",
"MSM<JPN>\ts\tMarine Science Museum, Tokai Univ.\t\t\t",
"MSM<PRI>\ts\tUniversity of Puerto Rico, Marino Puertorriqueno\t\t\t",
"MSNA\ts\tMuseo di Storia Naturale e Arte Archeologica\t\t\t",
"MSNG\ts\tMuseo Civico di Storia Naturale di Genova 'Giacomo Doria'\t\t\t",
"MSNM\ts\tMuseo Civico di Storia Naturale di Milano\t\t\t",
"MSNO\ts\tMuseum des Sciences Naturelles\t\t\t",
"MSNP\ts\tMuseo di Scienze Naturali\t\t\t",
"MSNT<ITA-Torino>\ts\tMuseo Regionale di Scienze Naturali, Torino\t\t\t",
"MSNT<ITA-Torino>:FAZC\ts\tMuseo Regionale di Scienze Naturali, Torino, Franco Andreone Zoological Collection\t\t",
"MSNT<ITA-Turin>\ts\tMuseo Civico DI Storia Naturale DI Torino\t\t\t",
"MSNU\ts\tMuseo di Storia Naturale dell'Universita\t\t\t",
"MSNV\ts\tMuseo Civico di Storia Naturale di Venezia\t\t\t",
"MSNVR\ts\tMuseo Civico di Storia Naturale di Verona\t\t\t",
"MSPC\ts\tMuseo di Storia Naturale \"Pietro Calderini\"\t\t\t",
"MSPP\tc\tMycology Section, Plant Pathology and Microbiology Division, Department of Agricultural Science\t\t\t",
"MSSC\ts\tMidwestern State University\t\t\t",
"MSTFM\ts\tMiddle School of the Third Factory Machinery\t\t\t",
"MSTR\ts\tWestfalisches Museum fur Naturkunde\t\t\t",
"MSU<THA>\tc\tAcetobacter\t\t\t",
"MSU<USA-MI>\ts\tMichigan State University Museum\tMSUC,MSUM\t\t",
"MSUD\ts\tI. I. Mecynikov State University of Odessa, Department of Morphology and Systematics of Plants\t\t\t",
"MSUH\ts\tUniversity of Mosul, Biology Department\t\t\t",
"MSUMC\ts\tMurray State University\t\t\t",
"MSUMZ\ts\tMemphis State University\t\t\t",
"MSUN\ts\tWestfaelische Wilhelms-Universitaet\t\t\t",
"MSUNH\ts\tMontana State University Northern\t\t\t",
"MSUT\ts\tNatural Medicinal Mushroom Museum, Mahasarakham University\t\t\t",
"MSUT<ALB>\ts\tMuseum of Natural History, Tirane\t\t\t",
"MSUZ\ts\tMississippi State University, Zoological Collections\t\t\t",
"MSV\ts\tMuseum der Stadt Villach\t\t\t",
"MT<CAN>\ts\tUniversite de Montreal\t\t\t",
"MT<RUS>\ts\tMus. Tinro, Vladyvostok\t\t\t",
"MTA\ts\tMaden Tetkik ve Arama Enstituesue\t\t\t",
"MTCC\tc\tMicrobial Type Culture Collection & Gene Bank\t\t\t",
"MTCHT\ts\tMar Thoma College\t\t\t",
"MTD\ts\tMuseum of Zoology Senckenberg Dresden\t\t\t",
"MTD:T\ts\tMuseum of Zoology Senckenberg Dresden, Tissue collection\t\t",
"MTD:TD\ts\tMuseum of Zoology Senckenberg Dresden, Herpetological Tissue Collection\t\t",
"MTDO\ts\tChiba University\t\t\t",
"MTEC\ts\tMontana State University\tMSUB\t\t",
"MTJB\ts\tJardin botanique de Montreal\t\t\t",
"MTKD\ts\tStaatliches Museum fuer Tierkunde\t\t\t",
"MTKKU\tc\tDepartment of Clinical Microbiology, Faculty of Medical Technology\t\t\t",
"MTL\ts\tMusee Toulouse Lautrec d'Albi\t\t\t",
"MTMG\ts\tMcGill University, Macdonald Campus, Plant Science Department\t\t\t",
"MTN\ts\tMalton Field Naturalists' Society\t\t\t",
"MTQA\ts\tMuseum of Tropical Queensland\tMTQ\t\t",
"MTRO\ts\tMuseum de Troyes\t\t\t",
"MTSN\ts\tTrento Museum of Natural Sciences\t\t\t",
"MTSU\ts\tMiddle Tennessee State University, Biology Department\t\t\t",
"MTUF\ts\tUniversity Museum, Tokyo University of Fisheries\t\t\t",
"MU<TUR>\tc\tMugla Sitki Kocman University\t\t\t",
"MU<USA-OH>\ts\tMiami University, Botany Department, Willard Sherman Turrell Herbarium\t\thttp://herbarium.muohio.edu/herbariummu/\t",
"MU<USA-TX>\ts\tMidwestern University\t\t\t",
"MUACC\tc\tMurdoch University Algal Culture Collection\t\t\t",
"MUAF\tc\tCulture collection of Mendel University of Agriculture and Forestry in Brno\t\t\t",
"MUAP\ts\tMuseo del Mar Universidad Arturo Prat\t\t\t",
"MUB\ts\tUniversidad de Murcia, Departamento de Biologia Vegetal, Botanica\t\t\t",
"MUB:ALGAS\ts\tUniversidad de Murcia, Departamento de Biologia Vegetal, Botanica, Algal Collection\t\t",
"MUB:BRIOFITOS\ts\tUniversidad de Murcia, Departamento de Biologia Vegetal, Botanica, Bryophyta Collection\t\t",
"MUB:HONGOS\ts\tUniversidad de Murcia, Departamento de Biologia Vegetal, Botanica, Mushroom Collection\t\t",
"MUBI\t\tMuseo de Biodiversidad del Peru, Cusco\t\t\t",
"MUCC\tc\tMurdoch University Culture Collection\t\t\t",
"MUCC<JPN>\tc\tMie University Culture Collection (Culture Collection, Laboratory of Plant Pathology)\t\t\t",
"MUCL\tc\tBelgian Coordinated Collections of Microorganisms / MUCL Agro-food & Environmental Fungal Collection\tBCCM/MUCL\t\t",
"MUCPV\ts\tMuseo de la Universidad Nacional del Comahue\tMPCA\t\t",
"MUCR\ts\tMuseo de Insectos\t\t\t",
"MUCV\ts\tMonash University, Biological Sciences Department\t\t\t",
"MUDH\ts\tThe Hague, Museon\t\t\t",
"MUFE\ts\tUniversity of Marmara, Department of Botany\t\t\t",
"MUFM\ts\tManipur University Fish Museum\t\t\t",
"MUFS\ts\tDepartment of Animal Science, Miyazaki  University\t\t\t",
"MUGM\ts\tMuseo de Ciencias Naturales, Coleccion \"Gustavo Orces\" (Ecuador)\t\t\t",
"MUGT\ts\tMuseo de Ciencias Naturales de la Universidad de Guayaquil\t\t\t",
"MUH\ts\tMirpur University of Science & Technology\t\t\t",
"MUHW\ts\tMarshall University, Biological Sciences Department\t\t\t",
"MUJ\ts\tMuseo Javeriano de Historia Natural, Laboratoriao de Entomologia\t\t\t",
"MUL\tc\tDepartment of Microbiology MUL-B 250\t\t\t",
"MULU\ts\tMuseum Ludovicae Ulricae, Zoology Institute of the University of Uppsala\t\t\t",
"MUM\tc\tMicoteca da Universidade do Minho\t\t\t",
"MUMF\ts\tDepartment of Life Sciences\t\t\t",
"MUMH<JPN>\ts\tMie University Mycological Herbarium\t\t\t",
"MUMNH\ts\tMahidol University Museum of Natural History\t\t\t",
"MUMZ\ts\tUniversity of Missouri, Museum of Zoology\t\t\t",
"MUNC\ts\tSt. John's, Memorial University of Newfoundland\t\t\t",
"MUNZ\ts\tMassey University\t\t\t",
"MUO\ts\tStovall Museum of Science and History\t\t\t",
"MUP\ts\tUniversidade do Porto, Museu do Historia Natural\t\t\t",
"MUR\ts\tMurray State University, Department of Biological Sciences\t\t\t",
"MURD\ts\tMurdoch University\t\t\t",
"MURU\ts\tMurdoch University\t\t\t",
"MUS\ts\tMuskingum College, Biology Department\t\t\t",
"MUSA\ts\tUniversidad Nacional de San Agustin, Museo de Historia Natural (Peru)\t\t\t",
"MUSK\ts\tMuskegon Community College, Life Science Department\t\t\t",
"MUSM\ts\tMuseo de Historia Natural de la Universidad Nacional Mayor de San Marcos en Lima\t\t\t",
"MUSN\ts\tMuseo Universitario di Storia Naturale e della Strumentazione Scientifica\t\t\t",
"MUST\ts\tAl-Mustansiriya University\t\t\t",
"MUT<ITA>\tc\tMycotheca Universitatis Taurinensis\t\t\t",
"MUZ\ts\tKing Abdulaziz City for Science and Technology\t\t\t",
"MV\ts\tUniversity of Montana Museum\t\t\t",
"MVC\ts\tUniversity of Charleston, Natural Sciences Department\t\t\t",
"MVDA\ts\tMinisterio de Ganaderia y Agricultura\t\t\t",
"MVEN\ts\tNaturhistorisch Museum\t\t\t",
"MVFA\ts\tUniversidad de la Republica, Laboratorio de Botanica\t\t\t",
"MVFQ\ts\tUniversidad de la Republica, Catedra de Botanica Farmaceutica\t\t\t",
"MVHC\ts\tUniversidad de la Republica, Seccion Micologia\t\t\t",
"MVJB\ts\tMuseo y Jardin Botanico\t\t\t",
"MVM\ts\tMuseo Nacional de Historia Natural, Departamento de Botanica\t\t\t",
"MVMA\ts\tMuseum of Victoria\t\t\t",
"MVN\ts\tPublic Library\t\t\t",
"MVNP\ts\tMesa Verde National Park\t\t\t",
"MVP\ts\tMuseum of Vicotria\t\t\t",
"MVSC\ts\tMillersville University, Biology Department\t\t\t",
"MVUP\ts\tMuseo de Vertebrados de la Universidad de Panama\t\t\t",
"MVZ\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley\t\thttp://mvzarctos.berkeley.edu/SpecimenDetail.cfm?guid=\t",
"MVZ:Bird\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Bird Collection\t\t",
"MVZ:Egg\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Egg Collection\t\t",
"MVZ:Herp\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Herpetology Collection\t http://arctos.database.museum/guid/MVZ:Herp:",
"MVZ:Hild\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Milton Hildebrand collection\t\t",
"MVZ:Img\tb\tMuseum of Vertebrate Zoology, University of California at Berkeley, Image Collection\t\t",
"MVZ:Mamm\ts\tMuseum of Vertebrate Zoology, University of California at Berkeley, Mammal Collection\t http://arctos.database.museum/guid/MVZ:Mamm:",
"MVZ:Page\tb\tMuseum of Vertebrate Zoology, University of California at Berkeley, Notebook Page Collection\t\t",
"MW<NLD>\ts\tMuseum Wasmann\t\t\t",
"MW<RUS>\tsb\tMoscow State University Herbarium\t\t\t",
"MWC\ts\tMuseum of Western Colorado\t\t\t",
"MWCF\ts\tMary Washington College, Department of Biology\t\t\t",
"MWFB\ts\tUniversity of California, Davis, Museum of Wildlife and Fisheries Biology\t\t\t",
"MWG\ts\tMoscow State University, Department of Biogeography\t\t\t",
"MWI\ts\tR. M. Myers Herbarium Western Illinois University\t\t\t",
"MWNH\ts\tMuseum Wiesbaden, Department of Natural Science\t\t\t",
"MWSJ\ts\tMissouri Western State College, Biology Department\t\t\t",
"MY\ts\tUniversidad Central de Venezuela, Botanica\t\t\t",
"MYDC\ts\tMianyang Institute for Drug Control\t\t\t",
"MYF\ts\tUniversidad Central de Venezuela\t\t\t",
"MYX\ts\tLomonosov Moscow State University\t\t\t",
"MZ-ICACH\ts\tInstituto de Ciencias y Artes de Chiapas, Museo Zoologico (Mexico)\t\t\t",
"MZ<CZE>\ts\tJihomoravske muzeum Znojmo\t\t\t",
"MZ<POL>\ts\tMuseum of the Earth, Polish Academy of Sciences\t\t\t",
"MZAF\ts\tMuseo Zoologico dell'Accademia dei Fisiocritici\t\t\t",
"MZB\ts\tMuseum Zoologicum Bogoriense\t\t\t",
"MZB:Amp\ts\tMuseum Zoologicum Bogoriense, Amphibian Collection\t\t",
"MZB:Ornith\ts\tMuseum Zoologicum Bogoriense, Ornithology Collection\t\t",
"MZBL\ts\tMuseo de Zoologica\t\t\t",
"MZBS\ts\tMuseo Zoologia\t\t\t",
"MZCP\ts\tUniversidade de Coimbra\t\t\t",
"MZCR\ts\tMuseo de Zoologia\t\t\t",
"MZFC\ts\tMuseo de Zoologia \"Alfonso L. Herrera\"\t\t\t",
"MZFN\ts\tMuseo Zoologico dell'Universita \"Federico II\"\t\t\t",
"MZGZ\ts\tMuseum Zoologia del Giardino Zoologico\t\t\t",
"MZH\ts\tZoolgical Museum, Finnish Museum of Natural History\t\t\t",
"MZKI\tc\tMicrobial Culture Collection of National Institute of Chemistry\t\t\t",
"MZL\ts\tMusee Zoologique\tMZLS\t\t",
"MZLS\ts\tMusee Zoologique\tMZL\t\t",
"MZLU\ts\tLund University Museum\t\t\t",
"MZN\ts\tMusee Zoologie\t\t\t",
"MZNA\ts\tUniversidad de Navarra, Museum of Zoology\t\t\t",
"MZNC\ts\tUniversidad Nacional de Cordoba, Museo de Zoolog&iacutea\t\t\t",
"MZP\ts\tMuzeum Ziemi Polska Akademia Nauk\t\t\t",
"MZPW\ts\tPolish Academy of Science, Museum of the Institute of Zoology\t\t\t",
"MZRF\ts\tMuseo Zangheri di Storia Naturale della Romagna\t\t\t",
"MZRO\ts\tMuseo Civico di Storia Naturale \"P. Zangheri\"\t\t\t",
"MZS\ts\tUniversite de Strasbourg, Musee de Zoologie\t\t\t",
"MZSF\ts\tUniversite de Strasbourg, Museum Zoologique\t\t\t",
"MZSP\ts\tMuseu de Zoologia da Universidade de Sao Paulo\t\t\t",
"MZTG\ts\tMuseum Zoologia\tIHN\t\t",
"MZUABCS\ts\tMuseo de Zoologia de la Universidad Automica de Baja California Sur\t\t\t",
"MZUB\ts\tMuseo di Zoologia\t\t\t",
"MZUC<CHL>\ts\tMuseo de Zoologia, Universidad de Concepcion\t\t\t",
"MZUC<ITA>\ts\tUniversita di Cagliari\t\t\t",
"MZUCR\ts\tUniversidad de Costa Rica, Museo de Zoologia\tUCR\t\t",
"MZUEL\ts\tMuseu de Zoologia da Universidade Estadual de Londrina\tMZUEL\t\t",
"MZUEL:Pisces\ts\tMuseu de Zoologia da Universidade Estadual de Londrina, Fish collection\t\t",
"MZUESC<BRA>\ts\tMuseu de Zoologia da Universidade Estadual de Santa Cruz\t\t\t",
"MZUF\ts\tMuseo Zoologico La Specola, Universita di Firenze\t\t\t",
"MZUFBA\ts\tMuseu de Zoologia, Universidade Federal da Bahia, Salvador\t\t\t",
"MZUFV\ts\tMuseu de Zoologia Joao Mojeen da Universidade Federal de Vicosa\t\t\t",
"MZUN\ts\tMuseo Zoologico di Universita degli Studi\t\t\t",
"MZUNAP\ts\tMuseo de Zoologia de la Universidad Nacional de la Amazonia Peruana\t\t\t",
"MZUP<ITA-Padova>\ts\tMuseo Zoologia\t\t\t",
"MZUP<ITA-Parma>\ts\tMuseo Zoologico di Universita degli Studi\t\t\t",
"MZUR\ts\tMuseo di Zoologia dell'Universita di Roma \"La Sapienza\"\tMZUL\t\t",
"MZUR:BAU\ts\tMuseo di Zoologia dell'Universita di Roma \"La Sapienza\", Zoological collection of the Department of Biology and Biotechnology\t\t",
"MZUS\ts\tMusee de Zoologie de l'Universite de Strasbourg\t\t\t",
"MZUSP\ts\tMuseu de Zoologia da Universidade de Sao Paulo\t\t\t",
"MZUT\ts\tMuseo di Zoologia, Instituto di Zoologia e Anatomia Comparata Universita di Torino\tMZUT<ITA-Torino>\t\t",
"MZUTH\ts\tMuseum of Zoology, University of Thessaloniki\t\t\t",
"MZUTI\ts\tMuseo de Zoologia, Universidad Tecnologica Indoamerica\t\t\t",
"MZUVN\ts\tMusee Zool. Univ. et Ville de Nancy\t\t\t",
"MZV<POL>\ts\tMuzeum i Instytut Zoologii\t\t\t",
"MZV<RUS>\ts\tZoological Museum Varsovite\t\t\t",
"MZYU\ts\tMuseum of Zoology, Yunnan University\t\t\t",
"N\ts\tNanjing University, Biology Department\t\t\t",
"NA\ts\tUnited States National Arboretum, USDA/ARS\t\t\t",
"NABG\ts\tBotanical Garden\t\t\t",
"NAC\ts\tNagano Nature Conservation Research Institute\t\t\t",
"NAI\ts\tUniversity of Nairobi, Botany Department\t\t\t",
"NAIC\ts\tNational Agricultural Insect Collection\t\t\t",
"NAKU\ts\tNamik Kemal University\t\t\t",
"NAM\ts\tFacultes Universitaires Notre-Dame de la Paix\t\t\t",
"NAN\ts\tNantong Teachers College, Biology Department\t\t\t",
"NAP<CHN>\ts\tInstitute of Zoology, Academia Sinica (formerly National Academy of Peiping)\t\t\t",
"NAP<ITA>\ts\tUniversita Degli Studi di Napoli Federico II, Dipartimento di Biologia Vegetale\t\t\t",
"NARA\ts\tNational Aquatic Resources Agency\t\t\t",
"NARI\ts\tNational Agricultural Research Institute\t\t\t",
"NARL\ts\tNational Agricultural Research Laboratories\t\t\t",
"NAS\ts\tInstitute of Botany, Jiangsu Province and Chinese Academy of Sciences\t\t\t",
"NASC<UK>\tb\tEuropean Arabidopsis Stock Centre\t\t\t",
"NASC<USA-MA>\ts\tMassachusetts College of Liberal Arts, Biology Department\t\t\t",
"NAT\ts\tSeale-Hayne Agricultural College\t\t\t",
"NATC\ts\tNorthwestern State University, Biological Sciences Department\t\t\t",
"NAU\ts\tNanjing Agricultural University, Department of Plant Science\t\t\t",
"NAUF\ts\tNorthern Arizona University\t\t\t",
"NAUJ\ts\tNanjing, Nanjing Agricultural University\t\t\t",
"NAUVM\ts\tNorthern Arizona University, Museum of Vertebrates\t\t\t",
"NAVA\ts\tNavajo Natural Heritage Program, Navajo Department of Fish & Wildlife\t\t\t",
"NBAIM\tc\tNational Bureau of Agriculturally Important Microorganisms\t\t\t",
"NBFGR\ts\tNational Bureau of Fish Genetic Resources (Indian Council of Agricultural Research)\t\t\t",
"NBFGR:CHN\ts\tNational Bureau of Fish Genetic Resources (Indian Council of Agricultural Research), Cochin Unit\t\t",
"NBG\ts\tNational Botanical Institute\t\t\t",
"NBGB<BEL>\tsb\tNational Botanical Garden, Belgium\t\t\t",
"NBIMCC\tc\tNational Bank for Industrial Microorganisms and Cell Cultures\t\t\t",
"NBM\ts\tNew Brunswick Museum\t\t\t",
"NBMB\ts\tNew Brunswick Museum\t\t\t",
"NBME\ts\tNational Butterfly Museum (Saruman Museum)\t\t\t",
"NBPC\ts\tNational Birds of Prey Centre\t\t\t",
"NBPGR\tb\tNational Bureau of Plant Genetic Resources\t\t\t",
"NBRC\tc\tNITE Biological Resource Center\tIFO\thttps://www.nite.go.jp/nbrc/catalogue/NBRCCatalogueDetailServlet?ID=NBRC&CAT=\t",
"NBRP\tb\tNational Bio-Resource Project\t\t\t",
"NBSB\ts\tNational Biomonitoring Specimen Bank, U.S. Geological Survey\t\t\t",
"NBSB:Bird\ts\tNational Biomonitoring Specimen Bank, U.S. Geological Survey, bird collection\t\t",
"NBSB:Mamm\ts\tNational Biomonitoring Specimen Bank, U.S. Geological Survey, mammal tissue collection\t\t",
"NBSI\ts\tBiologische Station Neusiedler See\t\t\t",
"NBV\ts\tKoninklijke Nederlandse Botanische Vereniging\t\t\t",
"NBY\ts\tNewbury District Museum\t\t\t",
"NBYC\ts\tNewberry College, Department of Biology\t\t\t",
"NCAIM\tc\tNational Collection of Agricultural and Industrial Microorganisms\t\t\t",
"NCAM\tc\tNational Collection of Agricultural Microorganisms\t\t\t",
"NCAS\ts\tRutgers University, Biological Sciences Department\t\t\t",
"NCATG\ts\tNorth Carolina A & T State University, Biology Department\t\t\t",
"NCAW\ts\tNorth-West College of Agriculture\t\t\t",
"NCB\tc\tNational Culture Bank\t\t\t",
"NCBS\ts\tYale University, Connecticut Botanical Society\t\t\t",
"NCBS<IND>\ts\tNational Centre for Biological Sciences, Bangalore\t\t\t",
"NCC<FRA>\tc\tNantes Culture Collection\t\t\t",
"NCC<USA-CA>\ts\tSonoma State University, Biology Department\t\t\t",
"NCCB\tc\tThe Netherlands Culture Collection of Bacteria\tLMD,NCCB<NLD>\t\t",
"NCCBH\ts\tNature Conservancy Council, Balloch\t\t\t",
"NCCE\ts\tNature Conservancy Council, Edinburgh\t\t\t",
"NCCH\ts\tNature Conservancy Council\t\t\t",
"NCCN\ts\tNature Conservancy Council, Norwich\t\t\t",
"NCCP\tc\tNational Culture Collection for Pathogens\t\t\t",
"NCCP<PAK>\tc\tNational Culture Collection of Pakistan\t\t\t",
"NCCPF\tc\tNational Culture Collection of Pathogenic Fungi\t\t\t",
"NCDC\tc\tNational Collection of Dairy Cultures\t\t\t",
"NCE\ts\tUniversity of Newcastle upon Tyne, School of Biological Sciences\t\t\t",
"NCF\ts\tDepartment of Forest Insects, Northwest College of Forestry\t\t\t",
"NCFB\tc\tNational Collection of Food Bacteria\tNCDO\t\t",
"NCH\ts\tNorwich Botanical Society\t\t\t",
"NCHU\ts\tNational Chung Hsing University\t\t\t",
"NCHU:ZOOL\ts\tNational Chung Hsing University, Department of Life Science\t\t",
"NCIM\tc\tNational Collection of Industrial Microorganisms\t\t\t",
"NCIMB\tc\tNational Collection of Industrial, Food and Marine Bacteria (incorporating the NCFB)\tNCIB,NCMB\t\t",
"NCIP\ts\tPusat Penelitian dan Pengembangan Oseanologi\t\t\t",
"NCKU\ts\tNational Cheng-Kung University, Biology Department\t\t\t",
"NCLN\ts\tNew College\t\t\t",
"NCMA<USA-ME>\tc\tNational Center for Marine Algae and Microbiota\t\t\t",
"NCMA<USA-NC>\ts\tRaleigh, North Carolina Department of Environmental Health and Natural Resources\t\t\t",
"NCMH\tc\tThe North Carolina Memorial Hospital\t\t\t",
"NCMK\ts\tNorwich Castle Museum\t\t\t",
"NCMS\ts\tNorth Carolina Museum of Natural Sciences\t\t\t",
"NCP\ts\tNational  Collection of Passiflora\t\t\t",
"NCPF\tc\tNational Collection of Pathogenic Fungi\t\t\t",
"NCPPB\tc\tNational Collection of Plant Pathogenic Bacteria\t\t\t",
"NCPV\tc\tNational Collection of Pathogenic Viruses\t\t\t",
"NCS\ts\tNorth Carolina State University\t\t\t",
"NCSC<THA>\tc\tNational Center of Streptococcus Collection, Department of Microbiology, Faculty of Medical Science\t\t\t",
"NCSC<USA-NC>\ts\tNorth Carolina State University, Botany Department\t\t\t",
"NCSLG\ts\tNorth Carolina State University (Larry F. Grand Mycological Herbarium)\t\t\t",
"NCSM\ts\tNorth Carolina Museum of Natural Sciences\tNCSMNS\t\t",
"NCSM:Birds\ts\tNorth Carolina Museum of Natural Sciences, Birds collection\t\t",
"NCSM:Fishes\ts\tNorth Carolina Museum of Natural Sciences, Fish collection\t\t",
"NCSM:Herp\ts\tNorth Carolina Museum of Natural Sciences, Herpetology Collection\t\t",
"NCSM:Mammals\ts\tNorth Carolina Museum of Natural Sciences, Mammal collection\t\t",
"NCSU\ts\tNorth Carolina State University Collections\t\t\t",
"NCTC\tc\tNational Collection of Type Cultures\t\thttps://www.phe-culturecollections.org.uk/products/bacteria/detail.jsp?collection=nctc&refId=NCTC+\t",
"NCU\ts\tUniversity of North Carolina, North Carolina Botanical Garden\t\t\t",
"NCUT\ts\tNicolaus Copernicus University\t\t\t",
"NCWRF\tc\tNational Collection of Wood Rotting Fungi\t\t\t",
"NCY\ts\tConservatoire et Jardins Botaniques de Nancy\t\t\t",
"NCYC\tc\tNational Collection of Yeast Cultures\t\t\t",
"NCZP\ts\tNorth Carolina Zoological Park\t\t\t",
"ND\ts\tUniversity of Notre Dame, Department of Biological Sciences\tNDG\t\t",
"NDA\ts\tNorth Dakota State University, Animal and Range Sciences Department\t\t\t",
"NDAA\ts\tOrange, New South Wales Department of Agriculture\t\t\t",
"NDAT\ts\tDepartment of Agriculture, Tunisia\t\t\t",
"NDFC\ts\tNewfoundland Department of Forestry\t\t\t",
"NDG\ts\tUniversity of Notre Dame, Department of Biological Sciences\tND\t\t",
"NDO\ts\tDivision of Forest Research, Forest Department\t\t\t",
"NDOA\ts\tNevada Department of Agriculture\t\t\t",
"NDSR\ts\tNational Drosophila Species Resource Center\t\t\t",
"NDSU\ts\tNorth Dakota State University\t\t\t",
"NDTC\ts\tNingde Teachers College, Biology Department\t\t\t",
"NE\ts\tUniversity of New England\t\t\t",
"NEB\ts\tUniversity of Nebraska State Museum (C. E. Bessey Herbarium)\t\t\t",
"NEBC\ts\tNew England Botanical Club\t\t\t",
"NEBK\ts\tUniversity of Nebraska at Kearney\t\t\t",
"NEFI\ts\tNortheastern Forestry University, Forestry Department\t\t\t",
"NEGI\ts\tHerbarium Cepullae Sinicae\t\t\t",
"NEHU\ts\tNorth Eastern Hills University\t\t\t",
"NEM\tc\tFaculte de Medecine Necker-Enfants Malades\t\t\t",
"NEMO\ts\tTruman State University\t\t\t",
"NEMSU\ts\tTruman State University\t\t\t",
"NEMU\ts\tNewark Museum\t\t\t",
"NENU\ts\tNortheast Normal University, Biology Department\t\t\t",
"NEPCC\tc\tNorth East Pacific Culture Collection\t\t\t",
"NESH\ts\tUniversity of Nevada\t\t\t",
"NEU\ts\tUniversite de Neuchatel, Laboratoire de botanique evolutive\t\t\t",
"NEUN\ts\tNear East University\t\t\t",
"NEW\ts\tUniversity of Newcastle\t\t\t",
"NEWHM\ts\tHancock Museum\t\t\t",
"NEZ\ts\tMuseum, Zoology Department, University of New England\t\t\t",
"NF\ts\tNanjing Forestry University, Forest Resources and Environment\t\t\t",
"NFCCI\tc\tNational Fungal Culture Collection of India\t\t\t",
"NFCCP\tc\tNational Fungal Culture Collection of Pakistan\t\t\t",
"NFLD\ts\tMemorial University of Newfoundland, Biology Department\t\t\t",
"NFM\ts\tNewfoundland Museum\t\t\t",
"NFO\ts\tNiagara Parks Botanical Gardens and School of Horticulture\t\t\t",
"NFRC\ts\tNorthern Forest Research Centre\t\t\t",
"NFRDI\tc\tNational Fisheries Research & Development Institute\t\t\t",
"NFRI\tc\tNorwegian Forest Research Institute\t\t\t",
"NFRN\ts\tCanadian Forest Service, NRCan\t\t\t",
"NGBB\ts\tNezahat Gokyigit Botanik Bahcesi\t\t\t",
"NGCPR\ts\tNaoroji Godrej Centre for Plant Research\t\t\t",
"NGI\ts\tNanjing Geographical Institute\tNIG\t\t",
"NGM\ts\tBromley House Library\t\t\t",
"NGMC\ts\tNational Geological Museum of China\t\t\t",
"NGR\tc\tPlant Pathology\t\t\t",
"NGU\ts\tFaculty of Education, Niigata University\t\t\t",
"NH\ts\tSouth African National Biodiversity Institute\t\t\t",
"NHA\ts\tUniversity of New Hampshire, Plant Biology Department\t\t\t",
"NHCP\ts\tNational Bureau of Plant Genetic Resources (NBPGR)\t\t\t",
"NHES\ts\tConnecticut Agricultural Experiment Station, Entomology Department\t\t\t",
"NHG\ts\tNaturhistorische Gesellschaft e. V., Abteilung Botanik\t\t\t",
"NHI\ts\tNatural History Institute\t\t\t",
"NHIC\ts\tOntario Ministry of Natural Resources\t\t\t",
"NHJ\ts\tNational Herbarium of Jordan\t\t\t",
"NHL\tc\tNational Institute of Hygienic Sciences\t\t\t",
"NHM<CHE>\ts\tNaturhistorisches Museum, Bern\t\t\t",
"NHM<GBR-Nottingham>\ts\tUniversity of Nottingham, Botany Department\t\t\t",
"NHMA\ts\tNatural History Museum, Denmark\t\t\t",
"NHMB<CHE>\ts\tNaturhistorisches Museum, Basel\tNMBA\t\t",
"NHMB<HUN>\ts\tNatural History Museum Bucharest\t\t\t",
"NHMBe\ts\tNaturhistorisches Museum Bern\t\t\t",
"NHMC<GRC>\ts\tNatural History Museum of Crete, University of Crete\t\t\t",
"NHMC<MMR>\ts\tNatural History Museum, Rangoon\t\t\t",
"NHME\ts\tNatuurhistorisch Museum Maastricht\t\t\t",
"NHMF\ts\tNatural History Museum Fribourg\t\t\t",
"NHMG<CHN>\ts\tNatural History Museum of Guangxi\t\t\t",
"NHMG<SWE>\ts\tGoteborgs Naturhistoriska Museet\t\t\t",
"NHMK\ts\tLandesmuseum fuer Karnten\t\t\t",
"NHML\ts\tNatural History Museum, Tripoli\t\t\t",
"NHMM\ts\tNatuurhistorische Museum Maastricht\t\t\t",
"NHMM-LS\ts\tNaturhistorisches Museum/Landessammlung fuer Naturkunde Rheinland-Pfalz\t\t\t",
"NHMN\ts\tNottingham Natural History Museum (Wollaton Hall)\t\t\t",
"NHMO\ts\tNatural History Museum of Oslo\t\t\t",
"NHMO:BI\ts\tNatural History Museum of Oslo, The avian collection\t\t",
"NHMO:Herp\ts\tNatural History Museum of Oslo, Herpetile collection\t\t",
"NHMO:Mam\ts\tNatural History Museum of Oslo, Mammal collection\t\t",
"NHMO:Pisc\ts\tNatural History Museum of Oslo, Fish collection\t\t",
"NHMR<HRV>\ts\tNatural History Museum Rijeka\t\t\t",
"NHMR<ISL>\ts\tNatural History Museum, Reykjavik\t\t\t",
"NHMR<NLD>\ts\tNatuurhistorisch Museum Rotterdam\t\t\t",
"NHMS\ts\tNatural History Museum Split\t\t\t",
"NHMTU\ts\tNatural History Museum, Tribhuvan University\t\t\t",
"NHMUK\tsb\tNatural History Museum, London\tBM,BM(NH),BMNH,NHM,NHM R,NMH\t\t",
"NHMUK<PAK>\ts\tNatural History Museum, Karachi\t\t\t",
"NHMV\ts\tMuritzeum gGmbH / Naturhistorische Landessammlungen fur Mecklenburg-Vorpommern\t\t\t",
"NHMW\ts\tNaturhistorisches Museum, Wien\tNMW\t\t",
"NHNC\ts\tLa Chaux-de-Fons\t\t\t",
"NHNE\ts\tNew England College, Biology Department\t\t\t",
"NHR\ts\tInstitute of Scientific and Technological Research (IRST)\t\t\t",
"NHRI\ts\tIslandic Museum of Natural History\t\t\t",
"NHRM\ts\tNaturhistoriska Rijkmuseet\t\t\t",
"NHRS\ts\tSwedish Museum of Natural History\t\t\t",
"NHSD\ts\tNatural History Society of Dublin\t\t\t",
"NHST\ts\tMuseum of Natural History, Reunion\t\t\t",
"NHT\ts\tTropical Pesticides Research Institute\t\t\t",
"NHV\ts\tInstitut fuer Landwirtschaftliche Botanik\t\t\t",
"NI<JPN>\tc\tNagao Institute\t\t\t",
"NI<SVK>\ts\tSlovenska pol'nohospodarska Univerzita, Katedra botaniky\t\t\t",
"NIAB\tb\tNational Institute of Agricultural Botany\t\t\t",
"NIAES\tc\tNational Institute for Agro-Environmental Sciences\t\t\t",
"NIAH\tc\tNational Institute of Animal Health\t\t\t",
"NIAID\tc\tNational Institute of Allergy and Infectious Diseases\t\t\t",
"NIAS\tsb\tNational Institute of Agrobiological Sciences\t\t\t",
"NIBH\tc\tNational Institute of Bioscience and Human-Technology\t\t\t",
"NIBR\tscb\tNational Institute of Biological Resources\tNNIBR\t\t",
"NIBSC\tb\tNational Institute for Biological Standards and Control\t\t\t",
"NICC\ts\tNational Insect Collection\t\t\t",
"NICD\ts\tMalaria Research Center\t\t\t",
"NICE\ts\tMuseum d'Histoire Naturelle\t\t\t",
"NICH\ts\tHattori Botanical Laboratory\t\t\t",
"NIES\tc\tMicrobial Culture Collection\t\t\t",
"NIFI\ts\tNational Inland Fisheries Institute\t\t\t",
"NIFRS\ts\tNational Research Institute of Fisheries Science\t\t\t",
"NIG\ts\tNanjing Geographical Institute\tNGI\t\t",
"NIGL\ts\tNanjing Institute of Geography and Limnology\t\t\t",
"NIGP\ts\tNaking Institute of Geology and Palaeontology\t\t\t",
"NIHHS\ts\tNational Institute of Horticultural and Herbal Science, RDA\t\t\t",
"NIM\ts\tMuseum d'histoire naturelle de Nimes\t\t\t",
"NIMM\ts\tNational Institute of Medicinal Materials\t\t\t",
"NINF\ts\tNewfoundland Insectarium\t\t\t",
"NIO\ts\tNational Institute of Oceanography\t\t\t",
"NIOCC\tc\tNational Institute of Oceanography Culture Collection\t\t\t",
"NIPH\tc\tNational Institute of Public Health, Collection A. Nemec\t\t\t",
"NIPR\ts\tNational Institute of Polar Research, Biological Data Department\t\t\t",
"NISL\tc\tNoda Institute for Scientific Research\t\t\t",
"NIT\ts\tJardim Botanico de Niteroi\t\t\t",
"NIWA\ts\tNational Institute of Water and Atmospheric Research\t\t\t",
"NJ\ts\tNjala University College\t\t\t",
"NJM<CZE>\ts\tMuzeum Novojieinska\t\t\t",
"NJM<JPN>\tc\tNippon Veterinary and Animal Science University\t\t\t",
"NJNU\ts\tNanjing Normal University, Biology Department\t\t\t",
"NJSM\ts\tNew Jersey State Museum\t\t\t",
"NKA\tc\tNationales Konsiliarlabor fur Adenoviren\t\t\t",
"NKMC\ts\tNational Kweiyang Medical College\t\t\t",
"NKME\ts\tNaturkundemuseum Erfurt\t\t\t",
"NKMU\ts\tNankai University Museum\t\t\t",
"NKU\ts\tNankai University, Biology Department\t\t\t",
"NKUM\ts\tNankai University\t\t\t",
"NLEC\ts\tNeal L. Evenhuis\t\t\t",
"NLH\ts\tAgricultural University of Norway, Department of Biology and Nature Conservation\t\t\t",
"NLHD\ts\tNiedersachsisches Landesmuseum\t\t\t",
"NLPS\ts\tNottingham Literary and Philosophical Society\t\t\t",
"NLSN\ts\tNotre Dame University, Biological Sciences Department\t\t\t",
"NLU\ts\tUniversity of Louisiana at Monroe, Museum of Natural History\t\t\t",
"NLUH\ts\tUniversity of the Philippines College Baguio\t\t\t",
"NM\ts\tNorthern Michigan University, Biology Department\t\t\t",
"NMAC\ts\tInner Mongolia Agricultural University, Department of Pratacultural Science\t\t\t",
"NMAG\ts\tNaturhistorisches Museum, Augsburg\t\t\t",
"NMB\tc\tNingbo Marine Biotechnology\t\t\t",
"NMB<CHE>\ts\tNaturhistorishes Museum\t\t\t",
"NMB<ZAF>\ts\tNational Museum, Bloemfontein\t\t\t",
"NMB<ZAF>:P\ts\tNational Museum, Bloemfontein, The Protozoan collection of the National Museum\t\t",
"NMBA<ARG>\ts\tNational Museum, Buenos Aires\t\t\t",
"NMBA<AUT>\ts\tNaturhistorisches Museum der Benediktiner-Abtei\t\t\t",
"NMBA<CHE>\ts\tNaturhistorisches Museum, Basel\tNHMB\t\t",
"NMBE\ts\tNaturhistorisches Museum der Burgergemeinde Bern\tNHM\t\t",
"NMBO\ts\tNational Museum, Bloemfontein\tNMB\t\t",
"NMBT\ts\tNatuurmuseum Brabant\t\t\t",
"NMBZ\ts\tNatural History Museum of Zimbabwe\t\t\t",
"NMC\ts\tNew Mexico State University, Department of Biology\t\t\t",
"NMC<CAN>\ts\tCanadian Museum of Nature\tCMN\t\t",
"NMCC<IND>\tc\tNorth Maharashtra Microbial Culture Collection Centre\t\t\t",
"NMCDC\ts\tInner Mongolia Center for Endemic Disease Control and Research\t\t\t",
"NMCI<JPN>\ts\tNoto Marine Center Ishikawa Prefecture\t\t\t",
"NMCI<JPN>:AR\ts\tNoto Marine Center Ishikawa Prefecture, Arthropoda collection\t\t",
"NMCI<JPN>:EC\ts\tNoto Marine Center Ishikawa Prefecture, Echinodermata\t\t",
"NMCI<JPN>:IV\ts\tNoto Marine Center Ishikawa Prefecture, Invertebrata\t\t",
"NMCI<JPN>:MO\ts\tNoto Marine Center Ishikawa Prefecture, Mollusca collection\t\t",
"NMCI<JPN>:P\ts\tNoto Marine Center Ishikawa Prefecture, Pisces  and Coelenterata\t\t",
"NMCI<JPN>:S\ts\tNoto Marine Center Ishikawa Prefecture, Sea weed\t\t",
"NMCL\ts\tNaturkunde-Museum\t\t\t",
"NMCR\ts\tNew Mexico State University, Department of Animal and Range Sciences\t\t\t",
"NME\ts\tSammlung des Naturkundemseum Erfurt\t\t\t",
"NMED\ts\tNew Mexico Environment Department\t\t\t",
"NMEG\ts\tNaturkundesmuseum\t\t\t",
"NMFC\ts\tInner Mongolia Forestry College, Desert Control and Utilization Department\t\t\t",
"NMFSH\ts\tNational Marine Fisheries Service\t\t\t",
"NMI\ts\tNational Museum of Ireland\tNMID\t\t",
"NMI<POL>\tc\tBacteria collection of National Institute of Public Health, National Medicines Institute, Poland\t\t\t",
"NMID\ts\tNational Museum of Ireland\tNMD\t\t",
"NMK\ts\tNational Museums of Kenya\t\t\t",
"NMK:HERP\ts\tNational Museums of Kenya, Herpetology Collection\t\t",
"NMK:ICH\ts\tNational Museums of Kenya, Ichthyology collection\t\t",
"NMK:ORN\ts\tNational Museums of Kenya, Ornithology Collection\t\t",
"NMKE\ts\tNational Museum of Kenya\tMK\t\t",
"NMKL\ts\tNational Museum of Malaysia\t\t\t",
"NML\tc\tNational Microbiology Laboratory, Public Health Agency of Canada\tNML-HCCC\t\t",
"NMLS\ts\tNatur-Museum Luzern\t\t\t",
"NMLU\ts\tNatur-Museum Luzern, Botany Department\t\t\t",
"NMMA\ts\tNantucket Maria Mitchell Association, Natural Sciences Department\t\t\t",
"NMMBP\ts\tNational Museum of Marine Biology and Aquarium\tMNNB-P\t\t",
"NMMH\ts\tNorth Manchurian Museum\t\t\t",
"NMML\ts\tNational Marine Mammal Laboratory\t\t\t",
"NMMNH\ts\tNew Mexico Museum of Natural History and Science\t\t\t",
"NMMNH:Mamm\ts\tNew Mexico Museum of Natural History and Science, Mammal collection\t\t",
"NMMTB\ts\tNational Marine Mammal Tissue Bank\t\t\t",
"NMN\ts\tNorthamptonshire Natural History Society\t\t\t",
"NMND\ts\tNational Museum of Natural History, New Delhi\tNMNH,NMNHI\t\t",
"NMNH<IND>\ts\tNational Museum of Natural History, New Delhi\tNMND,NMNHI\t\t",
"NMNHI\ts\tNational Museum of Natural History, New Delhi\tNMND,NMNH\t\t",
"NMNK\ts\tNational Museum of Nepal\t\t\t",
"NMNL\ts\tNatuurmuseum Nijmegen e.o.\t\t\t",
"NMNS\ts\tNational Museum of Natural Science\t\t\t",
"NMNW\ts\tNational Museum of Namibia\t\t\t",
"NMNZ\ts\tNational Museum of New Zealand\t\t\t",
"NMNZ:AI\ts\tNational Museum of New Zealand, Insects\t\t",
"NMNZ:AM\ts\tNational Museum of New Zealand, Amphibians\t\t",
"NMNZ:AS\ts\tNational Museum of New Zealand, Spiders\t\t",
"NMNZ:CR\ts\tNational Museum of New Zealand, Crustacea\t\t",
"NMNZ:M\ts\tNational Museum of New Zealand, Molluscs\t\t",
"NMNZ:MM\ts\tNational Museum of New Zealand, Marine Mammals\t\t",
"NMNZ:OR\ts\tNational Museum of New Zealand, Birds\t\t",
"NMNZ:P\ts\tNational Museum of New Zealand, Fish\t\t",
"NMNZ:RE\ts\tNational Museum of New Zealand, Reptiles\t\t",
"NMNZ:S\ts\tNational Museum of New Zealand, Fossil Vertebrates\t\t",
"NMNZ:TS\ts\tNational Museum of New Zealand, Tissue Collection\t\t",
"NMNZ:TSA\ts\tNational Museum of New Zealand, Tissue Collection\t\t",
"NMP<CZE>\ts\tNational Museum (Prague)\t\t\t",
"NMP<ZAF>\ts\tKwaZulu-Natal Museum\tNMSA\t\t",
"NMPC\ts\tNational Museum Prague\tMNHP<CZE>\t\t",
"NMPC:ENT\ts\tNational Museum Prague, Entomology Collection\t\t",
"NMPG<CHN>\ts\tZhejiang Institute of Traditional Chinese Medicine\t\t\t",
"NMPG<DEU>\ts\tMuseum der Natur-Gotha\t\t\t",
"NMPI\ts\tDivision of Plant Industry\t\t\t",
"NMR\ts\tSemyung University\t\t\t",
"NMRC<USA-MD>\tc\tNaval Medical Research Center\t\t\t",
"NMRC<USA-MD>:RDD\tc\tNaval Medical Research Center, Rickettsial Diseases Division\t\t",
"NMS\ts\tNational Museums of Scotland\tNMSZ,NSMZ,RSM<GBR>,RSME\t\t",
"NMS-G\ts\tNational Museums of Scotland - Geology & Zoology\t\t\t",
"NMSA\ts\tNatal Museum\t\t\t",
"NMSG\ts\tNaturmuseum St. Gallen\t\t\t",
"NMSL\ts\tNational Museum of Sri Lanka\t\t\t",
"NMSR\ts\tNaturhistorisches Museum im Thuringer Landes museum Heidecksburg zu Rudolstadt\t\t\t",
"NMSU<USA-MO>\ts\tNorthwest Missouri State University, Biology Department\t\t\t",
"NMSU<USA-NM>\ts\tNew Mexico State University\t\t\t",
"NMTC\ts\tInner Mongolia Normal University, Biology Department\t\t\t",
"NMTT\ts\tNational Museum and Art Gallery, Port-of-Spain\t\t\t",
"NMV<AUS>\ts\tMuseum Victoria\tNMM\t\t",
"NMV<AUS>:A\ts\tMuseum Victoria, Ichthyology\t\t",
"NMV<AUS>:AV\ts\tMuseum Victoria, Entomology - Australian Voucher Specimens\t\t",
"NMV<AUS>:B\ts\tMuseum Victoria, Ornithology\t\t",
"NMV<AUS>:BE\ts\tMuseum Victoria, Ornithology - Eggs\t\t",
"NMV<AUS>:BUP\ts\tMuseum Victoria, Buprestidae\t\t",
"NMV<AUS>:C\ts\tMuseum Victoria, Mammology\t\t",
"NMV<AUS>:COL\ts\tMuseum Victoria, Coleoptera\t\t",
"NMV<AUS>:D\ts\tMuseum Victoria, Herpetology\t\t",
"NMV<AUS>:DIP\ts\tMuseum Victoria, Diptera\t\t",
"NMV<AUS>:DTB\ts\tMuseum Victoria, Ornithology - Donald Thompson Collection\t\t",
"NMV<AUS>:DTD\ts\tMuseum Victoria, Herpetology - Donald Thompson Collection\t\t",
"NMV<AUS>:F\ts\tMuseum Victoria, Invertebrates Collection\t\t",
"NMV<AUS>:G\tb\tMuseum Victoria, DNA Products\t\t",
"NMV<AUS>:H\ts\tMuseum Victoria, Hygrobatidae\t\t",
"NMV<AUS>:HEM\ts\tMuseum Victoria, Hemiptera\t\t",
"NMV<AUS>:HET\ts\tMuseum Victoria, Heteroptera\t\t",
"NMV<AUS>:HLW\ts\tMuseum Victoria, Ornithology - H.L. White Collection\t\t",
"NMV<AUS>:HYM\ts\tMuseum Victoria, Hymenoptera\t\t",
"NMV<AUS>:ISO\ts\tMuseum Victoria, Isoptera\t\t",
"NMV<AUS>:J\ts\tMuseum Victoria, Crustacea\t\t",
"NMV<AUS>:K\ts\tMuseum Victoria, Arachnology\t\t",
"NMV<AUS>:LEP\ts\tMuseum Victoria, Lepidoptera\t\t",
"NMV<AUS>:MEC\ts\tMuseum Victoria, Mecoptera\t\t",
"NMV<AUS>:MEG\ts\tMuseum Victoria, Megaloptera\t\t",
"NMV<AUS>:NEU\ts\tMuseum Victoria, Neuroptera\t\t",
"NMV<AUS>:NOH\ts\tMuseum Victoria, Northofagus Project\t\t",
"NMV<AUS>:ODO\ts\tMuseum Victoria, Odonata\t\t",
"NMV<AUS>:P\ts\tMuseum Victoria, Paleontology & Paleobotany\t\t",
"NMV<AUS>:T\ts\tMuseum Victoria, Entomlogy Type Collection\t\t",
"NMV<AUS>:TRI\ts\tMuseum Victoria, Trichoptera\t\t",
"NMV<AUS>:Z\ts\tMuseum Victoria, Tissue Collection\t\t",
"NMV<JPN>\ts\tNakagawa Museum at Nakagawa-cho\t\t\t",
"NMW<AUT>\ts\tNaturhistorisches Museum, Wien\tNHMV,NHMW\t\t",
"NMW<GBR>\ts\tNational Museums & Galleries of Wales, Department of Biodiversity and Systematic Biology\t\t\t",
"NMWC\ts\tNational Museum of Wales\t\t\t",
"NMWZ\ts\tNational Museum of Wales\t\t\t",
"NMZB\ts\tNational Museum of Zimbabwe\t\t\t",
"NMZL\ts\tNational Museum of Zambia\t\t\t",
"NNA\ts\tNanning Arboretum\t\t\t",
"NNHMK\ts\tNational Natural History Museum of the Ukraine\t\t\t",
"NNKN\ts\tNoordbrabants Natuurmuseum\t\t\t",
"NNM\ts\tNationaal Natuurhistroisch Museum\t\t\t",
"NNMN\ts\tNationaal Natuurhistorisch Museum Naturalis\t\t\t",
"NNSU\ts\tN. I. Lobachevsky Nizhni Novgorod State University, Department of Botany\t\t\t",
"NO\ts\tTulane University, Department of Ecology and Evolutionary Biology\t\t\t",
"NOAA\ts\tNational Oceanic and Atmospeheric Administration\t\t\t",
"NOAA:MarFor\ts\tNational Oceanic and Atmospeheric Administration, Marine Forensics\t\t",
"NOAS\ts\tNew Orleans Academy of Science\t\t\t",
"NOCC\ts\tNational Orchid Conservation Center\t\t\t",
"NOCS-DC\ts\tNational Oceanography Center Southampton Discovery Collections\t\t\t",
"NODCAR\tc\tmarwa mokhtar Abd Rabo\t\t\t",
"NoF\tc\tThe Fungus Culture Collection of the Northern Forestry Centre\t\t\t",
"NOI\ts\tNanhai Oceanographic Institute\t\t\t",
"NOLS\ts\tUniversity of New Orleans, Biological Sciences Department\t\t\t",
"NORCCA\tc\tNorwegian Culture Collection of Algae\tNIVA\t\t",
"NOSU\ts\tNortheastern State University, Natural Sciences and Mathematics Department\t\t\t",
"NOT\ts\tNottingham City Natural History Museum\t\t\t",
"NOTM\ts\tUniversity of Nottingham, Manuscript Department\t\t\t",
"NOU\ts\tInstitut de Recherche pour le Developpement, Botany and Applied Ecology Department\t\t\t",
"NPA\ts\tNanjing Institute of Geology and Paleontology, Academia Sinica\t\t\t",
"NPB\ts\tNatal Parks, Game, and Fish Preservation Board, Research Section\t\t\t",
"NPC\ts\tNational Pusa Collection\t\t\t",
"NPCCAA\tc\tNational Pathogen Collection Center for Aquatic Animals\t\t\t",
"NPIB\ts\tNorthwest Plateau Institute of Biology\t\t\t",
"NPP\tc\tN.P.P\t\t\t",
"NPRI\ts\tSeoul National University\t\t\t",
"NPS\ts\tUnited States National Park Service\t\t\t",
"NPSC\ts\tNorthern Prairie Science Center\t\t\t",
"NPT\ts\tNewport Museum and Art Gallery\t\t\t",
"NPWRC\ts\tNorthern Prairie Research Center\t\t\t",
"NR\ts\tInstitute of Forest Ecology Slovak Academy of Sciences\t\t\t",
"NRC\tc\tDivision of Biological Sciences, National Research Council of Canada\t\t\t",
"NRC<EGY>\ts\tNational Research Centre\t\t\t",
"NRCC\ts\tNational Research Council of Canada\t\t\t",
"NRCS\tc\tNational Reference Center for Streptococci in Aachen\t\t\t",
"NRIBAS\ts\tNational Research Institute of Biology, Academia Sinica\t\t\t",
"NRIC\tc\tNODAI Research Institute Culture Collection\t\t\t",
"NRL\tc\tNeisseria Reference Laboratory\t\t\t",
"NRM\ts\tSwedish Museum of Natural History\t\t\t",
"NRN\ts\tNairn Literary Society Library, Public Library\t\t\t",
"NRNZ\ts\tNorthland Regional Museum\t\t\t",
"NRPSU\tc\tDepartment of Agro-industry, Faculty of Natural Resources\t\t\t",
"NRRL\tc\tAgricultural Research Service Culture Collection\t\thttps://nrrl.ncaur.usda.gov/cgi-bin/usda/prokaryote/report.html?nrrlcodes=\t",
"NRRL:MOLD\tsc\tAgricultural Research Service Culture Collection, Mold collection\thttps://www.ncbi.nlm.nih.gov/Taxonomy/nrrl/mold.cgi?",
"NRRL:PROK\tsc\tAgricultural Research Service Culture Collection, Prokaryotic collection\thttp://nrrl.ncaur.usda.gov/cgi-bin/usda/prokaryote/report.html?nrrlcodes=",
"NRRL:YEAST\tsc\tAgricultural Research Service Culture Collection, Yeast Collection\thttps://www.ncbi.nlm.nih.gov/Taxonomy/nrrl/yeast.cgi?",
"NRS\ts\tNaturhistoriska Riksmuseet\t\t\t",
"NRWC\ts\tN. R. Whitney Collection\t\t\t",
"NRZM\tc\tGerman Reference Center for Meningococci\t\t\t",
"NS\ts\tCentral Siberian Botanical Garden\t\t\t",
"NSAC\ts\tNova Scotia Agricultural College, Department of Environmental Sciences\t\t\t",
"NSCA\ts\tNorth Scotland College of Agriculture\t\t\t",
"NSCNFB\tc\tNovi Sad Collection of Nitrogen Fixing Bacteria\t\t\t",
"NSCPM\tc\tNational State Collection of Pathogenic Microorganisms\t\t\t",
"NSDA\ts\tNevada Division of Agriculture\t\t\t",
"NSK\ts\tSiberian Central Botanical Garden, Laboratory for Plant Systematics and Floristic Genesis\t\t\t",
"NSM<CAN>\ts\tNova Scotia Museum of Natural History\tNSMC\t\t",
"NSM<CHN>\ts\tSun Yat-Sen Tomb and Memorial Park Commission\t\t\t",
"NSM<JPN>\ts\tNSM-PV, National Science Museum\t\t\t",
"NSMC<CAN>\ts\tNova Scotia Museum\tNSM\t\t",
"NSMC<USA-NV>\ts\tNevada State Museum\t\t\t",
"NSMHS\ts\tNevada State Museum and Historical Society\t\t\t",
"NSMK\ts\tNational Science Museum\t\t\t",
"NSMT\ts\tNational Museum of Nature and Science, Tokyo\t\t\t",
"NSMW\ts\tNaturwissenschftlich Sammlung, Museum Wiesbaden\t\t\t",
"NSNR\ts\tNova Scotia Department of Natural Resources\t\t\t",
"NSPM\ts\tNova Scotia Museum of Natural History\t\t\t",
"NSRF\ts\tNova Scotia Research Foundation\t\t\t",
"NSS\ts\tUniversity of Liverpool Botanic Gardens\t\t\t",
"NSU\ts\tNortheastern State University, Biological Collections\t\t\t",
"NSUL\ts\tNorthwestern State University of Louisiana\t\t\t",
"NSW\ts\tRoyal Botanic Gardens\t\t\t",
"NSWA\ts\tNew South Wales Department of Agriculture\t\t\t",
"NSWF\ts\tState Forests of New South Wales\t\t\t",
"NSWGS\ts\tGeological Survey of New South Wales\t\t\t",
"NSYU\ts\tNational Sun Yat-sen University\t\t\t",
"NT\ts\tDepartment of Natural Resources, Environment and the Arts\tDNA\t\t",
"NTCCI\tc\tCulture Collection, Microbiology and Cell Biology Laboratory\t\t\t",
"NTDPIF\ts\tNorthern Territory Department of Primary Industry and Fisheries\t\t\t",
"NTLN\ts\tCounty Record Office, County Archives Department\t\t\t",
"NTM\ts\tMuseum and Art Gallery of the Northern Territory\t\t\t",
"NTM<FRA>\ts\tMuseum d'Histoire Naturelle de Nantes\t\t\t",
"NTN\ts\tCentral Museum and Art Gallery\t\t\t",
"NTNU\ts\tNational Taiwan Normal University\tNTNUB\t\t",
"NTNU-VM\ts\tNorwegian University of Science and Technology, Museum of Natural History and Archaeology\t\t\t",
"NTOU\tsc\tInstitute of Marine Biology, National Taiwan Ocean University\t\t\t",
"NTS\ts\tNevada Operations Office, U.S. Department of Energy\t\t\t",
"NTSC\ts\tUniversity of North Texas, Biological Sciences Department\t\t\t",
"NTUF\ts\tNational Taiwan University, Forestry Department\t\t\t",
"NTUM\ts\tNational Taiwan University\t\t\t",
"NTUMA\ts\tNational Taiwan University\t\t\t",
"NU<THA>\tc\tDepartment of Microbiology, Faculty of Science\t\t\t",
"NU<ZAF>\ts\tUniversity of Natal, School of Botany and Zoology\t\t\t",
"NUA\tc\tDepartment of Microbiology, National University of Athens\t\t\t",
"NUM\ts\tNagoya University\t\t\t",
"NUOL\ts\tNational University of Laos\t\t\t",
"NUSDM\tc\tDepartment of Microbiology, National University of Singapore\t\t\t",
"NUSMBS\ts\tNiigata University, Sado Marine Biological Station\t\t\t",
"NUV\ts\tNorwich University, Biology and Life Sciences Department\t\t\t",
"NUVC\ts\tNortheastern University, Vertebrate Collection\t\t\t",
"NVDA\ts\tNevada State Department of Agriculture\t\t\t",
"NVMC\ts\tNevada State Museum\t\t\t",
"NVRL\ts\tNaturforschende Verein in Riga\t\t\t",
"NVRW\ts\tNaturhistorisches Verein der Preussische Rheinland und Westfalens\t\t\t",
"NWAU\ts\tNorth-West Agricultural University\t\t\t",
"NWC\ts\tUniversity of Northern Iowa, Nixon Wilson Collection\t\t\t",
"NWC<GBR>\tb\tNational Willows Collection\t\t\t",
"NWFC\tsb\tNorthwest University of Agriculture Forestry Science & Technology\t\t\t",
"NWH\ts\tNorfolk Museums and Archaeology Service, Natural History Department\t\t\t",
"NWK\ts\tNewark District Council Museum\t\t\t",
"NWMSU\ts\tNorthwest Missouri State University\t\t\t",
"NWOSU\ts\tNorthwestern Oklahoma State University, Biology Department\t\t\t",
"NWSW\ts\tNaturwissenschaftliche Sammlungen der Stadt Winterthur\t\t\t",
"NWT\ts\tHarper Adams Agricultural College\t\t\t",
"NWTC\ts\tNorthwest Normal University\t\t\t",
"NWU\ts\tNorthwestern University, Botany Department\t\t\t",
"NWUB\ts\tNorthwest Normal University, Biology Department\t\t\t",
"NX\ts\tUniversidade do Estado de Mato Grosso - Campus de Nova Xavantina, Departamento de Ciencias Biologicas\t\t\t",
"NXAC\ts\tNingxia Agricultural College\t\t\t",
"NXF\ts\tNingxia Academy of Agriculture and Forestry Sciences\t\t\t",
"NY\ts\tNew York Botanical Garden\t\t\t",
"NYA\ts\tNanyue Arboretum\t\t\t",
"NYAS\ts\tSilvicultural Research Station\t\t\t",
"NYBG\ts\tNew York Botanical Garden\t\t\t",
"NYNU\tc\tMicrobiology Lab, Nanyang Normal University\t\t\t",
"NYS\ts\tNew York State Museum\t\t\t",
"NYSM\ts\tNew York State Museum\t\t\t",
"NYSM:ZM\ts\tNew York State Museum, Mammal collection\t\t",
"NYSM:ZO\ts\tNew York State Museum, Birds collection\t\t",
"NYZS\ts\tNew York Zoological Society\t\t\t",
"NZAC\ts\tNew Zealand Arthropod Collection\tLCR:NZAC\thttp://scd.landcareresearch.co.nz/Specimen/NZAC_&spec;\t",
"NZCS\ts\tUniversity, National Zoological Collection of Suriname\t\t\t",
"NZFRI\ts\tNew Zealand Forest Research Institute Limited\t\t\t",
"NZFS\tc\tForest Research Culture Collection\t\t\t",
"NZG\ts\tNational Zoological Gardens of South Africa\t\t\t",
"NZOI\ts\tNew Zealand Oceanographic Institute\t\t\t",
"NZP\tc\tNew Zealand Department of Scientific and Industrial Research\t\t\t",
"NZRD\tc\tNew Zealand Reference Culture Collection of Microorganisms, Dairy Section\t\t\t",
"NZRM\tc\tNew Zealand Reference Culture Collection, Medical Section\t\t\t",
"NZRP\tc\tNew Zealand Reference Culture Collection and Soil Section\t\t\t",
"NZSI\ts\tZoological Survey of India, National Zoological Collection\t\t\t",
"O\ts\tBotanical Museum, Natural History Museum, Oslo\t\t\t",
"OAC\ts\tOAC Herbarium, Biodiversity Institute of Ontario\tUOG:OAC\t\t",
"OAKL\ts\tOakland Museum of California, Natural Sciences Department\t\t\t",
"OAMB\ts\tOpen Air Museum of Ethnography and Natural Sciences\t\t\t",
"OAX\ts\tInstituto Politecnico Nacional (CIIDIR-Oax., I.P.N.)\t\t\t",
"OAXM\ts\tCentro Interdisciplinario de Estudios, Coleccion Mastozoologica (Mexico)\t\t\t",
"OB\ts\tStation Umwelt- und Natur Oberhausen\t\t\t",
"OBG<OMN>\ts\tThe Oman Botanic Garden\t\t\t",
"OBI\ts\tRobert F. Hoover Herbarium California Polytechnic State University\t\t\t",
"OBPF\ts\tPlanting Fields Arboretum State Historic Park\t\t\t",
"OC\ts\tOberlin College, Biology Department\t\t\t",
"OCHA\ts\tOchanomizu University\t\t\t",
"OCLA\ts\tUniversity of Science and Arts of Oklahoma\t\t\t",
"OCM\tc\tOregon Collection of Methanogens\t\t\t",
"OCNF\ts\tOchoco National Forest\t\t\t",
"OCRI\tscb\tOil Crops Research Institute\t\t\t",
"OCSA\ts\tVeterinary Research Institute\t\t\t",
"OCU\ts\tOklahoma City University\t\t\t",
"ODAC\ts\tOregon Department of Agriculture\t\t\t",
"ODU\ts\tOld Dominion University, Department of Biological Sciences\t\t\t",
"OFC\ts\tOrielton Field Centre\t\t\t",
"OGDF\ts\tForest Service Region 4, USDA\t\t\t",
"OGL\tb\tOcean Genome Legacy\t\t\t",
"OGL:OGR\tb\tOcean Genome Legacy, Ocean Genome Resource\t\t",
"OGU\ts\tOdesskij Gosudarstvennij Universitet\t\t\t",
"OH\ts\tAgricultural Museum of Praha\t\t\t",
"OHBR\ts\tOntario Hydro\t\t\t",
"OHHI\ts\tOrel State University\t\t\t",
"OHM\ts\tOldham Microscopical and Natural History Society\t\t\t",
"OHN\ts\tRegionherbariet i Oskarshamn\t\t\t",
"OHSC\ts\tOhio Historical Society\t\t\t",
"OKA\ts\tOksky State Biosphere Reserve\t\t\t",
"OKAY\ts\tOkayama University of Science, Department of Biosphere-Geosphere System Science\t\t\t",
"OKL\ts\tUniversity of Oklahoma, Botany and Microbiology Department/ Oklahoma Biological Survey\t\t\t",
"OKLA\ts\tOklahoma State University, Botany Department\t\t\t",
"OL\ts\tPalacky University, Botany Department\t\t\t",
"OLAN\ts\tMinisterio de Recursos Naturales\t\t\t",
"OLD\ts\tUniversitat Oldenburg\t\t\t",
"OLDM\ts\tLibraries, Art Galleries and Museums\t\t\t",
"OLDS\ts\tOlds College, Horticulture Department\t\t\t",
"OLE\ts\tOundle School, Biology Department\t\t\t",
"OLM\ts\tVlastivedne muzeum v Olomouci\t\t\t",
"OLML\ts\tOberoesterreichisches Landesmuseum\t\t\t",
"OLP\ts\tUniverzity Palackeho, Katedra biologie\t\t\t",
"OLS\ts\tUniversity of Warmia and Mazury\t\t\t",
"OLTC\ts\tTeachers Training College, Botany Department\t\t\t",
"OLV\ts\tOlivet College, Biology Department\t\t\t",
"OLYM\ts\tOlympic National Park\t\t\t",
"OM\ts\tOtago Museum\tOMNZ\t\t",
"OMA\ts\tUniversity of Nebraska Omaha, Biology Department\t\t\t",
"OMC<NZL>\ts\tCatalogues in Otago Museum\t\t\t",
"OMC<USA>\ts\tMills College, Biology Department\t\t\t",
"OMJ\ts\tOkresni muzeum a galerie\t\t\t",
"OMKH\ts\tOblastni muzeum Kutna Hora\t\t\t",
"OMNH<JPN>\ts\tOsaka Museum of Natural History\t\t\t",
"OMNH<USA-OK>\ts\tOklahoma Museum of Natural History\t\t\t",
"OMNH<USA-OK>:Amphibian\ts\tOklahoma Museum of Natural History, Amphibian collection\t\t",
"OMNH<USA-OK>:Birds\ts\tOklahoma Museum of Natural History, Birds Collection\t\t",
"OMNH<USA-OK>:Eggs\ts\tOklahoma Museum of Natural History, Eggs collection\t\t",
"OMNH<USA-OK>:Fish\ts\tOklahoma Museum of Natural History, Fish collection\t\t",
"OMNH<USA-OK>:Mammal\ts\tOklahoma Museum of Natural History, Mammals Collection\t\t",
"OMNH<USA-OK>:Reptile\ts\tOklahoma Museum of Natural History, Reptile Collection\t\t",
"OMNHN\ts\tThe Sam Noble Oklahoma State Museum of Natural History\t\t\t",
"OMNHO\ts\tOsaka Museum of Natural History\tOMNH\t\t",
"OMNZ\ts\tOtago Museum\tOM\t\t",
"OMP\ts\tPolabske muzeum v Podebradech\t\t\t",
"OMPB\ts\tOsservatorio per le Malattie delle Piante per la Regione Emilia-Romagna\t\t\t",
"OMPG\ts\tOsservatorio per le Malattie delle Piante per le Province di Genova e La Spezia\t\t\t",
"OMPS\ts\tOsservatorio per le Malattie delle Piante per la Sardegna\t\t\t",
"OMSK\ts\tOmsk Pedagogical Univeristy\t\t\t",
"OMSKM\ts\tOmsk State Agrarian University, Department of Forestry and Plant Conservation\t\t\t",
"OMUB\ts\tOndokuz Mayis University, Biology Department\t\t\t",
"ON\ts\tOman Natural History Museum\t\t\t",
"ONNC\ts\tOffice de la Recherche Scientifique et Technique d'Outre-Mer\t\t\t",
"ONPC\ts\tOlympic National Park\tONP\t\t",
"OOM\ts\tKameyama Botanical Garden\t\t\t",
"OP\ts\tSilesian Museum\t\t\t",
"OPANM\ts\tOtdel Paleontologii i Biostratigrafii Akademii Nauk Moldovkoi Republiki\t\t\t",
"OPM\ts\tOkinawa Prefectual Museum\t\t\t",
"ORE\ts\tUniversity of Oregon, Biology Department\t\t\t",
"OREB\ts\tKarolinska Hoegre Allmaenna Laeroverket\t\t\t",
"ORI\ts\tOcean Research Institute\t\t\t",
"ORIS\ts\tInstitute of Steppe of the Ural branch of Russian Academy of Sciences\t\t\t",
"ORIT\ts\tUniversity of Tokyo\t\t\t",
"ORM\ts\tMusee des Sciences Naturelles, Departement de Botanique\t\t\t",
"ORS\tc\tCulture Collection of the Laboratory of Soil Microbiology, ORSTOM\t\t\t",
"ORSAY\tsb\tUniversite Paris-Sud - Parc Botanique de Launay\t\t\t",
"ORSC\ts\tOffice de la Recherche Scientifique et Technique d'Outre-Mer\t\t\t",
"ORST\ts\tOffice de la Recherche Scientifique et Technique d'Outre-Mer\t\t\t",
"ORSTOM\ts\tOffice de la Recherche scientifique et Technique Outre-mer\t\t\t",
"ORT\ts\tInstituto Canario de Investigaciones Agrarias (ICIA)\t\t\t",
"ORTN\ts\tOrton Hall\t\t\t",
"ORU\ts\tOral Roberts University, Biology Department\t\t\t",
"OS<USA-OH>\ts\tOhio State University\t\t\t",
"OS<USA-OR>\ts\tOregon State University\tOSUC,SU\t\t",
"OS<USA-OR>:Fishes\ts\tOregon State University, Icthyology collection\t\t",
"OS<USA-OR>:Herps\ts\tOregon State University, Herpetological collection\t\t",
"OSA\ts\tOsaka Museum of Natural History\t\t\t",
"OSAC\ts\tOregon State Arthropod Collection\t\t\t",
"OSAL\ts\tOhio State University Acarology Laboratory\t\t\t",
"OSB\ts\tSociety of Botanists\t\t\t",
"OSBU\ts\tUniversitat Osnabruck, Spezielle Botanik\t\t\t",
"OSC\ts\tOregon State University, Botany and Plant Pathology Department\t\t\t",
"OSEC\ts\tK.C Emerson Museum\t\t\t",
"OSH\ts\tUniversity of Wisconsin Oshkosh, Biology and Microbiology Department\t\t\t",
"OSI\ts\tOrdnance Survey of Ireland\t\t\t",
"OSM<CZE>\ts\tOstravske muzeum\t\t\t",
"OSMC\ts\tSt. Martin's College, Biology Department\t\t\t",
"OSN\ts\tMuseum am Schoelerberg, Natur und Umwelt\t\t\t",
"OSTR\ts\tUniversity of Ostrava\t\t\t",
"OSU<USA-OK>\ts\tOklahoma State University, Collection of Vertebrates\t\t\t",
"OSUC\ts\tOregon State University\tOS,SU\t\t",
"OSUF\ts\tOregon State University, Department of Wood Science and Engineering\t\t\t",
"OSUFW\ts\tOregon State University, Department of Fisheries and Wildlife Mammal Collection\t\t\t",
"OSUMZ\ts\tOhio State University Museum\tOSU,OSUMZ\t\t",
"OSUMZ:Amphibian\ts\tOhio State University Museum, Amphibian collection\t\t",
"OSUMZ:Bird\ts\tOhio State University Museum, Bird Collection\t\t",
"OSUMZ:Fish\ts\tOhio State University Museum, Fish collection\t\t",
"OSUMZ:Mammal\tc\tOhio State University Museum, Mammal collection\t\t",
"OSUMZ:Reptile\ts\tOhio State University Museum, Reptile Collection\t\t",
"OSUO\ts\tOregon State University, School of Oceanography\t\t\t",
"OSUS\ts\tOklahoma State University\t\t\t",
"OSW\ts\tState University of New York at Oswego\t\t\t",
"OSWY\ts\tOswestry Museum\t\t\t",
"OTA\ts\tUniversity of Otago, Botany Department\t\t\t",
"OTF\ts\tCanadian Forest Service\t\t\t",
"OTM<NZL>\ts\tOtago Museum\t\t\t",
"OTM<USA-MT>\ts\tOld Trail Museum\t\t\t",
"OTSC\ts\tOrganization for Tropical Studies\t\t\t",
"OTT\ts\tUniversity of Ottawa, Biology Department\t\t\t",
"OU\ts\tFossil Catalgoue in the Geology Museum\t\t\t",
"OUA\ts\tUniversite de Ouagadougou\t\t\t",
"OUFE\ts\tEskisehir Osmangazi University Faculty of Education and Science\t\t\t",
"OULU\ts\tUniversity of Oulu, Biology Department\t\t\t",
"OUM\ts\tOxford University Museum of Natural History\tOUMNH\t\t",
"OUPR\ts\tUniversidade Federal de Ouro Preto, Campus Universitario\t\t\t",
"OUSM\ts\tOklahoma University Stovall Museum\t\t\t",
"OUT\tc\tDepartment of Biotechnology, Osaka University\t\t\t",
"OUVC\ts\tOhio University Vertebrate Collection\t\t\t",
"OVMB\ts\tOkresni vlastivedne muzeum\t\t\t",
"OWU\ts\tOhio Wesleyan University, Botany-Microbiology Department\t\t\t",
"OXD\ts\tWadham College\t\t\t",
"OXF\ts\tUniversity of Oxford (Fielding-Druce Herbarium)\t\t\t",
"OXM\ts\tMagdalen College Library\t\t\t",
"P\ts\tHerbier National de Paris\tP<FRA>\t\t",
"PA\ts\tUniversidade Federal do Oeste do Para\t\t\t",
"PAC\ts\tPennsylvania State University, Biology Department\t\t\t",
"PACA\ts\tInstituto Anchietano de Pesquisas/UNISINOS\t\t\t",
"PACC\tc\tPlovdiv Algal Culture Collection\t\t\t",
"PACMA\ts\tPennsylvania State University, Biology Department\t\t\t",
"PAD\ts\tUniversita degli Studi di Padova, Centro Interdipartimentale Musei Scientifici\t\t\t",
"PADA\ts\tPennsylvania Department of Agriculture\t\t\t",
"PAE\ts\tStiftung Herbarium Paul Aellen, Universitat Basel\t\t\t",
"PAL\ts\tUniversita degli Studi di Palermo, Dipartimento de Scienze Botaniche\t\t\t",
"PALEON\ts\tWyoming Dinosaur International Society\t\t\t",
"PAM\ts\tPennsylvania Department of Agriculture\t\t\t",
"PAMC\tc\tPolar and Alpine Microbial Collection\t\t\t",
"PAMG\ts\tEmpresa de Pesquisa Agropecuaria de Minas Gerais (EPAMIG), Departamento de Pesquisa\t\t\t",
"PAMP\ts\tUniversidad de Navarra, Departamento de Botanica\t\t\t",
"PAMUH\ts\tPamukkale University\t\t\t",
"PAN\ts\tPanjab University, Botany Department\t\t\t",
"PAP\ts\tMusee de Tahiti et des Iles\t\t\t",
"PAR\ts\tMuseo de Ciencias Naturales y Antropologicas Prof. Antonio Serrano, Departamento de Botanica\t\t\t",
"PARMA\ts\tUniversita degli Studi di Parma\t\t\t",
"PAS\ts\tJava Sugar Experimental Station\t\t\t",
"PASA\ts\tPasadena City College, Life Sciences Department\t\t\t",
"PASG\ts\tPaleontological Section of the Georgian Academy of Sciences\t\t\t",
"PASM\ts\tPalomar College, Life Sciences Department\t\t\t",
"PASSM\ts\tPeabody Academy of Science\t\t\t",
"PAT\ts\tMuseum National d'Histoire Naturelle, Laboratoire d'Ethnobiologie-Biogeographie\t\t\t",
"PAUH\ts\tUniversity of Texas-Pan American, Biology Department\t\t\t",
"PAUMC\ts\tPan American University, Mammal Collection\t\t\t",
"PAUP\ts\tPunjab Agricultural University\t\t\t",
"PAV\ts\tUniversita di Pavia, Dipartimento de Ecologia del Territorio\t\t\t",
"PAY\ts\tPaisley Philosophical Institute\t\t\t",
"PBB\ts\tResearch Center for the Conservation of Natural Resources University and Phu An Botanic Gardens\t\t\t",
"PBC<USA-HI>\tc\tPacific Bacterial Collection\t\t\t",
"PBF\tc\tPerum Bio Farma\t\t\t",
"PBH\ts\tPeterborough City Museum\t\t\t",
"PBL\ts\tBotanical Survey of India, Andaman & Nicobar Circle\t\t\t",
"PBM\ts\tMahidol University, Department of Pharmaceutical Botany\t\t\t",
"PBP\ts\tPatagonia Botanical Park\t\t\t",
"PBS\ts\tChambers Institute, Tweeddale Museum\t\t\t",
"PBZT\ts\tParc Botanique et Zoologique de Tsimbazaza\t\t\t",
"PC\ts\tMuseum National d'Histoire Naturelle\t\t\t",
"PCC\tc\tPasteur Culture Collection of Cyanobacteria\t\t\t",
"PCE\ts\tHugh Nicholson and Tony Abbott Herbarium\t\t\t",
"PCH\ts\tPrestwich and Pilkington Botanical Society\t\t\t",
"PCI\tc\tPenicillin Control and Immunology Section\t\t\t",
"PCM<IND>\ts\tPresidency College, Botany Department\t\t\t",
"PCM<POL>\tc\tPolish Collection of Microorganisms\t\t\t",
"PCMB\tb\tThe Pacific Center for Molecular Biodiversity\tBPBM:PCMB\t\t",
"PCNZ\ts\tLincoln Plant Health Station\t\t\t",
"PCU<THA>\tc\tDepartment of Microbiology, Faculty of Pharmaceutical Sciences\t\t\t",
"PD\tc\tDutch Plant Protection Service, Culture Collection of Plant Pathogenic Bacteria\t\t\t",
"PDA\ts\tRoyal Botanic Gardens, Department of Agriculture\t\t\t",
"PDBK<KOR>\tb\tPlant DNA Bank in Korea\t\t\t",
"PDD\ts\tNew Zealand Fungarium\tLCR:PDD\thttp://scd.landcareresearch.co.nz/Specimen/PDD_&spec;\t",
"PDTFAU\ts\tPaleoantropoloji Dil ve Tarih Cografya Facueltesi\t\t\t",
"PE\ts\tInstitute of Botany, Chinese Academy of Sciences\t\t\t",
"PECA\ts\tPratt Education Center and Aquarium\t\t\t",
"PECS\ts\tJanus Pannonius Museum, Natural History Department\t\t\t",
"PEFO\ts\tPetrified Forest\t\t\t",
"PEI\tcb\tPaul-Ehrlich-Institut\t\t\t",
"PEL\tsc\tUniversidade Federal de Pelotas, Departamento de Botanica\t\t\t",
"PEL:LIPP\tc\tUniversidade Federal de Pelotas, Departamento de Botanica, Laboratory Plant-Pathogen Interaction\t\t",
"PEM<CHN>\ts\tBeijing Medical University, Botany Department\t\t\t",
"PEM<ZAF>\ts\tPort Elizabeth Museum\t\t\t",
"PEMB\ts\tUniversity of North Carolina at Pembroke\t\t\t",
"PEN\ts\tPenrith Museum\t\t\t",
"PENN\ts\tUniversity of Pennsylvania Herbarium\t\t\t",
"PER\ts\tCity Museum\t\t\t",
"PERM\ts\tUniversity of Perm, Botany Department\t\t\t",
"PERTH\ts\tWestern Australian Herbarium\t\t\t",
"PERU\ts\tUniversita di Perugia, Dipartimento di Biologia Vegetale\t\t\t",
"PES\ts\tUniversity of Peshawar, Natural Drug Division\t\t\t",
"PESA\ts\tCentro Ricerche Floristiche Marche\t\t\t",
"PET\ts\tNational University of Peking Teachers' College\t\t\t",
"PEU\ts\tUniversity of Port Elizabeth, Botany Department\t\t\t",
"PEUFR\ts\tUniversidade Federal Rural de Pernambuco, Departamento de Biologia\t\t\t",
"PEY\ts\tPeking University, Biology Department\t\t\t",
"PFC\ts\tPfeiffer University, Biology Department\t\t\t",
"PFCA\ts\tPacific Forestry Centre Arthropod Reference Collection\t\t\t",
"PFES\ts\tPetawawa National Forestry Institute, Canadian Forest Service\t\t\t",
"PFI\ts\tPercy FitzPatrick Institute of African Ornithology\tPFI\t\t",
"PFRA\ts\tTree Nursery\t\t\t",
"PFRS\ts\tPacific Southwest Forest and Range Experiment Station\t\t\t",
"PFSS\ts\tPetrified Forest National Park\t\t\t",
"PG\ts\tPlant Gateway\t\t\t",
"PGC\tc\tPeterhof Genetic Collection of Microalgae\t\t\t",
"PGFA\ts\tPyatigorsk State Pharmaceutical Academy, Botany Department\t\t\t",
"PGL\ts\tPreussiche Geologische Landesanstalt\t\t\t",
"PGM\ts\tPacific Grove Museum of Natural History\t\t\t",
"PGMNH\ts\tPacific Grove Museum of Natural History\t\t\t",
"PGR\tc\tPlant Gene Resources of Canada national and international base and active collections\t\t\t",
"PGRC<CAN>\tb\tPlant Gene Resources of Canada\t\t\t",
"PGRC<CAN>:CN\tb\tPlant Gene Resources of Canada, Canadian National Plant Germplasm System\t\t",
"PGSC<USA-NC>\tc\tPseudomonas Genetic Stock Center\t\t\t",
"PH\ts\tAcademy of Natural Sciences, Botany Department\t\t\t",
"PHA\ts\tPharmaceutical Society of Great Britain\t\t\t",
"PHARB\ts\tThe Polly Hill Arboretum\t\t\t",
"PHARM\ts\tSouthern Cross University\t\t\t",
"PHBL\tc\tPhilip Harris Biological Ltd.\t\t\t",
"PHEL\ts\tPlant Health and Environment Laboratory\t\t\t",
"PHEO\ts\tKaradag Natural Reserve\t\t\t",
"PHG\ts\tPeper Harow\t\t\t",
"PHH\ts\tUniversity of Science, Ho Chi Minh City Vietnam National University\t\t\t",
"PHIL\ts\tUniversity of the Sciences in Philadelphia, Biological Sciences Department\t\t\t",
"PI<DEU>\ts\tInstitut und Museum fuer Geologie und Palaeontologie\t\t\t",
"PI<ITA>\ts\tUniversita di Pisa, Dipartimento di Scienze Botaniche\t\t\t",
"PI<RUS>\ts\tPaleontological Institute\t\t\t",
"PIAGR\ts\tUniversity of Pisa\t\t\t",
"PICRC\ts\tPalau International Coral Reef Center\t\t\t",
"PIHG\ts\tFlorida Department of Agriculture and Consumer Services\t\t\t",
"PIHU\ts\tPaleontological Institut of Helsingfors\t\t\t",
"PIKN\ts\tKoronivia Research Station\t\t\t",
"PIMUI\ts\tPalaeontologische Institut und Museum der Universitaet in Innsbruck\t\t\t",
"PIMUZ\ts\tPalaontologisches Institut und Museum der Universitat Zurich\t\t\t",
"PIN<GBR>\ts\tPhilosophical Institution of Newport\t\t\t",
"PIN<RUS>\ts\tPaleontological Institute, Russian Academy of Sciences\t\t\t",
"PINN\ts\tPinnacles National Monument\t\t\t",
"PIR\tc\tBulgarian Research Culture Collection\t\t\t",
"PISR\ts\tPechora-Ilych State Reserve, Russia\t\t\t",
"PIUU\ts\tPaleontological Institut, University of Uppsala\t\t\t",
"PKDC\ts\tDivisao de Museu de Historia Natural\t\t\t",
"PKM\ts\tV. G. Belinsk Pedagogical Institute of Penza\t\t\t",
"PL\ts\tZapadoceske muzeum\t\t\t",
"PLAT\ts\tState University of New York, College at Plattsburgh\t\t\t",
"PLES\ts\tPlyos State Museum\t\t\t",
"PLFV\ts\tPrincipality of Liechtenstein\t\t\t",
"PLH\ts\tPlymouth City Museum and Art Gallery\t\t\t",
"PLP\ts\tInstitute of Himalayan Bioresource Technology\t\t\t",
"PLU\ts\tPacific Lutheran University\t\t\t",
"PLY\tsc\tPlymouth Institution and Athenaeum\t\t\t",
"PLYMOUTH\tc\tPlymouth Culture Collection\t\t\t",
"PLYP\ts\tUniversity of Plymouth, Department of Biological Sciences\t\t\t",
"PM\ts\tPeabody Essex Museum, Natural History Department\t\t\t",
"PM<USA-AK>\ts\tPratt Museum\t\t\t",
"PM<USA-IA>\ts\tPutnam Museum of History and Natural Science\t\t\t",
"PMA<CAN>\ts\tProvincial Museum of Alberta\t\t\t",
"PMA<PAN>\ts\tUniversidad de Panama\t\t\t",
"PMAA\ts\tPalaeontological Collections, Provincial Museum and Achieves of Alberta\t\t\t",
"PMAE\ts\tRoyal Alberta Museum\t\t\t",
"PMAG\ts\tPerth Museum and Art Gallery\t\t\t",
"PMAS\ts\tPir Mehr Ali Shah Arid Agriculture University, Rawalpindi, Pakistan\t\t\t",
"PMAU\ts\tPeterborough Museum and Art Gallery\t\t\t",
"PMB\ts\tPrirodnjacki Muzej Srpske Zemije\t\t\t",
"PMBC\ts\tPhuket Marine Biological Centre\t\t\t",
"PMC\tc\tParis Museum Collection of Cyanobacteria\t\t\t",
"PMFP\ts\tPapeete Museum\t\t\t",
"PMG<BRA>\ts\tHorto Florestal\t\t\t",
"PMG<GBR>\ts\tPaisley Museum of Geological Collection\t\t\t",
"PMH\ts\tCity Museum and Records Office\t\t\t",
"PMHPS\ts\tPortsmouth Philosophical Society\t\t\t",
"PMHU\ts\tPalaontologisches Museum\t\t\t",
"PMK<RUS>\ts\tPugachev Regional Museum\t\t\t",
"PMK<SVK>\ts\tPodunajske muzeum\t\t\t",
"PMNH<PAK>\ts\tPakistan Museum of Natural History\t\t\t",
"PMNH<USA-CT>\ts\tPeabody Museum of Natural History\t\t\t",
"PMNH<USA-MA>\ts\tPratt Museum of Natural History\t\t\t",
"PMNHH\ts\tPalestine Museum of Natural History\t\t\t",
"PMQ\ts\tPublic Museum\t\t\t",
"PMR\ts\tPrirodoslovni muzej Rijeka\t\t\t",
"PMS<MKD>\ts\tPrirodonamen Muzej Skopje\t\t\t",
"PMS<USA-CA>\ts\tPacific Marine Station\t\t\t",
"PMS<USA-MA>\ts\tPeabody Essex Museum\t\t\t",
"PMSD\ts\tPettigrew Museum\t\t\t",
"PMSL\ts\tSlovenian Museum of Natural History (Prirodosloveni Muzej Slovenije)\t\t\t",
"PMSP\ts\tPrefeitura do Municipio de Sao Paulo, Departamento de Parques e Areas Verdes\t\t\t",
"PMU<RUS>\ts\tPaleontological Museum of Undory\t\t\t",
"PMU<SWE>\ts\tPaleontological Museum of Uppsala\t\t\t",
"PMV\ts\tProvincial Museum\t\t\t",
"PNBG\ts\tUniversity of the Philippines\t\t\t",
"PNC\ts\tParc National des Cevennes\t\t\t",
"PNCM-BIOTECH\tc\tPhilippine National Collection of Microorganisms\t\t\t",
"PND\ts\tDr. Shivaram Karantha  Pilikula Nisarga Dhama\t\t\t",
"PNG\ts\tDivision of Primary Industry\t\t\t",
"PNGM\ts\tNational Museum and Art Gallery, Port Moresby\t\t\t",
"PNH\ts\tPhilippine National Herbarium\t\t\t",
"PNICMM-INP\ts\tInstituto Nacional de la Pesca (Mexico)\t\t\t",
"PNL\ts\tPolytechnic of North London, Food and Biological Sciences Department\t\t\t",
"PNM\ts\tPhilippine National Museum\t\t\t",
"PNPC\ts\tChickasaw National Recreational Area [formerly Platt National Park]\t\t\t",
"PNZ\ts\tPenlee House Museum\t\t\t",
"PO<PRT>\ts\tUniversidade do Porto, Departamento de Botanica\t\t\t",
"PO<RUS>\ts\tCollection of the Zoological Institute of the Russian Academy of Sciences\t\t\t",
"POFS\ts\tForest Service, USDA\t\t\t",
"POKM<RUS-PENZA>\ts\tPenza Regional Local History Museum\t\t\t",
"POKM<RUS-PERM>\ts\tPerm Regional Lore Museum\t\t\t",
"POL-F\ts\tPollichia, Pfalzmuseum fur Naturkunde Thallichtenberg\t\t\t",
"POLL\ts\tPfalzmuseum fuer Naturkunde\t\t\t",
"POM\ts\tPomona College\t\t\t",
"POP\ts\tTatranske muzeum v Poprade\t\t\t",
"POR\ts\tUniversita degli Studi di Napoli\t\t\t",
"PORE\ts\tPoint Reyes National Seashore\t\t\t",
"PORT\ts\tBioCentro-UNELLEZ\t\t\t",
"PORUN\ts\tUniversita degli Studi di Napoli, Dip Ar Bo Pa Ve - Sezione Botanica\t\t\t",
"POZ\ts\tAdam Mickiewicz University, Department of Plant Taxonomy\tPOZW\t\t",
"POZG\ts\tAdam Mickiewicz University, The Natural History Collections Faculty\t\t\t",
"POZM\ts\tAdam Mickiewicz University, Department of Plant Ecology and Environment Protection\t\t\t",
"POZNB\ts\tAgricultural Academy, Botany Department\t\t\t",
"POZW\ts\tAdam Mickiewicz University\tPOZ\t\t",
"PPC\ts\tPalawan State University\t\t\t",
"PPCC<AUS>\tc\tPlant Pathology Culture Collection\t\t\t",
"PPCC<NZL>\ts\tPlant Protection Centre Collection\t\t\t",
"PPCD\ts\tWest Virginia Department of Agriculture\t\t\t",
"PPDD\ts\tMinistry of Agriculture\t\t\t",
"PPFI\ts\tPakistan Forest Institute\t\t\t",
"PPHM\ts\tPanhandle-Plains Historical Museum\t\t\t",
"PPI\ts\tNational Pingtung University of Science and Technology, Department of Forestry\t\t\t",
"PPIHAS\tc\tPlant Protection Institute, Centre for Agricultural Research, Hungarian Academy of Sciences\tPPIHAS\t\t",
"PPIU\ts\tM. Utemisov Western Kazakhstanian State University, V. V. Ivanov Department of Botany\t\t\t",
"PPKMI\tc\tPlant Production Technology Department, Faculty of Agricultural Technology\t\t\t",
"PPKU1\tc\tDepartment of Plant Pathology, Faculty of Agriculture, Thailand\t\t\t",
"PPL\ts\tAgricultural Development and Advisory Service, Harpenden Laboratory\t\t\t",
"PPNP\ts\tPoint Pelee National Park\t\t\t",
"PPPO\ts\tPusat Penelitian dan Pengembangan Oseanologi\t\t\t",
"PPPPB\tc\tARC-Plant Protection Research Institute, Plant Pathogenic and Plant Protecting Bacteria\t\t\t",
"PPRI\tc\tARC-Plant Protection Research, National Collection of Fungi: Culture Collection\t\t\t",
"PPRL\ts\tUSDA-ARS Poisonous Plant Research Lab\t\t\t",
"PPRZ\ts\tPlant Protection Research Institute\t\t\t",
"PPSIO\ts\tP. P. Shirshov Institute of Oceanology\t\t\t",
"PPU\ts\tPerm State Teacher Training University\t\t\t",
"PQFC\tb\tPhu Qui's Fruit Tree Center-Vietnam\t\t\t",
"PR\ts\tNational Museum in Prague, Department of Botany\t\t\t",
"PRA\ts\tInstitute of Botany, Academy of Sciences\t\t\t",
"PRB\ts\tPrague Botanical Garden\t\t\t",
"PRC\ts\tCharles University, Botany Department\t\t\t",
"PRE\ts\tNational Botanical Institute - Pretoria\t\t\t",
"PREM\ts\tSouth African National Collection of Fungi Herbarium\t\t\t",
"PRF\ts\tSouth African Forestry Research Institute, Environment Affairs Department\t\t\t",
"PRG\ts\tUniversidad Nacional Pedro Ruiz Gallo\t\t\t",
"PRH\ts\tPerthshire Society of Natural Science\t\t\t",
"PRI\ts\tCollege of Eastern Utah, Biology Department\t\t\t",
"PRL\tc\tPrairie Regional Laboratory\t\t\t",
"PRM\ts\tNational Museum, Mycological Department\t\t\t",
"PROIMI\tc\tPlanta Piloto de Procesos Industriales Microbiologicos\t\t\t",
"PRR\ts\tPatuxent Research Refuge\t\t\t",
"PRU\ts\tUniversity of Pretoria, Botany Department\t\t\t",
"PRV\ts\tPorvoo Museum of Natural History\t\t\t",
"PSAE\ts\tAlberta Environmental Centre\t\t\t",
"PSGB\ts\tUniversity of Bradford, Pharmacy Department\t\t\t",
"PSH\ts\tPlymouth State University\t\t\t",
"PSK\ts\tPskov State University\t\t\t",
"PSM\ts\tJames R. Slater Museum of Natural History\t\t\t",
"PSO\ts\tUniversidad de Narino\t\t\t",
"PSP\ts\tParasitic Seed Plants\t\t\t",
"PSS<GBR>\ts\tPhilosophical Society of Southampton\t\t\t",
"PSS<MNG>\ts\tPaleontology and Stratigraphic Section of the Geological Institute of the Mongolian Academy of Sciences\t\t\t",
"PSU<THA>\ts\tPrince of Songkla University, Biology Department\t\t\t",
"PSU<USA-OR>\ts\tPortland State University, Vertebrate Biology Museum\t\t\t",
"PSU<USA-OR>:Mamm\ts\tPortland State University, Vertebrate Biology Museum, Mammal Collection\t\t",
"PSU<USA-PA>\ts\tPennsylvania State University\t\t\t",
"PSUB\ts\tUniversity of Botswana\t\t\t",
"PSUC\ts\tFrost Entomological Museum\t\t\t",
"PSUMC\ts\tPittsburg State University\t\t\t",
"PSY\ts\tPaisley Museum\t\t\t",
"PTBG\ts\tNational Tropical Botanical Garden\t\t\t",
"PTCC\tc\tPakistan Type Culture Collections\t\t\t",
"PTCCI\tc\tPersian Type Culture Collection\t\t\t",
"PTH\ts\tPerth Museum and Art Gallery, Herbarium\tPER\t\t",
"PTHL\ts\tLiterary and Antiquarian Society of Perth\t\t\t",
"PTIS\ts\tPotato Introduction Station\t\t\t",
"PTN\ts\tEllesmere Chambers\t\t\t",
"PTTC\tc\tPranakorn Teacher Training College, Department of Biology, Faculty of Science and Technology\t\t\t",
"PTZ\ts\tKarelian Scientific Centre, Russian Academy of Sciences\t\t\t",
"PU\ts\tPrinceton University\t\t\t",
"PU-HI\ts\tDepartment of Palaeontology, Universidad Complutense of Madrid\t\t\t",
"PUA\ts\tPacific Union College, Biology Department\t\t\t",
"PUC<CHN>\ts\tBeijing University\t\t\t",
"PUC<ZAF>\ts\tNorth-West University\t\t\t",
"PUCMF\ts\tPachhunga University College Museum of Fish\t\t\t",
"PUCMNH\ts\tPacific Union College, Museum of Natural History\t\t\t",
"PUCP\ts\tPunjab University\t\t\t",
"PUH\ts\tUniversity of the Philippines, Institute of Biology\t\t\t",
"PUL\ts\tKriebel Hebarium Purdue University\t\t\t",
"PUM\ts\tUniversita DI Pisa\t\t\t",
"PUN\ts\tPunjabi University, Botany Department\t\t\t",
"PUO\ts\tPortland University\t\t\t",
"PUP\ts\tUniversity of Peshawar, Botany Department\t\t\t",
"PUR\ts\tArthur Herbarium Purdue University\t\t\t",
"PURC\ts\tPurdue University\t\t\t",
"PUS\ts\tPuslinch House\t\t\t",
"PUSC\ts\tUniversity of Southern Colorado, Life Sciences Department\t\t\t",
"PUY\ts\tMusee Crozatier\t\t\t",
"PVB\ts\tInstitute of Ecology of the Volga River Basin, Russian Academy of Science\t\t\t",
"PVF\tc\tPusat Veterinaria Farma\t\t\t",
"PVGB\tc\tPlant Virus GenBank\t\t\t",
"PVHR\ts\tUniversite Paris VI\t\t\t",
"PVL\ts\tPaleontologia de Vertebrados Lillo\t\t\t",
"PVNH\ts\tORSTOM\t\t\t",
"PVPH\ts\tPaleontolga de Vertebrados\t\t\t",
"PVSJ\ts\tMuseo do Ciencias Naturles\t\t\t",
"PW\ts\tPaleontological Collections\t\t\t",
"PWRC\ts\tPatuxent Wildlife Research Center\t\t\t",
"PWU\ts\tV.G.Korolenko Poltava National Pedagogical University\t\t\t",
"PY\ts\tCentro de Estudios y Colecciones Biologicas para la Conservacion\t\t\t",
"PYCC\tc\tPortuguese Yeast Culture Collection\t\thttp://pycc.bio-aware.com/BioloMICS.aspx?Table=PYCC%20strains&Name=PYCC%20\t",
"PYU\ts\tYunnan University, Laboratory of Pteridophyta\t\t\t",
"PZL\ts\tPenzance Library\t\t\t",
"PZV\ts\tPetrozavodsk State University, Department of Botany and Plant Physiology\t\t\t",
"Q\ts\tUniversidad Central\t\t\t",
"QAME\ts\tDireccion Nacional Forestal, Ministerio de Agricultura y Ganaderia\t\t\t",
"QAP\ts\tUniversidad Central\t\t\t",
"QBG\ts\tQueen Sirikit Botanic Garden\t\t\t",
"QC\ts\tNational Museum of Natural History, Bulawayo\t\t\t",
"QCA\ts\tPontificia Universidad Catolica del Ecuador, Departamento de Biologia\t\t\t",
"QCAM\ts\tPontificia Universidad Catolica del Ecuador\t\t\t",
"QCAZ\ts\tMuseo de Zoologia, Pontifica Universidad Catolica del Ecuador\t\t\t",
"QCAZ:A\ts\tMuseo de Zoologia, Pontifica Universidad Catolica del Ecuador, Amphibian Collection\t\t",
"QCAZ:R\ts\tMuseo de Zoologia, Pontifica Universidad Catolica del Ecuador, Reptile Collection\t\t",
"QCC\tc\t Qatari Culture Collection\t\t\t",
"QCNE\ts\tHerbario Nacional del Ecuador\t\t\t",
"QD\ts\tOcean University of China\t\t\t",
"QDC\ts\tQinghai Institute for Drug Control\t\t\t",
"QDPC\ts\tQueensland Department of Primary Industries\t\t\t",
"QDPI\ts\tQueensland Department of Primary Industries\t\t\t",
"QEF\ts\tUniversite Laval, Laboratoire d'ecologie forestiere\t\t\t",
"QF\ts\tInstitute of Forestry\t\t\t",
"QFA\ts\tUniversite Laval\t\t\t",
"QFB\ts\tLaurentian Forestry Centre, Canadian Forest Service\tQFBE\t\t",
"QFMQ\ts\tQueenstown Museum\t\t\t",
"QFNU\ts\tQufu Normal University\t\t\t",
"QFS\ts\tUniversite Laval\t\t\t",
"QG\ts\tGeneral Grassland Station of Qinghai\t\t\t",
"QIBX\ts\tQinghai Institute of Biology\t\t\t",
"QIMR\ts\tQueensland Institute of Medical Research\t\t\t",
"QK\ts\tFowler Herbarium Queen's University\t\t\t",
"QM\ts\tQueensland Museum\tQMB\t\t",
"QM<USA-MA>\ts\tU.S. Army Natick Research and Development Center\t\t\t",
"QMB\ts\tQueensland Museum, Brisbane\tQM\t\t",
"QMC\ts\tQueen Mary College\t\t\t",
"QMEX\ts\tUniversidad Autonoma de Queretaro, Centro Universitario\t\t\t",
"QMOR\ts\tCollection Entomologique Ouellet-Robert\t\t\t",
"QMP\ts\tMusee du Quebec\t\t\t",
"QNUN\ts\tQiannan Normal University for Nationalities\t\t\t",
"QPAR\ts\tMinistere du Tourisme de la Chasse et de la Peche du Quebec, Laboratoire de Recherches\t\t\t",
"QPH\ts\tSeminaire de Quebec\t\t\t",
"QPIM\ts\tDepartment of Primary Industries\tDPIQM\t\t",
"QPLS\ts\tBiblioteca Ecuatoriana Aurelio Espinosa Polit\t\t\t",
"QPNRA\ts\tPrograma Nacional de Regionalizacion, Ministerio de Agricultura y Ganaderia, Departamento de Ecologia\t\t\t",
"QRS\ts\tAustralian National Herbarium, Division of Plant Industry, CSIRO\t\t\t",
"QSA\ts\tInstitut de technologie agroalimentaire\t\t\t",
"QSMI\ts\tQueen Saovabha Memorial Institute\t\t\t",
"QTC\ts\tQiqihar Teachers College, Biology Department\t\t\t",
"QUA\ts\tQinghai University, Agriculture Department\t\t\t",
"QUC\ts\tUniversite Laval, Departement de biologie\t\t\t",
"QUE\ts\tComplexe scientifique\t\t\t",
"QUETTA\ts\tBotanical Garden of the University of Balochistan\t\t\t",
"QUSF\ts\tUniversidad San Francisco de Quito, Biology Department\t\t\t",
"QVG\ts\tQueen Victoria Museum\t\t\t",
"QVM\ts\tQueen Victoria Museum\t\t\t",
"QVMS\ts\tQueen Victoria Memorial Museum\t\t\t",
"QWA\ts\tUniversity of the North, Qwa Qwa Campus\t\t\t",
"QYTC\ts\tQingyang Teachers College, Biology Department\t\t\t",
"R<BRA>\ts\tUniversidade Federal do Rio de Janeiro, Departamento de Botanica\t\t\t",
"R<CHL>\ts\tDepartamento de Geologia, Universidad de Chile\t\t\t",
"RAB\ts\tInstitut Scientifique, Departement de Botanique et d'Ecologie Vegetale\t\t\t",
"RAF\ts\tMyanmar Forest Herbarium\t\t\t",
"RAM\ts\tRamsey Public Library\t\t\t",
"RAM<CAN>\ts\tRoyal Alberta Museum\t\t\t",
"RAME\ts\tRoyal Albert Memorial Museum\t\t\t",
"RAMK\ts\tRamkhamhaeng University, Biology Department\t\t\t",
"RAMM\ts\tRoyal Albert Memorial Museum, Leisure and Tourism Department\t\t\t",
"RANG\ts\tYangon University\t\t\t",
"RANK\ts\tResearch Center of Agriculture and Natural Resources of Kermanshah province\t\t\t",
"RARS\ts\tRegina Research Station\t\t\t",
"RAS\ts\tUnion of Burma Applied Research Institute, Pharmaceutical Department\t\t\t",
"RAU\ts\tLaboratoire de Biologie Vegetale\t\t\t",
"RAW\ts\tPakistan Agricultural Research Council\t\t\t",
"RB\ts\tJardim Botanico do Rio de Janeiro\t\t\t",
"RBCM\ts\tRoyal British Columbia Museum\tV\t\t",
"RBCM:Mamm\ts\tRoyal British Columbia Museum, Mammal Collection\t\t",
"RBCM:Ornith\ts\tRoyal British Columbia Museum, Ornithology Collection\t\t",
"RBE\ts\tUniversidade Federal Rural do Rio de Janeiro\t\t\t",
"RBF\tc\tRaiffeisen Bioforschung\t\t\t",
"RBINS\ts\tRoyal Belgian Institute of Natural Sciences\t\t\t",
"RBR\ts\tUniversidade Federal Rural do Rio de Janeiro, Departamento de Botanica\t\t\t",
"RBS\ts\tRoyal Botanic Society\t\t\t",
"RBY\ts\tEast Divisional Library\t\t\t",
"RC CCM\tc\tResource Centre Culture Collection of Microorganisms (St. Petersburg State University)\t\t\t",
"RCAM\tc\tRussian Collection of Agricultural Microorganisms\t\t\t",
"RCAT\tc\tRegional Collection of Animal Viruses and Tissue Cultures\t\t\t",
"RCB\tc\tRIKEN Cell Bank\t\t\t",
"RCC\tc\tRoscoff Culture Collection\t\t\t",
"RCDM\tc\tRepublican Centre for Deposition of Microorganisms of the National Academy of Sciences and Ministry of Education and Science of Armenia\t\t\t",
"RCHM\ts\tRochdale Museum Service\t\t\t",
"RCHP\ts\tRochdale Equitable Pioneers' Memorial Museum\t\t\t",
"RCMC\ts\tRockford College\t\t\t",
"RCN\ts\tRichmond Naturalists' Field Club\t\t\t",
"RCPF\tsc\tRussian Collection of Pathogenetic Fungi\t\t\t",
"RCPL\ts\tRoyal College of Physicians of London\t\t\t",
"RCR\ts\tRochester Public Museum\t\t\t",
"RCS\ts\tRoyal College of Surgeon's Museum\tRCSM\t\t",
"RCSL\ts\tRoyal College of Surgeons\t\t\t",
"RCVC\ts\tMaria Esther Bocco Herbarium Universidad Nacional de Rio Cuarto\t\t\t",
"RDAF\ts\tResearch Department South East Asian Fisheries Development Centre\t\t\t",
"RDG\ts\tReading Museum and Archive Service\t\t\t",
"RDS\ts\tRoyal Dublin Society\t\t\t",
"RE\ts\tLiaoning Reed Science Institute\t\t\t",
"RED\ts\tUniversity of Redlands, Biology Department\t\t\t",
"REDM\ts\tReading Museum and Archive Service\t\t\t",
"REED\ts\tReed College\t\t\t",
"REG\ts\tUniversitaet Regensburg, Regensburgische Botanische Gesellschaft\t\t\t",
"REGGIO\ts\tUniversita Mediterranea di Reggio Calabria\t\t\t",
"REH\ts\tReinhardt University\t\t\t",
"RELC\ts\tINIFAP-SAGAR\t\t\t",
"REN\ts\tCampus Scientifique de Beaulieu, Laboratoire de Botanique\t\t\t",
"RENO\ts\tUniversity of Nevada, Environmental and Resource Sciences Department\t\t\t",
"RENZ\ts\tUniversitaet Basel, The Swiss Orchid Foundation\t\t\t",
"REP\ts\tDesert Experiment Station of the W.I.R.\t\t\t",
"RESC\ts\tShasta College\t\t\t",
"RET\ts\tHerbarium Amanitarum Rooseveltensis\t\t\t",
"REU\ts\tUniversite de la Reunion\t\t\t",
"RFA\ts\tUniversidade Federal do Rio de Janeiro, Departamento de Botanica\t\t\t",
"RFE\ts\tRadcliffe Literary and Scientific Society Museum\t\t\t",
"RFFP\ts\tUniversidade do Estado do Rio de Janeiro\t\t\t",
"RFNS\ts\tRochdale Field Naturalists' Society\t\t\t",
"RGM\ts\tNationaal Natuurhistorisch Museum Leiden\t\t\t",
"RGPG\ts\tRaghunath Girls' Post-Graduate College\t\t\t",
"RGY\ts\tRugby School Natural History Society Museum\t\t\t",
"RH-EF\ts\tMuseum of Grannat\t\t\t",
"RHK\ts\tSt. Berchmans College\t\t\t",
"RHLCY\ts\tReservoir of Heilongtan\t\t\t",
"RHM\ts\tPublic Reference Library\t\t\t",
"RHMC\ts\tRed House Museum\t\t\t",
"RHMD\ts\tNational Institute of Science Communication\t\t\t",
"RHMU\tc\tDepartment of Pathology, Faculty of Medical Science, Ramathibordi Hospital\t\t\t",
"RHS\tc\tPlant Pathology, The Royal Horticultural Society\t\t\t",
"RHT\ts\tSt. Joseph's College\t\t\t",
"RI\ts\tRudjer Boskovic Institute (Herbarium Flora Adriatica)\t\t\t",
"RIA\tc\tThe Russia Research Institute for Antibiotics Culture Collection\t\t\t",
"RIB\tc\tNational Research Institute of Brewing, Tax Administration Agency\t\t\t",
"RIBM\tc\tResearch Institute for Brewing and Malting\t\t\t",
"RICK\ts\tBrigham Young University - Idaho\t\t\t",
"RICP<CZE>\tc\tCrop Research Institute\t\t\t",
"RIFAV\tb\tResearch Institute for Fruits and Vegetables\t\t\t",
"RIFFL\ts\tResearch Institute of Freshwater Fisheries\t\t\t",
"RIFY\tc\tInstitute of Enology and Viticulture, Yamanashi University\t\t\t",
"RIG\ts\tUniversity of Latvia, Department of Botany and Ecology\t\t\t",
"RIGB\ts\tLatvian State Center of Plant Protection\t\t\t",
"RIGG\ts\tUniversity of Latvia\t\t\t",
"RIM\ts\tL'Ecole d'Agriculture\t\t\t",
"RIMD\tc\tResearch Institute for Microbial Diseases, Research Center for Emerging Infectious Diseases\t\t\t",
"RIN\ts\tResearch Institute for Nature Management, Botany Department\t\t\t",
"RIOC\ts\tUniversidad Nacional de Rio Cuarto\t\t\t",
"RIPO\tc\tPlant Virus Collection\t\t\t",
"RITFC\tc\tResearch Institute for Tobacco and Fibre Crops\t\t\t",
"RIVE<SVK>\tc\tResearch Institute for Viticulture and Enology\t\t\t",
"RIVE<USA-WI>\ts\tUniversity of Wisconsin, Biology Department\t\t\t",
"RIY\ts\tNational Agriculture and Water Research Center\t\t\t",
"RIZ\ts\tInstituto de Zootecnia\t\t\t",
"RKT\ts\tRegional Research Institute (Ayurveda)\t\t\t",
"RLS\ts\tRoyal Latin School\t\t\t",
"RM<CAN>\ts\tMcGill University, Redpath Museum\t\t\t",
"RM<NZL>\tc\tRumen Microorganisms\t\t\t",
"RM<SGP>\ts\tRaffles Museum\t\t\t",
"RM<USA-WY>\ts\tUniversity of Wyoming Herbarium\t\t\t",
"RMA<USA-CA>\tc\tR. M. Alden Research Lab\t\t\t",
"RMBL\ts\tRocky Mountain Biological Laboratory\t\t\t",
"RMBR\ts\tRaffles Museum of Biodiversity Research\t\t\t",
"RMCA\ts\tRoyal Museum for Central Africa\t\t\t",
"RMDRC\ts\tRocky Mountain Dinosaur Resource Center\t\t\t",
"RMF\tc\tRocky Mountain Herbarium, Fungi\t\t\t",
"RMFM\ts\tRichmond Marine Fossils Museum\t\t\t",
"RMNH\ts\tNaturalis Biodiversity Center\tRMNHD\thttp://science.naturalis.nl/collections/collections-in-naturalis\t",
"RMNH:ACA\ts\tNaturalis Biodiversity Center, Acari collection\t\t",
"RMNH:AVES\ts\tNaturalis Biodiversity Center, bird collection\t\t",
"RMNH:BRA\ts\tNaturalis Biodiversity Center, brachiopod collection\t\t",
"RMNH:BRY\ts\tNaturalis Biodiversity Center, bryozoan collection\t\t",
"RMNH:COEL\ts\tNaturalis Biodiversity Center, Coelomate collection\t\t",
"RMNH:CRUS\ts\tNaturalis Biodiversity Center, crustacean collection\t\t",
"RMNH:CRUS.D\ts\tNaturalis Biodiversity Center, decapod collection\t\t",
"RMNH:INS\ts\tNaturalis Biodiversity Center, Insect collection\t\t",
"RMNH:MAM\ts\tNaturalis Biodiversity Center, Mammal collection\t\t",
"RMNH:MOL\ts\tNaturalis Biodiversity Center, mollusc collection\thttp://data.biodiversitydata.nl/naturalis/specimen/RMNH.MOL.",
"RMNH:PISC\ts\tNaturalis Biodiversity Center, fish collection\t\t",
"RMNH:POR\ts\tNaturalis Biodiversity Center, poriferan collection\t\t",
"RMNHD\ts\tNaturalis Biodiversity Center\tRMNH\t\t",
"RMNP\ts\tRiding Mountain National Park\t\t\t",
"RMRC\tb\tRegional Medical Research Centre\t\t\t",
"RMRIMS\tb\tRajendra Memorial Research Institute of Medical Science\t\t\t",
"RMS\ts\tUniversity of Wyoming\t\t\t",
"RMSC\ts\tRocky Mountain Forest and Range Experiment Station\t\t\t",
"RMSCC\tc\tRoche Molecular Systems Culture Collection\t\t\t",
"RMTV\ts\tUniversity of Rome Tor Vergata\t\t\t",
"RMWC\ts\tRandolph-Macon Woman's College, Biology Department\t\t\t",
"RNG\ts\tUniversity of Reading\t\t\t",
"RNMUT\ts\tRepublic Nature Museum of Uzbekistan\t\t\t",
"RO\ts\tUniversita degli Studi di Roma La Sapienza, Dipartimento di Biologia Vegetale\t\t\t",
"ROAN\ts\tVirginia Western Community College, Biology Department\t\t\t",
"ROCH\ts\tRochester Academy of Science\t\t\t",
"ROHB\ts\tCattedra di Micologia, Dipartimento di Biologia Vegetale\t\t\t",
"ROIG\ts\tEstacion Experimental de Plantas Medicinales Dr. Juan T. Roig\t\t\t",
"ROM\ts\tRoyal Ontario Museum\t\t\t",
"ROM:ENT\ts\tRoyal Ontario Museum, Entomology collection\t\t",
"ROM:HERP\ts\tRoyal Ontario Museum, Herpetology collection\t\t",
"ROM:ICH\ts\tRoyal Ontario Museum, Fish collection\t\t",
"ROM:IZ\ts\tRoyal Ontario Museum, Invertebrate Zoology Collection\t\t",
"ROM:MAM\ts\tRoyal Ontario Museum, Mammal Collection\t\t",
"ROM:ORN\ts\tRoyal Ontario Museum, Ornithology Collection\t\t",
"ROME\ts\tRoyal Ontario Museum, Entomology Collection\tROM:ENT\t\t",
"ROML\ts\tNational University of Lesotho, Biology Department\t\t\t",
"ROMO\ts\tRocky Mountain National Park\t\t\t",
"RON\ts\tUniversidade Federal de Rondonia\t\t\t",
"ROO\ts\tAgricultural Research Council-Range and Forage Institute\t\t\t",
"ROPA\ts\tSonoma State University, Biology Department\t\t\t",
"ROPV\ts\tIstituto Sperimentale per la Patologia Vegetale\t\t\t",
"ROST\ts\tUniversitaet Rostock\t\t\t",
"ROV\ts\tMuseo Civico di Rovereto\t\t\t",
"ROZ\ts\tStredoceske muzeum\t\t\t",
"RPM\ts\tReading Public Museum\t\t\t",
"RPMH\ts\tRoemer Pelizaeus Museum Hildesheim\t\t\t",
"RPN\ts\tRipon Mechanics Institute\t\t\t",
"RPPMC\ts\tRondeau Provincial Park\t\t\t",
"RPPR\ts\tInternationl Institute of Tropical Forestry\t\t\t",
"RPSC\ts\tRio Palenque Science Center\t\t\t",
"RPSP\ts\tUniversidade de Sao Paulo\t\t\t",
"RPTN\ts\tRepton School, Biology Department\t\t\t",
"RRCBI\ts\tRegional Research Centre (Ay.)\t\t\t",
"RRIASR\tc\tFungal Pathogens of Hevea Rubber in Sri Lanka\t\t\t",
"RRJ\tc\tRRL , Jammu INDIA\t\t\t",
"RRLB\ts\tRegional Research Laboratory (Institute of Minerals and Materials Technology)\t\t\t",
"RRLH\ts\tRegional Research Laboratory (Indian Institute of Integrative Medicine)\t\t\t",
"RSA\ts\tRancho Santa Ana Botanic Garden\t\t\t",
"RSCS\tc\tMedical Culture Collection\t\t\t",
"RSDR\ts\tDesert Institute, Turkmenistan Academy of Sciences\t\t\t",
"RSKK\tc\tRefik Saydam National Type Culture Collection-RSKK\t\t\t",
"RSM<CAN>\ts\tRoyal Saskatchewan Museum\tSMNH<CAN>\t\t",
"RSM<GBR>\ts\tRoyal Scottish Museum\tNMSZ,RSME\t\t",
"RSU\ts\tRyazan State University\t\t\t",
"RSY\ts\tButeshire Natural History Society, The Museum\t\t\t",
"RTCI\tc\tResearch Laboratory, Takeda Chemical Industry\t\t\t",
"RTE\ts\tHolmesdale Natural History Club Museum\t\t\t",
"RTHM\ts\tMunidipal Museum and Art Gallery\t\t\t",
"RTM\ts\tRishiri Town Museum\t\t\t",
"RTMP\ts\tRoyal Tyrell Museum of Paleontology\t\t\t",
"RU\ts\tUniversity of Reading, Agricultural Botany Department\t\t\t",
"RUBL\ts\tUniversity of Rajasthan, Botany Department\t\t\t",
"RUDZ\ts\tRhodes University\t\t\t",
"RUEB\ts\tEidgenossische Technische Hochschule ETH\t\t\t",
"RUH\ts\tRhodes University, Botany Department\t\t\t",
"RUHK\ts\tRazi University Herbarium\t\t\t",
"RUHV\ts\tRadford University, Biology Department\t\t\t",
"RUIC\ts\tRutgers University\t\t\t",
"RUMF\ts\tUniversity Museum, University of the Ryukyus\t\t\t",
"RUNYON\ts\tRobert Runyon Herbarium\t\t\t",
"RUPP\ts\tRoyal University of Phnom Penh\t\t\t",
"RUSI\ts\tJ.L.B. Smith Institute of Ichthyology (formerly of Rhodes University)\t\t\t",
"RUSU\ts\tUniversidade Santa Ursula\t\t\t",
"RUT\ts\tDouglass College, Rutgers University, Biological Sciences Department\t\t\t",
"RUTPP\ts\tCook College, Rutgers University, Plant Pathology Department\t\t\t",
"RUY\ts\tMid-Staffordshire Field Club\t\t\t",
"RV<ITA>\tc\tCollection of Leptospira Strains\t\t\t",
"RV<RUS>\ts\tMolotov State University of Rostov, Botany Department\t\t\t",
"RVP\ts\tMuseo Provincial de Historia Natural de La Pampa (Argentina)\t\t\t",
"RWBG\ts\tRostov State University\t\t\t",
"RWC\ts\tState University of New York, Roosevelt Wildlife Collection\t\t\t",
"RWDN\ts\tUniversity of Glasgow Field Station\t\t\t",
"RWPM\ts\tRoger Williams Park Museum of Natural History\t\t\t",
"RYCC\tc\tRoseworthy Yeast Culture Collection\t\t\t",
"RYD\ts\tSchool of Art\t\t\t",
"RYU\ts\tUniversity of the Ryukyus, Biology Department\t\t\t",
"S\ts\tSwedish Museum of Natural History, Botany Departments\t\t\t",
"SA\ts\tMuseum national d'Histoire Naturelle, Laboratiore de Paleontologie\t\t\t",
"SAAR\ts\tZentrum fuer Biodokumentation des Saarlandes\t\t\t",
"SAAS\ts\tSichuan Academy of Agricultural Sciences, Mycological Herbarium of Soil and Fertilizer Institute\t\t\t",
"SAAS<ZAF>\ts\tSaasveld, Port Elizabeth Technikon\t\t\t",
"SAB\ts\tSociety of Amateur Botanists\t\t\t",
"SACA\ts\tSouth-west Agricultural University\t\t\t",
"SACC\ts\tSt. Ambrose College\t\t\t",
"SACL\ts\tSanta Clara University, Biology Department\t\t\t",
"SACON\ts\tSalim Ali Centre for Ornithology and Natural History\t\t\t",
"SACS\ts\tShenyang Agricultural College\t\t\t",
"SACT\ts\tCalifornia State University, Biological Sciences Department\t\t\t",
"SAF\ts\tDepartment of Agricultural and Forest Sciences\t\t\t",
"SAFB\ts\tUniversity of Saskatchewan, Forestry Department\t\t\t",
"SAFU\ts\tUniversity of San Francisco\t\t\t",
"SAG\tc\tSammlung von Algenkulturen at Universitat Gottingen\t\thttp://sagdb.uni-goettingen.de/detailedList.php?str_number=\t",
"SAG<CHL>\tc\tColeccion de Micoligica Laboratorio Regional, Servicio Agricola y Ganadero\t\t\t",
"SAIAB\tsb\tSouth African Institute of Aquatic Biodiversity\t\t\t",
"SAIM\ts\tSouth African Institute for Medical Research\tSAIMR\t\t",
"SAIMR\ts\tSouth African Institute for Medical Research\tSAIM\t\t",
"SAITP\tc\tSchool of Pharmacy and Medical Sciences, University of South Australia\t\t\t",
"SAK\ts\tInstitute of Marine Geology and Geophysics, Far East Branch, Island Ecological Problems Department\t\t\t",
"SAKH\ts\tSakhalin Botanical Garden\t\t\t",
"SAL\ts\tKansas Wesleyan University, Biology Department\t\t\t",
"SALA\ts\tUniversidad de Salamanca, Departamento de Botanica\t\t\t",
"SALAF\ts\tUniversidad de Salamanca\t\t\t",
"SALF\ts\tSalford Royal Free Museum and Library\t\t\t",
"SALFM\ts\tSalford Natural History Museum, Salford City Council\t\t\t",
"SALK\ts\tUniversity of South Carolina Salkehatchie\t\t\t",
"SALLE\ts\tInstituto Geobiologico La Salle\t\t\t",
"SAM<ZAF>\ts\tSouth African Museum\tSAMK\t\t",
"SAMA\tsb\tSouth Australian Museum\tSAM\t\t",
"SAMA:Herpetology\ts\tSouth Australian Museum, Herpetology Collection\t\t",
"SAMC\ts\tIziko Museum of Capetown\t\t\t",
"SAMES\ts\tUniversidade Federal do Espirito Santo\t\t\t",
"SAMF\ts\tSamford University\t\t\t",
"SAMU\ts\tSavaria Museum, Department of Natural History\t\t\t",
"SAN\ts\tForest Research Centre, Forest Department\t\t\t",
"SANBI\ts\tSouth African National Biodiversity Institute\t\t\t",
"SANC\ts\tSouth African National Collection of Insects\tNCIP<ZAF>\t\t",
"SANDC\tsc\tSouth African National Diatom Collection, North-West University\t\t\t",
"SANT\ts\tUniversidad de Santiago de Compostela\t\t\t",
"SANT:Algae\ts\tUniversidad de Santiago de Compostela, algae collection\t\t",
"SANT:Bryo\ts\tUniversidad de Santiago de Compostela, bryophyte collection\t\t",
"SANT:Lich\ts\tUniversidad de Santiago de Compostela, lichen collection\t\t",
"SANU\ts\tShaanxi Normal University, Biology Department\t\t\t",
"SAO\ts\tSammlung Oberli\t\t\t",
"SAP\ts\tHerbarium of Graduate School of Science, Hokkaido University\t\t\t",
"SAPA\ts\tHokkaido University Museum (Fungal collection)\t\t\t",
"SAPCL\ts\tSt. Andrews Presbyterian College, Biology Department\t\t\t",
"SAPS\ts\tHokkaido University Museum (Plant collection)\t\t\t",
"SAPT\ts\tHokkaido University Botanic Garden\t\t\t",
"SAR\ts\tDepartment of Forestry\t\t\t",
"SARA\ts\tZemaljski Muzej Bosne I. Herzegovine\t\t\t",
"SARAT\ts\tDepartment of Morphology and Systematic Botany\t\t\t",
"SARBG\ts\tSaratov State University Botanical Garden\t\t\t",
"SARC\ts\tRoanoke College, Biology Department\t\t\t",
"SARI\ts\tSakarya Agricultural Research Institute\t\t\t",
"SAS\ts\tSammlung Arnhardt des Museums Schloss Wilhelmsburg Schmalkalden\t\t\t",
"SASK\ts\tUniversity of Saskatchewan, Plant Sciences Department\t\t\t",
"SASSA\ts\tUniversita di Sassari, Dipartimento di Scienze del Farmaco\t\t\t",
"SASSC\tb\tSENDAI Arabidopsis Seed Stock Center\t\t\t",
"SASY\ts\tInstitute for Biological Problems of Cryolithozone\t\t\t",
"SAT\ts\tAngelo State University, Biology Department\t\t\t",
"SAU<CHN>\ts\tSichuan Agricultural University, Department of Basic Courses\t\t\t",
"SAU<USA-AR>\ts\tSouthern Arkansas University\t\t\t",
"SAUF\ts\tSichuan Agricultural University, Forestry Department\t\t\t",
"SAUT\ts\tSichuan Agricultural University\t\t\t",
"SAV\ts\tInstitute of Botany, Slovak Academy of Sciences\t\t\t",
"SAV:F\ts\tInstitute of Botany, Slovak Academy of Sciences, Fungal Collection\t\t",
"SAWV\ts\tSalem International University, Department of Bioscience\t\t\t",
"SB\ts\tSaint Bernard Abbey\t\t\t",
"SBAC\ts\tAudubon Society -- Silver Bluff Audubon Center and Sanctuary\t\t\t",
"SBBG\ts\tSanta Barbara Botanic Garden\t\t\t",
"SBC\ts\tUniversity of California, Biological Sciences Department\t\t\t",
"SBCC\ts\tSanta Barbara City College, Department of Biological Sciences\t\t\t",
"SBCM\ts\tSan Bernardino County Museum\t\t\t",
"SBDE\ts\tSino-Belgian Dinosaur expedition\t\t\t",
"SBG\ts\tBotanical Garden of Stavropol State University, Botany Department\t\t\t",
"SBH\ts\tS Blair Hedges Collection\t\t\t",
"SBKA\ts\tStiftssammlungen des Benediktinerstiftskrems-Munster\t\t\t",
"SBM<USA-CA>\ts\tSanta Barbara Museum of Natural History\t\t\t",
"SBMNH\ts\tSanta Barbara Museum of Natural History\tSBMN,SBNHM\t\t",
"SBP\ts\tStation Biologique de Paimpont\t\t\t",
"SBSC\ts\tRobert A. Vines Environmental Science Center\t\t\t",
"SBSFU\tc\tSchool of Biological Sciences\t\t\t",
"SBT\ts\tBergius Foundation\t\t\t",
"SBU\ts\tSaint Bonaventure University, Biology Department\t\t\t",
"SBUG<DEU>\tc\tDepartment of Biology of the University of Greifswald\t\t\t",
"SBY\ts\tSalisbury and South Wiltshire Museum\t\t\t",
"SC\ts\tSalem College, Biology Department\t\t\t",
"SCA\ts\tLimbe Botanical & Zoological Gardens\t\t\t",
"SCAC\ts\tSouth China Agricultural College\t\t\t",
"SCAR\ts\tWood End Museum\t\t\t",
"SCAUB\ts\tSouth China Agricultural University\t\t\t",
"SCB\ts\tStation Centrale de Boukoko\t\t\t",
"SCCAP\tc\tScandinavian Culture Collection of Algae and Protozoa\t\t\t",
"SCCBC\ts\tSelkirk College, Environmental Sciences and Technologies Department\t\t\t",
"SCCN\ts\tScott Christian College\t\t\t",
"SCDH\ts\tSouth Carolina Department of Health and Environmental Control\t\t\t",
"SCFI\ts\tSichuan Academy of Forestry\t\t\t",
"SCFQ\ts\tService canadien de la faune\t\t\t",
"SCFS\ts\tUniversity of California-Berkeley, Sagehen Creek Field Station\t\t\t",
"SCH\ts\tMuseum zu Allerheiligen\t\t\t",
"SCHG\ts\tGeorge Museum\t\t\t",
"SCHN\ts\tSmith College, Biological Sciences Department\t\t\t",
"SCIEA\ts\tSouth China Institute of Endangered Animals\t\t\t",
"SCL\ts\tSt. Cloud State University, Department of Biological Sciences\t\t\t",
"SCM\ts\tSheffield City Museums\t\t\t",
"SCN\ts\tSociedad de Ciencias Naturales \"La Salle\"\t\t\t",
"SCNHM\ts\tSouthwestern College, Natural History Museum\t\t\t",
"SCNU\ts\tSichuan Normal University\t\t\t",
"SCP\ts\tSociedad Cientifica del Paraguay\t\t\t",
"SCPS\ts\tScarborough Philosophical and Archaeological Society Museum\t\t\t",
"SCR\ts\tScripps Institution of Oceanography, Herbarium\t\t\t",
"SCS\ts\tSwift Current Research and Development Centre (Agriculture and Agri-Food Canada)\t\t\t",
"SCSC\ts\tSaint Cloud State University\t\t\t",
"SCSFRI\ts\tSouth China Sea Fisheries Research Institute\t\t\t",
"SCSG\ts\tSouth China Sea Institute of Oceanology, Academia Sinica\t\t\t",
"SCSIO\ts\tSouth China Sea Institute of Oceanology, Academia Sinica\tSCSG\t\t",
"SCSM\ts\tSouth Carolina State Museum\t\t\t",
"SCT\ts\tFriend's School\t\t\t",
"SCTCC\tc\tSichuan Type Culture Collection\t\t\t",
"SCU\ts\tShandong Christian University\t\t\t",
"SCUF\ts\tUniversidade Federal de Santa Catarina\t\t\t",
"SCUI\ts\tSuez Canal University\t\t\t",
"SCUM\ts\tSichuan University Museum\t\t\t",
"SCV\tb\tState Collection of Viruses\t\t\t",
"SCZ\ts\tSmithsonian Tropical Research Institute\tSTRI\t\t",
"SD\ts\tHerbarium, San Diego Natural History Museum\t\t\t",
"SDAKS\ts\tSouth Dakota State University\t\t\t",
"SDAU\ts\tShandong Agricultural University\t\t\t",
"SDC\ts\tSouth Dakota State University, Department of Biology\t\t\t",
"SDCM\ts\tShandong College of Traditional Chinese Medicine\t\t\t",
"SDFH\ts\tShandong Drug and Food Vocational College\t\t\t",
"SDFI\ts\tShandong Forestry Institute\t\t\t",
"SDFS\ts\tShandong Forestry School\t\t\t",
"SDI\ts\tSouthend Institute\t\t\t",
"SDM<GBR>\ts\tStroud and District Museum\t\t\t",
"SDM<USA-CA>\ts\tSan Diego Mesa College, Botany Department\t\t\t",
"SDMP\ts\tShandong Institute of Traditional Chinese Medicine and Materia Medica\t\t\t",
"SDN\ts\tBorough of Thamesdown Museum and Art Gallery\t\t\t",
"SDNCU\tcb\tThe Specimen Depository of the Graduate School of Natural Sciences, Nagoya City University\t\t\t",
"SDNH<SWZ>\ts\tMalkerns Agricultural Research Station\t\t\t",
"SDNHM\ts\tSan Diego Natural History Museum\tSDMC,SDNH,SDSNH\t\t",
"SDNHM:Birds\ts\tSan Diego Natural History Museum, Bird collection\t\t",
"SDNHM:ENT\ts\tSan Diego Natural History Museum, Entomology collection\t\t",
"SDNHM:HERP\ts\tSan Diego Natural History Museum, Herpetology collection\t\t",
"SDNHM:Mamm\ts\tSan Diego Natural History Museum, Mammal collection\t\t",
"SDNU\ts\tShandong Normal  University, College of Life Sciences\t\t\t",
"SDSM\ts\tSouth Dakota School of Mines and Technology\t\t\t",
"SDSU<USA-CA>\ts\tSan Diego State University\t\t\t",
"SDSU<USA-CA>:Arthropods\ts\tSan Diego State University, Museum of Biodiversity Terrestrial Arthropod Collection\t\t",
"SDSU<USA-CA>:Birds\ts\tSan Diego State University, Museum of Biodiversity Birds Collection\t\t",
"SDSU<USA-CA>:Fish\ts\tSan Diego State University, Museum of Biodiversity Fish Collection\t\t",
"SDSU<USA-CA>:Greenhouse\tb\tSan Diego State University, Greenhouse\t\t",
"SDSU<USA-CA>:Herbarium\ts\tSan Diego State University, Herbarium\t\t",
"SDSU<USA-CA>:Herps\ts\tSan Diego State University, Museum of Biodiversity Amphibians & Reptiles Collection\t\t",
"SDSU<USA-CA>:Mammals\ts\tSan Diego State University, Museum of Biodiversity Mammal Collection\t\t",
"SDSU<USA-SD>\ts\tSeverin-McDaniel Insect Collection\t\t\t",
"SDU\ts\tUniversity of South Dakota, Department of Biology\t\t\t",
"SEAARI\ts\tSouth Eastern Anatolian Agricultural Research Institute\t\t\t",
"SEAC\ts\tEstacion Experimental de Agricolas de la Campara\t\t\t",
"SEAMEO\tc\tSeameo-Biotrop\t\t\t",
"SEAN\ts\tMuseo Entomologico\t\t\t",
"SEBR\tc\tSanofi ELF Biorecherches\t\t\t",
"SECM\ts\tScience Education Center\t\t\t",
"SEFES\ts\tSoutheastern Forest Experiment Station\t\t\t",
"SEFSC\ts\tSoutheast Fisheries Science Center\t\t\t",
"SEFSC:MMMGL\ts\tSoutheast Fisheries Science Center, Marine Mammal Molecular Genetics Laboratory\t\t",
"SEHU\ts\tHokkaido University Insect Collection\tEIHU\t\t",
"SEIG\ts\tSocieta Entomologica Italiana\t\t\t",
"SEL\ts\tMarie Selby Botanical Gardens\t\t\t",
"SELU\ts\tSoutheastern Louisiana University, Biological Sciences Department\t\t\t",
"SEMC\ts\tSnow Entomological Museum\tKU:SEMC\t\t",
"SEMIA\tc\tRhizobium Culture Collection\t\t\t",
"SEMK\ts\tSnow Entomological Museum\t\t\t",
"SEMM\ts\tStation Experimental de la Maboke\t\t\t",
"SEMO\ts\tSoutheast Missouri State University, Department of Biology\t\t\t",
"SERC<USA-MD>\ts\tSmithsonian Environmental Research Center\t\t\t",
"SERG\ts\tInstitut de Recherche Agronomique de Guinee\t\t\t",
"SERO\ts\tSociedad para el Estudio de los Recursos Bioticos de Oaxaca\t\t\t",
"SERTC\ts\tSoutheastern Regional Taxonomic Center\t\t\t",
"SES\ts\tSoutheastern Shanxi Teachers School, Biochemistry Department\t\t\t",
"SETON\ts\tPhilmont Scout Ranch, Seton Memorial Library\t\t\t",
"SEV\ts\tUniversidad de Sevilla, Departamento de Biologia Vegetal y Ecologia\t\t\t",
"SEVF\ts\tUniversidad de Sevilla, Departamento de Botanica\t\t\t",
"SEY\ts\tSeychelles Natural History Museum\t\t\t",
"SF\ts\tUniversidad Nacional del Litoral\t\t\t",
"SFAC\ts\tStephen F. Austin State University\t\t\t",
"SFB\ts\tSalgues Foundation of Brignoles for Development of Biological Sciences\t\t\t",
"SFC\ts\tSeoul National University, Fungal collection\t\t\t",
"SFD\ts\tSheffield Galleries and Museums Trust, City Museum\t\t\t",
"SFDK\ts\tSarawak Forestry Department\t\t\t",
"SFDL\ts\tSheffield Literary and Philosophical Society\t\t\t",
"SFDN\ts\tSheffield Naturalists' Club\t\t\t",
"SFGRH\ts\tSandong Forest Germplasm Resources Center\t\t\t",
"SFI\tb\tSlovenian Forestry Institute\t\t\t",
"SFRF\ts\tForest Service, Region 5, USDA\t\t\t",
"SFRP\ts\tSouthern Research Station, USDA Forest Service\t\t\t",
"SFRS\ts\tSea Fisheries Research Station\t\t\t",
"SFS\ts\tUniversite de Sherbrooke, Departement de biologie\t\t\t",
"SFSU\ts\tSan Francisco State University, Department of Biology\t\t\t",
"SFT\ts\tStowlangtoft Hall\t\t\t",
"SFU\ts\tShanghai Fisheries University\t\t\t",
"SFUC\ts\tSimon Fraser University\t\t\t",
"SFUV\ts\tSimon Fraser University, Biological Sciences Department\t\t\t",
"SFV\ts\tCalifornia State University, Department of Biology\t\t\t",
"SFVS\ts\tSan Fernando Valley State University\t\t\t",
"SG\ts\tShanghai Botanical Garden\t\t\t",
"SGBH\ts\tMuseum of Staffordshire County\t\t\t",
"SGE\ts\tStamford Park Museum\t\t\t",
"SGEL\ts\tStalybridge Library\t\t\t",
"SGGS\ts\tThe Museum\t\t\t",
"SGGW\ts\tWarsaw University of Life Sciences\t\t\t",
"SGMA\ts\tUniversidade Nova de Lisboa\t\t\t",
"SGN\ts\tSouthern Institute of Ecology\t\t\t",
"SGO\ts\tHerbario, Museo Nacional de Historia Natural, Santiago\t\t\t",
"SGSC\tc\tSalmonella Genetic Stock Centre\t\t\t",
"SGWG\ts\tSammlung der Sektion Geologische Wissenschaften der Ernst-Moritz-Arndt University\t\t\t",
"SH\ts\tAcademia Sinica\t\t\t",
"SHB\ts\tShanghai Baptist College\t\t\t",
"SHC\ts\tSacred Heart College\t\t\t",
"SHCP\ts\tSouthern Highlands Conservation Programme\t\t\t",
"SHCT\ts\tShanghai Teachers College of Technology, Biology Department\t\t\t",
"SHD\ts\tUniversity of Sheffield, Botany Department\t\t\t",
"SHDC\ts\tShanghai Institute for Drug Control\t\t\t",
"SHG\ts\tSohag University, Botany Department\t\t\t",
"SHI\ts\tHerbarium, Shihezi University\t\t\t",
"SHIN\ts\tShinshu University\t\t\t",
"SHJ\ts\tSt. John's University\t\t\t",
"SHM<CHN>\ts\tShanghai Museum of Natural History, Botanical Department\t\t\t",
"SHM<USA-SD>\ts\tSiouxland Heritage Museum\t\t\t",
"SHMC\ts\tLuther College, Sherman A. Hoslett Museum of Natural History\t\t\t",
"SHMH\ts\tUniversite l'Aurore, Musee Heude\t\t\t",
"SHMI\ts\tShanghai Institute of Materia Medica, Chinese Academy of Sciences, Phytochemistry Department\t\t\t",
"SHMU\ts\tShanghai Medical University\t\t\t",
"SHOR\ts\tShorter College, Biology Department\t\t\t",
"SHSND\ts\tNorth Dakota Heritage Center\t\t\t",
"SHST\ts\tSam Houston State University, Department of Biological Sciences\t\t\t",
"SHSU\ts\tSam Houston State University, Vertebrate Natural History Collection\t\t\t",
"SHTC\ts\tCalifornia State University, Stanislaus\t\t\t",
"SHTU\ts\tShanghai Teachers University, Biology Department\t\t\t",
"SHY\ts\tRowley's House Museum\t\t\t",
"SHYAN\ts\tShropshire Archaeological and Natural History Society\t\t\t",
"SHYB\ts\tShrewsbury School\t\t\t",
"SHYL\ts\tHerbarium and Library\t\t\t",
"SHYN\ts\tShrewsbury Natural History Society\t\t\t",
"SHYP\ts\tShrewsbury Public Library\t\t\t",
"SI\ts\tInstituto de Botanica Darwinion\t\t\t",
"SIAC<CHN>\ts\tSichuan Institute of Agriculture\t\t\t",
"SIAC<ITA>\ts\tAccademia dei Fisiocritici Onlus\t\t\t",
"SIB\ts\tSibiu Natural History Museum\t\t\t",
"SIBAC\ts\tSouthwest Institute of Biology\t\t\t",
"SIBS\ts\tInstitute of Marine Biological Research (IMBR)\t\t\t",
"SICH\ts\tSimpson College, Biology and Environmental Sciences Department\t\t\t",
"SIEMEA\ts\tSevertsov Insitute for Evolutionary Morphology and Animal Ecology\t\t\t",
"SIENA\ts\tUniversita di Siena, Dipartimento di Scienze Ambientali \"G. Sarfatti\"\t\t\t",
"SIF\ts\tSenckenbergisches Institut\t\t\t",
"SIFS\ts\tSichuan Forestry School\t\t\t",
"SIGMA\ts\tStation Internationale de Geobotanique Mediterraneenne et Alpine\t\t\t",
"SIIS\ts\tStaten Island Institute of Arts and Sciences\t\t\t",
"SIM\ts\tStaten Island Institute of Arts and Sciences, Science Department\t\t\t",
"SIMF\ts\tTaurida National University, Botany Department\t\t\t",
"SIMS\ts\tSherkin Island Marine Station\t\t\t",
"SINDH\ts\tUniversity of Sindh, Jamshoro\t\t\t",
"SING\ts\tSingapore Botanic Gardens\t\t\t",
"SINU\ts\tNational University of Singapore, Biological Sciences Department\t\t\t",
"SIO\ts\tScripps Institution of Oceanography\t\t\t",
"SIO:BIC\ts\tScripps Institution of Oceanography, Benthic Invertebrates Collection\thttp://gdcmp1.ucsd.edu/benthic_invert/",
"SIO:Marine Vertebrates\ts\tScripps Institution of Oceanography, Marine Vertebrates Collection\thttp://collections.ucsd.edu/mv/fish/dsp_collection.php?cID=",
"SITC\ts\tSichuan Teachers College, Biology Department\t\t\t",
"SIU\ts\tSouthern Illinois University, Plant Biology Department\t\t\t",
"SIUC\ts\tResearch Museum of Zoology, Southern Illinois University at Carbondale\t\t\t",
"SIUC:H\ts\tResearch Museum of Zoology, Southern Illinois University at Carbondale, Herpetology Collection\t\t",
"SIUCM\ts\tSouthern Illinois University\t\t\t",
"SIUE\ts\tSouthern Illinois University, Edwardsville\t\t\t",
"SIZK\ts\tSchmaulhausen Institute of Zoology\t\t\t",
"SJ\ts\tDepartamento de Recursos Naturales y Ambientales\t\t\t",
"SJAC\ts\tSan Joaquin County Agriculture Commissioner\t\t\t",
"SJC\ts\tSir John Cass College, Chemistry and Biology Department\t\t\t",
"SJCA\ts\tSt. John's College\t\t\t",
"SJCRY\ts\tSt. John's College of Ripon and York\t\t\t",
"SJER\ts\tUnited States Forest Service, San Joaquin Experimental Range\t\t\t",
"SJFM\ts\tFairbanks Museum and Planetarium\t\t\t",
"SJNM\ts\tSan Juan College\t\t\t",
"SJRP\ts\tUNESP, Campus Sao Jose Rio Preto, Departamento Zoologia e Botanica\t\t\t",
"SJSC\ts\tSan Jose State University, J. Gordon Edwards Museum of Entomology\t\t\t",
"SJSU\ts\tSan Jose State University, Biological Sciences Department\t\t\t",
"SJUBC\ts\tSaint John's University, Biology Collections\t\t\t",
"SK\ts\tKatedralskolan\t\t\t",
"SKK\ts\tSung Kyun Kwan University, Biological Sciences Department\t\t\t",
"SKM\ts\tSkokholm Field Centre\t\t\t",
"SKN\ts\tCraven Museum Service\t\t\t",
"SKR\ts\tLatvian Research Institute of Agriculture, Plant Protection Department\t\t\t",
"SKT\ts\tStockport Heritage Services\t\t\t",
"SKU\ts\tSri Krishnadevaraya University, Botany Department\t\t\t",
"SKUK\tc\tSimpanan Kultur Universiti Kebangsaan\t\t\t",
"SL\ts\tUniversity of Sierra Leone, Njala University College, Biological Sciences Department\t\t\t",
"SLA\ts\tSociete des Lettres, Sciences et Arts de l'Aveyron\t\t\t",
"SLBI\ts\tSouth London Botanical Institute\t\t\t",
"SLC\ts\tEast High School, Science Department\t\t\t",
"SLFC\ts\tSlapton Ley Field Centre\t\t\t",
"SLGINNSB\ts\tPaleontological Collection\t\t\t",
"SLJG\ts\tSteiermarkisches Landesmuseum Joanneum\t\t\t",
"SLL\ts\tSociete Linneenne de Lyon\t\t\t",
"SLO\ts\tKomenskeho University, Katedra botaniky\t\t\t",
"SLPM\ts\tUniversidad Autonoma de San Luis Potosi\t\t\t",
"SLRO\ts\tSlippery Rock University, Biology Department\t\t\t",
"SLSC\ts\tSt. Louis, St. Louis Science Center\t\t\t",
"SLSK\ts\tSt. Leonard's and St. Katherine's Schools\t\t\t",
"SLTC\ts\tTeachers College, Botany Department\t\t\t",
"SLU<CAN>\ts\tLaurentian University, Biology Department\t\t\t",
"SLU<USA-LA>\ts\tSoutheastern Louisiana University, Vertebrate Museum\t\t\t",
"SLUB\ts\tSt. Louis University Museum\t\t\t",
"SLUBGH\ts\tShah Abdul Latif University\t\t\t",
"SLUI\ts\tRosa Mochel Herbarium, Universidade Estadual do Maranhao\t\t\t",
"SLUM\ts\tSaint Louis University Museum Ichthylogy Collection\t\t\t",
"SM<CHN>\ts\tChongqing Municipal Academy of Chinese Materia Medica\t\t\t",
"SM<DEU-Frankfurt>\ts\tSenckenberg Museum\t\t\t",
"SM<DEU-Langenaltheim>\ts\tSchwegler Museum\t\t\t",
"SM<USA-FL>\ts\tSanford Museum Collections\t\t\t",
"SM<USA-TX>\ts\tStrecker Museum, Baylor University\t\t\t",
"SMAG\ts\tSouthland Museum and Art Gallery\t\t\t",
"SMAO\ts\tSimao Forestry Bureau\t\t\t",
"SMB\ts\tMarianske Muzeum, Natural History Department\t\t\t",
"SMBB\ts\tStredoslovenske muzeum\t\t\t",
"SMBL\ts\tSeto Marine Biological Laboratory, Kyoto University\t\t\t",
"SMC\ts\tSedgwick Museum\t\t\t",
"SMCC\tc\tSubsurface Microbial Culture Collection\t\t\t",
"SMCC-W\tc\tSubsurface Microbial Culture Collection--Western Branch\t\t\t",
"SMCW\ts\tSaint Michael's College, Biology Department\t\t\t",
"SMDB\ts\tUniversidade Federal de Santa Maria, Departamento de Biologia\t\t\t",
"SME<FRA>\ts\tStation Marine d'Endoume\t\t\t",
"SME<GBR>\ts\tSedgwick Museum of Geology\t\t\t",
"SMF<DEU>\ts\tForschungsinstitut und NaturMuseum Senckenberg\t\t\t",
"SMF<DEU>:Amphibia fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Amphibia fossil Collection\t\t",
"SMF<DEU>:Anatomie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Anatomie Collection\t\t",
"SMF<DEU>:Arachnologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Arachnologie Collection\t\t",
"SMF<DEU>:Arachnologie fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Arachnologie fossil Collection\t\t",
"SMF<DEU>:Aschelminthes\ts\tForschungsinstitut und NaturMuseum Senckenberg, Aschelminthes Collection\t\t",
"SMF<DEU>:Aves fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Aves fossil Collection\t\t",
"SMF<DEU>:Bernstein\ts\tForschungsinstitut und NaturMuseum Senckenberg, Bernstein Collection\t\t",
"SMF<DEU>:Brachiopoda fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Brachiopoda fossil Collection\t\t",
"SMF<DEU>:Bryozoa\ts\tForschungsinstitut und NaturMuseum Senckenberg, Bryozoa Collection\t\t",
"SMF<DEU>:Chaetognatha\ts\tForschungsinstitut und NaturMuseum Senckenberg, Chaetognatha Collection\t\t",
"SMF<DEU>:Clitellata\ts\tForschungsinstitut und NaturMuseum Senckenberg, Clitellata Collection\t\t",
"SMF<DEU>:Cnidaria\ts\tForschungsinstitut und NaturMuseum Senckenberg, Cnidaria Collection\t\t",
"SMF<DEU>:Cnidaria fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Cnidaria fossil Collection\t\t",
"SMF<DEU>:Coleoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Coleoptera Collection\t\t",
"SMF<DEU>:Copepoda\ts\tForschungsinstitut und NaturMuseum Senckenberg, Copepoda Collection\t\t",
"SMF<DEU>:Crustacea\ts\tForschungsinstitut und NaturMuseum Senckenberg, Crustacea Collection\t\t",
"SMF<DEU>:Ctenophora\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ctenophora Collection\t\t",
"SMF<DEU>:Diptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Diptera Collection\t\t",
"SMF<DEU>:Echinodermata\ts\tForschungsinstitut und NaturMuseum Senckenberg, Echinodermata Collection\t\t",
"SMF<DEU>:Echinodermata fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Echinodermata fossil Collection\t\t",
"SMF<DEU>:Echiura\ts\tForschungsinstitut und NaturMuseum Senckenberg, Echiura Collection\t\t",
"SMF<DEU>:Ephemeroptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ephemeroptera Collection\t\t",
"SMF<DEU>:Foraminifera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Foraminifera Collection\t\t",
"SMF<DEU>:Graptolithina fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Graptolithina fossil Collection\t\t",
"SMF<DEU>:Hemichordata\ts\tForschungsinstitut und NaturMuseum Senckenberg, Hemichordata Collection\t\t",
"SMF<DEU>:Herpetologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Herpetologie Collection\t\t",
"SMF<DEU>:Hunsruckschiefer\ts\tForschungsinstitut und NaturMuseum Senckenberg, Hunsruckschiefer Collection\t\t",
"SMF<DEU>:Hymenoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Hymenoptera Collection\t\t",
"SMF<DEU>:Hyolithen\ts\tForschungsinstitut und NaturMuseum Senckenberg, Hyolithen Collection\t\t",
"SMF<DEU>:Ichthyologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ichthyologie Collection\t\t",
"SMF<DEU>:Insecta fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Insecta fossil Collection\t\t",
"SMF<DEU>:Lepidoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Lepidoptera Collection\t\t",
"SMF<DEU>:Loricifera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Loricifera Collection\t\t",
"SMF<DEU>:Malakologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Malakologie Collection\t\t",
"SMF<DEU>:Mammalia fossil Grossauger\ts\tForschungsinstitut und NaturMuseum Senckenberg, Mammalia fossil Grossauger Collection\t\t",
"SMF<DEU>:Mammalia fossil Kleinsauger\ts\tForschungsinstitut und NaturMuseum Senckenberg, Mammalia fossil Kleinsauger Collection\t\t",
"SMF<DEU>:Mammalogie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Mammalogie Collection\t\t",
"SMF<DEU>:Mantodea\ts\tForschungsinstitut und NaturMuseum Senckenberg, Mantodea Collection\t\t",
"SMF<DEU>:Mineralogie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Mineralogie Collection\t\t",
"SMF<DEU>:Myriapoda\ts\tForschungsinstitut und NaturMuseum Senckenberg, Myriapoda Collection\t\t",
"SMF<DEU>:Nemertini\ts\tForschungsinstitut und NaturMuseum Senckenberg, Nemertini Collection\t\t",
"SMF<DEU>:Odonata\ts\tForschungsinstitut und NaturMuseum Senckenberg, Odonata Collection\t\t",
"SMF<DEU>:Onychophora\ts\tForschungsinstitut und NaturMuseum Senckenberg, Onychophora Collection\t\t",
"SMF<DEU>:Ornithologie-Alkohol\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ornithologie-Alkohol Collection\t\t",
"SMF<DEU>:Ornithologie-Balge\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ornithologie-Balge Collection\t\t",
"SMF<DEU>:Ornithologie-Skelette\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ornithologie-Skelette Collection\t\t",
"SMF<DEU>:Orthoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Orthoptera Collection\t\t",
"SMF<DEU>:Ostracoda\ts\tForschungsinstitut und NaturMuseum Senckenberg, Ostracoda Collection\t\t",
"SMF<DEU>:Otolithen\ts\tForschungsinstitut und NaturMuseum Senckenberg, Otolithen Collection\t\t",
"SMF<DEU>:Palaoanthropologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Palaoanthropologie Collection\t\t",
"SMF<DEU>:Palaoherpetologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Palaoherpetologie Collection\t\t",
"SMF<DEU>:Pantopoda\ts\tForschungsinstitut und NaturMuseum Senckenberg, Pantopoda Collection\t\t",
"SMF<DEU>:Pentastomida\ts\tForschungsinstitut und NaturMuseum Senckenberg, Pentastomida Collection\t\t",
"SMF<DEU>:Phoronida\ts\tForschungsinstitut und NaturMuseum Senckenberg, Phoronida Collection\t\t",
"SMF<DEU>:Pisces fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Pisces fossil Collection\t\t",
"SMF<DEU>:Plathelminthes\ts\tForschungsinstitut und NaturMuseum Senckenberg, Plathelminthes Collection\t\t",
"SMF<DEU>:Plecoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Plecoptera Collection\t\t",
"SMF<DEU>:Polychaeta\ts\tForschungsinstitut und NaturMuseum Senckenberg, Polychaeta Collection\t\t",
"SMF<DEU>:Porifera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Porifera Collection\t\t",
"SMF<DEU>:Reptilia fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Reptilia fossil Collection\t\t",
"SMF<DEU>:Sedimentologie\ts\tForschungsinstitut und NaturMuseum Senckenberg, Sedimentologie Collection\t\t",
"SMF<DEU>:Sipuncula\ts\tForschungsinstitut und NaturMuseum Senckenberg, Sipuncula Collection\t\t",
"SMF<DEU>:Strepsiptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Strepsiptera Collection\t\t",
"SMF<DEU>:Stromatolithen\ts\tForschungsinstitut und NaturMuseum Senckenberg, Stromatolithen Collection\t\t",
"SMF<DEU>:Tardigrada\ts\tForschungsinstitut und NaturMuseum Senckenberg, Tardigrada Collection\t\t",
"SMF<DEU>:Tentakulita fossil\ts\tForschungsinstitut und NaturMuseum Senckenberg, Tentakulita fossil Collection\t\t",
"SMF<DEU>:Thysanoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Thysanoptera Collection\t\t",
"SMF<DEU>:Trichoptera\ts\tForschungsinstitut und NaturMuseum Senckenberg, Trichoptera Collection\t\t",
"SMF<DEU>:Trilobita\ts\tForschungsinstitut und NaturMuseum Senckenberg, Trilobita Collection\t\t",
"SMF<DEU>:Tunicata\ts\tForschungsinstitut und NaturMuseum Senckenberg, Tunicata Collection\t\t",
"SMF<DEU>:Xiphosura\ts\tForschungsinstitut und NaturMuseum Senckenberg, Xiphosura Collection\t\t",
"SMF<PER>\ts\tUniversidad Nacional Mayor de San Marcos\t\t\t",
"SMH\ts\tSaint Meinrad College of Liberal Arts, Biology Department\t\t\t",
"SMI\ts\tPrince Rupert Forest Region, Research Section\t\t\t",
"SMIP\tc\tSecao de Maricultura\t\t\t",
"SMJM\ts\tSabah Museum\tSBM\t\t",
"SMK\ts\tSarawak Museum\tSM,SMSM\t\t",
"SMK:Mesozoa\ts\tSarawak Museum, Mesozoa Collection\t\t",
"SMKM\ts\tSelangor Museum\t\t\t",
"SMM\ts\tScience Museum of Minnesota\tSMPM\t\t",
"SMMC\ts\tSecond Military Medical College\t\t\t",
"SMN\ts\tSimao District National Medical and Pharmaceutical Institute\t\t\t",
"SMNG\ts\tSenckenberg Museum fuer Naturkunde Goerlitz\t\t\t",
"SMNG:Acari fossil\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Acari fossil Collection\t\t",
"SMNG:Arachnologie\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Arachnologie Collection\t\t",
"SMNG:Collembola\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Collembola Collection\t\t",
"SMNG:Heteroptera\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Heteroptera Collection\t\t",
"SMNG:Malakologie\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Malakologie Collection\t\t",
"SMNG:Orthoptera\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Orthoptera Collection\t\t",
"SMNG:Siphonaptera fossil\ts\tSenckenberg Museum fuer Naturkunde Goerlitz, Siphonaptera fossil Collection\t\t",
"SMNH<CAN>\ts\tSaskatchewan Museum of Natural History\t\t\t",
"SMNH<ISR>\ts\tSteinhardt Museum of Natural History\t\t\t",
"SMNH<JPN>\ts\tSaitama Museum of Natural History\t\t\t",
"SMNH<SWE>\ts\tSwedish Museum of Natural History\tNRM\t\t",
"SMNH<UKR>\ts\tState Museum of Natural History\t\t\t",
"SMNH<USA-KS>\ts\tSchmidt Museum of Natural History, Emporia State University\t\t\t",
"SMNK\ts\tStaatliches Museum fuer Naturkunde Karlsruhe (State Museum of Natural History)\t\t\t",
"SMNS\ts\tStaatliches Museum fur Naturkunde Stuttgart\t\t\t",
"SMOC\ts\tSlezske Muzeum Opava\t\t\t",
"SMP<SUR>\ts\tSurinaams Museum\t\t\t",
"SMP<USA-PA>\ts\tThe State Museum of Pennsylvania\t\t\t",
"SMR\ts\tSamara State University, Department for Ecology, Botany, and Nature Protection\t\t\t",
"SMRG\tc\tSoil Microbiology Research Group, Division of Soil Science, Department of Agriculture\t\t\t",
"SMRS\ts\tStavropol Museum of Regional Studies\t\t\t",
"SMRU\ts\tShoklo Malaria Research Unit\t\t\t",
"SMS\ts\tMissouri State University, Department of Biology\t\t\t",
"SMTP\ts\tSwedish Malaise Trap Project\t\t\t",
"SMTWA\tc\tSchool of Medical Technology Western Australia\t\t\t",
"SMU\ts\tSt. Mary's University\t\t\t",
"SMU<KOR>\ts\tSangmiung University\t\t\t",
"SMU<USA-TX>\ts\tShuler Museum of Paleontology, Southern Methodist University\tSMP\t\t",
"SMVM\ts\tNational Archives and Museum\t\t\t",
"SMW<GBR>\ts\tSchool of Medicine for Women\t\t\t",
"SMW<NAM>\ts\tState Museum\tSMWN\t\t",
"SMWN\ts\tState Museum\tSMW\t\t",
"SMWU\ts\tSang Miung Women's University\t\t\t",
"SN\ts\tSouth China Normal University, Biology Department\t\t\t",
"SNC\ts\tSaint Norbert College\t\t\t",
"SNCBSH\ts\tState of North Carolina Biological Station\t\t\t",
"SNGM\ts\tColeccion Paleontologica\t\t\t",
"SNHM\ts\tSudan Natural History Museum\tUKMS\t\t",
"SNHS\ts\tGuildford Museum\t\t\t",
"SNM<SVK>\ts\tSlovak National Museum\tSNMB\t\t",
"SNM<USA-NM>\ts\tWestern New Mexico University, Department of Natural Sciences\t\t\t",
"SNMB\ts\tStaatliches Naturhistorisches Museum\t\t\t",
"SNMBR\ts\tStaatliches Naturhistorisches Museum in Braunschweig\t\t\t",
"SNMC\ts\tSlovenske Narodne Muzeum\t\t\t",
"SNMG\ts\tStaatliches Museum fuer Naturkunde\t\t\t",
"SNMH\ts\tSree Narayana Mangalam College\t\t\t",
"SNMNH\ts\tSaudi Arabian National Museum of Natural History\t\t\t",
"SNOMNH\ts\tSam Nobel Oklahoma Museum of Natural History\t\t\t",
"SNP<MYS>\ts\tSabah Parks, Botany Section\t\t\t",
"SNPH\ts\tSehlabathebe National Park\t\t\t",
"SNSD\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology\t\t\t",
"SNSD:Arachnida\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Arachnida Collection\t\t",
"SNSD:Crustacea\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Crustacea Collection\t\t",
"SNSD:Hemiptera\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Hemiptera Collection\t\t",
"SNSD:Herpetologie\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Herpetologie Collection\t\t",
"SNSD:Ichthyologie\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Ichthyologie Collection\t\t",
"SNSD:Lepidoptera\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Lepidoptera Collection\t\t",
"SNSD:Malakologie\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Malakologie Collection\t\t",
"SNSD:Mammalogie\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Mammalogie Collection\t\t",
"SNSD:Moll\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, \t\t",
"SNSD:Myriapoda\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Myriapoda Collection\t\t",
"SNSD:Ornithologie\ts\tSenckenberg Natural History Collections Dresden, Museum of Zoology, Ornithologie Collection\t\t",
"SNU\ts\tSeoul National University, School of Biological Sciences\t\t\t",
"SNUA\ts\tSeoul National University, The Arboretum\t\t\t",
"SNW\ts\tShropshire and North Wales Natural History and Antiquarian Society\t\t\t",
"SO\ts\tSofia University \"St. Kliment Ohridski\", Botany Department\t\t\t",
"SOA\ts\tAgricultural University of Plovdiv, Botany Department\t\t\t",
"SOB\ts\tHusite Museum Tabor\t\t\t",
"SOC\ts\tSouthern Oregon University, Biology Department\t\t\t",
"SOF\ts\tSofyivka National Dendrological Park\t\t\t",
"SOFM\ts\tNational Museum of Natural History, Sofia\t\t\t",
"SOFRI\tb\tSouthern Fruit Research Institute  Vietnam\t\t\t",
"SOGS\ts\tPal. Coll, Sokoto State Government Palaeontological Collection\t\t\t",
"SOIC\ts\tNatural History Museum, National Insect Collection\t\t\t",
"SOKO\ts\tOkresni muzeum Sokolov (Regional Muzeum), Botany Department\t\t\t",
"SOM\ts\tBulgarian Academy of Sciences\t\t\t",
"SOMF\ts\tBulgarian Academy of Sciences (Mycological Collection)\t\t\t",
"SORO\ts\tUniversidade Federal de Sao Carlos, campus Sorocaba\t\t\t",
"SOSCMVNH\ts\tSouthern Oregon State College, Museum of Vertebrate Natural History\t\t\t",
"SOSN\ts\tSilesian Medical School in Katowice, Department of Pharmaceutical Botany\t\t\t",
"SOSSRC\ts\tSave Our Seas Shark Research Center, Nova Southeastern University\t\t\t",
"SOTO\ts\tCollege of the Ozarks, Biology Department\t\t\t",
"SOTON\ts\tSouthampton University\t\t\t",
"SOUT\ts\tLong Island University\t\t\t",
"SP\ts\tInstituto de Botanica\t\t\t",
"SPA\ts\tSwedish Museum of Natural History, Section for Palaeobotany\t\t\t",
"SPAL\ts\tMunicipio di Reggio Emilia, Musei Civici\t\t\t",
"SPB\ts\tUniversidade de Sao Paulo\t\t\t",
"SPC\ts\tSeattle Pacific University, Biology Department, Suite 205\t\t\t",
"SPF\ts\tUniversidade de Sao Paulo, Departamento de Botanica\t\t\t",
"SPFR\ts\tUniversidade de Sao Paulo, Departamento de Biologia\t\t\t",
"SPH\ts\tFox Research Forest\t\t\t",
"SPI\ts\tStavropol Pedagogical Institute, Botany Department\t\t\t",
"SPIF\ts\tSierra Pacific Industries-Forestry\t\t\t",
"SPL\ts\tPalynological Laboratory\t\t\t",
"SPLT\ts\tSouth Plains College, Science Department\t\t\t",
"SPM\ts\tSabah Parks\t\t\t",
"SPMCC\tc\tSungei Putih Microbial Culture Collection\t\t\t",
"SPMO\tc\tSalt Plains Microbial Observatory\t\t\t",
"SPMS\ts\tUniversity of South Florida\t\t\t",
"SPN\ts\tSouthampton University, Biology Department\t\t\t",
"SPNRI\ts\tSichuan Province, Natural Resources Institute\t\t\t",
"SPR\ts\tSpringfield Science Museum, Natural Science Department\t\t\t",
"SPRY\ts\tBurton Constable Foundation\t\t\t",
"SPSC\ts\tUniversidade Federal de Sao Carlos\t\t\t",
"SPSF\ts\tInstituto Florestal\t\t\t",
"SPSU\ts\tSt. Petersburg State University\t\t\t",
"SPT\ts\tBotanic Gardens Museum\t\t\t",
"SPTS\ts\tSouthport Scientific Society\t\t\t",
"SPWH\ts\tMarine Biological Laboratory\t\t\t",
"SQB\ts\tSociete quebecoise de bryologie\t\t\t",
"SQF\ts\tUniversidad de Chile, Laboratorio de Botanica, Escuela de Quimica y Farmacia\t\t\t",
"SQUCC\tc\tSultan Qaboos University Culture Collection\t\t\t",
"SQUH\ts\tSultan Qaboos University\t\t\t",
"SR\ts\tSichuan Institute of Natural Resources\t\t\t",
"SRAICC\tc\tSRAI's culture collection\t\t\t",
"SRCG\ts\tBaylor University\t\t\t",
"SRD\ts\tPassmore Edwards Museum\t\t\t",
"SRF\ts\tShangrao Forestry Institute\t\t\t",
"SRFA\ts\tUniversidad Nacional de La Pampa\t\t\t",
"SRGH\ts\tBotanic Garden\t\t\t",
"SRI\ts\tSerengetti Research Institute\t\t\t",
"SRNP\ts\tInsects of the Area Conservacion Guanacaste, northwestern Costa Rica\t\t\t",
"SRP\ts\tBoise State University, Biology Department\t\t\t",
"SRR\ts\tKoninklijke Shell (Shell Research N.V.)\t\t\t",
"SRRC\tc\tSouthern Regional Research Center, Agricultural Research Service, United States Department of Agriculture\t\t\t",
"SRS\ts\tUniversidade do Sul de Santa Catarina\t\t\t",
"SRSC\ts\tSul Ross State University, Department of Biology\t\t\t",
"SRSU\ts\tSul Ross State University\t\t\t",
"SS\ts\tUniversita di Sassari, Dipartimento di Botanica ed Ecologia Vegetale\t\t\t",
"SSC\ts\tSacramento State University\t\t\t",
"SSCMU\tc\tSoil Science and Conservation Department Faculty of Agriculture\t\t\t",
"SSCN\ts\tMusum of the Biological Laboratory\t\t\t",
"SSD\ts\tSammlung Simon des Stattlichen Museum fur Mineralogie und Geologie Dresden\t\t\t",
"SSF\ts\tSammlung des Senckenbrug-Museum\t\t\t",
"SSHZ\ts\tSayano-Shushensky State Nature Biosphere Reserve\t\t\t",
"SSI<DNK>\tc\tStatens Serum Institute\t\t\t",
"SSIC\tc\tCollaborating Centre for Reference and Research on Escherichia and Klebsiella\t\t\t",
"SSJC\ts\tSan Joaquin County, Agriculture Department\t\t\t",
"SSKKU\tc\tDepartment of Soil Science, Faculty of Agriculture\t\t\t",
"SSL\ts\tSammlung Langenhan an der Sektion Geophysik der Karl-Marx-Universitat Lepzig\t\t\t",
"SSLP\ts\tRocky Mountain Research Station\t\t\t",
"SSM<USA-GA>\ts\tSavannah Science Museum\t\t\t",
"SSM<USA-MA>\ts\tSpringfield Science Museum\t\t\t",
"SSMF\ts\tGreat Lakes Forestry Centre, Canadian Forest Service\t\t\t",
"SSMJI\tc\tScience Section, Department of General Education, Faculty of Agricultural Business\t\t\t",
"SSMM\ts\tShanxi School of Chinese Materia Medica\t\t\t",
"SSMS\ts\tSuriname State Museum\t\t\t",
"SSNR\ts\tSocieta per GL Studi Naturalistica della Romagna\t\t\t",
"SSOFM\ts\tSanabe Shizenkan Open Field Museum\t\t\t",
"SSPW\ts\tPerivale Wood Nature Reserve\t\t\t",
"SSU\ts\tSaratov State University\t\t\t",
"SSUC\ts\tPontificia Universidad Catolica de Chile, Departamento de Ecologia\t\t\t",
"ST\ts\tSuzhou Teachers College, Biology Department\t\t\t",
"STA\ts\tUniversity of St. Andrews, School of Environmental and Evolutionary Biology\t\t\t",
"STAL\ts\tVerulamium Museum\t\t\t",
"STAR\ts\tArkansas State University, Biological Sciences Department\t\t\t",
"STASH\ts\tSt. Beuno's College\t\t\t",
"STB\ts\tSt. Bartholomew's Hospital\t\t\t",
"STC\ts\tSichuan Teacher's College\t\t\t",
"STCR\ts\tUniversite de la Reunion\t\t\t",
"STD\ts\tPrittlewell Priory Museum\t\t\t",
"STDCM\ts\tSouthend Central Museum\t\t\t",
"STE\ts\tNational Botanical Institute\t\t\t",
"STE-U\tc\tCulture collection of the Department of Plant Pathology, University of Stellenbosch\t\t\t",
"STEU\tsc\tUniversity of Stellenbosch, Botany Department\t\t\t",
"STFX\ts\tSt. Francis Xavier University, Biology Department\t\t\t",
"STG\ts\tSt. Martin's Convent\t\t\t",
"STI\ts\tStirling Smith Art Gallery and Museum\t\t\t",
"STIU\ts\tUniversity of Stirling, Biological Sciences Department\t\t\t",
"STK\ts\tStoke-on-Trent Athenaeum\t\t\t",
"STL\ts\tInstituto Nacional de Limnologia, Departamento Macrofitas\t\t\t",
"STM<DEU>\ts\tStettinger Museum\t\t\t",
"STM<FRA>\tc\tLaboratoire des Symbioses Tropicales et Mediterraneennes\t\t\t",
"STM<GBR>\ts\tStreatham Antiquarian and Natural History Society\t\t\t",
"STMC\ts\tSchool of Tropical Medicine\t\t\t",
"STMU\ts\tSt. Mary's University\t\t\t",
"STNF\ts\tShasta-Trinity National Forest\t\t\t",
"STO\ts\tThe Potteries Museum & Art Gallery\t\t\t",
"STP\ts\tLa Societe Guernesiaise, Priaulx Library\t\t\t",
"STPCM\ts\tIsland Museum, Candie Gardens\t\t\t",
"STPE\ts\tFlorida Marine Research Institute, Florida Department of Environmental Protection\t\t\t",
"STPH\ts\tDireccao Geral do Ambiente, Cabinet of Environment, Ministry of Natural Resources and Environment\t\t\t",
"STPS\ts\tSt. Paul's School\t\t\t",
"STR\ts\tUniversity of Strasbourg\t\t\t",
"STRI\tsc\tSmithsonian Tropical Research Institute\tSCZ\t\t",
"STRI:ICBG-Panama\tc\tSmithsonian Tropical Research Institute,  International Cooperative Biodiversity Groups\t\t",
"STS\ts\tStromness Museum\t\t\t",
"STT\ts\tSt. Thomas's Hospital Medical School Library\t\t\t",
"STU\ts\tStaatliches Museum fuer Naturkunde Stuttgart\t\t\t",
"STUM\ts\tSanto Tomas University Museum\t\t\t",
"SU<CHN>\ts\tSuzhou University\t\t\t",
"SU<USA-CA>\ts\tStanford University\t\t\t",
"SU<USA-OR>\ts\tOregon State University\tOS,OSUC\t\t",
"SUA\ts\tSokoine University of Agriculture, Forest Biology Department\t\t\t",
"SUB\ts\tUniversitat Bonn\t\t\t",
"SUCEA\ts\tThe University at Albany\t\t\t",
"SUCH\ts\tSukhumi Botanical Garden of Georgian Academy of Sciences\t\t\t",
"SUCN\ts\tState University of California\t\t\t",
"SUCO\ts\tState University of New York, College at Oneonta, Biology Department\t\t\t",
"SUD\ts\tStroud and District Museum\t\t\t",
"SUEL\ts\tNatural History Museum of Bakony Mountains\t\t\t",
"SUF\ts\tShimonoseki University of Fisheries\t\t\t",
"SUFA\ts\tSulaimania University\t\t\t",
"SUFAF\ts\tSiirt University Flora and Fauna Center\t\t\t",
"SUH\ts\tSohag University\t\t\t",
"SUHC\ts\tSalisbury University, Department of Biology\t\t\t",
"SUK\ts\tShivaji University Kolhapur\t\t\t",
"SUM<CZE>\ts\tOkresni vlastivedne muzeum v Sumperku\t\t\t",
"SUM<ZAF>\ts\tStellenbosch University\t\t\t",
"SUN\ts\tSunderland Museum\t\t\t",
"SUND\ts\tSunderland Natural History and Antiquarian Society\t\t\t",
"SUNIV\ts\tUniversity of Stockholm\t\t\t",
"SUNY\ts\tState University of New York\t\t\t",
"SUNYO\ts\tState University of New York at Oneonta\t\t\t",
"SURCO\ts\tUniversidad Surcolombiana\t\t\t",
"SUU\ts\tSouthern Utah University\t\t\t",
"SUVA\ts\tUniversity of the South Pacific\t\t\t",
"SUVM\ts\tShippensburg University, Vertebrate Museum\t\t\t",
"SUWS\ts\tUniversity of Wisconsin-Superior, Department of Biology and Earth Science\t\t\t",
"SV\ts\tAntigua Estacion Experimental Agronomica\t\t\t",
"SVCK\tc\tSammlung von Conjugaten Kulturen\t\t\t",
"SVER\ts\tInstitute of Plant and Animal Ecology, Laboratory of Plant Ecology and Geobotany\t\t\t",
"SVG\ts\tArkeologisk museum i Stavanger\t\t\t",
"SVIEC\tc\tSecao de Virus\t\t\t",
"SVUTY\ts\tSri Venkateswara University\t\t\t",
"SVVC\ts\tSeminario Vescovile\t\t\t",
"SWA\ts\tSwansea Museum\t\t\t",
"SWAT\ts\tUniversity of Swat Pakistan\t\t\t",
"SWAU\ts\tSouthwest Agricultural University, Horticulture Department\t\t\t",
"SWBR\ts\tSweet Briar College, Biology Department\t\t\t",
"SWC<GBR>\ts\tSammlung des Cambridge, University of Zoology\t\t\t",
"SWC<USA-PA>\ts\tSwarthmore College, Biology Department\t\t\t",
"SWCTU\ts\tSouthwest Teachers University, Biology Department\t\t\t",
"SWE\ts\tChandos House, Stowe School\t\t\t",
"SWF\ts\tFlorida Gulf Coast University\t\t\t",
"SWFC\ts\tSouthwest Forestry College\t\t\t",
"SWFSC\ts\tSouthwest Fisheries Science Center\t\t\t",
"SWGC\ts\tGrenfell Campus, Memorial University of Newfoundland\t\t\t",
"SWIBASC\ts\tAcademia Sinica\t\t\t",
"SWMT\ts\tRhodes College, Biology Department\t\t\t",
"SWN\ts\tSaffron Walden Museum\t\t\t",
"SWNHS\ts\tSaffron Walden Horticultural Society\t\t\t",
"SWRS\ts\tSouthwestern Research Station\t\t\t",
"SWSL\ts\tUSDA/ARS, Southern Weed Science Research Unit\t\t\t",
"SWT\ts\tSouthwest Texas State University, Department of Biology\t\t\t",
"SWTN\ts\tSwinton and Pendlebury Botanical Society\t\t\t",
"SWU\ts\tSungshin Women's University\t\t\t",
"SXAU\ts\tShanxi Agricultural University, Forestry Department\t\t\t",
"SXDC\ts\tShaanxi Institute for Drug Control\t\t\t",
"SXIM\ts\tShaanxi Institute of Microbiology\t\t\t",
"SXMP\ts\tShaanxi Academy of Traditional Chinese Medicine and Pharmacology\t\t\t",
"SXU\ts\tShanxi University, Biology Department\t\t\t",
"SY\ts\tShenyang Municipal Academy of Landscape Gardening\t\t\t",
"SYAU\ts\tShenyang Agricultural University\t\t\t",
"SYAUF\ts\tShenyang Agricultural University, Forestry Department\t\t\t",
"SYD\ts\tUniversity of Sydney\t\t\t",
"SYKO\ts\tKomi Scientific Centre, Ural Division, Russian Academy of Sciences, Department of Geobotany and Plant Cover Restoration\t\t\t",
"SYKT\ts\tSyktyvkar State University, Botany Department\t\t\t",
"SYPC\ts\tShenyang College of Pharmacy, Pharmaceutical Botany Department\t\t\t",
"SYR\ts\tSyracuse University, Plant Sciences Department\t\t\t",
"SYRF\ts\tState University of New York\t\t\t",
"SYS\ts\tSun Yatsen University, Biology Department\t\t\t",
"SYS:Z\ts\tSun Yatsen University, Biology Department, Zoology Collection\t\t",
"SYSBM\ts\tThe Museum of Biology Sun Yat-sen University\t\t\t",
"SYSU\tsc\tNational Sun Yat-Sen University, Department of Biological Sciences\t\t\t",
"SYT\ts\tStonyhurst College\t\t\t",
"SZ\ts\tSichuan University, Biological Department\t\t\t",
"SZB\ts\tHaus der Natur\t\t\t",
"SZCU\ts\tDepartment of Systematic Zoology\t\t\t",
"SZCZ\ts\tUniversity of Szczecin\t\t\t",
"SZE<HUN>\ts\tMora Ferenc Museum, Natural Science Department\t\t\t",
"SZE<TUR>\ts\tZoology Department, Aegean University, Science Faculty\t\t\t",
"SZG\ts\tShenzhen Fairy Lake Botanical Garden\t\t\t",
"SZL\ts\tLandesherbar von Salzburg\t\t\t",
"SZM\ts\tSaitama Zoogeographical Museum\t\t\t",
"SZMC\tc\tSzeged Microbiological Collection\t\t\t",
"SZMN\ts\tSiberian Zoological Museum\t\t\t",
"SZP\ts\tSmthsonian Zoological Park\t\t\t",
"SZPT\ts\tShenzhen Polytechnic\t\t\t",
"SZPT:ENT\ts\tShenzhen Polytechnic, Entomology Collection\t\t",
"SZU\ts\tUniversity of Salzburg, Department of Organismic Biology\t\t\t",
"T\ts\tTavera, Department of Geology and Geophysics\t\t\t",
"TA\ts\tTimescale Adventures Research and Interpretive Center\t\t\t",
"TAA\ts\tEstonian University of Life Sciences\t\t\t",
"TAAM\ts\tInstitute of Agricultural and Environmental Sciences of the Estonian University of Life Sciences\tTAAM<EST>\t\t",
"TAC\ts\tTarleton State University, Biological Sciences Department\t\t\t",
"TAD\ts\tBotanical Institute of the Tajikistan Academy of Sciences, Department of Flora and Systematics of Higher Plants\t\t\t",
"TAES\ts\tTexas A&M University, Department of Rangeland Ecology and Management\tTAMU \t\t",
"TAFIRI\ts\tTanzania Fisheries Research Institute\t\t\t",
"TAI\ts\tNational Taiwan University, Institute of Ecology and Evolutionary Biology\t\t\t",
"TAIC\ts\tTexas A&M University-Kingsville, Department of Biology\t\t\t",
"TAIE\ts\tEndemic Species Research Institute\t\t\t",
"TAIF\ts\tTaiwan Forestry Research Institute\t\t\t",
"TAIM\ts\tTaiwan Museum\t\t\t",
"TAIU\ts\tTexas A&M University - Kingsville, Texas A&I Collections\t\t\t",
"TAK\ts\tLenin State University\t\t\t",
"TAL\ts\tJardin botanique de Talence\t\t\t",
"TALE\ts\tLaboratoire Geologique\t\t\t",
"TALL\ts\tTallinn Botanic Garden, Department of Environmental Education\t\t\t",
"TAM\ts\tEstonian Museum of Natural History, Botany Department\t\t\t",
"TAMA\tc\tMycology & Metabolic Diversity Research Center, Tamagawa University Research Institute\t\t\t",
"TAMA<IDN>\ts\tMedicinal Plant and Traditional Medicinal Medicine Researc and Development Center\t\t\t",
"TAMU\ts\tTexas A&M University, Biology Department\t\t\t",
"TAN\ts\tParc de Tsimbazaza, Departement Botanique\t\t\t",
"TANE\ts\tTanta University, Botany Department\t\t\t",
"TAR\ts\tConsiglio Nazionale delle Ricerche\t\t\t",
"TARI<CHN>\ts\tTaiwan Agricultural Research Institute\t\t\t",
"TARI<IRN>\ts\tResearch Institute of Forests and Rangelands, Botanical Department\t\t\t",
"TARI<TUR>\ts\tTrakya  Agricultural Research Institute\t\t\t",
"TASH\ts\tNational Academy of Science, Uzbekistan\t\t\t",
"TASM\ts\tUzbek Academy of Sciences, Laboratory of Mycology\t\t\t",
"TAU<GRC>\tsc\tAristotle University of Thessaloniki, Biology Department\t\t\t",
"TAU<ISR>\ts\tTel-Aviv University\t\t\t",
"TAUF\ts\tAristotle University of Thessaloniki, Laboratory of Forest Botany - Geobotany\t\t\t",
"TAWES\ts\tMaryland Department of Natural Resources\t\t\t",
"TB\ts\tTbilisi State University, Botany Department\t\t\t",
"TBG<JPN>\tb\tTsukuba Botanical Garden\t\t\t",
"TBGT\ts\tTropical Botanic Garden and Research Institute\t\t\t",
"TBI\ts\tGeorgian Academy of Sciences\t\t\t",
"TBIP\ts\tResearch Institute of Plant Protection\t\t\t",
"TBPH\ts\tIovel Kutateladze Institute of Pharmacochemistry\t\t\t",
"TBRC\tc\tThailand Bioresource Research\t\t\t",
"TBY\ts\tTenby Museum\t\t\t",
"TCB\ts\tNational Chung Hsing University, Botany Department\t\t\t",
"TCC\tc\tThonon Culture Collection of the INRA\t\t\t",
"TCC/USP\tc\tTrypanosomatid Culture Collection, University of Sao Paulo\tTRYCC\t\t",
"TCD\ts\tTrinity College\t\t\t",
"TCDL\ts\tTrinity College Dublin\t\t\t",
"TCDU<IRL>\tb\tTrinity College, Dublin University, Department of Zoology DNA repository\t\t\t",
"TCDU<UGA>\ts\tMinistry of Animal Industry and Fisheries\t\t\t",
"TCF\ts\tNational Chung Hsing University, Forestry Department\t\t\t",
"TCFB\tc\tTasmanian Collection of Fish Bacteria\t\t\t",
"TCMM\tc\tThai Collection of Medical Microorganism, Department of Pathology, Faculty of Veterinary Science\t\t\t",
"TCNM\ts\tTimpanogos Cave National Monument\t\t\t",
"TCSW\ts\tTexas Women's University, Biology Department\t\t\t",
"TCWC\ts\tBiodiversity Research and Teaching Collections (formerly the Texas Cooperative Wildlife Collection)\t\t\t",
"TCWC:Birds\ts\tBiodiversity Research and Teaching Collections (formerly the Texas Cooperative Wildlife Collection), Collection of Birds\t\t",
"TCWC:Fish\ts\tBiodiversity Research and Teaching Collections (formerly the Texas Cooperative Wildlife Collection), Collection of Fishes\t\t",
"TCWC:Herp\ts\tBiodiversity Research and Teaching Collections (formerly the Texas Cooperative Wildlife Collection), Collection of Amphibians and Reptiles\t\t",
"TCWC:Invrt\ts\tBiodiversity Research and Teaching Collections (formerly the Texas Cooperative Wildlife Collection), Collection of Marine Invertebrate\t\t",
"TCWC:Mamm\ts\tBiodiversity Research and Teaching Collections (formerly the Texas Cooperative Wildlife Collection),  Mammal collection\t\t",
"TDA\ts\tDepartment of Agriculture, Tasmania\t\t\t",
"TDAH\ts\tTasmanian Department of Agriculture\t\t\t",
"TDH\ts\tHerbarium Teddy M. Dolstra\t\t\t",
"TDMP\ts\tTa-Dzong Museum\t\t\t",
"TDN\ts\tTodmorden Botanical Society\t\t\t",
"TDNA\tb\tToulouse DNA databank\t\t\t",
"TDY\ts\tTyldesley Natural History Society\t\t\t",
"TEA\ts\tTea Research Institute\t\t\t",
"TEB\ts\tTeberda State Reserve\t\t\t",
"TECLA\ts\tCentro Nacional de Tecnologia Agropecuaria\t\t\t",
"TEF\ts\tCentre National de la Recherche Appliquee au Developement Rural, Departement des Recherches Forestieres et Piscicoles\t\t\t",
"TEFH\ts\tUniversidad Nacional Autonoma de Honduras, Departamento de Biologia\t\t\t",
"TEH\ts\tUniversity of Tehran\t\t\t",
"TELA\ts\tTel Aviv University, Botany Department\t\t\t",
"TELY\ts\tTate Library\t\t\t",
"TENHS\ts\tToynbee Natural History Society\t\t\t",
"TENN\ts\tDepartment of Ecology and Evolutionary Biology, University of Tennessee\t\t\t",
"TEPB\ts\tUniversidade Federal do Piaui, Departamento de Biologia\t\t\t",
"TER\ts\tIndiana State University, Life Science Department\t\t\t",
"TESC\ts\tThe Evergreen State College\t\t\t",
"TESRI\ts\tTaiwan Endemic Species Research Institute\t\t\t",
"TEU\ts\tTeikyo University, Education Department\t\t\t",
"TEUI\ts\tU.S. Forest Service Southwest Region, Terrestrial Ecological Unit Inventory\t\t\t",
"TEX\ts\tUniversity of Texas at Austin, Plant Resources Center\t\t\t",
"TEXA\ts\tBlackland Experiment Station\t\t\t",
"TF<JPN>\ts\tForestry and Forest Products Research Institute\tTFA\t\t",
"TF<THA>\ts\tDepartment of Mineral Resources\t\t\t",
"TFA\ts\tForestry and Forest Products Research Institute\tTF\t\t",
"TFAV\ts\tServicio Autonomo para el Desarrollo Ambiental del Estado Amazonas\t\t\t",
"TFC\ts\tUniversidad de La Laguna, Departamento de Biologia Vegetal (Botanica)\t\t\t",
"TFC<EST>\tc\tTartu Fungal Culture Collection\t\t\t",
"TFD\ts\tTanzania Forestry Research Institute\t\t\t",
"TFDA\ts\tTasmanian Fisheries Development Authority\t\t\t",
"TFIC\ts\tTasmanian Forest Insect Collection\t\t\t",
"TFM\ts\tForestry and Forest Products Research Institute\t\t\t",
"TFMC\ts\tMuseo de Ciencias Naturales de Santa Cruz de Tenerife\t\t\t",
"TFRI\ts\tTaiwan Fisheries Research Institute\t\t\t",
"TGM\ts\tJanashia State Museum of Georgia\t\t\t",
"TGPI\ts\tTiraspolskij Gosudarstvennij Pedagogiceskij Institut\t\t\t",
"TGRC\tb\tC.M. Rick Tomato Genetics Resource Center\t\t\t",
"TGU\ts\tUniversity of Montenegro\t\t\t",
"TH\ts\tUniversity of Tokyo\t\t\t",
"THBC\ts\tTechnische Hochschule\t\t\t",
"THIB\ts\tNicholls State University, Department of Biological Sciences\t\t\t",
"THIM\ts\tNational Biodiversity Centre\t\t\t",
"THL\ts\tGrierson Museum\t\t\t",
"THO\ts\tRobert Dick Museum Library\t\t\t",
"THRI\ts\tSequoia and Kings Canyon National Parks\t\t\t",
"THS\ts\tTsumura Laboratory\t\t\t",
"THUP\ts\tTunghai University\t\t\t",
"TI\ts\tHerbarium of the Department of Botany, University of Tokyo\t\t\t",
"TIC\ts\tCalifornia Department of Fish and Game\t\t\t",
"TIE\ts\tTianjin Natural History Museum, Botany Department\t\t\t",
"TIK\ts\tAgricultural Research Centre, Plant Pathology Department\t\t\t",
"TIMGP\ts\tInstitut und Museum fuer Geologie und Palaeontologie der Unversitaet\t\t\t",
"TIMJ\ts\tTainai Insect Museum\t\t\t",
"TIMM\tc\tInstitute of Medical Mycology\t\t\t",
"TIPR\ts\tInstitute of Pharmaceutical Research\t\t\t",
"TISTR\tc\tTISTR Culture Collection Bangkok MIRCEN\t\t\t",
"TIU\ts\tTokyo Imperial University, Science College Museum\t\t\t",
"TJDC\ts\tTianjin Municipal Institute for Drug Control, Department of Traditional Chinese Medicine\t\t\t",
"TJMP\ts\tTianjin Institute of Medical and Pharmaceutical Sciences\t\t\t",
"TK\ts\tTomsk State University\t\t\t",
"TK<MEX>\ts\tColeccion de mamiferos del Centro Interdisciplinario de Investigacion para el Desarrollo Integral Regional Unidad Durango\t\t\t",
"TKB\ts\tUniversity of Tsukuba\t\t\t",
"TKBC\tc\tInstitute of Biological Sciences, University of Tsukuba\t\t\t",
"TKNM\ts\tTwickenham Girls' School\t\t\t",
"TKPM\ts\tTokushima Prefectural Museum\t\t\t",
"TKU\ts\tTokyo Kyoiku University\t\t\t",
"TL\ts\tUniversite Paul Sabatier\t\t\t",
"TLA\ts\tEcole Nationale Superieure Agronomique\t\t\t",
"TLF\ts\tUniversite Paul Sabatier\t\t\t",
"TLHR\ts\tThueringer Landesmuseum Heidecksburg\t\t\t",
"TLJ\ts\tUniversite Paul-Sabatier\t\t\t",
"TLM\ts\tMuseum d'Histoire Naturelle de Toulouse\t\t\t",
"TLMF\ts\tTiroler Landesmuseum Ferdinandeum\t\t\t",
"TLON\ts\tMuseum d'histoire naturelle de Toulon et du Var\t\t\t",
"TLP\ts\tFaculte de Medecine, Chaire de Botanique\t\t\t",
"TLS\ts\tTunbridge Wells Museum and Art Gallery\t\t\t",
"TLU\ts\tTexas Lutheran University\t\t\t",
"TLXM\ts\tUniversidad Autonoma de Tlaxcala\t\t\t",
"TM<DEU>\ts\tTeylers Museum, Paleontologische\t\t\t",
"TM<SVK>\ts\tSlovak National Museum\t\t\t",
"TM<ZAF>\ts\tDitsong National Museum of Natural History\tTMSA,TRM\t\t",
"TMAG\ts\tTasmanian Museum & Art Gallery\t\t\t",
"TMAL\ts\tTameside Metropolitan Borough Museum\t\t\t",
"TMBS\ts\tTatsuo Tanaka Memorial Biological Laboratory\t\t\t",
"TMC<AUS>\ts\tTate Museum Collection\t\t\t",
"TMC<USA-CO>\tc\tTrudeau Mycobacterial Culture Collection, Trudeau Institute\t\t\t",
"TMC<USA-ID>\tc\tThe Mollicutes Collection\t\t\t",
"TMDU\ts\tTokyo Medical and Dental University\t\t\t",
"TMFE\ts\tElasmobranchii Collection of the Department of Fisheries, Tokai University\t\t\t",
"TMH\ts\tTasmanian Museum and Art Gallery\t\t\t",
"TMHN\ts\tTeyler Museum\t\t\t",
"TMI\ts\tTottori Mycological Institute\t\t\t",
"TMM\ts\tTexas Memorial Museum\tTMMC\t\t",
"TMMC\ts\tTexas Memorial Museum\tTMM,TNHC\t\t",
"TMN\ts\tInstitute of the Problems of Northern Development\t\t\t",
"TMNH\ts\tTianjin Museum of Natural History\t\t\t",
"TMP<FIN>\ts\tTampere Museums\t\t\t",
"TMRC\ts\tShahid Beheshti University of Medical Sciences\t\t\t",
"TMS\ts\tToleco Museum of Health and Natural History\t\t\t",
"TMSA\ts\tDitsong National Museum of Natural History\tTM<ZAF>\t\t",
"TMTC\ts\tTaiwan Provincial Museum\t\t\t",
"TMW\tc\tTechnische Mikrobiologie Weihenstephan\t\t\t",
"TNAU\ts\tTamil Nadu Agricultural University\t\t\t",
"TNFC\ts\tTynside Naturalists' Field Club\t\t\t",
"TNFS\ts\tUSDA Forest Service, Alaska Region\t\t\t",
"TNHC\ts\tTexas Memorial Museum, Texas Natural History Collection\tTMM,TMMC\t\t",
"TNHC:Herpetology\ts\tTexas Memorial Museum, Texas Natural History Collection, Herpetology Collection\t\t",
"TNHC:Ichthyology\ts\tTexas Memorial Museum, Texas Natural History Collection, Ichthyology Collection\t\t",
"TNHM\ts\tUniversity of Texas\t\t\t",
"TNM\ts\tNational Museum of Natural Science, Botany Department\t\t\t",
"TNP\ts\tMuseum of Tatra National Park\t\t\t",
"TNS\ts\tNational Science Museum, Department of Botany\t\t\t",
"TNSC<BEL>\ts\tThierry Neef de Sainval\t\t\t",
"TNSC<USA-NJ>\ts\tTrailside Nature and Science Center\t\t\t",
"TNSM\ts\tThailand Natural History Museum\tTHNHM\t\t",
"TNU\ts\tNational Taiwan Normal University, Herbarium\t\t\t",
"TNZ\ts\tTianjin Nat. Hist. Mus.\t\t\t",
"TO\ts\tUniversity of Turin\t\t\t",
"TOD\ts\tTodmorden Free Library\t\t\t",
"TOFO\ts\tUniversity of Tokyo, Section of Forest Botany\t\t\t",
"TOGO\ts\tUniversite du Lome, Laboratoire de Botanique et Ecologie Vegetale\t\t\t",
"TOGR\ts\tMuseo di Storia Naturale Don Bosco\t\t\t",
"TOHO\ts\tToho University\t\t\t",
"TOKE\ts\tTokyo University of Education\t\t\t",
"TOLI\ts\tUniversidad del Tolima, Departamento de Biologia\t\t\t",
"TOM\ts\tIstituto Missioni Consolata\t\t\t",
"TOM<CAN>\tc\tTomicus collection Canadian Forest Service\t\t\t",
"TON\ts\tMinistry of Agriculture and Food, Forestry and Fisheries\t\t\t",
"TONG\ts\tTonghua Teachers College, Biology Department\t\t\t",
"TOR\ts\tTorquay Museum\t\t\t",
"TOU\ts\tUniversity of Tours\t\t\t",
"TOYA\ts\tToyama Science Museum, Botany Department\t\t\t",
"TPI\ts\tThe Pirbright Institute\t\t\t",
"TPI:ENT\ts\tThe Pirbright Institute, Entomology collection\t\t",
"TPII\ts\tThanksgiving Point Institute\t\t\t",
"TPNG\ts\tDepartment of Primary Industry\t\t\t",
"TPV\ts\tPrairie View A & M University, Biology Department\t\t\t",
"TR\ts\tMuseo Tridentino di Scienze Naturali\t\t\t",
"TRA\ts\tAmerican Plant Life Society\t\t\t",
"TRD\ts\tAncient House Museum\t\t\t",
"TRE\ts\tTrencianske muzeum, Scientific Department\t\t\t",
"TRES\ts\tTresco Abbey\t\t\t",
"TRH\ts\tNorwegian University of Science and Technology, Department of Natural History\t\t\t",
"TRIN\ts\tThe National Herbarium of Trinidad and Tobago\t\t\t",
"TRM\ts\tVlastivedne muzeum Trutnov\t\t\t",
"TRN\ts\tN. Copernicus University\t\t\t",
"TRO\ts\tRoyal Horticultural Society of Cornwall\t\t\t",
"TROM\ts\tUniversity of Tromsoe, Botanical Department\t\t\t",
"TROY\ts\tTroy State University, Department of Biological and Environmental Sciences\t\t\t",
"TRPM\ts\tTottori Prefectural Museum\t\t\t",
"TRT\ts\tRoyal Ontario Museum, Department of Natural History\t\t\t",
"TRTC\ts\tRoyal Ontario Museum, Center for Biodiversity and Conservation Biology\t\t\t",
"TRTE\ts\tErindale College, University of Toronto, Department of Biology\t\t\t",
"TRTS\ts\tScarborough College, University of Toronto, Botany Department\t\t\t",
"TRU\ts\tRoyal Cornwall Museum\t\t\t",
"TRV\ts\tTransvaal Museum\t\t\t",
"TS\ts\tNational University of Shandong, Biology Department\t\t\t",
"TSB\ts\tUniversita degli Studi di Trieste, Dipartimento di Biologia\t\t\t",
"TSC\ts\tTarleton State University, Tarleton State Collection\t\t\t",
"TSGM\ts\tCentral Geological Museum\t\t\t",
"TSH\ts\tMycological Herbarium University of Tsukuba\t\t\t",
"TSM\ts\tErbario, Museo Civico di Storia Naturale, Trieste\t\t\t",
"TSMHN\ts\tTeylers Strichtina Museum\t\t\t",
"TSNIGRI\ts\tTsentralny Nauchno-Issledovatelskii Geolgo-Razvedochni Muzei(Chernyshev?s Central Museum of Geological Exploration)\t\t\t",
"TSSMC\ts\tTeton Science School\t\t\t",
"TSTN\ts\tTroston Hall\t\t\t",
"TSU\ts\tMiye University\t\t\t",
"TSY\tc\tLaboratory of Mycology, Division of Microbiology\t\t\t",
"TTC\ts\tTexas Tech University, Biological Sciences Department\t\t\t",
"TTCC\ts\tTexas Tech University\t\t\t",
"TTMB\ts\tTermeszettudomanyi Muzeum\t\t\t",
"TTN\ts\tSomerset County Museum\t\t\t",
"TTRS\ts\tTall Timbers Research Station, Fire Ecology Laboratory\t\t\t",
"TTRS:Mammal\ts\tTall Timbers Research Station, Fire Ecology Laboratory, Mammals collection\t\t",
"TTRS:Ornithology\ts\tTall Timbers Research Station, Fire Ecology Laboratory, Ornithology collection\t\t",
"TTU\ts\tTexas Tech University, Museum\t\t\t",
"TTY\ts\tWestonbirt School\t\t\t",
"TU<DEU>\ts\tInstitut fur Geologie und Palaontologie, Technische Universitat Braunschweig\t\t\t",
"TU<EST>\ts\tUniversity of Tartu, Natural History Museum, Botanical and Mycological Collections\t\t\t",
"TU<USA-LA>\ts\tTulane University, Museum of Natural History\t\t\t",
"TU<USA-LA>:Birds\ts\tTulane University, Museum of Natural History, Ornithological Collection\t\t",
"TU<USA-LA>:Fish\ts\tTulane University, Museum of Natural History, Fish Collection\t\t",
"TU<USA-LA>:Herptiles\ts\tTulane University, Museum of Natural History, Amphibian And Reptile Collection\t\t",
"TU<USA-LA>:Invertebrates\ts\tTulane University, Museum of Natural History, Invertebrate Collection\t\t",
"TU<USA-LA>:Mammals\ts\tTulane University, Museum of Natural History, Mammal Collection\t\t",
"TUAT\ts\tTokyo University of Agriculture\t\t\t",
"TUB\ts\tEberhard-Karls-Universitat Tubingen, Institut fur Biologie I\t\t\t",
"TUBSB\tb\tTohoku University Brassica Seed Bank\t\t\t",
"TUC\ts\tUniversity of Arizona, Ecology and Evolutionary Biology Department\t\t\t",
"TUCH\ts\tTribhuvan University, Central Department of Botany\t\t\t",
"TUCIM\tc\tTU Wien collection of industrial microorganisms\t\t\t",
"TUFC\ts\tTottori University Fungal Culture Collection\t\t\t",
"TUFIL\ts\tTokyo University of Fisheries, Ichthyological Laboratory\t\t\t",
"TUFT\ts\tTufts University, Biology Department\t\t\t",
"TUH\ts\tTehran University, Department of Biology\t\t\t",
"TULE\ts\tTokyo University of Agriculture & Technology\t\t\t",
"TULS\ts\tUniversity of Tulsa\t\t\t",
"TULV\ts\tJardin Botanico Juan Maria Cespedes\t\t\t",
"TUM\ts\tTechnische Universitat Munchen\t\t\t",
"TUMH\ts\tTottori Fungus/Mushroom Resource and Research Center\t\t\t",
"TUN\ts\tUniversite de Tunis, Laboratoire de Biologie Vegetale\t\t\t",
"TUNG\ts\tTunghai University, Biology Department\t\t\t",
"TUP\ts\tTrent University, Biology Department\t\t\t",
"TUPH\ts\tInstitute of Public Health Research\t\t\t",
"TUR\ts\tUniversity of Turku\t\t\t",
"TURA\ts\tAabo Akademi University, Biology Department\t\t\t",
"TURP\ts\tTurpan Eremophytes Botanical Garden\t\t\t",
"TUS\ts\tTohoku University, Biological Institute\t\t\t",
"TUSG\ts\tTohoku University\t\t\t",
"TUT\ts\tDaejeon University, Department of Biology\t\t\t",
"TUTC\ts\tTunghai University\t\t\t",
"TUZ\ts\tTartu University Zoological Department\t\t\t",
"TVBG\ts\tTver State University\t\t\t",
"TVY\ts\tTurvey Abbey\t\t\t",
"TWC\ts\tTexas Wesleyan College, Museum of Zoology\t\t\t",
"TWRA\ts\tTennessee Wildlife Resources Agency\t\t\t",
"TY\ts\tShanxi College of Traditional Chinese Medicine\t\t\t",
"TYF\ts\tShangxi Forestry Institute\t\t\t",
"TYM\ts\tBotanic Gardens of Toyama\t\t\t",
"TZM\ts\tNational Science Museum\t\t\t",
"U\ts\tNationaal Herbarium Nederland, Utrecht University branch\t\t\t",
"UA<GRC>\ts\tDepartment of Historical Geology and Paleontology\t\t\t",
"UA<USA-AL>\ts\tUniversity of Alabama Collection\t\t\t",
"UA<USA-AZ>\ts\tUniversity of Arizona\t\t\t",
"UAAAC\ts\tUniversity of Alaska Anchorage Avian Collection\t\t\t",
"UAAH\ts\tHerbarium, Department of Biological Sciences, University of Alaska Anchorage\t\t\t",
"UAAM\ts\tThe Arthropod Museum, University of Arkansas\t\t\t",
"UAB<ESP>\ts\tUniversidad Autonoma de Barcelona\t\t\t",
"UABC\ts\tUniversidad Autonoma de Baja California\t\t\t",
"UABCS\ts\tUniversidad Nacional Autonoma de Baja California Sur (Mexico)\t\t\t",
"UABD\ts\tUniversity of Alabama\t\t\t",
"UAC\ts\tUniversity of Calgary, Department of Biological Sciences\t\t\t",
"UACC\ts\tUniveridad Autonoma de Chapingo\t\t\t",
"UACCC\tc\tUniversity of Alabama Chytrid Culture Collection\tUA-SEC\t\t",
"UADBA\ts\tUniversity dAntananarivo, Department de Biologie Animale\t\t\t",
"UADBG\ts\tUniversity of Alberta Botanic Garden\t\t\t",
"UADY\ts\tUniversidad Autonoma de Yucatan, Departamento de Botanica\t\t\t",
"UAEM\ts\tUniveridad Autonoma de Morelos\t\t\t",
"UAEU\ts\tUnited Arab Emirates University\t\t\t",
"UAGC\ts\tUniversidad Autonoma de Guerrero, Area de Ciencias Naturales\t\t\t",
"UAIC<CIV>\ts\tUniversity of Abidjan\t\t\t",
"UAIC<USA-AL>\ts\tUniversity of Alabama, Ichthyological Collection\t\t\t",
"UAIC<USA-AZ>\ts\tUniversity of Arizona\t\t\t",
"UALRVC\ts\tUniversity of Arkansas at Little Rock, Vertebrate Collection\t\t\t",
"UAM\ts\tUniversity of Alaska, Museum of the North\tUAF\thttp://arctos.database.museum/SpecimenDetail.cfm?GUID=\t",
"UAM:Bird\ts\tUniversity of Alaska, Museum of the North, Bird Collection\t\t",
"UAM:Bryo\ts\tUniversity of Alaska, Museum of the North, Bryozoan Collection\t\t",
"UAM:Crus\ts\tUniversity of Alaska, Museum of the North, Marine Arthropod Collection\t\t",
"UAM:Ento\ts\tUniversity of Alaska, Museum of the North, Insect Collection\t\t",
"UAM:ES\ts\tUniversity of Alaska, Museum of the North, Earth Science\t\t",
"UAM:Fish\ts\tUniversity of Alaska, Museum of the North, Fish Collection\t\t",
"UAM:Herb\ts\tUniversity of Alaska, Museum of the North, UAM Herbarium\t\t",
"UAM:Herp\ts\tUniversity of Alaska, Museum of the North, Amphibian and Reptile Collection\t\t",
"UAM:Inv\ts\tUniversity of Alaska, Museum of the North, Invertebrate Collection\t\t",
"UAM:Mamm\ts\tUniversity of Alaska, Museum of the North, Mammal Collection\thttps://arctos.database.museum/guid/UAM:Mamm:",
"UAM:Moll\ts\tUniversity of Alaska, Museum of the North, Mollusc Collection\t\t",
"UAM:Paleo\ts\tUniversity of Alaska, Museum of the North, paleontology collection\t\t",
"UAM<ESP>\tc\tUniversidad Autonoma De Madrid culture collection of cyanobacteria\t\t\t",
"UAM<USA-AL>\ts\tUniversity of Alabama, Malacology Collection\t\t\t",
"UAM<USA-AR>\ts\tUniversity of Arkansas at Monticello\t\t\t",
"UAMH\tscb\tCentre for Global Microfungal Biodiversity\t\thttps://www.uamh.ca/details.php?id=\t",
"UAMI\ts\tUniversidad Autonoma Metropolitana, Unidad Iztapalapa (Mexico)\t\t\t",
"UAMIZ\ts\tUniversidad Autonoma Metropolitana, Iztapalapa, Departamento de Biologia\t\t\t",
"UAMM\ts\tUniversidad de los Andes\t\t\t",
"UAMZ\ts\tUniversity of Alberta Museum of Zoology\t\t\t",
"UAMZC\ts\tUniversity of Arkansas, Museum Zoological Collections\t\t\t",
"UANL\ts\tUniversidad Autonoma de Nuevo Leon\t\t\t",
"UAPC\ts\tUniversity of Alberta\t\t\t",
"UARK\ts\tUniversity of Arkansas\t\t\t",
"UAS\ts\tUniversidad Autonoma de Sinaloa\t\t\t",
"UAS-B\ts\tUniversity of Agricultural Sciences Bangalore\t\t\t",
"UASB\ts\tUniversity of Agricultural Sciences, Bangalore\t\t\t",
"UASK\ts\tUkrainian Academy of Science\t\t\t",
"UASM\ts\tUniversity of Alberta, E.H. Strickland Entomological Museum\t\t\t",
"UAT\ts\tUniversidad Autonoma de Tamaulipas\t\t\t",
"UAVP\ts\tUniversity of Alberta, Laboratory for Vertebrate Paleontology\tUAVP\t\t",
"UAWC<WBK>\tb\tUnion of Agricultural Work Committees\t\t\t",
"UAY\ts\tUniversidad Autonoma de Yucatan, Facultad de Medicina Veterinaria y Zootecnia\t\t\t",
"UAZ\ts\tUniversity of Arizona\t\t\t",
"UB\tsc\tUniversity of Brasilia Herbarium\t\t\t",
"UB<FRA>\ts\tLaboratoire de Biostratigraphie\t\t\t",
"UBA\ts\tMongolian Academy of Sciences\t\t\t",
"UBC\ts\tBeaty Biodiversity Museum, University of British Columbia\t\t\t",
"UBC:CTC\ts\tBeaty Biodiversity Museum, University of British Columbia, Cowan Tetrapod Collection\t\t",
"UBC:Fish\ts\tBeaty Biodiversity Museum, University of British Columbia, Fish Collection\t\t",
"UBC:SEM\ts\tBeaty Biodiversity Museum, University of British Columbia, Spencer Entomological Museum\t\t",
"UBCC\tc\tUniversity of Barcelona Culture Collection\t\t\t",
"UBCZ\ts\tUniversity of British Columbia, Spencer Entomological Museum\t\t\t",
"UBDH\ts\tUniversiti Brunei Darussalam\t\t\t",
"UBJTL\ts\tUniversidad Bogota Jorge Tadeo Lozano\t\t\t",
"UBL\ts\tUniversite du Benin\t\t\t",
"UBOCC\tc\tUniversite de Bretagne Occidentale\t\t\t",
"UBT\ts\tOekologisch-Botanischer Garten\t\t\t",
"UBU\ts\tMongolian State University, Botany Department\t\t\t",
"UC<AUS>\tscb\tUniversity of Canberra Wildlife Tissue Collection\t\t\t",
"UC<USA-CA>\ts\tUniversity of California, University Herbarium\t\t\t",
"UC<USA-MI>\tc\tUpjohn Culture Collection\t\t\t",
"UCAC\ts\tUniversity of Central Arkansas, Department of Biology\t\t\t",
"UCAM\ts\tUniversidad Autonoma de Campeche\t\t\t",
"UCB\ts\tUniversity of California at Berkeley\t\t\t",
"UCBG\ts\tUniversity of Botswana, Department of Biological Sciences\t\t\t",
"UCBL\ts\tCentre de Paleontologie Stratigraphique et Paleoecologie\t\t\t",
"UCBMG\tc\tUniversity of California Berkeley Mycogarden\t\t\t",
"UCC\ts\tUniversity of Cincinnati\t\t\t",
"UCC<IRL>\ts\tUniversity College Cork\t\t\t",
"UCCC\ts\tUniversidad de Concepcion, Museo de Zoologia\t\t\t",
"UCCM\tc\tUniversity of Calabar Collection of Microorganisms\t\t\t",
"UCD\tscb\tUniversity of California, Davis\t\t\t",
"UCDBA\ts\tUniversity of Chicago\t\t\t",
"UCDFST\tc\tPhaff Yeast Culture Collection\t\t\t",
"UCFC\ts\tUniversity of Central Florida\t\t\t",
"UCGC\ts\tUniversity of Colorado, Geological Museum\t\t\t",
"UCGE\tc\tUnit Cell of Genetic Engineering, Department of Biochemistry\t\t\t",
"UCH\ts\tUniversidad Autonoma de Chiriqui\t\t\t",
"UCHT\ts\tUniversity of Tennessee, Chattanooga, Department of Biological and Environmental Sciences\t\t\t",
"UCI\ts\tUniversity of Ibadan, Botany and Microbiology Department\t\t\t",
"UCJ\ts\tUniversite d'Abidjan, Departemente de Botanique\t\t\t",
"UCL<GBR>\ts\tUniversity College London\t\t\t",
"UCLA\ts\tUniversity of California at Los Angeles\t\t\t",
"UCLAF\tc\tHMR/Romainville\t\t\t",
"UCLGMZ\ts\tGrant Museum of Zoology and Comparative Anatomy\t\t\t",
"UCLZ\ts\tUniversity College London\t\t\t",
"UCM<ESP>\ts\tUniversidad Complutense Madrid\t\t\t",
"UCM<UKR>\tc\tUkrainian Collection of Microorganisms, Zabolotny Institute of Microbiology and Virology\t\t\t",
"UCM<USA-CO>\ts\tUniversity of Colorado Museum of Natural History\t\t\t",
"UCM<USA-CO>:Bird\ts\tUniversity of Colorado Museum of Natural History, University of Colorado Museum Bird Collection\t\t",
"UCM<USA-CO>:Fish\ts\tUniversity of Colorado Museum of Natural History, University of Colorado Museum Fish collection\t\t",
"UCM<USA-CO>:Herp\ts\tUniversity of Colorado Museum of Natural History, University of Colorado Museum Amplibian and Reptile collection\t\t",
"UCM<USA-CO>:Mamm\ts\tUniversity of Colorado Museum of Natural History, University of Colorado Museum Mammal Collection\t\t",
"UCMC\ts\tUniversity of Colorado Museum\tUCM\t\t",
"UCME\ts\tFaculdad de Biologia, Departamento de Zoologia\t\t\t",
"UCMM\ts\tPontificia Universidad Catolica Madre y Maestra\t\t\t",
"UCMP\ts\tUniversity of California Museum of Paleontology\t\t\t",
"UCMS\ts\tStorrs, University of Connecticut\t\t\t",
"UCNW\ts\tUniversity of Wales\t\t\t",
"UCNZ\ts\tUniversity of Canterbury\t\t\t",
"UCOB\ts\tUniversidad Centroccidental Lisandro Alvarado, Departamento de Ciencias Biologicas\t\t\t",
"UCOCV\ts\tUniversity of Central Oklahoma, Collection of Vertebrates\t\t\t",
"UCONN\ts\tUniversity of Connecticut\t\t\t",
"UCP\ts\tUniversidad del Cauca\tMHNUC \t\t",
"UCPC\ts\tUniversidad del Cauca\t\t\t",
"UCR<CRI>\ts\tUniversidad de Costa Rica, Museo de Zoologia\tMZUCR\t\t",
"UCR<USA-CA>\ts\tUniversity of California, Riverside\t\t\t",
"UCR<USA-CA>:ENT\ts\tUniversity of California, Riverside, Entomology Collection\t\t",
"UCS<USA-CT>\ts\tUniversity of Connecticut\t\t\t",
"UCS<USA-NY>\ts\tUnion College, Department of Biological Sciences\t\t\t",
"UCSA\ts\tUniversity College of Swansea, Botany Department\t\t\t",
"UCSB\ts\tUniversity of California, Santa Barbara\t\t\t",
"UCSC\ts\tUniversity of California, Department of Environmental Studies\t\t\t",
"UCSW\ts\tUniversity College, Botany Department\t\t\t",
"UCVC\ts\tUniversidad Catolica de Valparaiso\t\t\t",
"UCWI\ts\tUniversity of the West Indies, Department of Life Sciences\t\t\t",
"UDBC\ts\tUniversidad Distrital\t\t\t",
"UDCC\ts\tUniversity of Delaware\t\t\t",
"UDEL\ts\tUniversity of Delaware\t\t\t",
"UDM\ts\tMuseo Friulano di Storia Naturale\t\t\t",
"UDONECI\ts\tUniversidad de Oriente\t\t\t",
"UDSM\ts\tUniversity of Dar es Salaam\t\t\t",
"UDU\ts\tUdmurt State University, Department of Biology and Chemistry\t\t\t",
"UDW\ts\tUniversity of Durban-Westville, Botany Department\t\t\t",
"UEA\ts\tUniversity of East Anglia\t\t\t",
"UEC\ts\tUniversidade Estadual de Campinas, Departamento de Botanica\t\t\t",
"UEFS\ts\tLaboratorio de Ictiologia\t\t\t",
"UEGQ\ts\tUniversidade Estadual de Goias\t\t\t",
"UENF\ts\tUniversidade Estadual do Norte Fluminense\t\t\t",
"UESC\ts\tUniversidade Estadual de Santa Cruz\t\t\t",
"UESS\ts\tUniversidad de El Salvador\t\t\t",
"UEVH\ts\tUniversidade de Evora, Departamento de Biologia\t\t\t",
"UF\tsb\tUniversity of Florida Museum of Natural History\tFLMNH\t\t",
"UF/FGS\ts\tFlorida Geological Survey\t\t\t",
"UF:Herpetology\ts\tUniversity of Florida Museum of Natural History, Herpetology Collection\t\t",
"UF:Ichthyology\ts\tUniversity of Florida Museum of Natural History, Fish Collection\t\t",
"UF:Invertebrate Zoology\ts\tUniversity of Florida Museum of Natural History, Invertebrate Zoology and Malacology Collection\t\t",
"UF:Mammalogy\ts\tUniversity of Florida Museum of Natural History, Mammalogy Collection\t\t",
"UF:Ornithology\ts\tUniversity of Florida Museum of Natural History, Ornithology Skins and Skeletons Collection\t\t",
"UF:Porifera\ts\tUniversity of Florida Museum of Natural History, \t\t",
"UFA\ts\tUfa Scientific Centre, Russian Academy of Sciences\t\t\t",
"UFACPZ\ts\tUniversidade Federal do Acre/Parque Zoobotanico\t\t\t",
"UFC\ts\tUniversidade Federal do Ceara, Departamento de Biologia\t\t\t",
"UFES\ts\tUniversidade Federal do Espirito Santo\t\t\t",
"UFG\ts\tUniversidade Federal de Goias, Unidade de Conservacao\t\t\t",
"UFH\ts\tUniversity of Fort Hare, Botany Department\t\t\t",
"UFHNH\ts\tUtah Field House of Natural History State Park\t\t\t",
"UFJF\ts\tUniversidade Federal de Juiz de Fora\t\t\t",
"UFMA\ts\tUniversidade Federal do Maranhao, Curso de Farmacia\t\t\t",
"UFMG<BRA>\ts\tUniversidade Federal de Minas Gerais\t\t\t",
"UFMI\ts\tUniversidade Federal de Mato Grosso, Instituto de Biociencias\t\t\t",
"UFMT\ts\tUniversidade Federal de Mato Grosso, Herbario Central\t\t\t",
"UFNH\ts\tUtah Field House Natural History [address unknown]\t\t\t",
"UFOP\ts\t Universidade Federal de Ouro Preto\t\t\t",
"UFP\ts\tUniversidade Federal de Pernambuco, Departamento de Botanica\t\t\t",
"UFPA\tsc\tUniversidade Federal do Para (Federal University of Para)\t\t\t",
"UFPB\ts\tDepartamento de Sistematica e Ecologia\t\t\t",
"UFPEDA\tc\tUniversidade Federal de Pernambuco\t\t\t",
"UFRG\ts\tInstituto de Biologia\t\t\t",
"UFRGS\ts\tUniversidade Federale do Rio Grande do Sul\t\t\t",
"UFRJ<herbarium>\tsc\tHerbario e Colecao Fitopathologica \"Verlande Duarte Silveira\"\t\t\t",
"UFRJ<museum>\ts\tDepartramento de Zoologia, Universidade Federal do Rio de Janeiro\t\t\t",
"UFRJ<museum>:POR\ts\tDepartramento de Zoologia, Universidade Federal do Rio de Janeiro, Porifera collection\t\t",
"UFRJIM\tc\tDepartamento de Microbiologia Medica\t\t\t",
"UFRN\ts\tUniversidade Federal do Rio Grande do Norte\t\t\t",
"UFRN:Fungos\ts\tUniversidade Federal do Rio Grande do Norte, Fungal collection\t\t",
"UFRPE\ts\tUniversidade Federal Rural de Pernambuco\t\t\t",
"UFRR\ts\tUniversidade Federal de Roraima\t\t\t",
"UFS\ts\tNyabyeya Forestry College, Department of Environmental Forestry\t\t\t",
"UFSC\ts\tUniversidade Federal de Santa Catarina\t\t\t",
"UFSCARCC\tc\tFreshwater Microalgae Collection Cultures\t\t\t",
"UFU\ts\tUral Federal University\t\t\t",
"UFV\ts\tUniversidad Nacional Federico Villarreal\t\t\t",
"UFVB\ts\tVicosa, Universidade Federal de Vicosa, Museum of Entomology\t\t\t",
"UG<ESP>\ts\tMuseo del Departamento de Estratigrafia y Paleontologia\t\t\t",
"UG<GHA>\ts\tUniversity of Ghana\t\t\t",
"UGAMNH\ts\tUniversity of Georgia Museum of Natural History\t\t\t",
"UGCA\ts\tUniversity of Georgia\t\t\t",
"UGDA\ts\tGdansk University, Department of Plant Taxonomy and Nature Conservation\t\t\t",
"UGDZ\ts\tUniversity of Guelph, Department of Zoology\t\t\t",
"UGG\ts\tUniversity of Guam\tESUG,UGM\t\t",
"UGGE\ts\tUniversidad de Guayaquil\t\t\t",
"UGGG\ts\tUniversity of Guyana\t\t\t",
"UGM\ts\tUniversity of Guam\tESUG,UGG\t\t",
"UGMD\ts\tZoology Museum of the University of Ghent\t\t\t",
"UH\ts\tUniversity of Hawaii\t\t\t",
"UHCC\tc\tUniversity of Helsinki Cyanobacteria Culture Collection\t\t\t",
"UHI\ts\tUssishkin House, Botany Department\t\t\t",
"UHM\ts\tManoa, College of Tropical Agriculture, Department of Entomology\t\t\t",
"UI<NGA>\ts\tUniversity of Ibadan\t\t\t",
"UI<USA-UT>\ts\tBureau of Land Management (Uinta Herbarium)\t\t\t",
"UICC\tc\tUniversity of Indonesia Culture Collection\t\t\t",
"UIDA\ts\tUniversity of Idaho, Bird and Mammal Museum\t\t\t",
"UIM\ts\tUniversity of Idaho\t\t\t",
"UIMNH\ts\tUniversity of Illinois, Museum of Natural History\t\t\t",
"UIS\ts\tUniversidad Industrial de Santander, Departamento de Biologia\t\t\t",
"UIS:H\ts\tUniversidad Industrial de Santander, Departamento de Biologia, Collecion Herpetologica\t\t",
"UISMHN\ts\tUniversidad Industrial de Santander, Museo de Historia Natural\t\t\t",
"UJAT\ts\tUniversidad Juarez Autonoma de Tabasco\t\t\t",
"UJB\tc\tUniversity of Jaffna Botany\t\t\t",
"UJIM\ts\tUniversity of Jordan Insect Museum\t\t\t",
"UK<USA-KY>\ts\tUniversity of Kentucky\t\t\t",
"UKEN\ts\tUniversity of Kentucky\t\t\t",
"UKKP\tc\tUniversiti Kebangsaan Kultur Perubatan\t\t\t",
"UKKY\ts\tUniversity of Kunming\t\t\t",
"UKM<DEU>\ts\tUniversitaetsklinikum Muenster\t\t\t",
"UKMB\ts\tUniversiti Kebangsaan Malaysia, Botany Department\t\t\t",
"UKMHC\ts\tUniversiti Kebangsaan Malaysia\t\t\t",
"UKMHC:HC\ts\tUniversiti Kebangsaan Malaysia, Herpetological Collection\t\t",
"UKMS<MYS>\ts\tUniversiti Kebangsaan Malaysia, Kampus Sabah\t\t\t",
"UKMS<SDN>\ts\tSudan Natural History Museum\tSNHM\t\t",
"UKS\ts\tUniversity of Khartoum\t\t\t",
"UKSPI\ts\tUst-Kamenogorsk State Pedagogical Institute, Botany Department\t\t\t",
"UL\ts\tUniversity of Louisville\tULKY\t\t",
"ULABG\ts\tUniversidad de los Andes, Laboratorio de Biogeografia\t\t\t",
"ULCI\ts\tUniversidad de la Laguna\t\t\t",
"ULF\ts\tUniversite Laval, Departement des Sciences forestieres\t\t\t",
"ULKY\ts\tUniversity of Louisville\tUK\t\t",
"ULLZ\ts\tUniversity of Louisiana at Layafette Zoological Collection\tUSLZ\t\t",
"ULM\ts\tUniversitaet Ulm, Abteilung Systematische Botanik und Oekologie\t\t\t",
"ULMG\ts\tUniversity of Leipzig\t\t\t",
"ULN\ts\tUniversity of Lagos\t\t\t",
"ULQC\ts\tUniversity of Laval\t\t\t",
"ULS\ts\tUniversidad de La Serena, Departamento de Biologia\t\t\t",
"ULT\ts\tAl-Faateh University, Botany Department\t\t\t",
"ULV\ts\tUniversidad Central de Las Villas\t\t\t",
"UM\ts\tUman National University of Horticulture\t\t\t",
"UMA\ts\tUniversity of Massachusetts, Museum of Zoology\t\t\t",
"UMAN\ts\tUniversity of Manitoba, Zoological Collection\t\t\t",
"UMB\ts\tUbersee-Museums\tUMBB\t\t",
"UMBB\ts\tUbersee-Museum, University of Bremen\tUMB\t\t",
"UMBC\ts\tUniveristy of Malawi\t\t\t",
"UMBS\ts\tUniversity of Michigan\t\t\t",
"UMCE\ts\tHerbario Federico Johow, Universidad Metropolitana de Ciencias de la Educacion\t\t\t",
"UMD\ts\tUniversity of Minnesota, Duluth\t\t\t",
"UMDC\ts\tUniversity of Maryland\t\t\t",
"UMDE\ts\tUniversity of Maine\tUMO\t\t",
"UME\ts\tUmeaa University\t\t\t",
"UMEC\ts\tUniversity of Massachusetts\t\t\t",
"UMED\ts\tUniversity of Moi\t\t\t",
"UMF<USA-FL>\ts\tUniversity of Miami\t\t\t",
"UMF<USA-ME>\ts\tUniversity of Maine, Farmington\t\t\t",
"UMF<USA-MI>\ts\tUniversity of Michigan, Biology Department\t\t\t",
"UMFFTD\tc\tFood and Fermentation Technology Division, University of Mumbai\t\t\t",
"UMFK\ts\tUniversity of Maine at Fort Kent, Biology Department\t\t\t",
"UMH\ts\tUniversidad Miguel Hernandez, Departamento de Biologia Aplicada\t\t\t",
"UMHB\ts\tUniversity of Mary Hardin-Baylor\t\t\t",
"UMIC\ts\tUniversity of Mississippi\t\t\t",
"UMIM\ts\tUniveristy of Miami Ichthyological Museum\t\t\t",
"UMIP\tc\tCollection de Champignons et Actinomycetes Pathogenes\t\t\t",
"UMKC\ts\tUniversity of Missouri\t\t\t",
"UMKL\ts\tUniversity of Malaysia\t\t\t",
"UMKU\ts\tUganda Museum\t\t\t",
"UMM\ts\tUniversity of Maine at Machias\t\t\t",
"UMML\ts\tUniversity of Miami Marine Laboratory\t\t\t",
"UMMP\ts\tUniversity of Michigan\t\t\t",
"UMMZ\ts\tUniversity of Michigan, Museum of Zoology\t\t\t",
"UMMZ:Birds\ts\tUniversity of Michigan, Museum of Zoology, Birds Collection\t\t",
"UMMZ:Herpetology\ts\tUniversity of Michigan, Museum of Zoology, Herpetology Collection\thttp://portal.vertnet.org/o/ummz/herps?id=",
"UMMZ:Mammal\ts\tUniversity of Michigan, Museum of Zoology, Mammal collection\t\t",
"UMMZ:MC\ts\tUniversity of Michigan, Museum of Zoology, Mollusk Collection\t\t",
"UMNH\ts\tUtah Museum of Natural History\t\t\t",
"UMNH:Bird\ts\tUtah Museum of Natural History, Birds collection\t\t",
"UMNH:HERP\ts\tUtah Museum of Natural History, \t\t",
"UMNH:Mamm\ts\tUtah Museum of Natural History, Mammal collection\t\t",
"UMO<GBR>\ts\tUniversity Museum of Natural History\t\t\t",
"UMO<USA-ME>\ts\tUniversity of Maine\tUMDE\t\t",
"UMO<USA-MO>\ts\tDunn-Palmer Herbarium, University of Missouri, Museum Support Center\t\t\t",
"UMOC\ts\tUniversity of Missouri, Museum of Zoology\t\t\t",
"UMR CNRS\ts\tUnites Mixtes de Recherche\t\t\t",
"UMRC\tc\tUniversity of Minnesota Rhizobium Collection\t\t\t",
"UMRM\ts\tW.R. Enns Entomology Museum\t\t\t",
"UMS\ts\tUniversiti Malaysia Sabah\t\t\t",
"UMSA\ts\tInstituto de Ecologia\t\t\t",
"UMSNH\ts\tIchthyology Collection of the Laboratory of Aquatic Biology, Michoacan University of San Nicolas de Hidalgo\t\t\t",
"UMSP\ts\tUniversity of Minnesota\t\t\t",
"UMSS\ts\tUniversidad Mayor de San Simon, Facultad de Ciencias y Tecnologia, Centro de Biodiversidad, Zoologia,Laboratorio de Ictiologia\t\t\t",
"UMT\ts\tMutare Museum\t\t\t",
"UMTP\ts\tUniversiti Malaysia Terengganu\t\t\t",
"UMUT\ts\tUniversity Museum, University of Tokyo\t\t\t",
"UMUTZ\ts\tDepartment of Zoology, University Museum\tZUMT\t\t",
"UMZ\ts\tUnivesity Museum of Zoology, Cambridge University\t\t\t",
"UMZC\ts\tUniversity Museum of Zoology Cambridge\t\t\t",
"UMZM\ts\tUniversity of Montana, Zoological Museum\t\t\t",
"UN\ts\tUniversity of Nebraska\t\t\t",
"UNA\ts\tUniversity of Alabama, Department of Biological Sciences\t\t\t",
"UNAB\ts\tUniversidad Nacional, Facultad de Agronomia\t\t\t",
"UNAC\ts\tUniversidad Nacional Agraria\t\t\t",
"UNAD\ts\tUniversidad Nacional Agraria\t\t\t",
"UNAF\ts\tUniversity of North Alabama, Department of Biology\t\t\t",
"UNAH\ts\tUniversidad Nacional Autonoma de Honduras\t\t\t",
"UNAM\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia\tIBUNAM\t\t",
"UNAM:CNAC\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Acaros\t\t",
"UNAM:CNAN\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Aracnidos\t\t",
"UNAM:CNAR\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Anfibios\t\t",
"UNAM:CNAV\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Aves\t\t",
"UNAM:CNCR\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Crustaceos\t\t",
"UNAM:CNHE\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Helmintos\t\t",
"UNAM:CNIN\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Insectos\t\t",
"UNAM:CNMA\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Mamiferos\t\t",
"UNAM:CNMO\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Moluscos\t\t",
"UNAM:CNNE\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Nematodos\t\t",
"UNAM:CNPE\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional de Peces\t\t",
"UNAM:CNPGG\ts\tUniversidad Nacional Autonoma de Mexico Facultad de Ciencias/Biologia, Coleccion Nacional del Phylum Porifera Gerardo Green\t\t",
"UNAN\ts\tUniversidad Nacional Autonoma de Nicaragua\t\t\t",
"UNB\ts\tConnell Memorial Herbarium\t\t\t",
"UNB<BRA>\ts\tUniversidade de Brasilia, Departamento de Zoologia\t\t\t",
"UNC-B\ts\tUniversity of Northern Colorado\t\t\t",
"UNCA\ts\tUniversity of North Carolina at Asheville\t\t\t",
"UNCB\ts\tUniversidad Nacional de Colombia, Insituto de Ciencias Naturales de la Universidad Nacional\t\t\t",
"UNCC<COL>\ts\tUniversidad Nacional de Caldas, Museo de Historia Natural\t\t\t",
"UNCC<USA-NC>\ts\tUniversity of North Carolina, Biology Department\t\t\t",
"UNCG\tc\tUniversity of North  Carolina at Greensboro\t\t\t",
"UNCM\ts\tMuseo de Entomologia \"Francisco Luis Gallego\"\t\t\t",
"UNCOQ\ts\tUniversidad Catolica Norte\t\t\t",
"UNCP\ts\tUniversidad Nacional de Colombia\t\t\t",
"UNCW\ts\tUniversity of North Carolina at Wilmington\t\t\t",
"UNDH\ts\tUniversity of Natal Durban\t\t\t",
"UNEFM\ts\tUniversidad Experimental Francisco de Miranda\t\t\t",
"UNEVR\ts\tUniversity of Nevada, Museum of Biology\tUNR\t\t",
"UNEX\ts\tUniversidad de Extremadura, Departamento de Botanica\t\t\t",
"UNEX:FECRGA\tc\tUniversidad de Extremadura, Departamento de Botanica, Fungal Endophytes Collection of the  Research Group of Agronomy\t\t",
"UNH\ts\tUniversity of New Hampshire\t\t\t",
"UNI\ts\tUniversity of Northern Iowa\t\t\t",
"UNIMAS<MYS>\ts\tUniversiti Malaysia Sarawak\t\t\t",
"UNIN\ts\tUniversity of the North, Botany Department\t\t\t",
"UNIP\ts\tUniversidade Paulista, Laboratorio de Botanica\t\t\t",
"UNIPAR\ts\tMycological Herbarium University of Parakou\t\t\t",
"UNIQEM\tc\tInstitute of Microbiology, Russian Academy of Sciences\t\t\t",
"UNITEC\ts\tUnitec Institute of Technology\t\t\t",
"UNL<MEX>\ts\tUniversidad Autonoma de Nuevo Leon\t\t\t",
"UNL<PRT>\ts\tCentro de Estratigrafia e Paleobiologia da Universidade Nova de Lisboa\t\t\t",
"UNL<USA-NE>\ts\tUniversity of Nebraska State Museum\t\t\t",
"UNLO\ts\tUniversidad Nacional Experimental de los Llanos Occidental\t\t\t",
"UNLP\ts\tUniversidad Nacional de La Plata\t\t\t",
"UNLV\ts\tUniversity of Nevada, Las Vegas, Department of Biological Sciences\t\t\t",
"UNM\ts\tUniversity of New Mexico, Department of Biology\t\t\t",
"UNMC\ts\tUniversity of New Mexico\t\t\t",
"UNMDP\ts\tUniversidad Nacional de Mar del Plata, Mar del Plata, Argentina\t\t\t",
"UNN\ts\tUniversity of Nigeria, Botany Department\t\t\t",
"UNNEC\ts\tUniversidad Nacional del Nordeste, Facultad de Ciencias Exactas y Naturales y Agrimensura\t\t\t",
"UNNF\ts\tUniversite de Nancy\t\t\t",
"UNO\ts\tFundacion Universidad del Norte\t\t\t",
"UNOAL\ts\tUniversity of Northern Alabama\t\t\t",
"UNOP\ts\tUniversidade Estadual do Oeste do Parana\t\t\t",
"UNOVC\ts\tUniversity of New Orleans\t\t\t",
"UNPSJB-Pv\ts\tUniversidad Nacional de la Patagonia\t\t\t",
"UNR<ARG>\ts\tUniversidad Nacional de Rosario, Botanica y Ecologia Vegetal\t\t\t",
"UNR<USA-NV>\ts\tUniversity of Nevada, Museum of Biology\t\t\t",
"UNR<USA-NV>:Herpetology\ts\tUniversity of Nevada, Museum of Biology, Herpetology Collection\t\t",
"UNR<USA-NV>:Mammal\ts\tUniversity of Nevada, Museum of Biology, Mammalogy collection\t\t",
"UNS\ts\tUniversity of Science, Ho Chi Minh City, Vietnam\t\t\t",
"UNSA\ts\tUniversity of Natal\t\t\t",
"UNSL\ts\tUniversidad Nacional de San Luis\t\t\t",
"UNSM\ts\tUniversity of Nebraska State Museum\t\t\t",
"UNSW\tc\tMicrobiology Culture Collection, University of New South Wales\t\t\t",
"UNSW<AUS>\ts\tJohn T. Waterhouse Herbarium\t\t\t",
"UNT\ts\tUniversidad nacional de Tucumn\t\t\t",
"UNWH\ts\tUniversity of North-West, Biological Sciences Department\t\t\t",
"UO\ts\tUniversity of Oklahoma\t\t\t",
"UO<CZE>\ts\tUniversity of Ostrava\t\t\t",
"UOA/HCPF<GRC>\tc\tUOA/HCPF University of Athens/Hellenic Collection of Pathogenic Fungi\t\t\t",
"UOG\ts\tUniversity of Guelph\t\t\t",
"UOG:BIO\tb\tUniversity of Guelph, Biodiversity Institute of Ontario\t\t",
"UOG:DEBU\ts\tUniversity of Guelph, Ontario Insect Collection\t\t",
"UOIC\ts\tUniversity of Oregon\t\t\t",
"UOJ\ts\tUniversidad del Oriente, Departamento de Agronomia\t\t\t",
"UOK\ts\tUniversity of Kurdistan\t\t\t",
"UOM\ts\tUniversity of Missouri\t\t\t",
"UOMNH\ts\tUniversity of Oregon, Museum of Natural History\t\t\t",
"UOMZ\ts\tUniversity of Oklahoma, Stovall Museum of Zoology\t\t\t",
"UOP\ts\tUniversity of Opole\t\t\t",
"UOPJ\ts\tOsaka Prefecture University\t\t\t",
"UOS\ts\tUniversity of the South, Biology Department\t\t\t",
"UP\ts\tUniversity of Papua and New Guinea\t\t\t",
"UPA\ts\tUniversity of Patras, Department of Plant Biology\t\t\t",
"UPCB\ts\tUniversidade Federal do Parana, Departamento de Botanica\t\t\t",
"UPCC\tc\tNatural Sciences Research Institute Culture Collection\t\t\t",
"UPCT\ts\tUniversidad Politecnica De Cartagena\t\t\t",
"UPEI\ts\tUniversity of Prince Edward Island, Biology Department\t\t\t",
"UPF\ts\tUniversite de Polynesie Francaise Herbarium\t\t\t",
"UPIE\tb\tUnidad de Patologia Infecciosa y Epidemiologia\t\t\t",
"UPLB\ts\tMuseum of Natural History, University of the Philippines\t\t\t",
"UPM<FRA>\ts\tDepartement des Siences de la Terre\t\t\t",
"UPM<MYS>\ts\tUniversiti Pertanian Malaysia, Biology Department\t\t\t",
"UPM<RUS>\ts\tUdory Paleontological Museum\t\t\t",
"UPMR\tc\tRhizobium Collection\t\t\t",
"UPMSI\ts\tMarine Science Institute\t\t\t",
"UPNA\ts\tUniversidad Publica de Navarra, Departamento de Ciencias del Medio Natural\t\t\t",
"UPNG\ts\tUniversity of Papua New Guinea, Division of Biological Sciences\t\t\t",
"UPOL\ts\tUniversity Palacky Olomouc\t\t\t",
"UPOS\ts\tUniversidad Pablo de Olavide, Ciencias Ambientales (Botanica)\t\t\t",
"UPP\ts\tUppingham School Museum\t\t\t",
"UPPC\ts\tUniversity of the Philippines\t\t\t",
"UPR\ts\tPuerto Rico Botanic Garden, University of Puerto Rico\t\t\t",
"UPRG\ts\tUniversidad Nacional \"Pedro Ruiz Gallo\"\t\t\t",
"UPRM\tc\tUniversity of Puerto Rico at Mayagueez, Rhizobium Culture Collection\t\t\t",
"UPRP\ts\tUniversity of Puerto Rico at Rio Piedras\t\t\t",
"UPRRP\ts\tUniversity of Puerto Rico, Biology Department\t\t\t",
"UPS\ts\tUppsala University, Museum of Evolution, Botany Section (Fytoteket)\t\t\t",
"UPSA\ts\tUniversity of Pretoria\t\t\t",
"UPSC\tc\tFungal Culture Collection at the Botanical Museum\t\t\t",
"UPSU\ts\tUlyanovsk State Pedagogical University, Department of Botany\t\t\t",
"UPSV\ts\tUppsala University, Department of Plant Ecology\t\t\t",
"UPTC\ts\tUniversidad Pedogogica y Tecnologica de Colombia, Escuela de Ciencias Biologicas\t\t\t",
"UPVB\ts\tDepartamento de Geologia, Universidad del Pais Vasco\t\t\t",
"UPVLP\ts\tLaboratorio de Paleontolgia of the Universdad del Pais Vasco/Euskal Herriko Unibersitatea\t\t\t",
"UPVMI\ts\tUniversity of the Philippines Visayas Museum of Natural Sciences\t\t\t",
"UPVMI:I\ts\tUniversity of the Philippines Visayas Museum of Natural Sciences, University of the Philippines Visayas Museum of Natural Sciences Ichthyological Collection\t\t",
"UQAM\ts\tUniversite du Quebec a Montreal, Departement des Sciences biologiques\t\t\t",
"UQAR\ts\tUniversite du Quebec a Rimouski, Departement de biologie\t\t\t",
"UQIC\ts\tUniversity of Queensland Insect Collection\t\t\t",
"UQTR\ts\tUniversite du Quebec a Trois-Rivieres, Departement de chimie-biologie\t\t\t",
"URB\ts\tRyukyu University Department of Zoology\t\t\t",
"URIC\ts\tUniversity of Rhode Island\t\t\t",
"URIMC\ts\tUniversity of Rhode Island, Mammal Collection\t\t\t",
"URM<BRA>\tsc\tUniversidade Federal de Pernambuco\t\t\t",
"URM<JPN>\ts\tUniversity of the Ryukyus\t\t\t",
"URMU\ts\tMuseo Nacional de Historia Natural, Montevideo\t\t\t",
"URO\ts\tUniversity of the Ryukyus\t\t\t",
"URP\ts\tMuseo de Historia Natural, Universidad Ricardo Palma\t\t\t",
"URT\ts\tUniversita degli Studi di Roma Tre, Dipartimento di Biologia\t\t\t",
"URV\ts\tUniversity of Richmond, Biology Department\t\t\t",
"US\ts\tSmithsonian Institution, Department of Botany\tUS:Botany,USNM:US\t\t",
"US<ZAF>\ts\tUniversity of Stellenbosch\t\t\t",
"USA\ts\tUniversity of South Alabama\t\t\t",
"USAC<AUS>\ts\tUniversity of Western Australia\t\t\t",
"USAC<GTM>\ts\tUniversidad de San Carlos de Guatemala\t\t\t",
"USAM\ts\tUniversity of South Alabama, Department of Biological Sciences\t\t\t",
"USANHC\ts\tUniversity of South Alabama, Vertebrate Natural History Collection\t\t\t",
"USAS\ts\tUniversity of Regina, Biology Department\t\t\t",
"USB\tc\tBacterial collection of Universita degli studi della basilicata, Dipartimento di Biologia\t\t\t",
"USBCF\ts\tU. S. Bureau of Commercial Fisheries\t\t\t",
"USBS\ts\tSchool of Biological Sciences, University of Science\t\t\t",
"USC\ts\tUniversity of Southern California, Biological Sciences Department\t\t\t",
"USCC\ts\tUniversity of Southern Colorado\t\t\t",
"USCC<UK>\tc\tUniversity of Surrey Culture Collection\t\t\t",
"USCG\ts\tUniversidad de San Carlos de Guatemala\t\t\t",
"USCH\ts\tUniversity of South Carolina, Department of Biological Sciences\t\t\t",
"USCP\ts\tUniversity of San Carlos\t\t\t",
"USCS\ts\tUniversity of South Carolina, Science and Mathematics Department\t\t\t",
"USCWH\ts\tUnited Services College\t\t\t",
"USD<DOM>\ts\tUniversidad Autonoma de Santo Domingo\t\t\t",
"USD<USA-SD>\ts\tUniversity of South Dakota\t\t\t",
"USDA\tscb\tUnited States Department of Agriculture\t\t\t",
"USDA:CFRA\tb\tUnited States Department of Agriculture, Corvallis Fragaria Catalog\t\t",
"USDA:GRIN\tb\tUnited States Department of Agriculture, Germplasm Resources Information Network\t\t",
"USDA:NCGR\tb\tUnited States Department of Agriculture, National Clonal Germplasm Repository\t\t",
"USDA:NSGC\tsb\tUnited States Department of Agriculture, National Small Grains Collection\t\t",
"USDA:PGRU\tsb\tUnited States Department of Agriculture, Plant Genetic Resources Unit\t\t",
"USDA:USNPC\ts\tUnited States Department of Agriculture, US National Parasite Collection\t\t",
"USDAK\ts\tW. H. Over State Museum\t\t\t",
"USF\ts\tUniversity of South Florida\t\t\t",
"USF:CBD\tc\tUniversity of South Florida, Center for Biological Defense\t\t",
"USFC\ts\tU. S. Fish Commission\t\t\t",
"USFS\ts\tRocky Mountain Forest and Range Experiment Station\t\t\t",
"USGS\ts\tU.S. Geological Survey\t\t\t",
"USGS:ASC\ts\tU.S. Geological Survey, Alaska Science Center\t\t",
"USH\ts\tUshaw College\t\t\t",
"USI\ts\tUniversity of Southern Indiana\t\t\t",
"USJ\ts\tUniversidad de Costa Rica\t\t\t",
"USLH\ts\tUniversity of Louisiana Lafayette, Department of Renewable Resources\t\t\t",
"USM<MYS>\ts\tUniversiti Sains Malaysia\t\t\t",
"USM<MYS>:VCRU\ts\tUniversiti Sains Malaysia, Vector Control Research Unit\t\t",
"USM<PER>\ts\tUniversidad Nacional Mayor de San Marcos, Museo de Historia Natural, Herbario\t\t\t",
"USMMC\ts\tUniversiti Sains Malaysia Mollusc Collection\t\t\t",
"USMP\ts\tUniversiti Sains Malaysia\t\t\t",
"USMS\ts\tUniversity of Southern Mississippi, Department of Biological Sciences\t\t\t",
"USNC\ts\tSmithsonian Institution, Paleobiology Department\t\t\t",
"USNM\tsb\tNational Museum of Natural History, Smithsonian Institution\tNMNH\t\t",
"USNM:Birds\ts\tNational Museum of Natural History, Smithsonian Institution, Division of Birds\thttps://collections.nmnh.si.edu/search/birds/?nb=",
"USNM:Botany\ts\tNational Museum of Natural History, Smithsonian Institution, Plant Collection\thttps://collections.nmnh.si.edu/search/botany/?nb=",
"USNM:ENT\ts\tNational Museum of Natural History, Smithsonian Institution, Entomology Collection\thttps://collections.nmnh.si.edu/search/ento/?nb=",
"USNM:FISH\ts\tNational Museum of Natural History, Smithsonian Institution, National Fish Collection\thttps://collections.nmnh.si.edu/search/fishes/?nb=",
"USNM:Herp\ts\tNational Museum of Natural History, Smithsonian Institution, Division of Amphibians and Reptiles\thttps://collections.nmnh.si.edu/search/herps/?nb=",
"USNM:Herp Image\ts\tNational Museum of Natural History, Smithsonian Institution, Herpetology image collection\t\t",
"USNM:Herp Tissue\ts\tNational Museum of Natural History, Smithsonian Institution, Herpetology tissue collection\t\t",
"USNM:IZ\ts\tNational Museum of Natural History, Smithsonian Institution, Department of Invertebrate Zoology\thttps://collections.nmnh.si.edu/search/iz/?nb=",
"USNM:LAB\tb\tNational Museum of Natural History, Smithsonian Institution, Laboratories of Analytical Biology\t\t",
"USNM:MAMM\ts\tNational Museum of Natural History, Smithsonian Institution, Division of Mammals\thttps://collections.nmnh.si.edu/search/mammals/?nb=",
"USNTC\ts\tU.S. National Tick Collection\t\t\t",
"USON\ts\tUniversidad de Sonora, Departamento de Investigaciones Cientificas y Technologicas\t\t\t",
"USP<BRA>\ts\tUniversidade de Sao Paulo\t\t\t",
"USP<ESP>\ts\tUniversidad San Pablo-CEU (Departamento de Biologia Vegetal (seccion Botanica)\t\t\t",
"USP<FJI>\ts\tUniversity of the South Pacific\t\t\t",
"USPIY\ts\tK. D. Ushinsky Yaroslavl State Pedagogical University, Department of Botany\t\t\t",
"USRC\ts\tUniversity of Regina\t\t\t",
"USRCB\tc\tUkrainian Scientific-Research Cell Bank.\t\t\t",
"USSC\ts\tU.S. Soil Conservation Service\t\t\t",
"USTCMS\tc\tUniversity of Santo Tomas Collection of Microbial Strains\t\t\t",
"USTF\ts\tTechnologische Faculteit\t\t\t",
"USTH\ts\tUniversity of Santo Tomas\t\t\t",
"USTK\ts\tUniversity of Science and Technology, Museum of Natural History\t\t\t",
"USU\ts\tUnited States Department of Agriculture\t\t\t",
"USUUB\ts\tUtah State University Uintah Basin\t\t\t",
"USZ\ts\tUniversidad Autonoma Gabriel Rene Moreno\t\t\t",
"UT<USA-TN>\ts\tUniversity of Tennessee\t\t\t",
"UT<USA-UT>\ts\tUniversity of Utah Herbarium\t\t\t",
"UTA\ts\tUniversity of Texas at Arlington\t\t\t",
"UTA:A\ts\tUniversity of Texas at Arlington, Amphibian Collection\t\t",
"UTA:R\ts\tUniversity of Texas at Arlington, Reptile collection\t\t",
"UTAI\ts\tTel Aviv University\t\t\t",
"UTC\ts\tUtah State University, Biology Department\t\t\t",
"UTCEC\ts\tUniversidad Tecnica de Cotopaxi (Herbario de Botanica Aplicada UTCEC, CAREN (Agriculture Farming and Natural Resources, Facultad de Ciencias Agropecuarias y Recursos Naturales)\t\t\t",
"UTCI\ts\tUniversity of Tennessee at Chattanooga Insect Collection\t\t\t",
"UTD\ts\tUniversity of Texas, Plant Resources Center\t\t\t",
"UTE\ts\tUniversity of Tartu\t\t\t",
"UTEP\ts\tUniversity of Texas at El Paso Biodiversity Collections\t\t\t",
"UTEP:Bird\ts\tUniversity of Texas at El Paso Biodiversity Collections, Ornithology Collection\t\t",
"UTEP:Ento\ts\tUniversity of Texas at El Paso Biodiversity Collections, Entomology Collection\t\t",
"UTEP:ES\ts\tUniversity of Texas at El Paso Biodiversity Collections, Earth Science  fossils Collections\t\t",
"UTEP:Fish\ts\tUniversity of Texas at El Paso Biodiversity Collections, Ichthyology collection\t\t",
"UTEP:Herb\ts\tUniversity of Texas at El Paso Biodiversity Collections, Herbarium\t\t",
"UTEP:Herps\ts\tUniversity of Texas at El Paso Biodiversity Collections, Herpetology collection\t\t",
"UTEP:INV\ts\tUniversity of Texas at El Paso Biodiversity Collections, Invertebrates - Molluscs Collections\t\t",
"UTEP:Mammal\ts\tUniversity of Texas at El Paso Biodiversity Collections, Mammal collection\t\t",
"UTEP:Zoo\ts\tUniversity of Texas at El Paso Biodiversity Collections, Zooplankton collections\t\t",
"UTEX\tc\tThe Culture Collection of Algae at the University of Texas Austin\t\t\t",
"UTG\ts\tUniversity of Tuebingen\t\t\t",
"UTGD\ts\tGeology Department, The University of Tasmania\t\t\t",
"UTHSC\tc\tUniversity of Texas Health Science Center\t\t\t",
"UTIM\ts\tUniversity of Tennessee Insect Museum\t\t\t",
"UTKI\ts\tUniversity of Teheran\t\t\t",
"UTLH\ts\tUniversity of Technology, Human Sciences Department\t\t\t",
"UTLPA\ts\tUniversity of Texas at Austin, Laboratory of Physical Anthropology\t\t\t",
"UTM\ts\tUniversity of Tennessee at Martin\t\t\t",
"UTMC\ts\tUniversidad del Magdalena\t\t\t",
"UTMC<IRN>\tc\tUniversity of Tehran Microorganisms Collection\t\t\t",
"UTMZ\ts\tUniversity of Tennessee, Museum of Zoology\t\t\t",
"UTV\ts\tUniversita degli Studi della Tuscia, Dipartimento di Agrobiologia e Agrochimica\t\t\t",
"UTZM\ts\tUniversity of Tsukubo\t\t\t",
"UU<SWE>\ts\tUniversity of Uppsala\t\t\t",
"UU<UKR>\ts\tUzhgorod State University, Botany Department\t\t\t",
"UU<USA-UT>\ts\tUniversity of Utah, Department of Biology\t\t\t",
"UUC\tc\tJanet A. Robertson Collection of Ureaplasma urealyticum Cultures\t\t\t",
"UUDE\ts\tBuryat State University\t\t\t",
"UUH\ts\tInstitute of General and Experimental Biology, Department of Floristics and Geobotany\t\t\t",
"UUVP\ts\tUniversity of Utah, Vertebrate Paleontology\t\t\t",
"UUZM\ts\tUppsala University, Zoological Museum\t\t\t",
"UV<CHL>\ts\tUniversity of Valparaiso\t\t\t",
"UV<COL>\ts\tDepartamento de Biologia de la Universidad del Valle\t\t\t",
"UVA\ts\tGeological Institute of the University of Amsterdam\t\t\t",
"UVAL\ts\tUniversidad del Valle de Guatemala\t\t\t",
"UVC\ts\tColeccion de Anfibios y Reptiles, Universidad del Valle, Cali\t\t\t",
"UVCC\ts\tUniversity of Vermont\t\t\t",
"UVCE\ts\tColecao Entomologica, Laboratorio de Entomologia Sistematica\t\t\t",
"UVCO\ts\tUniversidad de Valle\t\t\t",
"UVG\ts\tUniversidad del Valle\t\t\t",
"UVGC\ts\tCollecion de Artropodos\t\t\t",
"UVIC\ts\tUniversity of Victoria, Biology Department\t\t\t",
"UVM\ts\tZadock Thompson Natural History Collection, University of Vermont\t\t\t",
"UVP\ts\tUtah State Vertebrate Paleontology Collection\t\t\t",
"UVSC\ts\tUtah Valley State College, Biology Department\t\t\t",
"UVST\ts\tSouthwest Texas Junior College, Biology Department\t\t\t",
"UVV\ts\tUniversita di Venezia, Dipartimento de Scienze Ambientali\t\t\t",
"UW\ts\tUniversity of Washington Fish Collection\t\t\t",
"UWA\ts\tUniversity of Western Australia, Botany Department\t\t\t",
"UWAL\ts\tUniversity of West Alabama\t\t\t",
"UWBM\ts\tUniversity of Washington, Burke Museum\t\t\t",
"UWBM:HERP\ts\tUniversity of Washington, Burke Museum, Herpetology Collection\t\t",
"UWBM:Mamm\ts\tUniversity of Washington, Burke Museum, Burke Museum's mammal collection\t\t",
"UWBM:ORN\ts\tUniversity of Washington, Burke Museum, Ornithology Collection\t\t",
"UWC\ts\tUniversity of the Western Cape, Botany Department\t\t\t",
"UWCC<USA-WA>\tc\tUniversity of Washington Culture Collection\t\t\t",
"UWCP\ts\tUniversity of Wroclaw\t\t\t",
"UWEC\ts\tUniversity of Wisconsin, Department of Biology\t\t\t",
"UWFC\ts\tUniversity of Washington Burke Museum Fish\t\t\t",
"UWFC:Ichthyology\ts\tUniversity of Washington Burke Museum Fish, Ichthyology Collection\t\t",
"UWFP\ts\tUniversity of West Florida, Department of Biology\t\t\t",
"UWGB\ts\tUniversity of Wisconsin-Green Bay, MAC 212\t\t\t",
"UWI\ts\tUniversity of the West Indies (Trinidad and Tobago)\t\t\t",
"UWIC\ts\tUniversity of the West Indies, Trinidad and Tobago\t\t\t",
"UWIJ\ts\tUniversity of the West Indies, Jamaica\t\t\t",
"UWIZM\ts\tThe University of the West Indies Zoology Museum\t\t\t",
"UWJ\ts\tUniversity of Wisconsin, Biology Department\t\t\t",
"UWL\ts\tUniversity of Wisconsin, Biology Department\t\t\t",
"UWM\ts\tUniversity of Wisconsin, Biological Sciences Department\t\t\t",
"UWM<POL>\ts\tUniversity of Warmia and Mazury in Olsztyn\t\t\t",
"UWMA\ts\tUniversity of Wisconsin, Milwaukee, Department of Anthropology\t\t\t",
"UWMIL\ts\tUniversity of Wisconsin, Milwaukee, Department of Biological Sciences\t\t\t",
"UWO\tsc\tUniversity of Western Ontario\t\t\t",
"UWOC\ts\tUniversity of Western Ontario\t\t\t",
"UWP\ts\tUniversity of Wrocklaw\t\t\t",
"UWPG\ts\tUniversity of Winnipeg, Biology Department\t\t\t",
"UWSP\ts\tUniversity of Wisconsin-Stevens Point,\t\t\t",
"UWW\ts\tUniversity of Wisconsin - Whitewater, Biological Sciences Department\t\t\t",
"UWYMV\ts\tUniversity of Wyoming Museum of Vertebrates\t\t\t",
"UWYMV:Bird\ts\tUniversity of Wyoming Museum of Vertebrates, Bird Collection\t\t",
"UWYMV:Fish\ts\tUniversity of Wyoming Museum of Vertebrates, Fish Collection\t\t",
"UWYMV:Herp\ts\tUniversity of Wyoming Museum of Vertebrates, Herpetology Collection\t\t",
"UWYMV:Mamm\ts\tUniversity of Wyoming Museum of Vertebrates, Mammal Collection\t\t",
"UWZM\ts\tUniversity of Wisconsin, Zoological Museum\t\t\t",
"UYIC\ts\tInstituto de Biologia\t\t\t",
"UZ\ts\tHerbario de la Universidad de Zaragoza\t\t\t",
"UZA\ts\tUnidad de Zoologia Aplicada, Departamento de Ecologia\t\t\t",
"UZIU\ts\tUppsala University\t\t\t",
"UZL\ts\tUniversity of Zambia, Biological Sciences Department\t\t\t",
"UZMC\ts\tUniversidad del Zulia\t\t\t",
"UZMH\ts\tUniversity Museum (Zoology)\t\t\t",
"UZMO\ts\tZoologisk Museum\t\t\t",
"V\ts\tRoyal British Columbia Museum - Herbarium\tRBCM\t\t",
"VA\ts\tUniversity of Virginia\t\t\t",
"VAB\ts\tUniversitat de Valencia, Departamento de Biologia Vegetal\t\t\t",
"VAFS\ts\tVietnamese Academy of Forest Sciences\t\t\t",
"VAIC\ts\tVictorian Agricultural Insect Collection\t\t\t",
"VAL\tsb\tUniversitat de Valencia (Jardin Botanico de Valencia)\t\t\t",
"VALA\ts\tUniversidad Politecnica, Departamento de Botanica\t\t\t",
"VALD\ts\tUniversidad Austral de Chile, Instituto de Botanica\t\t\t",
"VALLE\ts\tUniversidad Nacional de Colombia, Departamento de Ciencias Basicas\t\t\t",
"VALPL\ts\tUniversidad de Playa Ancha, Departamento de Biologia y Quimica\t\t\t",
"VAN\ts\tSociete Polymathique du Morbihan\t\t\t",
"VANF\ts\tYuezuencue Yil University, Biology Section\t\t\t",
"VAS\ts\tVassar College, Biology Department\t\t\t",
"VBCCA\tc\tVisva-Bharati Culture Collection of Algae\t\t\t",
"VBCM\ts\tUniversidad Complutense de Madrid\t\t\t",
"VBGI\ts\tBotanical Garden-Institute\t\t\t",
"VBI\ts\tInstitute of Ecology and Botany of the Hungarian Academy of Sciences, Botanical Department\t\t\t",
"VCRC\tc\tVolcani Center Rhizobium Collection (VCRC)\t\t\t",
"VCU\ts\tVirginia Commonwealth University, Biology Department\t\t\t",
"VDAC\ts\tVirginia Department of Agriculture and Consumer Services\t\t\t",
"VDAM\ts\tInstitute of Plant Science\t\t\t",
"VDB\ts\tVanderbilt University, Department of Biological Sciences\t\t\t",
"VECTOR\tsc\tState Research Center of Virology and Biotechnology\t\t\t",
"VEN\ts\tHerbario Nacional de Venezuela, Instituto Experimental Jardin Botanico Dr. Tobias Lasser\t\t\t",
"VENDA\ts\tThohoyandou Botanical Gardens, Department of Agriculture, Land & Environment\t\t\t",
"VER\ts\tHerbario, Museo Civico di Storia Naturale, Verona\t\t\t",
"VETMED\ts\tUniversity of Veterinary Medicine\t\t\t",
"VF\ts\tUniversidad de Valencia, Departamento de Biologia Vegetal, Botanica\t\t\t",
"VFM\ts\tForest Inventory and Planning Institute\t\t\t",
"VFU\ts\tVietnam Forestry University\t\t\t",
"VFWD\ts\tVermont Fish and Wildlife Department\t\t\t",
"VFWO\ts\tU.S. Fish and Wildlife Service, Ventura Fish and Wildlife Office\t\t\t",
"VGBI\ts\tBotanical Garden-Institute Vladivostok\t\t\t",
"VGZ\ts\tVoronezh State Biosphere Reserve, Research Department\t\t\t",
"VH\ts\tVivekanand Arts Sardar Dalipsingh Commerce and Science College\t\t\t",
"VHS<AUS>\tc\tVegetation Health Service  ( Phytophthora cultures )\t\t\t",
"VI<NOR>\tc\tMykotektet, National Veterinary Institute\t\t\t",
"VI<SWE>\ts\tGotlands Fornsal\t\t\t",
"VIA\ts\tFONAIAP-CENIAP\t\t\t",
"VIAM\tc\tInstitute of Applied Microbiology, University of Agricultural Sciences\t\t\t",
"VIAY\ts\tVeterinarian Institute of Armenia, Botany Department\t\t\t",
"VIC\ts\tUniversidade Federal de Vicosa, Departamento de Biologia Vegetal\t\t\t",
"VICA\ts\tAgriculture Department\t\t\t",
"VICF\ts\tForestry Department\t\t\t",
"VICH\ts\tPlant Protection Department\t\t\t",
"VIES\ts\tFederal University of Espirito Santo\t\t\t",
"VIGG\ts\tVavilov Institute of General Genetics\t\t\t",
"VIL\ts\tUniversite de Paris-Sud\t\t\t",
"VIMS\ts\tVirginia Institute of Marine Science\t\t\t",
"VIST\ts\tUniversity of the Virgin Islands, Natural Resources Program\t\t\t",
"VIT\ts\tMuseo de Ciencias Naturales de Alava, Departamento de Botanica\t\t\t",
"VIZR\tc\tCollection for plant protection, All-Russian Institute of Plant Protection\t\t\t",
"VKM\tc\tAll-Russian Collection of Microorganisms\t\thttp://www.vkm.ru/strains.php?vkm=\t",
"VKPM\tc\tRussian National Collection of Industrial Microorganisms\t\t\t",
"VLA\ts\tFar Eastern Branch, Russian Academy of Sciences, Botany Department\t\t\t",
"VM\ts\tOkresni vlastivedne muzeum (Museum of the Moravian Wallachia region, state funded organisation)\t\t\t",
"VMI\ts\tVirginia Military Institute\t\t\t",
"VMIL\ts\tVirginia Military Institute, Biology Department\t\t\t",
"VMKSC\ts\tKearney State University, Vertebrate Museum\t\t\t",
"VMM\ts\tVanderbilt Marine Museum\t\t\t",
"VMNH\ts\tVirginia Museum of Natural History\t\t\t",
"VMSL\ts\tI.N.T.A., E.E.A. San Luis, Pastizales Naturales\t\t\t",
"VNC\ts\tLos Angeles Valley College, Life Sciences Department\t\t\t",
"VNF\ts\tVietnam Forestry Herbarium\t\t\t",
"VNGA\ts\tVorarlberger Naturschau\t\t\t",
"VNIRO\ts\tInstitute of Oceanography\t\t\t",
"VNM\ts\tInstitute of Tropical Biology\t\t\t",
"VNMN\ts\tVietnam National Museum of Nature\t\t\t",
"VOA\ts\tOstrobothnian Museum\t\t\t",
"VOR\ts\tVoronezh State University, Biology and Plant Ecology Department\t\t\t",
"VORB\ts\tBotanical Garden Dr. B.M. Kozo-Polyansky, Voronezh State University\t\t\t",
"VORG\ts\tVoronezh State University, Faculty of Geography and Geoecology\t\t\t",
"VPB\tc\tVeterinary Pathology and Bacteriology Collection\t\t\t",
"VPCI\tc\tFungal Culture Collection\t\t\t",
"VPH\ts\tVan Pharmaceutical Herbarium, Yuzuncu Yil University\t\t\t",
"VPI\tsc\tVirginia Polytechnic Institute and State University\tVTMH\t\t",
"VPI:F\ts\tVirginia Polytechnic Institute and State University, Fungal Collection\t",
"VPIC\ts\tVirginia Polytechnic Institute and State University\t\t\t",
"VPIMM\ts\tVirginia Polytechnic University, Mammal Museum\t\t\t",
"VPM\ts\tVolgograd Provincial Museum\t\t\t",
"VPRI\tc\tVictoria Department of Primary Industries, Plant Disease Herbarium\t\t\t",
"VRLI\tc\tDepartment of Virology\t\t\t",
"VSC\ts\tValdosta State University, Biology Department\t\t\t",
"VSC-L\ts\tLyndon State College, Mammal Collection\t\t\t",
"VSCA\ts\tVisayas State College of Agriculture\t\t\t",
"VSM<NOR>\ts\tDet Kgl. Norske Videnskabers Selskab Museet\t\t\t",
"VSM<SVK>\ts\tEastern Slovakian (Vychodoslovenske) Museum, Natural History Department\t\t\t",
"VSRI\ts\tN.I. Vavilov All-Russian Scientific Research Instiutte of Plant Industry\t\t\t",
"VSUH\ts\tVirginia State University, Life Sciences Department\t\t\t",
"VT\ts\tPringle Herbarium, University of Vermont\t\t\t",
"VTA\ts\tJardin Botanique de la Villa Thuret\t\t\t",
"VTB\tc\tBanco de Celulas Humanas e Animais Laboratorio de Patologia Celular e Molecular\t\t\t",
"VTCC\tc\tVietnam Type Culture Collection, Center of Biotechnology\t\t\t",
"VTMH\ts\tVirginia Tech Massey Herbarium\t\t\t",
"VTT\tc\tVTT Biotechnology, Culture Collection\t\t\t",
"VU\ts\tVoronezh State University\t\t\t",
"VU<NLD>\ts\tVrije Universiteit Amsterdam\t\t\t",
"VUT\tc\tSchool of Veterinary Medicine, Faculty of Agriculture\t\t\t",
"VUW\ts\tVictoria University\tVUWE\t\t",
"VUWE\ts\tVictoria University\t\t\t",
"VYH\tc\tFinnish Environment Institute (SYKE)\t\t\t",
"VYM\ts\tMuzeum Vyakovska\t\t\t",
"W\ts\tNaturhistorisches Museum Wien, Department of Botany\t\t\t",
"WA\ts\tHerbarium, Faculty of Biology, University of Warsaw\t\t\t",
"WAB\ts\tWabash College, Biological Sciences Department\t\t\t",
"WABG\ts\tUniversity of Warsaw Botanic Garden\t\t\t",
"WAC\tc\tDepartment of Agriculture Western Australia Plant Pathogen Collection\t\t\t",
"WACA<USA-AZ>\ts\tWalnut Canyon National Monument\t\t\t",
"WACA<USA-OR>\ts\tWork Amber Collection\t\t\t",
"WACC\tc\tWestern Australian Culture Collection\t\t\t",
"WADA\ts\tWestern Australia Department of Agriculture\t\t\t",
"WAG\ts\tWageningen University\t\t http://data.biodiversitydata.nl/naturalis/specimen/WAG\t",
"WAHO\ts\tInstitute of Horticultural Plant Breeding, Department of Biosystematics\t\t\t",
"WAI\ts\tWaimea Valley\t\t\t",
"WAIK\ts\tUniversity of Waikato, Biological Sciences Department\t\t\t",
"WAITE\tc\tInsect Pathology Pathogen Collection\t\t\t",
"WAL\tc\tWadsworth Anaerobe Laboratory, Wadsworth Hospital Center\t\t\t",
"WAM\ts\tWestern Australian Museum\t\t\t",
"WAM:Mamm\ts\tWestern Australian Museum, Mammal Collection\t\t",
"WAM:R\ts\tWestern Australian Museum, Reptile Collection\t\t",
"WAMP\ts\tWestern Australian Museum\t\t\t",
"WAN\ts\tForest Research Station\t\t\t",
"WANF\ts\tWasatch-Cache National Forest\t\t\t",
"WAPA\ts\tWar in the Pacific National Historical Park\t\t\t",
"WAR\ts\tWarwickshire Museum, Natural History Department\t\t\t",
"WARC\tc\tNew Zealand Reference Culture Collection\t\t\t",
"WARK\ts\tWestern Illinois University, Biology Department\t\t\t",
"WARM\ts\tCentral Missouri State University, Biology Department\t\t\t",
"WARMS\ts\tWarwickshire Museum, Natural History Department\t\t\t",
"WARS\ts\tWildlife Advisory and Research Service\t\t\t",
"WASH\ts\tWashburn University, Biology Department\t\t\t",
"WAT\ts\tUniversity of Waterloo, Biology Department\t\t\t",
"WAU\ts\tWau Ecology Institute\t\t\t",
"WAUF\ts\tWarsaw Agricultural University, Department of Plant Pathology\t\t\t",
"WAVI\ts\tColby College, Biology Department\t\t\t",
"WB<DEU>\ts\tUniversitat Wurzburg\t\t\t",
"WB<USA-WI>\tc\tDepartment of Bacteriology, University of Wisconsin\t\t\t",
"WBCH\ts\tWisbech and Fenland Museum\t\t\t",
"WBG\ts\tWaimea Botanical Garden\t\t\t",
"WBM\ts\tUniversitat Wurzburg\t\t\t",
"WBR\ts\tLaboratoire de Paleontologie, Unversite de Montpellier\t\t\t",
"WBS\ts\tLandbouwuniversiteit\t\t\t",
"WCE\ts\tUniversity of London, Westfield College, Biology Department\t\t\t",
"WCH\ts\tGreenwich Borough Museum\t\t\t",
"WCL\ts\tWillesden Borough Council\t\t\t",
"WCP\ts\tWalla Walla College, Biological Sciences Department\t\t\t",
"WCR\ts\tWinchester City Museum\t\t\t",
"WCRP\ts\tWinchester Public Library\t\t\t",
"WCSBG\ts\tWest China Subalpine Botanical Garden\t\t\t",
"WCSU\ts\tWestern Connecticut State University, Department of Biological and Environmental Sciences\t\t\t",
"WCU\ts\tWest China University of Medical Sciences\t\t\t",
"WCUH\ts\tWestern Carolina University, Department of Biology\t\t\t",
"WCUM\tc\tWorking Collection\t\t\t",
"WCUUM\ts\tWest China Union University\t\t\t",
"WCW\ts\tWhitman College, Department of Biology\t\t\t",
"WDds\tc\tRaul Lopez Sanchez\t\t\t",
"WDNE\ts\tBureau of Land Management, Winnemucca District\t\t\t",
"WECO\ts\tWesleyan University, Biology Department\t\t\t",
"WEIC\ts\tWau Ecology Institute\t\t\t",
"WELC\ts\tWellesley College, Biological Sciences Department\t\t\t",
"WELT\ts\tMuseum of New Zealand Te Papa Tongarewa\t\t\t",
"WELTU\ts\tVictoria University of Wellington\t\t\t",
"WERN\ts\tWerneth Park Study Centre and Natural History Museum\t\t\t",
"WET\ts\tWartburg College, Biology Department\t\t\t",
"WEWO\ts\tWeymouth Woods Sandhills Nature Preserve\t\t\t",
"WFBM\ts\tW.F. Barr Entomological Collection\t\t\t",
"WFBVA\ts\tFederal Forest Research Centre Vienna, Department of Vegetation Science\t\t\t",
"WFIS\ts\tWagner Free Institute of Science\t\t\t",
"WFPL\tc\tWestern Forest Products Laboratory\t\t\t",
"WFU\ts\tWake Forest University, Biology Department\t\t\t",
"WFUVC\ts\tWake Forest University, Vertebrate Collection\t\t\t",
"WGC\ts\tState University of West Georgia, Biology Department\t\t\t",
"WGCH\ts\tWilton Garden Club\t\t\t",
"WGD\ts\tWashington Game Department\t\t\t",
"WGMM\ts\tWoodspring Museum\t\t\t",
"WGRC\tb\tWheat Genetics Resource Center\t\t\t",
"WGRS\ts\tWestern Ghat Regional Station of the Zoological Survey of India at Calicut\t\t\t",
"WH\ts\tWuhan University\t\t\t",
"WHB\ts\tUniversitaet fuer Bodenkultur\t\t\t",
"WHIT\ts\tWhittier College, Biology Department\t\t\t",
"WHM\ts\tWest Highland Museum\t\t\t",
"WHN\ts\tWhitehaven Museum\t\t\t",
"WHOI\ts\tWoods Hole Oceanographic Institution\t\t\t",
"WHT\ts\tWildlife Heritage Trust\t\t\t",
"WHY\ts\tWhitby Museum\t\t\t",
"WHYNC\ts\tWhytby Naturalists' Club\t\t\t",
"WI\ts\tVilnius University, Botany and Genetics Department\t\t\t",
"WIAP\ts\tWistar Institute of Anatomy\t\t\t",
"WIB\ts\tMinistry of Environment and Parks, Resource Quality Section\t\t\t",
"WIBF\ts\tWest Indian Beetle Fauna Project Collection\t\t\t",
"WIBG\ts\tWindward Islands Banana Grower's Association\t\t\t",
"WICA\ts\tWind Cave National Park\t\t\t",
"WICH\ts\tWichita State University\t\t\t",
"WIES\ts\tMuseum Wiesbaden\t\t\t",
"WII\ts\tWildlife Institute of India, Department of Habitat Ecology\t\t\t",
"WILLI\ts\tThe College of William and Mary, Department of Biology\t\t\t",
"WILLU\ts\tWillamette University\t\t\t",
"WIN\ts\tUniversity of Manitoba, Botany Department\t\t\t",
"WINC\ts\tWaite Insect & Nematode Collection\t\t\t",
"WIND\ts\tNational Botanical Research Institute\t\t\t",
"WINDM\ts\tDelta Marsh Field Station (University of Manitoba)\t\t\t",
"WINF\ts\tForestry and Rural Developmen Department\t\t\t",
"WINFM\ts\tForestry and Rural Developmen Department\t\t\t",
"WINO\ts\tSaint Mary's College, Biology Department\t\t\t",
"WINU\ts\tWinthrop University\t\t\t",
"WIR\tsb\tN. I. Vavilov Institute of Plant Industry, Department of Introduction and Systematics\t\t\t",
"WIS\ts\tUniversity of Wisconsin, Botany Department\t\t\t",
"WIU\ts\tWestern Illinois University, Museum of Natural History\t\t\t",
"WIUC\ts\tWestern Illinois University\t\t\t",
"WJC\ts\tWilliam Jewell College, Biology Department\t\t\t",
"WKD\ts\tWakefield Museum\t\t\t",
"WKDS\ts\tWakefield Grammar School\t\t\t",
"WKSU\ts\tWestern Kentucky State University\t\t\t",
"WKU\ts\tWestern Kentucky University, Department of Biology\t\t\t",
"WL\ts\tWolong Nature Reserve\t\t\t",
"WLH\ts\tWilberforce Library\t\t\t",
"WLK\ts\tBritish Columbia Ministry of Forests\t\t\t",
"WLMH\ts\tWest Lake Musuem\t\t\t",
"WLU\ts\tWilfrid Laurier University, Biology Department\t\t\t",
"WM\ts\tGezira Research Station\t\t\t",
"WMGC\ts\tGordon College, Biology Department\t\t\t",
"WMM\ts\tWitte Memorial Museum\t\t\t",
"WMNH\ts\tWakayama Prefectural Museum of Natural History\t\t\t",
"WMS\ts\tWakes Museum\t\t\t",
"WMU\ts\tWestern Michigan University, Biological Sciences Department\t\t\t",
"WMW\ts\tVestry House Museum\t\t\t",
"WNC\ts\tUniversity of North Carolina Wilmington, Department of Biology and Marine Biology\t\t\t",
"WNHM\ts\tOklahoma Baptist University, Webster Natural History Museum\t\t\t",
"WNLM\ts\tNiederoesterreichisches Landesmuseum\t\t\t",
"WNMU\ts\tWestern New Mexico University Museum\t\t\t",
"WNMU:Bird\ts\tWestern New Mexico University Museum, bird collection\t\t",
"WNMU:Fish\ts\tWestern New Mexico University Museum, Fish Collection\t\t",
"WNMU:Mamm\ts\tWestern New Mexico University Museum, mammal collection\t\t",
"WNRE\ts\tWhiteshell Nuclear Research Establishment\t\t\t",
"WNS\ts\tWiesbaden Naturwissenschaftliche Sammlung der Stadt\t\t\t",
"WNU\ts\tNorthwest University, Biology Department\t\t\t",
"WOCB\ts\tUniversity of Windsor, Biological Sciences Department\t\t\t",
"WOCSB\tb\tWheeler Orchid Collection and Species Bank\t\t\t",
"WOH\ts\tSouthwestern Oklahoma State University, Biology Department\t\t\t",
"WOLL\ts\tUniversity of Wollongong, Department of Biological Sciences\t\t\t",
"WOS\ts\tCity Museum and Art Gallery\t\t\t",
"WOSNH\ts\tWorcestershire Natural History Society Museum\t\t\t",
"WPBS\tc\tWPBS Rhizobium Collection\t\t\t",
"WPC\tcb\tWorld Phytophthora Genetic Resource Collection\t\t\t",
"WPH\ts\tWaterton Lakes National Park\t\t\t",
"WPL\ts\tWhitechapel Museum\t\t\t",
"WPMM\ts\tState Museum of Pennsylvania\t\t\t",
"WRC<JPN>\tb\tWildlife Research Center of Kyoto University\t\t\t",
"WRHM\ts\tInstitute of Terrestrial Ecology\t\t\t",
"WRL\tc\tThe Wellcome Bacterial Collection\t\t\t",
"WRN\ts\tWarrington Museum and Art Gallery\t\t\t",
"WRNFC\ts\tWarrington Field Naturalists' Club\t\t\t",
"WRO\ts\tUniversity of Bristol, Long Ashton Research Station\t\t\t",
"WRSL\ts\tWroclaw University, Botany Department\t\t\t",
"WS\ts\tWashington State University\t\t\t",
"WSBC\ts\tWichita State University\t\t\t",
"WSBC<DEU>\tc\tResearch collection of Bacillus cereus group species\t\t\t",
"WSC\ts\tWestfield State College, Museum and Herbarium\t\t\t",
"WSCH\ts\tWestfield State College, Biology Department\t\t\t",
"WSCO\ts\tWeber State University, Botany Department\t\t\t",
"WSF\tc\tWisconsin Soil Fungi Collection\t\t\t",
"WSFA\ts\tWilmington College, Biology Department\t\t\t",
"WSL\tb\tSwiss Federal Institute for Forest, Snow and Landscape Research\t\t\t",
"WSLC\tc\tResearch collection of Listeria (Weihenstephan Microbial Strain Collection)\t\t\t",
"WSM\ts\tWeston-super-Mare Museum and Art Gallery\t\t\t",
"WSM<AUS>\tc\tWestern Australian Soil Microbiology culture collection, Murdoch. University\t\t\t",
"WSNM\ts\tWhite Sands National Monument\t\t\t",
"WSP\ts\tWashington State University, Plant Pathology Department\t\t\t",
"WSRP\ts\tUniversity of Podlasie, Botany Department\t\t\t",
"WSU<USA-UT>\ts\tWeber State University, Bird and Mammal Collection\t\t\t",
"WSU<USA-WA>\ts\tWashington State University\t\t\t",
"WSUMNH\ts\tWayne State University, Museum of Natural History\t\t\t",
"WSY\ts\tRoyal Horticultural Society Garden Wisley\t\t\t",
"WTR\ts\tWinchester College, Biology Department\t\t\t",
"WTS\ts\tWest Texas A&M University, Department of Life, Earth and Environmental Sciences\t\t\t",
"WTSU\ts\tWest Texas A&M University, Natural History Collection\t\t\t",
"WTU\ts\tUniversity of Washington\t\t\t",
"WTU:F\ts\tUniversity of Washington, Fungal Collection\t\t",
"WTUH\ts\tUniversity of Washington Botanic Gardens, College of Forest Resources\t\t\t",
"WU\ts\tUniversitat Wien\t\t\t",
"WU<USA-TX>\ts\tWayland University\t\t\t",
"WUD\ts\tWayne State University, Biological Sciences Department\t\t\t",
"WUH\ts\tWuhu School of Traditional Chinese Medicine\t\t\t",
"WUK\ts\tNorthwestern Institute of Botany\t\t\t",
"WUM\ts\tUniversity of Witwatersrand\t\t\t",
"WUME\ts\tWillamette University\t\t\t",
"WUP\ts\tDepartment of Pharmacognosy, Universitat Wien\t\t\t",
"WVA\ts\tWest Virginia University, Biology Department\t\t\t",
"WVBS\ts\tWest Virginia Biological Survey\t\t\t",
"WVDH\tc\tWest Virginia Hygienic Laboratory\t\t\t",
"WVHP\ts\tWest Virginia Division of Natural Resources\t\t\t",
"WVIT\ts\tWest Virginia University, Biology Department\t\t\t",
"WVMS\ts\tMarshall University, West Virginia Mammal Survey\t\t\t",
"WVN\ts\tWhitehaven Scientific Association\t\t\t",
"WVUC\ts\tWest Virginia University\t\t\t",
"WVW\ts\tWest Virginia Wesleyan College, Biology Department\t\t\t",
"WWB\ts\tWestern Washington University, Biology Department\t\t\t",
"WWC\ts\tWarren Wilson College\t\t\t",
"WWF\ts\tWelder Wildlife Foundation\t\t\t",
"WWM\ts\tWerner Wildlife Museum\t\t\t",
"WWSP\ts\tWeymouth Woods Sandhills Nature Preserve\t\t\t",
"WXDC\ts\tWanxian Institute of Drug Control\t\t\t",
"WXM\ts\tNorth East Wales Institute, Department of Natural Science\t\t\t",
"WYAC\ts\tUniversity of Wyoming, Range Ecology and Watershed Management Department\t\t\t",
"WYCO\ts\tWytheville Community College, Biology Department\t\t\t",
"WYE\ts\tUniversity of London, Wye College\t\t\t",
"XAG\ts\tXinjiang Academy of Animal Sciences\t\t\t",
"XAL\ts\tInstituto de Ecologia, A.C.\t\t\t",
"XALU\ts\tUniversidad Veracruzana\t\t\t",
"XBGH\ts\tXian Botanical Garden\t\t\t",
"XCH\ts\tSt. Xavier's College, Botany Department\t\t\t",
"XFCFC\ts\tXiamen Fisheries College\t\t\t",
"XIAS\ts\tXichang Agricultural School\t\t\t",
"XIN\ts\tSouthwestern Guizhou Institute of Forestry\t\t\t",
"XJA\ts\tXinjiang Agricultural University\t\t\t",
"XJBI\ts\tXinjiang Institute of Ecology and Geography\t\t\t",
"XJDC\ts\tXinjiang Institute for Drug Control\t\t\t",
"XJFA\ts\tXinjiang Academy of Forestry Sciences\t\t\t",
"XJNU\ts\tXinjiang Normal University, Biology Department\t\t\t",
"XJU\ts\tXinjiang University, Biology Department\t\t\t",
"XJUG\ts\tXinjiang University, Geography Department\t\t\t",
"XM\ts\tXinjiang Medical College, Pharmacy Department\t\t\t",
"XMU\ts\tXiamen University\t\t\t",
"XNC\ts\tDepartment of Biology, Xinxiang Normal College\t\t\t",
"XOLO\ts\tHerbario de Plantas Utiles Efraim Hernandez X., Universidad Autonoma Chapingo\t\t\t",
"XTNM\ts\tXinjiang Institute of Traditional Chinese and Minorities Medicine\t\t\t",
"XUM\ts\tHope Department of Entomology\t\t\t",
"XYTC\ts\tXinyang Teachers College, Biology Department\t\t\t",
"XZ\ts\tTibet Plateau Institute of Biology\t\t\t",
"XZDC\ts\tTibet Institute for Drug Control\t\t\t",
"XZE\ts\tResearch Institute of Xizang Plateau Ecology\t\t\t",
"XZTC\ts\tXuzhou Teachers College, Biology Department\t\t\t",
"Y\ts\tYale University, Samuel Jones Record Memorial Collection\t\t\t",
"YA\ts\tNational Herbarium of Cameroon\t\t\t",
"YAAS\ts\tHerbarium of Yunnan Academy of Agricultural Sciences, Kunming, China\t\t\t",
"YAF\ts\tYunnan Academy of Forestry\t\t\t",
"YAI\ts\tArmenian Agricultural Academy, Botany Department\t\t\t",
"YAK\ts\tForest Survey and Design Institute\t\t\t",
"YALT\ts\tThe State Nikita Botanical Gardens, Flora and Vegetation\t\t\t",
"YAM\ts\tYamaguchi University, Plant Pathology Department\t\t\t",
"YAMA\ts\tYamagata Prefectural Museum\t\t\t",
"YAR\ts\tYaroslavl State University, Department of Biology and Ecology\t\t\t",
"YBDC\ts\tYibin Institute for Drug Control\t\t\t",
"YBI\ts\tInstitut National pour l'Etude et la Recherche Agronomique, Departement de Botanique\t\t\t",
"YBLF\tc\tYamanouchi Pharmaceutical Co., Ltd.\t\t\t",
"YBU\ts\tYibin University, College of Life Science and Food Engineering\t\t\t",
"YCE\ts\tYunnan College of Education, Biology Department\t\t\t",
"YCH\ts\tYavapai College, Biology Department\t\t\t",
"YCM\ts\tYokosuka City Museum\t\t\t",
"YCP\ts\tYunnan Laboratory for Conservation of Rare, Endangered & Endemic Forest Plants, State Forestry Administration\t\t\t",
"YDC\ts\tYunnan Institute for Drug Control\t\t\t",
"YELLO\ts\tYellowstone National Park\t\t\t",
"YEO\ts\tYeovil Museum\t\t\t",
"YF\ts\tYanbei Forestry Institute\t\t\t",
"YFS\ts\tYunnan Forestry School\t\t\t",
"YFTC\ts\tYale Fish Tissue Collection\t\t\t",
"YH\ts\tLutheran College\t\t\t",
"YHB<CAN>\ts\tYukon Heritage Resources Unit, Paleontology Program\tYHB\t\t",
"YIM\tc\tYunnan Institute of Microbiology\t\t\t",
"YIM<herbarium>\ts\tYunnan Institute of Pharmacology\t\t\t",
"YIO\ts\tYamashina Institute for Ornithology\t\t\t",
"YK\ts\tBootham School\t\t\t",
"YKN\ts\tYorkshire Naturalists' Trust Limited\t\t\t",
"YL\ts\tNorthwest Sci-tech University of Agriculture and Forestry\t\t\t",
"YLD\ts\tYulin Institute of Desert Control Research\t\t\t",
"YM<CHN>\tc\tStrains Collection of Yunnan Institute of Microbiology, Yunnan University, China\t\t\t",
"YM<GBR>\ts\tYork Museum\t\t\t",
"YM<USA-CA>\ts\tNational Park Service, Yosemite National Park\t\t\t",
"YMF\ts\tKey Laboratory of Industrial Microbiology & Fermentation Technology\t\t\t",
"YMUK\ts\tThe Yorkshire Museum\t\t\t",
"YNP\ts\tThe Yosemite Museum\t\t\t",
"YNTCEM\ts\tYunnan University of Traditional Chinese Medicine and Ethnomedicine\t\t\t",
"YNU\ts\tYokohama National University\t\t\t",
"YNUB\ts\tYunnan Normal University, Biology Department\t\t\t",
"YNUGI\ts\tYokohama National University - Geological Institute\t\t\t",
"YNUH\ts\tYeungnam University, Biology Department\t\t\t",
"YOLA\ts\tMari State University, Department of Plant Biology\t\t\t",
"YPM\ts\tYale Peabody Museum of Natural History\t\t\t",
"YPM/PU\ts\tPrinceton University Collection in Yale Peabody Museum\t\t\t",
"YPM:ENT\ts\tYale Peabody Museum of Natural History, Entomology Collection\thttp://peabody.research.yale.edu/cgi-bin/Query.Ledger?LE=ent&ID=",
"YPM:HER\ts\tYale Peabody Museum of Natural History, Herpetology Collection\thttp://peabody.research.yale.edu/cgi-bin/Query.Ledger?LE=her&ID=",
"YPM:ICH\ts\tYale Peabody Museum of Natural History, Ichthyology Collection\thttp://peabody.research.yale.edu/cgi-bin/Query.Ledger?LE=ich&ID=",
"YPM:IZ\ts\tYale Peabody Museum of Natural History, Invertebrate Zoology Collection\thttp://peabody.research.yale.edu/cgi-bin/Query.Ledger?LE=iz&ID=",
"YPM:MAM\ts\tYale Peabody Museum of Natural History, Mammology Collection\thttp://peabody.research.yale.edu/cgi-bin/Query.Ledger?LE=mam&ID=",
"YPM:ORN\ts\tYale Peabody Museum of Natural History, Ornithology Collection\thttp://peabody.research.yale.edu/cgi-bin/Query.Ledger?LE=orn&ID=",
"YPM:VP\ts\tYale Peabody Museum of Natural History, Vertebrate Paleontology\t\t",
"YPMC\ts\tYellowstone National Park\t\t\t",
"YRK\ts\tYorkshire Museum, Biology Department\t\t\t",
"YSU\ts\tThe Yugra State University Biological Collections\t\t\t",
"YU<CHN>\ts\tYunnan University\t\t\t",
"YU<JOR>\ts\tDepartment of Earth and Environmental Sciences, Yarmouk University\t\t\t",
"YU<USA-CT>\ts\tYale University, Botany Division\t\t\t",
"YUC\ts\tINIREB\t\t\t",
"YUKU\ts\tYunnan University, Biology Department\t\t\t",
"YUO\ts\tYoungstown State University, Biological Sciences Department\t\t\t",
"YUTO\ts\tYork University, Biology Department\t\t\t",
"YUZM\ts\tYasouj University Zoological Museum\t\t\t",
"YXDC\ts\tYuxi District Institute for Drug Control\t\t\t",
"YZU\ts\tYuzhou University\t\t\t",
"Z\tsb\tInstitut fur Systematische Botanik Universitat Zurich\t\t\t",
"ZA\ts\tUniversity of Zagreb, Botany Department\tZAHO\t\t",
"ZAD\ts\tMount Makulu Research Station\t\t\t",
"ZAGR\ts\tUniversity of Zagreb\t\t\t",
"ZAHO\ts\tUniversity of Zagreb, Botany Department\tZA\t\t",
"ZAR\ts\tInstitut de Paleontologie du Museum National Historie Naturelle\t\t\t",
"ZAU\ts\tZhejiang Agricultural University\t\t\t",
"ZAUC\ts\tZhejian Agricultural University\t\t\t",
"ZBMM\ts\tMaharaja's College, Zoology and Botany Museum\t\t\t",
"ZCA\ts\tZhelimu College of Animal Husbandry, Range Science Department\t\t\t",
"ZCM\ts\tShetland Museum\t\t\t",
"ZCU\ts\tThe Genetic bank of the Department of Zoology, Charles University\t\t\t",
"ZDC\ts\tZhejiang Institute for Drug Control\t\t\t",
"ZDEU\ts\tZoological collection of the Department of  Biology\t\t\t",
"ZDKU\ts\tKharkiv National University\t\t\t",
"ZDM\ts\tZigong dinosaur Museum\t\t\t",
"ZEA\ts\tUniversidad de Guadalajara, Centro Universitario de la Costa Sur, Departamento de Ecologia y Recursos Naturales\t\t\t",
"ZFMK\tsb\tZoologisches Forschungsmuseum Alexander Koenig\t\t\t",
"ZFMK:COL\ts\tZoologisches Forschungsmuseum Alexander Koenig, Coleoptera collection\t\t",
"ZFMK:FSJF\ts\tZoologisches Forschungsmuseum Alexander Koenig, fish collection of Jeorg Freyhof\t\t",
"ZFMK:ICH\ts\tZoologisches Forschungsmuseum Alexander Koenig, Ichthyological Collection\t\t",
"ZFSN\ts\tLaboratoire de Zoologie de la Faculte Des Sciences\t\t\t",
"ZGLC\ts\tNatural History Museum, Limassol\t\t\t",
"ZHAN\ts\tZhanjiang Teachers College, Biology Department\t\t\t",
"ZhM\ts\tZhejinag Museum\t\t\t",
"ZHR\ts\tZhiguli State Nature Reserve\t\t\t",
"ZIA\ts\tNational Academy of Sciences of Armenia\t\t\t",
"ZIAN\ts\tZoological Institute, Academy of Sciences\t\t\t",
"ZICUP\ts\tZoological Institute Charles University\t\t\t",
"ZIHU\ts\tHiroshima University, Zoological Institute\t\t\t",
"ZIK\ts\tUkrainian Academy of Sciences, Zoological Institute\t\t\t",
"ZIKU\ts\tZoological Institute, Kochi University\t\t\t",
"ZIL\ts\tAcademy of Sciences, Zoological Institute\t\t\t",
"ZIM\tc\tZIM Culture Collection of Industrial Microorganisms\t\t\t",
"ZIN\ts\tZoological Institute of the Russian Academy of Sciences\tZISP\t\t",
"ZIS\ts\tUniversitaet Saarbruecken\t\t\t",
"ZISB\ts\tInstitute of Zoology\t\t\t",
"ZISP\ts\tZoological Institute, Russian Academy of Sciences\tIN,ZIN\t\t",
"ZIT\ts\tGrusinian Academy of Sciences\t\t\t",
"ZITIU\ts\tZoological Institute, Tokyo Imperial University\t\t\t",
"ZIUG\ts\tZoologisches Institut\t\t\t",
"ZIUL\ts\tZoologisches Institut der Universitaet\t\t\t",
"ZIUN\ts\tUniversita DI Napoli\t\t\t",
"ZIUS<AUT>\ts\tZoologisches Institute der Universitat\t\t\t",
"ZIUS<SWE>\ts\tZoologiska Institutionen\t\t\t",
"ZIUT\ts\tDepartment of Zoology, Faculty of Science, University of Tokyo\t\t\t",
"ZIUU\ts\tUppsala Universitet, Zoologiska Museum\t\t\t",
"ZIUW\ts\tUniversitaet Wien, Zoologisches Institut\t\t\t",
"ZIUZ\ts\tZagreb University\t\t\t",
"ZJFC\ts\tZhejiang Forestry College, Forestry Department\t\t\t",
"ZJFI\ts\tZhejiang Forestry Institute, Bamboo Department\t\t\t",
"ZJMA\ts\tZhejiang Academy of Medical Sciences\t\t\t",
"ZJU\tb\tZhejiang University College of Sciences\t\t\t",
"ZLMU\ts\tMeijo University\t\t\t",
"ZLSYU\ts\tZoological Laboratory\t\t\t",
"ZLVG\tc\tCulture collection of the Laboratory of Forest Protection at the Slovenian Forestry Institute\t\t\t",
"ZM\ts\tZhejiang Museum of Natural History\t\t\t",
"ZMA\ts\tUniversiteit van Amsterdam, Zoologisch Museum\t\t\t",
"ZMA:MOL\ts\tUniversiteit van Amsterdam, Zoologisch Museum, Mollusc collection\thttp://data.biodiversitydata.nl/naturalis/specimen/ZMA.MOL.",
"ZMA:POR\ts\tUniversiteit van Amsterdam, Zoologisch Museum, Porifera collection\t\t",
"ZMAN\ts\tInstituut voor Taxonomische Zoologie, Zoologisch Museum\t\t\t",
"ZMAU\ts\tZoological Museum Andhra University\t\t\t",
"ZMB\ts\tMuseum Fur Naturkunde Berlin\tZMHU\t\t",
"ZMB:Bryozoa\ts\tMuseum Fur Naturkunde Berlin, Bryozoa Collection\t\t",
"ZMB:Cnidaria\ts\tMuseum Fur Naturkunde Berlin, Cnidaria Collection\t\t",
"ZMB:Crustacea\ts\tMuseum Fur Naturkunde Berlin, Crustacea Collection\t\t",
"ZMB:Echinodermata\ts\tMuseum Fur Naturkunde Berlin, Echinodermata Collection\t\t",
"ZMB:Hydrozoa\ts\tMuseum Fur Naturkunde Berlin, Hydrozoa Collection\t\t",
"ZMB:Mammal\ts\tMuseum Fur Naturkunde Berlin, Mammal collection\t\t",
"ZMB:Porifera\ts\tMuseum Fur Naturkunde Berlin, Porifera Collection\t\t",
"ZMB:Vermes\ts\tMuseum Fur Naturkunde Berlin, Vermes Collection\t\t",
"ZMBJ\ts\tBanding Zoological Museum\t\t\t",
"ZMBN\ts\tMuseum of Zoology at the University of Bergen, Invertebrate Collection\tBMBN\t\t",
"ZMC\ts\tDeptment of Biology, Zunyi Medical College\t\t\t",
"ZMFMIB\ts\tZoologial Museum Fan Memorial Institute of Biology\t\t\t",
"ZMG<DEU-Gottingen>\ts\tZoologisches Museum der Universitat Gottingen\t\t\t",
"ZMG<DEU-Gottingen>:Crustacea\ts\tZoologisches Museum der Universitat Gottingen, Crustacea Collection\t\t",
"ZMG<DEU-Greifswald>\ts\tZoologischen Museums Greifswald\t\t\t",
"ZMH\ts\tZoologisches Museum Hamburg\t\t\t",
"ZMHB\ts\tMuseum fur Naturkunde der Humboldt-Universitat\tMNB\t\t",
"ZMHU\ts\tZoologisches Museum der Humboldt Universitaet\t\t\t",
"ZMJU\ts\tZoological Museum, Jagiellonian University\t\t\t",
"ZMK<DEU>\ts\tZoologisches Museum der Universitat Kiel\t\t\t",
"ZMK<DNK>\ts\tZoological Museum, Copenhagen\t\t\t",
"ZMK<NOR>\ts\tZoological Musem, Kristiania\t\t\t",
"ZMKR\ts\tKoenigsberg Zoologisches Museum\t\t\t",
"ZMKU\ts\tKiev Zoological Museum\t\t\t",
"ZMKU<THA>\ts\tZoological Museum, Kasetsart University\t\t\t",
"ZMKU<THA>:R\ts\tZoological Museum, Kasetsart University, Reptile collection\t\t",
"ZML\ts\tSt Petersburg State University\t\t\t",
"ZMLP\ts\tUniversity of Punjab\t\t\t",
"ZMLU\ts\tLunds Universitet, Zoologiska Institutionen\t\t\t",
"ZMMGU\ts\tZoological Museum\t\t\t",
"ZMMU\ts\tZoological Museum, Moscow Lomonosov State University\tZMM,ZMUM\t\t",
"ZMMU:Birds\ts\tZoological Museum, Moscow Lomonosov State University, Bird Collection\t\t",
"ZMMU:Fishes\ts\tZoological Museum, Moscow Lomonosov State University, Fishes Collection\t\t",
"ZMMU:Herps\ts\tZoological Museum, Moscow Lomonosov State University, Ampibia and Reptilia Collection\t\t",
"ZMMU:Insects\ts\tZoological Museum, Moscow Lomonosov State University, Insects Collection\t\t",
"ZMMU:Invertebrates\ts\tZoological Museum, Moscow Lomonosov State University, Invertebrates Collection\t\t",
"ZMMU:Mamm\ts\tZoological Museum, Moscow Lomonosov State University, Mammal Collection\t\t",
"ZMNH\ts\tZhejiang Museum of Natural History\t\t\t",
"ZMO\ts\tZoology Museum, Oxford University\t\t\t",
"ZMS\ts\tZentralmuseum Senckenberg (SENCKENBERG world of biodiversity)\t\t\t",
"ZMSZ\ts\tZemaljski Mujski\t\t\t",
"ZMT<CZE>\ts\tZapadomoravske muzeum v Trebici\t\t\t",
"ZMT<GEO>\ts\tGeorgian State Museum, Zoological Section\t\t\t",
"ZMTAU\ts\tThe Steinhardt Museum of Natural History\t\t\t",
"ZMU\ts\tZhejiang Medical University, Pharmacy Department\t\t\t",
"ZMUA<CHN>\ts\tZooligal Museum, University of Amoy\t\t\t",
"ZMUA<GRC>\ts\tZoological Museum, University of Athens\t\t\t",
"ZMUAS\ts\tZoological Museum Ukrainian Academy of Sciences\t\t\t",
"ZMUB\ts\tMuseum of Zoology at the University of Bergen\t\t\t",
"ZMUB:BIRD\ts\tMuseum of Zoology at the University of Bergen, Bird collection\t\t",
"ZMUB:HERP\ts\tMuseum of Zoology at the University of Bergen, Herptile collection\t\t",
"ZMUB:ICHT\ts\tMuseum of Zoology at the University of Bergen, Fish Collections\t\t",
"ZMUB:MAMM\ts\tMuseum of Zoology at the University of Bergen, Mammal collection\t\t",
"ZMUC\tsb\tZoological Museum, University of Copenhagen\t\t\t",
"ZMUC:AVES\ts\tZoological Museum, University of Copenhagen, Aves collection\t\t",
"ZMUC:Fisk\ts\tZoological Museum, University of Copenhagen, Fish Collection\t\t",
"ZMUC:R\ts\tZoological Museum, University of Copenhagen, Amphibians and Reptiles collection\t\t",
"ZMUD\ts\tUniversity of Dhaka, Zoology Museum\t\t\t",
"ZMUH<DEU>\ts\tZoologisches Institut und Zoologisches Museum, Universitat Hamburg\t\t\t",
"ZMUH<VNM>\ts\tZoological Museum, University of Hanoi\t\t\t",
"ZMUI\ts\tZoological Museum, University of Istanbul\t\t\t",
"ZMUL\ts\tUniversitetets Lund, Zoologiska Museet\t\t\t",
"ZMUN\ts\tZoology, Natural History Museum, University of Oslo\t\t\t",
"ZMUO<FIN>\ts\tUniversity of Oulu Zoological Museum\t\t\t",
"ZMUO<NOR>\ts\tUniversitetets I Oslo, Zoologisk Museum\t\t\t",
"ZMUP\ts\tZoological Museum of the University of Patras\t\t\t",
"ZMUT\ts\tUniversity of Tokyo, Department of Zoology\t\t\t",
"ZMUU\ts\tUppsala Universitet, Zoologiska Museet\t\t\t",
"ZMUZ\ts\tZoologisches Museum der Universitat Zurich\t\t\t",
"ZNG\ts\tBulent Ecevit University\t\t\t",
"ZNM\ts\tZhejiang Natural Museum\t\t\t",
"ZNP\ts\tZion National Park\t\t\t",
"ZNPC\ts\tSpringdale, Zion National Park\t\t\t",
"ZNU\ts\tZhejiang Normal University, Biology Department\t\t\t",
"ZOM\ts\tHerbarium, Department of Agriculture, Malawi\t\t\t",
"ZPAL\ts\tZoological Institute of Paleobiology, Polish Academy of Sciences\t\t\t",
"ZPB\ts\tInstitute of Conservation and Natural History of the Soutpansberg\t\t\t",
"ZRC\ts\tZoological Reference Collection, National University of Singapore\t\t\t",
"ZSBS\ts\tZoologische Sammlung des Bayerischen Staates\t\t\t",
"ZSI\ts\t Zoological Survey of India\t\t\t",
"ZSI-CRS\ts\tZoological Survey of India, Central Regional Station\t\t\t",
"ZSI-E\ts\tZoological Survey of India\t\t\t",
"ZSI-M\ts\tZoological Survey of India\t\t\t",
"ZSI-NRS\ts\tZoological Survey of India\t\t\t",
"ZSI-SRS\ts\tZoological Survey of India, Southern Regional Station\t\t\t",
"ZSI-WRS\ts\tZoological Survey of India\t\t\t",
"ZSIC\ts\tZoological Survey of India\t\t\t",
"ZSLC\ts\tZoological Society of London\t\t\t",
"ZSM\tsb\tZoologische Staatssammlung Munchen\tZSMH\t\t",
"ZSM:Lep\ts\tZoologische Staatssammlung Munchen, Lepidoptera\t\t",
"ZSM:Mol\ts\tZoologische Staatssammlung Munchen, Mollusca\t\t",
"ZSMC\ts\tZoologische Staatssammlung\t\t\t",
"ZSP<PAK>\ts\tZoological Survey of Pakistan\t\t\t",
"ZSP<USA-PA>\ts\tZoological Society of Philadelphia\t\t\t",
"ZSS\ts\tSukkulenten-Sammlung Zuerich\t\t\t",
"ZT\ts\tEidgenossische Technische Hochschule Zurich\t\t\t",
"ZTNH\ts\tUniversity of Vermont, Zadock Thompson Natural History Collections\t\t\t",
"ZTS\ts\tInstitute of Nature Conservation, Polish Academy of Sciences, Tatra Field Station\t\t\t",
"ZUAB\ts\tZoologia--Universidad Autonoma de Barcelona\t\t\t",
"ZUAC\ts\tUniversity of Antananarivo\t\t\t",
"ZUEC\ts\tMuseu de Zoologia da Universidade Estadual de Campinas\t\t\t",
"ZUEC:AMP\ts\tMuseu de Zoologia da Universidade Estadual de Campinas, Amphibian collection\t\t",
"ZUEC:AVE\ts\tMuseu de Zoologia da Universidade Estadual de Campinas, Birds collection\t\t",
"ZUEC:MAM\ts\tMuseu de Zoologia da Universidade Estadual de Campinas, Mammal collection\t\t",
"ZUEC:PIS\ts\tMuseu de Zoologia da Universidade Estadual de Campinas, Fish collection\t\t",
"ZUEC:REP\ts\tMuseu de Zoologia da Universidade Estadual de Campinas, \t\t",
"ZUFES\ts\tUniversidad Federal do Espirito Santo\t\t\t",
"ZUFRJ\ts\tDepartamento de Zoolgia, Instituto de Biologia\t\t\t",
"ZUFSM<BRA>\ts\tUniversidade Federal de Santa Maria, Laboratorio de Herpetologia\t\t\t",
"ZULU\ts\tUniversity of Zululand, Botany Department\t\t\t",
"ZUMT\ts\tDepartment of Zoology, University Museum\tUMUTZ\t\t",
"ZUTC\ts\tZoological Museum University of Tehran\t\t\t",
"ZV\ts\tTechnical University, Department of Phytology\t\t\t",
"ZVC\ts\tDepto. de Zoologia Vertebrados de la Facultad de Humanidades y Ciencias\t\t\t",
"ZVCB<URY>\ts\tVertebrate Collection, Facultad de Ciencias, Universidad de la Republica\t\t\t",
"ZY\ts\tZunyi Normal College\t\t\t",
"ZYTC\ts\tZhangye Teachers College, Chemistry-Biology Department\t\t\t",
"ZZN\tc\tZavod za naravoslovje\t\t\t",
"ZZSZ\ts\tZoology Department, Faculty of Natural Sciences, University of Zagreb\t\t\t"
};
