/*  $Id: sequtil_tables.cpp 159695 2009-05-07 18:12:25Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Mati Shomrat
 *
 * File Description:
 *   Shared utility functions for the various sequtil classes.
 */  

#include <ncbi_pch.hpp>
#include "sequtil_tables.hpp"

BEGIN_NCBI_SCOPE
/////////////////////////////////////////////////////////////////////////////
//
// Conversion Tables

// IUPACna to IUPACna
const Uint1 CIupacnaToIupacna::scm_Table[256] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x41, 0x42, 0x43, 0x44, 0xff, 0xff, 0x47,
    0x48, 0xff, 0xff, 0x4b, 0xff, 0x4d, 0x4e, 0xff,
    0xff, 0xff, 0x52, 0x53, 0x54, 0x54, 0x56, 0x57,
    0xff, 0x59, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x41, 0x42, 0x43, 0x44, 0xff, 0xff, 0x47,
    0x48, 0xff, 0xff, 0x4b, 0xff, 0x4d, 0x4e, 0xff,
    0xff, 0xff, 0x52, 0x53, 0x54, 0x54, 0x56, 0x57,
    0xff, 0x59, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// IUPACna to NCBI2na
// A -> 0x0 A
// B -> 0x1 C
// C -> 0x1 C
// D -> 0x2 G
// G -> 0x2 G
// H -> 0x0 A
// K -> 0x2 G
// M -> 0x1 C
// N -> 0x0 A
// R -> 0x2 G
// S -> 0x1 C
// T -> 0x3 T
// V -> 0x0 A
// W -> 0x3 T
// Y -> 0x3 T
// U -> 0x3 T
const Uint1 CIupacnaTo2na::scm_Table[1024] = {
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x00, 0x00, 0x00, 0x00,
    0x40, 0x10, 0x04, 0x01,
    0x40, 0x10, 0x04, 0x01,
    0x80, 0x20, 0x08, 0x02,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x80, 0x20, 0x08, 0x02,
    0x00, 0x00, 0x00, 0x00,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x80, 0x20, 0x08, 0x02,
    0xc0, 0x30, 0x0c, 0x03,
    0x40, 0x10, 0x04, 0x01,
    0x00, 0x00, 0x00, 0x00,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x80, 0x20, 0x08, 0x02,
    0x40, 0x10, 0x04, 0x01,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x00, 0x00, 0x00, 0x00,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x00, 0x00, 0x00, 0x00,
    0x40, 0x10, 0x04, 0x01,
    0x40, 0x10, 0x04, 0x01,
    0x80, 0x20, 0x08, 0x02,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x80, 0x20, 0x08, 0x02,
    0x00, 0x00, 0x00, 0x00,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x80, 0x20, 0x08, 0x02,
    0xc0, 0x30, 0x0c, 0x03,
    0x40, 0x10, 0x04, 0x01,
    0x00, 0x00, 0x00, 0x00,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x80, 0x20, 0x08, 0x02,
    0x40, 0x10, 0x04, 0x01,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0x00, 0x00, 0x00, 0x00,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03,
    0xc0, 0x30, 0x0c, 0x03
};


// IUPACna to NCBI2na_expand
const Uint1 CIupacnaTo2naExpand::scm_Table[256] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x1, 0x1, 0x2, 0xff, 0xff, 0x2,
    0x0, 0xff, 0xff, 0x2, 0xff, 0x1, 0x0, 0xff,
    0xff, 0xff, 0x2, 0x1, 0x3, 0x3, 0x0, 0x3,
    0xff, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x1, 0x1, 0x2, 0xff, 0xff, 0x2,
    0x0, 0xff, 0xff, 0x2, 0xff, 0x1, 0x0, 0xff,
    0xff, 0xff, 0x2, 0x1, 0x3, 0x3, 0x0, 0x3,
    0xff, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// IUPACna to NCBI4na
const Uint1 CIupacnaTo4na::scm_Table[512] = {
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0x10,0x1,  0xe0,0xe,  0x20,0x2,
    0xd0,0xd,  0xf0,0xf,  0xf0,0xf,  0x40,0x4,
    0xb0,0xb,  0xf0,0xf,  0xf0,0xf,  0xc0,0xc,
    0xf0,0xf,  0x30,0x3,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0x50,0x5,  0x60,0x6,
    0x80,0x8,  0x80,0x8,  0x70,0x7,  0x90,0x9,
    0xf0,0xf,  0xa0,0xa,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0x10,0x1,  0xe0,0xe,  0x20,0x2,
    0xd0,0xd,  0xf0,0xf,  0xf0,0xf,  0x40,0x4,
    0xb0,0xb,  0xf0,0xf,  0xf0,0xf,  0xc0,0xc,
    0xf0,0xf,  0x30,0x3,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0x50,0x5,  0x60,0x6,
    0x80,0x8,  0x80,0x8,  0x70,0x7,  0x90,0x9,
    0xf0,0xf,  0xa0,0xa,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf,
    0xf0,0xf,  0xf0,0xf,  0xf0,0xf,  0xf0,0xf
};


// IUPACna to NCBI8na
const Uint1 CIupacnaTo8na::scm_Table[256] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x1, 0xe, 0x2, 0xd, 0xff, 0xff, 0x4,
    0xb, 0xff, 0xff, 0xc, 0xff, 0x3, 0xf, 0xff,
    0xff, 0xff, 0x5, 0x6, 0x8, 0x8, 0x7, 0x9,
    0xff, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x1, 0xe, 0x2, 0xd, 0xff, 0xff, 0x4,
    0xb, 0xff, 0xff, 0xc, 0xff, 0x3, 0xf, 0xff,
    0xff, 0xff, 0x5, 0x6, 0x8, 0x8, 0x7, 0x9,
    0xff, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBI2na to IUPACna
const Uint1 C2naToIupacna::scm_Table[1024] = {
    0x41, 0x41, 0x41, 0x41,    0x41, 0x41, 0x41, 0x43,
    0x41, 0x41, 0x41, 0x47,    0x41, 0x41, 0x41, 0x54,
    0x41, 0x41, 0x43, 0x41,    0x41, 0x41, 0x43, 0x43,
    0x41, 0x41, 0x43, 0x47,    0x41, 0x41, 0x43, 0x54,
    0x41, 0x41, 0x47, 0x41,    0x41, 0x41, 0x47, 0x43,
    0x41, 0x41, 0x47, 0x47,    0x41, 0x41, 0x47, 0x54,
    0x41, 0x41, 0x54, 0x41,    0x41, 0x41, 0x54, 0x43,
    0x41, 0x41, 0x54, 0x47,    0x41, 0x41, 0x54, 0x54,
    0x41, 0x43, 0x41, 0x41,    0x41, 0x43, 0x41, 0x43,
    0x41, 0x43, 0x41, 0x47,    0x41, 0x43, 0x41, 0x54,
    0x41, 0x43, 0x43, 0x41,    0x41, 0x43, 0x43, 0x43,
    0x41, 0x43, 0x43, 0x47,    0x41, 0x43, 0x43, 0x54,
    0x41, 0x43, 0x47, 0x41,    0x41, 0x43, 0x47, 0x43,
    0x41, 0x43, 0x47, 0x47,    0x41, 0x43, 0x47, 0x54,
    0x41, 0x43, 0x54, 0x41,    0x41, 0x43, 0x54, 0x43,
    0x41, 0x43, 0x54, 0x47,    0x41, 0x43, 0x54, 0x54,
    0x41, 0x47, 0x41, 0x41,    0x41, 0x47, 0x41, 0x43,
    0x41, 0x47, 0x41, 0x47,    0x41, 0x47, 0x41, 0x54,
    0x41, 0x47, 0x43, 0x41,    0x41, 0x47, 0x43, 0x43,
    0x41, 0x47, 0x43, 0x47,    0x41, 0x47, 0x43, 0x54,
    0x41, 0x47, 0x47, 0x41,    0x41, 0x47, 0x47, 0x43,
    0x41, 0x47, 0x47, 0x47,    0x41, 0x47, 0x47, 0x54,
    0x41, 0x47, 0x54, 0x41,    0x41, 0x47, 0x54, 0x43,
    0x41, 0x47, 0x54, 0x47,    0x41, 0x47, 0x54, 0x54,
    0x41, 0x54, 0x41, 0x41,    0x41, 0x54, 0x41, 0x43,
    0x41, 0x54, 0x41, 0x47,    0x41, 0x54, 0x41, 0x54,
    0x41, 0x54, 0x43, 0x41,    0x41, 0x54, 0x43, 0x43,
    0x41, 0x54, 0x43, 0x47,    0x41, 0x54, 0x43, 0x54,
    0x41, 0x54, 0x47, 0x41,    0x41, 0x54, 0x47, 0x43,
    0x41, 0x54, 0x47, 0x47,    0x41, 0x54, 0x47, 0x54,
    0x41, 0x54, 0x54, 0x41,    0x41, 0x54, 0x54, 0x43,
    0x41, 0x54, 0x54, 0x47,    0x41, 0x54, 0x54, 0x54,
    0x43, 0x41, 0x41, 0x41,    0x43, 0x41, 0x41, 0x43,
    0x43, 0x41, 0x41, 0x47,    0x43, 0x41, 0x41, 0x54,
    0x43, 0x41, 0x43, 0x41,    0x43, 0x41, 0x43, 0x43,
    0x43, 0x41, 0x43, 0x47,    0x43, 0x41, 0x43, 0x54,
    0x43, 0x41, 0x47, 0x41,    0x43, 0x41, 0x47, 0x43,
    0x43, 0x41, 0x47, 0x47,    0x43, 0x41, 0x47, 0x54,
    0x43, 0x41, 0x54, 0x41,    0x43, 0x41, 0x54, 0x43,
    0x43, 0x41, 0x54, 0x47,    0x43, 0x41, 0x54, 0x54,
    0x43, 0x43, 0x41, 0x41,    0x43, 0x43, 0x41, 0x43,
    0x43, 0x43, 0x41, 0x47,    0x43, 0x43, 0x41, 0x54,
    0x43, 0x43, 0x43, 0x41,    0x43, 0x43, 0x43, 0x43,
    0x43, 0x43, 0x43, 0x47,    0x43, 0x43, 0x43, 0x54,
    0x43, 0x43, 0x47, 0x41,    0x43, 0x43, 0x47, 0x43,
    0x43, 0x43, 0x47, 0x47,    0x43, 0x43, 0x47, 0x54,
    0x43, 0x43, 0x54, 0x41,    0x43, 0x43, 0x54, 0x43,
    0x43, 0x43, 0x54, 0x47,    0x43, 0x43, 0x54, 0x54,
    0x43, 0x47, 0x41, 0x41,    0x43, 0x47, 0x41, 0x43,
    0x43, 0x47, 0x41, 0x47,    0x43, 0x47, 0x41, 0x54,
    0x43, 0x47, 0x43, 0x41,    0x43, 0x47, 0x43, 0x43,
    0x43, 0x47, 0x43, 0x47,    0x43, 0x47, 0x43, 0x54,
    0x43, 0x47, 0x47, 0x41,    0x43, 0x47, 0x47, 0x43,
    0x43, 0x47, 0x47, 0x47,    0x43, 0x47, 0x47, 0x54,
    0x43, 0x47, 0x54, 0x41,    0x43, 0x47, 0x54, 0x43,
    0x43, 0x47, 0x54, 0x47,    0x43, 0x47, 0x54, 0x54,
    0x43, 0x54, 0x41, 0x41,    0x43, 0x54, 0x41, 0x43,
    0x43, 0x54, 0x41, 0x47,    0x43, 0x54, 0x41, 0x54,
    0x43, 0x54, 0x43, 0x41,    0x43, 0x54, 0x43, 0x43,
    0x43, 0x54, 0x43, 0x47,    0x43, 0x54, 0x43, 0x54,
    0x43, 0x54, 0x47, 0x41,    0x43, 0x54, 0x47, 0x43,
    0x43, 0x54, 0x47, 0x47,    0x43, 0x54, 0x47, 0x54,
    0x43, 0x54, 0x54, 0x41,    0x43, 0x54, 0x54, 0x43,
    0x43, 0x54, 0x54, 0x47,    0x43, 0x54, 0x54, 0x54,
    0x47, 0x41, 0x41, 0x41,    0x47, 0x41, 0x41, 0x43,
    0x47, 0x41, 0x41, 0x47,    0x47, 0x41, 0x41, 0x54,
    0x47, 0x41, 0x43, 0x41,    0x47, 0x41, 0x43, 0x43,
    0x47, 0x41, 0x43, 0x47,    0x47, 0x41, 0x43, 0x54,
    0x47, 0x41, 0x47, 0x41,    0x47, 0x41, 0x47, 0x43,
    0x47, 0x41, 0x47, 0x47,    0x47, 0x41, 0x47, 0x54,
    0x47, 0x41, 0x54, 0x41,    0x47, 0x41, 0x54, 0x43,
    0x47, 0x41, 0x54, 0x47,    0x47, 0x41, 0x54, 0x54,
    0x47, 0x43, 0x41, 0x41,    0x47, 0x43, 0x41, 0x43,
    0x47, 0x43, 0x41, 0x47,    0x47, 0x43, 0x41, 0x54,
    0x47, 0x43, 0x43, 0x41,    0x47, 0x43, 0x43, 0x43,
    0x47, 0x43, 0x43, 0x47,    0x47, 0x43, 0x43, 0x54,
    0x47, 0x43, 0x47, 0x41,    0x47, 0x43, 0x47, 0x43,
    0x47, 0x43, 0x47, 0x47,    0x47, 0x43, 0x47, 0x54,
    0x47, 0x43, 0x54, 0x41,    0x47, 0x43, 0x54, 0x43,
    0x47, 0x43, 0x54, 0x47,    0x47, 0x43, 0x54, 0x54,
    0x47, 0x47, 0x41, 0x41,    0x47, 0x47, 0x41, 0x43,
    0x47, 0x47, 0x41, 0x47,    0x47, 0x47, 0x41, 0x54,
    0x47, 0x47, 0x43, 0x41,    0x47, 0x47, 0x43, 0x43,
    0x47, 0x47, 0x43, 0x47,    0x47, 0x47, 0x43, 0x54,
    0x47, 0x47, 0x47, 0x41,    0x47, 0x47, 0x47, 0x43,
    0x47, 0x47, 0x47, 0x47,    0x47, 0x47, 0x47, 0x54,
    0x47, 0x47, 0x54, 0x41,    0x47, 0x47, 0x54, 0x43,
    0x47, 0x47, 0x54, 0x47,    0x47, 0x47, 0x54, 0x54,
    0x47, 0x54, 0x41, 0x41,    0x47, 0x54, 0x41, 0x43,
    0x47, 0x54, 0x41, 0x47,    0x47, 0x54, 0x41, 0x54,
    0x47, 0x54, 0x43, 0x41,    0x47, 0x54, 0x43, 0x43,
    0x47, 0x54, 0x43, 0x47,    0x47, 0x54, 0x43, 0x54,
    0x47, 0x54, 0x47, 0x41,    0x47, 0x54, 0x47, 0x43,
    0x47, 0x54, 0x47, 0x47,    0x47, 0x54, 0x47, 0x54,
    0x47, 0x54, 0x54, 0x41,    0x47, 0x54, 0x54, 0x43,
    0x47, 0x54, 0x54, 0x47,    0x47, 0x54, 0x54, 0x54,
    0x54, 0x41, 0x41, 0x41,    0x54, 0x41, 0x41, 0x43,
    0x54, 0x41, 0x41, 0x47,    0x54, 0x41, 0x41, 0x54,
    0x54, 0x41, 0x43, 0x41,    0x54, 0x41, 0x43, 0x43,
    0x54, 0x41, 0x43, 0x47,    0x54, 0x41, 0x43, 0x54,
    0x54, 0x41, 0x47, 0x41,    0x54, 0x41, 0x47, 0x43,
    0x54, 0x41, 0x47, 0x47,    0x54, 0x41, 0x47, 0x54,
    0x54, 0x41, 0x54, 0x41,    0x54, 0x41, 0x54, 0x43,
    0x54, 0x41, 0x54, 0x47,    0x54, 0x41, 0x54, 0x54,
    0x54, 0x43, 0x41, 0x41,    0x54, 0x43, 0x41, 0x43,
    0x54, 0x43, 0x41, 0x47,    0x54, 0x43, 0x41, 0x54,
    0x54, 0x43, 0x43, 0x41,    0x54, 0x43, 0x43, 0x43,
    0x54, 0x43, 0x43, 0x47,    0x54, 0x43, 0x43, 0x54,
    0x54, 0x43, 0x47, 0x41,    0x54, 0x43, 0x47, 0x43,
    0x54, 0x43, 0x47, 0x47,    0x54, 0x43, 0x47, 0x54,
    0x54, 0x43, 0x54, 0x41,    0x54, 0x43, 0x54, 0x43,
    0x54, 0x43, 0x54, 0x47,    0x54, 0x43, 0x54, 0x54,
    0x54, 0x47, 0x41, 0x41,    0x54, 0x47, 0x41, 0x43,
    0x54, 0x47, 0x41, 0x47,    0x54, 0x47, 0x41, 0x54,
    0x54, 0x47, 0x43, 0x41,    0x54, 0x47, 0x43, 0x43,
    0x54, 0x47, 0x43, 0x47,    0x54, 0x47, 0x43, 0x54,
    0x54, 0x47, 0x47, 0x41,    0x54, 0x47, 0x47, 0x43,
    0x54, 0x47, 0x47, 0x47,    0x54, 0x47, 0x47, 0x54,
    0x54, 0x47, 0x54, 0x41,    0x54, 0x47, 0x54, 0x43,
    0x54, 0x47, 0x54, 0x47,    0x54, 0x47, 0x54, 0x54,
    0x54, 0x54, 0x41, 0x41,    0x54, 0x54, 0x41, 0x43,
    0x54, 0x54, 0x41, 0x47,    0x54, 0x54, 0x41, 0x54,
    0x54, 0x54, 0x43, 0x41,    0x54, 0x54, 0x43, 0x43,
    0x54, 0x54, 0x43, 0x47,    0x54, 0x54, 0x43, 0x54,
    0x54, 0x54, 0x47, 0x41,    0x54, 0x54, 0x47, 0x43,
    0x54, 0x54, 0x47, 0x47,    0x54, 0x54, 0x47, 0x54,
    0x54, 0x54, 0x54, 0x41,    0x54, 0x54, 0x54, 0x43,
    0x54, 0x54, 0x54, 0x47,    0x54, 0x54, 0x54, 0x54
};


// NCBI2na to NCBI2na_expand
//
//for ( bases[0] = 0; bases[0] < 4; ++bases[0] ) {
//        for ( bases[1] = 0; bases[1] < 4; ++bases[1] ) {
//            for ( bases[2] = 0; bases[2] < 4; ++bases[2] ) {
//                for ( bases[3] = 0; bases[3] < 4; ++bases[3] ) {
//                    Uint1 index =  (bases[0] << 6) | (bases[1] << 4) |
//                                   (bases[2] << 2) | bases[3];
//                    for ( int i = 0; i < 4; ++i ) {
//                        s_Table[index*4 + i] = bases[i];
//                    }
//                }
//            }
//        }
//    }
//
const Uint1 C2naTo2naExpand::scm_Table[1024] = {
    0x0, 0x0, 0x0, 0x0,    0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x2,    0x0, 0x0, 0x0, 0x3,
    0x0, 0x0, 0x1, 0x0,    0x0, 0x0, 0x1, 0x1,
    0x0, 0x0, 0x1, 0x2,    0x0, 0x0, 0x1, 0x3,
    0x0, 0x0, 0x2, 0x0,    0x0, 0x0, 0x2, 0x1,
    0x0, 0x0, 0x2, 0x2,    0x0, 0x0, 0x2, 0x3,
    0x0, 0x0, 0x3, 0x0,    0x0, 0x0, 0x3, 0x1,
    0x0, 0x0, 0x3, 0x2,    0x0, 0x0, 0x3, 0x3,
    0x0, 0x1, 0x0, 0x0,    0x0, 0x1, 0x0, 0x1,
    0x0, 0x1, 0x0, 0x2,    0x0, 0x1, 0x0, 0x3,
    0x0, 0x1, 0x1, 0x0,    0x0, 0x1, 0x1, 0x1,
    0x0, 0x1, 0x1, 0x2,    0x0, 0x1, 0x1, 0x3,
    0x0, 0x1, 0x2, 0x0,    0x0, 0x1, 0x2, 0x1,
    0x0, 0x1, 0x2, 0x2,    0x0, 0x1, 0x2, 0x3,
    0x0, 0x1, 0x3, 0x0,    0x0, 0x1, 0x3, 0x1,
    0x0, 0x1, 0x3, 0x2,    0x0, 0x1, 0x3, 0x3,
    0x0, 0x2, 0x0, 0x0,    0x0, 0x2, 0x0, 0x1,
    0x0, 0x2, 0x0, 0x2,    0x0, 0x2, 0x0, 0x3,
    0x0, 0x2, 0x1, 0x0,    0x0, 0x2, 0x1, 0x1,
    0x0, 0x2, 0x1, 0x2,    0x0, 0x2, 0x1, 0x3,
    0x0, 0x2, 0x2, 0x0,    0x0, 0x2, 0x2, 0x1,
    0x0, 0x2, 0x2, 0x2,    0x0, 0x2, 0x2, 0x3,
    0x0, 0x2, 0x3, 0x0,    0x0, 0x2, 0x3, 0x1,
    0x0, 0x2, 0x3, 0x2,    0x0, 0x2, 0x3, 0x3,
    0x0, 0x3, 0x0, 0x0,    0x0, 0x3, 0x0, 0x1,
    0x0, 0x3, 0x0, 0x2,    0x0, 0x3, 0x0, 0x3,
    0x0, 0x3, 0x1, 0x0,    0x0, 0x3, 0x1, 0x1,
    0x0, 0x3, 0x1, 0x2,    0x0, 0x3, 0x1, 0x3,
    0x0, 0x3, 0x2, 0x0,    0x0, 0x3, 0x2, 0x1,
    0x0, 0x3, 0x2, 0x2,    0x0, 0x3, 0x2, 0x3,
    0x0, 0x3, 0x3, 0x0,    0x0, 0x3, 0x3, 0x1,
    0x0, 0x3, 0x3, 0x2,    0x0, 0x3, 0x3, 0x3,
    0x1, 0x0, 0x0, 0x0,    0x1, 0x0, 0x0, 0x1,
    0x1, 0x0, 0x0, 0x2,    0x1, 0x0, 0x0, 0x3,
    0x1, 0x0, 0x1, 0x0,    0x1, 0x0, 0x1, 0x1,
    0x1, 0x0, 0x1, 0x2,    0x1, 0x0, 0x1, 0x3,
    0x1, 0x0, 0x2, 0x0,    0x1, 0x0, 0x2, 0x1,
    0x1, 0x0, 0x2, 0x2,    0x1, 0x0, 0x2, 0x3,
    0x1, 0x0, 0x3, 0x0,    0x1, 0x0, 0x3, 0x1,
    0x1, 0x0, 0x3, 0x2,    0x1, 0x0, 0x3, 0x3,
    0x1, 0x1, 0x0, 0x0,    0x1, 0x1, 0x0, 0x1,
    0x1, 0x1, 0x0, 0x2,    0x1, 0x1, 0x0, 0x3,
    0x1, 0x1, 0x1, 0x0,    0x1, 0x1, 0x1, 0x1,
    0x1, 0x1, 0x1, 0x2,    0x1, 0x1, 0x1, 0x3,
    0x1, 0x1, 0x2, 0x0,    0x1, 0x1, 0x2, 0x1,
    0x1, 0x1, 0x2, 0x2,    0x1, 0x1, 0x2, 0x3,
    0x1, 0x1, 0x3, 0x0,    0x1, 0x1, 0x3, 0x1,
    0x1, 0x1, 0x3, 0x2,    0x1, 0x1, 0x3, 0x3,
    0x1, 0x2, 0x0, 0x0,    0x1, 0x2, 0x0, 0x1,
    0x1, 0x2, 0x0, 0x2,    0x1, 0x2, 0x0, 0x3,
    0x1, 0x2, 0x1, 0x0,    0x1, 0x2, 0x1, 0x1,
    0x1, 0x2, 0x1, 0x2,    0x1, 0x2, 0x1, 0x3,
    0x1, 0x2, 0x2, 0x0,    0x1, 0x2, 0x2, 0x1,
    0x1, 0x2, 0x2, 0x2,    0x1, 0x2, 0x2, 0x3,
    0x1, 0x2, 0x3, 0x0,    0x1, 0x2, 0x3, 0x1,
    0x1, 0x2, 0x3, 0x2,    0x1, 0x2, 0x3, 0x3,
    0x1, 0x3, 0x0, 0x0,    0x1, 0x3, 0x0, 0x1,
    0x1, 0x3, 0x0, 0x2,    0x1, 0x3, 0x0, 0x3,
    0x1, 0x3, 0x1, 0x0,    0x1, 0x3, 0x1, 0x1,
    0x1, 0x3, 0x1, 0x2,    0x1, 0x3, 0x1, 0x3,
    0x1, 0x3, 0x2, 0x0,    0x1, 0x3, 0x2, 0x1,
    0x1, 0x3, 0x2, 0x2,    0x1, 0x3, 0x2, 0x3,
    0x1, 0x3, 0x3, 0x0,    0x1, 0x3, 0x3, 0x1,
    0x1, 0x3, 0x3, 0x2,    0x1, 0x3, 0x3, 0x3,
    0x2, 0x0, 0x0, 0x0,    0x2, 0x0, 0x0, 0x1,
    0x2, 0x0, 0x0, 0x2,    0x2, 0x0, 0x0, 0x3,
    0x2, 0x0, 0x1, 0x0,    0x2, 0x0, 0x1, 0x1,
    0x2, 0x0, 0x1, 0x2,    0x2, 0x0, 0x1, 0x3,
    0x2, 0x0, 0x2, 0x0,    0x2, 0x0, 0x2, 0x1,
    0x2, 0x0, 0x2, 0x2,    0x2, 0x0, 0x2, 0x3,
    0x2, 0x0, 0x3, 0x0,    0x2, 0x0, 0x3, 0x1,
    0x2, 0x0, 0x3, 0x2,    0x2, 0x0, 0x3, 0x3,
    0x2, 0x1, 0x0, 0x0,    0x2, 0x1, 0x0, 0x1,
    0x2, 0x1, 0x0, 0x2,    0x2, 0x1, 0x0, 0x3,
    0x2, 0x1, 0x1, 0x0,    0x2, 0x1, 0x1, 0x1,
    0x2, 0x1, 0x1, 0x2,    0x2, 0x1, 0x1, 0x3,
    0x2, 0x1, 0x2, 0x0,    0x2, 0x1, 0x2, 0x1,
    0x2, 0x1, 0x2, 0x2,    0x2, 0x1, 0x2, 0x3,
    0x2, 0x1, 0x3, 0x0,    0x2, 0x1, 0x3, 0x1,
    0x2, 0x1, 0x3, 0x2,    0x2, 0x1, 0x3, 0x3,
    0x2, 0x2, 0x0, 0x0,    0x2, 0x2, 0x0, 0x1,
    0x2, 0x2, 0x0, 0x2,    0x2, 0x2, 0x0, 0x3,
    0x2, 0x2, 0x1, 0x0,    0x2, 0x2, 0x1, 0x1,
    0x2, 0x2, 0x1, 0x2,    0x2, 0x2, 0x1, 0x3,
    0x2, 0x2, 0x2, 0x0,    0x2, 0x2, 0x2, 0x1,
    0x2, 0x2, 0x2, 0x2,    0x2, 0x2, 0x2, 0x3,
    0x2, 0x2, 0x3, 0x0,    0x2, 0x2, 0x3, 0x1,
    0x2, 0x2, 0x3, 0x2,    0x2, 0x2, 0x3, 0x3,
    0x2, 0x3, 0x0, 0x0,    0x2, 0x3, 0x0, 0x1,
    0x2, 0x3, 0x0, 0x2,    0x2, 0x3, 0x0, 0x3,
    0x2, 0x3, 0x1, 0x0,    0x2, 0x3, 0x1, 0x1,
    0x2, 0x3, 0x1, 0x2,    0x2, 0x3, 0x1, 0x3,
    0x2, 0x3, 0x2, 0x0,    0x2, 0x3, 0x2, 0x1,
    0x2, 0x3, 0x2, 0x2,    0x2, 0x3, 0x2, 0x3,
    0x2, 0x3, 0x3, 0x0,    0x2, 0x3, 0x3, 0x1,
    0x2, 0x3, 0x3, 0x2,    0x2, 0x3, 0x3, 0x3,
    0x3, 0x0, 0x0, 0x0,    0x3, 0x0, 0x0, 0x1,
    0x3, 0x0, 0x0, 0x2,    0x3, 0x0, 0x0, 0x3,
    0x3, 0x0, 0x1, 0x0,    0x3, 0x0, 0x1, 0x1,
    0x3, 0x0, 0x1, 0x2,    0x3, 0x0, 0x1, 0x3,
    0x3, 0x0, 0x2, 0x0,    0x3, 0x0, 0x2, 0x1,
    0x3, 0x0, 0x2, 0x2,    0x3, 0x0, 0x2, 0x3,
    0x3, 0x0, 0x3, 0x0,    0x3, 0x0, 0x3, 0x1,
    0x3, 0x0, 0x3, 0x2,    0x3, 0x0, 0x3, 0x3,
    0x3, 0x1, 0x0, 0x0,    0x3, 0x1, 0x0, 0x1,
    0x3, 0x1, 0x0, 0x2,    0x3, 0x1, 0x0, 0x3,
    0x3, 0x1, 0x1, 0x0,    0x3, 0x1, 0x1, 0x1,
    0x3, 0x1, 0x1, 0x2,    0x3, 0x1, 0x1, 0x3,
    0x3, 0x1, 0x2, 0x0,    0x3, 0x1, 0x2, 0x1,
    0x3, 0x1, 0x2, 0x2,    0x3, 0x1, 0x2, 0x3,
    0x3, 0x1, 0x3, 0x0,    0x3, 0x1, 0x3, 0x1,
    0x3, 0x1, 0x3, 0x2,    0x3, 0x1, 0x3, 0x3,
    0x3, 0x2, 0x0, 0x0,    0x3, 0x2, 0x0, 0x1,
    0x3, 0x2, 0x0, 0x2,    0x3, 0x2, 0x0, 0x3,
    0x3, 0x2, 0x1, 0x0,    0x3, 0x2, 0x1, 0x1,
    0x3, 0x2, 0x1, 0x2,    0x3, 0x2, 0x1, 0x3,
    0x3, 0x2, 0x2, 0x0,    0x3, 0x2, 0x2, 0x1,
    0x3, 0x2, 0x2, 0x2,    0x3, 0x2, 0x2, 0x3,
    0x3, 0x2, 0x3, 0x0,    0x3, 0x2, 0x3, 0x1,
    0x3, 0x2, 0x3, 0x2,    0x3, 0x2, 0x3, 0x3,
    0x3, 0x3, 0x0, 0x0,    0x3, 0x3, 0x0, 0x1,
    0x3, 0x3, 0x0, 0x2,    0x3, 0x3, 0x0, 0x3,
    0x3, 0x3, 0x1, 0x0,    0x3, 0x3, 0x1, 0x1,
    0x3, 0x3, 0x1, 0x2,    0x3, 0x3, 0x1, 0x3,
    0x3, 0x3, 0x2, 0x0,    0x3, 0x3, 0x2, 0x1,
    0x3, 0x3, 0x2, 0x2,    0x3, 0x3, 0x2, 0x3,
    0x3, 0x3, 0x3, 0x0,    0x3, 0x3, 0x3, 0x1,
    0x3, 0x3, 0x3, 0x2,    0x3, 0x3, 0x3, 0x3
};


// NCBI2na to NCBI4na
/*
    static Uint1 convert[4] = { 0x1, 0x2, 0x4, 0x8 };
    for ( base[0] = 0; base[0] < 4; ++base[0] ) {
        for ( base[1] = 0; base[1] < 4; ++base[1] ) {
            for ( base[2] = 0; base[2] < 4; ++base[2] ) {
                for ( base[3] = 0; base[3] < 4; ++base[3] ) {
                    Uint1 index =  (base[0] << 6) | (base[1] << 4) |
                                   (base[2] << 2) | base[3];
                    scm_Table0[index * 2] = 
                        (convert[base[0]] << 4) | convert[base[1]];
                    scm_Table0[index * 2 + 1] = 
                        (convert[base[2]] << 4) | convert[base[3]];
                }
            }
        }
    }
*/
const Uint1 C2naTo4na::scm_Table0[512] = {
    0x11, 0x11,    0x11, 0x12,    0x11, 0x14,    0x11, 0x18,
    0x11, 0x21,    0x11, 0x22,    0x11, 0x24,    0x11, 0x28,
    0x11, 0x41,    0x11, 0x42,    0x11, 0x44,    0x11, 0x48,
    0x11, 0x81,    0x11, 0x82,    0x11, 0x84,    0x11, 0x88,
    0x12, 0x11,    0x12, 0x12,    0x12, 0x14,    0x12, 0x18,
    0x12, 0x21,    0x12, 0x22,    0x12, 0x24,    0x12, 0x28,
    0x12, 0x41,    0x12, 0x42,    0x12, 0x44,    0x12, 0x48,
    0x12, 0x81,    0x12, 0x82,    0x12, 0x84,    0x12, 0x88,
    0x14, 0x11,    0x14, 0x12,    0x14, 0x14,    0x14, 0x18,
    0x14, 0x21,    0x14, 0x22,    0x14, 0x24,    0x14, 0x28,
    0x14, 0x41,    0x14, 0x42,    0x14, 0x44,    0x14, 0x48,
    0x14, 0x81,    0x14, 0x82,    0x14, 0x84,    0x14, 0x88,
    0x18, 0x11,    0x18, 0x12,    0x18, 0x14,    0x18, 0x18,
    0x18, 0x21,    0x18, 0x22,    0x18, 0x24,    0x18, 0x28,
    0x18, 0x41,    0x18, 0x42,    0x18, 0x44,    0x18, 0x48,
    0x18, 0x81,    0x18, 0x82,    0x18, 0x84,    0x18, 0x88,
    0x21, 0x11,    0x21, 0x12,    0x21, 0x14,    0x21, 0x18,
    0x21, 0x21,    0x21, 0x22,    0x21, 0x24,    0x21, 0x28,
    0x21, 0x41,    0x21, 0x42,    0x21, 0x44,    0x21, 0x48,
    0x21, 0x81,    0x21, 0x82,    0x21, 0x84,    0x21, 0x88,
    0x22, 0x11,    0x22, 0x12,    0x22, 0x14,    0x22, 0x18,
    0x22, 0x21,    0x22, 0x22,    0x22, 0x24,    0x22, 0x28,
    0x22, 0x41,    0x22, 0x42,    0x22, 0x44,    0x22, 0x48,
    0x22, 0x81,    0x22, 0x82,    0x22, 0x84,    0x22, 0x88,
    0x24, 0x11,    0x24, 0x12,    0x24, 0x14,    0x24, 0x18,
    0x24, 0x21,    0x24, 0x22,    0x24, 0x24,    0x24, 0x28,
    0x24, 0x41,    0x24, 0x42,    0x24, 0x44,    0x24, 0x48,
    0x24, 0x81,    0x24, 0x82,    0x24, 0x84,    0x24, 0x88,
    0x28, 0x11,    0x28, 0x12,    0x28, 0x14,    0x28, 0x18,
    0x28, 0x21,    0x28, 0x22,    0x28, 0x24,    0x28, 0x28,
    0x28, 0x41,    0x28, 0x42,    0x28, 0x44,    0x28, 0x48,
    0x28, 0x81,    0x28, 0x82,    0x28, 0x84,    0x28, 0x88,
    0x41, 0x11,    0x41, 0x12,    0x41, 0x14,    0x41, 0x18,
    0x41, 0x21,    0x41, 0x22,    0x41, 0x24,    0x41, 0x28,
    0x41, 0x41,    0x41, 0x42,    0x41, 0x44,    0x41, 0x48,
    0x41, 0x81,    0x41, 0x82,    0x41, 0x84,    0x41, 0x88,
    0x42, 0x11,    0x42, 0x12,    0x42, 0x14,    0x42, 0x18,
    0x42, 0x21,    0x42, 0x22,    0x42, 0x24,    0x42, 0x28,
    0x42, 0x41,    0x42, 0x42,    0x42, 0x44,    0x42, 0x48,
    0x42, 0x81,    0x42, 0x82,    0x42, 0x84,    0x42, 0x88,
    0x44, 0x11,    0x44, 0x12,    0x44, 0x14,    0x44, 0x18,
    0x44, 0x21,    0x44, 0x22,    0x44, 0x24,    0x44, 0x28,
    0x44, 0x41,    0x44, 0x42,    0x44, 0x44,    0x44, 0x48,
    0x44, 0x81,    0x44, 0x82,    0x44, 0x84,    0x44, 0x88,
    0x48, 0x11,    0x48, 0x12,    0x48, 0x14,    0x48, 0x18,
    0x48, 0x21,    0x48, 0x22,    0x48, 0x24,    0x48, 0x28,
    0x48, 0x41,    0x48, 0x42,    0x48, 0x44,    0x48, 0x48,
    0x48, 0x81,    0x48, 0x82,    0x48, 0x84,    0x48, 0x88,
    0x81, 0x11,    0x81, 0x12,    0x81, 0x14,    0x81, 0x18,
    0x81, 0x21,    0x81, 0x22,    0x81, 0x24,    0x81, 0x28,
    0x81, 0x41,    0x81, 0x42,    0x81, 0x44,    0x81, 0x48,
    0x81, 0x81,    0x81, 0x82,    0x81, 0x84,    0x81, 0x88,
    0x82, 0x11,    0x82, 0x12,    0x82, 0x14,    0x82, 0x18,
    0x82, 0x21,    0x82, 0x22,    0x82, 0x24,    0x82, 0x28,
    0x82, 0x41,    0x82, 0x42,    0x82, 0x44,    0x82, 0x48,
    0x82, 0x81,    0x82, 0x82,    0x82, 0x84,    0x82, 0x88,
    0x84, 0x11,    0x84, 0x12,    0x84, 0x14,    0x84, 0x18,
    0x84, 0x21,    0x84, 0x22,    0x84, 0x24,    0x84, 0x28,
    0x84, 0x41,    0x84, 0x42,    0x84, 0x44,    0x84, 0x48,
    0x84, 0x81,    0x84, 0x82,    0x84, 0x84,    0x84, 0x88,
    0x88, 0x11,    0x88, 0x12,    0x88, 0x14,    0x88, 0x18,
    0x88, 0x21,    0x88, 0x22,    0x88, 0x24,    0x88, 0x28,
    0x88, 0x41,    0x88, 0x42,    0x88, 0x44,    0x88, 0x48,
    0x88, 0x81,    0x88, 0x82,    0x88, 0x84,    0x88, 0x88
};

/*
    static Uint1 convert[4] = { 0x1, 0x2, 0x4, 0x8 };
    for ( base[0] = 0; base[0] < 4; ++base[0] ) {
        for ( base[1] = 0; base[1] < 4; ++base[1] ) {
            for ( base[2] = 0; base[2] < 4; ++base[2] ) {
                for ( base[3] = 0; base[3] < 4; ++base[3] ) {
                    Uint1 index =  (base[0] << 6) | (base[1] << 4) |
                                   (base[2] << 2) | base[3];
                    sm_TableOffset1[index * 3] = 
                        0x0F & convert[base[0]];
                    sm_TableOffset1[index * 3 + 1] =
                        (convert[base[1]] << 4) | convert[base[2]]; 
                    sm_TableOffset1[index * 3 + 2] = 
                        (convert[base[3]] << 4) & 0xF0;
                }
            }
        }
    }
*/
const Uint1 C2naTo4na::scm_Table1[768] = {
    0x1, 0x11, 0x10,  0x1, 0x11, 0x20,  0x1, 0x11, 0x40,  0x1, 0x11, 0x80,
    0x1, 0x12, 0x10,  0x1, 0x12, 0x20,  0x1, 0x12, 0x40,  0x1, 0x12, 0x80,
    0x1, 0x14, 0x10,  0x1, 0x14, 0x20,  0x1, 0x14, 0x40,  0x1, 0x14, 0x80,
    0x1, 0x18, 0x10,  0x1, 0x18, 0x20,  0x1, 0x18, 0x40,  0x1, 0x18, 0x80,
    0x1, 0x21, 0x10,  0x1, 0x21, 0x20,  0x1, 0x21, 0x40,  0x1, 0x21, 0x80,
    0x1, 0x22, 0x10,  0x1, 0x22, 0x20,  0x1, 0x22, 0x40,  0x1, 0x22, 0x80,
    0x1, 0x24, 0x10,  0x1, 0x24, 0x20,  0x1, 0x24, 0x40,  0x1, 0x24, 0x80,
    0x1, 0x28, 0x10,  0x1, 0x28, 0x20,  0x1, 0x28, 0x40,  0x1, 0x28, 0x80,
    0x1, 0x41, 0x10,  0x1, 0x41, 0x20,  0x1, 0x41, 0x40,  0x1, 0x41, 0x80,
    0x1, 0x42, 0x10,  0x1, 0x42, 0x20,  0x1, 0x42, 0x40,  0x1, 0x42, 0x80,
    0x1, 0x44, 0x10,  0x1, 0x44, 0x20,  0x1, 0x44, 0x40,  0x1, 0x44, 0x80,
    0x1, 0x48, 0x10,  0x1, 0x48, 0x20,  0x1, 0x48, 0x40,  0x1, 0x48, 0x80,
    0x1, 0x81, 0x10,  0x1, 0x81, 0x20,  0x1, 0x81, 0x40,  0x1, 0x81, 0x80,
    0x1, 0x82, 0x10,  0x1, 0x82, 0x20,  0x1, 0x82, 0x40,  0x1, 0x82, 0x80,
    0x1, 0x84, 0x10,  0x1, 0x84, 0x20,  0x1, 0x84, 0x40,  0x1, 0x84, 0x80,
    0x1, 0x88, 0x10,  0x1, 0x88, 0x20,  0x1, 0x88, 0x40,  0x1, 0x88, 0x80,
    0x2, 0x11, 0x10,  0x2, 0x11, 0x20,  0x2, 0x11, 0x40,  0x2, 0x11, 0x80,
    0x2, 0x12, 0x10,  0x2, 0x12, 0x20,  0x2, 0x12, 0x40,  0x2, 0x12, 0x80,
    0x2, 0x14, 0x10,  0x2, 0x14, 0x20,  0x2, 0x14, 0x40,  0x2, 0x14, 0x80,
    0x2, 0x18, 0x10,  0x2, 0x18, 0x20,  0x2, 0x18, 0x40,  0x2, 0x18, 0x80,
    0x2, 0x21, 0x10,  0x2, 0x21, 0x20,  0x2, 0x21, 0x40,  0x2, 0x21, 0x80,
    0x2, 0x22, 0x10,  0x2, 0x22, 0x20,  0x2, 0x22, 0x40,  0x2, 0x22, 0x80,
    0x2, 0x24, 0x10,  0x2, 0x24, 0x20,  0x2, 0x24, 0x40,  0x2, 0x24, 0x80,
    0x2, 0x28, 0x10,  0x2, 0x28, 0x20,  0x2, 0x28, 0x40,  0x2, 0x28, 0x80,
    0x2, 0x41, 0x10,  0x2, 0x41, 0x20,  0x2, 0x41, 0x40,  0x2, 0x41, 0x80,
    0x2, 0x42, 0x10,  0x2, 0x42, 0x20,  0x2, 0x42, 0x40,  0x2, 0x42, 0x80,
    0x2, 0x44, 0x10,  0x2, 0x44, 0x20,  0x2, 0x44, 0x40,  0x2, 0x44, 0x80,
    0x2, 0x48, 0x10,  0x2, 0x48, 0x20,  0x2, 0x48, 0x40,  0x2, 0x48, 0x80,
    0x2, 0x81, 0x10,  0x2, 0x81, 0x20,  0x2, 0x81, 0x40,  0x2, 0x81, 0x80,
    0x2, 0x82, 0x10,  0x2, 0x82, 0x20,  0x2, 0x82, 0x40,  0x2, 0x82, 0x80,
    0x2, 0x84, 0x10,  0x2, 0x84, 0x20,  0x2, 0x84, 0x40,  0x2, 0x84, 0x80,
    0x2, 0x88, 0x10,  0x2, 0x88, 0x20,  0x2, 0x88, 0x40,  0x2, 0x88, 0x80,
    0x4, 0x11, 0x10,  0x4, 0x11, 0x20,  0x4, 0x11, 0x40,  0x4, 0x11, 0x80,
    0x4, 0x12, 0x10,  0x4, 0x12, 0x20,  0x4, 0x12, 0x40,  0x4, 0x12, 0x80,
    0x4, 0x14, 0x10,  0x4, 0x14, 0x20,  0x4, 0x14, 0x40,  0x4, 0x14, 0x80,
    0x4, 0x18, 0x10,  0x4, 0x18, 0x20,  0x4, 0x18, 0x40,  0x4, 0x18, 0x80,
    0x4, 0x21, 0x10,  0x4, 0x21, 0x20,  0x4, 0x21, 0x40,  0x4, 0x21, 0x80,
    0x4, 0x22, 0x10,  0x4, 0x22, 0x20,  0x4, 0x22, 0x40,  0x4, 0x22, 0x80,
    0x4, 0x24, 0x10,  0x4, 0x24, 0x20,  0x4, 0x24, 0x40,  0x4, 0x24, 0x80,
    0x4, 0x28, 0x10,  0x4, 0x28, 0x20,  0x4, 0x28, 0x40,  0x4, 0x28, 0x80,
    0x4, 0x41, 0x10,  0x4, 0x41, 0x20,  0x4, 0x41, 0x40,  0x4, 0x41, 0x80,
    0x4, 0x42, 0x10,  0x4, 0x42, 0x20,  0x4, 0x42, 0x40,  0x4, 0x42, 0x80,
    0x4, 0x44, 0x10,  0x4, 0x44, 0x20,  0x4, 0x44, 0x40,  0x4, 0x44, 0x80,
    0x4, 0x48, 0x10,  0x4, 0x48, 0x20,  0x4, 0x48, 0x40,  0x4, 0x48, 0x80,
    0x4, 0x81, 0x10,  0x4, 0x81, 0x20,  0x4, 0x81, 0x40,  0x4, 0x81, 0x80,
    0x4, 0x82, 0x10,  0x4, 0x82, 0x20,  0x4, 0x82, 0x40,  0x4, 0x82, 0x80,
    0x4, 0x84, 0x10,  0x4, 0x84, 0x20,  0x4, 0x84, 0x40,  0x4, 0x84, 0x80,
    0x4, 0x88, 0x10,  0x4, 0x88, 0x20,  0x4, 0x88, 0x40,  0x4, 0x88, 0x80,
    0x8, 0x11, 0x10,  0x8, 0x11, 0x20,  0x8, 0x11, 0x40,  0x8, 0x11, 0x80,
    0x8, 0x12, 0x10,  0x8, 0x12, 0x20,  0x8, 0x12, 0x40,  0x8, 0x12, 0x80,
    0x8, 0x14, 0x10,  0x8, 0x14, 0x20,  0x8, 0x14, 0x40,  0x8, 0x14, 0x80,
    0x8, 0x18, 0x10,  0x8, 0x18, 0x20,  0x8, 0x18, 0x40,  0x8, 0x18, 0x80,
    0x8, 0x21, 0x10,  0x8, 0x21, 0x20,  0x8, 0x21, 0x40,  0x8, 0x21, 0x80,
    0x8, 0x22, 0x10,  0x8, 0x22, 0x20,  0x8, 0x22, 0x40,  0x8, 0x22, 0x80,
    0x8, 0x24, 0x10,  0x8, 0x24, 0x20,  0x8, 0x24, 0x40,  0x8, 0x24, 0x80,
    0x8, 0x28, 0x10,  0x8, 0x28, 0x20,  0x8, 0x28, 0x40,  0x8, 0x28, 0x80,
    0x8, 0x41, 0x10,  0x8, 0x41, 0x20,  0x8, 0x41, 0x40,  0x8, 0x41, 0x80,
    0x8, 0x42, 0x10,  0x8, 0x42, 0x20,  0x8, 0x42, 0x40,  0x8, 0x42, 0x80,
    0x8, 0x44, 0x10,  0x8, 0x44, 0x20,  0x8, 0x44, 0x40,  0x8, 0x44, 0x80,
    0x8, 0x48, 0x10,  0x8, 0x48, 0x20,  0x8, 0x48, 0x40,  0x8, 0x48, 0x80,
    0x8, 0x81, 0x10,  0x8, 0x81, 0x20,  0x8, 0x81, 0x40,  0x8, 0x81, 0x80,
    0x8, 0x82, 0x10,  0x8, 0x82, 0x20,  0x8, 0x82, 0x40,  0x8, 0x82, 0x80,
    0x8, 0x84, 0x10,  0x8, 0x84, 0x20,  0x8, 0x84, 0x40,  0x8, 0x84, 0x80,
    0x8, 0x88, 0x10,  0x8, 0x88, 0x20,  0x8, 0x88, 0x40,  0x8, 0x88, 0x80
};


// NCBI2na to NCBI8na (NCBI4na_expand)
/*
    static Uint1 convert[] = { 0x01, 0x02, 0x04, 0x08 };
    Uint1 base[4];

    for ( base[0] = 0; base[0] < 4; ++(base[0]) ) {
        for ( base[1] = 0; base[1] < 4; ++(base[1]) ) {
            for ( base[2] = 0; base[2] < 4; ++(base[2]) ) {
                for ( base[3] = 0; base[3] < 4; ++(base[3]) ) {
                    Uint1 index = 
                        (base[0] << 6) | (base[1] << 4) | (base[2] << 2) | base[3];
                    for ( size_t i = 0; i < 4; ++i ) {
                        sm_Table[index * 4 + i] = convert[base[i]];
                    }
                }
            }
        }
    }
*/
const Uint1 C2naTo8na::scm_Table[1024] = {
    0x1,0x1,0x1,0x1, 0x1,0x1,0x1,0x2, 0x1,0x1,0x1,0x4, 0x1,0x1,0x1,0x8,
    0x1,0x1,0x2,0x1, 0x1,0x1,0x2,0x2, 0x1,0x1,0x2,0x4, 0x1,0x1,0x2,0x8,
    0x1,0x1,0x4,0x1, 0x1,0x1,0x4,0x2, 0x1,0x1,0x4,0x4, 0x1,0x1,0x4,0x8,
    0x1,0x1,0x8,0x1, 0x1,0x1,0x8,0x2, 0x1,0x1,0x8,0x4, 0x1,0x1,0x8,0x8,
    0x1,0x2,0x1,0x1, 0x1,0x2,0x1,0x2, 0x1,0x2,0x1,0x4, 0x1,0x2,0x1,0x8,
    0x1,0x2,0x2,0x1, 0x1,0x2,0x2,0x2, 0x1,0x2,0x2,0x4, 0x1,0x2,0x2,0x8,
    0x1,0x2,0x4,0x1, 0x1,0x2,0x4,0x2, 0x1,0x2,0x4,0x4, 0x1,0x2,0x4,0x8,
    0x1,0x2,0x8,0x1, 0x1,0x2,0x8,0x2, 0x1,0x2,0x8,0x4, 0x1,0x2,0x8,0x8,
    0x1,0x4,0x1,0x1, 0x1,0x4,0x1,0x2, 0x1,0x4,0x1,0x4, 0x1,0x4,0x1,0x8,
    0x1,0x4,0x2,0x1, 0x1,0x4,0x2,0x2, 0x1,0x4,0x2,0x4, 0x1,0x4,0x2,0x8,
    0x1,0x4,0x4,0x1, 0x1,0x4,0x4,0x2, 0x1,0x4,0x4,0x4, 0x1,0x4,0x4,0x8,
    0x1,0x4,0x8,0x1, 0x1,0x4,0x8,0x2, 0x1,0x4,0x8,0x4, 0x1,0x4,0x8,0x8,
    0x1,0x8,0x1,0x1, 0x1,0x8,0x1,0x2, 0x1,0x8,0x1,0x4, 0x1,0x8,0x1,0x8,
    0x1,0x8,0x2,0x1, 0x1,0x8,0x2,0x2, 0x1,0x8,0x2,0x4, 0x1,0x8,0x2,0x8,
    0x1,0x8,0x4,0x1, 0x1,0x8,0x4,0x2, 0x1,0x8,0x4,0x4, 0x1,0x8,0x4,0x8,
    0x1,0x8,0x8,0x1, 0x1,0x8,0x8,0x2, 0x1,0x8,0x8,0x4, 0x1,0x8,0x8,0x8,
    0x2,0x1,0x1,0x1, 0x2,0x1,0x1,0x2, 0x2,0x1,0x1,0x4, 0x2,0x1,0x1,0x8,
    0x2,0x1,0x2,0x1, 0x2,0x1,0x2,0x2, 0x2,0x1,0x2,0x4, 0x2,0x1,0x2,0x8,
    0x2,0x1,0x4,0x1, 0x2,0x1,0x4,0x2, 0x2,0x1,0x4,0x4, 0x2,0x1,0x4,0x8,
    0x2,0x1,0x8,0x1, 0x2,0x1,0x8,0x2, 0x2,0x1,0x8,0x4, 0x2,0x1,0x8,0x8,
    0x2,0x2,0x1,0x1, 0x2,0x2,0x1,0x2, 0x2,0x2,0x1,0x4, 0x2,0x2,0x1,0x8,
    0x2,0x2,0x2,0x1, 0x2,0x2,0x2,0x2, 0x2,0x2,0x2,0x4, 0x2,0x2,0x2,0x8,
    0x2,0x2,0x4,0x1, 0x2,0x2,0x4,0x2, 0x2,0x2,0x4,0x4, 0x2,0x2,0x4,0x8,
    0x2,0x2,0x8,0x1, 0x2,0x2,0x8,0x2, 0x2,0x2,0x8,0x4, 0x2,0x2,0x8,0x8,
    0x2,0x4,0x1,0x1, 0x2,0x4,0x1,0x2, 0x2,0x4,0x1,0x4, 0x2,0x4,0x1,0x8,
    0x2,0x4,0x2,0x1, 0x2,0x4,0x2,0x2, 0x2,0x4,0x2,0x4, 0x2,0x4,0x2,0x8,
    0x2,0x4,0x4,0x1, 0x2,0x4,0x4,0x2, 0x2,0x4,0x4,0x4, 0x2,0x4,0x4,0x8,
    0x2,0x4,0x8,0x1, 0x2,0x4,0x8,0x2, 0x2,0x4,0x8,0x4, 0x2,0x4,0x8,0x8,
    0x2,0x8,0x1,0x1, 0x2,0x8,0x1,0x2, 0x2,0x8,0x1,0x4, 0x2,0x8,0x1,0x8,
    0x2,0x8,0x2,0x1, 0x2,0x8,0x2,0x2, 0x2,0x8,0x2,0x4, 0x2,0x8,0x2,0x8,
    0x2,0x8,0x4,0x1, 0x2,0x8,0x4,0x2, 0x2,0x8,0x4,0x4, 0x2,0x8,0x4,0x8,
    0x2,0x8,0x8,0x1, 0x2,0x8,0x8,0x2, 0x2,0x8,0x8,0x4, 0x2,0x8,0x8,0x8,
    0x4,0x1,0x1,0x1, 0x4,0x1,0x1,0x2, 0x4,0x1,0x1,0x4, 0x4,0x1,0x1,0x8,
    0x4,0x1,0x2,0x1, 0x4,0x1,0x2,0x2, 0x4,0x1,0x2,0x4, 0x4,0x1,0x2,0x8,
    0x4,0x1,0x4,0x1, 0x4,0x1,0x4,0x2, 0x4,0x1,0x4,0x4, 0x4,0x1,0x4,0x8,
    0x4,0x1,0x8,0x1, 0x4,0x1,0x8,0x2, 0x4,0x1,0x8,0x4, 0x4,0x1,0x8,0x8,
    0x4,0x2,0x1,0x1, 0x4,0x2,0x1,0x2, 0x4,0x2,0x1,0x4, 0x4,0x2,0x1,0x8,
    0x4,0x2,0x2,0x1, 0x4,0x2,0x2,0x2, 0x4,0x2,0x2,0x4, 0x4,0x2,0x2,0x8,
    0x4,0x2,0x4,0x1, 0x4,0x2,0x4,0x2, 0x4,0x2,0x4,0x4, 0x4,0x2,0x4,0x8,
    0x4,0x2,0x8,0x1, 0x4,0x2,0x8,0x2, 0x4,0x2,0x8,0x4, 0x4,0x2,0x8,0x8,
    0x4,0x4,0x1,0x1, 0x4,0x4,0x1,0x2, 0x4,0x4,0x1,0x4, 0x4,0x4,0x1,0x8,
    0x4,0x4,0x2,0x1, 0x4,0x4,0x2,0x2, 0x4,0x4,0x2,0x4, 0x4,0x4,0x2,0x8,
    0x4,0x4,0x4,0x1, 0x4,0x4,0x4,0x2, 0x4,0x4,0x4,0x4, 0x4,0x4,0x4,0x8,
    0x4,0x4,0x8,0x1, 0x4,0x4,0x8,0x2, 0x4,0x4,0x8,0x4, 0x4,0x4,0x8,0x8,
    0x4,0x8,0x1,0x1, 0x4,0x8,0x1,0x2, 0x4,0x8,0x1,0x4, 0x4,0x8,0x1,0x8,
    0x4,0x8,0x2,0x1, 0x4,0x8,0x2,0x2, 0x4,0x8,0x2,0x4, 0x4,0x8,0x2,0x8,
    0x4,0x8,0x4,0x1, 0x4,0x8,0x4,0x2, 0x4,0x8,0x4,0x4, 0x4,0x8,0x4,0x8,
    0x4,0x8,0x8,0x1, 0x4,0x8,0x8,0x2, 0x4,0x8,0x8,0x4, 0x4,0x8,0x8,0x8,
    0x8,0x1,0x1,0x1, 0x8,0x1,0x1,0x2, 0x8,0x1,0x1,0x4, 0x8,0x1,0x1,0x8,
    0x8,0x1,0x2,0x1, 0x8,0x1,0x2,0x2, 0x8,0x1,0x2,0x4, 0x8,0x1,0x2,0x8,
    0x8,0x1,0x4,0x1, 0x8,0x1,0x4,0x2, 0x8,0x1,0x4,0x4, 0x8,0x1,0x4,0x8,
    0x8,0x1,0x8,0x1, 0x8,0x1,0x8,0x2, 0x8,0x1,0x8,0x4, 0x8,0x1,0x8,0x8,
    0x8,0x2,0x1,0x1, 0x8,0x2,0x1,0x2, 0x8,0x2,0x1,0x4, 0x8,0x2,0x1,0x8,
    0x8,0x2,0x2,0x1, 0x8,0x2,0x2,0x2, 0x8,0x2,0x2,0x4, 0x8,0x2,0x2,0x8,
    0x8,0x2,0x4,0x1, 0x8,0x2,0x4,0x2, 0x8,0x2,0x4,0x4, 0x8,0x2,0x4,0x8,
    0x8,0x2,0x8,0x1, 0x8,0x2,0x8,0x2, 0x8,0x2,0x8,0x4, 0x8,0x2,0x8,0x8,
    0x8,0x4,0x1,0x1, 0x8,0x4,0x1,0x2, 0x8,0x4,0x1,0x4, 0x8,0x4,0x1,0x8,
    0x8,0x4,0x2,0x1, 0x8,0x4,0x2,0x2, 0x8,0x4,0x2,0x4, 0x8,0x4,0x2,0x8,
    0x8,0x4,0x4,0x1, 0x8,0x4,0x4,0x2, 0x8,0x4,0x4,0x4, 0x8,0x4,0x4,0x8,
    0x8,0x4,0x8,0x1, 0x8,0x4,0x8,0x2, 0x8,0x4,0x8,0x4, 0x8,0x4,0x8,0x8,
    0x8,0x8,0x1,0x1, 0x8,0x8,0x1,0x2, 0x8,0x8,0x1,0x4, 0x8,0x8,0x1,0x8,
    0x8,0x8,0x2,0x1, 0x8,0x8,0x2,0x2, 0x8,0x8,0x2,0x4, 0x8,0x8,0x2,0x8,
    0x8,0x8,0x4,0x1, 0x8,0x8,0x4,0x2, 0x8,0x8,0x4,0x4, 0x8,0x8,0x4,0x8,
    0x8,0x8,0x8,0x1, 0x8,0x8,0x8,0x2, 0x8,0x8,0x8,0x4, 0x8,0x8,0x8,0x8
};

// NCBI2na_expand to IUPACna
// 0 -> A
// 1 -> C
// 2 -> G
// 3 -> T
const Uint1 C2naExpandToIupacna::scm_Table[256] = {
    0x41, 0x43, 0x47, 0x54, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBI4na to IUPACna
// 0  '-'  -> N
// 1  'A'  -> N
// 2  'C'  -> N
// 3  'M'  -> N
// 4  'G'  -> N
// 5  'R'  -> N
// 6  'S'  -> N
// 7  'V'  -> N
// 8  'T'  -> N
// 9  'W'  -> N
// 10 'Y'  -> N
// 11 'H'  -> N
// 12 'K'  -> N
// 13 'D'  -> N
// 14 'B'  -> N
// 15 'N'  -> N
const Uint1 C4naToIupacna::scm_Table[512] = {
    0x4e,0x4e,    0x4e,0x41,    0x4e,0x43,    0x4e,0x4d,
    0x4e,0x47,    0x4e,0x52,    0x4e,0x53,    0x4e,0x56,
    0x4e,0x54,    0x4e,0x57,    0x4e,0x59,    0x4e,0x48,
    0x4e,0x4b,    0x4e,0x44,    0x4e,0x42,    0x4e,0x4e,
    0x41,0x4e,    0x41,0x41,    0x41,0x43,    0x41,0x4d,
    0x41,0x47,    0x41,0x52,    0x41,0x53,    0x41,0x56,
    0x41,0x54,    0x41,0x57,    0x41,0x59,    0x41,0x48,
    0x41,0x4b,    0x41,0x44,    0x41,0x42,    0x41,0x4e,
    0x43,0x4e,    0x43,0x41,    0x43,0x43,    0x43,0x4d,
    0x43,0x47,    0x43,0x52,    0x43,0x53,    0x43,0x56,
    0x43,0x54,    0x43,0x57,    0x43,0x59,    0x43,0x48,
    0x43,0x4b,    0x43,0x44,    0x43,0x42,    0x43,0x4e,
    0x4d,0x4e,    0x4d,0x41,    0x4d,0x43,    0x4d,0x4d,
    0x4d,0x47,    0x4d,0x52,    0x4d,0x53,    0x4d,0x56,
    0x4d,0x54,    0x4d,0x57,    0x4d,0x59,    0x4d,0x48,
    0x4d,0x4b,    0x4d,0x44,    0x4d,0x42,    0x4d,0x4e,
    0x47,0x4e,    0x47,0x41,    0x47,0x43,    0x47,0x4d,
    0x47,0x47,    0x47,0x52,    0x47,0x53,    0x47,0x56,
    0x47,0x54,    0x47,0x57,    0x47,0x59,    0x47,0x48,
    0x47,0x4b,    0x47,0x44,    0x47,0x42,    0x47,0x4e,
    0x52,0x4e,    0x52,0x41,    0x52,0x43,    0x52,0x4d,
    0x52,0x47,    0x52,0x52,    0x52,0x53,    0x52,0x56,
    0x52,0x54,    0x52,0x57,    0x52,0x59,    0x52,0x48,
    0x52,0x4b,    0x52,0x44,    0x52,0x42,    0x52,0x4e,
    0x53,0x4e,    0x53,0x41,    0x53,0x43,    0x53,0x4d,
    0x53,0x47,    0x53,0x52,    0x53,0x53,    0x53,0x56,
    0x53,0x54,    0x53,0x57,    0x53,0x59,    0x53,0x48,
    0x53,0x4b,    0x53,0x44,    0x53,0x42,    0x53,0x4e,
    0x56,0x4e,    0x56,0x41,    0x56,0x43,    0x56,0x4d,
    0x56,0x47,    0x56,0x52,    0x56,0x53,    0x56,0x56,
    0x56,0x54,    0x56,0x57,    0x56,0x59,    0x56,0x48,
    0x56,0x4b,    0x56,0x44,    0x56,0x42,    0x56,0x4e,
    0x54,0x4e,    0x54,0x41,    0x54,0x43,    0x54,0x4d,
    0x54,0x47,    0x54,0x52,    0x54,0x53,    0x54,0x56,
    0x54,0x54,    0x54,0x57,    0x54,0x59,    0x54,0x48,
    0x54,0x4b,    0x54,0x44,    0x54,0x42,    0x54,0x4e,
    0x57,0x4e,    0x57,0x41,    0x57,0x43,    0x57,0x4d,
    0x57,0x47,    0x57,0x52,    0x57,0x53,    0x57,0x56,
    0x57,0x54,    0x57,0x57,    0x57,0x59,    0x57,0x48,
    0x57,0x4b,    0x57,0x44,    0x57,0x42,    0x57,0x4e,
    0x59,0x4e,    0x59,0x41,    0x59,0x43,    0x59,0x4d,
    0x59,0x47,    0x59,0x52,    0x59,0x53,    0x59,0x56,
    0x59,0x54,    0x59,0x57,    0x59,0x59,    0x59,0x48,
    0x59,0x4b,    0x59,0x44,    0x59,0x42,    0x59,0x4e,
    0x48,0x4e,    0x48,0x41,    0x48,0x43,    0x48,0x4d,
    0x48,0x47,    0x48,0x52,    0x48,0x53,    0x48,0x56,
    0x48,0x54,    0x48,0x57,    0x48,0x59,    0x48,0x48,
    0x48,0x4b,    0x48,0x44,    0x48,0x42,    0x48,0x4e,
    0x4b,0x4e,    0x4b,0x41,    0x4b,0x43,    0x4b,0x4d,
    0x4b,0x47,    0x4b,0x52,    0x4b,0x53,    0x4b,0x56,
    0x4b,0x54,    0x4b,0x57,    0x4b,0x59,    0x4b,0x48,
    0x4b,0x4b,    0x4b,0x44,    0x4b,0x42,    0x4b,0x4e,
    0x44,0x4e,    0x44,0x41,    0x44,0x43,    0x44,0x4d,
    0x44,0x47,    0x44,0x52,    0x44,0x53,    0x44,0x56,
    0x44,0x54,    0x44,0x57,    0x44,0x59,    0x44,0x48,
    0x44,0x4b,    0x44,0x44,    0x44,0x42,    0x44,0x4e,
    0x42,0x4e,    0x42,0x41,    0x42,0x43,    0x42,0x4d,
    0x42,0x47,    0x42,0x52,    0x42,0x53,    0x42,0x56,
    0x42,0x54,    0x42,0x57,    0x42,0x59,    0x42,0x48,
    0x42,0x4b,    0x42,0x44,    0x42,0x42,    0x42,0x4e,
    0x4e,0x4e,    0x4e,0x41,    0x4e,0x43,    0x4e,0x4d,
    0x4e,0x47,    0x4e,0x52,    0x4e,0x53,    0x4e,0x56,
    0x4e,0x54,    0x4e,0x57,    0x4e,0x59,    0x4e,0x48,
    0x4e,0x4b,    0x4e,0x44,    0x4e,0x42,    0x4e,0x4e
};


// NCBI4na to NCBI2na
// 0  -> 3  (gap -> T)
// 1  -> 0  (A -> A)
// 2  -> 1  (C -> C)
// 3  -> 1  (M -> C)
// 4  -> 2  (G -> G)
// 5  -> 2  (R -> G)
// 6  -> 1  (S -> C)
// 7  -> 0  (V -> A)
// 8  -> 3  (T -> T)
// 9  -> 3  (W -> T)
// 10 -> 3  (Y -> T)
// 11 -> 0  (H -> A)
// 12 -> 2  (K -> G)
// 13 -> 2  (D -> G)
// 14 -> 1  (B -> C)
// 15 -> 0  (N -> A)
/*
    for ( base[0] = 0; base[0] < 16; ++base[0] ) {
        for ( base[1] = 0; base[1] < 16; ++base[1] ) {
            Uint1 index = base[0] << 4 | base[1];
            sm_TableOffset0[index * 2] = 
                (convert[base[0]] << 6) | (convert[base[1]] << 4);
            sm_TableOffset0[index * 2 + 1] = 
                (convert[base[0]] << 2) | convert[base[1]];
        }
    }
*/
const Uint1 C4naTo2na::scm_Table0[512] = {
    0xf0,0xf,    0xc0,0xc,    0xd0,0xd,    0xd0,0xd,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0xf0,0xf,    0xf0,0xf,    0xf0,0xf,    0xc0,0xc,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0x30,0x3,    0x0,0x0,    0x10,0x1,    0x10,0x1,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0x30,0x3,    0x30,0x3,    0x30,0x3,    0x0,0x0,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0x70,0x7,    0x40,0x4,    0x50,0x5,    0x50,0x5,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x70,0x7,    0x70,0x7,    0x70,0x7,    0x40,0x4,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x70,0x7,    0x40,0x4,    0x50,0x5,    0x50,0x5,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x70,0x7,    0x70,0x7,    0x70,0x7,    0x40,0x4,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0xb0,0xb,    0x80,0x8,    0x90,0x9,    0x90,0x9,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0xb0,0xb,    0xb0,0xb,    0xb0,0xb,    0x80,0x8,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0xb0,0xb,    0x80,0x8,    0x90,0x9,    0x90,0x9,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0xb0,0xb,    0xb0,0xb,    0xb0,0xb,    0x80,0x8,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0x70,0x7,    0x40,0x4,    0x50,0x5,    0x50,0x5,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x70,0x7,    0x70,0x7,    0x70,0x7,    0x40,0x4,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x30,0x3,    0x0,0x0,    0x10,0x1,    0x10,0x1,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0x30,0x3,    0x30,0x3,    0x30,0x3,    0x0,0x0,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0xf0,0xf,    0xc0,0xc,    0xd0,0xd,    0xd0,0xd,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0xf0,0xf,    0xf0,0xf,    0xf0,0xf,    0xc0,0xc,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0xf0,0xf,    0xc0,0xc,    0xd0,0xd,    0xd0,0xd,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0xf0,0xf,    0xf0,0xf,    0xf0,0xf,    0xc0,0xc,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0xf0,0xf,    0xc0,0xc,    0xd0,0xd,    0xd0,0xd,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0xf0,0xf,    0xf0,0xf,    0xf0,0xf,    0xc0,0xc,
    0xe0,0xe,    0xe0,0xe,    0xd0,0xd,    0xc0,0xc,
    0x30,0x3,    0x0,0x0,    0x10,0x1,    0x10,0x1,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0x30,0x3,    0x30,0x3,    0x30,0x3,    0x0,0x0,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0xb0,0xb,    0x80,0x8,    0x90,0x9,    0x90,0x9,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0xb0,0xb,    0xb0,0xb,    0xb0,0xb,    0x80,0x8,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0xb0,0xb,    0x80,0x8,    0x90,0x9,    0x90,0x9,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0xb0,0xb,    0xb0,0xb,    0xb0,0xb,    0x80,0x8,
    0xa0,0xa,    0xa0,0xa,    0x90,0x9,    0x80,0x8,
    0x70,0x7,    0x40,0x4,    0x50,0x5,    0x50,0x5,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x70,0x7,    0x70,0x7,    0x70,0x7,    0x40,0x4,
    0x60,0x6,    0x60,0x6,    0x50,0x5,    0x40,0x4,
    0x30,0x3,    0x0,0x0,    0x10,0x1,    0x10,0x1,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0,
    0x30,0x3,    0x30,0x3,    0x30,0x3,    0x0,0x0,
    0x20,0x2,    0x20,0x2,    0x10,0x1,    0x0,0x0
};

/*
    for ( base[0] = 0; base[0] < 16; ++base[0] ) {
        for ( base[1] = 0; base[1] < 16; ++base[1] ) {
            Uint1 index = base[0] << 4 | base[1];
            sm_TableOffset1[index * 3] = 
                convert[base[1]] << 6;
            sm_TableOffset1[index * 3 + 1] = 
                (convert[base[0]] << 4) | (convert[base[1]] << 2);
            sm_TableOffset1[index * 3 + 2] = 
                convert[base[0]];
        }
    }
*/
const Uint1 C4naTo2na::scm_Table1[768] = {
    0xc0,0x3c,0x3,    0x0,0x30,0x3,    0x40,0x34,0x3,    0x40,0x34,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0x0,0x30,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0xc,0x0,    0x0,0x0,0x0,    0x40,0x4,0x0,    0x40,0x4,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0x0,0x0,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0x1c,0x1,    0x0,0x10,0x1,    0x40,0x14,0x1,    0x40,0x14,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0x0,0x10,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0x1c,0x1,    0x0,0x10,0x1,    0x40,0x14,0x1,    0x40,0x14,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0x0,0x10,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0x2c,0x2,    0x0,0x20,0x2,    0x40,0x24,0x2,    0x40,0x24,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0x0,0x20,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x2c,0x2,    0x0,0x20,0x2,    0x40,0x24,0x2,    0x40,0x24,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0x0,0x20,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x1c,0x1,    0x0,0x10,0x1,    0x40,0x14,0x1,    0x40,0x14,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0x0,0x10,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0xc,0x0,    0x0,0x0,0x0,    0x40,0x4,0x0,    0x40,0x4,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0x0,0x0,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0x3c,0x3,    0x0,0x30,0x3,    0x40,0x34,0x3,    0x40,0x34,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0x0,0x30,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0x3c,0x3,    0x0,0x30,0x3,    0x40,0x34,0x3,    0x40,0x34,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0x0,0x30,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0x3c,0x3,    0x0,0x30,0x3,    0x40,0x34,0x3,    0x40,0x34,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0xc0,0x3c,0x3,    0x0,0x30,0x3,
    0x80,0x38,0x3,    0x80,0x38,0x3,    0x40,0x34,0x3,    0x0,0x30,0x3,
    0xc0,0xc,0x0,    0x0,0x0,0x0,    0x40,0x4,0x0,    0x40,0x4,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0x0,0x0,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0x2c,0x2,    0x0,0x20,0x2,    0x40,0x24,0x2,    0x40,0x24,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0x0,0x20,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x2c,0x2,    0x0,0x20,0x2,    0x40,0x24,0x2,    0x40,0x24,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0xc0,0x2c,0x2,    0x0,0x20,0x2,
    0x80,0x28,0x2,    0x80,0x28,0x2,    0x40,0x24,0x2,    0x0,0x20,0x2,
    0xc0,0x1c,0x1,    0x0,0x10,0x1,    0x40,0x14,0x1,    0x40,0x14,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0xc0,0x1c,0x1,    0x0,0x10,0x1,
    0x80,0x18,0x1,    0x80,0x18,0x1,    0x40,0x14,0x1,    0x0,0x10,0x1,
    0xc0,0xc,0x0,    0x0,0x0,0x0,    0x40,0x4,0x0,    0x40,0x4,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0,
    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0xc0,0xc,0x0,    0x0,0x0,0x0,
    0x80,0x8,0x0,    0x80,0x8,0x0,    0x40,0x4,0x0,    0x0,0x0,0x0
};


// NCBI4na to NCBI2na_expand
// gap -> 3 T
// A   -> 0 A
// C   -> 1 C
// M   -> 1 C
// G   -> 2 G
// R   -> 2 G
// S   -> 1 C
// V   -> 0 A
// T   -> 3 T
// W   -> 3 T
// Y   -> 3 T
// H   -> 0 A
// K   -> 2 G
// D   -> 2 G
// B   -> 1 C
// N   -> 0 A

const Uint1 C4naTo2naExpand::scm_Table[512] = {
    0x3,0x3,    0x3,0x0,    0x3,0x1,    0x3,0x1,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x3,0x3,    0x3,0x3,    0x3,0x3,    0x3,0x0,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x0,0x3,    0x0,0x0,    0x0,0x1,    0x0,0x1,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x0,0x3,    0x0,0x3,    0x0,0x3,    0x0,0x0,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x1,0x3,    0x1,0x0,    0x1,0x1,    0x1,0x1,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x1,0x3,    0x1,0x3,    0x1,0x3,    0x1,0x0,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x1,0x3,    0x1,0x0,    0x1,0x1,    0x1,0x1,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x1,0x3,    0x1,0x3,    0x1,0x3,    0x1,0x0,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x2,0x3,    0x2,0x0,    0x2,0x1,    0x2,0x1,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x2,0x3,    0x2,0x3,    0x2,0x3,    0x2,0x0,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x2,0x3,    0x2,0x0,    0x2,0x1,    0x2,0x1,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x2,0x3,    0x2,0x3,    0x2,0x3,    0x2,0x0,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x1,0x3,    0x1,0x0,    0x1,0x1,    0x1,0x1,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x1,0x3,    0x1,0x3,    0x1,0x3,    0x1,0x0,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x0,0x3,    0x0,0x0,    0x0,0x1,    0x0,0x1,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x0,0x3,    0x0,0x3,    0x0,0x3,    0x0,0x0,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x3,0x3,    0x3,0x0,    0x3,0x1,    0x3,0x1,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x3,0x3,    0x3,0x3,    0x3,0x3,    0x3,0x0,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x3,0x3,    0x3,0x0,    0x3,0x1,    0x3,0x1,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x3,0x3,    0x3,0x3,    0x3,0x3,    0x3,0x0,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x3,0x3,    0x3,0x0,    0x3,0x1,    0x3,0x1,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x3,0x3,    0x3,0x3,    0x3,0x3,    0x3,0x0,
    0x3,0x2,    0x3,0x2,    0x3,0x1,    0x3,0x0,
    0x0,0x3,    0x0,0x0,    0x0,0x1,    0x0,0x1,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x0,0x3,    0x0,0x3,    0x0,0x3,    0x0,0x0,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x2,0x3,    0x2,0x0,    0x2,0x1,    0x2,0x1,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x2,0x3,    0x2,0x3,    0x2,0x3,    0x2,0x0,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x2,0x3,    0x2,0x0,    0x2,0x1,    0x2,0x1,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x2,0x3,    0x2,0x3,    0x2,0x3,    0x2,0x0,
    0x2,0x2,    0x2,0x2,    0x2,0x1,    0x2,0x0,
    0x1,0x3,    0x1,0x0,    0x1,0x1,    0x1,0x1,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x1,0x3,    0x1,0x3,    0x1,0x3,    0x1,0x0,
    0x1,0x2,    0x1,0x2,    0x1,0x1,    0x1,0x0,
    0x0,0x3,    0x0,0x0,    0x0,0x1,    0x0,0x1,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0,
    0x0,0x3,    0x0,0x3,    0x0,0x3,    0x0,0x0,
    0x0,0x2,    0x0,0x2,    0x0,0x1,    0x0,0x0
};


// NCBI4na to NCBI8na (NCBI4na_expand)
/*
    for ( base[0] = 0; base[0] < 16; ++base[0] ) {
        for ( base[1] = 0; base[1] < 16; ++base[1] ) {
            Uint1 index = (base[0] << 4) | base[1];
            for( int i = 0; i < 2; ++i ) {
                sm_Table[index * 2 + i] = base[i];
            }
        }
    }
*/
const Uint1 C4naTo8na::scm_Table[512] = {
    0x0,0x0,    0x0,0x1,    0x0,0x2,    0x0,0x3,
    0x0,0x4,    0x0,0x5,    0x0,0x6,    0x0,0x7,
    0x0,0x8,    0x0,0x9,    0x0,0xa,    0x0,0xb,
    0x0,0xc,    0x0,0xd,    0x0,0xe,    0x0,0xf,
    0x1,0x0,    0x1,0x1,    0x1,0x2,    0x1,0x3,
    0x1,0x4,    0x1,0x5,    0x1,0x6,    0x1,0x7,
    0x1,0x8,    0x1,0x9,    0x1,0xa,    0x1,0xb,
    0x1,0xc,    0x1,0xd,    0x1,0xe,    0x1,0xf,
    0x2,0x0,    0x2,0x1,    0x2,0x2,    0x2,0x3,
    0x2,0x4,    0x2,0x5,    0x2,0x6,    0x2,0x7,
    0x2,0x8,    0x2,0x9,    0x2,0xa,    0x2,0xb,
    0x2,0xc,    0x2,0xd,    0x2,0xe,    0x2,0xf,
    0x3,0x0,    0x3,0x1,    0x3,0x2,    0x3,0x3,
    0x3,0x4,    0x3,0x5,    0x3,0x6,    0x3,0x7,
    0x3,0x8,    0x3,0x9,    0x3,0xa,    0x3,0xb,
    0x3,0xc,    0x3,0xd,    0x3,0xe,    0x3,0xf,
    0x4,0x0,    0x4,0x1,    0x4,0x2,    0x4,0x3,
    0x4,0x4,    0x4,0x5,    0x4,0x6,    0x4,0x7,
    0x4,0x8,    0x4,0x9,    0x4,0xa,    0x4,0xb,
    0x4,0xc,    0x4,0xd,    0x4,0xe,    0x4,0xf,
    0x5,0x0,    0x5,0x1,    0x5,0x2,    0x5,0x3,
    0x5,0x4,    0x5,0x5,    0x5,0x6,    0x5,0x7,
    0x5,0x8,    0x5,0x9,    0x5,0xa,    0x5,0xb,
    0x5,0xc,    0x5,0xd,    0x5,0xe,    0x5,0xf,
    0x6,0x0,    0x6,0x1,    0x6,0x2,    0x6,0x3,
    0x6,0x4,    0x6,0x5,    0x6,0x6,    0x6,0x7,
    0x6,0x8,    0x6,0x9,    0x6,0xa,    0x6,0xb,
    0x6,0xc,    0x6,0xd,    0x6,0xe,    0x6,0xf,
    0x7,0x0,    0x7,0x1,    0x7,0x2,    0x7,0x3,
    0x7,0x4,    0x7,0x5,    0x7,0x6,    0x7,0x7,
    0x7,0x8,    0x7,0x9,    0x7,0xa,    0x7,0xb,
    0x7,0xc,    0x7,0xd,    0x7,0xe,    0x7,0xf,
    0x8,0x0,    0x8,0x1,    0x8,0x2,    0x8,0x3,
    0x8,0x4,    0x8,0x5,    0x8,0x6,    0x8,0x7,
    0x8,0x8,    0x8,0x9,    0x8,0xa,    0x8,0xb,
    0x8,0xc,    0x8,0xd,    0x8,0xe,    0x8,0xf,
    0x9,0x0,    0x9,0x1,    0x9,0x2,    0x9,0x3,
    0x9,0x4,    0x9,0x5,    0x9,0x6,    0x9,0x7,
    0x9,0x8,    0x9,0x9,    0x9,0xa,    0x9,0xb,
    0x9,0xc,    0x9,0xd,    0x9,0xe,    0x9,0xf,
    0xa,0x0,    0xa,0x1,    0xa,0x2,    0xa,0x3,
    0xa,0x4,    0xa,0x5,    0xa,0x6,    0xa,0x7,
    0xa,0x8,    0xa,0x9,    0xa,0xa,    0xa,0xb,
    0xa,0xc,    0xa,0xd,    0xa,0xe,    0xa,0xf,
    0xb,0x0,    0xb,0x1,    0xb,0x2,    0xb,0x3,
    0xb,0x4,    0xb,0x5,    0xb,0x6,    0xb,0x7,
    0xb,0x8,    0xb,0x9,    0xb,0xa,    0xb,0xb,
    0xb,0xc,    0xb,0xd,    0xb,0xe,    0xb,0xf,
    0xc,0x0,    0xc,0x1,    0xc,0x2,    0xc,0x3,
    0xc,0x4,    0xc,0x5,    0xc,0x6,    0xc,0x7,
    0xc,0x8,    0xc,0x9,    0xc,0xa,    0xc,0xb,
    0xc,0xc,    0xc,0xd,    0xc,0xe,    0xc,0xf,
    0xd,0x0,    0xd,0x1,    0xd,0x2,    0xd,0x3,
    0xd,0x4,    0xd,0x5,    0xd,0x6,    0xd,0x7,
    0xd,0x8,    0xd,0x9,    0xd,0xa,    0xd,0xb,
    0xd,0xc,    0xd,0xd,    0xd,0xe,    0xd,0xf,
    0xe,0x0,    0xe,0x1,    0xe,0x2,    0xe,0x3,
    0xe,0x4,    0xe,0x5,    0xe,0x6,    0xe,0x7,
    0xe,0x8,    0xe,0x9,    0xe,0xa,    0xe,0xb,
    0xe,0xc,    0xe,0xd,    0xe,0xe,    0xe,0xf,
    0xf,0x0,    0xf,0x1,    0xf,0x2,    0xf,0x3,
    0xf,0x4,    0xf,0x5,    0xf,0x6,    0xf,0x7,
    0xf,0x8,    0xf,0x9,    0xf,0xa,    0xf,0xb,
    0xf,0xc,    0xf,0xd,    0xf,0xe,    0xf,0xf
};


// NCBI8na to IUPACna
const Uint1 C8naToIupacna::scm_Table[256] = {
    0x4e, 0x41, 0x43, 0x4d, 0x47, 0x52, 0x53, 0x56,
    0x54, 0x57, 0x59, 0x48, 0x4b, 0x44, 0x42, 0x4e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBI8na to NCBI2na
const Uint1 C8naTo2na::scm_Table[1024] = {
    0xc0,0x30,0xc,0x3,   0x0,0x0,0x0,0x0,
    0x40,0x10,0x4,0x1,   0x40,0x10,0x4,0x1,
    0x80,0x20,0x8,0x2,   0x80,0x20,0x8,0x2,
    0x40,0x10,0x4,0x1,   0x0,0x0,0x0,0x0,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0x0,0x0,0x0,0x0,
    0x80,0x20,0x8,0x2,   0x80,0x20,0x8,0x2,
    0x40,0x10,0x4,0x1,   0x0,0x0,0x0,0x0,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3,
    0xc0,0x30,0xc,0x3,   0xc0,0x30,0xc,0x3
};


// IUPACaa to NCBIstdaa
const Uint1 CIupacaaToStdaa::scm_Table[256] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0x1b, 0xa, 0xb, 0xc, 0xd, 0x1a,
    0xe, 0xf, 0x10, 0x11, 0x12, 0x18, 0x13, 0x14,
    0x15, 0x16, 0x17, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0x1b, 0xa, 0xb, 0xc, 0xd, 0x1a,
    0xe, 0xf, 0x10, 0x11, 0x12, 0x18, 0x13, 0x14,
    0x15, 0x16, 0x17, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBIeaa to IUPACaa
const Uint1 CEaaToIupacaa::scm_Table[256] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x58, 0xff, 0xff, 0x58, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBIeaa to NCBIstdaa
const Uint1 CEaaToStdaa::scm_Table[256] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x19, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7,
    0x8, 0x9, 0x1b, 0xa, 0xb, 0xc, 0xd, 0x1a,
    0xe, 0xf, 0x10, 0x11, 0x12, 0x18, 0x13, 0x14,
    0x15, 0x16, 0x17, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBIstdaa to IUPACaa
const Uint1 CStdaaToIupacaa::scm_Table[256] = {
    0xff, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4b, 0x4c, 0x4d, 0x4e, 0x50, 0x51,
    0x52, 0x53, 0x54, 0x56, 0x57, 0x58, 0x59, 0x5a,
    0x55, 0xff, 0x4f, 0x4a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


// NCBIstdaa to NCBIeaa
const Uint1 CStdaaToEaa::scm_Table[256] = {
    0x2d, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4b, 0x4c, 0x4d, 0x4e, 0x50, 0x51,
    0x52, 0x53, 0x54, 0x56, 0x57, 0x58, 0x59, 0x5a,
    0x55, 0x2a, 0x4f, 0x4a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

/////////////////////////////////////////////////////////////////////////////
//
// Reverse Tables

// NCBI2na
const Uint1* C2naReverse::scm_Tables[4] = { 
    scm_Table0,
    scm_Table1,
    scm_Table2,
    scm_Table3
};

const Uint1 C2naReverse::scm_Table3[256] = {
    0x00, 0x40, 0x80, 0xc0, 0x10, 0x50, 0x90, 0xd0,
    0x20, 0x60, 0xa0, 0xe0, 0x30, 0x70, 0xb0, 0xf0,
    0x04, 0x44, 0x84, 0xc4, 0x14, 0x54, 0x94, 0xd4,
    0x24, 0x64, 0xa4, 0xe4, 0x34, 0x74, 0xb4, 0xf4,
    0x08, 0x48, 0x88, 0xc8, 0x18, 0x58, 0x98, 0xd8,
    0x28, 0x68, 0xa8, 0xe8, 0x38, 0x78, 0xb8, 0xf8,
    0x0c, 0x4c, 0x8c, 0xcc, 0x1c, 0x5c, 0x9c, 0xdc,
    0x2c, 0x6c, 0xac, 0xec, 0x3c, 0x7c, 0xbc, 0xfc,
    0x01, 0x41, 0x81, 0xc1, 0x11, 0x51, 0x91, 0xd1,
    0x21, 0x61, 0xa1, 0xe1, 0x31, 0x71, 0xb1, 0xf1,
    0x05, 0x45, 0x85, 0xc5, 0x15, 0x55, 0x95, 0xd5,
    0x25, 0x65, 0xa5, 0xe5, 0x35, 0x75, 0xb5, 0xf5,
    0x09, 0x49, 0x89, 0xc9, 0x19, 0x59, 0x99, 0xd9,
    0x29, 0x69, 0xa9, 0xe9, 0x39, 0x79, 0xb9, 0xf9,
    0x0d, 0x4d, 0x8d, 0xcd, 0x1d, 0x5d, 0x9d, 0xdd,
    0x2d, 0x6d, 0xad, 0xed, 0x3d, 0x7d, 0xbd, 0xfd,
    0x02, 0x42, 0x82, 0xc2, 0x12, 0x52, 0x92, 0xd2,
    0x22, 0x62, 0xa2, 0xe2, 0x32, 0x72, 0xb2, 0xf2,
    0x06, 0x46, 0x86, 0xc6, 0x16, 0x56, 0x96, 0xd6,
    0x26, 0x66, 0xa6, 0xe6, 0x36, 0x76, 0xb6, 0xf6,
    0x0a, 0x4a, 0x8a, 0xca, 0x1a, 0x5a, 0x9a, 0xda,
    0x2a, 0x6a, 0xaa, 0xea, 0x3a, 0x7a, 0xba, 0xfa,
    0x0e, 0x4e, 0x8e, 0xce, 0x1e, 0x5e, 0x9e, 0xde,
    0x2e, 0x6e, 0xae, 0xee, 0x3e, 0x7e, 0xbe, 0xfe,
    0x03, 0x43, 0x83, 0xc3, 0x13, 0x53, 0x93, 0xd3,
    0x23, 0x63, 0xa3, 0xe3, 0x33, 0x73, 0xb3, 0xf3,
    0x07, 0x47, 0x87, 0xc7, 0x17, 0x57, 0x97, 0xd7,
    0x27, 0x67, 0xa7, 0xe7, 0x37, 0x77, 0xb7, 0xf7,
    0x0b, 0x4b, 0x8b, 0xcb, 0x1b, 0x5b, 0x9b, 0xdb,
    0x2b, 0x6b, 0xab, 0xeb, 0x3b, 0x7b, 0xbb, 0xfb,
    0x0f, 0x4f, 0x8f, 0xcf, 0x1f, 0x5f, 0x9f, 0xdf,
    0x2f, 0x6f, 0xaf, 0xef, 0x3f, 0x7f, 0xbf, 0xff
};

const Uint1 C2naReverse::scm_Table2[512] = {
    0x00, 0x00,   0x01, 0x00,   0x02, 0x00,   0x03, 0x00,
    0x00, 0x40,   0x01, 0x40,   0x02, 0x40,   0x03, 0x40,
    0x00, 0x80,   0x01, 0x80,   0x02, 0x80,   0x03, 0x80,
    0x00, 0xc0,   0x01, 0xc0,   0x02, 0xc0,   0x03, 0xc0,
    0x00, 0x10,   0x01, 0x10,   0x02, 0x10,   0x03, 0x10,
    0x00, 0x50,   0x01, 0x50,   0x02, 0x50,   0x03, 0x50,
    0x00, 0x90,   0x01, 0x90,   0x02, 0x90,   0x03, 0x90,
    0x00, 0xd0,   0x01, 0xd0,   0x02, 0xd0,   0x03, 0xd0,
    0x00, 0x20,   0x01, 0x20,   0x02, 0x20,   0x03, 0x20,
    0x00, 0x60,   0x01, 0x60,   0x02, 0x60,   0x03, 0x60,
    0x00, 0xa0,   0x01, 0xa0,   0x02, 0xa0,   0x03, 0xa0,
    0x00, 0xe0,   0x01, 0xe0,   0x02, 0xe0,   0x03, 0xe0,
    0x00, 0x30,   0x01, 0x30,   0x02, 0x30,   0x03, 0x30,
    0x00, 0x70,   0x01, 0x70,   0x02, 0x70,   0x03, 0x70,
    0x00, 0xb0,   0x01, 0xb0,   0x02, 0xb0,   0x03, 0xb0,
    0x00, 0xf0,   0x01, 0xf0,   0x02, 0xf0,   0x03, 0xf0,
    0x00, 0x04,   0x01, 0x04,   0x02, 0x04,   0x03, 0x04,
    0x00, 0x44,   0x01, 0x44,   0x02, 0x44,   0x03, 0x44,
    0x00, 0x84,   0x01, 0x84,   0x02, 0x84,   0x03, 0x84,
    0x00, 0xc4,   0x01, 0xc4,   0x02, 0xc4,   0x03, 0xc4,
    0x00, 0x14,   0x01, 0x14,   0x02, 0x14,   0x03, 0x14,
    0x00, 0x54,   0x01, 0x54,   0x02, 0x54,   0x03, 0x54,
    0x00, 0x94,   0x01, 0x94,   0x02, 0x94,   0x03, 0x94,
    0x00, 0xd4,   0x01, 0xd4,   0x02, 0xd4,   0x03, 0xd4,
    0x00, 0x24,   0x01, 0x24,   0x02, 0x24,   0x03, 0x24,
    0x00, 0x64,   0x01, 0x64,   0x02, 0x64,   0x03, 0x64,
    0x00, 0xa4,   0x01, 0xa4,   0x02, 0xa4,   0x03, 0xa4,
    0x00, 0xe4,   0x01, 0xe4,   0x02, 0xe4,   0x03, 0xe4,
    0x00, 0x34,   0x01, 0x34,   0x02, 0x34,   0x03, 0x34,
    0x00, 0x74,   0x01, 0x74,   0x02, 0x74,   0x03, 0x74,
    0x00, 0xb4,   0x01, 0xb4,   0x02, 0xb4,   0x03, 0xb4,
    0x00, 0xf4,   0x01, 0xf4,   0x02, 0xf4,   0x03, 0xf4,
    0x00, 0x08,   0x01, 0x08,   0x02, 0x08,   0x03, 0x08,
    0x00, 0x48,   0x01, 0x48,   0x02, 0x48,   0x03, 0x48,
    0x00, 0x88,   0x01, 0x88,   0x02, 0x88,   0x03, 0x88,
    0x00, 0xc8,   0x01, 0xc8,   0x02, 0xc8,   0x03, 0xc8,
    0x00, 0x18,   0x01, 0x18,   0x02, 0x18,   0x03, 0x18,
    0x00, 0x58,   0x01, 0x58,   0x02, 0x58,   0x03, 0x58,
    0x00, 0x98,   0x01, 0x98,   0x02, 0x98,   0x03, 0x98,
    0x00, 0xd8,   0x01, 0xd8,   0x02, 0xd8,   0x03, 0xd8,
    0x00, 0x28,   0x01, 0x28,   0x02, 0x28,   0x03, 0x28,
    0x00, 0x68,   0x01, 0x68,   0x02, 0x68,   0x03, 0x68,
    0x00, 0xa8,   0x01, 0xa8,   0x02, 0xa8,   0x03, 0xa8,
    0x00, 0xe8,   0x01, 0xe8,   0x02, 0xe8,   0x03, 0xe8,
    0x00, 0x38,   0x01, 0x38,   0x02, 0x38,   0x03, 0x38,
    0x00, 0x78,   0x01, 0x78,   0x02, 0x78,   0x03, 0x78,
    0x00, 0xb8,   0x01, 0xb8,   0x02, 0xb8,   0x03, 0xb8,
    0x00, 0xf8,   0x01, 0xf8,   0x02, 0xf8,   0x03, 0xf8,
    0x00, 0x0c,   0x01, 0x0c,   0x02, 0x0c,   0x03, 0x0c,
    0x00, 0x4c,   0x01, 0x4c,   0x02, 0x4c,   0x03, 0x4c,
    0x00, 0x8c,   0x01, 0x8c,   0x02, 0x8c,   0x03, 0x8c,
    0x00, 0xcc,   0x01, 0xcc,   0x02, 0xcc,   0x03, 0xcc,
    0x00, 0x1c,   0x01, 0x1c,   0x02, 0x1c,   0x03, 0x1c,
    0x00, 0x5c,   0x01, 0x5c,   0x02, 0x5c,   0x03, 0x5c,
    0x00, 0x9c,   0x01, 0x9c,   0x02, 0x9c,   0x03, 0x9c,
    0x00, 0xdc,   0x01, 0xdc,   0x02, 0xdc,   0x03, 0xdc,
    0x00, 0x2c,   0x01, 0x2c,   0x02, 0x2c,   0x03, 0x2c,
    0x00, 0x6c,   0x01, 0x6c,   0x02, 0x6c,   0x03, 0x6c,
    0x00, 0xac,   0x01, 0xac,   0x02, 0xac,   0x03, 0xac,
    0x00, 0xec,   0x01, 0xec,   0x02, 0xec,   0x03, 0xec,
    0x00, 0x3c,   0x01, 0x3c,   0x02, 0x3c,   0x03, 0x3c,
    0x00, 0x7c,   0x01, 0x7c,   0x02, 0x7c,   0x03, 0x7c,
    0x00, 0xbc,   0x01, 0xbc,   0x02, 0xbc,   0x03, 0xbc,
    0x00, 0xfc,   0x01, 0xfc,   0x02, 0xfc,   0x03, 0xfc
};

const Uint1 C2naReverse::scm_Table1[512] = {
    0x00, 0x00,   0x04, 0x00,   0x08, 0x00,   0x0c, 0x00,
    0x01, 0x00,   0x05, 0x00,   0x09, 0x00,   0x0d, 0x00,
    0x02, 0x00,   0x06, 0x00,   0x0a, 0x00,   0x0e, 0x00,
    0x03, 0x00,   0x07, 0x00,   0x0b, 0x00,   0x0f, 0x00,
    0x00, 0x40,   0x04, 0x40,   0x08, 0x40,   0x0c, 0x40,
    0x01, 0x40,   0x05, 0x40,   0x09, 0x40,   0x0d, 0x40,
    0x02, 0x40,   0x06, 0x40,   0x0a, 0x40,   0x0e, 0x40,
    0x03, 0x40,   0x07, 0x40,   0x0b, 0x40,   0x0f, 0x40,
    0x00, 0x80,   0x04, 0x80,   0x08, 0x80,   0x0c, 0x80,
    0x01, 0x80,   0x05, 0x80,   0x09, 0x80,   0x0d, 0x80,
    0x02, 0x80,   0x06, 0x80,   0x0a, 0x80,   0x0e, 0x80,
    0x03, 0x80,   0x07, 0x80,   0x0b, 0x80,   0x0f, 0x80,
    0x00, 0xc0,   0x04, 0xc0,   0x08, 0xc0,   0x0c, 0xc0,
    0x01, 0xc0,   0x05, 0xc0,   0x09, 0xc0,   0x0d, 0xc0,
    0x02, 0xc0,   0x06, 0xc0,   0x0a, 0xc0,   0x0e, 0xc0,
    0x03, 0xc0,   0x07, 0xc0,   0x0b, 0xc0,   0x0f, 0xc0,
    0x00, 0x10,   0x04, 0x10,   0x08, 0x10,   0x0c, 0x10,
    0x01, 0x10,   0x05, 0x10,   0x09, 0x10,   0x0d, 0x10,
    0x02, 0x10,   0x06, 0x10,   0x0a, 0x10,   0x0e, 0x10,
    0x03, 0x10,   0x07, 0x10,   0x0b, 0x10,   0x0f, 0x10,
    0x00, 0x50,   0x04, 0x50,   0x08, 0x50,   0x0c, 0x50,
    0x01, 0x50,   0x05, 0x50,   0x09, 0x50,   0x0d, 0x50,
    0x02, 0x50,   0x06, 0x50,   0x0a, 0x50,   0x0e, 0x50,
    0x03, 0x50,   0x07, 0x50,   0x0b, 0x50,   0x0f, 0x50,
    0x00, 0x90,   0x04, 0x90,   0x08, 0x90,   0x0c, 0x90,
    0x01, 0x90,   0x05, 0x90,   0x09, 0x90,   0x0d, 0x90,
    0x02, 0x90,   0x06, 0x90,   0x0a, 0x90,   0x0e, 0x90,
    0x03, 0x90,   0x07, 0x90,   0x0b, 0x90,   0x0f, 0x90,
    0x00, 0xd0,   0x04, 0xd0,   0x08, 0xd0,   0x0c, 0xd0,
    0x01, 0xd0,   0x05, 0xd0,   0x09, 0xd0,   0x0d, 0xd0,
    0x02, 0xd0,   0x06, 0xd0,   0x0a, 0xd0,   0x0e, 0xd0,
    0x03, 0xd0,   0x07, 0xd0,   0x0b, 0xd0,   0x0f, 0xd0,
    0x00, 0x20,   0x04, 0x20,   0x08, 0x20,   0x0c, 0x20,
    0x01, 0x20,   0x05, 0x20,   0x09, 0x20,   0x0d, 0x20,
    0x02, 0x20,   0x06, 0x20,   0x0a, 0x20,   0x0e, 0x20,
    0x03, 0x20,   0x07, 0x20,   0x0b, 0x20,   0x0f, 0x20,
    0x00, 0x60,   0x04, 0x60,   0x08, 0x60,   0x0c, 0x60,
    0x01, 0x60,   0x05, 0x60,   0x09, 0x60,   0x0d, 0x60,
    0x02, 0x60,   0x06, 0x60,   0x0a, 0x60,   0x0e, 0x60,
    0x03, 0x60,   0x07, 0x60,   0x0b, 0x60,   0x0f, 0x60,
    0x00, 0xa0,   0x04, 0xa0,   0x08, 0xa0,   0x0c, 0xa0,
    0x01, 0xa0,   0x05, 0xa0,   0x09, 0xa0,   0x0d, 0xa0,
    0x02, 0xa0,   0x06, 0xa0,   0x0a, 0xa0,   0x0e, 0xa0,
    0x03, 0xa0,   0x07, 0xa0,   0x0b, 0xa0,   0x0f, 0xa0,
    0x00, 0xe0,   0x04, 0xe0,   0x08, 0xe0,   0x0c, 0xe0,
    0x01, 0xe0,   0x05, 0xe0,   0x09, 0xe0,   0x0d, 0xe0,
    0x02, 0xe0,   0x06, 0xe0,   0x0a, 0xe0,   0x0e, 0xe0,
    0x03, 0xe0,   0x07, 0xe0,   0x0b, 0xe0,   0x0f, 0xe0,
    0x00, 0x30,   0x04, 0x30,   0x08, 0x30,   0x0c, 0x30,
    0x01, 0x30,   0x05, 0x30,   0x09, 0x30,   0x0d, 0x30,
    0x02, 0x30,   0x06, 0x30,   0x0a, 0x30,   0x0e, 0x30,
    0x03, 0x30,   0x07, 0x30,   0x0b, 0x30,   0x0f, 0x30,
    0x00, 0x70,   0x04, 0x70,   0x08, 0x70,   0x0c, 0x70,
    0x01, 0x70,   0x05, 0x70,   0x09, 0x70,   0x0d, 0x70,
    0x02, 0x70,   0x06, 0x70,   0x0a, 0x70,   0x0e, 0x70,
    0x03, 0x70,   0x07, 0x70,   0x0b, 0x70,   0x0f, 0x70,
    0x00, 0xb0,   0x04, 0xb0,   0x08, 0xb0,   0x0c, 0xb0,
    0x01, 0xb0,   0x05, 0xb0,   0x09, 0xb0,   0x0d, 0xb0,
    0x02, 0xb0,   0x06, 0xb0,   0x0a, 0xb0,   0x0e, 0xb0,
    0x03, 0xb0,   0x07, 0xb0,   0x0b, 0xb0,   0x0f, 0xb0,
    0x00, 0xf0,   0x04, 0xf0,   0x08, 0xf0,   0x0c, 0xf0,
    0x01, 0xf0,   0x05, 0xf0,   0x09, 0xf0,   0x0d, 0xf0,
    0x02, 0xf0,   0x06, 0xf0,   0x0a, 0xf0,   0x0e, 0xf0,
    0x03, 0xf0,   0x07, 0xf0,   0x0b, 0xf0,   0x0f, 0xf0
};

const Uint1 C2naReverse::scm_Table0[512] = {
    0x00, 0x00,   0x10, 0x00,   0x20, 0x00,   0x30, 0x00,
    0x04, 0x00,   0x14, 0x00,   0x24, 0x00,   0x34, 0x00,
    0x08, 0x00,   0x18, 0x00,   0x28, 0x00,   0x38, 0x00,
    0x0c, 0x00,   0x1c, 0x00,   0x2c, 0x00,   0x3c, 0x00,
    0x01, 0x00,   0x11, 0x00,   0x21, 0x00,   0x31, 0x00,
    0x05, 0x00,   0x15, 0x00,   0x25, 0x00,   0x35, 0x00,
    0x09, 0x00,   0x19, 0x00,   0x29, 0x00,   0x39, 0x00,
    0x0d, 0x00,   0x1d, 0x00,   0x2d, 0x00,   0x3d, 0x00,
    0x02, 0x00,   0x12, 0x00,   0x22, 0x00,   0x32, 0x00,
    0x06, 0x00,   0x16, 0x00,   0x26, 0x00,   0x36, 0x00,
    0x0a, 0x00,   0x1a, 0x00,   0x2a, 0x00,   0x3a, 0x00,
    0x0e, 0x00,   0x1e, 0x00,   0x2e, 0x00,   0x3e, 0x00,
    0x03, 0x00,   0x13, 0x00,   0x23, 0x00,   0x33, 0x00,
    0x07, 0x00,   0x17, 0x00,   0x27, 0x00,   0x37, 0x00,
    0x0b, 0x00,   0x1b, 0x00,   0x2b, 0x00,   0x3b, 0x00,
    0x0f, 0x00,   0x1f, 0x00,   0x2f, 0x00,   0x3f, 0x00,
    0x00, 0x40,   0x10, 0x40,   0x20, 0x40,   0x30, 0x40,
    0x04, 0x40,   0x14, 0x40,   0x24, 0x40,   0x34, 0x40,
    0x08, 0x40,   0x18, 0x40,   0x28, 0x40,   0x38, 0x40,
    0x0c, 0x40,   0x1c, 0x40,   0x2c, 0x40,   0x3c, 0x40,
    0x01, 0x40,   0x11, 0x40,   0x21, 0x40,   0x31, 0x40,
    0x05, 0x40,   0x15, 0x40,   0x25, 0x40,   0x35, 0x40,
    0x09, 0x40,   0x19, 0x40,   0x29, 0x40,   0x39, 0x40,
    0x0d, 0x40,   0x1d, 0x40,   0x2d, 0x40,   0x3d, 0x40,
    0x02, 0x40,   0x12, 0x40,   0x22, 0x40,   0x32, 0x40,
    0x06, 0x40,   0x16, 0x40,   0x26, 0x40,   0x36, 0x40,
    0x0a, 0x40,   0x1a, 0x40,   0x2a, 0x40,   0x3a, 0x40,
    0x0e, 0x40,   0x1e, 0x40,   0x2e, 0x40,   0x3e, 0x40,
    0x03, 0x40,   0x13, 0x40,   0x23, 0x40,   0x33, 0x40,
    0x07, 0x40,   0x17, 0x40,   0x27, 0x40,   0x37, 0x40,
    0x0b, 0x40,   0x1b, 0x40,   0x2b, 0x40,   0x3b, 0x40,
    0x0f, 0x40,   0x1f, 0x40,   0x2f, 0x40,   0x3f, 0x40,
    0x00, 0x80,   0x10, 0x80,   0x20, 0x80,   0x30, 0x80,
    0x04, 0x80,   0x14, 0x80,   0x24, 0x80,   0x34, 0x80,
    0x08, 0x80,   0x18, 0x80,   0x28, 0x80,   0x38, 0x80,
    0x0c, 0x80,   0x1c, 0x80,   0x2c, 0x80,   0x3c, 0x80,
    0x01, 0x80,   0x11, 0x80,   0x21, 0x80,   0x31, 0x80,
    0x05, 0x80,   0x15, 0x80,   0x25, 0x80,   0x35, 0x80,
    0x09, 0x80,   0x19, 0x80,   0x29, 0x80,   0x39, 0x80,
    0x0d, 0x80,   0x1d, 0x80,   0x2d, 0x80,   0x3d, 0x80,
    0x02, 0x80,   0x12, 0x80,   0x22, 0x80,   0x32, 0x80,
    0x06, 0x80,   0x16, 0x80,   0x26, 0x80,   0x36, 0x80,
    0x0a, 0x80,   0x1a, 0x80,   0x2a, 0x80,   0x3a, 0x80,
    0x0e, 0x80,   0x1e, 0x80,   0x2e, 0x80,   0x3e, 0x80,
    0x03, 0x80,   0x13, 0x80,   0x23, 0x80,   0x33, 0x80,
    0x07, 0x80,   0x17, 0x80,   0x27, 0x80,   0x37, 0x80,
    0x0b, 0x80,   0x1b, 0x80,   0x2b, 0x80,   0x3b, 0x80,
    0x0f, 0x80,   0x1f, 0x80,   0x2f, 0x80,   0x3f, 0x80,
    0x00, 0xc0,   0x10, 0xc0,   0x20, 0xc0,   0x30, 0xc0,
    0x04, 0xc0,   0x14, 0xc0,   0x24, 0xc0,   0x34, 0xc0,
    0x08, 0xc0,   0x18, 0xc0,   0x28, 0xc0,   0x38, 0xc0,
    0x0c, 0xc0,   0x1c, 0xc0,   0x2c, 0xc0,   0x3c, 0xc0,
    0x01, 0xc0,   0x11, 0xc0,   0x21, 0xc0,   0x31, 0xc0,
    0x05, 0xc0,   0x15, 0xc0,   0x25, 0xc0,   0x35, 0xc0,
    0x09, 0xc0,   0x19, 0xc0,   0x29, 0xc0,   0x39, 0xc0,
    0x0d, 0xc0,   0x1d, 0xc0,   0x2d, 0xc0,   0x3d, 0xc0,
    0x02, 0xc0,   0x12, 0xc0,   0x22, 0xc0,   0x32, 0xc0,
    0x06, 0xc0,   0x16, 0xc0,   0x26, 0xc0,   0x36, 0xc0,
    0x0a, 0xc0,   0x1a, 0xc0,   0x2a, 0xc0,   0x3a, 0xc0,
    0x0e, 0xc0,   0x1e, 0xc0,   0x2e, 0xc0,   0x3e, 0xc0,
    0x03, 0xc0,   0x13, 0xc0,   0x23, 0xc0,   0x33, 0xc0,
    0x07, 0xc0,   0x17, 0xc0,   0x27, 0xc0,   0x37, 0xc0,
    0x0b, 0xc0,   0x1b, 0xc0,   0x2b, 0xc0,   0x3b, 0xc0,
    0x0f, 0xc0,   0x1f, 0xc0,   0x2f, 0xc0,   0x3f, 0xc0
};


// NCBI4na
const Uint1 C4naReverse::scm_Table[256] = {
    0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
    0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0,
    0x01, 0x11, 0x21, 0x31, 0x41, 0x51, 0x61, 0x71,
    0x81, 0x91, 0xa1, 0xb1, 0xc1, 0xd1, 0xe1, 0xf1,
    0x02, 0x12, 0x22, 0x32, 0x42, 0x52, 0x62, 0x72,
    0x82, 0x92, 0xa2, 0xb2, 0xc2, 0xd2, 0xe2, 0xf2,
    0x03, 0x13, 0x23, 0x33, 0x43, 0x53, 0x63, 0x73,
    0x83, 0x93, 0xa3, 0xb3, 0xc3, 0xd3, 0xe3, 0xf3,
    0x04, 0x14, 0x24, 0x34, 0x44, 0x54, 0x64, 0x74,
    0x84, 0x94, 0xa4, 0xb4, 0xc4, 0xd4, 0xe4, 0xf4,
    0x05, 0x15, 0x25, 0x35, 0x45, 0x55, 0x65, 0x75,
    0x85, 0x95, 0xa5, 0xb5, 0xc5, 0xd5, 0xe5, 0xf5,
    0x06, 0x16, 0x26, 0x36, 0x46, 0x56, 0x66, 0x76,
    0x86, 0x96, 0xa6, 0xb6, 0xc6, 0xd6, 0xe6, 0xf6,
    0x07, 0x17, 0x27, 0x37, 0x47, 0x57, 0x67, 0x77,
    0x87, 0x97, 0xa7, 0xb7, 0xc7, 0xd7, 0xe7, 0xf7,
    0x08, 0x18, 0x28, 0x38, 0x48, 0x58, 0x68, 0x78,
    0x88, 0x98, 0xa8, 0xb8, 0xc8, 0xd8, 0xe8, 0xf8,
    0x09, 0x19, 0x29, 0x39, 0x49, 0x59, 0x69, 0x79,
    0x89, 0x99, 0xa9, 0xb9, 0xc9, 0xd9, 0xe9, 0xf9,
    0x0a, 0x1a, 0x2a, 0x3a, 0x4a, 0x5a, 0x6a, 0x7a,
    0x8a, 0x9a, 0xaa, 0xba, 0xca, 0xda, 0xea, 0xfa,
    0x0b, 0x1b, 0x2b, 0x3b, 0x4b, 0x5b, 0x6b, 0x7b,
    0x8b, 0x9b, 0xab, 0xbb, 0xcb, 0xdb, 0xeb, 0xfb,
    0x0c, 0x1c, 0x2c, 0x3c, 0x4c, 0x5c, 0x6c, 0x7c,
    0x8c, 0x9c, 0xac, 0xbc, 0xcc, 0xdc, 0xec, 0xfc,
    0x0d, 0x1d, 0x2d, 0x3d, 0x4d, 0x5d, 0x6d, 0x7d,
    0x8d, 0x9d, 0xad, 0xbd, 0xcd, 0xdd, 0xed, 0xfd,
    0x0e, 0x1e, 0x2e, 0x3e, 0x4e, 0x5e, 0x6e, 0x7e,
    0x8e, 0x9e, 0xae, 0xbe, 0xce, 0xde, 0xee, 0xfe,
    0x0f, 0x1f, 0x2f, 0x3f, 0x4f, 0x5f, 0x6f, 0x7f,
    0x8f, 0x9f, 0xaf, 0xbf, 0xcf, 0xdf, 0xef, 0xff
};


/////////////////////////////////////////////////////////////////////////////
//
// Complement Tables

// IUPACna

const Uint1 CIupacnaCmp::scm_Table[256] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,

    0x40, 0x54, 0x56, 0x47, 0x48, 0x45, 0x46, 0x43,
    0x44, 0x49, 0x4a, 0x4d, 0x4c, 0x4b, 0x4e, 0x4f,
    0x50, 0x51, 0x59, 0x53, 0x41, 0x41, 0x42, 0x57,
    0x58, 0x52, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,

    0x60, 0x74, 0x76, 0x67, 0x68, 0x65, 0x66, 0x63,
    0x64, 0x69, 0x6a, 0x6d, 0x6c, 0x6b, 0x6e, 0x6f,
    0x70, 0x71, 0x79, 0x73, 0x61, 0x61, 0x62, 0x77,
    0x78, 0x72, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,

    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
    0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
    0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
    0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff
};


// NCBI2na
const Uint1* C2naCmp::scm_Tables[4] = {
    0, scm_Table1, scm_Table2, scm_Table3
};

const Uint1 C2naCmp::scm_Table1[512] = {
    0xfc, 0x03,    0xf8, 0x03,    0xf4, 0x03,    0xf0, 0x03,
    0xec, 0x03,    0xe8, 0x03,    0xe4, 0x03,    0xe0, 0x03,
    0xdc, 0x03,    0xd8, 0x03,    0xd4, 0x03,    0xd0, 0x03,
    0xcc, 0x03,    0xc8, 0x03,    0xc4, 0x03,    0xc0, 0x03,
    0xbc, 0x03,    0xb8, 0x03,    0xb4, 0x03,    0xb0, 0x03,
    0xac, 0x03,    0xa8, 0x03,    0xa4, 0x03,    0xa0, 0x03,
    0x9c, 0x03,    0x98, 0x03,    0x94, 0x03,    0x90, 0x03,
    0x8c, 0x03,    0x88, 0x03,    0x84, 0x03,    0x80, 0x03,
    0x7c, 0x03,    0x78, 0x03,    0x74, 0x03,    0x70, 0x03,
    0x6c, 0x03,    0x68, 0x03,    0x64, 0x03,    0x60, 0x03,
    0x5c, 0x03,    0x58, 0x03,    0x54, 0x03,    0x50, 0x03,
    0x4c, 0x03,    0x48, 0x03,    0x44, 0x03,    0x40, 0x03,
    0x3c, 0x03,    0x38, 0x03,    0x34, 0x03,    0x30, 0x03,
    0x2c, 0x03,    0x28, 0x03,    0x24, 0x03,    0x20, 0x03,
    0x1c, 0x03,    0x18, 0x03,    0x14, 0x03,    0x10, 0x03,
    0x0c, 0x03,    0x08, 0x03,    0x04, 0x03,    0x00, 0x03,
    0xfc, 0x02,    0xf8, 0x02,    0xf4, 0x02,    0xf0, 0x02,
    0xec, 0x02,    0xe8, 0x02,    0xe4, 0x02,    0xe0, 0x02,
    0xdc, 0x02,    0xd8, 0x02,    0xd4, 0x02,    0xd0, 0x02,
    0xcc, 0x02,    0xc8, 0x02,    0xc4, 0x02,    0xc0, 0x02,
    0xbc, 0x02,    0xb8, 0x02,    0xb4, 0x02,    0xb0, 0x02,
    0xac, 0x02,    0xa8, 0x02,    0xa4, 0x02,    0xa0, 0x02,
    0x9c, 0x02,    0x98, 0x02,    0x94, 0x02,    0x90, 0x02,
    0x8c, 0x02,    0x88, 0x02,    0x84, 0x02,    0x80, 0x02,
    0x7c, 0x02,    0x78, 0x02,    0x74, 0x02,    0x70, 0x02,
    0x6c, 0x02,    0x68, 0x02,    0x64, 0x02,    0x60, 0x02,
    0x5c, 0x02,    0x58, 0x02,    0x54, 0x02,    0x50, 0x02,
    0x4c, 0x02,    0x48, 0x02,    0x44, 0x02,    0x40, 0x02,
    0x3c, 0x02,    0x38, 0x02,    0x34, 0x02,    0x30, 0x02,
    0x2c, 0x02,    0x28, 0x02,    0x24, 0x02,    0x20, 0x02,
    0x1c, 0x02,    0x18, 0x02,    0x14, 0x02,    0x10, 0x02,
    0x0c, 0x02,    0x08, 0x02,    0x04, 0x02,    0x00, 0x02,
    0xfc, 0x01,    0xf8, 0x01,    0xf4, 0x01,    0xf0, 0x01,
    0xec, 0x01,    0xe8, 0x01,    0xe4, 0x01,    0xe0, 0x01,
    0xdc, 0x01,    0xd8, 0x01,    0xd4, 0x01,    0xd0, 0x01,
    0xcc, 0x01,    0xc8, 0x01,    0xc4, 0x01,    0xc0, 0x01,
    0xbc, 0x01,    0xb8, 0x01,    0xb4, 0x01,    0xb0, 0x01,
    0xac, 0x01,    0xa8, 0x01,    0xa4, 0x01,    0xa0, 0x01,
    0x9c, 0x01,    0x98, 0x01,    0x94, 0x01,    0x90, 0x01,
    0x8c, 0x01,    0x88, 0x01,    0x84, 0x01,    0x80, 0x01,
    0x7c, 0x01,    0x78, 0x01,    0x74, 0x01,    0x70, 0x01,
    0x6c, 0x01,    0x68, 0x01,    0x64, 0x01,    0x60, 0x01,
    0x5c, 0x01,    0x58, 0x01,    0x54, 0x01,    0x50, 0x01,
    0x4c, 0x01,    0x48, 0x01,    0x44, 0x01,    0x40, 0x01,
    0x3c, 0x01,    0x38, 0x01,    0x34, 0x01,    0x30, 0x01,
    0x2c, 0x01,    0x28, 0x01,    0x24, 0x01,    0x20, 0x01,
    0x1c, 0x01,    0x18, 0x01,    0x14, 0x01,    0x10, 0x01,
    0x0c, 0x01,    0x08, 0x01,    0x04, 0x01,    0x00, 0x01,
    0xfc, 0x00,    0xf8, 0x00,    0xf4, 0x00,    0xf0, 0x00,
    0xec, 0x00,    0xe8, 0x00,    0xe4, 0x00,    0xe0, 0x00,
    0xdc, 0x00,    0xd8, 0x00,    0xd4, 0x00,    0xd0, 0x00,
    0xcc, 0x00,    0xc8, 0x00,    0xc4, 0x00,    0xc0, 0x00,
    0xbc, 0x00,    0xb8, 0x00,    0xb4, 0x00,    0xb0, 0x00,
    0xac, 0x00,    0xa8, 0x00,    0xa4, 0x00,    0xa0, 0x00,
    0x9c, 0x00,    0x98, 0x00,    0x94, 0x00,    0x90, 0x00,
    0x8c, 0x00,    0x88, 0x00,    0x84, 0x00,    0x80, 0x00,
    0x7c, 0x00,    0x78, 0x00,    0x74, 0x00,    0x70, 0x00,
    0x6c, 0x00,    0x68, 0x00,    0x64, 0x00,    0x60, 0x00,
    0x5c, 0x00,    0x58, 0x00,    0x54, 0x00,    0x50, 0x00,
    0x4c, 0x00,    0x48, 0x00,    0x44, 0x00,    0x40, 0x00,
    0x3c, 0x00,    0x38, 0x00,    0x34, 0x00,    0x30, 0x00,
    0x2c, 0x00,    0x28, 0x00,    0x24, 0x00,    0x20, 0x00,
    0x1c, 0x00,    0x18, 0x00,    0x14, 0x00,    0x10, 0x00,
    0x0c, 0x00,    0x08, 0x00,    0x04, 0x00,    0x00, 0x00
};

const Uint1 C2naCmp::scm_Table2[512] = {
    0xf0, 0x0f,    0xe0, 0x0f,    0xd0, 0x0f,    0xc0, 0x0f,
    0xb0, 0x0f,    0xa0, 0x0f,    0x90, 0x0f,    0x80, 0x0f,
    0x70, 0x0f,    0x60, 0x0f,    0x50, 0x0f,    0x40, 0x0f,
    0x30, 0x0f,    0x20, 0x0f,    0x10, 0x0f,    0x00, 0x0f,
    0xf0, 0x0e,    0xe0, 0x0e,    0xd0, 0x0e,    0xc0, 0x0e,
    0xb0, 0x0e,    0xa0, 0x0e,    0x90, 0x0e,    0x80, 0x0e,
    0x70, 0x0e,    0x60, 0x0e,    0x50, 0x0e,    0x40, 0x0e,
    0x30, 0x0e,    0x20, 0x0e,    0x10, 0x0e,    0x00, 0x0e,
    0xf0, 0x0d,    0xe0, 0x0d,    0xd0, 0x0d,    0xc0, 0x0d,
    0xb0, 0x0d,    0xa0, 0x0d,    0x90, 0x0d,    0x80, 0x0d,
    0x70, 0x0d,    0x60, 0x0d,    0x50, 0x0d,    0x40, 0x0d,
    0x30, 0x0d,    0x20, 0x0d,    0x10, 0x0d,    0x00, 0x0d,
    0xf0, 0x0c,    0xe0, 0x0c,    0xd0, 0x0c,    0xc0, 0x0c,
    0xb0, 0x0c,    0xa0, 0x0c,    0x90, 0x0c,    0x80, 0x0c,
    0x70, 0x0c,    0x60, 0x0c,    0x50, 0x0c,    0x40, 0x0c,
    0x30, 0x0c,    0x20, 0x0c,    0x10, 0x0c,    0x00, 0x0c,
    0xf0, 0x0b,    0xe0, 0x0b,    0xd0, 0x0b,    0xc0, 0x0b,
    0xb0, 0x0b,    0xa0, 0x0b,    0x90, 0x0b,    0x80, 0x0b,
    0x70, 0x0b,    0x60, 0x0b,    0x50, 0x0b,    0x40, 0x0b,
    0x30, 0x0b,    0x20, 0x0b,    0x10, 0x0b,    0x00, 0x0b,
    0xf0, 0x0a,    0xe0, 0x0a,    0xd0, 0x0a,    0xc0, 0x0a,
    0xb0, 0x0a,    0xa0, 0x0a,    0x90, 0x0a,    0x80, 0x0a,
    0x70, 0x0a,    0x60, 0x0a,    0x50, 0x0a,    0x40, 0x0a,
    0x30, 0x0a,    0x20, 0x0a,    0x10, 0x0a,    0x00, 0x0a,
    0xf0, 0x09,    0xe0, 0x09,    0xd0, 0x09,    0xc0, 0x09,
    0xb0, 0x09,    0xa0, 0x09,    0x90, 0x09,    0x80, 0x09,
    0x70, 0x09,    0x60, 0x09,    0x50, 0x09,    0x40, 0x09,
    0x30, 0x09,    0x20, 0x09,    0x10, 0x09,    0x00, 0x09,
    0xf0, 0x08,    0xe0, 0x08,    0xd0, 0x08,    0xc0, 0x08,
    0xb0, 0x08,    0xa0, 0x08,    0x90, 0x08,    0x80, 0x08,
    0x70, 0x08,    0x60, 0x08,    0x50, 0x08,    0x40, 0x08,
    0x30, 0x08,    0x20, 0x08,    0x10, 0x08,    0x00, 0x08,
    0xf0, 0x07,    0xe0, 0x07,    0xd0, 0x07,    0xc0, 0x07,
    0xb0, 0x07,    0xa0, 0x07,    0x90, 0x07,    0x80, 0x07,
    0x70, 0x07,    0x60, 0x07,    0x50, 0x07,    0x40, 0x07,
    0x30, 0x07,    0x20, 0x07,    0x10, 0x07,    0x00, 0x07,
    0xf0, 0x06,    0xe0, 0x06,    0xd0, 0x06,    0xc0, 0x06,
    0xb0, 0x06,    0xa0, 0x06,    0x90, 0x06,    0x80, 0x06,
    0x70, 0x06,    0x60, 0x06,    0x50, 0x06,    0x40, 0x06,
    0x30, 0x06,    0x20, 0x06,    0x10, 0x06,    0x00, 0x06,
    0xf0, 0x05,    0xe0, 0x05,    0xd0, 0x05,    0xc0, 0x05,
    0xb0, 0x05,    0xa0, 0x05,    0x90, 0x05,    0x80, 0x05,
    0x70, 0x05,    0x60, 0x05,    0x50, 0x05,    0x40, 0x05,
    0x30, 0x05,    0x20, 0x05,    0x10, 0x05,    0x00, 0x05,
    0xf0, 0x04,    0xe0, 0x04,    0xd0, 0x04,    0xc0, 0x04,
    0xb0, 0x04,    0xa0, 0x04,    0x90, 0x04,    0x80, 0x04,
    0x70, 0x04,    0x60, 0x04,    0x50, 0x04,    0x40, 0x04,
    0x30, 0x04,    0x20, 0x04,    0x10, 0x04,    0x00, 0x04,
    0xf0, 0x03,    0xe0, 0x03,    0xd0, 0x03,    0xc0, 0x03,
    0xb0, 0x03,    0xa0, 0x03,    0x90, 0x03,    0x80, 0x03,
    0x70, 0x03,    0x60, 0x03,    0x50, 0x03,    0x40, 0x03,
    0x30, 0x03,    0x20, 0x03,    0x10, 0x03,    0x00, 0x03,
    0xf0, 0x02,    0xe0, 0x02,    0xd0, 0x02,    0xc0, 0x02,
    0xb0, 0x02,    0xa0, 0x02,    0x90, 0x02,    0x80, 0x02,
    0x70, 0x02,    0x60, 0x02,    0x50, 0x02,    0x40, 0x02,
    0x30, 0x02,    0x20, 0x02,    0x10, 0x02,    0x00, 0x02,
    0xf0, 0x01,    0xe0, 0x01,    0xd0, 0x01,    0xc0, 0x01,
    0xb0, 0x01,    0xa0, 0x01,    0x90, 0x01,    0x80, 0x01,
    0x70, 0x01,    0x60, 0x01,    0x50, 0x01,    0x40, 0x01,
    0x30, 0x01,    0x20, 0x01,    0x10, 0x01,    0x00, 0x01,
    0xf0, 0x00,    0xe0, 0x00,    0xd0, 0x00,    0xc0, 0x00,
    0xb0, 0x00,    0xa0, 0x00,    0x90, 0x00,    0x80, 0x00,
    0x70, 0x00,    0x60, 0x00,    0x50, 0x00,    0x40, 0x00,
    0x30, 0x00,    0x20, 0x00,    0x10, 0x00,    0x00, 0x00
};

const Uint1 C2naCmp::scm_Table3[512] = {
    0xc0, 0x3f,    0x80, 0x3f,    0x40, 0x3f,    0x00, 0x3f,
    0xc0, 0x3e,    0x80, 0x3e,    0x40, 0x3e,    0x00, 0x3e,
    0xc0, 0x3d,    0x80, 0x3d,    0x40, 0x3d,    0x00, 0x3d,
    0xc0, 0x3c,    0x80, 0x3c,    0x40, 0x3c,    0x00, 0x3c,
    0xc0, 0x3b,    0x80, 0x3b,    0x40, 0x3b,    0x00, 0x3b,
    0xc0, 0x3a,    0x80, 0x3a,    0x40, 0x3a,    0x00, 0x3a,
    0xc0, 0x39,    0x80, 0x39,    0x40, 0x39,    0x00, 0x39,
    0xc0, 0x38,    0x80, 0x38,    0x40, 0x38,    0x00, 0x38,
    0xc0, 0x37,    0x80, 0x37,    0x40, 0x37,    0x00, 0x37,
    0xc0, 0x36,    0x80, 0x36,    0x40, 0x36,    0x00, 0x36,
    0xc0, 0x35,    0x80, 0x35,    0x40, 0x35,    0x00, 0x35,
    0xc0, 0x34,    0x80, 0x34,    0x40, 0x34,    0x00, 0x34,
    0xc0, 0x33,    0x80, 0x33,    0x40, 0x33,    0x00, 0x33,
    0xc0, 0x32,    0x80, 0x32,    0x40, 0x32,    0x00, 0x32,
    0xc0, 0x31,    0x80, 0x31,    0x40, 0x31,    0x00, 0x31,
    0xc0, 0x30,    0x80, 0x30,    0x40, 0x30,    0x00, 0x30,
    0xc0, 0x2f,    0x80, 0x2f,    0x40, 0x2f,    0x00, 0x2f,
    0xc0, 0x2e,    0x80, 0x2e,    0x40, 0x2e,    0x00, 0x2e,
    0xc0, 0x2d,    0x80, 0x2d,    0x40, 0x2d,    0x00, 0x2d,
    0xc0, 0x2c,    0x80, 0x2c,    0x40, 0x2c,    0x00, 0x2c,
    0xc0, 0x2b,    0x80, 0x2b,    0x40, 0x2b,    0x00, 0x2b,
    0xc0, 0x2a,    0x80, 0x2a,    0x40, 0x2a,    0x00, 0x2a,
    0xc0, 0x29,    0x80, 0x29,    0x40, 0x29,    0x00, 0x29,
    0xc0, 0x28,    0x80, 0x28,    0x40, 0x28,    0x00, 0x28,
    0xc0, 0x27,    0x80, 0x27,    0x40, 0x27,    0x00, 0x27,
    0xc0, 0x26,    0x80, 0x26,    0x40, 0x26,    0x00, 0x26,
    0xc0, 0x25,    0x80, 0x25,    0x40, 0x25,    0x00, 0x25,
    0xc0, 0x24,    0x80, 0x24,    0x40, 0x24,    0x00, 0x24,
    0xc0, 0x23,    0x80, 0x23,    0x40, 0x23,    0x00, 0x23,
    0xc0, 0x22,    0x80, 0x22,    0x40, 0x22,    0x00, 0x22,
    0xc0, 0x21,    0x80, 0x21,    0x40, 0x21,    0x00, 0x21,
    0xc0, 0x20,    0x80, 0x20,    0x40, 0x20,    0x00, 0x20,
    0xc0, 0x1f,    0x80, 0x1f,    0x40, 0x1f,    0x00, 0x1f,
    0xc0, 0x1e,    0x80, 0x1e,    0x40, 0x1e,    0x00, 0x1e,
    0xc0, 0x1d,    0x80, 0x1d,    0x40, 0x1d,    0x00, 0x1d,
    0xc0, 0x1c,    0x80, 0x1c,    0x40, 0x1c,    0x00, 0x1c,
    0xc0, 0x1b,    0x80, 0x1b,    0x40, 0x1b,    0x00, 0x1b,
    0xc0, 0x1a,    0x80, 0x1a,    0x40, 0x1a,    0x00, 0x1a,
    0xc0, 0x19,    0x80, 0x19,    0x40, 0x19,    0x00, 0x19,
    0xc0, 0x18,    0x80, 0x18,    0x40, 0x18,    0x00, 0x18,
    0xc0, 0x17,    0x80, 0x17,    0x40, 0x17,    0x00, 0x17,
    0xc0, 0x16,    0x80, 0x16,    0x40, 0x16,    0x00, 0x16,
    0xc0, 0x15,    0x80, 0x15,    0x40, 0x15,    0x00, 0x15,
    0xc0, 0x14,    0x80, 0x14,    0x40, 0x14,    0x00, 0x14,
    0xc0, 0x13,    0x80, 0x13,    0x40, 0x13,    0x00, 0x13,
    0xc0, 0x12,    0x80, 0x12,    0x40, 0x12,    0x00, 0x12,
    0xc0, 0x11,    0x80, 0x11,    0x40, 0x11,    0x00, 0x11,
    0xc0, 0x10,    0x80, 0x10,    0x40, 0x10,    0x00, 0x10,
    0xc0, 0x0f,    0x80, 0x0f,    0x40, 0x0f,    0x00, 0x0f,
    0xc0, 0x0e,    0x80, 0x0e,    0x40, 0x0e,    0x00, 0x0e,
    0xc0, 0x0d,    0x80, 0x0d,    0x40, 0x0d,    0x00, 0x0d,
    0xc0, 0x0c,    0x80, 0x0c,    0x40, 0x0c,    0x00, 0x0c,
    0xc0, 0x0b,    0x80, 0x0b,    0x40, 0x0b,    0x00, 0x0b,
    0xc0, 0x0a,    0x80, 0x0a,    0x40, 0x0a,    0x00, 0x0a,
    0xc0, 0x09,    0x80, 0x09,    0x40, 0x09,    0x00, 0x09,
    0xc0, 0x08,    0x80, 0x08,    0x40, 0x08,    0x00, 0x08,
    0xc0, 0x07,    0x80, 0x07,    0x40, 0x07,    0x00, 0x07,
    0xc0, 0x06,    0x80, 0x06,    0x40, 0x06,    0x00, 0x06,
    0xc0, 0x05,    0x80, 0x05,    0x40, 0x05,    0x00, 0x05,
    0xc0, 0x04,    0x80, 0x04,    0x40, 0x04,    0x00, 0x04,
    0xc0, 0x03,    0x80, 0x03,    0x40, 0x03,    0x00, 0x03,
    0xc0, 0x02,    0x80, 0x02,    0x40, 0x02,    0x00, 0x02,
    0xc0, 0x01,    0x80, 0x01,    0x40, 0x01,    0x00, 0x01,
    0xc0, 0x00,    0x80, 0x00,    0x40, 0x00,    0x00, 0x00
};


// NCBI4na
const Uint1 C4naCmp::scm_Table0[256] = {
    0x00, 0x08, 0x04, 0x0c, 0x02, 0x0a, 0x06, 0x0e,
    0x01, 0x09, 0x05, 0x0d, 0x03, 0x0b, 0x07, 0x0f,
    0x80, 0x88, 0x84, 0x8c, 0x82, 0x8a, 0x86, 0x8e,
    0x81, 0x89, 0x85, 0x8d, 0x83, 0x8b, 0x87, 0x8f,
    0x40, 0x48, 0x44, 0x4c, 0x42, 0x4a, 0x46, 0x4e,
    0x41, 0x49, 0x45, 0x4d, 0x43, 0x4b, 0x47, 0x4f,
    0xc0, 0xc8, 0xc4, 0xcc, 0xc2, 0xca, 0xc6, 0xce,
    0xc1, 0xc9, 0xc5, 0xcd, 0xc3, 0xcb, 0xc7, 0xcf,
    0x20, 0x28, 0x24, 0x2c, 0x22, 0x2a, 0x26, 0x2e,
    0x21, 0x29, 0x25, 0x2d, 0x23, 0x2b, 0x27, 0x2f,
    0xa0, 0xa8, 0xa4, 0xac, 0xa2, 0xaa, 0xa6, 0xae,
    0xa1, 0xa9, 0xa5, 0xad, 0xa3, 0xab, 0xa7, 0xaf,
    0x60, 0x68, 0x64, 0x6c, 0x62, 0x6a, 0x66, 0x6e,
    0x61, 0x69, 0x65, 0x6d, 0x63, 0x6b, 0x67, 0x6f,
    0xe0, 0xe8, 0xe4, 0xec, 0xe2, 0xea, 0xe6, 0xee,
    0xe1, 0xe9, 0xe5, 0xed, 0xe3, 0xeb, 0xe7, 0xef,
    0x10, 0x18, 0x14, 0x1c, 0x12, 0x1a, 0x16, 0x1e,
    0x11, 0x19, 0x15, 0x1d, 0x13, 0x1b, 0x17, 0x1f,
    0x90, 0x98, 0x94, 0x9c, 0x92, 0x9a, 0x96, 0x9e,
    0x91, 0x99, 0x95, 0x9d, 0x93, 0x9b, 0x97, 0x9f,
    0x50, 0x58, 0x54, 0x5c, 0x52, 0x5a, 0x56, 0x5e,
    0x51, 0x59, 0x55, 0x5d, 0x53, 0x5b, 0x57, 0x5f,
    0xd0, 0xd8, 0xd4, 0xdc, 0xd2, 0xda, 0xd6, 0xde,
    0xd1, 0xd9, 0xd5, 0xdd, 0xd3, 0xdb, 0xd7, 0xdf,
    0x30, 0x38, 0x34, 0x3c, 0x32, 0x3a, 0x36, 0x3e,
    0x31, 0x39, 0x35, 0x3d, 0x33, 0x3b, 0x37, 0x3f,
    0xb0, 0xb8, 0xb4, 0xbc, 0xb2, 0xba, 0xb6, 0xbe,
    0xb1, 0xb9, 0xb5, 0xbd, 0xb3, 0xbb, 0xb7, 0xbf,
    0x70, 0x78, 0x74, 0x7c, 0x72, 0x7a, 0x76, 0x7e,
    0x71, 0x79, 0x75, 0x7d, 0x73, 0x7b, 0x77, 0x7f,
    0xf0, 0xf8, 0xf4, 0xfc, 0xf2, 0xfa, 0xf6, 0xfe,
    0xf1, 0xf9, 0xf5, 0xfd, 0xf3, 0xfb, 0xf7, 0xff
};

const Uint1 C4naCmp::scm_Table1[512] = {
    0x00, 0x00,    0x80, 0x00,    0x40, 0x00,    0xc0, 0x00,
    0x20, 0x00,    0xa0, 0x00,    0x60, 0x00,    0xe0, 0x00,
    0x10, 0x00,    0x90, 0x00,    0x50, 0x00,    0xd0, 0x00,
    0x30, 0x00,    0xb0, 0x00,    0x70, 0x00,    0xf0, 0x00,
    0x00, 0x08,    0x80, 0x08,    0x40, 0x08,    0xc0, 0x08,
    0x20, 0x08,    0xa0, 0x08,    0x60, 0x08,    0xe0, 0x08,
    0x10, 0x08,    0x90, 0x08,    0x50, 0x08,    0xd0, 0x08,
    0x30, 0x08,    0xb0, 0x08,    0x70, 0x08,    0xf0, 0x08,
    0x00, 0x04,    0x80, 0x04,    0x40, 0x04,    0xc0, 0x04,
    0x20, 0x04,    0xa0, 0x04,    0x60, 0x04,    0xe0, 0x04,
    0x10, 0x04,    0x90, 0x04,    0x50, 0x04,    0xd0, 0x04,
    0x30, 0x04,    0xb0, 0x04,    0x70, 0x04,    0xf0, 0x04,
    0x00, 0x0c,    0x80, 0x0c,    0x40, 0x0c,    0xc0, 0x0c,
    0x20, 0x0c,    0xa0, 0x0c,    0x60, 0x0c,    0xe0, 0x0c,
    0x10, 0x0c,    0x90, 0x0c,    0x50, 0x0c,    0xd0, 0x0c,
    0x30, 0x0c,    0xb0, 0x0c,    0x70, 0x0c,    0xf0, 0x0c,
    0x00, 0x02,    0x80, 0x02,    0x40, 0x02,    0xc0, 0x02,
    0x20, 0x02,    0xa0, 0x02,    0x60, 0x02,    0xe0, 0x02,
    0x10, 0x02,    0x90, 0x02,    0x50, 0x02,    0xd0, 0x02,
    0x30, 0x02,    0xb0, 0x02,    0x70, 0x02,    0xf0, 0x02,
    0x00, 0x0a,    0x80, 0x0a,    0x40, 0x0a,    0xc0, 0x0a,
    0x20, 0x0a,    0xa0, 0x0a,    0x60, 0x0a,    0xe0, 0x0a,
    0x10, 0x0a,    0x90, 0x0a,    0x50, 0x0a,    0xd0, 0x0a,
    0x30, 0x0a,    0xb0, 0x0a,    0x70, 0x0a,    0xf0, 0x0a,
    0x00, 0x06,    0x80, 0x06,    0x40, 0x06,    0xc0, 0x06,
    0x20, 0x06,    0xa0, 0x06,    0x60, 0x06,    0xe0, 0x06,
    0x10, 0x06,    0x90, 0x06,    0x50, 0x06,    0xd0, 0x06,
    0x30, 0x06,    0xb0, 0x06,    0x70, 0x06,    0xf0, 0x06,
    0x00, 0x0e,    0x80, 0x0e,    0x40, 0x0e,    0xc0, 0x0e,
    0x20, 0x0e,    0xa0, 0x0e,    0x60, 0x0e,    0xe0, 0x0e,
    0x10, 0x0e,    0x90, 0x0e,    0x50, 0x0e,    0xd0, 0x0e,
    0x30, 0x0e,    0xb0, 0x0e,    0x70, 0x0e,    0xf0, 0x0e,
    0x00, 0x01,    0x80, 0x01,    0x40, 0x01,    0xc0, 0x01,
    0x20, 0x01,    0xa0, 0x01,    0x60, 0x01,    0xe0, 0x01,
    0x10, 0x01,    0x90, 0x01,    0x50, 0x01,    0xd0, 0x01,
    0x30, 0x01,    0xb0, 0x01,    0x70, 0x01,    0xf0, 0x01,
    0x00, 0x09,    0x80, 0x09,    0x40, 0x09,    0xc0, 0x09,
    0x20, 0x09,    0xa0, 0x09,    0x60, 0x09,    0xe0, 0x09,
    0x10, 0x09,    0x90, 0x09,    0x50, 0x09,    0xd0, 0x09,
    0x30, 0x09,    0xb0, 0x09,    0x70, 0x09,    0xf0, 0x09,
    0x00, 0x05,    0x80, 0x05,    0x40, 0x05,    0xc0, 0x05,
    0x20, 0x05,    0xa0, 0x05,    0x60, 0x05,    0xe0, 0x05,
    0x10, 0x05,    0x90, 0x05,    0x50, 0x05,    0xd0, 0x05,
    0x30, 0x05,    0xb0, 0x05,    0x70, 0x05,    0xf0, 0x05,
    0x00, 0x0d,    0x80, 0x0d,    0x40, 0x0d,    0xc0, 0x0d,
    0x20, 0x0d,    0xa0, 0x0d,    0x60, 0x0d,    0xe0, 0x0d,
    0x10, 0x0d,    0x90, 0x0d,    0x50, 0x0d,    0xd0, 0x0d,
    0x30, 0x0d,    0xb0, 0x0d,    0x70, 0x0d,    0xf0, 0x0d,
    0x00, 0x03,    0x80, 0x03,    0x40, 0x03,    0xc0, 0x03,
    0x20, 0x03,    0xa0, 0x03,    0x60, 0x03,    0xe0, 0x03,
    0x10, 0x03,    0x90, 0x03,    0x50, 0x03,    0xd0, 0x03,
    0x30, 0x03,    0xb0, 0x03,    0x70, 0x03,    0xf0, 0x03,
    0x00, 0x0b,    0x80, 0x0b,    0x40, 0x0b,    0xc0, 0x0b,
    0x20, 0x0b,    0xa0, 0x0b,    0x60, 0x0b,    0xe0, 0x0b,
    0x10, 0x0b,    0x90, 0x0b,    0x50, 0x0b,    0xd0, 0x0b,
    0x30, 0x0b,    0xb0, 0x0b,    0x70, 0x0b,    0xf0, 0x0b,
    0x00, 0x07,    0x80, 0x07,    0x40, 0x07,    0xc0, 0x07,
    0x20, 0x07,    0xa0, 0x07,    0x60, 0x07,    0xe0, 0x07,
    0x10, 0x07,    0x90, 0x07,    0x50, 0x07,    0xd0, 0x07,
    0x30, 0x07,    0xb0, 0x07,    0x70, 0x07,    0xf0, 0x07,
    0x00, 0x0f,    0x80, 0x0f,    0x40, 0x0f,    0xc0, 0x0f,
    0x20, 0x0f,    0xa0, 0x0f,    0x60, 0x0f,    0xe0, 0x0f,
    0x10, 0x0f,    0x90, 0x0f,    0x50, 0x0f,    0xd0, 0x0f,
    0x30, 0x0f,    0xb0, 0x0f,    0x70, 0x0f,    0xf0, 0x0f
};


// NCBI8na
const Uint1 C8naCmp::scm_Table[256] = {
    0x00, 0x08, 0x04, 0x0c, 0x02, 0x0a, 0x06, 0x0e,
    0x01, 0x09, 0x05, 0x0d, 0x03, 0x0b, 0x07, 0x0f,
    0x80, 0x88, 0x84, 0x8c, 0x82, 0x8a, 0x86, 0x8e,
    0x81, 0x89, 0x85, 0x8d, 0x83, 0x8b, 0x87, 0x8f,
    0x40, 0x48, 0x44, 0x4c, 0x42, 0x4a, 0x46, 0x4e,
    0x41, 0x49, 0x45, 0x4d, 0x43, 0x4b, 0x47, 0x4f,
    0xc0, 0xc8, 0xc4, 0xcc, 0xc2, 0xca, 0xc6, 0xce,
    0xc1, 0xc9, 0xc5, 0xcd, 0xc3, 0xcb, 0xc7, 0xcf,
    0x20, 0x28, 0x24, 0x2c, 0x22, 0x2a, 0x26, 0x2e,
    0x21, 0x29, 0x25, 0x2d, 0x23, 0x2b, 0x27, 0x2f,
    0xa0, 0xa8, 0xa4, 0xac, 0xa2, 0xaa, 0xa6, 0xae,
    0xa1, 0xa9, 0xa5, 0xad, 0xa3, 0xab, 0xa7, 0xaf,
    0x60, 0x68, 0x64, 0x6c, 0x62, 0x6a, 0x66, 0x6e,
    0x61, 0x69, 0x65, 0x6d, 0x63, 0x6b, 0x67, 0x6f,
    0xe0, 0xe8, 0xe4, 0xec, 0xe2, 0xea, 0xe6, 0xee,
    0xe1, 0xe9, 0xe5, 0xed, 0xe3, 0xeb, 0xe7, 0xef,
    0x10, 0x18, 0x14, 0x1c, 0x12, 0x1a, 0x16, 0x1e,
    0x11, 0x19, 0x15, 0x1d, 0x13, 0x1b, 0x17, 0x1f,
    0x90, 0x98, 0x94, 0x9c, 0x92, 0x9a, 0x96, 0x9e,
    0x91, 0x99, 0x95, 0x9d, 0x93, 0x9b, 0x97, 0x9f,
    0x50, 0x58, 0x54, 0x5c, 0x52, 0x5a, 0x56, 0x5e,
    0x51, 0x59, 0x55, 0x5d, 0x53, 0x5b, 0x57, 0x5f,
    0xd0, 0xd8, 0xd4, 0xdc, 0xd2, 0xda, 0xd6, 0xde,
    0xd1, 0xd9, 0xd5, 0xdd, 0xd3, 0xdb, 0xd7, 0xdf,
    0x30, 0x38, 0x34, 0x3c, 0x32, 0x3a, 0x36, 0x3e,
    0x31, 0x39, 0x35, 0x3d, 0x33, 0x3b, 0x37, 0x3f,
    0xb0, 0xb8, 0xb4, 0xbc, 0xb2, 0xba, 0xb6, 0xbe,
    0xb1, 0xb9, 0xb5, 0xbd, 0xb3, 0xbb, 0xb7, 0xbf,
    0x70, 0x78, 0x74, 0x7c, 0x72, 0x7a, 0x76, 0x7e,
    0x71, 0x79, 0x75, 0x7d, 0x73, 0x7b, 0x77, 0x7f,
    0xf0, 0xf8, 0xf4, 0xfc, 0xf2, 0xfa, 0xf6, 0xfe,
    0xf1, 0xf9, 0xf5, 0xfd, 0xf3, 0xfb, 0xf7, 0xff
};


/////////////////////////////////////////////////////////////////////////////
//
// ReverseComplement Tables

// NCBI2na
const Uint1* C2naRevCmp::scm_Tables[4] = {
    scm_Table0, scm_Table1, scm_Table2, scm_Table3
};


const Uint1 C2naRevCmp::scm_Table0[512] = {
    0xc0,0x3f,  0xc0,0x2f,  0xc0,0x1f,  0xc0,0xf,
    0xc0,0x3b,  0xc0,0x2b,  0xc0,0x1b,  0xc0,0xb,
    0xc0,0x37,  0xc0,0x27,  0xc0,0x17,  0xc0,0x7,
    0xc0,0x33,  0xc0,0x23,  0xc0,0x13,  0xc0,0x3,
    0xc0,0x3e,  0xc0,0x2e,  0xc0,0x1e,  0xc0,0xe,
    0xc0,0x3a,  0xc0,0x2a,  0xc0,0x1a,  0xc0,0xa,
    0xc0,0x36,  0xc0,0x26,  0xc0,0x16,  0xc0,0x6,
    0xc0,0x32,  0xc0,0x22,  0xc0,0x12,  0xc0,0x2,
    0xc0,0x3d,  0xc0,0x2d,  0xc0,0x1d,  0xc0,0xd,
    0xc0,0x39,  0xc0,0x29,  0xc0,0x19,  0xc0,0x9,
    0xc0,0x35,  0xc0,0x25,  0xc0,0x15,  0xc0,0x5,
    0xc0,0x31,  0xc0,0x21,  0xc0,0x11,  0xc0,0x1,
    0xc0,0x3c,  0xc0,0x2c,  0xc0,0x1c,  0xc0,0xc,
    0xc0,0x38,  0xc0,0x28,  0xc0,0x18,  0xc0,0x8,
    0xc0,0x34,  0xc0,0x24,  0xc0,0x14,  0xc0,0x4,
    0xc0,0x30,  0xc0,0x20,  0xc0,0x10,  0xc0,0x0,
    0x80,0x3f,  0x80,0x2f,  0x80,0x1f,  0x80,0xf,
    0x80,0x3b,  0x80,0x2b,  0x80,0x1b,  0x80,0xb,
    0x80,0x37,  0x80,0x27,  0x80,0x17,  0x80,0x7,
    0x80,0x33,  0x80,0x23,  0x80,0x13,  0x80,0x3,
    0x80,0x3e,  0x80,0x2e,  0x80,0x1e,  0x80,0xe,
    0x80,0x3a,  0x80,0x2a,  0x80,0x1a,  0x80,0xa,
    0x80,0x36,  0x80,0x26,  0x80,0x16,  0x80,0x6,
    0x80,0x32,  0x80,0x22,  0x80,0x12,  0x80,0x2,
    0x80,0x3d,  0x80,0x2d,  0x80,0x1d,  0x80,0xd,
    0x80,0x39,  0x80,0x29,  0x80,0x19,  0x80,0x9,
    0x80,0x35,  0x80,0x25,  0x80,0x15,  0x80,0x5,
    0x80,0x31,  0x80,0x21,  0x80,0x11,  0x80,0x1,
    0x80,0x3c,  0x80,0x2c,  0x80,0x1c,  0x80,0xc,
    0x80,0x38,  0x80,0x28,  0x80,0x18,  0x80,0x8,
    0x80,0x34,  0x80,0x24,  0x80,0x14,  0x80,0x4,
    0x80,0x30,  0x80,0x20,  0x80,0x10,  0x80,0x0,
    0x40,0x3f,  0x40,0x2f,  0x40,0x1f,  0x40,0xf,
    0x40,0x3b,  0x40,0x2b,  0x40,0x1b,  0x40,0xb,
    0x40,0x37,  0x40,0x27,  0x40,0x17,  0x40,0x7,
    0x40,0x33,  0x40,0x23,  0x40,0x13,  0x40,0x3,
    0x40,0x3e,  0x40,0x2e,  0x40,0x1e,  0x40,0xe,
    0x40,0x3a,  0x40,0x2a,  0x40,0x1a,  0x40,0xa,
    0x40,0x36,  0x40,0x26,  0x40,0x16,  0x40,0x6,
    0x40,0x32,  0x40,0x22,  0x40,0x12,  0x40,0x2,
    0x40,0x3d,  0x40,0x2d,  0x40,0x1d,  0x40,0xd,
    0x40,0x39,  0x40,0x29,  0x40,0x19,  0x40,0x9,
    0x40,0x35,  0x40,0x25,  0x40,0x15,  0x40,0x5,
    0x40,0x31,  0x40,0x21,  0x40,0x11,  0x40,0x1,
    0x40,0x3c,  0x40,0x2c,  0x40,0x1c,  0x40,0xc,
    0x40,0x38,  0x40,0x28,  0x40,0x18,  0x40,0x8,
    0x40,0x34,  0x40,0x24,  0x40,0x14,  0x40,0x4,
    0x40,0x30,  0x40,0x20,  0x40,0x10,  0x40,0x0,
    0x0,0x3f,  0x0,0x2f,  0x0,0x1f,  0x0,0xf,
    0x0,0x3b,  0x0,0x2b,  0x0,0x1b,  0x0,0xb,
    0x0,0x37,  0x0,0x27,  0x0,0x17,  0x0,0x7,
    0x0,0x33,  0x0,0x23,  0x0,0x13,  0x0,0x3,
    0x0,0x3e,  0x0,0x2e,  0x0,0x1e,  0x0,0xe,
    0x0,0x3a,  0x0,0x2a,  0x0,0x1a,  0x0,0xa,
    0x0,0x36,  0x0,0x26,  0x0,0x16,  0x0,0x6,
    0x0,0x32,  0x0,0x22,  0x0,0x12,  0x0,0x2,
    0x0,0x3d,  0x0,0x2d,  0x0,0x1d,  0x0,0xd,
    0x0,0x39,  0x0,0x29,  0x0,0x19,  0x0,0x9,
    0x0,0x35,  0x0,0x25,  0x0,0x15,  0x0,0x5,
    0x0,0x31,  0x0,0x21,  0x0,0x11,  0x0,0x1,
    0x0,0x3c,  0x0,0x2c,  0x0,0x1c,  0x0,0xc,
    0x0,0x38,  0x0,0x28,  0x0,0x18,  0x0,0x8,
    0x0,0x34,  0x0,0x24,  0x0,0x14,  0x0,0x4,
    0x0,0x30,  0x0,0x20,  0x0,0x10,  0x0,0x0
};

const Uint1 C2naRevCmp::scm_Table1[512] = {
    0xf0,0xf,  0xf0,0xb,  0xf0,0x7,  0xf0,0x3,
    0xf0,0xe,  0xf0,0xa,  0xf0,0x6,  0xf0,0x2,
    0xf0,0xd,  0xf0,0x9,  0xf0,0x5,  0xf0,0x1,
    0xf0,0xc,  0xf0,0x8,  0xf0,0x4,  0xf0,0x0,
    0xb0,0xf,  0xb0,0xb,  0xb0,0x7,  0xb0,0x3,
    0xb0,0xe,  0xb0,0xa,  0xb0,0x6,  0xb0,0x2,
    0xb0,0xd,  0xb0,0x9,  0xb0,0x5,  0xb0,0x1,
    0xb0,0xc,  0xb0,0x8,  0xb0,0x4,  0xb0,0x0,
    0x70,0xf,  0x70,0xb,  0x70,0x7,  0x70,0x3,
    0x70,0xe,  0x70,0xa,  0x70,0x6,  0x70,0x2,
    0x70,0xd,  0x70,0x9,  0x70,0x5,  0x70,0x1,
    0x70,0xc,  0x70,0x8,  0x70,0x4,  0x70,0x0,
    0x30,0xf,  0x30,0xb,  0x30,0x7,  0x30,0x3,
    0x30,0xe,  0x30,0xa,  0x30,0x6,  0x30,0x2,
    0x30,0xd,  0x30,0x9,  0x30,0x5,  0x30,0x1,
    0x30,0xc,  0x30,0x8,  0x30,0x4,  0x30,0x0,
    0xe0,0xf,  0xe0,0xb,  0xe0,0x7,  0xe0,0x3,
    0xe0,0xe,  0xe0,0xa,  0xe0,0x6,  0xe0,0x2,
    0xe0,0xd,  0xe0,0x9,  0xe0,0x5,  0xe0,0x1,
    0xe0,0xc,  0xe0,0x8,  0xe0,0x4,  0xe0,0x0,
    0xa0,0xf,  0xa0,0xb,  0xa0,0x7,  0xa0,0x3,
    0xa0,0xe,  0xa0,0xa,  0xa0,0x6,  0xa0,0x2,
    0xa0,0xd,  0xa0,0x9,  0xa0,0x5,  0xa0,0x1,
    0xa0,0xc,  0xa0,0x8,  0xa0,0x4,  0xa0,0x0,
    0x60,0xf,  0x60,0xb,  0x60,0x7,  0x60,0x3,
    0x60,0xe,  0x60,0xa,  0x60,0x6,  0x60,0x2,
    0x60,0xd,  0x60,0x9,  0x60,0x5,  0x60,0x1,
    0x60,0xc,  0x60,0x8,  0x60,0x4,  0x60,0x0,
    0x20,0xf,  0x20,0xb,  0x20,0x7,  0x20,0x3,
    0x20,0xe,  0x20,0xa,  0x20,0x6,  0x20,0x2,
    0x20,0xd,  0x20,0x9,  0x20,0x5,  0x20,0x1,
    0x20,0xc,  0x20,0x8,  0x20,0x4,  0x20,0x0,
    0xd0,0xf,  0xd0,0xb,  0xd0,0x7,  0xd0,0x3,
    0xd0,0xe,  0xd0,0xa,  0xd0,0x6,  0xd0,0x2,
    0xd0,0xd,  0xd0,0x9,  0xd0,0x5,  0xd0,0x1,
    0xd0,0xc,  0xd0,0x8,  0xd0,0x4,  0xd0,0x0,
    0x90,0xf,  0x90,0xb,  0x90,0x7,  0x90,0x3,
    0x90,0xe,  0x90,0xa,  0x90,0x6,  0x90,0x2,
    0x90,0xd,  0x90,0x9,  0x90,0x5,  0x90,0x1,
    0x90,0xc,  0x90,0x8,  0x90,0x4,  0x90,0x0,
    0x50,0xf,  0x50,0xb,  0x50,0x7,  0x50,0x3,
    0x50,0xe,  0x50,0xa,  0x50,0x6,  0x50,0x2,
    0x50,0xd,  0x50,0x9,  0x50,0x5,  0x50,0x1,
    0x50,0xc,  0x50,0x8,  0x50,0x4,  0x50,0x0,
    0x10,0xf,  0x10,0xb,  0x10,0x7,  0x10,0x3,
    0x10,0xe,  0x10,0xa,  0x10,0x6,  0x10,0x2,
    0x10,0xd,  0x10,0x9,  0x10,0x5,  0x10,0x1,
    0x10,0xc,  0x10,0x8,  0x10,0x4,  0x10,0x0,
    0xc0,0xf,  0xc0,0xb,  0xc0,0x7,  0xc0,0x3,
    0xc0,0xe,  0xc0,0xa,  0xc0,0x6,  0xc0,0x2,
    0xc0,0xd,  0xc0,0x9,  0xc0,0x5,  0xc0,0x1,
    0xc0,0xc,  0xc0,0x8,  0xc0,0x4,  0xc0,0x0,
    0x80,0xf,  0x80,0xb,  0x80,0x7,  0x80,0x3,
    0x80,0xe,  0x80,0xa,  0x80,0x6,  0x80,0x2,
    0x80,0xd,  0x80,0x9,  0x80,0x5,  0x80,0x1,
    0x80,0xc,  0x80,0x8,  0x80,0x4,  0x80,0x0,
    0x40,0xf,  0x40,0xb,  0x40,0x7,  0x40,0x3,
    0x40,0xe,  0x40,0xa,  0x40,0x6,  0x40,0x2,
    0x40,0xd,  0x40,0x9,  0x40,0x5,  0x40,0x1,
    0x40,0xc,  0x40,0x8,  0x40,0x4,  0x40,0x0,
    0x0,0xf,  0x0,0xb,  0x0,0x7,  0x0,0x3,
    0x0,0xe,  0x0,0xa,  0x0,0x6,  0x0,0x2,
    0x0,0xd,  0x0,0x9,  0x0,0x5,  0x0,0x1,
    0x0,0xc,  0x0,0x8,  0x0,0x4,  0x0,0x0
};

const Uint1 C2naRevCmp::scm_Table2[512] = {
    0xfc,0x3,  0xfc,0x2,  0xfc,0x1,  0xfc,0x0,
    0xbc,0x3,  0xbc,0x2,  0xbc,0x1,  0xbc,0x0,
    0x7c,0x3,  0x7c,0x2,  0x7c,0x1,  0x7c,0x0,
    0x3c,0x3,  0x3c,0x2,  0x3c,0x1,  0x3c,0x0,
    0xec,0x3,  0xec,0x2,  0xec,0x1,  0xec,0x0,
    0xac,0x3,  0xac,0x2,  0xac,0x1,  0xac,0x0,
    0x6c,0x3,  0x6c,0x2,  0x6c,0x1,  0x6c,0x0,
    0x2c,0x3,  0x2c,0x2,  0x2c,0x1,  0x2c,0x0,
    0xdc,0x3,  0xdc,0x2,  0xdc,0x1,  0xdc,0x0,
    0x9c,0x3,  0x9c,0x2,  0x9c,0x1,  0x9c,0x0,
    0x5c,0x3,  0x5c,0x2,  0x5c,0x1,  0x5c,0x0,
    0x1c,0x3,  0x1c,0x2,  0x1c,0x1,  0x1c,0x0,
    0xcc,0x3,  0xcc,0x2,  0xcc,0x1,  0xcc,0x0,
    0x8c,0x3,  0x8c,0x2,  0x8c,0x1,  0x8c,0x0,
    0x4c,0x3,  0x4c,0x2,  0x4c,0x1,  0x4c,0x0,
    0xc,0x3,  0xc,0x2,  0xc,0x1,  0xc,0x0,
    0xf8,0x3,  0xf8,0x2,  0xf8,0x1,  0xf8,0x0,
    0xb8,0x3,  0xb8,0x2,  0xb8,0x1,  0xb8,0x0,
    0x78,0x3,  0x78,0x2,  0x78,0x1,  0x78,0x0,
    0x38,0x3,  0x38,0x2,  0x38,0x1,  0x38,0x0,
    0xe8,0x3,  0xe8,0x2,  0xe8,0x1,  0xe8,0x0,
    0xa8,0x3,  0xa8,0x2,  0xa8,0x1,  0xa8,0x0,
    0x68,0x3,  0x68,0x2,  0x68,0x1,  0x68,0x0,
    0x28,0x3,  0x28,0x2,  0x28,0x1,  0x28,0x0,
    0xd8,0x3,  0xd8,0x2,  0xd8,0x1,  0xd8,0x0,
    0x98,0x3,  0x98,0x2,  0x98,0x1,  0x98,0x0,
    0x58,0x3,  0x58,0x2,  0x58,0x1,  0x58,0x0,
    0x18,0x3,  0x18,0x2,  0x18,0x1,  0x18,0x0,
    0xc8,0x3,  0xc8,0x2,  0xc8,0x1,  0xc8,0x0,
    0x88,0x3,  0x88,0x2,  0x88,0x1,  0x88,0x0,
    0x48,0x3,  0x48,0x2,  0x48,0x1,  0x48,0x0,
    0x8,0x3,  0x8,0x2,  0x8,0x1,  0x8,0x0,
    0xf4,0x3,  0xf4,0x2,  0xf4,0x1,  0xf4,0x0,
    0xb4,0x3,  0xb4,0x2,  0xb4,0x1,  0xb4,0x0,
    0x74,0x3,  0x74,0x2,  0x74,0x1,  0x74,0x0,
    0x34,0x3,  0x34,0x2,  0x34,0x1,  0x34,0x0,
    0xe4,0x3,  0xe4,0x2,  0xe4,0x1,  0xe4,0x0,
    0xa4,0x3,  0xa4,0x2,  0xa4,0x1,  0xa4,0x0,
    0x64,0x3,  0x64,0x2,  0x64,0x1,  0x64,0x0,
    0x24,0x3,  0x24,0x2,  0x24,0x1,  0x24,0x0,
    0xd4,0x3,  0xd4,0x2,  0xd4,0x1,  0xd4,0x0,
    0x94,0x3,  0x94,0x2,  0x94,0x1,  0x94,0x0,
    0x54,0x3,  0x54,0x2,  0x54,0x1,  0x54,0x0,
    0x14,0x3,  0x14,0x2,  0x14,0x1,  0x14,0x0,
    0xc4,0x3,  0xc4,0x2,  0xc4,0x1,  0xc4,0x0,
    0x84,0x3,  0x84,0x2,  0x84,0x1,  0x84,0x0,
    0x44,0x3,  0x44,0x2,  0x44,0x1,  0x44,0x0,
    0x4,0x3,  0x4,0x2,  0x4,0x1,  0x4,0x0,
    0xf0,0x3,  0xf0,0x2,  0xf0,0x1,  0xf0,0x0,
    0xb0,0x3,  0xb0,0x2,  0xb0,0x1,  0xb0,0x0,
    0x70,0x3,  0x70,0x2,  0x70,0x1,  0x70,0x0,
    0x30,0x3,  0x30,0x2,  0x30,0x1,  0x30,0x0,
    0xe0,0x3,  0xe0,0x2,  0xe0,0x1,  0xe0,0x0,
    0xa0,0x3,  0xa0,0x2,  0xa0,0x1,  0xa0,0x0,
    0x60,0x3,  0x60,0x2,  0x60,0x1,  0x60,0x0,
    0x20,0x3,  0x20,0x2,  0x20,0x1,  0x20,0x0,
    0xd0,0x3,  0xd0,0x2,  0xd0,0x1,  0xd0,0x0,
    0x90,0x3,  0x90,0x2,  0x90,0x1,  0x90,0x0,
    0x50,0x3,  0x50,0x2,  0x50,0x1,  0x50,0x0,
    0x10,0x3,  0x10,0x2,  0x10,0x1,  0x10,0x0,
    0xc0,0x3,  0xc0,0x2,  0xc0,0x1,  0xc0,0x0,
    0x80,0x3,  0x80,0x2,  0x80,0x1,  0x80,0x0,
    0x40,0x3,  0x40,0x2,  0x40,0x1,  0x40,0x0,
    0x0,0x3,  0x0,0x2,  0x0,0x1,  0x0,0x0
};

const Uint1 C2naRevCmp::scm_Table3[256] = {
    0xff, 0xbf, 0x7f, 0x3f, 0xef, 0xaf, 0x6f, 0x2f,
    0xdf, 0x9f, 0x5f, 0x1f, 0xcf, 0x8f, 0x4f, 0xf,
    0xfb, 0xbb, 0x7b, 0x3b, 0xeb, 0xab, 0x6b, 0x2b,
    0xdb, 0x9b, 0x5b, 0x1b, 0xcb, 0x8b, 0x4b, 0xb,
    0xf7, 0xb7, 0x77, 0x37, 0xe7, 0xa7, 0x67, 0x27,
    0xd7, 0x97, 0x57, 0x17, 0xc7, 0x87, 0x47, 0x7,
    0xf3, 0xb3, 0x73, 0x33, 0xe3, 0xa3, 0x63, 0x23,
    0xd3, 0x93, 0x53, 0x13, 0xc3, 0x83, 0x43, 0x3,
    0xfe, 0xbe, 0x7e, 0x3e, 0xee, 0xae, 0x6e, 0x2e,
    0xde, 0x9e, 0x5e, 0x1e, 0xce, 0x8e, 0x4e, 0xe,
    0xfa, 0xba, 0x7a, 0x3a, 0xea, 0xaa, 0x6a, 0x2a,
    0xda, 0x9a, 0x5a, 0x1a, 0xca, 0x8a, 0x4a, 0xa,
    0xf6, 0xb6, 0x76, 0x36, 0xe6, 0xa6, 0x66, 0x26,
    0xd6, 0x96, 0x56, 0x16, 0xc6, 0x86, 0x46, 0x6,
    0xf2, 0xb2, 0x72, 0x32, 0xe2, 0xa2, 0x62, 0x22,
    0xd2, 0x92, 0x52, 0x12, 0xc2, 0x82, 0x42, 0x2,
    0xfd, 0xbd, 0x7d, 0x3d, 0xed, 0xad, 0x6d, 0x2d,
    0xdd, 0x9d, 0x5d, 0x1d, 0xcd, 0x8d, 0x4d, 0xd,
    0xf9, 0xb9, 0x79, 0x39, 0xe9, 0xa9, 0x69, 0x29,
    0xd9, 0x99, 0x59, 0x19, 0xc9, 0x89, 0x49, 0x9,
    0xf5, 0xb5, 0x75, 0x35, 0xe5, 0xa5, 0x65, 0x25,
    0xd5, 0x95, 0x55, 0x15, 0xc5, 0x85, 0x45, 0x5,
    0xf1, 0xb1, 0x71, 0x31, 0xe1, 0xa1, 0x61, 0x21,
    0xd1, 0x91, 0x51, 0x11, 0xc1, 0x81, 0x41, 0x1,
    0xfc, 0xbc, 0x7c, 0x3c, 0xec, 0xac, 0x6c, 0x2c,
    0xdc, 0x9c, 0x5c, 0x1c, 0xcc, 0x8c, 0x4c, 0xc,
    0xf8, 0xb8, 0x78, 0x38, 0xe8, 0xa8, 0x68, 0x28,
    0xd8, 0x98, 0x58, 0x18, 0xc8, 0x88, 0x48, 0x8,
    0xf4, 0xb4, 0x74, 0x34, 0xe4, 0xa4, 0x64, 0x24,
    0xd4, 0x94, 0x54, 0x14, 0xc4, 0x84, 0x44, 0x4,
    0xf0, 0xb0, 0x70, 0x30, 0xe0, 0xa0, 0x60, 0x20,
    0xd0, 0x90, 0x50, 0x10, 0xc0, 0x80, 0x40, 0x0
};


// NCBI4na
const Uint1 C4naRevCmp::scm_Table0[512] = {
    0x0,0x0,  0x0,0x8,  0x0,0x4,  0x0,0xc,
    0x0,0x2,  0x0,0xa,  0x0,0x9,  0x0,0xe,
    0x0,0x1,  0x0,0x6,  0x0,0x5,  0x0,0xd,
    0x0,0x3,  0x0,0xb,  0x0,0x7,  0x0,0xf,
    0x80,0x0,  0x80,0x8,  0x80,0x4,  0x80,0xc,
    0x80,0x2,  0x80,0xa,  0x80,0x9,  0x80,0xe,
    0x80,0x1,  0x80,0x6,  0x80,0x5,  0x80,0xd,
    0x80,0x3,  0x80,0xb,  0x80,0x7,  0x80,0xf,
    0x40,0x0,  0x40,0x8,  0x40,0x4,  0x40,0xc,
    0x40,0x2,  0x40,0xa,  0x40,0x9,  0x40,0xe,
    0x40,0x1,  0x40,0x6,  0x40,0x5,  0x40,0xd,
    0x40,0x3,  0x40,0xb,  0x40,0x7,  0x40,0xf,
    0xc0,0x0,  0xc0,0x8,  0xc0,0x4,  0xc0,0xc,
    0xc0,0x2,  0xc0,0xa,  0xc0,0x9,  0xc0,0xe,
    0xc0,0x1,  0xc0,0x6,  0xc0,0x5,  0xc0,0xd,
    0xc0,0x3,  0xc0,0xb,  0xc0,0x7,  0xc0,0xf,
    0x20,0x0,  0x20,0x8,  0x20,0x4,  0x20,0xc,
    0x20,0x2,  0x20,0xa,  0x20,0x9,  0x20,0xe,
    0x20,0x1,  0x20,0x6,  0x20,0x5,  0x20,0xd,
    0x20,0x3,  0x20,0xb,  0x20,0x7,  0x20,0xf,
    0xa0,0x0,  0xa0,0x8,  0xa0,0x4,  0xa0,0xc,
    0xa0,0x2,  0xa0,0xa,  0xa0,0x9,  0xa0,0xe,
    0xa0,0x1,  0xa0,0x6,  0xa0,0x5,  0xa0,0xd,
    0xa0,0x3,  0xa0,0xb,  0xa0,0x7,  0xa0,0xf,
    0x90,0x0,  0x90,0x8,  0x90,0x4,  0x90,0xc,
    0x90,0x2,  0x90,0xa,  0x90,0x9,  0x90,0xe,
    0x90,0x1,  0x90,0x6,  0x90,0x5,  0x90,0xd,
    0x90,0x3,  0x90,0xb,  0x90,0x7,  0x90,0xf,
    0xe0,0x0,  0xe0,0x8,  0xe0,0x4,  0xe0,0xc,
    0xe0,0x2,  0xe0,0xa,  0xe0,0x9,  0xe0,0xe,
    0xe0,0x1,  0xe0,0x6,  0xe0,0x5,  0xe0,0xd,
    0xe0,0x3,  0xe0,0xb,  0xe0,0x7,  0xe0,0xf,
    0x10,0x0,  0x10,0x8,  0x10,0x4,  0x10,0xc,
    0x10,0x2,  0x10,0xa,  0x10,0x9,  0x10,0xe,
    0x10,0x1,  0x10,0x6,  0x10,0x5,  0x10,0xd,
    0x10,0x3,  0x10,0xb,  0x10,0x7,  0x10,0xf,
    0x60,0x0,  0x60,0x8,  0x60,0x4,  0x60,0xc,
    0x60,0x2,  0x60,0xa,  0x60,0x9,  0x60,0xe,
    0x60,0x1,  0x60,0x6,  0x60,0x5,  0x60,0xd,
    0x60,0x3,  0x60,0xb,  0x60,0x7,  0x60,0xf,
    0x50,0x0,  0x50,0x8,  0x50,0x4,  0x50,0xc,
    0x50,0x2,  0x50,0xa,  0x50,0x9,  0x50,0xe,
    0x50,0x1,  0x50,0x6,  0x50,0x5,  0x50,0xd,
    0x50,0x3,  0x50,0xb,  0x50,0x7,  0x50,0xf,
    0xd0,0x0,  0xd0,0x8,  0xd0,0x4,  0xd0,0xc,
    0xd0,0x2,  0xd0,0xa,  0xd0,0x9,  0xd0,0xe,
    0xd0,0x1,  0xd0,0x6,  0xd0,0x5,  0xd0,0xd,
    0xd0,0x3,  0xd0,0xb,  0xd0,0x7,  0xd0,0xf,
    0x30,0x0,  0x30,0x8,  0x30,0x4,  0x30,0xc,
    0x30,0x2,  0x30,0xa,  0x30,0x9,  0x30,0xe,
    0x30,0x1,  0x30,0x6,  0x30,0x5,  0x30,0xd,
    0x30,0x3,  0x30,0xb,  0x30,0x7,  0x30,0xf,
    0xb0,0x0,  0xb0,0x8,  0xb0,0x4,  0xb0,0xc,
    0xb0,0x2,  0xb0,0xa,  0xb0,0x9,  0xb0,0xe,
    0xb0,0x1,  0xb0,0x6,  0xb0,0x5,  0xb0,0xd,
    0xb0,0x3,  0xb0,0xb,  0xb0,0x7,  0xb0,0xf,
    0x70,0x0,  0x70,0x8,  0x70,0x4,  0x70,0xc,
    0x70,0x2,  0x70,0xa,  0x70,0x9,  0x70,0xe,
    0x70,0x1,  0x70,0x6,  0x70,0x5,  0x70,0xd,
    0x70,0x3,  0x70,0xb,  0x70,0x7,  0x70,0xf,
    0xf0,0x0,  0xf0,0x8,  0xf0,0x4,  0xf0,0xc,
    0xf0,0x2,  0xf0,0xa,  0xf0,0x9,  0xf0,0xe,
    0xf0,0x1,  0xf0,0x6,  0xf0,0x5,  0xf0,0xd,
    0xf0,0x3,  0xf0,0xb,  0xf0,0x7,  0xf0,0xf
};

const Uint1 C4naRevCmp::scm_Table1[256] = {
    0x0, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x90, 0xe0,
    0x10, 0x60, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
    0x8, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x98, 0xe8,
    0x18, 0x68, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
    0x4, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x94, 0xe4,
    0x14, 0x64, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
    0xc, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x9c, 0xec,
    0x1c, 0x6c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
    0x2, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x92, 0xe2,
    0x12, 0x62, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
    0xa, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x9a, 0xea,
    0x1a, 0x6a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
    0x9, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x99, 0xe9,
    0x19, 0x69, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
    0xe, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x9e, 0xee,
    0x1e, 0x6e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
    0x1, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x91, 0xe1,
    0x11, 0x61, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
    0x6, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x96, 0xe6,
    0x16, 0x66, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
    0x5, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x95, 0xe5,
    0x15, 0x65, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
    0xd, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x9d, 0xed,
    0x1d, 0x6d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
    0x3, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x93, 0xe3,
    0x13, 0x63, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
    0xb, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x9b, 0xeb,
    0x1b, 0x6b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
    0x7, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x97, 0xe7,
    0x17, 0x67, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
    0xf, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x9f, 0xef,
    0x1f, 0x6f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff
};

/////////////////////////////////////////////////////////////////////////////
//
// Ambiguity Tables

// IUPACna
const bool CIupacnaAmbig::scm_Table[256] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


// NCBI4na
const bool CNcbi4naAmbig::scm_Table[256] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


// NCBI8na
const bool CNcbi8naAmbig::scm_Table[256] = {
    0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


END_NCBI_SCOPE
