/* $Id: GBProject_ver2.hpp 410943 2013-08-22 20:54:31Z rafanovi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBProject_ver2.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: GBProject_ver2_.hpp


#ifndef OBJECTS_GBPROJ_GBPROJECT_VER2_HPP
#define OBJECTS_GBPROJ_GBPROJECT_VER2_HPP


// generated includes
#include <objects/gbproj/GBProject_ver2_.hpp>
#include <objects/gbproj/igbproject.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CGBProject_ver2
    : public CGBProject_ver2_Base
    , public IGBProject
{
    typedef CGBProject_ver2_Base Tparent;
public:
    CGBProject_ver2(void);
    ~CGBProject_ver2(void);

    /// @name IGBProject Implementation
    /// @{
    /// See IGNProject for comments
    EProjectVersion GetVersion() const;

    void AddItem(CProjectItem& item, CProjectFolder& folder);

    const CProjectFolder& GetData() const;
    CProjectFolder&       SetData();

    bool                 IsSetDescr() const;
    const CProjectDescr& GetDescr() const;
    CProjectDescr&       SetDescr();
    void                 SetDescr(CProjectDescr& descr);

    bool                      IsSetAnnot() const;
    const IGBProject::TAnnot& GetAnnot() const;
    IGBProject::TAnnot&       SetAnnot();

    /// retrieve the data loader descriptor set for this project
    virtual bool IsSetDataLoaders() const;
    virtual const TDataLoaders& GetDataLoaders() const;
    virtual TDataLoaders&       SetDataLoaders();

    bool                      IsSetViews() const;
    const IGBProject::TViews& GetViews() const;
    IGBProject::TViews&       SetViews();

    virtual bool IsSetViewSettings() const;
    virtual const TViewSettings& GetViewSettings() const;
    virtual TViewSettings&       SetViewSettings();

    void SetDirtyFlag(bool dirty);
    bool GetDirtyFlag() const;

    void SetCreateDate(const CDate& date);

    void SetModifiedDate(const CDate& date);
    /// @}
private:
    // Prohibit copy constructor and assignment operator
    CGBProject_ver2(const CGBProject_ver2& value);
    CGBProject_ver2& operator=(const CGBProject_ver2& value);

private:
    bool m_Dirty; /// true if changes have not been saved
};

/////////////////// CGBProject_ver2 inline methods


inline
IGBProject::EProjectVersion CGBProject_ver2::GetVersion() const
{
    return eVersion2;
}


/////////////////// end of CGBProject_ver2 inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_GBPROJECT_VER2_HPP
/* Original file checksum: lines: 86, chars: 2505, CRC32: 2f94a777 */
