/*  $Id: cell_line.inc 530081 2017-03-10 18:09:40Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Colleen Bollin
 *
 * File Description:
 *   Built-in copy of cell_line.txt.
 *
 */

static const char* const kCellLine[] = {
    "1483\tHomo sapiens\tUM-SCC-1\tHuman",
    "183\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "1E8\tHomo sapiens\tNALM-6\tHomo sapiens\t",
    "2008/C13*5.25\tHomo sapiens\tME-180\tHomo sapiens",
    "207 (EU-2)\tHomo sapiens\tREH and SUP-B2\tHuman",
    "222\tHomo sapiens\tPA1\tHuman",
    "2474/90\tHomo sapiens\tHT-29\tHuman",
    "2563 (MAC-21)\tHomo sapiens\tHeLa\tHuman",
    "2957/90\tHomo sapiens\tHT-29\tHuman",
    "3051/80\tHomo sapiens\tHT-29\tHuman",
    "41M\tHomo sapiens\tOAW 28\tHuman",
    "A172TR3\tHomo sapiens\tU-251 MG\tHomo sapiens\t",
    "A2008\tHomo sapiens\tME-180\tHuman",
    "ACC2\tHomo sapiens\tHeLa\tHuman",
    "ACC3\tHomo sapiens\tHeLa\tHuman",
    "ACCM\tHomo sapiens\tHeLa\tHuman",
    "ACCNS\tHomo sapiens\tUnknown\tMouse",
    "ACCS\tHomo sapiens\tT-24\tHuman",
    "ADLC-5M2\tHomo sapiens\tHeLa\tHuman",
    "AG-F\tHomo sapiens\tCCRF-CEM\tHuman",
    "AKI\tHomo sapiens\tHeLa\tHuman",
    "ALVA-101\tHomo sapiens\tPC-3\tHuman",
    "ALVA-31\tHomo sapiens\tPC-3\tHuman",
    "ALVA-41\tHomo sapiens\tPC-3\tHuman",
    "ALVA-55\tHomo sapiens\tPC-3\tHuman",
    "AMDURII\tHomo sapiens\tLLC-PK1\tPig, Sus scrofa",
    "AO\tHomo sapiens\tHeLa\tHuman",
    "ARO\tHomo sapiens\tHT-29\tHuman",
    "ARO81-1\tHomo sapiens\tHT-29\tHuman",
    "AV3\tHomo sapiens\tHeLa\tHuman",
    "AZ521\tHomo sapiens\tHuTu 80\tHuman",
    "Aedes aegypti, Suitor's clone\tMosquito\tUnknown\tMoth, Antheraea eucalypti",
    "Aedes vexans culture\tMosquito\tUnknown\tMoth, Antheraea eucalypti",
    "Ao38\tAscalapha odorata \tunknown\tTrichoplusia ni\t",
    "B10XI\tGallus gallus\tUnknown\tPig, Sus scrofa",
    "B2-17\tHomo sapiens\tU-251 MG\tHuman",
    "B6\tGallus gallus\tUnknown\tPig, Sus scrofa",
    "BCC1/KMC\tHomo sapiens\tHeLa\tHuman",
    "BE-13\tHomo sapiens\tPEER\tHuman",
    "BG-1\tHomo sapiens\tMCF-7\tHuman",
    "BHP 10-3\tHomo sapiens\tTPC-1\tHuman",
    "BHP 14-9\tHomo sapiens\tM14\tHuman",
    "BHP 17-10\tHomo sapiens\tM14\tHuman",
    "BHP 2-7\tHomo sapiens\tTPC-1\tHuman",
    "BHP 5-16\tHomo sapiens\tM14\tHuman",
    "BHP 7-13\tHomo sapiens\tTPC-1\tHuman",
    "BIC-1\tHomo sapiens\tSW-480, SW-620\tHuman",
    "BJA-B\tHomo sapiens\tHeLa\tHuman",
    "BLIN-1 (also subclone 1E8)\tHomo sapiens\tNALM-6\tHuman",
    "BM-1604\tHomo sapiens\tDU-145\tHuman",
    "BSCC-93\tHomo sapiens\tDJM-1\tHuman",
    "BT-20\tHomo sapiens\tHeLa\tHuman",
    "BT-B\tHomo sapiens\tHeLa\tHuman",
    "BTI-Tnao38\tAscalapha odorata \tunknown\tTrichoplusia ni\t",
    "BrCA 5\tHomo sapiens\tHeLa\tHuman",
    "C-433\tHomo sapiens\tRD-ES\tHuman",
    "C13\tHomo sapiens\tME-180\tHomo sapiens\t",
    "C13\tHomo sapiens\tME-180\tHuman",
    "C16 (MRC-5 derivative)\tHomo sapiens\tHeLa\tHuman",
    "CAC2\tHomo sapiens\tUnknown\tRat",
    "CCL3\tHomo sapiens\tUnknown\tMouse",
    "CH1, CH1cisR\tHomo sapiens\tPA1\tHuman",
    "CHB\tHomo sapiens\tUnknown\tRat",
    "CHP-100\tHomo sapiens\tIMR-32\tHuman",
    "CHP-234\tHomo sapiens\tUnknown\tHuman",
    "CMP\tHomo sapiens\tHeLa\tHuman",
    "CMPII C2\tHomo sapiens\tHeLa\tHuman",
    "CNDT2\tHomo sapiens\tUnknown\tHuman",
    "CNE-1\tHomo sapiens\tHeLa\tHomo sapiens\t",
    "CNE-2\tHomo sapiens\tHeLa\tHomo sapiens\t",
    "CO (= COLE)\tHomo sapiens\tCCRF-CEM\tHuman",
    "COLO-587\tHomo sapiens\tCOLO-320DM\tHuman",
    "COLO-677\tHomo sapiens\tRPMI-8226\tHuman",
    "COLO-720E\tHomo sapiens\tCOLO684, COLO685, COLO704\tHuman",
    "COLO-818\tHomo sapiens\tCOLO-800\tHuman",
    "Ca9-22\tHomo sapiens\tMSK-922\tHuman",
    "CaMa (clone 15)\tHomo sapiens\tUnknown\tSyrian hamster and mouse",
    "CaOV\tHomo sapiens\tHeLa\tHuman",
    "CaVe\tHomo sapiens\tHeLa\tHuman",
    "Caov-2\tHomo sapiens\tNIH:OVCAR-2\tHuman",
    "Chang liver\tHomo sapiens\tHeLa\tHuman",
    "Clom 15\tHomo sapiens\tUnknown\tRat",
    "Clone 1-5c-4\tHomo sapiens\tHeLa\tHuman",
    "Clone 1A\tOncorhynchus mykiss\tCHSE-214\tChinook salmon, Oncorhynchus tschawytscha",
    "Clone-16\tHomo sapiens\tUnknown\tSyrian hamster",
    "CoLo-TC\tHomo sapiens\tCOLO-205\tHuman",
    "Culisita inornata culture\tMosquito\tUnknown\tMoth, Antheraea eucalypti",
    "D-17\tCanis lupus familiaris\tMoresco\tDog, Canis familiaris",
    "D-54 MG\tHomo sapiens\tA-172\tHomo sapiens\t",
    "D18T\tHomo sapiens\tHeLa\tHuman",
    "D98/AH\tHomo sapiens\tHeLa\tHuman",
    "D98/AH2 Clone B\tHomo sapiens\tHeLa\tHuman",
    "DAMI\tHomo sapiens\tHEL\tHuman",
    "DAPT\tHomo sapiens\tHeLa\tHuman",
    "DD\tHomo sapiens\tK-562\tHuman",
    "DM12 (Tu-167 derivative)\tHomo sapiens\tUM-SCC-1\tHuman",
    "DM14 (Tu-167 derivative)\tHomo sapiens\tUM-SCC-1\tHuman",
    "DRO\tHomo sapiens\tA-375\tHuman",
    "DRO90-1\tHomo sapiens\tA-375\tHuman",
    "Det30A\tHomo sapiens\tHeLa\tHuman",
    "Detroit 98/AG\tHomo sapiens\tHeLa\tHuman",
    "Detroit 98/AH-2\tHomo sapiens\tHeLa\tHuman",
    "Detroit 98/AH-R\tHomo sapiens\tHeLa\tHuman",
    "Detroit 98s\tHomo sapiens\tHeLa\tHuman",
    "Detroit-6 (Det6)\tHomo sapiens\tHeLa\tHuman",
    "Detroit-98\tHomo sapiens\tHeLa\tHuman",
    "DuPro-1\tHomo sapiens\tPC-3\tHuman",
    "EB-3\tHomo sapiens\tDaudi\tHuman",
    "EB33\tHomo sapiens\tHeLa\tHuman",
    "ECC-1\tHomo sapiens\tIshikawa\tHuman",
    "ECTC\tBos taurus\tVero\tMonkey, African green (Cercopithecus aethiops)",
    "ECV-304\tHomo sapiens\tT-24\tHuman",
    "ED27\tHomo sapiens\tHeLa\tHuman",
    "EEK\tEquus caballus\tNSK\tPig, Sus scrofa",
    "EH\tHomo sapiens\tHK\tHuman",
    "EJ-1\tHomo sapiens\tT-24\tHuman",
    "EPC\tCyprinus carpio\tUnknown\tFathead minnow, Pimephales promelas",
    "EPLC-65\tHomo sapiens\tHeLa\tHuman",
    "EPLC3-2M1\tHomo sapiens\tHeLa\tHuman",
    "ESP1\tHomo sapiens\tHeLa\tHuman",
    "ETK-1\tHomo sapiens\tSSP-25\tHuman",
    "EU-1\tHomo sapiens\tREH\tHuman",
    "EU-7\tHomo sapiens\tCCRF-CEM\tHuman",
    "EUE\tHomo sapiens\tHeLa\tHuman",
    "EVLC2\tHomo sapiens\tUnknown\tHuman",
    "Ej138\tHomo sapiens\tT-24\tHuman",
    "ElCo\tHomo sapiens\tHeLa\tHuman",
    "F2-4E5\tHomo sapiens\tSK-HEP-1\tHuman",
    "F2-5B6\tHomo sapiens\tSK-HEP-1\tHuman",
    "F255A4\tHomo sapiens\tHeLa\tHuman",
    "FB2\tHomo sapiens\tTPC-1\tHuman",
    "FL\tHomo sapiens\tHeLa\tHuman",
    "FQ\tHomo sapiens\tOMK-210\tMonkey, Owl (Aotus trivirgatus)",
    "FU-RPNT-2\tHomo sapiens\tFU-RPNT-1\tHuman",
    "Fitz-HSA \tCanis lupus familiaris\tDEN-HSA \tDog, Canis familiaris",
    "Flow 13000\tHomo sapiens\tMRC-5\tHuman",
    "Flow 5000\tHomo sapiens\tFlow 1000\tHuman",
    "Flow 6000\tHomo sapiens\tFlow 1000\tHuman",
    "Flow 7000\tHomo sapiens\tFlow 3000\tHuman",
    "G-11 (HBT-3 derivative)\tHomo sapiens\tHeLa\tHuman",
    "GHE\tHomo sapiens\tT-24\tHuman",
    "GM1312\tHomo sapiens\tCorrect name, incorrect cell type\tHuman",
    "GOS-3\tHomo sapiens\tU-343 MG\tHuman",
    "GPS-M\tCavia porcellus\tStrain L-M\tMouse",
    "GPS-PD\tCavia porcellus\tStrain L-M\tMouse",
    "GREF-X\tHomo sapiens\tUnknown\tRat",
    "GT3TKB\tHomo sapiens\tRERF-LC-A1\tHuman",
    "Girardi heart\tHomo sapiens\tHeLa\tHuman",
    "Grey\tCanis lupus familiaris\tUnknown\tHuman",
    "H-494\tHomo sapiens\tHeLa\tHuman",
    "H249\tHomo sapiens\tH69\tHuman",
    "H7D7A and derivatives\tHomo sapiens\tHepG2\tHuman",
    "H7D7B and derivatives\tHomo sapiens\tHepG2\tHuman",
    "H7D7C and derivatives\tHomo sapiens\tHepG2\tHuman",
    "H7D7D and derivatives\tHomo sapiens\tHepG2\tHuman",
    "HAC15\tHomo sapiens\tNCI-H295R\tHomo sapiens\t",
    "HAG\tHomo sapiens\tT-24\tHuman",
    "HBC\tHomo sapiens\tUnknown\tRat",
    "HBL-100\tHomo sapiens\tUnknown\tHuman",
    "HBT-3\tHomo sapiens\tHeLa\tHuman",
    "HBT-39b\tHomo sapiens\tHeLa\tHuman",
    "HBT-E (HBT-3 clone)\tHomo sapiens\tHeLa\tHuman",
    "HCE\tHomo sapiens\tHeLa\tHuman",
    "HCV-29Tmv (HCV-29 derivative)\tHomo sapiens\tT-24\tHuman",
    "HCu-10\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HCu-18\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HCu-22\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HCu-27\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HCu-33\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HCu-37\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HCu-39\tHomo sapiens\tHcu-10, Hcu-18, Hcu-22, Hcu-27, Hcu-33, Hcu-37 or Hcu-39 (genetically identical)\tHuman",
    "HEC-155\tHomo sapiens\tHEC-180\tHuman",
    "HEC-180\tHomo sapiens\tHEC-155\tHuman",
    "HEK\tHomo sapiens\tHeLa\tHuman",
    "HEK/HRV (HEK derivative)\tHomo sapiens\tHeLa\tHuman",
    "HEL-R66\tHomo sapiens\tUnknown\tMonkey, African green (Cercopithecus aethiops)",
    "HES\tHomo sapiens\tHeLa\tHuman",
    "HEp-2 (H.Ep.-2)\tHomo sapiens\tHeLa\tHuman",
    "HIMEG-1\tHomo sapiens\tHL-60\tHuman",
    "HKB-1\tHomo sapiens\tUnknown\tHuman",
    "HKMUS\tHomo sapiens\tSKG-II-SF\tHuman",
    "HKMUS-SF\tHomo sapiens\tSKG-II-SF\tHuman",
    "HL111783\tHomo sapiens\tHeLa\tHuman",
    "HMV-1\tHomo sapiens\tHeLa\tHuman",
    "HPB-ALL\tHomo sapiens\tJURKAT\tHuman",
    "HPB-MLT\tHomo sapiens\tHPB-ALL\tHuman",
    "HPC-36M (HPC-36 derivative)\tHomo sapiens\tHeLa\tHuman",
    "HS-SULTAN\tHomo sapiens\tJIJOYE\tHuman",
    "HSC-41\tHomo sapiens\tHSC-42\tHuman",
    "HSG\tHomo sapiens\tHeLa\tHuman",
    "HSG-AZA1\tHomo sapiens\tHeLa\tHuman",
    "HSG-AZA3\tHomo sapiens\tHeLa\tHuman",
    "HSGc-C5\tHomo sapiens\tHeLa\tHuman",
    "HSY\tHomo sapiens\tHeLa\tHuman",
    "Hep-2C\tHomo sapiens\tHeLa\tHuman",
    "Hep2 (Clone 2B)\tHomo sapiens\tHeLa\tHuman",
    "Hs 677.St\tHomo sapiens\tUnknown\tMouse",
    "Hu1734\tHomo sapiens\tHCV-29\tHuman",
    "Hu456\tHomo sapiens\tT-24\tHuman",
    "Hu549\tHomo sapiens\tT-24\tHuman",
    "Hu609\tHomo sapiens\tJ82\tHuman",
    "Hu609Tmv (Hu609 derivative)\tHomo sapiens\tT-24\tHuman",
    "Hu961a, Hu961t (Hu961 derivatives)\tHomo sapiens\tT-24\tHuman",
    "HuKo39\tHomo sapiens\tHeLa\tHuman",
    "HuL-1\tHomo sapiens\tHeLa\tHuman",
    "Hut\tHomo sapiens\tHeLa\tHuman",
    "IMC-2\tHomo sapiens\tHeLa\tHuman",
    "IMC-3\tHomo sapiens\tHeLa\tHuman",
    "IMC-4\tHomo sapiens\tHeLa\tHuman",
    "IPDDC-A2\tHomo sapiens\tUnknown\tRat",
    "IPEC\tSus scrofa\tUnknown\tCow",
    "IPRB\tHomo sapiens\tUnknown\tRat",
    "IPRI-OL-11\tOrgyia leucostigma\tIPRI-CF-124\tChoristoneura fumiferana\t",
    "IPRI-OL-7\tOrgyia leucostigma\tIPRI-CF-124\tChoristoneura fumiferana\t",
    "IPTP/98\tHomo sapiens\tUnknown\tRat",
    "IST-1\tHomo sapiens\tSK-OV-3\tHuman",
    "Intestine 407 (Int-407, HEI)\tHomo sapiens\tHeLa\tHuman",
    "J-111\tHomo sapiens\tHeLa\tHuman",
    "J-82\tHomo sapiens\tT-24\tHuman",
    "J96\tHomo sapiens\tHeLa\tHuman",
    "JCA-1\tHomo sapiens\tT-24\tHuman",
    "JHC\tHomo sapiens\tHeLa\tHuman",
    "JHH-1\tHomo sapiens\tUnknown\tMouse",
    "JHT (JHC derivative)\tHomo sapiens\tHeLa\tHuman",
    "JHU012\tHomo sapiens\tJHU022\tHuman",
    "JHU013 (JHU012 derivative)\tHomo sapiens\tFaDu\tHuman",
    "JHU019\tHomo sapiens\tPC-3\tHuman",
    "JHU028\tHomo sapiens\tA549\tHuman",
    "JMAR (Tu-167 derivative)\tHomo sapiens\tUM-SCC-1\tHuman",
    "JOSK-I\tHomo sapiens\tU-937\tHuman",
    "JOSK-K\tHomo sapiens\tU-937\tHuman",
    "JOSK-M\tHomo sapiens\tU-937\tHuman",
    "JOSK-S\tHomo sapiens\tU-937\tHuman",
    "JTC-17\tHomo sapiens\tHeLa\tHuman",
    "JTC-3\tHomo sapiens\tHeLa\tHuman",
    "K051\tHomo sapiens\tK-562\tHuman",
    "K1\tHomo sapiens\tGLAG-66\tHuman",
    "K2\tHomo sapiens\tGLAG-66\tHuman",
    "KAK1\tHomo sapiens\tHT-29\tHuman",
    "KARPAS-45\tHomo sapiens\tUnknown\tHuman",
    "KAT10\tHomo sapiens\tHT-29\tHuman",
    "KAT4\tHomo sapiens\tHT-29\tHuman",
    "KAT5\tHomo sapiens\tHT-29\tHuman",
    "KAT50\tHomo sapiens\tHT-29\tHuman",
    "KAT7\tHomo sapiens\tHT-29\tHuman",
    "KB\tHomo sapiens\tHeLa\tHuman",
    "KB-3-1\tHomo sapiens\tHeLa\tHuman",
    "KB-V1\tHomo sapiens\tHeLa\tHuman",
    "KBM-3\tHomo sapiens\tHL-60\tHuman",
    "KCI-MOH1\tHomo sapiens\tHPAC\tHuman",
    "KE-37\tHomo sapiens\tCCRF-CEM\tHuman",
    "KM-3\tHomo sapiens\tREH\tHuman",
    "KM20\tHomo sapiens\tHT-29\tHomo sapiens\t",
    "KM20L2\tHomo sapiens\tHT-29\tHomo sapiens\t",
    "KM3\tHomo sapiens\tUnknown\tRat",
    "KMS-21-BM\tHomo sapiens\tUnknown\tHuman",
    "KMT-2\tHomo sapiens\tKG-1\tHuman",
    "KNS-89\tHomo sapiens\tU-251 MG\tHuman",
    "KOSC-3\tHomo sapiens\tCa9-22\tHuman",
    "KP-1N\tHomo sapiens\tPANC-1\tHuman",
    "KP-P1\tHomo sapiens\tHeLa\tHuman",
    "KPB-M15\tHomo sapiens\tKYO-1\tHuman",
    "KPL-1\tHomo sapiens\tMCF-7\tHuman",
    "KSY-1\tHomo sapiens\tT-24\tHuman",
    "KU-YS\tHomo sapiens\tKU-SN\tHuman",
    "KU7\tHomo sapiens\tHeLa\tHuman",
    "L-132\tHomo sapiens\tHeLa\tHuman",
    "L-41 (J96 derivative)\tHomo sapiens\tHeLa\tHuman",
    "L-540\tHomo sapiens\tCCRF-CEM\tHuman",
    "LC5\tHomo sapiens\tHeLa\tHomo sapiens\t",
    "LC5-HIV\tHomo sapiens\tHeLa\tHomo sapiens\t",
    "LED-Ti\tHomo sapiens\tHeLa\tHuman",
    "LLC-15MB\tHomo sapiens\tM14\tHuman",
    "LN-319\tHomo sapiens\tLN-992\tHuman",
    "LN-443\tHomo sapiens\tLN-444\tHuman",
    "LR10.6\tHomo sapiens\tNALM-6\tHuman",
    "LT-1\tFrog, grass\tTH and FHM\tTH = box turtle; FHM = fathead minnow",
    "LU\tHomo sapiens\tHeLa\tHuman",
    "LU 106\tHomo sapiens\tHeLa\tHuman",
    "Lu-130\tHomo sapiens\tLu-134A, B\tHuman",
    "M10T\tHomo sapiens\tHeLa\tHuman",
    "M4A4 and derivatives (MDA-MB-435 derivatives)\tHomo sapiens\tM14\tHuman",
    "MA-1\tHomo sapiens\tPfeiffer\tHuman",
    "MA-104\tMacaca mulatta\tVero?\tMonkey, African green (Cercopithecus aethiops)",
    "MA-111\tOryctolagus cuniculus\tVero?\tMonkey, African green (Cercopithecus aethiops)",
    "MA-160\tHomo sapiens\tHeLa\tHuman",
    "MB-02\tHomo sapiens\tHU-3\tHuman",
    "MC-4000\tHomo sapiens\tHeLa\tHuman",
    "MCF-7/AdrR (NCI/ADR-RES)\tHomo sapiens\tOVCAR-8\tHuman",
    "MDA-MB-435\tHomo sapiens\tM14\tHuman",
    "MDA-N (MDA-MB-435 derivative)\tHomo sapiens\tM14\tHuman",
    "MDA1986LN\tHomo sapiens\tUM-SCC-1\tHuman",
    "MDA686LN\tHomo sapiens\tUM-SCC-1\tHuman",
    "MDA686TU\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "MDS\tHomo sapiens\tJURKAT\tHuman",
    "ME-WEI\tHomo sapiens\tUnknown, does not match other cell line from same donor\tHuman",
    "MEL-HO\tHomo sapiens\tUnknown, does not match other cell line from same donor\tHuman",
    "MGH-U1 (EJ)\tHomo sapiens\tT-24\tHuman",
    "MGH-U2 (HM)\tHomo sapiens\tT-24\tHuman",
    "MHH-225\tHomo sapiens\tJURKAT\tHuman",
    "MKB-1\tHomo sapiens\tCCRF-CEM\tHuman",
    "MKN-7\tHomo sapiens\tUnknown\tHuman",
    "MKN28\tHomo sapiens\tMKN74\tHuman",
    "MOBS-1\tHomo sapiens\tU-937\tHuman",
    "MOLT-15\tHomo sapiens\tCTV-1\tHuman",
    "MPanc-96\tHomo sapiens\tAsPC-1\tHuman",
    "MRO87-1\tHomo sapiens\tHT-29\tHuman",
    "MS (Monkey Stable)\tMonkey\tHeLa\tHuman",
    "MT-1\tHomo sapiens\tHeLa\tHuman",
    "MT-3\tHomo sapiens\tLS-174T (LS-180 derivative)\tHomo sapiens\t",
    "MUTZ-1\tHomo sapiens\tNamalwa\tHuman",
    "MV522\tHomo sapiens\tHT-29\tHuman",
    "MaTu\tHomo sapiens\tHeLa\tHuman",
    "Mash-1\tHomo sapiens\tMMac\tHuman",
    "McCoy\tHomo sapiens\tStrain L\tMouse",
    "Minnesota EE\tHomo sapiens\tHeLa\tHuman",
    "NC-37\tHomo sapiens\tRaji\tHuman",
    "NCC16\tHomo sapiens\tPHK16-0b\tHuman",
    "NCI-H1264\tHomo sapiens\tNCI-H157\tHuman",
    "NCI-H1304\tHomo sapiens\tNCI-H1870\tHuman",
    "NCI-H1514\tHomo sapiens\tUnknown\tHuman",
    "NCI-H157\tHomo sapiens\tNCI-H1264\tHuman",
    "NCI-H1622\tHomo sapiens\tUnknown\tHuman",
    "NCI-H1870\tHomo sapiens\tNCI-H1304\tHuman",
    "NCI-H249\tHomo sapiens\tNCI-H69\tHuman",
    "NCI-H513\tHomo sapiens\tNCI-H125\tHuman",
    "NCI-H592\tHomo sapiens\tNCI-H69\tHuman",
    "NCI-H60\tHomo sapiens\tNCI-N417\tHuman",
    "NCI-H630\tHomo sapiens\tMixture\tHuman",
    "NCI-H738\tHomo sapiens\tUnknown\tHuman",
    "NCI-H929\tHomo sapiens\tK-562\tHuman",
    "NCI/ADR-RES (MCF-7/AdrR)\tHomo sapiens\tOVCAR-8\tHuman",
    "NCOL-1\tHomo sapiens\tLoVo\tHuman",
    "NCTC 2544\tHomo sapiens\tHeLa\tHuman",
    "NCTC 3075\tHomo sapiens\tHeLa\tHuman",
    "ND-1\tHomo sapiens\tDU-145\tHuman",
    "NM2C5 and derivatives (MDA-MB-435 derivatives)\tHomo sapiens\tM14\tHuman",
    "NOI-90\tHomo sapiens\tREH\tHuman",
    "NOSE06\tHomo sapiens\tDOV-13\tHuman",
    "NOSE07\tHomo sapiens\tDOV-13\tHuman",
    "NPA87\tHomo sapiens\tM14\tHuman",
    "NS-3\tHomo sapiens\tCOLO 201\tHuman",
    "OCM-3\tHomo sapiens\tSK-MEL-28\tHomo sapiens\t",
    "OCM-8\tHomo sapiens\tSK-MEL-28\tHomo sapiens\t",
    "OCUM-6\tHomo sapiens\tOCUM-11\tHuman",
    "OE\tHomo sapiens\tHeLa\tHuman",
    "OF\tHomo sapiens\tHeLa\tHuman",
    "OLGA-PH-J/92 [OL-J/92]\tOrconectes limosus\tUnknown\tUnknown, similar to amoeba species",
    "ONCO-DG-1\tHomo sapiens\tOVCAR-3\tHuman",
    "OS 187\tHomo sapiens\tHCT-15\tHuman",
    "OST\tHomo sapiens\tHeLa\tHuman",
    "OU-AML-1\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-2\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-3\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-4\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-5\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-6\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-7\tHomo sapiens\tOCI/AML2\tHuman",
    "OU-AML-8\tHomo sapiens\tOCI/AML2\tHuman",
    "OV-1063\tHomo sapiens\tUnknown\tHuman",
    "OV2008, OV2008/C13\tHomo sapiens\tME-180\tHuman",
    "OV2008/C13\tHomo sapiens\tME-180\tHomo sapiens\t",
    "OVMIU\tHomo sapiens\tOVSAYO\tHuman",
    "Ovary1847\tHomo sapiens\tNIH:OVCAR-8\tHuman",
    "P1-1A3\tHomo sapiens\tSK-HEP-1\tHuman",
    "P1-4D6\tHomo sapiens\tSK-HEP-1\tHuman",
    "P39/TSUGANE (P39/TSU)\tHomo sapiens\tHL-60\tHuman",
    "PBEI\tHomo sapiens\tNALM-6\tHuman",
    "PC-93\tHomo sapiens\tHeLa\tHuman",
    "PC-MDS\tHomo sapiens\tK-562\tHuman",
    "PCI-22A\tHomo sapiens\tUnknown, does not match other cell line from same donor\tHuman",
    "PCI-22B\tHomo sapiens\tUnknown, does not match other cell line from same donor\tHuman",
    "PCI-3\tHomo sapiens\tPC-3\tHuman",
    "PEAZ-1\tHomo sapiens\tHT-1080\tHuman",
    "PH61-N\tHomo sapiens\tMIA PaCa-2\tHuman",
    "PLB-985\tHomo sapiens\tHL-60\tHuman",
    "PPC-1\tHomo sapiens\tPC-3\tHuman",
    "PSV811\tHomo sapiens\tWI-38\tHuman",
    "Panc 01.28\tHomo sapiens\tPanc 01.28, Panc 06.03\tHomo sapiens\t",
    "Panc 06.03\tHomo sapiens\tPanc 01.28, Panc 06.03\tHomo sapiens\t",
    "Parks\tCanis lupus familiaris\tUnknown\tHuman",
    "RAMAK-1\tHomo sapiens\tT-24\tHuman",
    "RB\tHomo sapiens\tOMK-210\tMonkey, Owl (Aotus trivirgatus)",
    "RBHF-1\tHomo sapiens\tUnknown\tNon-human",
    "RC-2A\tHomo sapiens\tCCRF-CEM\tHuman",
    "RED-3\tHomo sapiens\tHL-60\tHuman",
    "REH-6\tHomo sapiens\tUnknown\tMouse",
    "REPC\tHomo sapiens\tHep 3B\tHuman",
    "RERF-LC-MA\tHomo sapiens\tSK-MES-1\tHuman",
    "RERF-LC-OK\tHomo sapiens\tMarcus\tHuman",
    "RGC-5\tRat\t661W\tMouse",
    "RM-10\tHomo sapiens\tK-562\tHuman",
    "RMG-II\tHomo sapiens\tRMG-I\tHuman",
    "RMUG-L\tHomo sapiens\tSNG-II\tHuman",
    "RO-D81-1\tHomo sapiens\tHT-29\tHuman",
    "RO-H85-1\tHomo sapiens\t647-V\tHuman",
    "RPMI-4788\tHomo sapiens\tHeLa\tHuman",
    "RPMI-6666\tHomo sapiens\tCorrect name, incorrect cell type\tHuman",
    "RPMI-8402\tHomo sapiens\tUnknown\tHuman",
    "RPTC-1\tHomo sapiens\tTPC-1\tHuman",
    "RS-1\tHomo sapiens\tK-562\tHuman",
    "RT4\tHomo sapiens\tHeLa\tHuman",
    "RTSG\tHomo sapiens\tSNG-II\tHuman",
    "RY\tHomo sapiens\tUnknown\tMonkey",
    "SA4\tHomo sapiens\tHeLa\tHuman",
    "SAM-1\tHomo sapiens\tK-562\tHuman",
    "SAML-1\tHomo sapiens\tU-937\tHuman",
    "SBC-2\tHomo sapiens\tHeLa\tHuman",
    "SBC-7\tHomo sapiens\tHeLa\tHuman",
    "SCCTF\tHomo sapiens\tSCCKN\tHuman",
    "SCLC-16H\tHomo sapiens\tSCLC-21/22H\tHuman",
    "SCLC-24H\tHomo sapiens\tSCLC-21/22H\tHuman",
    "SEG-1\tHomo sapiens\tNCI-H460\tHuman",
    "SF767\tHomo sapiens\tME-180\tHuman",
    "SH-2\tHomo sapiens\tHeLa\tHuman",
    "SH-3\tHomo sapiens\tHeLa\tHuman",
    "SJPL\tSus scrofa\tUnknown\tMonkey, African green (Cercopithecus aethiops)",
    "SK-GT-5\tHomo sapiens\tSK-GT-2\tHuman",
    "SK-MG-1\tHomo sapiens\tMarcus\tHuman",
    "SK-N-MC\tHomo sapiens\tUnknown\tHuman",
    "SK-OV-4\tHomo sapiens\tC-33A\tHuman",
    "SK-OV-6\tHomo sapiens\tC-33A\tHuman",
    "SKW-3\tHomo sapiens\tKE-37\tHuman",
    "SLK\tHomo sapiens\tCaki-1\tHuman",
    "SNB-19\tHomo sapiens\tU-251 MG\tHuman",
    "SPI-801\tHomo sapiens\tK-562\tHuman",
    "SPI-802\tHomo sapiens\tK-562\tHuman",
    "SQ-5\tHomo sapiens\tHeLa\tHuman",
    "SR-91\tHomo sapiens\tAML-193\tHuman",
    "SW-527\tHomo sapiens\tSW-480, SW-620\tHuman",
    "SW-598\tHomo sapiens\tSW-480, SW-620\tHuman",
    "SW-608\tHomo sapiens\tSW-480, SW-620\tHuman",
    "SW-613\tHomo sapiens\tSW-480, SW-620\tHuman",
    "SW-732\tHomo sapiens\tSW-480, SW-620\tHuman",
    "SW-733\tHomo sapiens\tSW-480, SW-620\tHuman",
    "SpR\tHomo sapiens\tOMK-210\tMonkey, Owl (Aotus trivirgatus)",
    "T-1\tHomo sapiens\tHeLa\tHuman",
    "T-33\tHomo sapiens\tK-562\tHuman",
    "T-9 (WI-38 derivative)\tHomo sapiens\tHeLa\tHuman",
    "T1\tHomo sapiens\tHeLa\tHuman",
    "T3M-12\tHomo sapiens\tT3M-1\tHuman",
    "T404\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "T406 (oral SCC) **Different cell line exists with same name:  T406 (glioblastoma)**\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "T409\tHomo sapiens\tUM-SCC-1\tHuman",
    "TCO-1\tHomo sapiens\tTCO-2\tHuman",
    "TDL-1\tHomo sapiens\tP3JHR-1\tHuman",
    "TDL-2\tHomo sapiens\tP3JHR-1\tHuman",
    "TDL-3\tHomo sapiens\tRPMI 1788\tHuman",
    "TDL-4\tHomo sapiens\tRaji\tHuman",
    "TE-12\tHomo sapiens\tTE-2, TE-3, TE-12 or TE-13 (genetically identical)\tHuman",
    "TE-13\tHomo sapiens\tTE-2, TE-3, TE-12 or TE-13 (genetically identical)\tHuman",
    "TE-2\tHomo sapiens\tTE-2, TE-3, TE-12 or TE-13 (genetically identical)\tHuman",
    "TE-3\tHomo sapiens\tTE-2, TE-3, TE-12 or TE-13 (genetically identical)\tHuman",
    "TE-7\tHomo sapiens\tTE-2, TE-3, TE-12 or TE-13 (genetically identical)\tHuman",
    "TE671\tHomo sapiens\tRD\tHuman",
    "TE671 Subline No.2\tHomo sapiens\tRD\tHuman",
    "TEC61\tHomo sapiens\tJEG3\tHuman",
    "TI-1\tHomo sapiens\tK-562\tHuman",
    "TK-1\tHomo sapiens\tU-251 MG\tHuman",
    "TMH-1\tHomo sapiens\tIHH-4\tHuman",
    "TMM\tHomo sapiens\tCorrect name, incorrect cell type\tHuman",
    "TSU-Pr1\tHomo sapiens\tT-24\tHuman",
    "Tu-138\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "Tu-158LN\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "Tu-159\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "Tu-167\tHomo sapiens\tUM-SCC-1\tHuman",
    "Tu-182\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "Tu-212\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "Tu-212LN\tHomo sapiens\tT404, T406, Tu-138, Tu-158LN, Tu-159, Tu-182, Tu-212, Tu-212LN (genetically identical)\tHuman",
    "TuWi\tHomo sapiens\tHeLa\tHuman",
    "U-118 MG\tHomo sapiens\tU-138 MG\tHuman",
    "U-373 MG\tHomo sapiens\tU-251 MG\tHuman",
    "U-937\tHomo sapiens\tUnknown\tHuman",
    "U251-TR3\tHomo sapiens\tU-251 MG\tHomo sapiens\t",
    "UM-UC-2\tHomo sapiens\tT-24\tHuman",
    "UM-UC-3-GFP (UM-UC-3 derivative)\tHomo sapiens\tUnknown, NOT UM-UC-3\tHuman",
    "UPES/C\tHomo sapiens\tUnknown\tRat",
    "UPHHJA\tHomo sapiens\tUnknown\tRat",
    "UROtsa\tHomo sapiens\tT-24\tHuman",
    "UT-7\tHomo sapiens\tU-937\tHuman",
    "UTMB-460\tHomo sapiens\tCCRF-CEM\tHuman",
    "VC312R\tHomo sapiens\tUnknown\tMixed, human + mouse",
    "VM-CUB-III\tHomo sapiens\tVM-CUB-I\tHuman",
    "WISH\tHomo sapiens\tHeLa\tHuman",
    "WKD\tHomo sapiens\tHeLa\tHuman",
    "WRL 68\tHomo sapiens\tHeLa\tHuman",
    "WSU-ALCL\tHomo sapiens\tCCRF-CEM\tHuman",
    "WSU-CLL\tHomo sapiens\tREH\tHuman",
    "WiDr\tHomo sapiens\tHT-29\tHuman",
    "Wong-Kilbourne\tHomo sapiens\tHeLa\tHuman",
    "YAA\tHomo sapiens\tU-937\tHuman",
    "YAP\tHomo sapiens\tU-937\tHuman",
    "YJ\tHomo sapiens\tHL-60\tHuman",
    "YMB-1\tHomo sapiens\tZR-75-1\tHuman",
    "YMB-1-E\tHomo sapiens\tZR-75-1\tHuman",
    "Yamada\tCanis lupus familiaris\tUnknown\tMouse",
    "hPTC\tHomo sapiens\tUnknown\tPig, Sus scrofa",
    "hTERT-EEC\tHomo sapiens\tMCF-7\tHuman"
};
