C
C	$Id: dashdb.f,v 1.5 2008-07-27 00:16:58 haley Exp $
C                                                                      
C                Copyright (C)  2000
C        University Corporation for Atmospheric Research
C                All Rights Reserved
C
C The use of this Software is governed by a License Agreement.
C
      SUBROUTINE DASHDB (IPAT)
C
C ARGUMENTS              IPAT
C ON INPUT                 IPAT IS A 16-BIT DASH PATTERN.  BY DEFAULT
C                          EACH BIT IN THE PATTERN REPRESENTS 3 PLOTTER
C                          ADDRESS UNITS (1=SOLID, 0=BLANK)
C
C
C
C USER ENTRY POINT.
C DASHDB GIVES AN INTERNAL REPRESENTATION TO THE DASH PATTERN WHICH IS
C SPECIFIED IN ITS ARGUMENT. THIS INTERNAL REPRESENTATION IS PASSED
C TO ROUTINE CFVLD IN THE COMMON-BLOCK DASHD1.
C
      DIMENSION IPAT(1)
      COMMON/INTPR/IPAU,FPART,TENSN,NP,SMALL,L1,ADDLR,ADDTB,MLLINE,
     1    ICLOSE
C
C DASHD1 IS FOR COMMUNICATION BETWEEN THE ROUTINES DASHDB DASHDC
C AND CFVLD.
C ISL, MNCSTR AND IGP ARE INITIALIZED IN DASHBDX.
C
      COMMON /DASHD1/  ISL,  L,  ISIZE,  IP(100),  NWDSM1,  IPFLAG(100)
     1                 ,MNCSTR, IGP
C
C IFCFLG IS THE FIRST CALL FLAG FOR DASHDB AND DASHDC.
C IT IS INITIALIZED IN DASHBDX.
C
      COMMON /DDFLAG/ IFCFLG
C
C IFSTFL CONTROLS THAT FRSTD IS CALLED BEFORE VECTD IS CALLED (IN CFVLD)
C WHENEVER DASHDB OR DASHDC HAVE BEEN CALLED. IT IS INITIALIZED
C IN DASHBDX AND REFERENCED IN CFVLD.
C
      COMMON /DCFLAG/ IFSTFL
C
C LOCAL VARIABLES TO DASHDB AND DASHDC ARE SAVED IN DSAVE6
C FOR THE NEXT CALL TO
C
      COMMON /DSAVE6/ MASK, NCHRWD, NBWD, MNCST1
      SAVE
C
C Do a call forcing a BLOCKDATA to be loaded from a binary library.
C
      CALL DASHBD
C
C THE FOLLOWING CALL IS FOR LIBRARY STATISTICS GATHERING AT NCAR
      CALL Q8QST4 ('GRAPHX', 'DASHCHAR', 'DASHDB', 'VERSION  1')
      IF (IFCFLG .EQ. 2) GOTO 10
C
C CHECK IF THE CONSTANTS IN THE BLOCKDATA DASHBDX ARE LOADED CORRECTLY
C
      IF (MNCSTR .EQ. 15) GOTO 6
      CALL SETER('DASHDB -- BLOCKDATA DASHBDX APPARENTLY NOT LOADED CORR
     1ECTLY',1,2)
    6 CONTINUE
C
C INITIALIZATION
C
      MNCST1 = MNCSTR + 1
C
C MASK IS AN ALL SOLID PATTERN
C
      MASK=IOR(ISHIFT(32767,1),1)
C
      IFCFLG = 2
C
C L - NUMBER OF WORDS IN THE FINAL PATTERN, POINTER TO IP ARRAY.
C ISL - FLAG FOR ALL SOLID PATTERN (1) OR ALL GAP PATTERN (-1).
C IFSTFL - FLAG TO CONTROL THAT FRSTD IS CALLED IN CFVLD BEFORE VECTD IS
C          CALLED, WHENEVER DASHDB OR DASHDC HAVE BEEN CALLED.
C
   10 CONTINUE
      NCHRTS = 0
      L = 0
      ISL = 0
      IFSTFL = 1
C
      ICRT = IPAU*ISHIFT(1,15-10)
      IF (IPAT(1) .NE. 0) GO TO 260
      ISL = -1
      RETURN
  260 IF (IPAT(1) .NE. MASK) GO TO 270
      ISL = 1
      RETURN
  270 NMODE1 = IAND(ISHIFT(IPAT(1),-15),1)
      DO 290 I = 1,16
      IF (NMODE1 .NE. IAND(ISHIFT(IPAT(1),I-16),1)) GO TO 280
      NMODE1 = 1 - NMODE1
      L = L + 1
      IP(L) = 0
      IPFLAG(L) = 1 - 2*NMODE1
  280 IP(L) = IP(L) + ICRT
  290 CONTINUE
      RETURN
      END
