/*
 * ndpi_content_match.c
 *
 * Copyright (C) 2011-21 - ntop.org
 *
 * nDPI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nDPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nDPI.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* ****************************************************** */

static ndpi_network host_protocol_list[] = {
  /*
    SoundCloud
  */
  { 0x22FB2FEE /* 34.251.47.238 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },
  { 0x23A06456 /* 35.160.100.86 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },
  { 0x36C0CA58 /* 54.192.202.88 */, 32, NDPI_PROTOCOL_SOUNDCLOUD },

  /*
    Facebook, Inc.
    origin AS32934, AS54115
  */

  { 0x1F0D1800 /* 31.13.24.0/21 */, 21, NDPI_PROTOCOL_FACEBOOK },
  { 0x1F0D4000 /* 31.13.64.0/18 */, 18, NDPI_PROTOCOL_FACEBOOK },
  { 0x2D402800 /* 45.64.40.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0x42DC9000 /* 66.220.144.0/20 */, 20, NDPI_PROTOCOL_FACEBOOK },
  { 0x453FB000 /* 69.63.176.0/20 */, 20, NDPI_PROTOCOL_FACEBOOK },
  { 0x45ABE000 /* 69.171.224.0/19 */, 19, NDPI_PROTOCOL_FACEBOOK },
  { 0x4A774C00 /* 74.119.76.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0x67046000 /* 103.4.96.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0x81860000 /* 129.134.0.0/16 */, 16, NDPI_PROTOCOL_FACEBOOK },
  { 0x81CD5E00 /* 129.205.94.0/23 */, 23, NDPI_PROTOCOL_FACEBOOK },
  { 0x9df00000 /* 157.240.0.0/16 */, 16, NDPI_PROTOCOL_FACEBOOK },
  { 0xADFC4000 /* 173.252.64.0/18 */, 18, NDPI_PROTOCOL_FACEBOOK },
  { 0xB33CC000 /* 179.60.192.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0xB93CD800 /* 185.60.216.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0xC7C94000 /* 199.201.64.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },
  { 0xCC0F1400 /* 204.15.20.0/22 */, 22, NDPI_PROTOCOL_FACEBOOK },

  /*
    Twitter Inc.
    origin AS13414, AS35995
  */

  { 0x0819C200 /* 8.25.194.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0x0819C400 /* 8.25.196.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0x450C3800 /* 69.12.56.0/21 */, 21, NDPI_PROTOCOL_TWITTER },
  { 0x67FC7000 /* 103.252.112.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0x68F42800 /* 104.244.40.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42900 /* 104.244.41.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42A00 /* 104.244.42.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42B00 /* 104.244.43.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42C00 /* 104.244.44.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42D00 /* 104.244.45.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42E00 /* 104.244.46.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0x68F42F00 /* 104.244.47.0/24 */, 24, NDPI_PROTOCOL_TWITTER },
  { 0xB92D0400 /* 185.45.4.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xB92D0600 /* 185.45.6.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xBC40E000 /* 188.64.224.0/21 */, 21, NDPI_PROTOCOL_TWITTER },
  { 0xC02C4400 /* 192.44.68.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xC0854C00 /* 192.133.76.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0xC7109C00 /* 199.16.156.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0xC73B9400 /* 199.59.148.0/22 */, 22, NDPI_PROTOCOL_TWITTER },
  { 0xC7453A00 /* 199.69.58.0/23 */, 23, NDPI_PROTOCOL_TWITTER },
  { 0xC7603800 /* 199.96.56.0/21 */, 21, NDPI_PROTOCOL_TWITTER },
  { 0xCAA08000 /* 202.160.128.0/22 */, 22, NDPI_PROTOCOL_TWITTER },

  /*
    WhatsApp Inc.
    List of the WhatsApp server IP addresses and ranges
    https://developers.facebook.com/docs/whatsapp/network-debugging/
    Dec 1st, 2019
  */
  { 0x1F0D4033 /* 31.13.64.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4035 /* 31.13.64.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4131 /* 31.13.65.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4132 /* 31.13.65.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4233 /* 31.13.66.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4238 /* 31.13.66.56/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4239 /* 31.13.66.57/32  */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4334 /* 31.13.67.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4430 /* 31.13.68.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4434 /* 31.13.68.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4631 /* 31.13.70.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4632 /* 31.13.70.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4731 /* 31.13.71.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4732 /* 31.13.71.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4830 /* 31.13.72.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4834 /* 31.13.72.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4934 /* 31.13.73.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4A34 /* 31.13.74.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4C3C /* 31.13.76.60/32  */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4C3D /* 31.13.76.61/32  */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4F35 /* 31.13.79.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D4F36 /* 31.13.79.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5030 /* 31.13.80.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5035 /* 31.13.80.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5130 /* 31.13.81.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5135 /* 31.13.81.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5233 /* 31.13.82.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5237 /* 31.13.82.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5331 /* 31.13.83.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5333 /* 31.13.83.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5431 /* 31.13.84.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5433 /* 31.13.84.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5531 /* 31.13.85.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5533 /* 31.13.85.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5631 /* 31.13.86.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5633 /* 31.13.86.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5730 /* 31.13.87.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5733 /* 31.13.87.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5935 /* 31.13.89.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5936 /* 31.13.89.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5A31 /* 31.13.90.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5A33 /* 31.13.90.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5B31 /* 31.13.91.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5B33 /* 31.13.91.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5C3E /* 31.13.92.62/32  */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5C30 /* 31.13.92.48/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5C34 /* 31.13.92.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5D35 /* 31.13.93.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5D36 /* 31.13.93.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5D37 /* 31.13.93.55/32  */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5E34 /* 31.13.94.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5E36 /* 31.13.94.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5F32 /* 31.13.95.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x1F0D5F3F /* 31.13.95.63/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x3216F0A0 /* 50.22.240.160/27*/, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x32175A80 /* 50.23.90.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x45ABEF0B /* 69.171.239.11/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x45ABFA34 /* 69.171.250.52/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x45ABFA36 /* 69.171.250.54/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x45ABFF0B /* 69.171.255.11/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x66846036 /* 102.132.96.54/31*/, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x66846136 /* 102.132.97.54/31*/, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8AE00 /* 108.168.174.0/27*/, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8B0C0 /* 108.168.176.192/26*/, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8B100 /* 108.168.177.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8B460 /* 108.168.180.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8FE41 /* 108.168.254.65/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8FFE0 /* 108.168.255.224/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x6CA8FFE3 /* 108.168.255.227/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00135 /* 157.240.1.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00136 /* 157.240.1.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00235 /* 157.240.2.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00236 /* 157.240.2.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00336 /* 157.240.3.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00635 /* 157.240.6.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00636 /* 157.240.6.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00735 /* 157.240.7.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00736 /* 157.240.7.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00835 /* 157.240.8.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00836 /* 157.240.8.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00935 /* 157.240.9.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00936 /* 157.240.9.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00A35 /* 157.240.10.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00A36 /* 157.240.10.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00B35 /* 157.240.11.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00B36 /* 157.240.11.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00C35 /* 157.240.12.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00C36 /* 157.240.12.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00D36 /* 157.240.13.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00E34 /* 157.240.14.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00F35 /* 157.240.15.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF00F36 /* 157.240.15.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01034 /* 157.240.16.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01234 /* 157.240.18.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01335 /* 157.240.19.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01336 /* 157.240.19.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01434 /* 157.240.20.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01534 /* 157.240.21.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01635 /* 157.240.22.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01636 /* 157.240.22.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01735 /* 157.240.23.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01736 /* 157.240.23.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01836 /* 157.240.24.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01936 /* 157.240.25.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01A36 /* 157.240.26.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01B36 /* 157.240.27.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01C33 /* 157.240.28.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01C37 /* 157.240.28.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01D35 /* 157.240.29.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01D36 /* 157.240.29.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF01E36 /* 157.240.30.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C034 /* 157.240.192.52/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C037 /* 157.240.192.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C132 /* 157.240.193.50/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C137 /* 157.240.193.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C236 /* 157.240.194.54/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C336 /* 157.240.195.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C338 /* 157.240.195.56/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C43C /* 157.240.196.60/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C93C /* 157.240.201.60/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E550060 /* 158.85.0.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E5505C0 /* 158.85.5.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E552E80 /* 158.85.46.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E5530E0 /* 158.85.48.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E553A20 /* 158.85.58.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E553A60 /* 158.85.58.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E553DC0 /* 158.85.61.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E55E0A0 /* 158.85.224.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0x9E55E920 /* 158.85.233.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C2400 /* 169.44.36.0/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5020 /* 169.44.80.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5260 /* 169.44.82.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92C5480 /* 169.44.84.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92D4720 /* 169.45.71.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92D5780 /* 169.45.87.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DA9C0 /* 169.45.169.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DD240 /* 169.45.210.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DD6E0 /* 169.45.214.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DDBE0 /* 169.45.219.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DEE20 /* 169.45.238.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DF2C0 /* 169.45.242.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DF860 /* 169.45.248.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92DF8A0 /* 169.45.248.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F05C0 /* 169.47.5.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F0640 /* 169.47.6.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2320 /* 169.47.35.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2880 /* 169.47.40.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2A60 /* 169.47.42.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2AA0 /* 169.47.42.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F2AC0 /* 169.47.42.192/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F8260 /* 169.47.130.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92F9980 /* 169.47.153.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92FC680 /* 169.47.198.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA92FD4A0 /* 169.47.212.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93547E0 /* 169.53.71.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9355140 /* 169.53.81.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9363320 /* 169.54.51.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93637C0 /* 169.54.55.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA936DE80 /* 169.54.222.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9373C94 /* 169.55.60.148/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9373CAA /* 169.55.60.170/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93743E0 /* 169.55.67.224/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93745A0 /* 169.55.69.160/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9374A20 /* 169.55.74.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA9374B60 /* 169.55.75.96/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4B80 /* 169.60.75.128/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C4F00 /* 169.60.79.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93C9300 /* 169.60.147.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93D6500 /* 169.61.101.0/24 */, 24, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93E9F10 /* 169.62.159.16/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4080 /* 169.63.64.128/28 */, 28, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4920 /* 169.63.73.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4940 /* 169.63.73.64/26 */, 26, NDPI_PROTOCOL_WHATSAPP },
  { 0xA93F4C00 /* 169.63.76.0/25 */, 25, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC0A220 /* 173.192.162.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC0DEA0 /* 173.192.222.160/27*/, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC1E680 /* 173.193.230.128/27*/, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xADC1EF00 /* 173.193.239.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE24D080 /* 174.36.208.128/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE24D220 /* 174.36.210.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xAE25F340 /* 174.37.243.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC031 /* 179.60.192.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC033 /* 179.60.192.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC134 /* 179.60.193.52/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC235 /* 179.60.194.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC236 /* 179.60.194.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC331 /* 179.60.195.49/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB33CC333 /* 179.60.195.51/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8AD8840 /* 184.173.136.64/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8AD9320 /* 184.173.147.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8ADA140 /* 184.173.161.64/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB8ADAD74 /* 184.173.173.116/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD835 /* 185.60.216.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD836 /* 185.60.216.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD935 /* 185.60.217.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CD936 /* 185.60.217.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDA35 /* 185.60.218.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDA36 /* 185.60.218.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDB35 /* 185.60.219.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xB93CDB36 /* 185.60.219.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0xC09BD4C0 /* 192.155.212.192/27*/, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xC60BC1B6 /* 198.11.193.182/31 */, 31, NDPI_PROTOCOL_WHATSAPP },
  { 0xC60BFB20 /* 198.11.251.32/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xC6175000 /* 198.23.80.0/27 */, 27, NDPI_PROTOCOL_WHATSAPP },
  { 0xD02B73C0 /* 208.43.115.192/27 */, 27, NDPI_PROTOCOL_WHATSAPP },

  /* Files */
  { 0xB93CD835 /* 185.60.216.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CD836 /* 185.60.216.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CD935 /* 185.60.217.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CD936 /* 185.60.217.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDA35 /* 185.60.218.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDA36 /* 185.60.218.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDB35 /* 185.60.219.53/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },
  { 0xB93CDB36 /* 185.60.219.54/32 */, 32, NDPI_PROTOCOL_WHATSAPP_FILES },

  /*
    WhatsApp Web
    List of the WhatsApp Web server IP addresses and ranges
  */
  { 0x9DF01337 /* 157.240.19.55/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0143D /* 157.240.20.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF080A0 /* 157.240.128.160/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08121 /* 157.240.129.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08221 /* 157.240.130.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08321 /* 157.240.131.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08421 /* 157.240.132.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08521 /* 157.240.133.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08621 /* 157.240.134.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08721 /* 157.240.135.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08821 /* 157.240.136.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08921 /* 157.240.137.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08A21 /* 157.240.138.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08B22 /* 157.240.139.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08C22 /* 157.240.140.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08D22 /* 157.240.141.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08E22 /* 157.240.142.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF08F22 /* 157.240.143.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09022 /* 157.240.144.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09122 /* 157.240.145.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09222 /* 157.240.146.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09322 /* 157.240.147.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09422 /* 157.240.148.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09722 /* 157.240.151.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09822 /* 157.240.152.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09BA2 /* 157.240.155.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09EA2 /* 157.240.158.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF09FA2 /* 157.240.159.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A0A2 /* 157.240.160.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A222 /* 157.240.162.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A262 /* 157.240.162.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A2A2 /* 157.240.162.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A2E2 /* 157.240.162.226/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A422 /* 157.240.164.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A462 /* 157.240.164.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A522 /* 157.240.165.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A562 /* 157.240.165.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A622 /* 157.240.166.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A662 /* 157.240.166.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A722 /* 157.240.167.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A762 /* 157.240.167.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A822 /* 157.240.168.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0A862 /* 157.240.168.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0ACA0 /* 157.240.172.160/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0AD22 /* 157.240.173.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0AEA2 /* 157.240.174.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0AF22 /* 157.240.175.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B0A2 /* 157.240.176.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B1A2 /* 157.240.177.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B2A2 /* 157.240.178.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B3A2 /* 157.240.179.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B4A2 /* 157.240.180.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B5A2 /* 157.240.181.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B622 /* 157.240.182.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B722 /* 157.240.183.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B822 /* 157.240.184.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B922 /* 157.240.185.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0B962 /* 157.240.185.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BA62 /* 157.240.186.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BB62 /* 157.240.187.98/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BCA2 /* 157.240.188.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BCE2 /* 157.240.188.226/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BD21 /* 157.240.189.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BD61 /* 157.240.189.97/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BDA2 /* 157.240.189.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BDE2 /* 157.240.189.226/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BE21 /* 157.240.190.33/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BE61 /* 157.240.190.97/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BEA2 /* 157.240.190.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BEE2 /* 157.240.190.226/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BF22 /* 157.240.191.34/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BFA2 /* 157.240.191.162/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0BFE2 /* 157.240.191.226/32*/, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C53C /* 157.240.197.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C53D /* 157.240.197.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C63C /* 157.240.198.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C63D /* 157.240.198.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C83C /* 157.240.200.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0C83D /* 157.240.200.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CB3C /* 157.240.203.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CB3D /* 157.240.203.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CC3C /* 157.240.204.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CC3D /* 157.240.204.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CE3C /* 157.240.206.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CE3D /* 157.240.206.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CF3C /* 157.240.207.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0CF3D /* 157.240.207.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D03C /* 157.240.208.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D03D /* 157.240.208.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D13C /* 157.240.209.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D13D /* 157.240.209.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D23C /* 157.240.210.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D23D /* 157.240.210.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D43C /* 157.240.212.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D43D /* 157.240.212.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D53C /* 157.240.213.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D53D /* 157.240.213.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D63C /* 157.240.214.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D63D /* 157.240.214.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D83C /* 157.240.216.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0D83D /* 157.240.216.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0DE3C /* 157.240.222.60/32 */, 32, NDPI_PROTOCOL_WHATSAPP },
  { 0x9DF0DE3D /* 157.240.222.61/32 */, 32, NDPI_PROTOCOL_WHATSAPP },

  /*
    WeChat
    origin AS132203, AS132591, AS45090
  */
  { 0xCBCD93AB /* 203.205.147.171/32 */, 32, NDPI_PROTOCOL_WECHAT },
  { 0xCBCD93AD /* 203.205.147.173/32 */, 32, NDPI_PROTOCOL_WECHAT },
  { 0xCBCD97A2 /* 203.205.151.162/32 */, 32, NDPI_PROTOCOL_WECHAT },
  { 0x67071E25 /* 103.7.30.37/32     */, 32, NDPI_PROTOCOL_WECHAT },
  { 0XCBCDB000 /* 203.205.176.0/20   */, 20, NDPI_PROTOCOL_WECHAT },
  { 0XCBCDC000 /* 203.205.192.0/18   */, 18, NDPI_PROTOCOL_WECHAT },

  /*
    OpenDNS, LLC
    origin AS36692, AS30607
  */

  { 0x26631400 /* 38.99.20.0/23 */, 23, NDPI_PROTOCOL_OPENDNS },
  { 0x3F504FC0 /* 63.80.79.192/26 */, 26, NDPI_PROTOCOL_OPENDNS },
  { 0x43D74000 /* 67.215.64.0/19 */, 19, NDPI_PROTOCOL_OPENDNS },
  { 0x92700000 /* 146.112.0.0/16 */, 16, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5400 /* 185.60.84.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5500 /* 185.60.85.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5600 /* 185.60.86.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xB93C5700 /* 185.60.87.0/24 */, 24, NDPI_PROTOCOL_OPENDNS },
  { 0xCCC2E800 /* 204.194.232.0/21*/, 21, NDPI_PROTOCOL_OPENDNS },
  { 0xD043D800 /* 208.67.216.0/21 */, 21, NDPI_PROTOCOL_OPENDNS },
  { 0xD0452000 /* 208.69.32.0/21 */, 21, NDPI_PROTOCOL_OPENDNS },

  /*
    Microsoft Corporation (MS One Drive)
  */

  { 0xCC4FC300 /* 204.79.195.0/24 */, 24, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0xCC4FC400 /* 204.79.196.0/23 */, 23, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x86AA0000 /* 134.170.0.0/16 */, 16, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x83FD0C00 /* 131.253.12.0/22 */, 22, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x83FD1000 /* 131.253.16.0/23 */, 23, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x83FD1200 /* 131.253.18.0/24 */, 24, NDPI_PROTOCOL_MS_ONE_DRIVE },
  { 0x4136BF00 /* 65.54.191.0/24 */, 24, NDPI_PROTOCOL_MS_ONE_DRIVE },

  /*
    Amazon.com, Inc. / Amazon Data Services Ireland Ltd
    origin AS16509, AS14618, AS7224, AS62785, AS8987
  */

  { 0x08129000 /* 8.18.144.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x08129100 /* 8.18.145.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x08F84F00 /* 8.248.79.0/24 */, 24, NDPI_PROTOCOL_AMAZON_VIDEO },
  { 0x0D200000 /* 13.32.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D340000 /* 13.52.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D380000 /* 13.56.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D700000 /* 13.112.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0D7C0000 /* 13.124.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0DD00000 /* 13.208.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0DE40000 /* 13.228.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x0DE80000 /* 13.232.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x0DF80000 /* 13.248.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x17140000 /* 23.20.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x1B000000 /* 27.0.0.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x22C00000 /* 34.192.0.0/10 */, 10, NDPI_PROTOCOL_AMAZON },
  { 0x23980000 /* 35.152.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x23B00000 /* 35.176.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x2BFAC000 /* 43.250.192.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x2BFAC100 /* 43.250.193.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x2E338000 /* 46.51.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x2E33C000 /* 46.51.192.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x2E33D800 /* 46.51.216.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x2E33E000 /* 46.51.224.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x2E890000 /* 46.137.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x2E898000 /* 46.137.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x2E89C000 /* 46.137.192.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x2E89E000 /* 46.137.224.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x32100000 /* 50.16.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x32700000 /* 50.112.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34000000 /* 52.0.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34020000 /* 52.2.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34040000 /* 52.4.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34080000 /* 52.8.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34090000 /* 52.9.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x340A0000 /* 52.10.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x340C0000 /* 52.12.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x340E0000 /* 52.14.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34100000 /* 52.16.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34120000 /* 52.18.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34140000 /* 52.20.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34180000 /* 52.24.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x341C0000 /* 52.28.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x341D0000 /* 52.29.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x341E0000 /* 52.30.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34200000 /* 52.32.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34240000 /* 52.36.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34280000 /* 52.40.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x342C0000 /* 52.44.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x342E0000 /* 52.46.0.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x342E5000 /* 52.46.80.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x342F0000 /* 52.47.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34300000 /* 52.48.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34340000 /* 52.52.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34360000 /* 52.54.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34380000 /* 52.56.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34390000 /* 52.57.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x343A0000 /* 52.58.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x343C0000 /* 52.60.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x343E0000 /* 52.62.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34400000 /* 52.64.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34408000 /* 52.64.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34410000 /* 52.65.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34420000 /* 52.66.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34430000 /* 52.67.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34440000 /* 52.68.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34460000 /* 52.70.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34480000 /* 52.72.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x344A0000 /* 52.74.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x344C0000 /* 52.76.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x344C8000 /* 52.76.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x344D0000 /* 52.77.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x344E0000 /* 52.78.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x344F0000 /* 52.79.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x34520000 /* 52.82.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34540000 /* 52.84.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34580000 /* 52.88.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x345A0000 /* 52.90.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x345EE000 /* 52.94.224.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x345F0000 /* 52.95.0.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x345F0A00 /* 52.95.10.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x345F0C00 /* 52.95.12.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F1000 /* 52.95.16.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x345F1800 /* 52.95.24.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F1E00 /* 52.95.30.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x345F2200 /* 52.95.34.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345F2300 /* 52.95.35.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345F2400 /* 52.95.36.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F3000 /* 52.95.48.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F3400 /* 52.95.52.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F3800 /* 52.95.56.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F4000 /* 52.95.64.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x345F5000 /* 52.95.80.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x345F6000 /* 52.95.96.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F6400 /* 52.95.100.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F6800 /* 52.95.104.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345F6F00 /* 52.95.111.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345F8000 /* 52.95.128.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x345FA000 /* 52.95.160.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x345FC000 /* 52.95.192.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0x345FD400 /* 52.95.212.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x345FE000 /* 52.95.224.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF000 /* 52.95.240.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF100 /* 52.95.241.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF200 /* 52.95.242.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF300 /* 52.95.243.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF400 /* 52.95.244.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF500 /* 52.95.245.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF600 /* 52.95.246.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF700 /* 52.95.247.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF800 /* 52.95.248.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FF900 /* 52.95.249.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFA00 /* 52.95.250.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFB00 /* 52.95.251.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFC00 /* 52.95.252.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFD00 /* 52.95.253.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x345FFE00 /* 52.95.254.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x34778000 /* 52.119.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x347C8000 /* 52.124.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34818000 /* 52.129.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34908000 /* 52.144.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34C00000 /* 52.192.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34C40000 /* 52.196.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x34C80000 /* 52.200.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x34D00000 /* 52.208.0.0/13 */, 13, NDPI_PROTOCOL_AMAZON },
  { 0x34D80000 /* 52.216.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34DA0000 /* 52.218.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DA8000 /* 52.218.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DB0000 /* 52.219.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DB8000 /* 52.219.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DC0000 /* 52.220.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x34DE0000 /* 52.222.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x34DE8000 /* 52.222.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36400000 /* 54.64.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36420000 /* 54.66.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36428000 /* 54.66.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36430000 /* 54.67.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36440000 /* 54.68.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36460000 /* 54.70.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36480000 /* 54.72.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36490000 /* 54.73.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x364A0000 /* 54.74.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x364C0000 /* 54.76.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x364E0000 /* 54.78.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x364F0000 /* 54.79.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x364F8000 /* 54.79.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36500000 /* 54.80.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36540000 /* 54.84.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36560000 /* 54.86.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36570000 /* 54.87.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36580000 /* 54.88.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36590000 /* 54.89.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x365A0000 /* 54.90.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x365C0000 /* 54.92.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365C8000 /* 54.92.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365D0000 /* 54.93.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x365E0000 /* 54.94.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365E8000 /* 54.94.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x365EC000 /* 54.94.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x365F0000 /* 54.95.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x365F8000 /* 54.95.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36900000 /* 54.144.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36940000 /* 54.148.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36960000 /* 54.150.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36970000 /* 54.151.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36978000 /* 54.151.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36980000 /* 54.152.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36990000 /* 54.153.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36998000 /* 54.153.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x369A0000 /* 54.154.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x369B0000 /* 54.155.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x369C0000 /* 54.156.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36A00000 /* 54.160.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x36A40000 /* 54.164.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36A60000 /* 54.166.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36A80000 /* 54.168.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36A90000 /* 54.169.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36A98000 /* 54.169.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36AA0000 /* 54.170.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36AB0000 /* 54.171.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36AC0000 /* 54.172.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36AE0000 /* 54.174.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36B00000 /* 54.176.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36B20000 /* 54.178.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B28000 /* 54.178.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B30000 /* 54.179.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B38000 /* 54.179.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36B3C000 /* 54.179.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36B60000 /* 54.182.0.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x36B60800 /* 54.182.8.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x36B61000 /* 54.182.16.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x36B68000 /* 54.182.128.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68200 /* 54.182.130.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68400 /* 54.182.132.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68600 /* 54.182.134.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68800 /* 54.182.136.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68A00 /* 54.182.138.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68C00 /* 54.182.140.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B68E00 /* 54.182.142.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69000 /* 54.182.144.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69200 /* 54.182.146.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69400 /* 54.182.148.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69600 /* 54.182.150.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69800 /* 54.182.152.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69A00 /* 54.182.154.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69C00 /* 54.182.156.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B69E00 /* 54.182.158.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A200 /* 54.182.162.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A400 /* 54.182.164.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A600 /* 54.182.166.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6A800 /* 54.182.168.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6AA00 /* 54.182.170.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6AE00 /* 54.182.174.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B000 /* 54.182.176.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B200 /* 54.182.178.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B400 /* 54.182.180.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B600 /* 54.182.182.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6B800 /* 54.182.184.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6BA00 /* 54.182.186.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6BF00 /* 54.182.191.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C000 /* 54.182.192.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C100 /* 54.182.193.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C200 /* 54.182.194.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C300 /* 54.182.195.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C400 /* 54.182.196.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C500 /* 54.182.197.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C600 /* 54.182.198.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C700 /* 54.182.199.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C800 /* 54.182.200.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6C900 /* 54.182.201.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CA00 /* 54.182.202.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CB00 /* 54.182.203.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CC00 /* 54.182.204.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CD00 /* 54.182.205.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CE00 /* 54.182.206.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6CF00 /* 54.182.207.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D100 /* 54.182.209.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D200 /* 54.182.210.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D300 /* 54.182.211.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D400 /* 54.182.212.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D500 /* 54.182.213.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D600 /* 54.182.214.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D700 /* 54.182.215.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D800 /* 54.182.216.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6D900 /* 54.182.217.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DA00 /* 54.182.218.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DB00 /* 54.182.219.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DC00 /* 54.182.220.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DD00 /* 54.182.221.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DE00 /* 54.182.222.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6DF00 /* 54.182.223.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E000 /* 54.182.224.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E200 /* 54.182.226.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E400 /* 54.182.228.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E600 /* 54.182.230.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E700 /* 54.182.231.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E800 /* 54.182.232.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6E900 /* 54.182.233.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EA00 /* 54.182.234.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EB00 /* 54.182.235.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EC00 /* 54.182.236.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6ED00 /* 54.182.237.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EE00 /* 54.182.238.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6EF00 /* 54.182.239.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F000 /* 54.182.240.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F200 /* 54.182.242.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F300 /* 54.182.243.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F400 /* 54.182.244.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F500 /* 54.182.245.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F600 /* 54.182.246.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6F800 /* 54.182.248.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FA00 /* 54.182.250.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FC00 /* 54.182.252.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FD00 /* 54.182.253.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FE00 /* 54.182.254.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B6FF00 /* 54.182.255.0/24 */, 24, NDPI_PROTOCOL_AMAZON },
  { 0x36B70000 /* 54.183.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B78000 /* 54.183.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36B80000 /* 54.184.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36BA0000 /* 54.186.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36BC0000 /* 54.188.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36BE0000 /* 54.190.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36BF0000 /* 54.191.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C00000 /* 54.192.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C10000 /* 54.193.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C18000 /* 54.193.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C20000 /* 54.194.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C30000 /* 54.195.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C40000 /* 54.196.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36C60000 /* 54.198.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36C70000 /* 54.199.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C78000 /* 54.199.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36C80000 /* 54.200.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36CA0000 /* 54.202.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36CC0000 /* 54.204.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36CE0000 /* 54.206.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36CE8000 /* 54.206.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36CF0000 /* 54.207.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36CF8000 /* 54.207.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D00000 /* 54.208.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36D20000 /* 54.210.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D30000 /* 54.211.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D40000 /* 54.212.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D50000 /* 54.213.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36D60000 /* 54.214.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D68000 /* 54.214.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D70000 /* 54.215.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36D78000 /* 54.215.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36D7C000 /* 54.215.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36D80000 /* 54.216.0.0/15 */, 15, NDPI_PROTOCOL_AMAZON },
  { 0x36DA0000 /* 54.218.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36DA8000 /* 54.218.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36DB0000 /* 54.219.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x36DB8000 /* 54.219.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36DBC000 /* 54.219.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36DC0000 /* 54.220.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36DD0000 /* 54.221.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0x36DF2000 /* 54.223.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x36DF4000 /* 54.223.64.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x36E00000 /* 54.224.0.0/12 */, 12, NDPI_PROTOCOL_AMAZON },
  { 0x36F00000 /* 54.240.0.0/12 */, 12, NDPI_PROTOCOL_AMAZON },
  { 0x3F5C0C00 /* 63.92.12.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x3FEE0C00 /* 63.238.12.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x3FEE1000 /* 63.238.16.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0x42074000 /* 66.7.64.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x43CA0000 /* 67.202.0.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0x4815C000 /* 72.21.192.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x482C2000 /* 72.44.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0x4B658000 /* 75.101.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x4F7D0000 /* 79.125.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x57EE5000 /* 87.238.80.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x607F0000 /* 96.127.0.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0x67040800 /* 103.4.8.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0x6708AC00 /* 103.8.172.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0x67F69400 /* 103.246.148.0/23*/, 23, NDPI_PROTOCOL_AMAZON },
  { 0x67F69600 /* 103.246.150.0/23*/, 23, NDPI_PROTOCOL_AMAZON },
  { 0x6B140000 /* 107.20.0.0/14 */, 14, NDPI_PROTOCOL_AMAZON },
  { 0x7AF8C000 /* 122.248.192.0/18*/, 18, NDPI_PROTOCOL_AMAZON },
  { 0xAC606000 /* 172.96.96.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0xAE810000 /* 174.129.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0xAF298000 /* 175.41.128.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xAF29C000 /* 175.41.192.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xB0204000 /* 176.32.64.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB0206000 /* 176.32.96.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB0206800 /* 176.32.104.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB0207000 /* 176.32.112.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB0207800 /* 176.32.120.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xB0207E00 /* 176.32.126.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0xB0220000 /* 176.34.0.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB0222000 /* 176.34.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB0224000 /* 176.34.64.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xB0228000 /* 176.34.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB1478000 /* 177.71.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB148F000 /* 177.72.240.0/21 */, 21, NDPI_PROTOCOL_AMAZON },
  { 0xB2EC0000 /* 178.236.0.0/20 */, 20, NDPI_PROTOCOL_AMAZON },
  { 0xB8480000 /* 184.72.0.0/18 */, 18, NDPI_PROTOCOL_AMAZON },
  { 0xB8484000 /* 184.72.64.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB8486000 /* 184.72.96.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xB8488000 /* 184.72.128.0/17 */, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB8490000 /* 184.73.0.0/16 */, 16, NDPI_PROTOCOL_AMAZON },
  { 0xB8A98000 /* 184.169.128.0/17*/, 17, NDPI_PROTOCOL_AMAZON },
  { 0xB9307800 /* 185.48.120.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xB98F1000 /* 185.143.16.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xC77FE800 /* 199.127.232.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xC7FFC000 /* 199.255.192.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xCB53DC00 /* 203.83.220.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xCCEC8000 /* 204.236.128.0/18*/, 18, NDPI_PROTOCOL_AMAZON },
  { 0xCCECC000 /* 204.236.192.0/18*/, 18, NDPI_PROTOCOL_AMAZON },
  { 0xCCF6A000 /* 204.246.160.0/19*/, 19, NDPI_PROTOCOL_AMAZON },
  { 0xCDFBC000 /* 205.251.192.0/18*/, 18, NDPI_PROTOCOL_AMAZON },
  { 0xCFABA000 /* 207.171.160.0/19*/, 19, NDPI_PROTOCOL_AMAZON },
  { 0xD02FF800 /* 208.47.248.0/23 */, 23, NDPI_PROTOCOL_AMAZON },
  { 0xD1C96000 /* 209.201.96.0/22 */, 22, NDPI_PROTOCOL_AMAZON },
  { 0xD8892000 /* 216.137.32.0/19 */, 19, NDPI_PROTOCOL_AMAZON },
  { 0xD8B6E000 /* 216.182.224.0/20*/, 20, NDPI_PROTOCOL_AMAZON },

  /*
    Netflix Inc. / Netflix Streaming Services Inc.
    origin AS2906, AS55095, AS40027
  */

  { 0x17F60000 /* 23.246.0.0/18 */, 18, NDPI_PROTOCOL_NETFLIX },
  { 0x254DB800 /* 37.77.184.0/21 */, 21, NDPI_PROTOCOL_NETFLIX },
  { 0x26487E00 /* 38.72.126.0/24 */, 24, NDPI_PROTOCOL_NETFLIX },
  { 0x2D390000 /* 45.57.0.0/17 */, 17, NDPI_PROTOCOL_NETFLIX },
  { 0x40788000 /* 64.120.128.0/17 */, 17, NDPI_PROTOCOL_NETFLIX },
  { 0x42C58000 /* 66.197.128.0/17 */, 17, NDPI_PROTOCOL_NETFLIX },
  { 0x4535E000 /* 69.53.224.0/19 */, 19, NDPI_PROTOCOL_NETFLIX },
  { 0x6CAF2000 /* 108.175.32.0/20 */, 20, NDPI_PROTOCOL_NETFLIX },
  { 0xB902DC00 /* 185.2.220.0/22 */, 22, NDPI_PROTOCOL_NETFLIX },
  { 0xB909BC00 /* 185.9.188.0/22 */, 22, NDPI_PROTOCOL_NETFLIX },
  { 0xC0AD4000 /* 192.173.64.0/18 */, 18, NDPI_PROTOCOL_NETFLIX },
  { 0xC6266000 /* 198.38.96.0/19 */, 19, NDPI_PROTOCOL_NETFLIX },
  { 0xC62D3000 /* 198.45.48.0/20 */, 20, NDPI_PROTOCOL_NETFLIX },
  { 0xD194D687 /* 209.148.214.135/21*/, 21, NDPI_PROTOCOL_NETFLIX },

  /*
    Cloudflare, Inc.
    origin AS13335, AS132892, AS203898, AS394536
  */

  { 0x321ff200 /* 50.31.242.0/23 */, 23, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x6715f400 /* 103.21.244.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x6716c800 /* 103.22.200.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x671f0400 /* 103.31.4.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x68100000 /* 104.16.0.0/12 */, 12, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x6CA2C000 /* 108.162.192.0/18*/, 18, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x83004800 /* 131.0.72.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8D654400 /* 141.101.68.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8D654500 /* 141.101.69.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d656000 /* 141.101.96.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d654000 /* 141.101.64.0/20 */, 20, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d655000 /* 141.101.80.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d655800 /* 141.101.88.0/19 */, 19, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d656800 /* 141.101.104.0/21*/, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d657000 /* 141.101.112.0/21*/, 21, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d657800 /* 141.101.120.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0x8d657c00 /* 141.101.124.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xbe5df000 /* 190.93.240.0/20 */, 20, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xA29E0000 /* 162.158.0.0/15 */, 15, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xA2FB5200 /* 162.251.82.0/24 */, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xAC400000 /* 172.64.0.0/13 */, 13, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xADF53000 /* 173.245.48.0/20 */, 20, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xB97A0000 /* 185.122.0.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726000 /* 188.114.96.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726400 /* 188.114.100.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726800 /* 188.114.104.0/24*/, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726900 /* 188.114.105.0/24*/, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726A00 /* 188.114.106.0/24*/, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726B00 /* 188.114.107.0/24*/, 24, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xBC726C00 /* 188.114.108.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xC6298000 /* 198.41.128.0/17 */, 17, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xc5eaf000 /* 197.234.240.0/22 */, 22, NDPI_PROTOCOL_CLOUDFLARE },
  { 0xC71B8000 /* 199.27.128.0/21 */, 21, NDPI_PROTOCOL_CLOUDFLARE },

  /*
    Microsoft 365 (Formerly known as Office 365)
  */
  { 0x0D6B0100 /* 13.107.1.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0300 /* 13.107.3.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0400 /* 13.107.4.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0500 /* 13.107.5.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0600 /* 13.107.6.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0700 /* 13.107.7.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0900 /* 13.107.9.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0C00 /* 13.107.12.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0D00 /* 13.107.13.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B0F00 /* 13.107.15.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },
  { 0x0D6B1000 /* 13.107.16.0 */, 24 , NDPI_PROTOCOL_MICROSOFT_365 },

  /*
    OCS GO (Orange Cinéma Séries)
  */

  { 0xB2F8D000 /* 178.248.208.0 */, 21, NDPI_PROTOCOL_OCS },


  /* Teamviewer
   AS43304, AS208187, AS208175
   router1.teamviewer.com... router16.teamviewer.com */
  { 0x25FCE044 /* 37.252.224.68 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE048 /* 37.252.224.72 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE04C /* 37.252.224.76 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE784 /* 37.252.231.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE788 /* 37.252.231.136 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE864 /* 37.252.232.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE868 /* 37.252.232.104 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCE86C /* 37.252.232.108 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF664 /* 37.252.246.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF668 /* 37.252.246.104 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF764 /* 37.252.247.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF768 /* 37.252.247.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF770 /* 37.252.247.112 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCF772 /* 37.252.247.114 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFD64 /* 37.252.253.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFD68 /* 37.252.253.104 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEA4 /* 37.252.254.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEA8 /* 37.252.254.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEB0 /* 37.252.254.176 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEB8 /* 37.252.254.184 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFEBC /* 37.252.254.188 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFC4 /* 37.252.255.196 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFC8 /* 37.252.255.200 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFD0 /* 37.252.255.208 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x25FCFFD2 /* 37.252.255.210 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x32751BD8 /* 50.117.27.216 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x44446410 /* 68.68.100.16 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x462634C8 /* 70.38.52.200 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006A4 /* 94.16.6.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006A8 /* 94.16.6.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006B0 /* 94.16.6.176 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x5E1006B2 /* 94.16.6.178 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x6CA399D8 /* 108.163.153.216 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05602 /* 158.176.86.2 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05604 /* 158.176.86.4 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05608 /* 158.176.86.8 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB0560A /* 158.176.86.10 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB0560C /* 158.176.86.12 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9EB05610 /* 158.176.86.16 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085884 /* 159.8.88.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085888 /* 159.8.88.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085890 /* 159.8.88.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F085892 /* 159.8.88.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5E2 /* 159.8.229.226 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5E4 /* 159.8.229.228 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5E8 /* 159.8.229.232 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F08E5F0 /* 159.8.229.240 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6C4 /* 159.122.182.196 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6C8 /* 159.122.182.200 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6D0 /* 159.122.182.208 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7AB6D2 /* 159.122.182.210 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0x9F7ABD20 /* 159.122.189.32 */, 27, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4362 /* 161.156.67.98 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4364 /* 161.156.67.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4368 /* 161.156.67.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA19C4370 /* 161.156.67.112 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA9334DE2 /* 169.51.77.226 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA9334DE4 /* 169.51.77.228 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xA9334DE8 /* 169.51.77.232 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xAE8E0AE0 /* 174.142.10.224 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xAE8EEBE8 /* 174.142.235.232 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xAE8EEC78 /* 174.142.236.120 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A84 /* 178.255.154.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A88 /* 178.255.154.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A90 /* 178.255.154.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9A92 /* 178.255.154.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BA4 /* 178.255.155.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BA8 /* 178.255.155.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BB0 /* 178.255.155.176 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BBC /* 178.255.155.188 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB2FF9BBE /* 178.255.155.190 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB86B0EA8 /* 184.107.14.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB9BC2000 /* 185.188.32.0 */, 22, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xB9F51C00 /* 185.245.28.0 */, 22, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBC414C84 /* 188.65.76.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBC414C88 /* 188.65.76.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBC414C8C /* 188.65.76.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC064 /* 188.172.192.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC068 /* 188.172.192.104 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC06C /* 188.172.192.108 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC684 /* 188.172.198.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC688 /* 188.172.198.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC690 /* 188.172.198.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC698 /* 188.172.198.152 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC69C /* 188.172.198.156 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACC69E /* 188.172.198.158 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB84 /* 188.172.219.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB88 /* 188.172.219.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB90 /* 188.172.219.144 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB9B /* 188.172.219.155 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB9C /* 188.172.219.156 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDB9E /* 188.172.219.158 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF64 /* 188.172.223.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF68 /* 188.172.223.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF70 /* 188.172.223.112 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACDF72 /* 188.172.223.114 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9A4 /* 188.172.233.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9A8 /* 188.172.233.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B0 /* 188.172.233.176 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B2 /* 188.172.233.178 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B4 /* 188.172.233.180 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACE9B8 /* 188.172.233.184 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB84 /* 188.172.235.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB88 /* 188.172.235.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB90 /* 188.172.235.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB98 /* 188.172.235.152 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB9C /* 188.172.235.156 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACEB9E /* 188.172.235.158 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF584 /* 188.172.245.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF588 /* 188.172.245.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF590 /* 188.172.245.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF592 /* 188.172.245.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6A4 /* 188.172.246.164 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6A8 /* 188.172.246.168 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6B0 /* 188.172.246.176 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6BA /* 188.172.246.186 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6BC /* 188.172.246.188 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACF6BE /* 188.172.246.190 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACFE84 /* 188.172.254.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACFE88 /* 188.172.254.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xBCACFE8C /* 188.172.254.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xC0AF7958 /* 192.175.121.88 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xC120E000 /* 193.32.224.0 */, 22, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xC13A6400 /* 193.58.100.0 */, 22, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A264 /* 213.227.162.100 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A268 /* 213.227.162.104 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A270 /* 213.227.162.112 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A27C /* 213.227.162.124 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A27E /* 213.227.162.126 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A384 /* 213.227.163.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A388 /* 213.227.163.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A390 /* 213.227.163.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A884 /* 213.227.168.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A888 /* 213.227.168.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3A890 /* 213.227.168.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3B984 /* 213.227.185.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3B988 /* 213.227.185.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3B98C /* 213.227.185.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA84 /* 213.227.186.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA88 /* 213.227.186.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA90 /* 213.227.186.144 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA98 /* 213.227.186.152 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD5E3BA9C /* 213.227.186.156 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920284 /* 217.146.2.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920288 /* 217.146.2.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920484 /* 217.146.4.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920488 /* 217.146.4.136 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920844 /* 217.146.8.68 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920848 /* 217.146.8.72 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD992084C /* 217.146.8.76 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D84 /* 217.146.13.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D88 /* 217.146.13.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D90 /* 217.146.13.144 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920D92 /* 217.146.13.146 */, 32, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920E84 /* 217.146.14.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920E88 /* 217.146.14.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9920E8C /* 217.146.14.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921584 /* 217.146.21.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921588 /* 217.146.21.136 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD992158C /* 217.146.21.140 */, 31, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921784 /* 217.146.23.132 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921788 /* 217.146.23.136 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD9921790 /* 217.146.23.144 */, 28, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD99217A0 /* 217.146.23.160 */, 29, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD99217A8 /* 217.146.23.168 */, 30, NDPI_PROTOCOL_TEAMVIEWER },
  { 0xD99217AC /* 217.146.23.172 */, 32, NDPI_PROTOCOL_TEAMVIEWER },

#if 0
  /*
    IFLIX services -by www.vizuamatix.com R&D team
  */
  { 0x344D0000 /* 52.77.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x34DC0000 /* 52.220.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x344A0000 /* 52.74.0.0 */, 16, NDPI_PROTOCOL_IFLIX },
  { 0x36E69F00 /* 54.230.159.0 */, 24, NDPI_PROTOCOL_IFLIX },
  { 0x36C09C50 /* 54.192.156.80  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x36FBB6A8 /* 54.251.182.168*/, 32, NDPI_PROTOCOL_IFLIX },
  { 0x36C09600 /* 54.192.150.0  */, 24, NDPI_PROTOCOL_IFLIX },
  { 0x344AC0F7 /* 52.74.192.247  */, 32, NDPI_PROTOCOL_IFLIX },
  { 0x0215E718 /* 2.21.231.24 */, 32, NDPI_PROTOCOL_IFLIX },
#endif

  /*
    Citrix GotoMeeting (AS16815, AS21866)
  */

  { 0xD873D000 /* 216.115.208.0 */, 20, NDPI_PROTOCOL_CITRIX },
  { 0xD8DB7000 /* 216.219.112.0 */, 20, NDPI_PROTOCOL_CITRIX },
  { 0xADC70000 /* 173.199.0.0   */, 18, NDPI_PROTOCOL_CITRIX },

  /*
    Cisco Webex LLC
    origin AS13445
  */

  { 0x0819C000 /* 8.25.192.0/24 */, 24, NDPI_PROTOCOL_WEBEX },
  { 0x3E6DC000 /* 62.109.192.0/18 */, 18, NDPI_PROTOCOL_WEBEX },
  { 0x40446000 /* 64.68.96.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0x4272A000 /* 66.114.160.0/20 */, 20, NDPI_PROTOCOL_WEBEX },
  { 0x42A32000 /* 66.163.32.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0x721DC000 /* 114.29.192.0/19 */, 19, NDPI_PROTOCOL_WEBEX },
  { 0xADF30000 /* 173.243.0.0/20 */, 20, NDPI_PROTOCOL_WEBEX },
  { 0xCFB6A000 /* 207.182.160.0/19*/, 19, NDPI_PROTOCOL_WEBEX },
  { 0xD0085100 /* 208.8.81.0/24 */, 24, NDPI_PROTOCOL_WEBEX },
  { 0xD1C5C000 /* 209.197.192.0/19*/, 19, NDPI_PROTOCOL_WEBEX },
  { 0xD204C000 /* 210.4.192.0/20 */, 20, NDPI_PROTOCOL_WEBEX },

  /*
    Viber Media S.à r.l.
    https://whois.arin.net/rest/nets;q=AWS-VIBER-MEDIA?showDetails=true&showARIN=false&showNonArinTopLevelNet=false&ext=netref2
  */

  { 0x0DE61550 /* 13.230.21.80/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x0D39B480 /* 13.57.180.128/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x012C30400 /* 18.195.4.0/23 */, 23, NDPI_PROTOCOL_VIBER },
  { 0x012C45500 /* 18.196.85.0/25 */, 25, NDPI_PROTOCOL_VIBER },
  { 0x022E8A340 /* 34.232.163.64/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x022F67200 /* 34.246.114.0/23 */, 23, NDPI_PROTOCOL_VIBER },
  { 0x3400FC00 /* 52.0.252.0/22 */, 22, NDPI_PROTOCOL_VIBER },
  { 0x3403A746 /* 52.3.167.70/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x34162CEB /* 52.22.44.235/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x34165F0F /* 52.22.95.15/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x3640BFF0 /* 54.64.191.240/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x3655545D /* 54.85.84.93/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x3655565D /* 54.85.86.93/32 */, 32, NDPI_PROTOCOL_VIBER },
  { 0x36A5FFD0 /* 54.165.255.208/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x36A5FFE0 /* 54.165.255.224/27 */, 27, NDPI_PROTOCOL_VIBER },
  { 0x36DBBFA0 /* 54.219.191.160/28 */, 28, NDPI_PROTOCOL_VIBER },
  { 0x36E8FB90 /* 54.232.251.144/28 */, 28, NDPI_PROTOCOL_VIBER },

  /*
    Apple Inc.
    origin AS714, AS6185
  */

  { 0x11000000 /* 17.0.0.0/8       */, 8 , NDPI_PROTOCOL_APPLE },
  { 0xC0233200 /* 192.35.50.0/24 */, 24, NDPI_PROTOCOL_APPLE },
  { 0xC6B71000 /* 198.183.16.0/24 */, 24, NDPI_PROTOCOL_APPLE },
  { 0xC6B71100 /* 198.183.17.0/24 */, 24, NDPI_PROTOCOL_APPLE },
  { 0xCDB4AF00 /* 205.180.175.0/24 */, 24, NDPI_PROTOCOL_APPLE },

  /*
    Dropbox, Inc.
    origin AS19679
  */

  { 0x2D3A4000 /* 45.58.64.0/20 */, 20, NDPI_PROTOCOL_DROPBOX },
  { 0x6CA0A000 /* 108.160.160.0/20 */, 20, NDPI_PROTOCOL_DROPBOX },
  { 0xA27D0000 /* 162.125.0.0/16 */, 16, NDPI_PROTOCOL_DROPBOX },
  { 0xB92D0800 /* 185.45.8.0/22 */, 22, NDPI_PROTOCOL_DROPBOX },
  { 0xC72FD800 /* 199.47.216.0/22 */, 22, NDPI_PROTOCOL_DROPBOX },

  /*
    Skype (Microsoft CDN)
  */
  { 0x9D388740 /* 157.56.135.64 */, 26, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x9D38B900 /* 157.56.185.0 */, 26, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x9D383400 /* 157.56.52.0 */, 26, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x9D383580 /* 157.56.53.128 */, 25, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x9D38C600 /* 157.56.198.0 */, 26, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x9D3C0000 /* 157.60.0.0 */, 16, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x9D360000 /* 157.54.0.0 */, 15, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x0D6B0380 /* 13.107.3.128 */, 32, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x0D6B0381 /* 13.107.3.129 */, 32, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x6FDD4000 /* 111.221.64.0 */, 18, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x5BBED800 /* 91.190.216.0 */, 21, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x5BBEDA00 /* 91.190.218.0 */, 24, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x287F816D /* 40.126.129.109 */, 32, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x4237DF00 /* 65.55.223.0 */, 26, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x17600000 /* 23.96.0.0 */, 13, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x34724A05 /* 52.114.74.5 */, 32, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x14B40000 /* 20.180.0.0 */, 14, NDPI_PROTOCOL_SKYPE_TEAMS },
  { 0x14B80000 /* 20.184.0.0 */, 13, NDPI_PROTOCOL_SKYPE_TEAMS },

  /*
    Blizzard Entertainment, Inc
    origin AS57976
  */

  { 0x052AA000 /* 5.42.160.0/19 */, 19, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81DE00 /* 12.129.222.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81E400 /* 12.129.228.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81EC00 /* 12.129.236.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C81FE00 /* 12.129.254.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x0C82F400 /* 12.130.244.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x18690000 /* 24.105.0.0/18 */, 18, NDPI_PROTOCOL_STARCRAFT },
  { 0x25F40000 /* 37.244.0.0/18 */, 18, NDPI_PROTOCOL_STARCRAFT },
  { 0x3B992800 /* 59.153.40.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x3E73F400 /* 62.115.244.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x50EFD000 /* 80.239.208.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0x67047200 /* 103.4.114.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x67C62000 /* 103.198.32.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },
  { 0x89DD4000 /* 137.221.64.0/18 */, 18, NDPI_PROTOCOL_STARCRAFT },
  { 0xB93C7000 /* 185.60.112.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0xC30CF400 /* 195.12.244.0/22 */, 22, NDPI_PROTOCOL_STARCRAFT },
  { 0xC76C2000 /* 199.108.32.0/20 */, 20, NDPI_PROTOCOL_STARCRAFT },
  { 0xC76C3000 /* 199.108.48.0/20 */, 20, NDPI_PROTOCOL_STARCRAFT },
  { 0xCA094200 /* 202.9.66.0/23 */, 23, NDPI_PROTOCOL_STARCRAFT },

  /*
    Google Inc. / Google Switzerland GmbH / Google Ireland Limited
    origin AS15169, AS36384, AS41264, AS43515, AS36039, AS36040, AS36492
  */
  { 0x08063000 /* 8.6.48.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x08080400 /* 8.8.4.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x08080800 /* 8.8.8.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x080FCA00 /* 8.15.202.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x0822D000 /* 8.34.208.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x0822D800 /* 8.34.216.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x0823C000 /* 8.35.192.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x0823C800 /* 8.35.200.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x17EC3000 /* 23.236.48.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x17FB8000 /* 23.251.128.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x23B80000 /* 35.184.0.0/13 */, 13, NDPI_PROTOCOL_GOOGLE },
  { 0x2D79E400 /* 45.121.228.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x2D79E500 /* 45.121.229.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x2D79E600 /* 45.121.230.0/23 */, 23, NDPI_PROTOCOL_GOOGLE },
  { 0x2E1CF700 /* 46.28.247.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x4009E000 /* 64.9.224.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x400F7000 /* 64.15.112.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x40E9A000 /* 64.233.160.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x42660000 /* 66.102.0.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x42F94000 /* 66.249.64.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x46208000 /* 70.32.128.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x480EC000 /* 72.14.192.0/18 */, 18, NDPI_PROTOCOL_GOOGLE },
  { 0x4A721800 /* 74.114.24.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x4A7D0000 /* 74.125.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0x59CFE000 /* 89.207.224.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0x673E4000 /* 103.62.64.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x673E4100 /* 103.62.65.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0x673E4200 /* 103.62.66.0/23 */, 23, NDPI_PROTOCOL_GOOGLE },
  { 0x68840000 /* 104.132.0.0/14 */, 14, NDPI_PROTOCOL_GOOGLE },
  { 0x689A0000 /* 104.154.0.0/15 */, 15, NDPI_PROTOCOL_GOOGLE },
  { 0x68C40000 /* 104.196.0.0/14 */, 14, NDPI_PROTOCOL_GOOGLE },
  { 0x68EDA000 /* 104.237.160.0/19*/, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x6BA7A000 /* 107.167.160.0/19*/, 19, NDPI_PROTOCOL_GOOGLE },
  { 0x6BB2C000 /* 107.178.192.0/18*/, 18, NDPI_PROTOCOL_GOOGLE },
  { 0x6C3B5000 /* 108.59.80.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0x6CAAC000 /* 108.170.192.0/18*/, 18, NDPI_PROTOCOL_GOOGLE },
  { 0x6CB10000 /* 108.177.0.0/17 */, 17, NDPI_PROTOCOL_GOOGLE },
  { 0x71C56800 /* 113.197.104.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0x82D30000 /* 130.211.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0x8EFA0000 /* 142.250.0.0/15 */, 15, NDPI_PROTOCOL_GOOGLE },
  { 0x92940000 /* 146.148.0.0/17 */, 17, NDPI_PROTOCOL_GOOGLE },
  { 0xA2D89400 /* 162.216.148.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xA2DEB000 /* 162.222.176.0/21*/, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xAC660800 /* 172.102.8.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xAC6E2000 /* 172.110.32.0/21 */, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xACD90000 /* 172.217.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0xACFD0000 /* 172.253.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0xADC20000 /* 173.194.0.0/16 */, 16, NDPI_PROTOCOL_GOOGLE },
  { 0xADFF7000 /* 173.255.112.0/20*/, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xB9191C00 /* 185.25.28.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xB9969400 /* 185.150.148.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC068A000 /* 192.104.160.0/23*/, 23, NDPI_PROTOCOL_GOOGLE },
  { 0xC0771C00 /* 192.119.28.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC09E1C00 /* 192.158.28.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC0B20000 /* 192.178.0.0/15 */, 15, NDPI_PROTOCOL_GOOGLE },
  { 0xC1210400 /* 193.33.4.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC1210500 /* 193.33.5.0/24 */, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC1C8DE00 /* 193.200.222.0/24*/, 24, NDPI_PROTOCOL_GOOGLE },
  { 0xC27A5000 /* 194.122.80.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC7C07000 /* 199.192.112.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xC7DFE800 /* 199.223.232.0/21*/, 21, NDPI_PROTOCOL_GOOGLE },
  { 0xCFDFA000 /* 207.223.160.0/20*/, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xD0419800 /* 208.65.152.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },
  { 0xD075E000 /* 208.117.224.0/19*/, 19, NDPI_PROTOCOL_GOOGLE },
  { 0xD1558000 /* 209.85.128.0/17 */, 17, NDPI_PROTOCOL_GOOGLE },
  { 0xD16BB000 /* 209.107.176.0/20*/, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xD83AC000 /* 216.58.192.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0xD8495000 /* 216.73.80.0/20 */, 20, NDPI_PROTOCOL_GOOGLE },
  { 0xD8EF2000 /* 216.239.32.0/19 */, 19, NDPI_PROTOCOL_GOOGLE },
  { 0xD8FCDC00 /* 216.252.220.0/22 */, 22, NDPI_PROTOCOL_GOOGLE },

  /*
    Canonical Ltd (Ubuntu)
    origin AS41231z
  */

  { 0x5BBD5800 /* 91.189.88.0/21 */,   21, NDPI_PROTOCOL_UBUNTUONE },
  { 0xA2D52000 /* 162.213.32.0/22 */,  22, NDPI_PROTOCOL_UBUNTUONE },
  { 0xB97DBC00 /* 185.125.188.0/22 */, 22, NDPI_PROTOCOL_UBUNTUONE },

  /*
    Telegram Messenger LLP
    origin: AS62041, AS62014, AS59930
  */

  { 0x5B6C0400 /* 91.108.4.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C0800 /* 91.108.8.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C0C00 /* 91.108.12.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C1000 /* 91.108.16.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C1400 /* 91.108.20.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x5B6C3800 /* 91.108.56.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM },
  { 0x959AA000 /* 149.154.160.0/20*/, 20, NDPI_PROTOCOL_TELEGRAM },

  /*
    BitTorrent
  */

  { 0xB9381424 /* 185.56.20.36/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xC0DEED0A /* 192.222.237.10/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x4DDEAE14 /* 77.222.174.20/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x25779CBD /* 37.119.156.189/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x05277C26 /* 5.39.124.38/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0x4FC0AB43 /* 79.192.171.67/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xAC100010 /* 172.16.0.16/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xB2A4F550 /* 178.164.245.80/32 */, 32, NDPI_PROTOCOL_BITTORRENT },
  { 0xAE597B3E /* 174.89.123.62/32 */, 32, NDPI_PROTOCOL_BITTORRENT },

  /*
    Ethereum
    curl -s https://raw.githubusercontent.com/ethereum/go-ethereum/master/params/bootnodes.go | grep -v '^/' | grep ':' | cut -d '@' -f 2 | cut -d ':' -f 1
  */
  { 0x128A6C43 /* 18.138.108.67/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x03D12D4F /* 3.209.45.79/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x22FF1771 /* 34.255.23.113/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x239EF497 /* 35.158.244.151/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34BBCF1B /* 52.187.207.27/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0xBFEAA2C6 /* 191.234.162.198/32*/, 32, NDPI_PROTOCOL_MINING },
  { 0x34E7A56C /* 52.231.165.108/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x682AD919 /* 104.42.217.25/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x050153E2 /* 5.1.83.226/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34B0070A /* 52.176.7.10/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34B0644D /* 52.176.100.77/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34E8F398 /* 52.232.243.152/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0xC051D0DF /* 192.81.208.223/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34A92A65 /* 52.169.42.101/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34039EB8 /* 52.3.158.184/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x9F591CD3 /* 159.89.28.211/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x338D4E35 /* 51.141.78.53/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x0D5D3689 /* 13.93.54.137/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x5EED3672 /* 94.237.54.114/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x34409B93 /* 52.64.155.147/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0xD5BA1052 /* 213.186.16.82/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x343888C8 /* 52.56.136.200/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x23B1E2A8 /* 35.177.226.168/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x287603DF /* 40.118.3.223/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x287603DF /* 40.118.3.223/32 */, 32, NDPI_PROTOCOL_MINING },
  { 0x287603DF /* 40.118.3.223/32 */, 32, NDPI_PROTOCOL_MINING },

  /*
    Tor
    https://torstatus.rueckgr.at/ip_list_all.php/Tor_ip_list_ALL.csv
    From 02.03.2021

    Use utils/toripaddr2list.py to convert them
  */

  { 0x021AF7B0 /* 2.26.247.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x021F74E1 /* 2.31.116.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x022268A9 /* 2.34.104.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0238F1F3 /* 2.56.241.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02CB293F /* 2.203.41.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02CB95BD /* 2.203.149.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02CDC156 /* 2.205.193.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E5C9C5 /* 2.229.201.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E6381E /* 2.230.56.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E6C1C5 /* 2.230.193.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E6C1C5 /* 2.230.193.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E95BB0 /* 2.233.91.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x02E97097 /* 2.233.112.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x030ABEC2 /* 3.10.190.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0313F63E /* 3.19.246.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0314B3F9 /* 3.20.179.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x032479C1 /* 3.36.121.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x035CE1DC /* 3.92.225.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0379A741 /* 3.121.167.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x037D13E9 /* 3.125.19.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0381EA03 /* 3.129.234.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x03E173EE /* 3.225.115.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x03E33AC5 /* 3.227.58.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05013834 /* 5.1.56.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05023698 /* 5.2.54.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024315 /* 5.2.67.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0502450D /* 5.2.69.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0502450E /* 5.2.69.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0502450F /* 5.2.69.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024515 /* 5.2.69.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024516 /* 5.2.69.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024517 /* 5.2.69.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050248F3 /* 5.2.72.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0502493A /* 5.2.73.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024942 /* 5.2.73.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024974 /* 5.2.73.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024A89 /* 5.2.74.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024D16 /* 5.2.77.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024D92 /* 5.2.77.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024E45 /* 5.2.78.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024E7E /* 5.2.78.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024F91 /* 5.2.79.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05024FB3 /* 5.2.79.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05091202 /* 5.9.18.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050915F0 /* 5.9.21.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05091DB7 /* 5.9.29.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050925A2 /* 5.9.37.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050925D6 /* 5.9.37.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509380C /* 5.9.56.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093C04 /* 5.9.60.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05093DCF /* 5.9.61.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050950D9 /* 5.9.80.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509524C /* 5.9.82.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0509622B /* 5.9.98.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05097812 /* 5.9.120.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050978FA /* 5.9.120.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050979CF /* 5.9.121.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05097C63 /* 5.9.124.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050989A7 /* 5.9.137.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05098EEE /* 5.9.142.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099C11 /* 5.9.156.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E4B /* 5.9.158.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E4B /* 5.9.158.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E7B /* 5.9.158.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E8F /* 5.9.158.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050B4D2D /* 5.11.77.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x050D8E24 /* 5.13.142.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0513B825 /* 5.19.184.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B71D /* 5.34.183.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274802 /* 5.39.72.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274814 /* 5.39.72.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274D0A /* 5.39.77.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05274E28 /* 5.39.78.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275087 /* 5.39.80.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275087 /* 5.39.80.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052756CB /* 5.39.86.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527577C /* 5.39.87.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05275F5F /* 5.39.95.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527B9A4 /* 5.39.185.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0527D8A0 /* 5.39.216.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052A8173 /* 5.42.129.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052C65BE /* 5.44.101.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x052D6F95 /* 5.45.111.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0538C6E1 /* 5.56.198.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0539F0F4 /* 5.57.240.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x053BE333 /* 5.59.227.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x053D2983 /* 5.61.41.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054F4F85 /* 5.79.79.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054F5535 /* 5.79.85.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x054F6D30 /* 5.79.109.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05532D83 /* 5.83.45.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0564799A /* 5.100.121.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05653316 /* 5.101.51.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05684EC4 /* 5.104.78.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x058426E7 /* 5.132.38.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05856DDE /* 5.133.109.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0585B1D1 /* 5.133.177.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587001A /* 5.135.0.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05877322 /* 5.135.115.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587992C /* 5.135.153.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05879EA2 /* 5.135.158.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A231 /* 5.135.162.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B026 /* 5.135.176.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B16B /* 5.135.177.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B5D5 /* 5.135.181.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BB05 /* 5.135.187.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BDA8 /* 5.135.189.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0587C70D /* 5.135.199.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x058F555D /* 5.143.85.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x059218C7 /* 5.146.24.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x059299B7 /* 5.146.153.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05937923 /* 5.147.121.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0593F89E /* 5.147.248.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0596DD89 /* 5.150.221.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x059AAEF1 /* 5.154.174.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x059F1F5F /* 5.159.31.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05A6E1CA /* 5.166.225.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05AC828B /* 5.172.130.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05B4190B /* 5.180.25.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05B53333 /* 5.181.51.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05B53334 /* 5.181.51.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05B59C75 /* 5.181.156.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05B6D377 /* 5.182.211.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BC04A4 /* 5.188.4.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BC85C8 /* 5.188.133.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD81DE /* 5.189.129.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8E76 /* 5.189.142.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD94E1 /* 5.189.148.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD9A51 /* 5.189.154.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD9B27 /* 5.189.155.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDA432 /* 5.189.164.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDA4E6 /* 5.189.164.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDA9BE /* 5.189.169.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDAA03 /* 5.189.170.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05BDC976 /* 5.189.201.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C41740 /* 5.196.23.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C41D08 /* 5.196.29.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C43A60 /* 5.196.58.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C44489 /* 5.196.68.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C446E2 /* 5.196.70.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C44718 /* 5.196.71.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C449B8 /* 5.196.73.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C782BC /* 5.199.130.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C785C1 /* 5.199.133.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78EEC /* 5.199.142.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05C81590 /* 5.200.21.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05CEE040 /* 5.206.224.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05E644B3 /* 5.230.68.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05E79E0B /* 5.231.158.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05F96B03 /* 5.249.107.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FC980A /* 5.252.152.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FCB348 /* 5.252.179.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FCC57A /* 5.252.197.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FCC5A4 /* 5.252.197.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FE426F /* 5.254.66.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x05FF601D /* 5.255.96.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x080FB3B6 /* 8.15.179.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x081A158F /* 8.26.21.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x082A4C44 /* 8.42.76.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x08D05AD5 /* 8.208.90.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x08D14F7D /* 8.209.79.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x08D15DA0 /* 8.209.93.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x08D15E55 /* 8.209.94.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x08D290AA /* 8.210.144.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0CEB97C8 /* 12.235.151.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D30111F /* 13.48.17.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D312CB8 /* 13.49.44.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D42C113 /* 13.66.193.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0D7C1282 /* 13.124.18.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0DD320A5 /* 13.211.32.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0DE83666 /* 13.232.54.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0EC8B162 /* 14.200.177.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x0FBC6B6B /* 15.188.107.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12125211 /* 18.18.82.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1212F811 /* 18.18.248.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x121BC5FC /* 18.27.197.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x121BC5FC /* 18.27.197.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12859E42 /* 18.133.158.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12BCDA78 /* 18.188.218.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12C52376 /* 18.197.35.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12CC1475 /* 18.204.20.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12CDA3B7 /* 18.205.163.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12DC1473 /* 18.220.20.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12DE816E /* 18.222.129.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x12DFA4F5 /* 18.223.164.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x14306806 /* 20.48.104.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1751425A /* 23.81.66.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C13E6 /* 23.92.19.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1447 /* 23.92.20.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1DCC /* 23.92.29.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1FFA /* 23.92.31.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175E6B11 /* 23.94.107.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x175FA692 /* 23.95.166.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1768516A /* 23.104.81.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1769A375 /* 23.105.163.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x176C314F /* 23.108.49.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x176C4F6E /* 23.108.79.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1778B673 /* 23.120.182.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1778B673 /* 23.120.182.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1778B67B /* 23.120.182.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1778B67C /* 23.120.182.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1778B67D /* 23.120.182.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140C8 /* 23.129.64.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140C9 /* 23.129.64.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140CA /* 23.129.64.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140CB /* 23.129.64.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140CC /* 23.129.64.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140CD /* 23.129.64.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140CE /* 23.129.64.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140CF /* 23.129.64.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D0 /* 23.129.64.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D1 /* 23.129.64.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D2 /* 23.129.64.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D3 /* 23.129.64.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D4 /* 23.129.64.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D5 /* 23.129.64.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D6 /* 23.129.64.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D7 /* 23.129.64.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D8 /* 23.129.64.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140D9 /* 23.129.64.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140DC /* 23.129.64.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140DD /* 23.129.64.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140DE /* 23.129.64.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140DF /* 23.129.64.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E0 /* 23.129.64.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E1 /* 23.129.64.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E2 /* 23.129.64.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E3 /* 23.129.64.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E4 /* 23.129.64.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E5 /* 23.129.64.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E6 /* 23.129.64.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E7 /* 23.129.64.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E8 /* 23.129.64.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140E9 /* 23.129.64.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140EA /* 23.129.64.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140EB /* 23.129.64.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140EC /* 23.129.64.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140ED /* 23.129.64.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178140FD /* 23.129.64.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x178DF0CE /* 23.141.240.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17E3C767 /* 23.227.199.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17ED228A /* 23.237.34.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17ED89F4 /* 23.237.137.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EDB27A /* 23.237.178.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF095C /* 23.239.9.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF0A90 /* 23.239.10.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF11B3 /* 23.239.17.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF16F8 /* 23.239.22.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF6016 /* 23.239.96.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF7165 /* 23.239.113.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FD392A /* 23.253.57.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEE188 /* 23.254.225.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18036EE0 /* 24.3.110.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18036FD7 /* 24.3.111.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18050123 /* 24.5.1.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1812C27C /* 24.18.194.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18314378 /* 24.49.67.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1834F299 /* 24.52.242.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x183B2D9D /* 24.59.45.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x183D0ABF /* 24.61.10.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x184744C8 /* 24.71.68.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18501AC8 /* 24.80.26.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1854DDAA /* 24.84.221.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x187C0097 /* 24.124.0.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1882E163 /* 24.130.225.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1884D72E /* 24.132.215.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18865C89 /* 24.134.92.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x188676F5 /* 24.134.118.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1886EA11 /* 24.134.234.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1886EA11 /* 24.134.234.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1896CCE1 /* 24.150.204.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18970133 /* 24.151.1.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x189AB9A9 /* 24.154.185.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18BAB0BD /* 24.186.176.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18BEC2BA /* 24.190.194.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18D13EBB /* 24.209.62.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18D1BF80 /* 24.209.191.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18D8AC47 /* 24.216.172.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18E1C3EA /* 24.225.195.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x18FD6F62 /* 24.253.111.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1B02BA91 /* 27.2.186.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1B6F5428 /* 27.111.84.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1B7A3B56 /* 27.122.59.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1B7A3B64 /* 27.122.59.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1BFF4BC6 /* 27.255.75.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1BFF4D45 /* 27.255.77.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F03E338 /* 31.3.227.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F064647 /* 31.6.70.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F073BE2 /* 31.7.59.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F073DBA /* 31.7.61.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F073DBB /* 31.7.61.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F073DBC /* 31.7.61.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F073DBD /* 31.7.61.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F073DBE /* 31.7.61.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0DBC2B /* 31.13.188.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0DC3F8 /* 31.13.195.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0E28AF /* 31.14.40.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F10D69A /* 31.16.214.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F128C1A /* 31.18.140.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1C0C8E /* 31.28.12.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1CA8AE /* 31.28.168.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1DF8E9 /* 31.29.248.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F49DE /* 31.31.73.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4A2F /* 31.31.74.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4DB0 /* 31.31.77.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F33F348 /* 31.51.243.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F34EF97 /* 31.52.239.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F830211 /* 31.131.2.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F830213 /* 31.131.2.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1F8304AB /* 31.131.4.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAB9AD4 /* 31.171.154.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB31A2B /* 31.179.26.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB8C698 /* 31.184.198.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB8C6B7 /* 31.184.198.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB8DAB4 /* 31.184.218.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FBBC2D2 /* 31.187.194.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC18B0E /* 31.193.139.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC90E33 /* 31.201.14.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC9101E /* 31.201.16.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCF5931 /* 31.207.89.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCF594C /* 31.207.89.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD043F8 /* 31.208.67.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD0CC21 /* 31.208.204.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD69018 /* 31.214.144.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD690AF /* 31.214.144.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC0385 /* 31.220.3.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC0395 /* 31.220.3.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC3436 /* 31.220.52.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x225B58CB /* 34.91.88.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x22D1D6D3 /* 34.209.214.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x22DD4C96 /* 34.221.76.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23485B53 /* 35.72.91.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23AA4DE0 /* 35.170.77.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x23B647D1 /* 35.182.71.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2437E791 /* 36.55.231.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x24E1ADD8 /* 36.225.173.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2509E7C3 /* 37.9.231.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x250BE3B3 /* 37.11.227.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x250BE3B3 /* 37.11.227.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x250EEC2B /* 37.14.236.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2518913D /* 37.24.145.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x251C9A44 /* 37.28.154.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25236BEE /* 37.35.107.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25304971 /* 37.48.73.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253054C1 /* 37.48.84.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2530782F /* 37.48.120.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253078C4 /* 37.48.120.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B253B /* 37.59.37.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B4CFC /* 37.59.76.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B4CFD /* 37.59.76.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B4CFE /* 37.59.76.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253B4CFF /* 37.59.76.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x253DCCF8 /* 37.61.204.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2561B974 /* 37.97.185.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2561FDB0 /* 37.97.253.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x256E4215 /* 37.110.66.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x256E7968 /* 37.110.121.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25771541 /* 37.119.21.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x257760F3 /* 37.119.96.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578A795 /* 37.120.167.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578A7C8 /* 37.120.167.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578A9FC /* 37.120.169.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ABBC /* 37.120.171.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ABE6 /* 37.120.171.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ACF2 /* 37.120.172.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ADAD /* 37.120.173.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ADAD /* 37.120.173.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578AEF9 /* 37.120.174.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578B3A9 /* 37.120.179.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578B824 /* 37.120.184.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578B85E /* 37.120.184.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578BB68 /* 37.120.187.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578BD0A /* 37.120.189.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578BE06 /* 37.120.190.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578BE06 /* 37.120.190.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578BEA0 /* 37.120.190.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578BEA0 /* 37.120.190.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2578EE0B /* 37.120.238.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x257AD0DC /* 37.122.208.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x257BAD47 /* 37.123.173.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258ABB73 /* 37.138.187.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258AE43F /* 37.138.228.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258AE43F /* 37.138.228.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258B0868 /* 37.139.8.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258B16B4 /* 37.139.22.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x258F7609 /* 37.143.118.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2591409F /* 37.145.64.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2592236F /* 37.146.35.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2594C42E /* 37.148.196.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2598E704 /* 37.152.231.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2599010A /* 37.153.1.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259910AA /* 37.153.16.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC353 /* 37.157.195.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC357 /* 37.157.195.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFD23 /* 37.157.253.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFE25 /* 37.157.254.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFE71 /* 37.157.254.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFE72 /* 37.157.254.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFF23 /* 37.157.255.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFF72 /* 37.157.255.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x259DFF76 /* 37.157.255.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB011D /* 37.187.1.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB024C /* 37.187.2.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB02E6 /* 37.187.2.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB102B /* 37.187.16.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB10AF /* 37.187.16.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1143 /* 37.187.17.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1502 /* 37.187.21.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1514 /* 37.187.21.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1531 /* 37.187.21.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1599 /* 37.187.21.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB17E8 /* 37.187.23.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6054 /* 37.187.96.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB60B7 /* 37.187.96.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6223 /* 37.187.98.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB62B9 /* 37.187.98.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB64D6 /* 37.187.100.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB64D6 /* 37.187.100.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB666C /* 37.187.102.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6736 /* 37.187.103.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB686F /* 37.187.104.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6968 /* 37.187.105.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6B5B /* 37.187.107.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB757B /* 37.187.117.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7622 /* 37.187.118.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7A08 /* 37.187.122.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7A65 /* 37.187.122.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBA299 /* 37.187.162.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB349 /* 37.187.179.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBC446 /* 37.187.196.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBCD72 /* 37.187.205.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC093 /* 37.191.192.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC093 /* 37.191.192.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC1A6 /* 37.191.193.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC1A6 /* 37.191.193.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC1ED /* 37.191.193.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC1ED /* 37.191.193.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC31C /* 37.191.195.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC31C /* 37.191.195.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC46B /* 37.191.196.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC46B /* 37.191.196.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC75F /* 37.191.199.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC75F /* 37.191.199.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC777 /* 37.191.199.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFC777 /* 37.191.199.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFCEC5 /* 37.191.206.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFCEC5 /* 37.191.206.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25BFF7CC /* 37.191.247.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25C863FB /* 37.200.99.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25C989CF /* 37.201.137.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CC14BE /* 37.204.20.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CC14BE /* 37.204.20.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CC8C05 /* 37.204.140.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD08BF /* 37.205.8.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD0983 /* 37.205.9.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF11C /* 37.218.241.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF1CB /* 37.218.241.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF21A /* 37.218.242.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF254 /* 37.218.242.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF291 /* 37.218.242.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DAF2D9 /* 37.218.242.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DC24F0 /* 37.220.36.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC12C /* 37.221.193.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC313 /* 37.221.195.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC317 /* 37.221.195.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC41F /* 37.221.196.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC667 /* 37.221.198.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC672 /* 37.221.198.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC672 /* 37.221.198.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E45EDB /* 37.228.94.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E48102 /* 37.228.129.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E48105 /* 37.228.129.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E4811D /* 37.228.129.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E48135 /* 37.228.129.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25E4813E /* 37.228.129.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB30F7 /* 37.235.48.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB318A /* 37.235.49.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25F7318B /* 37.247.49.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25F73728 /* 37.247.55.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCB957 /* 37.252.185.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCB9E5 /* 37.252.185.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBB6F /* 37.252.187.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBB81 /* 37.252.187.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBC10 /* 37.252.188.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBC65 /* 37.252.188.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBC8C /* 37.252.188.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBCB4 /* 37.252.188.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBD11 /* 37.252.189.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBEB0 /* 37.252.190.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBF29 /* 37.252.191.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBFBE /* 37.252.191.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2616110D /* 38.22.17.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2627C01E /* 38.39.192.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2627C04E /* 38.39.192.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2644254D /* 38.68.37.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26448705 /* 38.68.135.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26661429 /* 38.102.20.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x268F42AA /* 38.143.66.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C836 /* 38.145.200.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C838 /* 38.145.200.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C83D /* 38.145.200.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C83E /* 38.145.200.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C841 /* 38.145.200.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C842 /* 38.145.200.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C843 /* 38.145.200.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C844 /* 38.145.200.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C86A /* 38.145.200.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C86B /* 38.145.200.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C86C /* 38.145.200.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C86D /* 38.145.200.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C86E /* 38.145.200.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C86F /* 38.145.200.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C870 /* 38.145.200.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C914 /* 38.145.201.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C918 /* 38.145.201.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C919 /* 38.145.201.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C91A /* 38.145.201.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2691C91B /* 38.145.201.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26937AFA /* 38.147.122.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26937AFB /* 38.147.122.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26937AFC /* 38.147.122.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26937AFD /* 38.147.122.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x26937AFE /* 38.147.122.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x284494D9 /* 40.68.148.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x28716D0E /* 40.113.109.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x28739EA0 /* 40.115.158.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x287AA530 /* 40.122.165.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x29D04709 /* 41.208.71.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7E17A2 /* 42.126.23.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BE77234 /* 43.231.114.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BFB9F90 /* 43.251.159.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BFBAA0D /* 43.251.170.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2BFC250E /* 43.252.37.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2CE23569 /* 44.226.53.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2CF22157 /* 44.242.33.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D090DEB /* 45.9.13.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D09941F /* 45.9.148.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D099426 /* 45.9.148.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D099429 /* 45.9.148.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D09942B /* 45.9.148.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D09942F /* 45.9.148.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D09943E /* 45.9.148.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0994CD /* 45.9.148.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D09FA87 /* 45.9.250.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0A9F84 /* 45.10.159.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0CCD6C /* 45.12.205.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0CCD78 /* 45.12.205.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0CCE6A /* 45.12.206.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0D68B9 /* 45.13.104.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0E9577 /* 45.14.149.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0E96B6 /* 45.14.150.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0E9706 /* 45.14.151.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0F1052 /* 45.15.16.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D0F11A4 /* 45.15.17.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D1BCBC2 /* 45.27.203.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D1BE93F /* 45.27.233.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20807D /* 45.32.128.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D208A31 /* 45.32.138.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D20F01F /* 45.32.240.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D210C9E /* 45.33.12.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D2111AA /* 45.33.17.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D211BD2 /* 45.33.27.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D211D4C /* 45.33.29.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D212AEE /* 45.33.42.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D212CDE /* 45.33.44.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D212E65 /* 45.33.46.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D212FDA /* 45.33.47.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D213347 /* 45.33.51.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D2140CE /* 45.33.64.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D214DDA /* 45.33.77.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D217278 /* 45.33.114.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D217C62 /* 45.33.124.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D23219E /* 45.35.33.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D23689F /* 45.35.104.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D23C00E /* 45.35.192.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D23C022 /* 45.35.192.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D23C02E /* 45.35.192.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D23C2A2 /* 45.35.194.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3722FC /* 45.55.34.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D378370 /* 45.55.131.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37C0DE /* 45.55.192.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D37F0E1 /* 45.55.240.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D384494 /* 45.56.68.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D384DE6 /* 45.56.77.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3857FC /* 45.56.87.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3859B6 /* 45.56.89.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D385AB0 /* 45.56.90.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D385FC7 /* 45.56.95.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3867F9 /* 45.56.103.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3D3393 /* 45.61.51.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EE2AA /* 45.62.226.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EEB19 /* 45.62.235.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EEB70 /* 45.62.235.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EEF6D /* 45.62.239.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF44E /* 45.62.244.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF49A /* 45.62.244.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF6BA /* 45.62.246.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF7E1 /* 45.62.247.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF9AB /* 45.62.249.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EF9AC /* 45.62.249.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3EFC4F /* 45.62.252.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F4131 /* 45.63.65.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D3F7468 /* 45.63.116.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D40BA7A /* 45.64.186.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D42212D /* 45.66.33.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D422323 /* 45.66.35.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429C67 /* 45.66.156.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429C68 /* 45.66.156.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429C70 /* 45.66.156.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429C74 /* 45.66.156.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429C9E /* 45.66.156.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CA8 /* 45.66.156.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CA9 /* 45.66.156.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CB0 /* 45.66.156.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CC2 /* 45.66.156.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CC4 /* 45.66.156.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CC5 /* 45.66.156.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CC6 /* 45.66.156.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429CC8 /* 45.66.156.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429D0A /* 45.66.157.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429D69 /* 45.66.157.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429D6A /* 45.66.157.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429F31 /* 45.66.159.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D429FD6 /* 45.66.159.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4337CF /* 45.67.55.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D43DB0D /* 45.67.219.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4902D3 /* 45.73.2.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C175B /* 45.76.23.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C1B30 /* 45.76.27.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C5656 /* 45.76.86.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C72A0 /* 45.76.114.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C739F /* 45.76.115.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4C93E3 /* 45.76.147.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4CB133 /* 45.76.177.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4CBD78 /* 45.76.189.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4CD95A /* 45.76.217.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4D2DFA /* 45.77.45.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4D3293 /* 45.77.50.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4D34B1 /* 45.77.52.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4D892C /* 45.77.137.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4DC427 /* 45.77.196.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4DC6FF /* 45.77.198.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4DE231 /* 45.77.226.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4DF0B7 /* 45.77.240.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F0529 /* 45.79.5.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F0E8D /* 45.79.14.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F1814 /* 45.79.24.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F279C /* 45.79.39.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F2961 /* 45.79.41.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F2981 /* 45.79.41.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F31DF /* 45.79.49.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F3328 /* 45.79.51.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F3515 /* 45.79.53.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F3824 /* 45.79.56.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F42EE /* 45.79.66.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F4693 /* 45.79.70.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F46DB /* 45.79.70.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F4C19 /* 45.79.76.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F4C59 /* 45.79.76.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F4CAE /* 45.79.76.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5913 /* 45.79.89.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5985 /* 45.79.89.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5B7E /* 45.79.91.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5C5E /* 45.79.92.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5FF4 /* 45.79.95.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F5FF6 /* 45.79.95.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F6C82 /* 45.79.108.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F6D37 /* 45.79.109.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F70E1 /* 45.79.112.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7961 /* 45.79.121.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7AB5 /* 45.79.122.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7C09 /* 45.79.124.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7C79 /* 45.79.124.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7CD0 /* 45.79.124.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7CEA /* 45.79.124.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F7E4C /* 45.79.126.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F8067 /* 45.79.128.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F8A08 /* 45.79.138.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F8AAB /* 45.79.138.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F90DE /* 45.79.144.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F9D36 /* 45.79.157.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F9D67 /* 45.79.157.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F9E65 /* 45.79.158.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4F9F34 /* 45.79.159.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FA6B3 /* 45.79.166.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FB599 /* 45.79.181.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FBF08 /* 45.79.191.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FC215 /* 45.79.194.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FC59B /* 45.79.197.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FC743 /* 45.79.199.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FCB8F /* 45.79.203.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FCEDC /* 45.79.206.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FD7B6 /* 45.79.215.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FDACD /* 45.79.218.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FDFA4 /* 45.79.223.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D4FF9EC /* 45.79.249.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D510750 /* 45.81.7.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D51075F /* 45.81.7.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D52A754 /* 45.82.167.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D52A7EA /* 45.82.167.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D532860 /* 45.83.40.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D54FD1C /* 45.84.253.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D54FD1C /* 45.84.253.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5640D2 /* 45.86.64.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D56A245 /* 45.86.162.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D586ED5 /* 45.88.110.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5A0578 /* 45.90.5.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5A3A61 /* 45.90.58.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5ADA75 /* 45.90.218.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5ADA76 /* 45.90.218.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5ADA78 /* 45.90.218.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5ADA79 /* 45.90.218.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5B6512 /* 45.91.101.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5B65E3 /* 45.91.101.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5CEEF6 /* 45.92.238.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D5FEBC5 /* 45.95.235.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D728204 /* 45.114.130.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D77CBAA /* 45.119.203.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7B7665 /* 45.123.118.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7D412D /* 45.125.65.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7D4170 /* 45.125.65.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7D4176 /* 45.125.65.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D7DA63A /* 45.125.166.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D803DAA /* 45.128.61.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8085CE /* 45.128.133.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8085F2 /* 45.128.133.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D81022D /* 45.129.2.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D810374 /* 45.129.3.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8103D7 /* 45.129.3.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8138C8 /* 45.129.56.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D81601E /* 45.129.96.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D828A41 /* 45.130.138.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D84F425 /* 45.132.244.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D84F626 /* 45.132.246.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8501F7 /* 45.133.1.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D85C027 /* 45.133.192.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8611A0 /* 45.134.17.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8786D9 /* 45.135.134.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D897C7A /* 45.137.124.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D899B38 /* 45.137.155.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D899B40 /* 45.137.155.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D899B72 /* 45.137.155.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8A1AA3 /* 45.138.26.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8A9DB5 /* 45.138.157.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8BCAB0 /* 45.139.202.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8CAABB /* 45.140.170.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8D9C6B /* 45.141.156.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8D9D32 /* 45.141.157.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8D9DE2 /* 45.141.157.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8D9F3F /* 45.141.159.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8E641E /* 45.142.100.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8EB136 /* 45.142.177.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8EB310 /* 45.142.179.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8EB3A1 /* 45.142.179.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8EB3A1 /* 45.142.179.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8ED796 /* 45.142.215.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D8F8B31 /* 45.143.139.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D940A36 /* 45.148.10.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D964037 /* 45.150.64.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D97A70A /* 45.151.167.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D97A70A /* 45.151.167.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A002 /* 45.153.160.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A081 /* 45.153.160.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A082 /* 45.153.160.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A083 /* 45.153.160.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A084 /* 45.153.160.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A085 /* 45.153.160.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A086 /* 45.153.160.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A087 /* 45.153.160.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A088 /* 45.153.160.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A089 /* 45.153.160.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A08A /* 45.153.160.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A08B /* 45.153.160.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99A08C /* 45.153.160.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D99E5C2 /* 45.153.229.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9A23EC /* 45.154.35.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF42 /* 45.154.255.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF43 /* 45.154.255.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF44 /* 45.154.255.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF45 /* 45.154.255.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF46 /* 45.154.255.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF47 /* 45.154.255.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF48 /* 45.154.255.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF49 /* 45.154.255.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF4A /* 45.154.255.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF4B /* 45.154.255.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF4C /* 45.154.255.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF4D /* 45.154.255.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF4E /* 45.154.255.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9AFF93 /* 45.154.255.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9B2AF0 /* 45.155.42.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9C15F9 /* 45.156.21.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9C1783 /* 45.156.23.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9C1785 /* 45.156.23.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2D9C17AF /* 45.156.23.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2DB35916 /* 45.179.89.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2DF95A1A /* 45.249.90.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E040B79 /* 46.4.11.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0420B8 /* 46.4.32.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0420B8 /* 46.4.32.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0422F2 /* 46.4.34.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04313E /* 46.4.49.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0437B1 /* 46.4.55.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0442B2 /* 46.4.66.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E044E94 /* 46.4.78.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04585C /* 46.4.88.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0466FE /* 46.4.102.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047349 /* 46.4.115.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047CA3 /* 46.4.124.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047CA5 /* 46.4.124.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04AE34 /* 46.4.174.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04B030 /* 46.4.176.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04B768 /* 46.4.183.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04D964 /* 46.4.217.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04E968 /* 46.4.233.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E113FD6 /* 46.17.63.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138D52 /* 46.19.141.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138D53 /* 46.19.141.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138D54 /* 46.19.141.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138D55 /* 46.19.141.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138D56 /* 46.19.141.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E142374 /* 46.20.35.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1618ED /* 46.22.24.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E16D4E6 /* 46.22.212.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E174851 /* 46.23.72.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E175DA1 /* 46.23.93.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6C3F /* 46.28.108.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6DE7 /* 46.28.109.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6EF4 /* 46.28.110.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCF6B /* 46.28.207.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1DA3E1 /* 46.29.163.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1DA7F3 /* 46.29.167.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1DF8EE /* 46.29.248.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1DFA1B /* 46.29.250.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E24264C /* 46.36.38.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E242786 /* 46.36.39.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2630E1 /* 46.38.48.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E263312 /* 46.38.51.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26EB0E /* 46.38.235.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26ECFA /* 46.38.236.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26EDDD /* 46.38.237.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26F220 /* 46.38.242.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26FB07 /* 46.38.251.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26FDA1 /* 46.38.253.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26FEDF /* 46.38.254.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26FFA5 /* 46.38.255.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E276109 /* 46.39.97.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E27B73C /* 46.39.183.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E29891C /* 46.41.137.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E29944B /* 46.41.148.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B4158 /* 46.59.65.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B4414 /* 46.59.68.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E481F74 /* 46.72.31.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E491467 /* 46.73.20.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E506018 /* 46.80.96.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E50885E /* 46.80.136.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E510994 /* 46.81.9.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E517E09 /* 46.81.126.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E5536BB /* 46.85.54.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E656B8B /* 46.101.107.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6570D7 /* 46.101.112.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65A5C5 /* 46.101.165.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65B2BE /* 46.101.178.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65B60E /* 46.101.182.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E65B7A0 /* 46.101.183.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E693799 /* 46.105.55.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6979E4 /* 46.105.121.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E69A5F1 /* 46.105.165.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E69E36D /* 46.105.227.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7E60FE /* 46.126.96.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7EA0D0 /* 46.126.160.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E80082E /* 46.128.8.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8A4A88 /* 46.138.74.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8A4A88 /* 46.138.74.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8AF3EF /* 46.138.243.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8E0419 /* 46.142.4.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8E0F90 /* 46.142.15.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA34CAA /* 46.163.76.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA4F49D /* 46.164.244.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5D641 /* 46.165.214.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DDCF /* 46.165.221.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5E605 /* 46.165.230.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5F59A /* 46.165.245.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FDB4 /* 46.165.253.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FDC7 /* 46.165.253.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FE28 /* 46.165.254.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA680AD /* 46.166.128.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA68B6F /* 46.166.139.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA697D9 /* 46.166.151.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A115 /* 46.166.161.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A11A /* 46.166.161.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A12E /* 46.166.161.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A132 /* 46.166.161.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A142 /* 46.166.161.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A14B /* 46.166.161.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A14F /* 46.166.161.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A163 /* 46.166.161.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A1A6 /* 46.166.161.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A1B5 /* 46.166.161.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A1B9 /* 46.166.161.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A1BD /* 46.166.161.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD04 /* 46.166.173.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD05 /* 46.166.173.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD1D /* 46.166.173.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD2D /* 46.166.173.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD9A /* 46.166.173.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AD9B /* 46.166.173.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6ADA1 /* 46.166.173.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6ADA9 /* 46.166.173.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6ADAE /* 46.166.173.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6ADB0 /* 46.166.173.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6ADC3 /* 46.166.173.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6ADC9 /* 46.166.173.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AF10 /* 46.166.175.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6AF1D /* 46.166.175.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6B614 /* 46.166.182.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6BB4D /* 46.166.187.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA7F406 /* 46.167.244.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA7F439 /* 46.167.244.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EAD8024 /* 46.173.128.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EADDA6F /* 46.173.218.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB612F5 /* 46.182.18.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB61303 /* 46.182.19.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB61320 /* 46.182.19.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB615F8 /* 46.182.21.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB66ABE /* 46.182.106.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7773A /* 46.183.119.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC0640 /* 46.188.6.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC0640 /* 46.188.6.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EC20EE1 /* 46.194.14.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDF331B /* 46.223.51.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE26E89 /* 46.226.110.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE3435C /* 46.227.67.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE34365 /* 46.227.67.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE34437 /* 46.227.68.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE3446A /* 46.227.68.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE53776 /* 46.229.55.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE5EEAC /* 46.229.238.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE72085 /* 46.231.32.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE75DD8 /* 46.231.93.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8F850 /* 46.232.248.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8F8F3 /* 46.232.248.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8F98A /* 46.232.249.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8F98A /* 46.232.249.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8F9BC /* 46.232.249.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8FB1D /* 46.232.251.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8FB1D /* 46.232.251.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE8FBBF /* 46.232.251.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEA27AA /* 46.234.39.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEBB65B /* 46.235.182.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF4E6CF /* 46.244.230.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF67E3E /* 46.246.126.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF8A418 /* 46.248.164.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF9256D /* 46.249.37.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF93B71 /* 46.249.59.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF93EFA /* 46.249.62.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F291128 /* 47.41.17.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F291128 /* 47.41.17.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F343B64 /* 47.52.59.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F385E63 /* 47.56.94.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F385E9F /* 47.56.94.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F387EC4 /* 47.56.126.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F38C023 /* 47.56.192.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F38C5F6 /* 47.56.197.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F38C698 /* 47.56.198.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F38D41B /* 47.56.212.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F38E925 /* 47.56.233.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F84095E /* 47.132.9.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F84A5B3 /* 47.132.165.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F90455C /* 47.144.69.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F96F09C /* 47.150.240.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F97960D /* 47.151.150.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F98CF73 /* 47.152.207.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2F9BDAD6 /* 47.155.218.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FBE56FC /* 47.190.86.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FC61E5C /* 47.198.30.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FF494C5 /* 47.244.148.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FFE196B /* 47.254.25.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FFE835D /* 47.254.131.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FFE8608 /* 47.254.134.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FFE8698 /* 47.254.134.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FFE9217 /* 47.254.146.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x2FFE98F2 /* 47.254.152.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C0098 /* 49.12.0.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C05C3 /* 49.12.5.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C0661 /* 49.12.6.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C0A27 /* 49.12.10.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C0CC1 /* 49.12.12.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C20DA /* 49.12.32.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C2156 /* 49.12.33.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C2622 /* 49.12.38.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C2954 /* 49.12.41.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C2A66 /* 49.12.42.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C2DCB /* 49.12.45.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C2E56 /* 49.12.46.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C41A5 /* 49.12.65.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C4528 /* 49.12.69.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C467A /* 49.12.70.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C498C /* 49.12.73.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C4AA7 /* 49.12.74.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C4BA5 /* 49.12.75.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C4E7A /* 49.12.78.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C5DF0 /* 49.12.93.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C60E3 /* 49.12.96.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C61CC /* 49.12.97.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C6466 /* 49.12.100.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C6695 /* 49.12.102.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C6AF3 /* 49.12.106.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C6CE2 /* 49.12.108.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C6D54 /* 49.12.109.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C6DCC /* 49.12.109.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x310C73D2 /* 49.12.115.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31326BDD /* 49.50.107.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31C25D36 /* 49.194.93.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31CD9A8B /* 49.205.154.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31CEFD30 /* 49.206.253.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31D4A626 /* 49.212.166.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x31F78826 /* 49.247.136.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207014C /* 50.7.1.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207088D /* 50.7.8.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32070E24 /* 50.7.14.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAA /* 50.7.74.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAA /* 50.7.74.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAB /* 50.7.74.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAB /* 50.7.74.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAC /* 50.7.74.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAC /* 50.7.74.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAD /* 50.7.74.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAD /* 50.7.74.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAE /* 50.7.74.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32074AAE /* 50.7.74.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32077343 /* 50.7.115.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32077573 /* 50.7.117.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32077C23 /* 50.7.124.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207972F /* 50.7.151.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32079757 /* 50.7.151.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B222 /* 50.7.178.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B292 /* 50.7.178.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B3CA /* 50.7.179.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207BA26 /* 50.7.186.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3207F8A2 /* 50.7.248.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3215B72E /* 50.21.183.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x321FFC1C /* 50.31.252.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3227AA28 /* 50.39.170.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3227AF58 /* 50.39.175.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32357397 /* 50.53.115.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3241AD3F /* 50.65.173.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3248794F /* 50.72.121.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32532107 /* 50.83.33.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x325963B1 /* 50.89.99.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3262AF21 /* 50.98.175.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3273A59E /* 50.115.165.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x327402E9 /* 50.116.2.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32740C24 /* 50.116.12.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32741307 /* 50.116.19.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x327423CC /* 50.116.35.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32742ED6 /* 50.116.46.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32742F8B /* 50.116.47.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32743365 /* 50.116.51.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32C18F2A /* 50.193.143.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32C50BBC /* 50.197.11.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32C50BBD /* 50.197.11.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32E6E754 /* 50.230.231.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32ECC9DA /* 50.236.201.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32FA02AB /* 50.250.2.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32FEDA25 /* 50.254.218.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x32FF717D /* 50.255.113.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F005C /* 51.15.0.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F04CA /* 51.15.4.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F04CA /* 51.15.4.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F0756 /* 51.15.7.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F079E /* 51.15.7.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F083F /* 51.15.8.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F0998 /* 51.15.9.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F12A3 /* 51.15.18.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F19B6 /* 51.15.25.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F1B0D /* 51.15.27.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F24B7 /* 51.15.36.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2564 /* 51.15.37.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F25B9 /* 51.15.37.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2741 /* 51.15.39.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2BCD /* 51.15.43.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2C9D /* 51.15.44.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2CFB /* 51.15.44.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2D34 /* 51.15.45.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2E0F /* 51.15.46.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2F11 /* 51.15.47.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F2F8B /* 51.15.47.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F318F /* 51.15.49.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3224 /* 51.15.50.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3410 /* 51.15.52.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3675 /* 51.15.54.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3AD4 /* 51.15.58.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3B0F /* 51.15.59.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F3E82 /* 51.15.62.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F41F3 /* 51.15.65.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F4929 /* 51.15.73.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F4961 /* 51.15.73.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F4A82 /* 51.15.74.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F4B78 /* 51.15.75.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F4DF4 /* 51.15.77.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F4E00 /* 51.15.78.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F500E /* 51.15.80.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F5194 /* 51.15.81.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F51FA /* 51.15.81.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F550D /* 51.15.85.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F59DA /* 51.15.89.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F5B07 /* 51.15.91.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F5B4E /* 51.15.91.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F5D99 /* 51.15.93.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F62F0 /* 51.15.98.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F63B6 /* 51.15.99.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F7013 /* 51.15.112.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F7154 /* 51.15.113.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F7155 /* 51.15.113.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F760A /* 51.15.118.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F78A2 /* 51.15.120.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F7A67 /* 51.15.122.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F7AEA /* 51.15.122.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F7C01 /* 51.15.124.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F8DC1 /* 51.15.141.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F8E00 /* 51.15.142.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F96E4 /* 51.15.150.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330F96E4 /* 51.15.150.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FAD7D /* 51.15.173.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FADD3 /* 51.15.173.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FAE2F /* 51.15.174.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FAE49 /* 51.15.174.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FB18C /* 51.15.177.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FB18C /* 51.15.177.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FB194 /* 51.15.177.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FB9C9 /* 51.15.185.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBBD1 /* 51.15.187.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBC3A /* 51.15.188.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBC48 /* 51.15.188.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBC50 /* 51.15.188.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBDD1 /* 51.15.189.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBE64 /* 51.15.190.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBE6D /* 51.15.190.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBEE7 /* 51.15.190.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBEE9 /* 51.15.190.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FBEEC /* 51.15.190.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FC518 /* 51.15.197.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FCE48 /* 51.15.206.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FDB16 /* 51.15.219.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FDBE1 /* 51.15.219.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FDFC7 /* 51.15.223.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FE1D8 /* 51.15.225.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FE813 /* 51.15.232.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FEA88 /* 51.15.234.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FF316 /* 51.15.243.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FF6AA /* 51.15.246.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x330FF951 /* 51.15.249.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33263630 /* 51.38.54.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33264088 /* 51.38.64.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x332641A0 /* 51.38.65.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x332645D2 /* 51.38.69.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3326502E /* 51.38.80.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33265127 /* 51.38.81.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33265961 /* 51.38.89.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33265AC5 /* 51.38.90.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33266205 /* 51.38.98.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33266B75 /* 51.38.107.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33266B7A /* 51.38.107.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33267C6D /* 51.38.124.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33268668 /* 51.38.134.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3326A2E8 /* 51.38.162.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3326B49B /* 51.38.180.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3326E95D /* 51.38.233.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3334C820 /* 51.52.200.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344882C /* 51.68.136.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33448BBA /* 51.68.139.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33448C5E /* 51.68.140.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33449B55 /* 51.68.155.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33449B6C /* 51.68.155.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33449B8F /* 51.68.155.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344AA4A /* 51.68.170.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344AAF7 /* 51.68.170.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344AE4F /* 51.68.174.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344B61E /* 51.68.182.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344B98D /* 51.68.185.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344BA3B /* 51.68.186.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344C5DC /* 51.68.197.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344CC8B /* 51.68.204.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344CDB5 /* 51.68.205.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344E506 /* 51.68.229.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3344E6AD /* 51.68.230.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B3476 /* 51.75.52.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B3654 /* 51.75.54.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B3658 /* 51.75.54.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B3DC2 /* 51.75.61.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B4017 /* 51.75.64.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B4054 /* 51.75.64.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B40F5 /* 51.75.64.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B410A /* 51.75.65.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B4166 /* 51.75.65.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B441C /* 51.75.68.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B45BE /* 51.75.69.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B46F6 /* 51.75.70.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B476C /* 51.75.71.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B4B12 /* 51.75.75.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B4BCA /* 51.75.75.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B4FB5 /* 51.75.79.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B52A6 /* 51.75.82.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B5572 /* 51.75.85.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B7DF1 /* 51.75.125.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B7FC8 /* 51.75.127.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B81CC /* 51.75.129.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B8F91 /* 51.75.143.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B8F92 /* 51.75.143.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B8F96 /* 51.75.143.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B8FF1 /* 51.75.143.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B902B /* 51.75.144.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B9911 /* 51.75.153.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334B9913 /* 51.75.153.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BA237 /* 51.75.162.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BAB88 /* 51.75.171.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BB36D /* 51.75.179.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BC2DE /* 51.75.194.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BCE0C /* 51.75.206.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BCE0C /* 51.75.206.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BF6CF /* 51.75.246.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BFA39 /* 51.75.250.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334BFE3F /* 51.75.254.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D235A /* 51.77.35.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D27FF /* 51.77.39.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D32E5 /* 51.77.50.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D34D8 /* 51.77.52.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D6C21 /* 51.77.108.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D6F43 /* 51.77.111.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D8759 /* 51.77.135.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334D9EDA /* 51.77.158.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334DC3B7 /* 51.77.195.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334DCA29 /* 51.77.202.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334DFBC0 /* 51.77.251.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334F16E0 /* 51.79.22.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334F3327 /* 51.79.51.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334F332A /* 51.79.51.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334F42C4 /* 51.79.66.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334F45F1 /* 51.79.69.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334FD3B4 /* 51.79.211.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x334FDDD3 /* 51.79.221.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x335120F1 /* 51.81.32.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33512347 /* 51.81.35.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3351384A /* 51.81.56.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515035 /* 51.81.80.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515182 /* 51.81.81.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515379 /* 51.81.83.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515425 /* 51.81.84.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3351547D /* 51.81.84.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3351550F /* 51.81.85.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3351556A /* 51.81.85.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515671 /* 51.81.86.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515728 /* 51.81.87.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515732 /* 51.81.87.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515D25 /* 51.81.93.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33515DA2 /* 51.81.93.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33517515 /* 51.81.117.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x335197A5 /* 51.81.151.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3351EE30 /* 51.81.238.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33532528 /* 51.83.37.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33532DF6 /* 51.83.45.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3353832A /* 51.83.131.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33538404 /* 51.83.132.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33538555 /* 51.83.133.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3353ED3B /* 51.83.237.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3353FE99 /* 51.83.254.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33590628 /* 51.89.6.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33596441 /* 51.89.100.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33598F98 /* 51.89.143.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33598F99 /* 51.89.143.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33598F9B /* 51.89.143.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33598F9D /* 51.89.143.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33598F9E /* 51.89.143.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33598F9F /* 51.89.143.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3359989E /* 51.89.152.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33599941 /* 51.89.153.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3359A51E /* 51.89.165.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3359C872 /* 51.89.200.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x335B49C2 /* 51.91.73.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x335B62D4 /* 51.91.98.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x335B667F /* 51.91.102.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x335B79FF /* 51.91.121.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E41F3 /* 51.158.65.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E4576 /* 51.158.69.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E4C77 /* 51.158.76.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E4E1B /* 51.158.78.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E4FC6 /* 51.158.79.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E6F9D /* 51.158.111.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E7762 /* 51.158.119.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E925D /* 51.158.146.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9292 /* 51.158.146.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9298 /* 51.158.146.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E92F0 /* 51.158.146.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9319 /* 51.158.147.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E931A /* 51.158.147.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9324 /* 51.158.147.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9338 /* 51.158.147.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9349 /* 51.158.147.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E938E /* 51.158.147.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9390 /* 51.158.147.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9480 /* 51.158.148.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9480 /* 51.158.148.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E94E6 /* 51.158.148.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E94E6 /* 51.158.148.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9857 /* 51.158.152.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E985A /* 51.158.152.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E985D /* 51.158.152.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9887 /* 51.158.152.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E98D5 /* 51.158.152.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E98E4 /* 51.158.152.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339E9A70 /* 51.158.154.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EA5D4 /* 51.158.165.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EA6E6 /* 51.158.166.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EAA1C /* 51.158.170.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EAB23 /* 51.158.171.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EAD89 /* 51.158.173.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EB426 /* 51.158.180.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EB4F6 /* 51.158.180.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339EBB6E /* 51.158.187.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F2283 /* 51.159.34.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F3440 /* 51.159.52.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F3980 /* 51.159.57.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F3B66 /* 51.159.59.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F3BB0 /* 51.159.59.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F3BB8 /* 51.159.59.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F3BBB /* 51.159.59.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F436A /* 51.159.67.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F4387 /* 51.159.67.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x339F43C5 /* 51.159.67.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33A10BE4 /* 51.161.11.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33A12114 /* 51.161.33.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33A12371 /* 51.161.35.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33A12BEB /* 51.161.43.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33A12BEC /* 51.161.43.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AE0F12 /* 51.174.15.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AEC34E /* 51.174.195.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AF7926 /* 51.175.121.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33AFF5A2 /* 51.175.245.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33B21180 /* 51.178.17.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33B25119 /* 51.178.81.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33B252C9 /* 51.178.82.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33B25689 /* 51.178.86.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33B2AA82 /* 51.178.170.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C32AE2 /* 51.195.42.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C32D64 /* 51.195.45.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C34117 /* 51.195.65.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3674A /* 51.195.103.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3755C /* 51.195.117.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C388BE /* 51.195.136.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C38BA7 /* 51.195.139.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3938F /* 51.195.147.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3A6A0 /* 51.195.166.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3A6A2 /* 51.195.166.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3A6A4 /* 51.195.166.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3C80A /* 51.195.200.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3CA07 /* 51.195.202.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3CB70 /* 51.195.203.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3CB76 /* 51.195.203.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33C3E880 /* 51.195.232.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33D20EA2 /* 51.210.14.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33D22296 /* 51.210.34.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33D265C4 /* 51.210.101.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE0E1F /* 51.222.14.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE0FA4 /* 51.222.15.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE1371 /* 51.222.19.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE1835 /* 51.222.24.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE1D50 /* 51.222.29.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE61AA /* 51.222.97.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE6EA3 /* 51.222.110.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33DE8511 /* 51.222.133.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE2397 /* 51.254.35.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE2D2B /* 51.254.45.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE2D2B /* 51.254.45.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE305D /* 51.254.48.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE60D0 /* 51.254.96.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE7286 /* 51.254.114.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FE88C3 /* 51.254.136.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF276E /* 51.255.39.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF2D90 /* 51.255.45.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF4B03 /* 51.255.75.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF6A55 /* 51.255.106.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x33FF96B1 /* 51.255.150.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34084499 /* 52.8.68.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x340A368F /* 52.10.54.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x340FE863 /* 52.15.232.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x342F5B96 /* 52.47.91.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3434E60D /* 52.52.230.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3435F238 /* 52.53.242.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x343696C2 /* 52.54.150.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x343F8694 /* 52.63.134.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x345BCC23 /* 52.91.204.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x347771C3 /* 52.119.113.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x348D2159 /* 52.141.33.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x348F9D5C /* 52.143.157.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34CD0FEF /* 52.205.15.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34D65EA3 /* 52.214.94.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x34E70B22 /* 52.231.11.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x362418E2 /* 54.36.24.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x362467DF /* 54.36.103.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36247403 /* 54.36.116.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624789C /* 54.36.120.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624A2B9 /* 54.36.162.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624A5AA /* 54.36.165.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624A656 /* 54.36.166.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624AC20 /* 54.36.172.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624CD26 /* 54.36.205.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624CD26 /* 54.36.205.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624E3F7 /* 54.36.227.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3624EDA3 /* 54.36.237.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x362510F1 /* 54.37.16.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36258A68 /* 54.37.138.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36258B76 /* 54.37.139.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625C89B /* 54.37.200.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625C89D /* 54.37.200.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625CCBC /* 54.37.204.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625CF25 /* 54.37.207.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625CF52 /* 54.37.207.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625CF54 /* 54.37.207.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625E516 /* 54.37.229.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625E83D /* 54.37.232.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3625EA42 /* 54.37.234.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626163D /* 54.38.22.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626242C /* 54.38.36.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36263465 /* 54.38.52.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626355E /* 54.38.53.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36263704 /* 54.38.55.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36263B01 /* 54.38.59.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36263B02 /* 54.38.59.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36264F99 /* 54.38.79.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626B765 /* 54.38.183.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626BB36 /* 54.38.187.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626DBF8 /* 54.38.219.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626DBF9 /* 54.38.219.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626DBFA /* 54.38.219.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3626DBFB /* 54.38.219.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36271049 /* 54.39.16.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3627321C /* 54.39.50.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36279481 /* 54.39.148.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3627B03C /* 54.39.176.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3627CACA /* 54.39.202.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36434BD9 /* 54.67.75.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365AEA7A /* 54.90.234.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365D3C91 /* 54.93.60.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365D4D46 /* 54.93.77.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365E6AFC /* 54.94.106.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x365E6AFC /* 54.94.106.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3699F91A /* 54.153.249.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x369FE1DB /* 54.159.225.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36A50625 /* 54.165.6.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36B46A83 /* 54.180.106.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36B7C9FF /* 54.183.201.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x36FB578F /* 54.251.87.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3A01F0F3 /* 58.1.240.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3AB945F2 /* 58.185.69.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3AB945F5 /* 58.185.69.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3B6AD323 /* 59.106.211.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3BA7C245 /* 59.167.194.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3C8B7BDE /* 60.139.123.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3CF130C2 /* 60.241.48.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3CF2611D /* 60.242.97.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3D1B9613 /* 61.27.150.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3D5C16EB /* 61.92.22.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3DC58519 /* 61.197.133.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3DF58AD9 /* 61.245.138.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E040F54 /* 62.4.15.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E041968 /* 62.4.25.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E0C7674 /* 62.12.118.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E1F0526 /* 62.31.5.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E2A8AA2 /* 62.42.138.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E36B176 /* 62.54.177.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4128FA /* 62.65.40.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E416AA3 /* 62.65.106.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4852DE /* 62.72.82.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4EC204 /* 62.78.194.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E50E331 /* 62.80.227.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E669444 /* 62.102.148.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E669444 /* 62.102.148.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E669445 /* 62.102.148.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6D0002 /* 62.109.0.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6D0473 /* 62.109.4.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E700A9A /* 62.112.10.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71B3BA /* 62.113.179.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D16D /* 62.113.209.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D372 /* 62.113.211.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D8AD /* 62.113.216.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71D8B1 /* 62.113.216.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71E37C /* 62.113.227.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E73FF62 /* 62.115.255.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2496 /* 62.141.36.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2645 /* 62.141.38.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D27A0 /* 62.141.39.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D30AF /* 62.141.48.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D30B1 /* 62.141.48.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D335A /* 62.141.51.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8F5442 /* 62.143.84.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8FDA0C /* 62.143.218.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E9502BC /* 62.149.2.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E97B43E /* 62.151.180.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3E990B29 /* 62.153.11.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EA803D4 /* 62.168.3.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAB89A9 /* 62.171.137.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAB8E03 /* 62.171.142.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAB909B /* 62.171.144.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAB9125 /* 62.171.145.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAB9477 /* 62.171.148.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EAB9FA4 /* 62.171.159.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EABA574 /* 62.171.165.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EABB406 /* 62.171.180.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EABBA42 /* 62.171.186.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EABBF3F /* 62.171.191.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB26980 /* 62.178.105.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB28A2E /* 62.178.138.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB6541B /* 62.182.84.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC37614 /* 62.195.118.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC5CFB6 /* 62.197.207.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED209B2 /* 62.210.9.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED22552 /* 62.210.37.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED253CF /* 62.210.83.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED253CF /* 62.210.83.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED255B2 /* 62.210.85.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2560F /* 62.210.86.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25909 /* 62.210.89.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED263EE /* 62.210.99.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2692E /* 62.210.105.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2692E /* 62.210.105.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED26974 /* 62.210.105.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED26D30 /* 62.210.109.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2743D /* 62.210.116.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27B18 /* 62.210.123.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27D1A /* 62.210.125.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED27D82 /* 62.210.125.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED29461 /* 62.210.148.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2B1BD /* 62.210.177.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2B577 /* 62.210.181.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CDE4 /* 62.210.205.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2D765 /* 62.210.215.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F492 /* 62.210.244.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED8361D /* 62.216.54.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED84BB0 /* 62.216.75.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED85410 /* 62.216.84.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED8544F /* 62.216.84.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED85462 /* 62.216.84.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED85475 /* 62.216.84.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED85476 /* 62.216.84.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED8556E /* 62.216.85.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED8577D /* 62.216.87.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED85A5B /* 62.216.90.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE0C06F /* 62.224.192.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EEBE71C /* 62.235.231.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EF08287 /* 62.240.130.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EFB594A /* 62.251.89.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3EFB7E7C /* 62.251.126.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3F8EFB66 /* 63.142.251.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3F8F35B6 /* 63.143.53.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x3FE374A2 /* 63.227.116.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4004AF21 /* 64.4.175.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x401B17B1 /* 64.27.23.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x401B3FDA /* 64.27.63.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x402AB3E3 /* 64.42.179.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x402AB3ED /* 64.42.179.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x402C339C /* 64.44.51.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x403454C2 /* 64.52.84.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x404AA0DD /* 64.74.160.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x404F9884 /* 64.79.152.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4053A72D /* 64.83.167.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x406273D1 /* 64.98.115.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4071201D /* 64.113.32.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E102BF /* 64.225.2.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E10E6E /* 64.225.14.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E11020 /* 64.225.16.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E15D7D /* 64.225.93.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E17014 /* 64.225.112.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E339B5 /* 64.227.57.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E35601 /* 64.227.86.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E360A9 /* 64.227.96.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E36480 /* 64.227.100.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E368F9 /* 64.227.104.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40E36A99 /* 64.227.106.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x40EA6D1B /* 64.234.109.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4115015C /* 65.21.1.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x41150327 /* 65.21.3.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x411504CD /* 65.21.4.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x411531CC /* 65.21.49.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x41153966 /* 65.21.57.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4118F2F4 /* 65.24.242.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4131140A /* 65.49.20.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4131140A /* 65.49.20.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4131140B /* 65.49.20.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4131140B /* 65.49.20.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4131140C /* 65.49.20.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4131140C /* 65.49.20.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4132CB05 /* 65.50.203.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57BFE /* 65.181.123.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x41B7DA59 /* 65.183.218.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x420B7C43 /* 66.11.124.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4217CDEE /* 66.23.205.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4217E387 /* 66.23.227.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x422A452C /* 66.42.69.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x422AA3DE /* 66.42.163.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4246CCAF /* 66.70.204.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4246CFA8 /* 66.70.207.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4246D314 /* 66.70.211.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4246E4A8 /* 66.70.228.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4246E4AE /* 66.70.228.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42555C0F /* 66.85.92.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0210 /* 66.111.2.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0214 /* 66.111.2.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0283 /* 66.111.2.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42738E39 /* 66.115.142.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4292C121 /* 66.146.193.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4298B30B /* 66.152.179.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD851 /* 66.175.216.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDD43 /* 66.175.221.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDECE /* 66.175.222.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42B7AD1D /* 66.183.173.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42B7AD51 /* 66.183.173.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42CE0052 /* 66.206.0.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42CE008A /* 66.206.0.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42CE041A /* 66.206.4.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42D04080 /* 66.208.64.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42D3C526 /* 66.211.197.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42819 /* 66.228.40.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42D53 /* 66.228.45.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E433CF /* 66.228.51.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E43A5F /* 66.228.58.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E43B6A /* 66.228.59.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42E6E6E6 /* 66.230.230.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x42F8CE15 /* 66.248.206.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4308CA98 /* 67.8.202.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43A3810F /* 67.163.129.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43A5094A /* 67.165.9.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43C62510 /* 67.198.37.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43CF5895 /* 67.207.88.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43DB8807 /* 67.219.136.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x43F96BC3 /* 67.249.107.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x440EB1C4 /* 68.14.177.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4442F16F /* 68.66.241.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4443201F /* 68.67.32.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44432020 /* 68.67.32.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44432021 /* 68.67.32.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44432022 /* 68.67.32.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44471B4E /* 68.71.27.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x446B4B78 /* 68.107.75.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4481293F /* 68.129.41.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x448E317A /* 68.142.49.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4494F65B /* 68.148.246.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44952BE2 /* 68.149.43.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44A0F2D6 /* 68.160.242.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7732E /* 68.183.115.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7A3D7 /* 68.183.163.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7B659 /* 68.183.182.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7B8AE /* 68.183.184.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7C2F2 /* 68.183.194.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7E682 /* 68.183.230.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44C4B384 /* 68.196.179.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x44CD105D /* 68.205.16.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4504EA51 /* 69.4.234.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x450B6F25 /* 69.11.111.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451EB98E /* 69.30.185.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x451EEF7E /* 69.30.239.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x453EA2B2 /* 69.62.162.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4546D6E7 /* 69.70.214.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4577BADD /* 69.119.186.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4578C69A /* 69.120.198.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x458E9677 /* 69.142.150.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A323DE /* 69.163.35.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C20A /* 69.164.194.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D28E /* 69.164.210.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D312 /* 69.164.211.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD41 /* 69.164.221.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD4E /* 69.164.221.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DE97 /* 69.164.222.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45A9AA5B /* 69.169.170.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45AE93ED /* 69.174.147.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x45C3929E /* 69.195.146.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x462C581F /* 70.44.88.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46346063 /* 70.52.96.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46379C58 /* 70.55.156.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46397C03 /* 70.57.124.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x463F6AE6 /* 70.63.106.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x463FAA56 /* 70.63.170.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4640585B /* 70.64.88.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x464487BB /* 70.68.135.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x464AB0F3 /* 70.74.176.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4659739D /* 70.89.115.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46599959 /* 70.89.153.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4660C44D /* 70.96.196.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x466AFC17 /* 70.106.252.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46AD9A77 /* 70.173.154.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46ADFBDA /* 70.173.251.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46B32FCD /* 70.179.47.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46B61AE3 /* 70.182.26.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x46ECD098 /* 70.236.208.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139041 /* 71.19.144.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139059 /* 71.19.144.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713906A /* 71.19.144.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x471390B8 /* 71.19.144.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139515 /* 71.19.149.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139A06 /* 71.19.154.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139A54 /* 71.19.154.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139B79 /* 71.19.155.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47139D7F /* 71.19.157.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713FBDA /* 71.19.251.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713FC05 /* 71.19.252.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713FC06 /* 71.19.252.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713FC18 /* 71.19.252.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713FC19 /* 71.19.252.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4713FC1A /* 71.19.252.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x473CC014 /* 71.60.192.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x475D4C7D /* 71.93.76.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47692C2D /* 71.105.44.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4769B563 /* 71.105.181.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x477238D0 /* 71.114.56.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47730F3B /* 71.115.15.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47788B8B /* 71.120.139.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x477D3DC2 /* 71.125.61.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x477E8290 /* 71.126.130.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x477FA820 /* 71.127.168.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x477FB39E /* 71.127.179.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x477FB6AF /* 71.127.182.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47832772 /* 71.131.39.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x478B2A3A /* 71.139.42.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47A62A46 /* 71.166.42.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47AE697E /* 71.174.105.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47B0E995 /* 71.176.233.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47B72DC8 /* 71.183.45.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47C5A46C /* 71.197.164.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47DAB043 /* 71.218.176.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47DAB043 /* 71.218.176.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47DF6C6B /* 71.223.108.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47E03707 /* 71.224.55.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47E77383 /* 71.231.115.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x47F4A6D4 /* 71.244.166.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480548E3 /* 72.5.72.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB1A4 /* 72.14.177.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB3A6 /* 72.14.179.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4818DB3D /* 72.24.219.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4833E01F /* 72.51.224.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x485DF3D3 /* 72.93.243.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x488486D9 /* 72.132.134.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48AE4157 /* 72.174.65.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48BA0691 /* 72.186.6.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48CD20CE /* 72.205.32.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48D659E9 /* 72.214.89.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48D92DEF /* 72.217.45.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48DF7615 /* 72.223.118.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x48EA9B15 /* 72.234.155.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x492AA0FF /* 73.42.160.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x494981D1 /* 73.73.129.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x495A1463 /* 73.90.20.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x496712B6 /* 73.103.18.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4980CC27 /* 73.128.204.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49855BC5 /* 73.133.91.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4994F549 /* 73.148.245.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49A727A8 /* 73.167.39.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49AAC3D9 /* 73.170.195.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49B189E2 /* 73.177.137.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49B54350 /* 73.181.67.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49C910C4 /* 73.201.16.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49CA042A /* 73.202.4.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49D9CBFC /* 73.217.203.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49DB4497 /* 73.219.68.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49E108A4 /* 73.225.8.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x49FCCD97 /* 73.252.205.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A492809 /* 74.73.40.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A522FC2 /* 74.82.47.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A530292 /* 74.83.2.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5B1502 /* 74.91.21.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A6F19B1 /* 74.111.25.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A6F19B1 /* 74.111.25.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A74BA78 /* 74.116.186.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A77C170 /* 74.119.193.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A79BCDA /* 74.121.188.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A79BF6A /* 74.121.191.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4A79BFB2 /* 74.121.191.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACB8A17 /* 74.203.138.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE68E /* 74.207.230.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE7BA /* 74.207.231.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF207 /* 74.207.242.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD07840 /* 74.208.120.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD0FD1E /* 74.208.253.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B3A2D6D /* 75.58.45.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B4B6666 /* 75.75.102.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B57AD17 /* 75.87.173.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B7F0F49 /* 75.127.15.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4B8FDCC9 /* 75.143.220.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BA34769 /* 75.163.71.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BAED0EF /* 75.174.208.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB02D57 /* 75.176.45.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB810FB /* 75.184.16.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0E70EB /* 76.14.112.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0E97AE /* 76.14.151.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C1EFF5E /* 76.30.255.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C43BD9E /* 76.67.189.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4806D1 /* 76.72.6.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4C719F31 /* 76.113.159.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4CA95C7A /* 76.169.92.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4CC0678D /* 76.192.103.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D01A178 /* 77.1.161.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D03993B /* 77.3.153.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D03B344 /* 77.3.179.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D03EAA4 /* 77.3.234.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0479A4 /* 77.4.121.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D083181 /* 77.8.49.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D08E760 /* 77.8.231.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0A059B /* 77.10.5.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0B334A /* 77.11.51.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0B395E /* 77.11.57.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0B726E /* 77.11.114.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0BBAC4 /* 77.11.186.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D140234 /* 77.20.2.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D14B323 /* 77.20.179.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D152810 /* 77.21.40.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D16A804 /* 77.22.168.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D16B9B4 /* 77.22.185.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D16C07B /* 77.22.192.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D1737EC /* 77.23.55.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D227E4E /* 77.34.126.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D258EB3 /* 77.37.142.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25A012 /* 77.37.160.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D2F7436 /* 77.47.116.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D325406 /* 77.50.84.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D36C9BA /* 77.54.201.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D37D26F /* 77.55.210.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D37DCFA /* 77.55.220.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D39809A /* 77.57.128.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3AFA6E /* 77.58.250.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D440763 /* 77.68.7.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4407E9 /* 77.68.7.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4409C6 /* 77.68.9.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D441E68 /* 77.68.30.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D444F48 /* 77.68.79.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D445814 /* 77.68.88.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D445E6A /* 77.68.94.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D447E38 /* 77.68.126.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D461C26 /* 77.70.28.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D463FDC /* 77.70.63.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D494027 /* 77.73.64.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D49403C /* 77.73.64.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D49451F /* 77.73.69.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4A602B /* 77.74.96.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D518E45 /* 77.81.142.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D51F748 /* 77.81.247.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D74E0 /* 77.109.116.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D787140 /* 77.120.113.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D799D1F /* 77.121.157.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D7B2A94 /* 77.123.42.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4D7B9B2D /* 77.123.155.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DA2E549 /* 77.162.229.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DB38AF0 /* 77.179.138.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBE31C6 /* 77.190.49.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBE4F86 /* 77.190.79.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBF5B29 /* 77.191.91.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DBFC8CF /* 77.191.200.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DCDFBF9 /* 77.205.251.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DE1FAC3 /* 77.225.250.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF3B556 /* 77.243.181.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A3 /* 77.247.181.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A3 /* 77.247.181.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A5 /* 77.247.181.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A5 /* 77.247.181.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4DFAE3CA /* 77.250.227.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E0DCFE7 /* 78.13.207.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E148781 /* 78.20.135.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E1F415C /* 78.31.65.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E239051 /* 78.35.144.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E28D956 /* 78.40.217.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2A08E5 /* 78.42.8.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2A86A0 /* 78.42.134.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2BCF49 /* 78.43.207.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2BCF49 /* 78.43.207.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2CFA5D /* 78.44.250.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E26FA /* 78.46.38.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E350B /* 78.46.53.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E3ACC /* 78.46.58.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E3F71 /* 78.46.63.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E40F5 /* 78.46.64.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E55D8 /* 78.46.85.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E62CF /* 78.46.98.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E6870 /* 78.46.104.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E7836 /* 78.46.120.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E7C8D /* 78.46.124.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EA266 /* 78.46.162.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EA27B /* 78.46.162.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EAE48 /* 78.46.174.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EB157 /* 78.46.177.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EBD71 /* 78.46.189.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC0E9 /* 78.46.192.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC1D7 /* 78.46.193.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC2A4 /* 78.46.194.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2ECB12 /* 78.46.203.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2ED9D6 /* 78.46.217.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EF96D /* 78.46.249.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EFB93 /* 78.46.251.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F0E63 /* 78.47.14.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F126E /* 78.47.18.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F141D /* 78.47.20.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F202A /* 78.47.32.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F2414 /* 78.47.36.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F291C /* 78.47.41.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F37A2 /* 78.47.55.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F56A8 /* 78.47.86.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5A25 /* 78.47.90.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F642D /* 78.47.100.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F676D /* 78.47.103.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F68C7 /* 78.47.104.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F758C /* 78.47.117.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F799E /* 78.47.121.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F7D30 /* 78.47.125.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F86C4 /* 78.47.134.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F9375 /* 78.47.147.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FA9BD /* 78.47.169.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FB006 /* 78.47.176.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FB261 /* 78.47.178.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FB65E /* 78.47.182.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FBBA9 /* 78.47.187.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FCB69 /* 78.47.203.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE20C /* 78.47.226.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE3E4 /* 78.47.227.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FF29E /* 78.47.242.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FF410 /* 78.47.244.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FFDC6 /* 78.47.253.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E3041A3 /* 78.48.65.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E36F077 /* 78.54.240.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E374BB4 /* 78.55.75.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E376340 /* 78.55.99.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E37CCD2 /* 78.55.204.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E494561 /* 78.73.69.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E52B402 /* 78.82.180.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E52F55D /* 78.82.245.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E4AEC /* 78.94.74.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E8DB4 /* 78.94.141.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E8DCA /* 78.94.141.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5EBA85 /* 78.94.186.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5EFDFD /* 78.94.253.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6305A6 /* 78.99.5.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BED35 /* 78.107.237.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BEFD5 /* 78.107.239.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BEFFD /* 78.107.239.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C6603 /* 78.108.102.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C6F70 /* 78.108.111.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C6F7F /* 78.108.111.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6CD87F /* 78.108.216.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81A575 /* 78.129.165.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81A576 /* 78.129.165.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81A578 /* 78.129.165.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81A585 /* 78.129.165.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81B410 /* 78.129.180.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81BA1C /* 78.129.186.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81C136 /* 78.129.193.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E82806A /* 78.130.128.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E88E985 /* 78.136.233.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8B7228 /* 78.139.114.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8DE987 /* 78.141.233.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8DF57A /* 78.141.245.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E8CF2 /* 78.142.140.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8EAF46 /* 78.142.175.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E95C1A0 /* 78.149.193.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9F6355 /* 78.159.99.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC2023D /* 78.194.2.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC23B76 /* 78.194.59.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC29E1E /* 78.194.158.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC29E8D /* 78.194.158.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC44A69 /* 78.196.74.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC46094 /* 78.196.96.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC4A7C0 /* 78.196.167.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC67C06 /* 78.198.124.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC693E3 /* 78.198.147.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F13EF85 /* 79.19.239.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F3569ED /* 79.53.105.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F626F31 /* 79.98.111.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6F0F83 /* 79.111.15.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F704994 /* 79.112.73.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F71B4DB /* 79.113.180.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7C070B /* 79.124.7.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F852443 /* 79.133.36.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F852444 /* 79.133.36.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F852445 /* 79.133.36.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EAF7 /* 79.134.234.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EB5D /* 79.134.235.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EBF3 /* 79.134.235.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EBFD /* 79.134.235.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F88012E /* 79.136.1.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8923B3 /* 79.137.35.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C2975 /* 79.140.41.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C2976 /* 79.140.41.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB1C0 /* 79.143.177.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB5DD /* 79.143.181.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB72C /* 79.143.183.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FBA11 /* 79.143.186.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FACC120 /* 79.172.193.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FAF0B84 /* 79.175.11.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC41DA6 /* 79.196.29.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC4FB1E /* 79.196.251.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC661E0 /* 79.198.97.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC78C4C /* 79.199.140.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC86ABE /* 79.200.106.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC9EA9F /* 79.201.234.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCCBABC /* 79.204.186.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCEECB1 /* 79.206.236.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD1A758 /* 79.209.167.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD47A23 /* 79.212.122.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD6CA75 /* 79.214.202.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD8B158 /* 79.216.177.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FDB9A7C /* 79.219.154.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FDDA7A0 /* 79.221.167.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF78635 /* 79.247.134.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FFBCB37 /* 79.251.203.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x4FFE1B89 /* 79.254.27.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x501FC381 /* 80.31.195.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x503CF5EA /* 80.60.245.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5042870D /* 80.66.135.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5042877B /* 80.66.135.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5043A756 /* 80.67.167.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5043ACA2 /* 80.67.172.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50478AC3 /* 80.71.138.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50482BFA /* 80.72.43.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x504F1707 /* 80.79.23.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50555448 /* 80.85.84.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5059E40F /* 80.89.228.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x505A2719 /* 80.90.39.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5062830A /* 80.98.131.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50640FBA /* 80.100.15.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50644561 /* 80.100.69.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50644561 /* 80.100.69.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50649D29 /* 80.100.157.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506DC17C /* 80.109.193.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x506E230F /* 80.110.35.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507090E9 /* 80.112.144.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5070A5A4 /* 80.112.165.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F890E /* 80.127.137.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x507F9804 /* 80.127.152.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5081164C /* 80.129.22.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50883977 /* 80.136.57.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5089B235 /* 80.137.178.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5089B920 /* 80.137.185.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x508E950C /* 80.142.149.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5090D364 /* 80.144.211.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50B360A5 /* 80.179.96.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50C37AA6 /* 80.195.122.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D096B9 /* 80.208.150.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D1D915 /* 80.209.217.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D24A9B /* 80.210.74.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D3352C /* 80.211.53.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D34AAD /* 80.211.74.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D35A6A /* 80.211.90.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D382F1 /* 80.211.130.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D3B941 /* 80.211.185.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D3D348 /* 80.211.211.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D3DAC9 /* 80.211.218.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D3FBA4 /* 80.211.251.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D3FE8F /* 80.211.254.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D41A47 /* 80.212.26.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D9020B /* 80.217.2.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50D9DB2F /* 80.217.219.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DB7C3B /* 80.219.124.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DB88D8 /* 80.219.136.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50DD2B67 /* 80.221.43.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E0A7F5 /* 80.224.167.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E0A7F5 /* 80.224.167.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50E598E4 /* 80.229.152.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50EB2330 /* 80.235.35.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50EE7C03 /* 80.238.124.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F13CCF /* 80.241.60.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1D556 /* 80.241.213.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1D666 /* 80.241.214.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1D934 /* 80.241.217.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DA61 /* 80.241.218.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DC39 /* 80.241.220.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50F4F39E /* 80.244.243.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50FA0412 /* 80.250.4.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50FD5EFC /* 80.253.94.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x50FF00B4 /* 80.255.0.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5100E203 /* 81.0.226.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510469E4 /* 81.4.105.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51046D3F /* 81.4.109.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510628B6 /* 81.6.40.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51062BA7 /* 81.6.43.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51062BFC /* 81.6.43.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070AC1 /* 81.7.10.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070AFB /* 81.7.10.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070BFD /* 81.7.11.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070E1F /* 81.7.14.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51070EFD /* 81.7.14.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510710B1 /* 81.7.16.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510710B6 /* 81.7.16.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51071207 /* 81.7.18.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51071261 /* 81.7.18.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x510AD006 /* 81.10.208.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5110211F /* 81.16.33.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111092 /* 81.17.16.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111093 /* 81.17.16.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111094 /* 81.17.16.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111095 /* 81.17.16.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111096 /* 81.17.16.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111232 /* 81.17.18.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111233 /* 81.17.18.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111234 /* 81.17.18.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111235 /* 81.17.18.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111236 /* 81.17.18.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5111133A /* 81.17.19.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111E21 /* 81.17.30.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111E2C /* 81.17.30.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51111E30 /* 81.17.30.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51113C18 /* 81.17.60.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5113074B /* 81.19.7.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51148F8A /* 81.20.143.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511CCED8 /* 81.28.206.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511D866E /* 81.29.134.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9E79 /* 81.30.158.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9EAA /* 81.30.158.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x512C2670 /* 81.44.38.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5133F653 /* 81.51.246.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5153258A /* 81.83.37.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515AB4A1 /* 81.90.180.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x515F3444 /* 81.95.52.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x516FBA3A /* 81.111.186.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x519D99AA /* 81.157.153.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A1A38C /* 81.161.163.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A7E8D5 /* 81.167.232.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A98CA0 /* 81.169.140.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9A758 /* 81.169.167.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9B41C /* 81.169.180.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9BA10 /* 81.169.186.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9C5D1 /* 81.169.197.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9CAC4 /* 81.169.202.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9DF56 /* 81.169.223.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9E879 /* 81.169.232.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9EB9A /* 81.169.235.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9FF7D /* 81.169.255.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA838A /* 81.170.131.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA8E9D /* 81.170.142.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA8F7B /* 81.170.143.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA9B06 /* 81.170.155.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA9B06 /* 81.170.155.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AB1D92 /* 81.171.29.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51AEE712 /* 81.174.231.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51C6E327 /* 81.198.227.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51C9C9A9 /* 81.201.201.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51EDCEE0 /* 81.237.206.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51F7AF35 /* 81.247.175.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x51FE2F75 /* 81.254.47.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x520724C8 /* 82.7.36.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x520724C8 /* 82.7.36.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5214A469 /* 82.20.164.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5215B01F /* 82.21.176.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52239F01 /* 82.35.159.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x522F7B5D /* 82.47.123.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52333815 /* 82.51.56.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52400974 /* 82.64.9.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x524014AB /* 82.64.20.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240331C /* 82.64.51.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52404BE8 /* 82.64.75.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x524071D3 /* 82.64.113.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52407545 /* 82.64.117.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52408D90 /* 82.64.141.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52409941 /* 82.64.153.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52409AD7 /* 82.64.154.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240A3BC /* 82.64.163.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240BD75 /* 82.64.189.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240C519 /* 82.64.197.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240DF36 /* 82.64.223.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240EE54 /* 82.64.238.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240EE90 /* 82.64.238.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240EF26 /* 82.64.239.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5240F370 /* 82.64.243.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52411D79 /* 82.65.29.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52412043 /* 82.65.32.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5241760F /* 82.65.118.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52417D72 /* 82.65.125.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52417D72 /* 82.65.125.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52418768 /* 82.65.135.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5241944B /* 82.65.148.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52419636 /* 82.65.150.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5241C972 /* 82.65.201.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5241E4C9 /* 82.65.228.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5243B44D /* 82.67.180.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5243D421 /* 82.67.212.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52452F72 /* 82.69.47.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52483064 /* 82.72.48.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5248F0A6 /* 82.72.240.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x524DEE06 /* 82.77.238.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525EFBE3 /* 82.94.251.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x525F6B33 /* 82.95.107.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52661BC3 /* 82.102.27.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52678C57 /* 82.103.140.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52747803 /* 82.116.120.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52761720 /* 82.118.23.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F267 /* 82.118.242.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F293 /* 82.118.242.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52770434 /* 82.119.4.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x528343E8 /* 82.131.67.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52913B7F /* 82.145.59.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52922F11 /* 82.146.47.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5295E37B /* 82.149.227.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5295E37C /* 82.149.227.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5295E37E /* 82.149.227.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5295E3EC /* 82.149.227.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x529E6443 /* 82.158.100.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1321E /* 82.161.50.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1321E /* 82.161.50.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1D257 /* 82.161.210.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A51277 /* 82.165.18.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A514A1 /* 82.165.20.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A51ED4 /* 82.165.30.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A543DE /* 82.165.67.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A544A5 /* 82.165.68.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A54641 /* 82.165.70.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A56748 /* 82.165.103.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A573A6 /* 82.165.115.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A5A72E /* 82.165.167.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52A5CEC4 /* 82.165.206.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B52F46 /* 82.181.47.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B55B76 /* 82.181.91.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52B568CA /* 82.181.104.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C05E7D /* 82.192.94.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C4080D /* 82.196.8.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C40B0A /* 82.196.11.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C47E5D /* 82.196.126.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C5A043 /* 82.197.160.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C5D71E /* 82.197.215.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52C5DAD4 /* 82.197.218.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52CFCAF3 /* 82.207.202.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52CFDD9E /* 82.207.221.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52CFDDFD /* 82.207.221.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D4AA4F /* 82.212.170.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52D9D96E /* 82.217.217.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD69C6 /* 82.221.105.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD80BF /* 82.221.128.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8305 /* 82.221.131.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8347 /* 82.221.131.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8366 /* 82.221.131.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD8D60 /* 82.221.141.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF0998 /* 82.223.9.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF0B55 /* 82.223.11.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF0EF5 /* 82.223.14.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF1144 /* 82.223.17.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF11A4 /* 82.223.17.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF4672 /* 82.223.70.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF8B4F /* 82.223.139.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DFCD85 /* 82.223.205.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DFD8A9 /* 82.223.216.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x52DFDE3D /* 82.223.222.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5320599D /* 83.32.89.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5327BD23 /* 83.39.189.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53346064 /* 83.52.96.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x533623FC /* 83.54.35.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5337EA89 /* 83.55.234.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53448302 /* 83.68.131.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5360D53F /* 83.96.213.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53611462 /* 83.97.20.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53611463 /* 83.97.20.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53611464 /* 83.97.20.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53611465 /* 83.97.20.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x536114F5 /* 83.97.20.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x536114F8 /* 83.97.20.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x536157B6 /* 83.97.87.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53637EF4 /* 83.99.126.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53637EF4 /* 83.99.126.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53807D46 /* 83.128.125.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5380BC15 /* 83.128.188.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x538693C8 /* 83.134.147.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53874D65 /* 83.135.77.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53875CEB /* 83.135.92.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5387C7C8 /* 83.135.199.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5387D571 /* 83.135.213.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5387D571 /* 83.135.213.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5387D61D /* 83.135.214.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53886A88 /* 83.136.106.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53886ADF /* 83.136.106.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53886B72 /* 83.136.107.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x538F7410 /* 83.143.116.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2BC64 /* 83.162.188.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53ABA26B /* 83.171.162.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53C5EB2E /* 83.197.235.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D10979 /* 83.209.9.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D109E9 /* 83.209.9.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D13523 /* 83.209.53.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D448BD /* 83.212.72.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D44A5B /* 83.212.74.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D44B0A /* 83.212.75.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D45219 /* 83.212.82.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46078 /* 83.212.96.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46344 /* 83.212.99.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46464 /* 83.212.100.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46672 /* 83.212.102.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46781 /* 83.212.103.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46785 /* 83.212.103.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D4682D /* 83.212.104.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46B80 /* 83.212.107.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53D772B2 /* 83.215.114.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53DCAE50 /* 83.220.174.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53E29C13 /* 83.226.156.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53E45D4C /* 83.228.93.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53F344C2 /* 83.243.68.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FD0EFF /* 83.253.14.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x53FD0EFF /* 83.253.14.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54104F49 /* 84.16.79.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54104F49 /* 84.16.79.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413AFA5 /* 84.19.175.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5413BCD8 /* 84.19.188.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542681C7 /* 84.38.129.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542681C8 /* 84.38.129.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5427706E /* 84.39.112.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5427F142 /* 84.39.241.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54287046 /* 84.40.112.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x542CB64C /* 84.44.182.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54309661 /* 84.48.150.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5435C0F3 /* 84.53.192.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5435E176 /* 84.53.225.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x543C987C /* 84.60.152.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x543ED92D /* 84.62.217.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54497CEB /* 84.73.124.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x544B66CF /* 84.75.102.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54523B39 /* 84.82.59.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54546D27 /* 84.84.109.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5471B335 /* 84.113.179.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54727686 /* 84.114.118.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54767285 /* 84.118.114.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5476A13F /* 84.118.161.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54855135 /* 84.133.81.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5487662F /* 84.135.102.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548A34AC /* 84.138.52.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548C38DB /* 84.140.56.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x548ECAFA /* 84.142.202.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54903C49 /* 84.144.60.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5492ECEE /* 84.146.236.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5494A944 /* 84.148.169.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549A95F1 /* 84.154.149.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549B7C02 /* 84.155.124.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x549E11B2 /* 84.158.17.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54A53079 /* 84.165.48.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54A87446 /* 84.168.116.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54AA479B /* 84.170.71.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54AA8066 /* 84.170.128.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54ACD9B1 /* 84.172.217.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54B8E5F1 /* 84.184.229.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54BEEAC8 /* 84.190.234.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C0A2E5 /* 84.192.162.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C2829B /* 84.194.130.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54C6709A /* 84.198.112.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D18B00 /* 84.209.139.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D4FF24 /* 84.212.255.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D550D6 /* 84.213.80.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54D9B70E /* 84.217.183.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54DC6662 /* 84.220.102.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54E2099E /* 84.226.9.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54E2D8EE /* 84.226.216.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54EF9969 /* 84.239.153.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F03CEA /* 84.240.60.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F50A18 /* 84.245.10.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54F70819 /* 84.247.8.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54FABBCA /* 84.250.187.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54FBCE67 /* 84.251.206.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x54FC7954 /* 84.252.121.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55007D82 /* 85.0.125.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550191E3 /* 85.1.145.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5502D2F7 /* 85.2.210.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC3EE /* 85.10.195.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC423 /* 85.10.196.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC86D /* 85.10.200.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACACF /* 85.10.202.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACB47 /* 85.10.203.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACF4B /* 85.10.207.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x550AF0FA /* 85.10.240.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55114127 /* 85.17.65.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551158AE /* 85.17.88.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551158B1 /* 85.17.88.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55117F81 /* 85.17.127.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55172CAF /* 85.23.44.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5518A9B6 /* 85.24.169.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5518A9B6 /* 85.24.169.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55192B1F /* 85.25.43.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55199F41 /* 85.25.159.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5519D5D3 /* 85.25.213.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x551A721A /* 85.26.114.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5555F11F /* 85.85.241.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5559AC96 /* 85.89.172.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555AF5BA /* 85.90.245.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555B99A3 /* 85.91.153.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555C6C4C /* 85.92.108.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555DDACC /* 85.93.218.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x555DE293 /* 85.93.226.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5577526C /* 85.119.82.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5577528E /* 85.119.82.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55775297 /* 85.119.82.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5583101D /* 85.131.16.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x558FD68F /* 85.143.214.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55901D7B /* 85.144.29.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x559191C9 /* 85.145.145.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55954732 /* 85.149.71.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x559FEDD2 /* 85.159.237.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55A3354B /* 85.163.53.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55A59933 /* 85.165.153.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55A77098 /* 85.167.112.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55A779FA /* 85.167.121.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C2EE83 /* 85.194.238.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3D09A /* 85.195.208.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3E6F9 /* 85.195.230.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3E831 /* 85.195.232.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3E831 /* 85.195.232.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3EBF8 /* 85.195.235.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3EE64 /* 85.195.238.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3F2C2 /* 85.195.242.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3FD3B /* 85.195.253.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C3FD3B /* 85.195.253.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55C53874 /* 85.197.56.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55CC4A8B /* 85.204.74.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55CC79DB /* 85.204.121.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D090A4 /* 85.208.144.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D0930C /* 85.208.147.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19D03 /* 85.209.157.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19D1A /* 85.209.157.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19D1B /* 85.209.157.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19D1C /* 85.209.157.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19E2C /* 85.209.158.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19E73 /* 85.209.158.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19EC7 /* 85.209.158.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19ED1 /* 85.209.158.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19ED2 /* 85.209.158.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19EDC /* 85.209.158.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D19EDD /* 85.209.158.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D41074 /* 85.212.16.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D42660 /* 85.212.38.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D437A3 /* 85.212.55.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D458DC /* 85.212.88.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D46948 /* 85.212.105.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D481CA /* 85.212.129.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D49F4B /* 85.212.159.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D4E6A8 /* 85.212.230.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D612E1 /* 85.214.18.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D61345 /* 85.214.19.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D63440 /* 85.214.52.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D64016 /* 85.214.64.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D65F5E /* 85.214.95.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D661CE /* 85.214.97.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D66427 /* 85.214.100.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6700C /* 85.214.112.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D675B9 /* 85.214.117.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D68D83 /* 85.214.141.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D69810 /* 85.214.152.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D69C1C /* 85.214.156.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6A031 /* 85.214.160.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6A774 /* 85.214.167.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6C4B2 /* 85.214.196.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6DDAF /* 85.214.221.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6FD6B /* 85.214.253.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D758F4 /* 85.215.88.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D86304 /* 85.216.99.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55D89823 /* 85.216.152.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E4106B /* 85.228.16.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E47B45 /* 85.228.123.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E4C785 /* 85.228.199.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E4C785 /* 85.228.199.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E4E8AB /* 85.228.232.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E58329 /* 85.229.131.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E607F5 /* 85.230.7.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E65169 /* 85.230.81.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55E67B17 /* 85.230.123.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55EB1184 /* 85.235.17.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55EB4292 /* 85.235.66.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55EBFA58 /* 85.235.250.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F16ACB /* 85.241.106.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F3FB2E /* 85.243.251.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F4755F /* 85.244.117.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55F76B7D /* 85.247.107.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x55FF02B4 /* 85.255.2.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5600BC31 /* 86.0.188.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56059E60 /* 86.5.158.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x560E518D /* 86.14.81.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5611B54E /* 86.17.181.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5616C335 /* 86.22.195.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563107CB /* 86.49.7.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5634413C /* 86.52.65.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B1526 /* 86.59.21.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B15A3 /* 86.59.21.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7346 /* 86.59.115.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7753 /* 86.59.119.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7758 /* 86.59.119.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56498F2B /* 86.73.143.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x564B56A9 /* 86.75.86.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56506CE4 /* 86.80.108.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5650FEAB /* 86.80.254.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x565633FD /* 86.86.51.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56690585 /* 86.105.5.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5669D482 /* 86.105.212.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x566F98F0 /* 86.111.152.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56730FF8 /* 86.115.15.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567B34BC /* 86.123.52.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567C0B90 /* 86.124.11.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567E668B /* 86.126.102.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567FC0DF /* 86.127.192.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x567FC0DF /* 86.127.192.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x569618B2 /* 86.150.24.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56A1753D /* 86.161.117.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56CECB5F /* 86.206.203.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56E37963 /* 86.227.121.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56EE1E35 /* 86.238.30.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56F340E8 /* 86.243.64.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x56FAF2AE /* 86.250.242.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x570191D6 /* 87.1.145.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x570E5D3C /* 87.14.93.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x570F1E1D /* 87.15.30.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x570F65C7 /* 87.15.101.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57131077 /* 87.19.16.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5715AE88 /* 87.21.174.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57365AC6 /* 87.54.90.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x573D5F85 /* 87.61.95.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5747888D /* 87.71.136.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x574849E7 /* 87.72.73.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x575C1E41 /* 87.92.30.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x575CB1F6 /* 87.92.177.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x575CDE70 /* 87.92.222.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762870D /* 87.98.135.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762B905 /* 87.98.185.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5762F520 /* 87.98.245.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5764FFF7 /* 87.100.255.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5767F1CA /* 87.103.241.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57685465 /* 87.104.84.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576A7EC3 /* 87.106.126.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576AC138 /* 87.106.193.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x576EEDAB /* 87.110.237.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5776609A /* 87.118.96.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57766E1B /* 87.118.110.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57766E71 /* 87.118.110.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767088 /* 87.118.112.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5776740C /* 87.118.116.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5776745A /* 87.118.116.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767467 /* 87.118.116.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767A1E /* 87.118.122.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57767A33 /* 87.118.122.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577824D2 /* 87.120.36.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577824D4 /* 87.120.36.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778254F /* 87.120.37.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778FE62 /* 87.120.254.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778FE69 /* 87.120.254.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5778FE72 /* 87.120.254.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5779342F /* 87.121.52.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577AE107 /* 87.122.225.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577B7800 /* 87.123.120.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577B95E5 /* 87.123.149.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577BB3AF /* 87.123.179.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577BE367 /* 87.123.227.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x577BEB9F /* 87.123.235.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x578C4951 /* 87.140.73.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5791ADBB /* 87.145.173.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5791B547 /* 87.145.181.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57928E12 /* 87.146.142.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57959E6D /* 87.149.158.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5799CC19 /* 87.153.204.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579AD4A4 /* 87.154.212.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x579F9B53 /* 87.159.155.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A0F7E6 /* 87.160.247.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A7406D /* 87.167.64.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A8B98D /* 87.168.185.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57A92662 /* 87.169.38.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57AE7E5D /* 87.174.126.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B344DA /* 87.179.68.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B522B2 /* 87.181.34.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B557C2 /* 87.181.87.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B59FFE /* 87.181.159.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B6E65D /* 87.182.230.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57B924A4 /* 87.185.36.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57C1D00E /* 87.193.208.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57D85945 /* 87.216.89.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57DABA08 /* 87.218.186.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57DC1CAA /* 87.220.28.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57DDB59F /* 87.221.181.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57E57317 /* 87.229.115.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57E73063 /* 87.231.48.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECC217 /* 87.236.194.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECC3FD /* 87.236.195.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57F557DC /* 87.245.87.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57F56464 /* 87.245.100.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57F76FDE /* 87.247.111.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57F80729 /* 87.248.7.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57F80729 /* 87.248.7.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57FD8E48 /* 87.253.142.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x57FEBF2E /* 87.254.191.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58055D0D /* 88.5.93.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5806AD07 /* 88.6.173.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x581B7A64 /* 88.27.122.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58429C72 /* 88.66.156.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58452CE0 /* 88.69.44.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58485793 /* 88.72.87.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x584AD0C5 /* 88.74.208.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58501456 /* 88.80.20.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58567363 /* 88.86.115.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58599E2C /* 88.89.158.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x585A800C /* 88.90.128.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x585AA6BD /* 88.90.166.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x585B7012 /* 88.91.112.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5862C5DA /* 88.98.197.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58630432 /* 88.99.4.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58630E4C /* 88.99.14.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58631FBA /* 88.99.31.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58632608 /* 88.99.38.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586326E5 /* 88.99.38.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58633DC9 /* 88.99.61.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58634C0A /* 88.99.76.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58635011 /* 88.99.80.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58635076 /* 88.99.80.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58635461 /* 88.99.84.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58635609 /* 88.99.86.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58635D50 /* 88.99.93.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586361D6 /* 88.99.97.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x586365CF /* 88.99.101.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5863AB4B /* 88.99.171.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58721869 /* 88.114.24.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x587316F4 /* 88.115.22.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58733DFF /* 88.115.61.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5877AA96 /* 88.119.170.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5882681B /* 88.130.104.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58863D60 /* 88.134.61.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58863F06 /* 88.134.63.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58A01347 /* 88.160.19.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C4A740 /* 88.196.167.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60AFA /* 88.198.10.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60C42 /* 88.198.12.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60EBE /* 88.198.14.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6182F /* 88.198.24.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C62049 /* 88.198.32.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C623BC /* 88.198.35.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C63454 /* 88.198.52.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C64689 /* 88.198.70.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C65B4A /* 88.198.91.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66521 /* 88.198.101.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C67019 /* 88.198.112.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6A53C /* 88.198.165.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6ACCE /* 88.198.172.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6B17A /* 88.198.177.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6CE1F /* 88.198.206.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6CF30 /* 88.198.207.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6E385 /* 88.198.227.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D0794E /* 88.208.121.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D60950 /* 88.214.9.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D62325 /* 88.214.35.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D62327 /* 88.214.35.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D62328 /* 88.214.35.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D62330 /* 88.214.35.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D6233D /* 88.214.35.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D6233E /* 88.214.35.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D62357 /* 88.214.35.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D97535 /* 88.217.117.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58D98CDE /* 88.217.140.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58DA5C7E /* 88.218.92.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58DA5C91 /* 88.218.92.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58DA5C92 /* 88.218.92.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x58DA5C93 /* 88.218.92.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x590C71F5 /* 89.12.113.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x590CC110 /* 89.12.193.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x590E8395 /* 89.14.131.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5916605A /* 89.22.96.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5919210D /* 89.25.33.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x591B00EC /* 89.27.0.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x591F393A /* 89.31.57.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5921C385 /* 89.33.195.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5921F672 /* 89.33.246.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59221B18 /* 89.34.27.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59232221 /* 89.35.34.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592327B9 /* 89.35.39.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5924DA7F /* 89.36.218.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59274321 /* 89.39.67.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592769E4 /* 89.39.105.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59280DD9 /* 89.40.13.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59288F94 /* 89.40.143.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5928B56B /* 89.40.181.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5929AD8A /* 89.41.173.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592D2E6D /* 89.45.46.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592D2EE3 /* 89.45.46.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592D2EF6 /* 89.45.46.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x592E6447 /* 89.46.100.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59456557 /* 89.69.101.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5946F018 /* 89.70.240.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594A54D5 /* 89.74.84.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594B2AB9 /* 89.75.42.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594E1098 /* 89.78.16.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x594E2988 /* 89.78.41.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5966C9F1 /* 89.102.201.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x596B394F /* 89.107.57.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5987F0A2 /* 89.135.240.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59900C11 /* 89.144.12.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59987A1A /* 89.152.122.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A11A4E /* 89.161.26.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38019 /* 89.163.128.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3801A /* 89.163.128.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3801C /* 89.163.128.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3801D /* 89.163.128.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38F08 /* 89.163.143.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A38F08 /* 89.163.143.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3CCFE /* 89.163.204.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3CCFE /* 89.163.204.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D80B /* 89.163.216.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DC80 /* 89.163.220.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DC91 /* 89.163.220.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DC96 /* 89.163.220.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DCA2 /* 89.163.220.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DCA7 /* 89.163.220.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0BB /* 89.163.224.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0FA /* 89.163.224.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E173 /* 89.163.225.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E191 /* 89.163.225.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E1A2 /* 89.163.225.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E1AB /* 89.163.225.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E1AC /* 89.163.225.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E1B0 /* 89.163.225.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E1C3 /* 89.163.225.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59A403D3 /* 89.164.3.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BB8F1F /* 89.187.143.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59BFD901 /* 89.191.217.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59D41A24 /* 89.212.26.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59D9661E /* 89.217.102.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59DF6479 /* 89.223.100.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59E92B4A /* 89.233.43.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EA9DFE /* 89.234.157.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EA9DFE /* 89.234.157.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EE4B40 /* 89.238.75.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59EFD47C /* 89.239.212.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F4514D /* 89.244.81.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F50DCA /* 89.245.13.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F5A564 /* 89.245.165.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F5A585 /* 89.245.165.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F94199 /* 89.249.65.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x59F941F9 /* 89.249.65.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A016850 /* 90.1.104.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A2E1F24 /* 90.46.31.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A2E1F24 /* 90.46.31.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A41E34D /* 90.65.227.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A4F04B9 /* 90.79.4.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A59F0C5 /* 90.89.240.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A5F33B0 /* 90.95.51.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A67E3C4 /* 90.103.227.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A703906 /* 90.112.57.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A925A41 /* 90.146.90.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A92B0DD /* 90.146.176.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5A9B0506 /* 90.155.5.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABA1310 /* 90.186.19.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABB34E9 /* 90.187.52.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABB34E9 /* 90.187.52.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABBDD6D /* 90.187.221.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ABBFEAD /* 90.187.254.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ACB4318 /* 90.203.67.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AD333BC /* 90.211.51.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE14147 /* 90.225.65.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE74B05 /* 90.231.75.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AFB454F /* 90.251.69.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5AFFF47F /* 90.255.244.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B05DF63 /* 91.5.223.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0774C3 /* 91.7.116.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0E520B /* 91.14.82.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0F54D5 /* 91.15.84.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B1251DE /* 91.18.81.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B131CA5 /* 91.19.28.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B211EBA /* 91.33.30.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B239F50 /* 91.35.159.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B239F50 /* 91.35.159.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B25DB05 /* 91.37.219.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B279502 /* 91.39.149.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2B36BD /* 91.43.54.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2F2004 /* 91.47.32.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2FCD56 /* 91.47.205.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B33FA73 /* 91.51.250.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B371070 /* 91.55.16.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3954F2 /* 91.57.84.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3A8FC9 /* 91.58.143.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3C7480 /* 91.60.116.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3DFC33 /* 91.61.252.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3E139D /* 91.62.19.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3F2BBF /* 91.63.43.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B40274A /* 91.64.39.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B415F21 /* 91.65.95.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B418DB9 /* 91.65.141.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B420909 /* 91.66.9.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B43BC60 /* 91.67.188.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B4DA8BA /* 91.77.168.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B59BCD7 /* 91.89.188.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B5A2C1B /* 91.90.44.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B5C6D2B /* 91.92.109.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6AAA74 /* 91.106.170.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6D1594 /* 91.109.21.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79320E /* 91.121.50.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B794CCF /* 91.121.76.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795219 /* 91.121.82.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795284 /* 91.121.82.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79563B /* 91.121.86.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B798FC7 /* 91.121.143.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799341 /* 91.121.147.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79A006 /* 91.121.160.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79B506 /* 91.121.181.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7A640D /* 91.122.100.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7EE7DC /* 91.126.231.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B843C09 /* 91.132.60.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B84907D /* 91.132.144.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8491F5 /* 91.132.145.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B849287 /* 91.132.146.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8493A8 /* 91.132.147.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B86D685 /* 91.134.214.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B88A437 /* 91.136.164.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B893E0F /* 91.137.62.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8AB86D /* 91.138.184.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5093 /* 91.143.80.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F50E6 /* 91.143.80.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F511B /* 91.143.81.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F51D4 /* 91.143.81.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5364 /* 91.143.83.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5534 /* 91.143.85.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5733 /* 91.143.87.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5788 /* 91.143.87.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F5802 /* 91.143.88.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8F583E /* 91.143.88.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B917B16 /* 91.145.123.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B948D75 /* 91.148.141.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B949349 /* 91.148.147.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B95E178 /* 91.149.225.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B95E183 /* 91.149.225.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B975D2E /* 91.151.93.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5B9BF1E1 /* 91.155.241.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BA03715 /* 91.160.55.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BA8A612 /* 91.168.166.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BADCAC3 /* 91.173.202.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBFB30A /* 91.191.179.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC066A0 /* 91.192.102.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06709 /* 91.192.103.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0670A /* 91.192.103.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0670B /* 91.192.103.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0670F /* 91.192.103.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06710 /* 91.192.103.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06711 /* 91.192.103.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06718 /* 91.192.103.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06719 /* 91.192.103.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0671A /* 91.192.103.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0671B /* 91.192.103.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06721 /* 91.192.103.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06722 /* 91.192.103.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06723 /* 91.192.103.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0672A /* 91.192.103.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0672B /* 91.192.103.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0672C /* 91.192.103.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC06732 /* 91.192.103.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC0E092 /* 91.192.224.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC1EC10 /* 91.193.236.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC20B08 /* 91.194.11.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC25459 /* 91.194.84.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC35C11 /* 91.195.92.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC36386 /* 91.195.99.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC36388 /* 91.195.99.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC7DF08 /* 91.199.223.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC7DF09 /* 91.199.223.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC7DF15 /* 91.199.223.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC7DF16 /* 91.199.223.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC7DF17 /* 91.199.223.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC9411D /* 91.201.65.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC9415B /* 91.201.65.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB0592 /* 91.203.5.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB05A5 /* 91.203.5.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB90C2 /* 91.203.144.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB9172 /* 91.203.145.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB9174 /* 91.203.145.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCB927E /* 91.203.146.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCC06C3 /* 91.204.6.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCDBA92 /* 91.205.186.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCF3C30 /* 91.207.60.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD0B87B /* 91.208.184.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50859 /* 91.213.8.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50882 /* 91.213.8.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD5E93C /* 91.213.233.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD5E98A /* 91.213.233.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD6A945 /* 91.214.169.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDACB3B /* 91.218.203.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDB1CD3 /* 91.219.28.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED16 /* 91.219.237.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED4B /* 91.219.237.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED75 /* 91.219.237.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEE78 /* 91.219.238.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEE94 /* 91.219.238.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEEDD /* 91.219.238.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEF5C /* 91.219.239.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDC9164 /* 91.220.145.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDCDC05 /* 91.220.220.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDD39B3 /* 91.221.57.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDF529A /* 91.223.82.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDF52C5 /* 91.223.82.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE168CB /* 91.225.104.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE43556 /* 91.228.53.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE54C7C /* 91.229.76.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE97433 /* 91.233.116.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE97477 /* 91.233.116.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEA1337 /* 91.234.19.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEC7457 /* 91.236.116.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF0E5C3 /* 91.240.229.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF355A8 /* 91.243.85.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF4B555 /* 91.244.181.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFA5134 /* 91.250.81.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFA629E /* 91.250.98.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF20C /* 91.250.242.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF278 /* 91.250.242.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF2FA /* 91.250.242.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF2FB /* 91.250.242.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF2FC /* 91.250.242.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C179C45 /* 92.23.156.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C1D7DA6 /* 92.29.125.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C20259B /* 92.32.37.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C208B7D /* 92.32.139.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C2281E8 /* 92.34.129.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C2284C6 /* 92.34.132.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C229716 /* 92.34.151.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C23183C /* 92.35.24.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C23242A /* 92.35.36.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C234516 /* 92.35.69.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C23A770 /* 92.35.167.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C26810E /* 92.38.129.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C269882 /* 92.38.152.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C26A315 /* 92.38.163.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C26A353 /* 92.38.163.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C26B883 /* 92.38.184.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C326996 /* 92.50.105.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3C2499 /* 92.60.36.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3C2569 /* 92.60.37.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3F6F53 /* 92.63.111.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4B0D62 /* 92.75.13.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C5C2133 /* 92.92.33.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C642562 /* 92.100.37.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6F04B1 /* 92.111.4.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C74829F /* 92.116.130.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C748EE8 /* 92.116.142.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C74978B /* 92.116.151.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C74BE02 /* 92.116.190.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C74CB6D /* 92.116.203.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C757420 /* 92.117.116.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C758FF1 /* 92.117.143.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5C75AFE1 /* 92.117.175.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC9C33B /* 92.201.195.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD0DDF4 /* 92.208.221.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD30F77 /* 92.211.15.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDB70C1 /* 92.219.112.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDC008B /* 92.220.0.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDD1EE7 /* 92.221.30.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE4A3A /* 92.222.74.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE544C /* 92.222.84.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE5C0A /* 92.222.92.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEAC38 /* 92.222.172.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEB40A /* 92.222.180.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF41F1 /* 92.223.65.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF48A8 /* 92.223.72.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF4F78 /* 92.223.79.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF5D90 /* 92.223.93.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF5D91 /* 92.223.93.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF5DFA /* 92.223.93.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF6975 /* 92.223.105.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF69AE /* 92.223.105.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDF6D31 /* 92.223.109.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE8D820 /* 92.232.216.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF2E5D7 /* 92.242.229.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF41F1C /* 92.244.31.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF65485 /* 92.246.84.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF77AF5 /* 92.247.122.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF98F77 /* 92.249.143.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF98F77 /* 92.249.143.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFC5071 /* 92.252.80.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFFB08A /* 92.255.176.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D08EFD0 /* 93.8.239.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D19B3EC /* 93.25.179.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D1F0DA3 /* 93.31.13.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D28075E /* 93.40.7.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D299575 /* 93.41.149.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D31F52A /* 93.49.245.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D387516 /* 93.56.117.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D4286DB /* 93.66.134.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D484F40 /* 93.72.79.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D51FD2B /* 93.81.253.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5AC8B5 /* 93.90.200.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5CCDF8 /* 93.92.205.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5D2EB4 /* 93.93.46.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F580D /* 93.95.88.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64A6 /* 93.95.100.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64AA /* 93.95.100.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5F64CA /* 93.95.100.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68AAF1 /* 93.104.170.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68BCAC /* 93.104.188.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D13D /* 93.104.209.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D502 /* 93.104.213.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D731AB5 /* 93.115.26.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73548F /* 93.115.84.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735604 /* 93.115.86.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735606 /* 93.115.86.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735608 /* 93.115.86.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735B42 /* 93.115.91.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735F26 /* 93.115.95.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73600F /* 93.115.96.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7361F2 /* 93.115.97.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73F132 /* 93.115.241.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73F1C2 /* 93.115.241.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D762033 /* 93.118.32.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7620C5 /* 93.118.32.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7FEFFB /* 93.127.239.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5D830968 /* 93.131.9.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DA0C726 /* 93.160.199.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAE5F10 /* 93.174.95.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAE791F /* 93.174.121.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB1407B /* 93.177.64.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB1432B /* 93.177.67.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB14347 /* 93.177.67.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49A5E /* 93.180.154.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49D9A /* 93.180.157.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB4B2D8 /* 93.180.178.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB501A1 /* 93.181.1.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBACA20 /* 93.186.202.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBE8E92 /* 93.190.142.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBE8F29 /* 93.190.143.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCCB09F /* 93.204.176.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCDD891 /* 93.205.216.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCEE9BC /* 93.206.233.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD3ECAE /* 93.211.236.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD4C11F /* 93.212.193.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD6E3AD /* 93.214.227.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD790D5 /* 93.215.144.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDA4731 /* 93.218.71.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDA5955 /* 93.218.89.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDB2FA4 /* 93.219.47.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDF314F /* 93.223.49.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E10689F /* 94.16.104.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E106AC0 /* 94.16.106.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E106D29 /* 94.16.109.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E106F55 /* 94.16.111.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1072FE /* 94.16.114.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107489 /* 94.16.116.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107489 /* 94.16.116.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107617 /* 94.16.118.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107617 /* 94.16.118.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1076FA /* 94.16.118.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1076FA /* 94.16.118.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107914 /* 94.16.121.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E10795B /* 94.16.121.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E10796F /* 94.16.121.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107A3D /* 94.16.122.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107A41 /* 94.16.122.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107ADE /* 94.16.122.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107B43 /* 94.16.123.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107BA9 /* 94.16.123.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E107BAB /* 94.16.123.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E108B97 /* 94.16.139.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E13D94C /* 94.19.217.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E144A56 /* 94.20.74.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E15788F /* 94.21.120.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17113A /* 94.23.17.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E171DCC /* 94.23.29.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E179651 /* 94.23.150.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17C286 /* 94.23.194.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17C363 /* 94.23.195.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17DE48 /* 94.23.222.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17F72A /* 94.23.247.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17F89E /* 94.23.248.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1A49A2 /* 94.26.73.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1A49A2 /* 94.26.73.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1B8CC1 /* 94.27.140.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1BBAB0 /* 94.27.186.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E20420F /* 94.32.66.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E405C6E /* 94.64.92.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E42737A /* 94.66.115.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E49DFF3 /* 94.73.223.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4BC2DD /* 94.75.194.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4F9D4E /* 94.79.157.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E64061B /* 94.100.6.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E640647 /* 94.100.6.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E640648 /* 94.100.6.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E66334E /* 94.102.51.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E675955 /* 94.103.89.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E71D317 /* 94.113.211.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E729BF2 /* 94.114.155.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E72C188 /* 94.114.193.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E72C188 /* 94.114.193.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E820AFB /* 94.130.10.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E821BCD /* 94.130.27.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E822864 /* 94.130.40.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E823932 /* 94.130.57.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8245AB /* 94.130.69.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E824C84 /* 94.130.76.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E826185 /* 94.130.97.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E826270 /* 94.130.98.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E826A43 /* 94.130.106.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E826CD6 /* 94.130.108.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82810F /* 94.130.129.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82AFCC /* 94.130.175.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82B4DC /* 94.130.180.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82B568 /* 94.130.181.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82B70D /* 94.130.183.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82B81C /* 94.130.184.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82BB91 /* 94.130.187.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82C8A7 /* 94.130.200.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E82F66A /* 94.130.246.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C723E /* 94.140.114.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7249 /* 94.140.114.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C724A /* 94.140.114.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C726F /* 94.140.114.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7298 /* 94.140.114.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C72B1 /* 94.140.114.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C72BE /* 94.140.114.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C72DD /* 94.140.114.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C72FF /* 94.140.114.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7310 /* 94.140.115.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7372 /* 94.140.115.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7372 /* 94.140.115.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7419 /* 94.140.116.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8C7882 /* 94.140.120.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF18A /* 94.142.241.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF1C2 /* 94.142.241.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF1C2 /* 94.142.241.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF1E2 /* 94.142.241.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF410 /* 94.142.244.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF410 /* 94.142.244.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9A9F60 /* 94.154.159.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9B312F /* 94.155.49.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9C4D18 /* 94.156.77.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9C800A /* 94.156.128.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9CAF78 /* 94.156.175.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB12866 /* 94.177.40.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC7D587 /* 94.199.213.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC7D6E5 /* 94.199.214.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED429ED /* 94.212.41.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDB1F1D /* 94.219.31.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDC5070 /* 94.220.80.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE18A86 /* 94.225.138.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE20662 /* 94.226.6.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE24C33 /* 94.226.76.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE32FCA /* 94.227.47.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE6D093 /* 94.230.208.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE6D093 /* 94.230.208.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE6D094 /* 94.230.208.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23B2F /* 94.242.59.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23C16 /* 94.242.60.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF9C0CB /* 94.249.192.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFD8A22 /* 94.253.138.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE4A86 /* 94.254.74.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE5536 /* 94.254.85.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F187ECE /* 95.24.126.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1A15BD /* 95.26.21.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1BF5FD /* 95.27.245.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F215D8C /* 95.33.93.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F2A66C3 /* 95.42.102.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F3461DD /* 95.52.97.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F350E01 /* 95.53.14.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F432637 /* 95.67.38.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F510FFF /* 95.81.15.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F548C24 /* 95.84.140.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F54A42B /* 95.84.164.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5508E2 /* 95.85.8.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F58FD13 /* 95.88.253.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5A6040 /* 95.90.96.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B0138 /* 95.91.1.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B596E /* 95.91.89.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5BACD9 /* 95.91.172.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F69CE5A /* 95.105.206.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6D7A34 /* 95.109.122.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6E9210 /* 95.110.146.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6FE6B2 /* 95.111.230.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6FF607 /* 95.111.246.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6FFCE6 /* 95.111.252.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6FFE09 /* 95.111.254.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6FFFC1 /* 95.111.255.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F702B60 /* 95.112.43.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F76A77E /* 95.118.167.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F802BA4 /* 95.128.43.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8537D2 /* 95.133.55.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D230F /* 95.141.35.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D247F /* 95.141.36.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D5392 /* 95.141.83.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D5392 /* 95.141.83.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D539B /* 95.141.83.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D539B /* 95.141.83.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EA13F /* 95.142.161.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EA17E /* 95.142.161.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACD6 /* 95.143.172.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FC17D /* 95.143.193.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F991F08 /* 95.153.31.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F991F1A /* 95.153.31.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9A1849 /* 95.154.24.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9A19A7 /* 95.154.25.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9AC21F /* 95.154.194.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9BD25D /* 95.155.210.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9C5F08 /* 95.156.95.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA428A9 /* 95.164.40.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA43196 /* 95.164.49.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA58D2B /* 95.165.141.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA58F70 /* 95.165.143.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA5940C /* 95.165.148.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA8AA2B /* 95.168.170.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FAAE130 /* 95.170.225.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FACEB4A /* 95.172.235.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB3B11B /* 95.179.177.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB3CBCE /* 95.179.203.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB3D625 /* 95.179.214.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB3ED2F /* 95.179.237.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB3F758 /* 95.179.247.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB5A42E /* 95.181.164.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB7337E /* 95.183.51.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FB734B6 /* 95.183.52.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD029F3 /* 95.208.41.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD07B02 /* 95.208.123.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD376C2 /* 95.211.118.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38817 /* 95.211.136.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38A07 /* 95.211.138.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38A33 /* 95.211.138.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD39363 /* 95.211.147.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3CD8A /* 95.211.205.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3D248 /* 95.211.210.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD6345C /* 95.214.52.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D8A /* 95.215.45.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72DBC /* 95.215.45.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD801FB /* 95.216.1.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD802AC /* 95.216.2.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD803A6 /* 95.216.3.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD803AB /* 95.216.3.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD80ECE /* 95.216.14.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD80ECE /* 95.216.14.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD80EDE /* 95.216.14.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD80EDE /* 95.216.14.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD80F10 /* 95.216.15.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD813CE /* 95.216.19.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD813CE /* 95.216.19.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD813CF /* 95.216.19.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD813CF /* 95.216.19.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD81B69 /* 95.216.27.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8211E /* 95.216.33.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8213A /* 95.216.33.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD82354 /* 95.216.35.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD86237 /* 95.216.98.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8639C /* 95.216.99.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD865F7 /* 95.216.101.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD87355 /* 95.216.115.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD87355 /* 95.216.115.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD873AD /* 95.216.115.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88822 /* 95.216.136.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8882E /* 95.216.136.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88987 /* 95.216.137.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88A10 /* 95.216.138.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88B10 /* 95.216.139.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88C1C /* 95.216.140.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88C9F /* 95.216.140.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88CEF /* 95.216.140.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD88D13 /* 95.216.141.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89071 /* 95.216.144.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89101 /* 95.216.145.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8917F /* 95.216.145.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89275 /* 95.216.146.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89276 /* 95.216.146.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD894EA /* 95.216.148.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89819 /* 95.216.152.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89A09 /* 95.216.154.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89A87 /* 95.216.154.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89A8B /* 95.216.154.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89BBF /* 95.216.155.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD89F46 /* 95.216.159.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8A26D /* 95.216.162.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8A885 /* 95.216.168.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8A901 /* 95.216.169.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8AA44 /* 95.216.170.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8B235 /* 95.216.178.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8BB5B /* 95.216.187.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8BE62 /* 95.216.190.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8C016 /* 95.216.192.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8C127 /* 95.216.193.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8C552 /* 95.216.197.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8C6FC /* 95.216.198.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8C9A1 /* 95.216.201.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8CCFE /* 95.216.204.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8D1C1 /* 95.216.209.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8D4DE /* 95.216.212.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD8DA9F /* 95.216.218.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90090 /* 95.217.0.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90247 /* 95.217.2.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9029C /* 95.217.2.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD902CE /* 95.217.2.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9041E /* 95.217.4.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90558 /* 95.217.5.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9065E /* 95.217.6.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90AFC /* 95.217.10.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90D16 /* 95.217.13.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90E11 /* 95.217.14.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90E69 /* 95.217.14.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90F11 /* 95.217.15.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD90F7D /* 95.217.15.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD910D4 /* 95.217.16.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD913D0 /* 95.217.19.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD91490 /* 95.217.20.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD915E9 /* 95.217.21.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD91602 /* 95.217.22.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD91C70 /* 95.217.28.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD92A32 /* 95.217.42.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD92A5E /* 95.217.42.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD93E04 /* 95.217.62.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD94E54 /* 95.217.78.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD953B6 /* 95.217.83.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD96ACF /* 95.217.106.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD98368 /* 95.217.131.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD98417 /* 95.217.132.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD98559 /* 95.217.133.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD98737 /* 95.217.135.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9873C /* 95.217.135.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD999EF /* 95.217.153.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD99BEB /* 95.217.155.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD99D01 /* 95.217.157.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9A03B /* 95.217.160.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9A224 /* 95.217.162.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9A2A6 /* 95.217.162.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9A488 /* 95.217.164.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9A51B /* 95.217.165.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9A5A9 /* 95.217.165.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9B352 /* 95.217.179.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9B4D8 /* 95.217.180.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9B5E4 /* 95.217.181.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9B715 /* 95.217.183.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9BA25 /* 95.217.186.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9BD5E /* 95.217.189.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9BD9B /* 95.217.189.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9BF09 /* 95.217.191.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9BFA6 /* 95.217.191.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9CB85 /* 95.217.203.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9D3E0 /* 95.217.211.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9D3E7 /* 95.217.211.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9D3ED /* 95.217.211.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9D49A /* 95.217.212.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9D9C6 /* 95.217.217.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9D9DA /* 95.217.217.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9DD4F /* 95.217.221.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9DF36 /* 95.217.223.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9EB94 /* 95.217.235.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9ED8E /* 95.217.237.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9EF19 /* 95.217.239.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9EF6F /* 95.217.239.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD9F8A9 /* 95.217.248.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDE3102 /* 95.222.49.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDE6195 /* 95.222.97.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FE931B1 /* 95.233.49.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FEA2635 /* 95.234.38.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x5FF4AF40 /* 95.244.175.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x602118C0 /* 96.33.24.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x602B5268 /* 96.43.82.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x604144C1 /* 96.65.68.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60518354 /* 96.81.131.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E69DB /* 96.126.105.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x607E6EA3 /* 96.126.110.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60EE5541 /* 96.238.85.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60FC7084 /* 96.252.112.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60FD4E6C /* 96.253.78.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x60FFD124 /* 96.255.209.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6145DA26 /* 97.69.218.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x614AEDC4 /* 97.74.237.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x61576D71 /* 97.87.109.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x615DCA16 /* 97.93.202.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8418 /* 97.107.132.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8965 /* 97.107.137.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8AA2 /* 97.107.138.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8B1C /* 97.107.139.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8B6C /* 97.107.139.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x620BE427 /* 98.11.228.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x620EA6F8 /* 98.14.166.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x622672AC /* 98.38.114.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x627F6026 /* 98.127.96.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6280AD01 /* 98.128.173.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6280C064 /* 98.128.192.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62A2F9F4 /* 98.162.249.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62C14538 /* 98.193.69.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62CFCE36 /* 98.207.206.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62D97CEF /* 98.217.124.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62E19D4E /* 98.225.157.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x62EABDD8 /* 98.234.189.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x632F1D42 /* 99.47.29.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x637AC9F4 /* 99.122.201.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63832D8F /* 99.131.45.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6396E515 /* 99.150.229.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63A37A45 /* 99.163.122.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63B00FA9 /* 99.176.15.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63C788F0 /* 99.199.136.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x63F1A0BD /* 99.241.160.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6408EDC9 /* 100.8.237.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640E17D0 /* 100.14.23.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640E9FFE /* 100.14.159.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640F8B7B /* 100.15.139.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x640FF937 /* 100.15.249.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6410DE35 /* 100.16.222.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65377D0A /* 101.55.125.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65635FC9 /* 101.99.95.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65649293 /* 101.100.146.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6564A07A /* 101.100.160.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65714061 /* 101.113.64.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65714E14 /* 101.113.78.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x65A14664 /* 101.161.70.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x66827051 /* 102.130.112.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67033C43 /* 103.3.60.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67033EA8 /* 103.3.62.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67094C5C /* 103.9.76.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67101AA0 /* 103.16.26.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6719E736 /* 103.25.231.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x671C345D /* 103.28.52.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x671FFB70 /* 103.31.251.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67234A4A /* 103.35.74.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67494120 /* 103.73.65.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x674943C6 /* 103.73.67.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x674BBE0B /* 103.75.190.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67662E39 /* 103.102.46.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67882B8D /* 103.136.43.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67882B8D /* 103.136.43.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67995C5D /* 103.153.92.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67C8D242 /* 103.200.210.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67D44676 /* 103.212.70.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67E36348 /* 103.227.99.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67E4359B /* 103.228.53.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67EADCC3 /* 103.234.220.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67ECC958 /* 103.236.201.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67ECC96E /* 103.236.201.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67F91CC3 /* 103.249.28.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67FD2962 /* 103.253.41.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67FD296F /* 103.253.41.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x67FD4971 /* 103.253.73.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6825C166 /* 104.37.193.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6825FB7C /* 104.37.251.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6839E71A /* 104.57.231.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6839E71A /* 104.57.231.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6839E71B /* 104.57.231.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6839E71B /* 104.57.231.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68830BD6 /* 104.131.11.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883BA20 /* 104.131.186.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6883CE17 /* 104.131.206.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6894FA38 /* 104.148.250.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689581D2 /* 104.149.129.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958262 /* 104.149.130.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689582DA /* 104.149.130.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6895838A /* 104.149.131.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958466 /* 104.149.132.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958676 /* 104.149.134.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6895876E /* 104.149.135.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6895876E /* 104.149.135.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958956 /* 104.149.137.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958956 /* 104.149.137.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958A7A /* 104.149.138.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958B2A /* 104.149.139.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958C8A /* 104.149.140.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958C8B /* 104.149.140.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958C8C /* 104.149.140.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958C8D /* 104.149.140.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958C8E /* 104.149.140.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958CCA /* 104.149.140.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958CEA /* 104.149.140.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958CF2 /* 104.149.140.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958CF6 /* 104.149.140.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68958CFE /* 104.149.140.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6898BDD6 /* 104.152.189.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6898D182 /* 104.152.209.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6898D1CA /* 104.152.209.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6898D24D /* 104.152.210.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6898D393 /* 104.152.211.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6898D3E3 /* 104.152.211.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x689DC2EB /* 104.157.194.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68A8CD6A /* 104.168.205.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68AC4A54 /* 104.172.74.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68B1DD35 /* 104.177.221.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68B2A8F2 /* 104.178.168.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68B803E6 /* 104.184.3.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68B803E6 /* 104.184.3.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C2E4F0 /* 104.194.228.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C2EB68 /* 104.194.235.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68C81520 /* 104.200.21.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CEED17 /* 104.206.237.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CEED18 /* 104.206.237.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF92D0 /* 104.207.146.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF9565 /* 104.207.149.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68D9FA12 /* 104.217.250.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DA3F48 /* 104.218.63.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DA3F49 /* 104.218.63.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DA3F4B /* 104.218.63.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DA3F4C /* 104.218.63.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DBFA94 /* 104.219.250.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF5E42 /* 104.223.94.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68DF9999 /* 104.223.153.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC3410 /* 104.236.52.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC575A /* 104.236.87.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED850A /* 104.237.133.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED8BEE /* 104.237.139.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED9086 /* 104.237.144.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED98F5 /* 104.237.152.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED9A9C /* 104.237.154.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EEA272 /* 104.238.162.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EEA76F /* 104.238.167.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68EEBC62 /* 104.238.188.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44824 /* 104.244.72.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44824 /* 104.244.72.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44849 /* 104.244.72.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44863 /* 104.244.72.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44873 /* 104.244.72.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44889 /* 104.244.72.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44898 /* 104.244.72.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F448A4 /* 104.244.72.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F448A8 /* 104.244.72.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F448A8 /* 104.244.72.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F448B4 /* 104.244.72.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F448BC /* 104.244.72.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F448F8 /* 104.244.72.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4490D /* 104.244.73.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4490D /* 104.244.73.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4492B /* 104.244.73.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4492E /* 104.244.73.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44955 /* 104.244.73.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4495D /* 104.244.73.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4495D /* 104.244.73.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44983 /* 104.244.73.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F449AF /* 104.244.73.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F449CD /* 104.244.73.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F449CD /* 104.244.73.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A1C /* 104.244.74.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A37 /* 104.244.74.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A39 /* 104.244.74.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A61 /* 104.244.74.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A79 /* 104.244.74.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44A79 /* 104.244.74.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44AD3 /* 104.244.74.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44AD3 /* 104.244.74.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44AEB /* 104.244.74.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44B10 /* 104.244.75.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44B21 /* 104.244.75.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44B50 /* 104.244.75.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44B9B /* 104.244.75.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44C0D /* 104.244.76.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44C18 /* 104.244.76.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44C45 /* 104.244.76.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44CAA /* 104.244.76.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44CB8 /* 104.244.76.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44CBD /* 104.244.76.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D35 /* 104.244.77.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D5F /* 104.244.77.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D65 /* 104.244.77.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D65 /* 104.244.77.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D6F /* 104.244.77.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D7A /* 104.244.77.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D7A /* 104.244.77.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44D9F /* 104.244.77.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44DC7 /* 104.244.77.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44DFA /* 104.244.77.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44E12 /* 104.244.78.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44EE7 /* 104.244.78.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44EE9 /* 104.244.78.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44F19 /* 104.244.79.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44F4B /* 104.244.79.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44F79 /* 104.244.79.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44FBB /* 104.244.79.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44FC4 /* 104.244.79.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44FC4 /* 104.244.79.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F81B25 /* 104.248.27.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F85870 /* 104.248.88.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x68F876F1 /* 104.248.118.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B8FB956 /* 107.143.185.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9823A7 /* 107.152.35.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9826BA /* 107.152.38.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B982EC9 /* 107.152.46.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9B743A /* 107.155.116.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9F218B /* 107.159.33.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAADBBC /* 107.170.219.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAC2AEC /* 107.172.42.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BACC90A /* 107.172.201.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAD9485 /* 107.173.148.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAD9F30 /* 107.173.159.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAEF466 /* 107.174.244.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAF2C59 /* 107.175.44.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB4EFA4 /* 107.180.239.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB6B5F5 /* 107.182.181.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A2A /* 107.189.10.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A33 /* 107.189.10.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A46 /* 107.189.10.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A5D /* 107.189.10.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A77 /* 107.189.10.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A8F /* 107.189.10.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0A9A /* 107.189.10.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0AED /* 107.189.10.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0B50 /* 107.189.11.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0B7B /* 107.189.11.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0B99 /* 107.189.11.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0B99 /* 107.189.11.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD0BCF /* 107.189.11.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD1E64 /* 107.189.30.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD1EE6 /* 107.189.30.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD1F66 /* 107.189.31.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD1FA5 /* 107.189.31.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD1FB5 /* 107.189.31.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBD1FB6 /* 107.189.31.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBE2F34 /* 107.190.47.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF64AE /* 107.191.100.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0E3F48 /* 108.14.63.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0E5218 /* 108.14.82.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C101D58 /* 108.16.29.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C102D52 /* 108.16.45.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1CA777 /* 108.28.167.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1DD7B9 /* 108.29.215.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1F2612 /* 108.31.38.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C27E593 /* 108.39.229.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C35D09D /* 108.53.208.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C38B228 /* 108.56.178.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C38B415 /* 108.56.180.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D60E6 /* 108.61.96.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3D6395 /* 108.61.99.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA686 /* 108.61.166.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3E7B5C /* 108.62.123.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C43E3FD /* 108.67.227.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6C4B2B1B /* 108.75.43.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAC76FB /* 108.172.118.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAEBFF7 /* 108.174.191.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CC5E833 /* 108.197.232.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CCE4CF2 /* 108.206.76.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF0B68C /* 108.240.182.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6CFB5D86 /* 108.251.93.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D3FD842 /* 109.63.216.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44BF84 /* 109.68.191.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44BF9F /* 109.68.191.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D454311 /* 109.69.67.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466401 /* 109.70.100.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466402 /* 109.70.100.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466403 /* 109.70.100.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466404 /* 109.70.100.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466405 /* 109.70.100.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466406 /* 109.70.100.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466407 /* 109.70.100.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466408 /* 109.70.100.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466409 /* 109.70.100.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46640A /* 109.70.100.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46640B /* 109.70.100.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46640C /* 109.70.100.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46640D /* 109.70.100.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46640E /* 109.70.100.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46640F /* 109.70.100.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466410 /* 109.70.100.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466411 /* 109.70.100.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466412 /* 109.70.100.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466413 /* 109.70.100.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466414 /* 109.70.100.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466415 /* 109.70.100.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466416 /* 109.70.100.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466417 /* 109.70.100.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466418 /* 109.70.100.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D466419 /* 109.70.100.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46641A /* 109.70.100.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46641B /* 109.70.100.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46641C /* 109.70.100.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46641D /* 109.70.100.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D46641E /* 109.70.100.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC04E /* 109.74.192.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC3DF /* 109.74.195.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4ACBE8 /* 109.74.203.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4ACE15 /* 109.74.206.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D571994 /* 109.87.25.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D58435D /* 109.88.67.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5A1F70 /* 109.90.31.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5AB389 /* 109.90.179.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5CB65B /* 109.92.182.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D64588C /* 109.100.88.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D696DA2 /* 109.105.109.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6A3C52 /* 109.106.60.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6B239A /* 109.107.35.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D7A394A /* 109.122.57.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D7B505E /* 109.123.80.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D884FF4 /* 109.136.79.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D8887C1 /* 109.136.135.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6D945C99 /* 109.148.92.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA921A3 /* 109.169.33.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC1C85E /* 109.193.200.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC5C1A0 /* 109.197.193.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC6A3B9 /* 109.198.163.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC98564 /* 109.201.133.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DCAC46B /* 109.202.196.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DCE83DC /* 109.206.131.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DD13492 /* 109.209.52.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE42506 /* 109.228.37.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE428E4 /* 109.228.40.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE4321E /* 109.228.50.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE433FB /* 109.228.51.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE5D206 /* 109.229.210.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6E07A /* 109.230.224.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6E0D0 /* 109.230.224.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6EC59 /* 109.230.236.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEA2275 /* 109.234.34.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEB4334 /* 109.235.67.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC3F7A /* 109.236.63.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC530B /* 109.236.83.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC5652 /* 109.236.86.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC566D /* 109.236.86.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC5AD1 /* 109.236.90.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEE0B06 /* 109.238.11.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEE0BB9 /* 109.238.11.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF1A78A /* 109.241.167.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF8959A /* 109.248.149.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF8959B /* 109.248.149.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF895A7 /* 109.248.149.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF895A8 /* 109.248.149.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF895A9 /* 109.248.149.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF89606 /* 109.248.150.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFAF252 /* 109.250.242.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFB3713 /* 109.251.55.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6E042F8B /* 110.4.47.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6E20886B /* 110.32.136.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6E8DDFC2 /* 110.141.223.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6F4525D6 /* 111.69.37.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x6FF1B009 /* 111.241.176.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x70D525E8 /* 112.213.37.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x71A1348A /* 113.161.52.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x71D290D9 /* 113.210.144.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7217A450 /* 114.23.164.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7217CF55 /* 114.23.207.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x726C3AC9 /* 114.108.58.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73927FFE /* 115.146.127.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x73A3F2B1 /* 115.163.242.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x740CB4EA /* 116.12.180.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x740CB4EB /* 116.12.180.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x740CB4EC /* 116.12.180.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x740CB4ED /* 116.12.180.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74539CCD /* 116.83.156.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7458EB58 /* 116.88.235.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA09DA /* 116.202.9.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA0E50 /* 116.202.14.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA3764 /* 116.202.55.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA646C /* 116.202.100.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA6612 /* 116.202.102.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA66F3 /* 116.202.102.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA6938 /* 116.202.105.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA828A /* 116.202.130.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CA9BDF /* 116.202.155.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CAB394 /* 116.202.179.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CAF559 /* 116.202.245.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB1106 /* 116.203.17.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB12AE /* 116.203.18.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB1656 /* 116.203.22.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB18DE /* 116.203.24.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB32B6 /* 116.203.50.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB40D4 /* 116.203.64.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB4521 /* 116.203.69.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB4A09 /* 116.203.74.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB4E93 /* 116.203.78.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB5379 /* 116.203.83.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB5694 /* 116.203.86.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB5818 /* 116.203.88.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB5A7F /* 116.203.90.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB610A /* 116.203.97.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB610F /* 116.203.97.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB693C /* 116.203.105.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB6B47 /* 116.203.107.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB6CE4 /* 116.203.108.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB75DC /* 116.203.117.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB84A2 /* 116.203.132.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB8891 /* 116.203.136.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB8B98 /* 116.203.139.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB8C4A /* 116.203.140.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB8FF7 /* 116.203.143.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB95C5 /* 116.203.149.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CB9FB0 /* 116.203.159.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBBA31 /* 116.203.186.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBBB90 /* 116.203.187.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBBC4F /* 116.203.188.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBC5D6 /* 116.203.197.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBC680 /* 116.203.198.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBD155 /* 116.203.209.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBDB74 /* 116.203.219.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBDDE2 /* 116.203.221.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBE10B /* 116.203.225.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBE652 /* 116.203.230.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBEAF6 /* 116.203.234.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74CBF5AA /* 116.203.245.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x74FB8AD6 /* 116.251.138.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x761B1DED /* 118.27.29.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x767F6C88 /* 118.127.108.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76A34AA0 /* 118.163.74.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76D02839 /* 118.208.40.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x76D0A8BB /* 118.208.168.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x77119EDD /* 119.17.158.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x773B624C /* 119.59.98.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x773B6EC0 /* 119.59.110.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x77690B48 /* 119.105.11.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x77A1648A /* 119.161.100.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x794B7263 /* 121.75.114.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x79A0ED49 /* 121.160.237.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x79C81A2E /* 121.200.26.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7A3E32C7 /* 122.62.50.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7AC73B9A /* 122.199.59.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7B1E808A /* 123.30.128.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7BC28E7B /* 123.194.142.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7BCB62E8 /* 123.203.98.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7BFF3E89 /* 123.255.62.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7C6D01CF /* 124.109.1.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7C964DB6 /* 124.150.77.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7CBEA9FC /* 124.190.169.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD4D9C5 /* 125.212.217.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD4DC3C /* 125.212.220.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7DD4F183 /* 125.212.241.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x7E337E74 /* 126.51.126.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x801F000D /* 128.31.0.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x801F0022 /* 128.31.0.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x801F0027 /* 128.31.0.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x801F003D /* 128.31.0.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8027081D /* 128.39.8.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72C2F /* 128.199.44.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C737CF /* 128.199.55.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78407 /* 128.199.132.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C792BA /* 128.199.146.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7D59D /* 128.199.213.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7DE72 /* 128.199.222.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7E5CA /* 128.199.229.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7E838 /* 128.199.232.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F032 /* 128.199.240.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F5FC /* 128.199.245.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80D002E9 /* 128.208.2.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x80E8123A /* 128.232.18.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x810D838C /* 129.13.131.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81610722 /* 129.97.7.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81642658 /* 129.100.38.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8192823F /* 129.146.130.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x819F23CD /* 129.159.35.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x819F26FB /* 129.159.38.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81E8852B /* 129.232.133.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81E88677 /* 129.232.134.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x81F2DB55 /* 129.242.219.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823D3261 /* 130.61.50.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823D33B7 /* 130.61.51.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823D7DF1 /* 130.61.125.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823DB9ED /* 130.61.185.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823DBDED /* 130.61.189.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x823F4E5F /* 130.63.78.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82599539 /* 130.89.149.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82950E1F /* 130.149.14.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x829550C7 /* 130.149.80.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B433F2 /* 130.180.51.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B45992 /* 130.180.89.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82B46FC2 /* 130.180.111.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82C10F31 /* 130.193.15.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82C10FBA /* 130.193.15.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82CCA103 /* 130.204.161.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E1F45A /* 130.225.244.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E1F45A /* 130.225.244.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E1FE67 /* 130.225.254.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82E1FE67 /* 130.225.254.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF4EE8 /* 130.255.78.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8396C0B6 /* 131.150.192.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x839960DA /* 131.153.96.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BC /* 131.188.40.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BD /* 131.188.40.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83C4FD5F /* 131.196.253.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83CB2092 /* 131.203.32.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83FF0430 /* 131.255.4.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83FF0460 /* 131.255.4.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83FF049B /* 131.255.4.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x83FF049C /* 131.255.4.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x849161BF /* 132.145.97.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84917F11 /* 132.145.127.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84917F11 /* 132.145.127.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84F83B48 /* 132.248.59.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84F8F105 /* 132.248.241.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84F8F105 /* 132.248.241.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x84FCBAB9 /* 132.252.186.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86030A79 /* 134.3.10.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86039253 /* 134.3.146.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86130992 /* 134.19.9.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8665D7A6 /* 134.101.215.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x866679A2 /* 134.102.121.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867720D0 /* 134.119.32.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867A27A9 /* 134.122.39.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867A3690 /* 134.122.54.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x867A7239 /* 134.122.114.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8682ACE5 /* 134.130.172.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86C35840 /* 134.195.88.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86C3591B /* 134.195.89.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86C359C1 /* 134.195.89.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86C365C8 /* 134.195.101.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D145CE /* 134.209.69.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D158E4 /* 134.209.88.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D15ECD /* 134.209.94.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D19666 /* 134.209.150.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D19F4A /* 134.209.159.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D1A863 /* 134.209.168.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D1B7AC /* 134.209.183.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D1D040 /* 134.209.208.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86D1E060 /* 134.209.224.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86F96A15 /* 134.249.106.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86F97A68 /* 134.249.122.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86F9B9B0 /* 134.249.185.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86F9E7CF /* 134.249.231.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86FFDAEF /* 134.255.218.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x86FFF771 /* 134.255.247.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8713733F /* 135.19.115.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8717835D /* 135.23.131.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8717D50A /* 135.23.213.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D37E4 /* 135.125.55.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D5919 /* 135.125.89.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D66A9 /* 135.125.102.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D66AA /* 135.125.102.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D6ABB /* 135.125.106.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D89EC /* 135.125.137.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D9334 /* 135.125.147.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877D9572 /* 135.125.149.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877DA1F6 /* 135.125.161.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877DA1F7 /* 135.125.161.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x877DA1FA /* 135.125.161.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87941AD3 /* 135.148.26.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87941AD5 /* 135.148.26.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794207A /* 135.148.32.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794207B /* 135.148.32.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794208B /* 135.148.32.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420A8 /* 135.148.32.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420A9 /* 135.148.32.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420AA /* 135.148.32.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420AB /* 135.148.32.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420AC /* 135.148.32.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420AD /* 135.148.32.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420AE /* 135.148.32.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420AF /* 135.148.32.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420B0 /* 135.148.32.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420B2 /* 135.148.32.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x879420B3 /* 135.148.32.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942132 /* 135.148.33.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942133 /* 135.148.33.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942134 /* 135.148.33.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942135 /* 135.148.33.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942136 /* 135.148.33.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942137 /* 135.148.33.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942138 /* 135.148.33.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942139 /* 135.148.33.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794213A /* 135.148.33.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794213B /* 135.148.33.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794213C /* 135.148.33.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794213D /* 135.148.33.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794213E /* 135.148.33.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794213F /* 135.148.33.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942140 /* 135.148.33.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942141 /* 135.148.33.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942142 /* 135.148.33.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942143 /* 135.148.33.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942144 /* 135.148.33.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942145 /* 135.148.33.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942147 /* 135.148.33.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942148 /* 135.148.33.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942149 /* 135.148.33.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794214A /* 135.148.33.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794214B /* 135.148.33.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794214C /* 135.148.33.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794214D /* 135.148.33.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794214E /* 135.148.33.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794214F /* 135.148.33.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942150 /* 135.148.33.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942151 /* 135.148.33.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942152 /* 135.148.33.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942153 /* 135.148.33.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942154 /* 135.148.33.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942155 /* 135.148.33.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942156 /* 135.148.33.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942157 /* 135.148.33.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942158 /* 135.148.33.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942159 /* 135.148.33.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794215A /* 135.148.33.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794215B /* 135.148.33.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794215C /* 135.148.33.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794215D /* 135.148.33.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794215E /* 135.148.33.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794215F /* 135.148.33.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942160 /* 135.148.33.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942161 /* 135.148.33.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942162 /* 135.148.33.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942163 /* 135.148.33.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942164 /* 135.148.33.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942165 /* 135.148.33.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942166 /* 135.148.33.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942167 /* 135.148.33.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942168 /* 135.148.33.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942169 /* 135.148.33.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794216A /* 135.148.33.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794216B /* 135.148.33.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794216C /* 135.148.33.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794216D /* 135.148.33.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794216E /* 135.148.33.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794216F /* 135.148.33.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942170 /* 135.148.33.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942171 /* 135.148.33.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942172 /* 135.148.33.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942173 /* 135.148.33.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942174 /* 135.148.33.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942175 /* 135.148.33.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942176 /* 135.148.33.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942177 /* 135.148.33.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942178 /* 135.148.33.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942179 /* 135.148.33.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794217A /* 135.148.33.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794217B /* 135.148.33.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794217C /* 135.148.33.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794217D /* 135.148.33.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794217E /* 135.148.33.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794217F /* 135.148.33.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942180 /* 135.148.33.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942181 /* 135.148.33.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942182 /* 135.148.33.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942183 /* 135.148.33.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942184 /* 135.148.33.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942185 /* 135.148.33.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942186 /* 135.148.33.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942187 /* 135.148.33.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942188 /* 135.148.33.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942189 /* 135.148.33.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794218A /* 135.148.33.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794218B /* 135.148.33.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794218C /* 135.148.33.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794218D /* 135.148.33.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794218E /* 135.148.33.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8794218F /* 135.148.33.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942190 /* 135.148.33.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942191 /* 135.148.33.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942192 /* 135.148.33.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942193 /* 135.148.33.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942194 /* 135.148.33.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87942195 /* 135.148.33.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B42CFB /* 135.180.44.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B4650F /* 135.180.101.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B4650F /* 135.180.101.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5170B /* 135.181.23.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51A00 /* 135.181.26.0/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51A8E /* 135.181.26.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51B69 /* 135.181.27.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51C8F /* 135.181.28.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51CA9 /* 135.181.28.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51CAA /* 135.181.28.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B51EB1 /* 135.181.30.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B524A5 /* 135.181.36.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5253A /* 135.181.37.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B52571 /* 135.181.37.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B529CE /* 135.181.41.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B543CC /* 135.181.67.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B543D2 /* 135.181.67.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B56238 /* 135.181.98.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5696F /* 135.181.105.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B56A4E /* 135.181.106.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B56AE6 /* 135.181.106.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B56FD0 /* 135.181.111.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B590E6 /* 135.181.144.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B591A9 /* 135.181.145.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CA55 /* 135.181.202.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CD18 /* 135.181.205.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CD44 /* 135.181.205.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CD59 /* 135.181.205.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CFE8 /* 135.181.207.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CFE9 /* 135.181.207.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x87B5CFEB /* 135.181.207.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88193330 /* 136.25.51.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x881B528B /* 136.27.82.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x881B528B /* 136.27.82.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8822670A /* 136.34.103.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8825666F /* 136.37.102.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8825666F /* 136.37.102.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8825C5B2 /* 136.37.197.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8831090A /* 136.49.9.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88319695 /* 136.49.150.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x883729A6 /* 136.55.41.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8839BADB /* 136.57.186.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8890D7B4 /* 136.144.215.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3020D /* 136.243.2.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3033C /* 136.243.3.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3048B /* 136.243.4.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3048B /* 136.243.4.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F30812 /* 136.243.8.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F30F3E /* 136.243.15.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F327B9 /* 136.243.39.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F33CBC /* 136.243.60.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F345F3 /* 136.243.69.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F352BC /* 136.243.82.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3832E /* 136.243.131.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F39552 /* 136.243.149.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F39CBB /* 136.243.156.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3B094 /* 136.243.176.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3B185 /* 136.243.177.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3E506 /* 136.243.229.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F451C5 /* 136.244.81.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x88F46C8F /* 136.244.108.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8932130B /* 137.50.19.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x893BB9B3 /* 137.59.185.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894A74D6 /* 137.74.116.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894AA9F1 /* 137.74.169.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x894ABD5F /* 137.74.189.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x89C141E0 /* 137.193.65.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x89DC29F7 /* 137.220.41.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x89DC5E7C /* 137.220.94.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A136034 /* 138.19.96.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A3B1128 /* 138.59.17.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A3B1269 /* 138.59.18.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A3B126A /* 138.59.18.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A3B126E /* 138.59.18.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A4409B8 /* 138.68.9.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A44ACB0 /* 138.68.172.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A4B9FA4 /* 138.75.159.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A58DD26 /* 138.88.221.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8A75942D /* 138.117.148.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC501D0 /* 138.197.1.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC56230 /* 138.197.98.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5805C /* 138.197.128.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC590BF /* 138.197.144.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5946C /* 138.197.148.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC59892 /* 138.197.152.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5A65C /* 138.197.166.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5A829 /* 138.197.168.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5AB58 /* 138.197.171.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5ADE8 /* 138.197.173.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5CF9B /* 138.197.207.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC5D59A /* 138.197.213.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC91305 /* 138.201.19.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC91C83 /* 138.201.28.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC92306 /* 138.201.35.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC95CB7 /* 138.201.92.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC97A37 /* 138.201.122.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC998CB /* 138.201.152.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9A90C /* 138.201.169.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9AFD3 /* 138.201.175.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9B192 /* 138.201.177.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9C49C /* 138.201.196.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9D295 /* 138.201.210.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9D296 /* 138.201.210.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9F4F9 /* 138.201.244.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9F712 /* 138.201.247.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9FA21 /* 138.201.250.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9FADD /* 138.201.250.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8AC9FFF5 /* 138.201.255.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B05B106 /* 139.5.177.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B1C26DF /* 139.28.38.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0006 /* 139.59.0.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0886 /* 139.59.8.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B0FDA /* 139.59.15.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B1005 /* 139.59.16.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2438 /* 139.59.36.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2438 /* 139.59.36.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B2DF2 /* 139.59.45.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B3813 /* 139.59.56.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B3A6D /* 139.59.58.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B3DFD /* 139.59.61.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B4310 /* 139.59.67.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B4356 /* 139.59.67.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B4E71 /* 139.59.78.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B4F40 /* 139.59.79.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B5E12 /* 139.59.94.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3B61ED /* 139.59.97.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B3BB2DC /* 139.59.178.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B6337BA /* 139.99.55.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B635888 /* 139.99.88.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B63611A /* 139.99.97.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B6362BF /* 139.99.98.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B636763 /* 139.99.103.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B637882 /* 139.99.120.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B638596 /* 139.99.133.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B638716 /* 139.99.135.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B639BBB /* 139.99.155.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B63AAE7 /* 139.99.170.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B63AC0B /* 139.99.172.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B63B219 /* 139.99.178.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B63DA03 /* 139.99.218.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B63EE11 /* 139.99.238.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8B8A597B /* 139.138.89.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA202E7 /* 139.162.2.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2036C /* 139.162.3.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2060A /* 139.162.6.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2072A /* 139.162.7.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20A48 /* 139.162.10.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20ABE /* 139.162.10.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20BF8 /* 139.162.11.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20DC5 /* 139.162.13.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA20FD0 /* 139.162.15.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA21EF7 /* 139.162.30.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA22339 /* 139.162.35.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2298C /* 139.162.41.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA22FB8 /* 139.162.47.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA23B86 /* 139.162.59.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA23F7D /* 139.162.63.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA242F6 /* 139.162.66.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA27130 /* 139.162.113.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2752B /* 139.162.117.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA280FB /* 139.162.128.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA28E78 /* 139.162.142.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA29756 /* 139.162.151.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA29C73 /* 139.162.156.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2A2EE /* 139.162.162.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2A7F3 /* 139.162.167.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2AED6 /* 139.162.174.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2B3CA /* 139.162.179.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2BFF3 /* 139.162.191.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2C267 /* 139.162.194.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2C345 /* 139.162.195.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2C6B2 /* 139.162.198.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2C90D /* 139.162.201.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2C9EE /* 139.162.201.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2D2FC /* 139.162.210.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2E0AB /* 139.162.224.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2E81C /* 139.162.232.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2EFB1 /* 139.162.239.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2F578 /* 139.162.245.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BA2FD2C /* 139.162.253.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8BB4A3D7 /* 139.180.163.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E640E /* 140.78.100.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E640E /* 140.78.100.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E640F /* 140.78.100.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E640F /* 140.78.100.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6410 /* 140.78.100.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6410 /* 140.78.100.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6411 /* 140.78.100.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6411 /* 140.78.100.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6412 /* 140.78.100.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6412 /* 140.78.100.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6413 /* 140.78.100.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6413 /* 140.78.100.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6414 /* 140.78.100.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6414 /* 140.78.100.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6415 /* 140.78.100.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6415 /* 140.78.100.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6416 /* 140.78.100.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6416 /* 140.78.100.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6417 /* 140.78.100.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6417 /* 140.78.100.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6418 /* 140.78.100.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6418 /* 140.78.100.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6419 /* 140.78.100.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6419 /* 140.78.100.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641A /* 140.78.100.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641A /* 140.78.100.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641B /* 140.78.100.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641B /* 140.78.100.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641C /* 140.78.100.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641C /* 140.78.100.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641D /* 140.78.100.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E641D /* 140.78.100.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6423 /* 140.78.100.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6423 /* 140.78.100.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6424 /* 140.78.100.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6424 /* 140.78.100.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6425 /* 140.78.100.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6425 /* 140.78.100.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6426 /* 140.78.100.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6426 /* 140.78.100.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6427 /* 140.78.100.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6427 /* 140.78.100.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6428 /* 140.78.100.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6428 /* 140.78.100.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6429 /* 140.78.100.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E6429 /* 140.78.100.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E642A /* 140.78.100.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E642A /* 140.78.100.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E642B /* 140.78.100.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E642B /* 140.78.100.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C4E64FD /* 140.78.100.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C5207CE /* 140.82.7.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8C523AFD /* 140.82.58.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CBACD44 /* 140.186.205.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEE27B7 /* 140.238.39.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEE3948 /* 140.238.57.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEE3948 /* 140.238.57.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEE472E /* 140.238.71.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEE9A79 /* 140.238.154.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEE9BF9 /* 140.238.155.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEEA8D6 /* 140.238.168.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEEAC22 /* 140.238.172.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEEDBDE /* 140.238.219.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEEE45F /* 140.238.228.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8CEEFEEC /* 140.238.254.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D001405 /* 141.0.20.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D0EDCB1 /* 141.14.220.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D142145 /* 141.20.33.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D146721 /* 141.20.103.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D27FAF5 /* 141.39.250.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D463D78 /* 141.70.61.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D467DE8 /* 141.70.125.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D62884F /* 141.98.136.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D69433A /* 141.105.67.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8D9C14BA /* 141.156.20.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DC11563 /* 141.193.21.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DE0DD8E /* 141.224.221.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DEF9464 /* 141.239.148.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA1A7 /* 141.255.161.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA566 /* 141.255.165.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA68E /* 141.255.166.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA696 /* 141.255.166.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA6BD /* 141.255.166.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D018 /* 142.4.208.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D01A /* 142.4.208.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D025 /* 142.4.208.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D11F /* 142.4.209.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D12D /* 142.4.209.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D1C8 /* 142.4.209.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D1CA /* 142.4.209.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D212 /* 142.4.210.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D22D /* 142.4.210.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D2B2 /* 142.4.210.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D2CD /* 142.4.210.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D35E /* 142.4.211.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D397 /* 142.4.211.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D3DE /* 142.4.211.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D41F /* 142.4.212.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D50C /* 142.4.213.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D51C /* 142.4.213.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D54E /* 142.4.213.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D551 /* 142.4.213.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D554 /* 142.4.213.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D558 /* 142.4.213.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D55A /* 142.4.213.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D569 /* 142.4.213.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D56D /* 142.4.213.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D570 /* 142.4.213.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D5B8 /* 142.4.213.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D5C0 /* 142.4.213.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D5D5 /* 142.4.213.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D6C3 /* 142.4.214.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D726 /* 142.4.215.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D72B /* 142.4.215.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D72C /* 142.4.215.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D72D /* 142.4.215.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E0BC95A /* 142.11.201.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2C8550 /* 142.44.133.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2C8B0C /* 142.44.139.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2C9C83 /* 142.44.156.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2CA323 /* 142.44.163.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2CF18E /* 142.44.241.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2CF385 /* 142.44.243.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2CF5A5 /* 142.44.245.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2CF69C /* 142.44.246.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2CF766 /* 142.44.247.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F59A3 /* 142.47.89.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F5B19 /* 142.47.91.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F617D /* 142.47.97.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F61F5 /* 142.47.97.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F63B4 /* 142.47.99.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6762 /* 142.47.103.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6942 /* 142.47.105.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6BD9 /* 142.47.107.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6D82 /* 142.47.109.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6D84 /* 142.47.109.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6D88 /* 142.47.109.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6D89 /* 142.47.109.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6D8A /* 142.47.109.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2F6D8C /* 142.47.109.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2FD8A8 /* 142.47.216.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E2FDAA2 /* 142.47.218.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E5D678C /* 142.93.103.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E5D9BBD /* 142.93.155.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E5DA9C5 /* 142.93.169.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E5DBE66 /* 142.93.190.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E5DE37F /* 142.93.227.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E5DE8A5 /* 142.93.232.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E71DED9 /* 142.113.222.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8E721E43 /* 142.114.30.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6A4923 /* 143.106.73.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6BE563 /* 143.107.229.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6BE578 /* 143.107.229.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6BE5D2 /* 143.107.229.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8F6E9C18 /* 143.110.156.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x8FB26F78 /* 143.178.111.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90025A39 /* 144.2.90.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90027784 /* 144.2.119.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1882 /* 144.76.24.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1EA7 /* 144.76.30.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C25F2 /* 144.76.37.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C2A8F /* 144.76.42.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C39B7 /* 144.76.57.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C3A17 /* 144.76.58.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C4B89 /* 144.76.75.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C5DF5 /* 144.76.93.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6B5E /* 144.76.107.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904C7656 /* 144.76.118.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CA588 /* 144.76.165.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CA824 /* 144.76.168.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CAA14 /* 144.76.170.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CADB4 /* 144.76.173.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CAFCD /* 144.76.175.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CC850 /* 144.76.200.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CD8FC /* 144.76.216.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CDFAE /* 144.76.223.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CEC0E /* 144.76.236.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x904CEC1B /* 144.76.236.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x905B4DB3 /* 144.91.77.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x905B5C63 /* 144.91.92.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x905B68F2 /* 144.91.104.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x905B6A48 /* 144.91.106.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x905B7D0F /* 144.91.125.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x905B7DEF /* 144.91.125.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90AC4BB3 /* 144.172.75.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90AC7604 /* 144.172.118.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90AC7676 /* 144.172.118.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90AC7691 /* 144.172.118.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90AC76ED /* 144.172.118.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90AC99A5 /* 144.172.153.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90CA31AB /* 144.202.49.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90CA3FF3 /* 144.202.63.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D904A6 /* 144.217.4.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D90788 /* 144.217.7.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D90C65 /* 144.217.12.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D93CD3 /* 144.217.60.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D93CD3 /* 144.217.60.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D93CEF /* 144.217.60.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D93CEF /* 144.217.60.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D94B6E /* 144.217.75.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D95050 /* 144.217.80.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9571C /* 144.217.87.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D95F0C /* 144.217.95.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9CF03 /* 144.217.207.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9F58C /* 144.217.245.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x90D9F591 /* 144.217.245.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91DC000F /* 145.220.0.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF00CC /* 145.239.0.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF0161 /* 145.239.1.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF07A8 /* 145.239.7.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF07A9 /* 145.239.7.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF07AA /* 145.239.7.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF194B /* 145.239.25.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF4C5F /* 145.239.76.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF513A /* 145.239.81.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF54AC /* 145.239.84.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF54AC /* 145.239.84.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF5B25 /* 145.239.91.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF76F3 /* 145.239.118.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EF9EEA /* 145.239.158.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91EFBB1A /* 145.239.187.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x91F96A63 /* 145.249.106.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92002849 /* 146.0.40.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92004882 /* 146.0.72.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92004D32 /* 146.0.77.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923B0A8B /* 146.59.10.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923B9607 /* 146.59.150.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923B97B0 /* 146.59.151.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923BEADC /* 146.59.234.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x923BFBC4 /* 146.59.251.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x927385B3 /* 146.115.133.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9B024 /* 146.185.176.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9BDC5 /* 146.185.189.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9FD65 /* 146.185.253.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x92E470FC /* 146.228.112.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x935C5843 /* 147.92.88.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93870426 /* 147.135.4.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93870444 /* 147.135.4.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93870645 /* 147.135.6.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x938740D9 /* 147.135.64.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93874E9D /* 147.135.78.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9387693E /* 147.135.105.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93877030 /* 147.135.112.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9387708B /* 147.135.112.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x938771B2 /* 147.135.113.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x93877262 /* 147.135.114.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x938772F5 /* 147.135.114.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x938773D4 /* 147.135.115.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9387D1EA /* 147.135.209.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x943FB4A1 /* 148.63.180.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x944AC250 /* 148.74.194.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB0B15 /* 148.251.11.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB1668 /* 148.251.22.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB29EB /* 148.251.41.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB335E /* 148.251.51.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB4399 /* 148.251.67.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB4BF7 /* 148.251.75.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB5110 /* 148.251.81.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB51ED /* 148.251.81.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB9B6C /* 148.251.155.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBB6D7 /* 148.251.182.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBB6DB /* 148.251.182.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBB7CD /* 148.251.183.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBBEE5 /* 148.251.190.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBBFFC /* 148.251.191.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBC0A0 /* 148.251.192.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBD3D3 /* 148.251.211.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBEDDB /* 148.251.237.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x94FC7833 /* 148.252.120.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x951C3A89 /* 149.28.58.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x951CAEEA /* 149.28.174.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x951CB691 /* 149.28.182.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x951CB795 /* 149.28.183.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x951CE706 /* 149.28.231.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x951CF568 /* 149.28.245.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95221B89 /* 149.34.27.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95382C2F /* 149.56.44.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95382DC8 /* 149.56.45.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95385ED8 /* 149.56.94.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95385ED9 /* 149.56.94.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95385EDA /* 149.56.94.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95385EDB /* 149.56.94.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x953862D8 /* 149.56.98.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95386355 /* 149.56.99.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95389D77 /* 149.56.157.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538B938 /* 149.56.185.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538B938 /* 149.56.185.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9538E98E /* 149.56.233.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x955AC857 /* 149.90.200.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A4332 /* 149.154.67.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9879 /* 149.154.152.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9ACF /* 149.154.154.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9D50 /* 149.154.157.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9F57 /* 149.154.159.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9FAC /* 149.154.159.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CA3D06 /* 149.202.61.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CABE0E /* 149.202.190.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAD0CB /* 149.202.208.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAEECC /* 149.202.238.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95CAEECC /* 149.202.238.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95D29696 /* 149.210.150.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2A4E4 /* 149.210.164.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x95F83E04 /* 149.248.62.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x965FD6BE /* 150.95.214.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x966B4BBA /* 150.107.75.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x966B4C0D /* 150.107.76.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9688B9B1 /* 150.136.185.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x971B07DC /* 151.27.7.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97215DFF /* 151.33.93.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97301E6F /* 151.48.30.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97338745 /* 151.51.135.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x973F2389 /* 151.63.35.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97400708 /* 151.64.7.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x974128B0 /* 151.65.40.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97425F50 /* 151.66.95.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x974DBCEF /* 151.77.188.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x975029E6 /* 151.80.41.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97502CB1 /* 151.80.44.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97733821 /* 151.115.56.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x977F344F /* 151.127.52.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97C5F09A /* 151.197.240.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDA6B /* 151.236.218.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EDB96E /* 151.237.185.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x97EDB986 /* 151.237.185.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x984360B9 /* 152.67.96.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9843E5A2 /* 152.67.229.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9843EA83 /* 152.67.234.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x985968CE /* 152.89.104.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98596A93 /* 152.89.106.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98618A95 /* 152.97.138.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98732E84 /* 152.115.46.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98AE07DB /* 152.174.7.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98E48058 /* 152.228.128.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98E482AC /* 152.228.130.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x98E482AE /* 152.228.130.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x995C7EEA /* 153.92.126.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x995C7FEF /* 153.92.127.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x99782A89 /* 153.120.42.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x997E805E /* 153.126.128.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x99F2CA02 /* 153.242.202.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A1043D8 /* 154.16.67.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A3903D6 /* 154.57.3.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9A3B7048 /* 154.59.112.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B044615 /* 155.4.70.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B0449C5 /* 155.4.73.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B046E25 /* 155.4.110.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B04C78A /* 155.4.199.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B620505 /* 155.98.5.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B620505 /* 155.98.5.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B620506 /* 155.98.5.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B620506 /* 155.98.5.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B8A896D /* 155.138.137.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B8A8F1C /* 155.138.143.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9B8A9CC0 /* 155.138.156.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D1616FE /* 157.22.22.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A1856 /* 157.90.24.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A22C3 /* 157.90.34.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A2609 /* 157.90.38.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A92D7 /* 157.90.146.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A92D8 /* 157.90.146.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A92D9 /* 157.90.146.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A92DA /* 157.90.146.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A92DB /* 157.90.146.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A943D /* 157.90.148.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A943E /* 157.90.148.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D5A943F /* 157.90.148.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D6117B1 /* 157.97.23.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D83F6AB /* 157.131.246.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D83FFA2 /* 157.131.255.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9D83FFA2 /* 157.131.255.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9DB4D90D /* 157.180.217.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9DB4E03D /* 157.180.224.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9DE649AE /* 157.230.73.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9DE67078 /* 157.230.112.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9DF58F9A /* 157.245.143.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9DF5B80D /* 157.245.184.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E337E48 /* 158.51.126.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AAD4E /* 158.58.173.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E4500E0 /* 158.69.0.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E4500F6 /* 158.69.0.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E453F36 /* 158.69.63.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E457B46 /* 158.69.123.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E457E87 /* 158.69.126.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45BB3F /* 158.69.187.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CC24 /* 158.69.204.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CD5C /* 158.69.205.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CDF7 /* 158.69.205.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45CFD8 /* 158.69.207.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45D922 /* 158.69.217.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E45DA4E /* 158.69.218.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E658B56 /* 158.101.139.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E65A8E1 /* 158.101.168.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E65B7E7 /* 158.101.183.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E65CE21 /* 158.101.206.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E65D6FB /* 158.101.214.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E8CCAD5 /* 158.140.202.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E8CCE4B /* 158.140.206.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9E8CE6E9 /* 158.140.230.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EAE0B9C /* 158.174.11.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EAE70AC /* 158.174.112.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EAE70AC /* 158.174.112.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EAE7276 /* 158.174.114.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EAE918B /* 158.174.145.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EB55D8F /* 158.181.93.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF0170 /* 158.255.1.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF06F2 /* 158.255.6.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFF073D /* 158.255.7.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD451 /* 158.255.212.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD4B2 /* 158.255.212.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD729 /* 158.255.215.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD7C1 /* 158.255.215.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4102CC /* 159.65.2.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F410ABD /* 159.65.10.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F411086 /* 159.65.16.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F41EC2B /* 159.65.236.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4502EF /* 159.69.2.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45068E /* 159.69.6.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F450C80 /* 159.69.12.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4515C4 /* 159.69.21.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F451B67 /* 159.69.27.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F451CAD /* 159.69.28.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F451DFD /* 159.69.29.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F452403 /* 159.69.36.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45262C /* 159.69.38.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45265D /* 159.69.38.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45293F /* 159.69.41.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F452C53 /* 159.69.44.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F455122 /* 159.69.81.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4555DC /* 159.69.85.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F455AEB /* 159.69.90.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45726E /* 159.69.114.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4577A9 /* 159.69.119.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4577AA /* 159.69.119.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F4577C7 /* 159.69.119.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F459351 /* 159.69.147.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45989D /* 159.69.152.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45B519 /* 159.69.181.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45B51A /* 159.69.181.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45B51B /* 159.69.181.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45B8AC /* 159.69.184.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45BFC3 /* 159.69.191.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45BFC9 /* 159.69.191.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45CF14 /* 159.69.207.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F45D406 /* 159.69.212.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59577E /* 159.89.87.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F599505 /* 159.89.149.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59A0F1 /* 159.89.160.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59A2B8 /* 159.89.162.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59AA79 /* 159.89.170.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59ABB4 /* 159.89.171.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59AE09 /* 159.89.174.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F59ECE4 /* 159.89.236.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F9316A8 /* 159.147.22.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BAC4 /* 159.148.186.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94BCFA /* 159.148.188.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB065D /* 159.203.6.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1633 /* 159.203.22.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1B05 /* 159.203.27.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0x9FCB1DF0 /* 159.203.29.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA010833A /* 160.16.131.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA014915C /* 160.20.145.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA01492EF /* 160.20.146.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA07764A0 /* 160.119.100.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077F918 /* 160.119.249.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077F9DE /* 160.119.249.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077F9DF /* 160.119.249.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077F9EF /* 160.119.249.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077F9F0 /* 160.119.249.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077FD67 /* 160.119.253.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA077FD72 /* 160.119.253.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA0CAA2BA /* 160.202.162.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1230890 /* 161.35.8.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1233922 /* 161.35.57.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA123572D /* 161.35.87.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA123736D /* 161.35.115.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1237ED7 /* 161.35.126.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA12387B5 /* 161.35.135.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1238E49 /* 161.35.142.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA123E176 /* 161.35.225.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA135A068 /* 161.53.160.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA161436A /* 161.97.67.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1614689 /* 161.97.70.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA16175FC /* 161.97.117.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA16180EF /* 161.97.128.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA16185E1 /* 161.97.133.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1618D77 /* 161.97.141.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1618E0F /* 161.97.142.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA1814070 /* 161.129.64.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2C895DD /* 162.200.149.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D49E52 /* 162.212.158.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D49E52 /* 162.212.158.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D503DD /* 162.213.3.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D5D357 /* 162.213.211.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DDD9F1 /* 162.221.217.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2E23846 /* 162.226.56.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2EDCF35 /* 162.237.207.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F348C6 /* 162.243.72.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3B96D /* 162.243.185.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F4506F /* 162.244.80.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F45080 /* 162.244.80.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C7 /* 162.247.72.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F749C0 /* 162.247.73.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74A07 /* 162.247.74.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74A1B /* 162.247.74.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74A4A /* 162.247.74.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74AC8 /* 162.247.74.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74AC9 /* 162.247.74.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74ACA /* 162.247.74.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74ACC /* 162.247.74.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74ACE /* 162.247.74.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74AD5 /* 162.247.74.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74AD8 /* 162.247.74.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74AD9 /* 162.247.74.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F80408 /* 162.248.4.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A00F /* 162.248.160.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A081 /* 162.248.160.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A11A /* 162.248.161.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A11C /* 162.248.161.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A11E /* 162.248.161.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A11F /* 162.248.161.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A122 /* 162.248.161.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A16B /* 162.248.161.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A173 /* 162.248.161.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A175 /* 162.248.161.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A187 /* 162.248.161.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A1A3 /* 162.248.161.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A1AC /* 162.248.161.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A1BA /* 162.248.161.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A1BD /* 162.248.161.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A1C8 /* 162.248.161.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FABE35 /* 162.250.190.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FABF0F /* 162.250.191.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FABF0F /* 162.250.191.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FF54F8 /* 162.255.84.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA31611D3 /* 163.22.17.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA32CAD25 /* 163.44.173.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA32CAE81 /* 163.44.174.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA39E0DB1 /* 163.158.13.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC07E9 /* 163.172.7.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC0EDD /* 163.172.14.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1575 /* 163.172.21.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1976 /* 163.172.25.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC19AE /* 163.172.25.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC19EA /* 163.172.25.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1BE0 /* 163.172.27.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1C76 /* 163.172.28.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1D1E /* 163.172.29.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1D22 /* 163.172.29.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC1E4C /* 163.172.30.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2324 /* 163.172.35.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2474 /* 163.172.36.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2768 /* 163.172.39.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC29AC /* 163.172.41.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC29E4 /* 163.172.41.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2A34 /* 163.172.42.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2A38 /* 163.172.42.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC2B51 /* 163.172.43.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC30EE /* 163.172.48.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC35C9 /* 163.172.53.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC3A02 /* 163.172.58.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC3C19 /* 163.172.60.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC3C19 /* 163.172.60.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC3F7A /* 163.172.63.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC44DE /* 163.172.68.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC48FA /* 163.172.72.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC494E /* 163.172.73.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC5485 /* 163.172.84.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC58EC /* 163.172.88.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC5E77 /* 163.172.94.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC5E90 /* 163.172.94.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC81EE /* 163.172.129.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC887D /* 163.172.136.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8B68 /* 163.172.139.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8D0A /* 163.172.141.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC8E5C /* 163.172.142.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC97CE /* 163.172.151.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9AA2 /* 163.172.154.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3AC9DD5 /* 163.172.157.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACA9FD /* 163.172.169.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB31F /* 163.172.179.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB61A /* 163.172.182.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB820 /* 163.172.184.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACB8F3 /* 163.172.184.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACBC71 /* 163.172.188.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACC235 /* 163.172.194.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD236 /* 163.172.210.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD380 /* 163.172.211.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD380 /* 163.172.211.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD3D2 /* 163.172.211.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD4B4 /* 163.172.212.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD562 /* 163.172.213.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA3ACD5D4 /* 163.172.213.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA434F9D5 /* 164.52.249.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA444617A /* 164.68.97.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4446649 /* 164.68.102.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4446A5E /* 164.68.106.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4446BDE /* 164.68.107.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4446C3B /* 164.68.108.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA45A943C /* 164.90.148.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA48409C7 /* 164.132.9.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484431B /* 164.132.67.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484AFE7 /* 164.132.175.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA484E21E /* 164.132.226.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA4A08105 /* 164.160.129.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA516051E /* 165.22.5.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5162DB4 /* 165.22.45.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA51657DF /* 165.22.87.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA516D465 /* 165.22.212.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA516D48D /* 165.22.212.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA516DA94 /* 165.22.218.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA516E6A4 /* 165.22.230.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA516ECFB /* 165.22.236.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5A9CD7F /* 165.169.205.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E31FFA /* 165.227.31.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E32071 /* 165.227.32.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E322F0 /* 165.227.34.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E32801 /* 165.227.40.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E344AB /* 165.227.68.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E3A13C /* 165.227.161.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E3A13E /* 165.227.161.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E3AE96 /* 165.227.174.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E88443 /* 165.232.132.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA5E88533 /* 165.232.133.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA646CF02 /* 166.70.207.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7472D4D /* 167.71.45.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7473238 /* 167.71.50.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7475094 /* 167.71.80.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7478DF3 /* 167.71.141.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA747DB7C /* 167.71.219.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA75642A8 /* 167.86.66.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7565E6B /* 167.86.94.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA756643B /* 167.86.100.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA756660C /* 167.86.102.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7566EFE /* 167.86.110.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7567046 /* 167.86.112.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA756723F /* 167.86.114.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA75672F4 /* 167.86.114.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7567E0A /* 167.86.126.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7567F82 /* 167.86.127.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7580786 /* 167.88.7.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA758A1D1 /* 167.88.161.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772221B /* 167.114.34.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA77260B9 /* 167.114.96.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7729098 /* 167.114.144.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772AA9C /* 167.114.170.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA772F470 /* 167.114.244.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7AC7D7B /* 167.172.125.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7ACEDCB /* 167.172.237.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA7B34EFC /* 167.179.78.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8466EA5 /* 168.70.110.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA87732EC /* 168.119.50.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA87732ED /* 168.119.50.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA87732EF /* 168.119.50.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8773BB9 /* 168.119.59.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8773F32 /* 168.119.63.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA877B8B4 /* 168.119.184.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA877E2B1 /* 168.119.226.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA877FE66 /* 168.119.254.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA88AD492 /* 168.138.212.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8CD943A /* 168.205.148.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB431E /* 168.235.67.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAAEF578B /* 170.239.87.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAAFD016D /* 170.253.1.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C109 /* 171.25.193.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C114 /* 171.25.193.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C119 /* 171.25.193.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C14D /* 171.25.193.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C14E /* 171.25.193.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C18B /* 171.25.193.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xABF421BD /* 171.244.33.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC489406 /* 172.72.148.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC49317D /* 172.73.49.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC51836E /* 172.81.131.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC51836F /* 172.81.131.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC568B94 /* 172.86.139.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC59AA87 /* 172.89.170.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC5D30C5 /* 172.93.48.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC5D81F9 /* 172.93.129.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC5E2243 /* 172.94.34.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC61E0F3 /* 172.97.224.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC62C12B /* 172.98.193.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC62C13E /* 172.98.193.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC67A4CE /* 172.103.164.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC680427 /* 172.104.4.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68042E /* 172.104.4.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6804F1 /* 172.104.4.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC680D4D /* 172.104.13.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC681BD8 /* 172.104.27.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68231B /* 172.104.35.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6824AA /* 172.104.36.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68318C /* 172.104.49.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6842BC /* 172.104.66.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC684ABE /* 172.104.74.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC684CF2 /* 172.104.76.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC684EC5 /* 172.104.78.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC684FDE /* 172.104.79.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68552B /* 172.104.85.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68567A /* 172.104.86.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6857FA /* 172.104.87.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68582B /* 172.104.88.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC685F52 /* 172.104.95.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68654C /* 172.104.101.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC686D2F /* 172.104.109.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC686F5E /* 172.104.111.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC687E6D /* 172.104.126.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC688326 /* 172.104.131.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC688570 /* 172.104.133.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC688889 /* 172.104.136.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC688A89 /* 172.104.138.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68944D /* 172.104.148.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC689495 /* 172.104.148.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6894DB /* 172.104.148.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68A726 /* 172.104.167.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68AA52 /* 172.104.170.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68B167 /* 172.104.177.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68B3D2 /* 172.104.179.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68B3DC /* 172.104.179.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68B7E2 /* 172.104.183.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68BBBC /* 172.104.187.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68BFEA /* 172.104.191.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68CEF9 /* 172.104.206.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68D0BE /* 172.104.208.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC68E3B6 /* 172.104.227.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC690325 /* 172.105.3.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC690499 /* 172.105.4.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6908F7 /* 172.105.8.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC691337 /* 172.105.19.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC691449 /* 172.105.20.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69144A /* 172.105.20.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6916EC /* 172.105.22.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6918B6 /* 172.105.24.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69191E /* 172.105.25.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC691D07 /* 172.105.29.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC692391 /* 172.105.35.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6923F9 /* 172.105.35.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69256E /* 172.105.37.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6929BB /* 172.105.41.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC692A73 /* 172.105.42.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69306F /* 172.105.48.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69342F /* 172.105.52.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69377D /* 172.105.55.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6939EA /* 172.105.57.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC693B6E /* 172.105.59.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC693DD4 /* 172.105.61.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC693F0A /* 172.105.63.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC694011 /* 172.105.64.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69412D /* 172.105.65.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6944B2 /* 172.105.68.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6947E8 /* 172.105.71.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC694B3D /* 172.105.75.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6952A6 /* 172.105.82.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC695D5A /* 172.105.93.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC695E54 /* 172.105.94.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC695E7D /* 172.105.94.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6962D9 /* 172.105.98.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC696769 /* 172.105.103.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC696791 /* 172.105.103.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC696888 /* 172.105.104.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6968E7 /* 172.105.104.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6969EC /* 172.105.105.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC696ACD /* 172.105.106.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC696EBD /* 172.105.110.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC696F07 /* 172.105.111.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC697487 /* 172.105.116.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6974E6 /* 172.105.116.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC697AA1 /* 172.105.122.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69961F /* 172.105.150.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69971E /* 172.105.151.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6997EE /* 172.105.151.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69A384 /* 172.105.163.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69A384 /* 172.105.163.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69A3D3 /* 172.105.163.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69A3DE /* 172.105.163.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69A935 /* 172.105.169.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69A997 /* 172.105.169.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69AA2B /* 172.105.170.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69AB49 /* 172.105.171.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69AB8D /* 172.105.171.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69ADC6 /* 172.105.173.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69AE8D /* 172.105.174.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69AF92 /* 172.105.175.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69B1BC /* 172.105.177.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69B7F4 /* 172.105.183.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69B928 /* 172.105.185.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69B956 /* 172.105.185.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69B996 /* 172.105.185.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69BA2A /* 172.105.186.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69BA62 /* 172.105.186.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69BA6C /* 172.105.186.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69BC16 /* 172.105.188.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69C51B /* 172.105.197.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69C593 /* 172.105.197.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69C79B /* 172.105.199.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69CC20 /* 172.105.204.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69CF2A /* 172.105.207.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69D6A2 /* 172.105.214.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69E711 /* 172.105.231.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69EC44 /* 172.105.236.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69F275 /* 172.105.242.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC69F642 /* 172.105.246.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6A0043 /* 172.106.0.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6A0CF6 /* 172.106.12.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6A11E2 /* 172.106.17.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6A70FE /* 172.106.112.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6B5C12 /* 172.107.92.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAC6B6046 /* 172.107.96.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF18C1A /* 172.241.140.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF515D7 /* 172.245.21.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF51E05 /* 172.245.30.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xACF58612 /* 172.245.134.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD00311A /* 173.0.49.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD00312A /* 173.0.49.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD003132 /* 173.0.49.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD00313A /* 173.0.49.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD003142 /* 173.0.49.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD00314A /* 173.0.49.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD00315A /* 173.0.49.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD308CDB /* 173.48.140.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD30A351 /* 173.48.163.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD31D9E7 /* 173.49.217.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD491C90 /* 173.73.28.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD4973EE /* 173.73.115.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD4B273D /* 173.75.39.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD525A59 /* 173.82.90.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD527723 /* 173.82.119.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAD52EE86 /* 173.82.238.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADC6F37E /* 173.198.243.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4C0A2 /* 173.212.192.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4C266 /* 173.212.194.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4C8F1 /* 173.212.200.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4D9F7 /* 173.212.217.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4DAA5 /* 173.212.218.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4DD0A /* 173.212.221.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4E7E4 /* 173.212.231.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4E906 /* 173.212.233.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4ECA9 /* 173.212.236.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4ED10 /* 173.212.237.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4EF4E /* 173.212.239.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4EF4E /* 173.212.239.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4F15D /* 173.212.241.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4F26E /* 173.212.242.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4FDAC /* 173.212.253.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD4FEC0 /* 173.212.254.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD56C74 /* 173.213.108.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADD711B3 /* 173.215.17.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE680E8 /* 173.230.128.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE680EA /* 173.230.128.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE68886 /* 173.230.136.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE6895B /* 173.230.137.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE68A20 /* 173.230.138.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE6996D /* 173.230.153.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADE69A5A /* 173.230.154.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADEF4FCB /* 173.239.79.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADF90798 /* 173.249.7.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADF90871 /* 173.249.8.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADF91D89 /* 173.249.29.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADF93056 /* 173.249.48.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADF93FE3 /* 173.249.63.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFF8C1B /* 173.255.140.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFD0F8 /* 173.255.208.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE486 /* 173.255.228.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFED46 /* 173.255.237.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF2B8 /* 173.255.242.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF574 /* 173.255.245.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF9EA /* 173.255.249.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFFACB /* 173.255.250.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFFADB /* 173.255.250.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFFFE4 /* 173.255.255.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE012A11 /* 174.1.42.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE140BED /* 174.20.11.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE351DA8 /* 174.53.29.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE58365A /* 174.88.54.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE590695 /* 174.89.6.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE59EB9F /* 174.89.235.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE59EB9F /* 174.89.235.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE5B9E19 /* 174.91.158.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6BA0B2 /* 174.107.160.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6E2875 /* 174.110.40.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE7FA9E9 /* 174.127.169.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE7FF4FC /* 174.127.244.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE886272 /* 174.136.98.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8A2CF2 /* 174.138.44.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8A3258 /* 174.138.50.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8A3B64 /* 174.138.59.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8AD3B4 /* 174.138.211.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8CE376 /* 174.140.227.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8DC829 /* 174.141.200.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8DC829 /* 174.141.200.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0090162 /* 176.9.1.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00901D3 /* 176.9.1.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0091170 /* 176.9.17.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009256F /* 176.9.37.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00927C4 /* 176.9.39.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0092843 /* 176.9.40.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0092883 /* 176.9.40.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00932F0 /* 176.9.50.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00935CA /* 176.9.53.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0093A9E /* 176.9.58.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0094B6E /* 176.9.75.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009542D /* 176.9.84.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00962E4 /* 176.9.98.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00972FC /* 176.9.114.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0097649 /* 176.9.118.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0097728 /* 176.9.119.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0097B7A /* 176.9.123.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009896E /* 176.9.137.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0099414 /* 176.9.148.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0099AF7 /* 176.9.154.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB009D00C /* 176.9.208.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C8 /* 176.10.99.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C9 /* 176.10.99.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CA /* 176.10.99.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CB /* 176.10.99.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CC /* 176.10.99.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CD /* 176.10.99.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CE /* 176.10.99.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CF /* 176.10.99.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D0 /* 176.10.99.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D1 /* 176.10.99.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D2 /* 176.10.99.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A68F0 /* 176.10.104.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A68F0 /* 176.10.104.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A6BB4 /* 176.10.107.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB014C4E0 /* 176.20.196.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F2395 /* 176.31.35.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F749B /* 176.31.116.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F7FBF /* 176.31.127.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FA359 /* 176.31.163.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FB41D /* 176.31.180.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FD356 /* 176.31.211.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FE54C /* 176.31.229.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB02475B9 /* 176.36.117.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB02496F6 /* 176.36.150.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0259926 /* 176.37.153.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB035168E /* 176.53.22.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0355A1A /* 176.53.90.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0394FF9 /* 176.57.79.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A59B6 /* 176.58.89.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6462 /* 176.58.100.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6E42 /* 176.58.110.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A7669 /* 176.58.118.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A799F /* 176.58.121.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A79B1 /* 176.58.121.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB043AAC0 /* 176.67.170.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB05F9467 /* 176.95.148.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB06AC987 /* 176.106.201.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB06BB01F /* 176.107.176.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB06BB393 /* 176.107.179.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB072F82F /* 176.114.248.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0746831 /* 176.116.104.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB074C0D7 /* 176.116.192.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0771D1C /* 176.119.29.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0771E26 /* 176.119.30.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0779C97 /* 176.119.156.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0779E1F /* 176.119.158.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0795133 /* 176.121.81.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B03DE /* 176.123.3.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0442 /* 176.123.4.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0504 /* 176.123.5.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B05C1 /* 176.123.5.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B05E3 /* 176.123.5.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B05FA /* 176.123.5.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B060D /* 176.123.6.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0629 /* 176.123.6.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0766 /* 176.123.7.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B07AC /* 176.123.7.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B07B5 /* 176.123.7.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B07C5 /* 176.123.7.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0856 /* 176.123.8.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B08E8 /* 176.123.8.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0AB1 /* 176.123.10.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EF231 /* 176.126.242.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0982DD5 /* 176.152.45.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB09EEC66 /* 176.158.236.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C1151D /* 176.193.21.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C179FB /* 176.193.121.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C6DBA5 /* 176.198.219.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0DF83D4 /* 176.223.131.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB0DF8D6A /* 176.223.141.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB122A49A /* 177.34.164.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB1435147 /* 177.67.81.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB1C64AFD /* 177.198.74.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB1EBD94F /* 177.235.217.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB20BD543 /* 178.11.213.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB20CFF6F /* 178.12.255.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA0D /* 178.17.170.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA17 /* 178.17.170.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA4D /* 178.17.170.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA58 /* 178.17.170.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA5B /* 178.17.170.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA67 /* 178.17.170.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA70 /* 178.17.170.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA74 /* 178.17.170.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA84 /* 178.17.170.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA87 /* 178.17.170.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA95 /* 178.17.170.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAA4 /* 178.17.170.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAA9 /* 178.17.170.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAB2 /* 178.17.170.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AAB3 /* 178.17.170.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB05 /* 178.17.171.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB27 /* 178.17.171.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB37 /* 178.17.171.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB4E /* 178.17.171.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB66 /* 178.17.171.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AB7C /* 178.17.171.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211ABC5 /* 178.17.171.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211ABE9 /* 178.17.171.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AD1A /* 178.17.173.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE02 /* 178.17.174.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE0A /* 178.17.174.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE0D /* 178.17.174.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE0E /* 178.17.174.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE44 /* 178.17.174.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AE4F /* 178.17.174.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AEA4 /* 178.17.174.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AEC4 /* 178.17.174.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AEC6 /* 178.17.174.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AED3 /* 178.17.174.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AEE8 /* 178.17.174.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AEEF /* 178.17.174.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AEF2 /* 178.17.174.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2125EF7 /* 178.18.94.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB213607D /* 178.19.96.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2143710 /* 178.20.55.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2143712 /* 178.20.55.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21AAF2E /* 178.26.175.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B5CB9 /* 178.27.92.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B5CB9 /* 178.27.92.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B709A /* 178.27.112.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220BD58 /* 178.32.189.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DC3D /* 178.32.220.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DE93 /* 178.32.222.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DF57 /* 178.32.223.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB221B7FB /* 178.33.183.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB224CD62 /* 178.36.205.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2271DB0 /* 178.39.29.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB227C793 /* 178.39.199.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB231B982 /* 178.49.185.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E18D4 /* 178.62.24.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2C12 /* 178.62.44.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E56CE /* 178.62.86.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5EF3 /* 178.62.94.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EEF39 /* 178.62.239.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EF9B8 /* 178.62.249.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFBB8 /* 178.62.251.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFC52 /* 178.62.252.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F12DF /* 178.63.18.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F137E /* 178.63.19.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F1B52 /* 178.63.27.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F28BD /* 178.63.40.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F28C5 /* 178.63.40.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F345A /* 178.63.52.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F444E /* 178.63.68.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F4502 /* 178.63.69.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F45FE /* 178.63.69.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F4818 /* 178.63.72.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F550E /* 178.63.85.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F57A5 /* 178.63.87.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F6122 /* 178.63.97.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F749D /* 178.63.116.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F8A11 /* 178.63.138.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FA97C /* 178.63.169.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FAC0D /* 178.63.172.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FAC0E /* 178.63.172.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB243A6C4 /* 178.67.166.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB249D276 /* 178.73.210.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24D63C7 /* 178.77.99.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24EC9C0 /* 178.78.201.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24ED425 /* 178.78.212.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24EF1B2 /* 178.78.241.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F83F7 /* 178.79.131.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F86C4 /* 178.79.134.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA1B1 /* 178.79.161.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA3AA /* 178.79.163.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA5A6 /* 178.79.165.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA9C1 /* 178.79.169.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB44F /* 178.79.180.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB63F /* 178.79.182.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB252D7DB /* 178.82.215.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2530C2F /* 178.83.12.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2807282 /* 178.128.114.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2807334 /* 178.128.115.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2807E3D /* 178.128.126.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280A87C /* 178.128.168.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280B6DF /* 178.128.182.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280CEB2 /* 178.128.206.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280EF81 /* 178.128.239.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280F732 /* 178.128.247.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280F988 /* 178.128.249.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB280F9F9 /* 178.128.249.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2840006 /* 178.132.0.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2844E94 /* 178.132.78.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB28C253A /* 178.140.37.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB28C5FA1 /* 178.140.95.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C2D2 /* 178.162.194.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C742 /* 178.162.199.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A548B1 /* 178.165.72.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AA0A08 /* 178.170.10.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AA0AAF /* 178.170.10.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AA2A70 /* 178.170.42.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF80B2 /* 178.175.128.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF83C2 /* 178.175.131.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF9494 /* 178.175.148.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF94E0 /* 178.175.148.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF94F1 /* 178.175.148.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2BDE121 /* 178.189.225.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C3CEC3 /* 178.195.206.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C3CEC3 /* 178.195.206.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C8A42E /* 178.200.164.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C9D8EF /* 178.201.216.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CA997A /* 178.202.153.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D12EAD /* 178.209.46.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE061 /* 178.238.224.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FA9DB1 /* 178.250.157.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE0758 /* 178.254.7.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE0919 /* 178.254.9.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1297 /* 178.254.18.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE149F /* 178.254.20.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1615 /* 178.254.22.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1E42 /* 178.254.30.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1E56 /* 178.254.30.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1F12 /* 178.254.31.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1F7D /* 178.254.31.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1FEE /* 178.254.31.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2363 /* 178.254.35.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2D40 /* 178.254.45.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB31AF66B /* 179.26.246.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B8010 /* 179.43.128.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B86BC /* 179.43.134.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B92E6 /* 179.43.146.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B9CD6 /* 179.43.156.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B9EB0 /* 179.43.158.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0A4 /* 179.43.160.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0EA /* 179.43.160.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0EB /* 179.43.160.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0EC /* 179.43.160.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0ED /* 179.43.160.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA0EE /* 179.43.160.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA7E2 /* 179.43.167.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA7E3 /* 179.43.167.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA7E4 /* 179.43.167.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA7E5 /* 179.43.167.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA7E6 /* 179.43.167.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA90E /* 179.43.169.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BA914 /* 179.43.169.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BBCCE /* 179.43.188.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB32BBE0A /* 179.43.190.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB330FBBC /* 179.48.251.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB4812E1B /* 180.129.46.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB4957D8A /* 180.149.125.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB4961BF6 /* 180.150.27.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB4961F82 /* 180.150.31.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB496E263 /* 180.150.226.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB52B851B /* 181.43.133.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB5771E1A /* 181.119.30.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB5A13315 /* 181.161.51.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB637F517 /* 182.55.245.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB6ABE944 /* 182.171.233.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB758284F /* 183.88.40.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB7B2BD65 /* 183.178.189.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB7B36EFA /* 183.179.110.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB838D75F /* 184.56.215.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB85A4952 /* 184.90.73.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8699232 /* 184.105.146.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB869DC18 /* 184.105.220.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB869DDF8 /* 184.105.221.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB869DDF9 /* 184.105.221.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB8946E18 /* 184.148.110.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB899B1AC /* 184.153.177.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9025229 /* 185.2.82.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9041D79 /* 185.4.29.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9048487 /* 185.4.132.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9048494 /* 185.4.132.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90484B7 /* 185.4.132.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9048668 /* 185.4.134.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9048668 /* 185.4.134.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9048787 /* 185.4.135.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB904879D /* 185.4.135.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9083F26 /* 185.8.63.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EC83 /* 185.8.236.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A1029 /* 185.10.16.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A4416 /* 185.10.68.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A4447 /* 185.10.68.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A444B /* 185.10.68.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A445C /* 185.10.68.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A44D7 /* 185.10.68.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90B925F /* 185.11.146.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C06EA /* 185.12.6.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C2D72 /* 185.12.45.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C2D73 /* 185.12.45.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C2D74 /* 185.12.45.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C2D75 /* 185.12.45.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C2D76 /* 185.12.45.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90E1E39 /* 185.14.30.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90F5C40 /* 185.15.92.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90F5C42 /* 185.15.92.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB90FF6F3 /* 185.15.246.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9103CCD /* 185.16.60.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9118FF7 /* 185.17.143.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB911B284 /* 185.17.178.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB911B865 /* 185.17.184.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9156432 /* 185.21.100.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D8C4 /* 185.21.216.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D8C5 /* 185.21.216.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D920 /* 185.21.217.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D920 /* 185.21.217.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D921 /* 185.21.217.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D921 /* 185.21.217.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D93C /* 185.21.217.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AC28 /* 185.22.172.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AC5C /* 185.22.172.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AC6A /* 185.22.172.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AC6A /* 185.22.172.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AD7A /* 185.22.173.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916ADB4 /* 185.22.173.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AE2E /* 185.22.174.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB916AE77 /* 185.22.174.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9193023 /* 185.25.48.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91932C7 /* 185.25.50.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91932C7 /* 185.25.50.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91933CA /* 185.25.51.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91933CA /* 185.25.51.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91B7F76 /* 185.27.127.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91C6513 /* 185.28.101.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB91F88F4 /* 185.31.136.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DDC9 /* 185.32.221.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DEAB /* 185.32.222.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DEAC /* 185.32.222.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DEAD /* 185.32.222.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DEED /* 185.32.222.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB920DEED /* 185.32.222.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9222102 /* 185.34.33.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9234EC8 /* 185.35.78.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB923C8FA /* 185.35.200.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB923CADE /* 185.35.202.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB926AF47 /* 185.38.175.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB926AF48 /* 185.38.175.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92AAACB /* 185.42.170.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92ADF6F /* 185.42.223.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB92B04B7 /* 185.43.4.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9358170 /* 185.53.129.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9385041 /* 185.56.80.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB938AB5E /* 185.56.171.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9479 /* 185.61.148.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94E1 /* 185.61.148.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93E9685 /* 185.62.150.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93FBCC8 /* 185.63.188.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB93FFD82 /* 185.63.253.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9406AAD /* 185.64.106.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9406AF4 /* 185.64.106.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94186AF /* 185.65.134.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94186AF /* 185.65.134.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94187B3 /* 185.65.135.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB941CD0A /* 185.65.205.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB941CE9A /* 185.65.206.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB941F150 /* 185.65.241.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB942FA28 /* 185.66.250.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F418 /* 185.72.244.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F425 /* 185.72.244.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F791 /* 185.72.247.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB949D303 /* 185.73.211.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB949DC08 /* 185.73.220.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB949F0CD /* 185.73.240.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB94ABE3C /* 185.74.190.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9501E66 /* 185.80.30.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB950DE9E /* 185.80.222.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB950DEA4 /* 185.80.222.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527E1E /* 185.82.126.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527E64 /* 185.82.126.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527EEE /* 185.82.126.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527EF9 /* 185.82.126.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527F07 /* 185.82.127.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527F0B /* 185.82.127.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9527F30 /* 185.82.127.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952D931 /* 185.82.217.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952DB55 /* 185.82.219.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB952DB6D /* 185.82.219.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95451F0 /* 185.84.81.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95605DF /* 185.86.5.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB956945A /* 185.86.148.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB956963A /* 185.86.150.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9569685 /* 185.86.150.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95697A8 /* 185.86.151.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3D5A /* 185.90.61.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DDA /* 185.90.61.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DDB /* 185.90.61.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DDC /* 185.90.61.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DDE /* 185.90.61.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DDF /* 185.90.61.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DE0 /* 185.90.61.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DEE /* 185.90.61.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DEF /* 185.90.61.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF0 /* 185.90.61.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF3 /* 185.90.61.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF4 /* 185.90.61.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF5 /* 185.90.61.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF6 /* 185.90.61.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF7 /* 185.90.61.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF8 /* 185.90.61.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB95A3DF9 /* 185.90.61.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB960D2C0 /* 185.96.210.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9612022 /* 185.97.32.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9616551 /* 185.97.101.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96302B2 /* 185.99.2.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96454D4 /* 185.100.84.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96454FB /* 185.100.84.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964553D /* 185.100.85.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645565 /* 185.100.85.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645584 /* 185.100.85.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645680 /* 185.100.86.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB964569A /* 185.100.86.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96456B6 /* 185.100.86.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645729 /* 185.100.87.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9645729 /* 185.100.87.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457CA /* 185.100.87.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457CE /* 185.100.87.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457CF /* 185.100.87.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457F0 /* 185.100.87.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457F1 /* 185.100.87.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457F2 /* 185.100.87.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457F3 /* 185.100.87.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457F4 /* 185.100.87.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457FA /* 185.100.87.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96457FB /* 185.100.87.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB965234F /* 185.101.35.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96523BD /* 185.101.35.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96569AD /* 185.101.105.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9676D44 /* 185.103.109.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9676E0E /* 185.103.110.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9676E90 /* 185.103.110.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9678712 /* 185.103.135.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9678713 /* 185.103.135.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB969BE56 /* 185.105.190.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96B2FAB /* 185.107.47.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96B2FD7 /* 185.107.47.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96B46CA /* 185.107.70.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96B4719 /* 185.107.71.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96B4729 /* 185.107.71.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96B5301 /* 185.107.83.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96C814E /* 185.108.129.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96C8172 /* 185.108.129.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96D40BF /* 185.109.64.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96D5B7E /* 185.109.91.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB96EB8AC /* 185.110.184.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9705232 /* 185.112.82.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB970900B /* 185.112.144.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9709014 /* 185.112.144.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB970929B /* 185.112.146.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB970929F /* 185.112.146.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9709D87 /* 185.112.157.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9718CB2 /* 185.113.140.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9718F56 /* 185.113.143.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9718F57 /* 185.113.143.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9718F59 /* 185.113.143.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9718F5B /* 185.113.143.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9718F5F /* 185.113.143.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9755244 /* 185.117.82.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9755247 /* 185.117.82.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97559A8 /* 185.117.89.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9757684 /* 185.117.118.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB975D709 /* 185.117.215.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB976A429 /* 185.118.164.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9794510 /* 185.121.69.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9794528 /* 185.121.69.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9794529 /* 185.121.69.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB979452A /* 185.121.69.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97DCEBA /* 185.125.206.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97DD942 /* 185.125.217.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97E7468 /* 185.126.116.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97E7469 /* 185.126.116.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97E746A /* 185.126.116.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB97E74EC /* 185.126.116.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9802952 /* 185.128.41.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9822C6C /* 185.130.44.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9822C7C /* 185.130.44.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9822CB4 /* 185.130.44.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9822D45 /* 185.130.45.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9861C4F /* 185.134.28.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB98EEC8E /* 185.142.236.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB98EEF31 /* 185.142.239.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB991824D /* 185.145.130.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9929D3B /* 185.146.157.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992E482 /* 185.146.228.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992E482 /* 185.146.228.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992E483 /* 185.146.228.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB992E483 /* 185.146.228.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9930A30 /* 185.147.10.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB994928F /* 185.148.146.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF02 /* 185.149.207.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF03 /* 185.149.207.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF41 /* 185.149.207.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF42 /* 185.149.207.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF43 /* 185.149.207.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF44 /* 185.149.207.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF45 /* 185.149.207.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF46 /* 185.149.207.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB995CF6F /* 185.149.207.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9967502 /* 185.150.117.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB996751C /* 185.150.117.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB996754B /* 185.150.117.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99675C8 /* 185.150.117.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB996A21B /* 185.150.162.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99CAD94 /* 185.156.173.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99DA0CA /* 185.157.160.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99DA104 /* 185.157.161.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99E726A /* 185.158.114.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99EFB28 /* 185.158.251.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99F4506 /* 185.159.69.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99F45EA /* 185.159.69.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99F462F /* 185.159.70.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB99F4674 /* 185.159.70.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A06EB7 /* 185.160.110.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2F97E /* 185.162.249.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2FB1C /* 185.162.251.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2FB1C /* 185.162.251.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2FB5E /* 185.162.251.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2FB7A /* 185.162.251.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2FB87 /* 185.162.251.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A2FBF9 /* 185.162.251.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32D6B /* 185.163.45.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DD4 /* 185.163.45.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DF7 /* 185.163.45.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32DFD /* 185.163.45.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A32E8A /* 185.163.46.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A376E2 /* 185.163.118.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A84D /* 185.165.168.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A8A8 /* 185.165.168.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A8E5 /* 185.165.168.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A98A /* 185.165.169.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5A9DE /* 185.165.169.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5F07E /* 185.165.240.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A5F205 /* 185.165.242.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9A81568 /* 185.168.21.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AA711C /* 185.170.113.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AA711C /* 185.170.113.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AA7165 /* 185.170.113.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AA7219 /* 185.170.114.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9ADB199 /* 185.173.177.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9AF3878 /* 185.175.56.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B0F758 /* 185.176.247.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B17F22 /* 185.177.127.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B19721 /* 185.177.151.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B1972A /* 185.177.151.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B53CB5 /* 185.181.60.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B5A0D8 /* 185.181.160.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B5E54D /* 185.181.229.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B79F63 /* 185.183.159.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B79F63 /* 185.183.159.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B7C230 /* 185.183.194.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B7C25A /* 185.183.194.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B945D4 /* 185.185.69.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B94745 /* 185.185.71.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9B9AA1B /* 185.185.170.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BA4DE9 /* 185.186.77.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BA4E78 /* 185.186.78.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BA4F9F /* 185.186.79.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BA4FFB /* 185.186.79.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BCB6D5 /* 185.188.182.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BD32FD /* 185.189.50.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BD70A2 /* 185.189.112.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BDB78F /* 185.189.183.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BF7C8F /* 185.191.124.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9BFCCFE /* 185.191.204.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C17E1A /* 185.193.126.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C17FA7 /* 185.193.127.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C28CC9 /* 185.194.140.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C3ED18 /* 185.195.237.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C3ED19 /* 185.195.237.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C3ED75 /* 185.195.237.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C3ED76 /* 185.195.237.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C402FB /* 185.196.2.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C61A95 /* 185.198.26.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9C638AF /* 185.198.56.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CB761B /* 185.203.118.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CC01EF /* 185.204.1.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CDBB45 /* 185.205.187.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CDD123 /* 185.205.209.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CDD285 /* 185.205.210.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CDD2F5 /* 185.205.210.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9CFCD95 /* 185.207.205.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D3132B /* 185.211.19.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D4956F /* 185.212.149.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D4957D /* 185.212.149.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D51467 /* 185.213.20.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D51468 /* 185.213.20.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D51469 /* 185.213.20.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D5146A /* 185.213.20.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D5146B /* 185.213.20.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D514D5 /* 185.213.20.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D514F7 /* 185.213.20.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D5150A /* 185.213.21.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D5150B /* 185.213.21.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D59BA9 /* 185.213.155.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D59BA9 /* 185.213.155.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D82082 /* 185.216.32.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D8B0D2 /* 185.216.176.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D8B365 /* 185.216.179.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D90055 /* 185.217.0.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D90060 /* 185.217.0.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9D95F19 /* 185.217.95.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F0 /* 185.220.100.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F0 /* 185.220.100.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F1 /* 185.220.100.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F1 /* 185.220.100.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F2 /* 185.220.100.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F2 /* 185.220.100.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F3 /* 185.220.100.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F3 /* 185.220.100.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F4 /* 185.220.100.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F4 /* 185.220.100.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F5 /* 185.220.100.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F5 /* 185.220.100.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F6 /* 185.220.100.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F6 /* 185.220.100.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F7 /* 185.220.100.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F7 /* 185.220.100.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F8 /* 185.220.100.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F8 /* 185.220.100.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F9 /* 185.220.100.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64F9 /* 185.220.100.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FA /* 185.220.100.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FA /* 185.220.100.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FB /* 185.220.100.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FB /* 185.220.100.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FC /* 185.220.100.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FC /* 185.220.100.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FD /* 185.220.100.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FD /* 185.220.100.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FE /* 185.220.100.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FE /* 185.220.100.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FF /* 185.220.100.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC64FF /* 185.220.100.255/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6501 /* 185.220.101.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6501 /* 185.220.101.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6502 /* 185.220.101.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6502 /* 185.220.101.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6503 /* 185.220.101.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6504 /* 185.220.101.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6504 /* 185.220.101.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6505 /* 185.220.101.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6505 /* 185.220.101.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6506 /* 185.220.101.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6506 /* 185.220.101.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6507 /* 185.220.101.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6507 /* 185.220.101.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6508 /* 185.220.101.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6508 /* 185.220.101.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6509 /* 185.220.101.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6509 /* 185.220.101.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650A /* 185.220.101.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650A /* 185.220.101.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650B /* 185.220.101.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650B /* 185.220.101.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650C /* 185.220.101.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650C /* 185.220.101.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650D /* 185.220.101.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650D /* 185.220.101.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650E /* 185.220.101.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650E /* 185.220.101.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650F /* 185.220.101.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC650F /* 185.220.101.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6510 /* 185.220.101.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6510 /* 185.220.101.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6511 /* 185.220.101.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6511 /* 185.220.101.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6512 /* 185.220.101.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6512 /* 185.220.101.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6513 /* 185.220.101.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6513 /* 185.220.101.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6514 /* 185.220.101.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6514 /* 185.220.101.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6515 /* 185.220.101.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6515 /* 185.220.101.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6516 /* 185.220.101.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6516 /* 185.220.101.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6517 /* 185.220.101.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6517 /* 185.220.101.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6518 /* 185.220.101.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6518 /* 185.220.101.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6581 /* 185.220.101.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6581 /* 185.220.101.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6582 /* 185.220.101.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6582 /* 185.220.101.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6583 /* 185.220.101.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6584 /* 185.220.101.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6584 /* 185.220.101.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6585 /* 185.220.101.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6585 /* 185.220.101.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6586 /* 185.220.101.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6586 /* 185.220.101.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6587 /* 185.220.101.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6587 /* 185.220.101.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6588 /* 185.220.101.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6589 /* 185.220.101.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6589 /* 185.220.101.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658A /* 185.220.101.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658A /* 185.220.101.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658B /* 185.220.101.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658B /* 185.220.101.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658C /* 185.220.101.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658C /* 185.220.101.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658D /* 185.220.101.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658D /* 185.220.101.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658E /* 185.220.101.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658E /* 185.220.101.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC658F /* 185.220.101.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6590 /* 185.220.101.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6590 /* 185.220.101.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6591 /* 185.220.101.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6591 /* 185.220.101.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6592 /* 185.220.101.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6592 /* 185.220.101.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6593 /* 185.220.101.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6593 /* 185.220.101.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6594 /* 185.220.101.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6594 /* 185.220.101.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6595 /* 185.220.101.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6595 /* 185.220.101.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6596 /* 185.220.101.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6596 /* 185.220.101.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6597 /* 185.220.101.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C1 /* 185.220.101.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C1 /* 185.220.101.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C2 /* 185.220.101.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C2 /* 185.220.101.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C3 /* 185.220.101.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C3 /* 185.220.101.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C4 /* 185.220.101.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C4 /* 185.220.101.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C5 /* 185.220.101.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C5 /* 185.220.101.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C6 /* 185.220.101.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C6 /* 185.220.101.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C7 /* 185.220.101.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C7 /* 185.220.101.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C8 /* 185.220.101.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C8 /* 185.220.101.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C9 /* 185.220.101.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65C9 /* 185.220.101.201/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CA /* 185.220.101.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CA /* 185.220.101.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CB /* 185.220.101.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CB /* 185.220.101.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CC /* 185.220.101.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CC /* 185.220.101.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CD /* 185.220.101.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CD /* 185.220.101.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CE /* 185.220.101.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CE /* 185.220.101.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CF /* 185.220.101.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65CF /* 185.220.101.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D0 /* 185.220.101.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D0 /* 185.220.101.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D1 /* 185.220.101.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D1 /* 185.220.101.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D2 /* 185.220.101.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D2 /* 185.220.101.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D3 /* 185.220.101.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D3 /* 185.220.101.211/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D4 /* 185.220.101.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D4 /* 185.220.101.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D5 /* 185.220.101.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D5 /* 185.220.101.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D6 /* 185.220.101.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D6 /* 185.220.101.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D7 /* 185.220.101.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D7 /* 185.220.101.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D8 /* 185.220.101.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D8 /* 185.220.101.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D9 /* 185.220.101.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65D9 /* 185.220.101.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65DA /* 185.220.101.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65DA /* 185.220.101.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65DB /* 185.220.101.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65DB /* 185.220.101.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC65DC /* 185.220.101.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6604 /* 185.220.102.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6604 /* 185.220.102.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6606 /* 185.220.102.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6606 /* 185.220.102.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6607 /* 185.220.102.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6607 /* 185.220.102.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6608 /* 185.220.102.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6608 /* 185.220.102.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F0 /* 185.220.102.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F0 /* 185.220.102.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F1 /* 185.220.102.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F1 /* 185.220.102.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F2 /* 185.220.102.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F2 /* 185.220.102.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F3 /* 185.220.102.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F3 /* 185.220.102.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F4 /* 185.220.102.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F4 /* 185.220.102.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F5 /* 185.220.102.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F5 /* 185.220.102.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F6 /* 185.220.102.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F6 /* 185.220.102.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F7 /* 185.220.102.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F7 /* 185.220.102.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F8 /* 185.220.102.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F8 /* 185.220.102.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F9 /* 185.220.102.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66F9 /* 185.220.102.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FA /* 185.220.102.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FA /* 185.220.102.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FB /* 185.220.102.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FB /* 185.220.102.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FC /* 185.220.102.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FC /* 185.220.102.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FD /* 185.220.102.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FD /* 185.220.102.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FE /* 185.220.102.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC66FE /* 185.220.102.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6704 /* 185.220.103.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6705 /* 185.220.103.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6706 /* 185.220.103.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6707 /* 185.220.103.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6708 /* 185.220.103.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC6709 /* 185.220.103.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DC670A /* 185.220.103.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DECA0C /* 185.222.202.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DECA68 /* 185.222.202.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9DECA85 /* 185.222.202.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E0535D /* 185.224.83.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E11092 /* 185.225.16.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E11103 /* 185.225.17.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E113CC /* 185.225.19.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E113E6 /* 185.225.19.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E14485 /* 185.225.68.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E1453B /* 185.225.69.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E1453C /* 185.225.69.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E1455A /* 185.225.69.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E1455B /* 185.225.69.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E14562 /* 185.225.69.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E3444E /* 185.227.68.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E34452 /* 185.227.68.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E34BFA /* 185.227.75.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E35207 /* 185.227.82.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E35238 /* 185.227.82.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E3523F /* 185.227.82.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E48AFC /* 185.228.138.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E48B66 /* 185.228.139.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E84427 /* 185.232.68.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E96417 /* 185.233.100.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E968AC /* 185.233.104.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E96A22 /* 185.233.106.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E96B65 /* 185.233.107.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E96B65 /* 185.233.107.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E96B6E /* 185.233.107.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E96B6E /* 185.233.107.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E9BA92 /* 185.233.186.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E9FC0E /* 185.233.252.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9E9FC0E /* 185.233.252.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9ECCBCB /* 185.236.203.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9EE8020 /* 185.238.128.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9EE8109 /* 185.238.129.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9EE8119 /* 185.238.129.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9EE89A7 /* 185.238.137.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9EFC90B /* 185.239.201.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F0665A /* 185.240.102.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F268AF /* 185.242.104.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F271E0 /* 185.242.113.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F271F2 /* 185.242.113.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F2B448 /* 185.242.180.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F37055 /* 185.243.112.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F3DA16 /* 185.243.218.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F4275B /* 185.244.39.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F48015 /* 185.244.128.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F494ED /* 185.244.148.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F4C077 /* 185.244.192.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F4C09B /* 185.244.192.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F4C0F7 /* 185.244.192.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F4C18D /* 185.244.193.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F68082 /* 185.246.128.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F680A1 /* 185.246.128.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F69816 /* 185.246.152.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F6B6C5 /* 185.246.182.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E00E /* 185.247.224.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E06C /* 185.247.224.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E06D /* 185.247.224.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E06E /* 185.247.224.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E06F /* 185.247.224.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E070 /* 185.247.224.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F7E071 /* 185.247.224.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F8A015 /* 185.248.160.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9F8A041 /* 185.248.160.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9FBA54A /* 185.251.165.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xB9FDDBA0 /* 185.253.219.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBA69411F /* 186.105.65.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBAD1BAA3 /* 186.209.186.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBB14AFD4 /* 187.20.175.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBB3F6418 /* 187.63.100.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBB797571 /* 187.121.117.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC1622DB /* 188.22.34.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC173AEE /* 188.23.58.238/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC175DD7 /* 188.23.93.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC18BAF7 /* 188.24.186.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC1AC425 /* 188.26.196.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC20529A /* 188.32.82.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22A6DA /* 188.34.166.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22B40B /* 188.34.180.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22B5CD /* 188.34.181.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22B7A4 /* 188.34.183.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C78B /* 188.34.199.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C78E /* 188.34.199.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C78F /* 188.34.199.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C884 /* 188.34.200.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C944 /* 188.34.201.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C945 /* 188.34.201.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC22C946 /* 188.34.201.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2821D9 /* 188.40.33.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC282973 /* 188.40.41.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286345 /* 188.40.99.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286B7E /* 188.40.107.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2880F6 /* 188.40.128.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2893B1 /* 188.40.147.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC289F7A /* 188.40.159.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28A61D /* 188.40.166.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28EE90 /* 188.40.238.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3D18EC /* 188.61.24.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3D4D15 /* 188.61.77.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3D987C /* 188.61.152.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3DCF79 /* 188.61.207.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3E6D92 /* 188.62.109.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44241C /* 188.68.36.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44242E /* 188.68.36.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4424D1 /* 188.68.36.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44269C /* 188.68.38.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442977 /* 188.68.41.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442A53 /* 188.68.42.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442BC0 /* 188.68.43.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442BDA /* 188.68.43.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442D48 /* 188.68.45.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442DB4 /* 188.68.45.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442EA4 /* 188.68.46.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC442EF5 /* 188.68.46.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44355C /* 188.68.53.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44355C /* 188.68.53.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC443732 /* 188.68.55.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC443732 /* 188.68.55.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC44E053 /* 188.68.224.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4CFE40 /* 188.76.254.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4DEF5E /* 188.77.239.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC528030 /* 188.82.128.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC52C517 /* 188.82.197.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC728CE9 /* 188.114.140.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC728CE9 /* 188.114.140.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC76C6F4 /* 188.118.198.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78EA1A /* 188.120.234.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7E5326 /* 188.126.83.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7F1525 /* 188.127.21.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7F453C /* 188.127.69.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7FA71B /* 188.127.167.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7FC52A /* 188.127.197.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7FE266 /* 188.127.226.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A2195 /* 188.138.33.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A21E9 /* 188.138.33.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A480A /* 188.138.72.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A4B65 /* 188.138.75.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A6662 /* 188.138.102.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A703C /* 188.138.112.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8D3CBE /* 188.141.60.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8F4BC1 /* 188.143.75.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC96821F /* 188.150.130.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC97CA35 /* 188.151.202.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBC9A9107 /* 188.154.145.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA50642 /* 188.165.6.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5C098 /* 188.165.192.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5D498 /* 188.165.212.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5DC22 /* 188.165.220.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5FF54 /* 188.165.255.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6085B /* 188.166.8.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6210F /* 188.166.33.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA626EF /* 188.166.38.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA64569 /* 188.166.69.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA65788 /* 188.166.87.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA65BC2 /* 188.166.91.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA65DA3 /* 188.166.93.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA66138 /* 188.166.97.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA8225A /* 188.168.34.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCADAA10 /* 188.173.170.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCBE6DFA /* 188.190.109.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC0C833 /* 188.192.200.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC21A69 /* 188.194.26.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC36D2D /* 188.195.109.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC3D962 /* 188.195.217.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD1341F /* 188.209.52.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD5316D /* 188.213.49.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD58639 /* 188.213.134.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD66892 /* 188.214.104.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD680B5 /* 188.214.128.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD68431 /* 188.214.132.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD91C7B /* 188.217.28.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE26BCB /* 188.226.107.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE298D2 /* 188.226.152.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE29AB4 /* 188.226.154.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DDF3 /* 188.226.221.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DE13 /* 188.226.222.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE33A1C /* 188.227.58.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE3CE65 /* 188.227.206.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF0D06A /* 188.240.208.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF0D214 /* 188.240.210.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF0D232 /* 188.240.210.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF2343B /* 188.242.52.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF42B19 /* 188.244.43.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBCFA44E9 /* 188.250.68.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBD54152C /* 189.84.21.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBD6E2D40 /* 189.110.45.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBD848E37 /* 189.132.142.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBDC3D40D /* 189.195.212.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0285E3 /* 190.2.133.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE029107 /* 190.2.145.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE02925A /* 190.2.146.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0832 /* 190.10.8.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0844 /* 190.10.8.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A0898 /* 190.10.8.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE0A08A6 /* 190.10.8.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE61A58D /* 190.97.165.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE93B2D8 /* 190.147.178.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBE96EA25 /* 190.150.234.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBED3FED2 /* 190.211.254.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBEEFDD82 /* 190.239.221.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBF5C7544 /* 191.92.117.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBF60D082 /* 191.96.208.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xBFDD08DD /* 191.221.8.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0008056 /* 192.0.128.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC003941B /* 192.3.148.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC021C118 /* 192.33.193.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02250B0 /* 192.34.80.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0242621 /* 192.36.38.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02838E9 /* 192.40.56.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7166 /* 192.42.113.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7365 /* 192.42.115.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7366 /* 192.42.115.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A740D /* 192.42.116.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A740E /* 192.42.116.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A740F /* 192.42.116.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7410 /* 192.42.116.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7411 /* 192.42.116.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7412 /* 192.42.116.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7413 /* 192.42.116.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7414 /* 192.42.116.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7416 /* 192.42.116.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7417 /* 192.42.116.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7418 /* 192.42.116.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7419 /* 192.42.116.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A741A /* 192.42.116.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A741B /* 192.42.116.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A741C /* 192.42.116.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A74A1 /* 192.42.116.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02C1E28 /* 192.44.30.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02EDF97 /* 192.46.223.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC02EE13A /* 192.46.225.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC034A746 /* 192.52.167.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC034A747 /* 192.52.167.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC05183BE /* 192.81.131.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0571C1C /* 192.87.28.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0571C52 /* 192.87.28.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F1B8F /* 192.95.27.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC06305DD /* 192.99.5.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630B28 /* 192.99.11.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630BB1 /* 192.99.11.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630C28 /* 192.99.12.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630D1C /* 192.99.13.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632230 /* 192.99.34.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC063235B /* 192.99.35.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632A22 /* 192.99.42.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632BAB /* 192.99.43.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0634511 /* 192.99.69.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC06397AA /* 192.99.151.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0639832 /* 192.99.152.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC06F967E /* 192.111.150.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0776C72 /* 192.119.108.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0792C1A /* 192.121.44.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC07CFA53 /* 192.124.250.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0912DBE /* 192.145.45.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0912EF7 /* 192.145.46.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B556A /* 192.155.85.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B59A9 /* 192.155.89.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A4 /* 192.160.102.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A5 /* 192.160.102.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A6 /* 192.160.102.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A8 /* 192.160.102.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066A9 /* 192.160.102.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A066AA /* 192.160.102.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A28D35 /* 192.162.141.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A6F58A /* 192.166.245.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A6F5B0 /* 192.166.245.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0BB6ABE /* 192.187.106.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0C3500A /* 192.195.80.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D28FDC /* 192.210.143.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2CB32 /* 192.210.203.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2CECB /* 192.210.206.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0DEB2BD /* 192.222.178.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0DEF814 /* 192.222.248.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0ECB105 /* 192.236.177.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B714 /* 192.241.183.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1E9CB /* 192.241.233.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1FC3F /* 192.241.252.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F36D1F /* 192.243.109.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC0FE4F8A /* 192.254.79.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC100D52A /* 193.0.213.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1010CA6 /* 193.1.12.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722B /* 193.11.114.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722D /* 193.11.114.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722E /* 193.11.114.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA4F3 /* 193.11.164.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA6C4 /* 193.11.166.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11964B4 /* 193.25.100.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11A9C56 /* 193.26.156.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11A9D34 /* 193.26.157.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11A9D34 /* 193.26.157.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11D23CD /* 193.29.35.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11D3967 /* 193.29.57.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11D3E21 /* 193.29.62.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11E7B46 /* 193.30.123.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11E7B71 /* 193.30.123.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11F189A /* 193.31.24.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC11F1B5D /* 193.31.27.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1207EA0 /* 193.32.126.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1207EA0 /* 193.32.126.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC122A6D7 /* 193.34.166.215/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1253A8E /* 193.37.58.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC125D505 /* 193.37.213.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1263681 /* 193.38.54.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1268905 /* 193.38.137.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC12A9C6A /* 193.42.156.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC12F93FB /* 193.47.147.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC12F93FC /* 193.47.147.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC138F04A /* 193.56.240.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC13F3A4C /* 193.63.58.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1462879 /* 193.70.40.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1462B4C /* 193.70.43.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC14670A5 /* 193.70.112.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC14D99DD /* 193.77.153.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC14DB639 /* 193.77.182.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1504103 /* 193.80.65.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC151DFEB /* 193.81.223.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC168DC23 /* 193.104.220.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC168DC5E /* 193.104.220.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1694950 /* 193.105.73.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16A1F02 /* 193.106.31.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16AA669 /* 193.106.166.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16AA669 /* 193.106.166.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16C7529 /* 193.108.117.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16C7529 /* 193.108.117.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16C753B /* 193.108.117.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16C7567 /* 193.108.117.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16C75D1 /* 193.108.117.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F1A25 /* 193.111.26.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F73D2 /* 193.111.115.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1870ADB /* 193.135.10.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1944531 /* 193.148.69.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1944604 /* 193.148.70.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC19446E0 /* 193.148.70.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC19446E3 /* 193.148.70.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC196161B /* 193.150.22.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC19AE1EB /* 193.154.225.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A02013 /* 193.160.32.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A02017 /* 193.160.32.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A1C163 /* 193.161.193.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A5BD06 /* 193.165.189.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A99142 /* 193.169.145.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A991C2 /* 193.169.145.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A991CA /* 193.169.145.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B055B7 /* 193.176.85.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B63D09 /* 193.182.61.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B66FB6 /* 193.182.111.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B69035 /* 193.182.144.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B762E0 /* 193.183.98.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1BBAD04 /* 193.187.173.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1BEA835 /* 193.190.168.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1C8F10B /* 193.200.241.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA763E /* 193.218.118.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA765A /* 193.218.118.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA7664 /* 193.218.118.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA7674 /* 193.218.118.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA767D /* 193.218.118.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA7691 /* 193.218.118.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA769B /* 193.218.118.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA769C /* 193.218.118.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA76A0 /* 193.218.118.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA76A7 /* 193.218.118.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA76B7 /* 193.218.118.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DA76E7 /* 193.218.118.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E0A32B /* 193.224.163.43/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E99A5F /* 193.233.154.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F37 /* 193.234.15.55/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F38 /* 193.234.15.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F39 /* 193.234.15.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F3A /* 193.234.15.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F3B /* 193.234.15.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F3C /* 193.234.15.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F3D /* 193.234.15.61/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EA0F3E /* 193.234.15.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EAE143 /* 193.234.225.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EFE865 /* 193.239.232.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC1EFE866 /* 193.239.232.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC205F92E /* 194.5.249.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC205F992 /* 194.5.249.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC209AD6B /* 194.9.173.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC20D5383 /* 194.13.83.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2249057 /* 194.36.144.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2249103 /* 194.36.145.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2277F28 /* 194.39.127.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2370D31 /* 194.55.13.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2370D32 /* 194.55.13.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC23B2E02 /* 194.59.46.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC23BCE36 /* 194.59.206.54/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC23BCFC6 /* 194.59.207.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC258690D /* 194.88.105.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC258691E /* 194.88.105.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2588F42 /* 194.88.143.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC263680C /* 194.99.104.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC26DC18E /* 194.109.193.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC27CFAD4 /* 194.124.250.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC27CFAD5 /* 194.124.250.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC27EAF9D /* 194.126.175.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC28C753A /* 194.140.117.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC291960F /* 194.145.150.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC29C4378 /* 194.156.67.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2A9506F /* 194.169.80.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A47 /* 194.180.154.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A48 /* 194.180.154.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A49 /* 194.180.154.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A4A /* 194.180.154.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A4B /* 194.180.154.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A4C /* 194.180.154.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A4D /* 194.180.154.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B49A4E /* 194.180.154.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2B649E0 /* 194.182.73.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BBCF2D /* 194.187.207.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BBF974 /* 194.187.249.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BFE1F0 /* 194.191.225.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2BFE9D5 /* 194.191.233.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2E6FD33 /* 194.230.253.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC2EC871A /* 194.236.135.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC312101E /* 195.18.16.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC327F7A4 /* 195.39.247.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC328B522 /* 195.40.181.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC343BFD2 /* 195.67.191.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC343BFD2 /* 195.67.191.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3458F8E /* 195.69.143.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3474454 /* 195.71.68.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC350971E /* 195.80.151.30/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC35AC816 /* 195.90.200.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC371C63E /* 195.113.198.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37AB5F2 /* 195.122.181.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD107 /* 195.123.209.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD15B /* 195.123.209.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD15B /* 195.123.209.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD29E /* 195.123.210.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD471 /* 195.123.212.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BD4E4 /* 195.123.212.228/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BEEA4 /* 195.123.238.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC37BF58D /* 195.123.245.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3858377 /* 195.133.131.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC387C286 /* 195.135.194.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3901588 /* 195.144.21.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39015B6 /* 195.144.21.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39015DB /* 195.144.21.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3947CC7 /* 195.148.124.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A1CC8 /* 195.154.28.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A69AA /* 195.154.105.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A69F1 /* 195.154.105.241/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6A3C /* 195.154.106.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6A58 /* 195.154.106.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6A6A /* 195.154.106.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6A93 /* 195.154.106.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6B0C /* 195.154.107.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7240 /* 195.154.114.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A72A8 /* 195.154.114.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7725 /* 195.154.119.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A77CB /* 195.154.119.203/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A8571 /* 195.154.133.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A857C /* 195.154.133.124/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A9C05 /* 195.154.156.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA46F /* 195.154.164.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA4F3 /* 195.154.164.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AB673 /* 195.154.182.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AD15B /* 195.154.209.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AE287 /* 195.154.226.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AE9B7 /* 195.154.233.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AEBBE /* 195.154.235.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AED79 /* 195.154.237.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AED93 /* 195.154.237.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AEDB3 /* 195.154.237.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF007 /* 195.154.240.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF091 /* 195.154.240.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF17D /* 195.154.241.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF1AB /* 195.154.241.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF1B4 /* 195.154.241.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFAC0 /* 195.154.250.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFAEF /* 195.154.250.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFB19 /* 195.154.251.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFBBF /* 195.154.251.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFBC6 /* 195.154.251.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFC58 /* 195.154.252.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFC97 /* 195.154.252.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFCA7 /* 195.154.252.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFDE2 /* 195.154.253.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFF5A /* 195.154.255.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFF77 /* 195.154.255.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFFAE /* 195.154.255.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A97DE2 /* 195.169.125.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00313 /* 195.176.3.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00313 /* 195.176.3.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00314 /* 195.176.3.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00314 /* 195.176.3.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00317 /* 195.176.3.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00317 /* 195.176.3.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00318 /* 195.176.3.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B00318 /* 195.176.3.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3BD6094 /* 195.189.96.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3BDE330 /* 195.189.227.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3BF5107 /* 195.191.81.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C903E9 /* 195.201.3.233/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C90925 /* 195.201.9.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9154B /* 195.201.21.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C916EA /* 195.201.22.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C91AAF /* 195.201.26.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C91DFC /* 195.201.29.252/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C921D8 /* 195.201.33.216/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9274E /* 195.201.39.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C93EEF /* 195.201.62.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C95BF3 /* 195.201.91.243/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C95E71 /* 195.201.94.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9673B /* 195.201.103.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C971C1 /* 195.201.113.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C98DA6 /* 195.201.141.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9A854 /* 195.201.168.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9A86F /* 195.201.168.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9E258 /* 195.201.226.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C9EB60 /* 195.201.235.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3CE69D9 /* 195.206.105.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3CE69E3 /* 195.206.105.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3D38FDF /* 195.211.143.223/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E61626 /* 195.230.22.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E617C3 /* 195.230.23.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E617C4 /* 195.230.23.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E6A853 /* 195.230.168.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3EA9856 /* 195.234.152.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3FE86C2 /* 195.254.134.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC3FE874C /* 195.254.135.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC55184AB /* 197.81.132.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC60C58C3 /* 198.12.88.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC60D327E /* 198.13.50.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC60D3666 /* 198.13.54.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC60D36B8 /* 198.13.54.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC610460A /* 198.16.70.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6105C9D /* 198.16.92.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6106D1F /* 198.16.109.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC618A462 /* 198.24.164.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC618A8E2 /* 198.24.168.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B4033 /* 198.27.64.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E8A28 /* 198.46.138.40/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62EBE93 /* 198.46.190.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC62EF824 /* 198.46.248.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63280ED /* 198.50.128.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632BF5F /* 198.50.191.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632C48A /* 198.50.196.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC632EE80 /* 198.50.238.128/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC636806C /* 198.54.128.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A672F /* 198.58.103.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6B35 /* 198.58.107.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A744F /* 198.58.116.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A7A4B /* 198.58.122.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A7D72 /* 198.58.125.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6487B6D /* 198.72.123.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6493242 /* 198.73.50.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3379 /* 198.74.51.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3442 /* 198.74.52.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3939 /* 198.74.57.57/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3D33 /* 198.74.61.51/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC65BAC0D /* 198.91.172.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6609B03 /* 198.96.155.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6609B09 /* 198.96.155.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66230AF /* 198.98.48.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623120 /* 198.98.49.32/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623270 /* 198.98.50.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623397 /* 198.98.51.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623397 /* 198.98.51.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66233BD /* 198.98.51.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC662348F /* 198.98.52.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623669 /* 198.98.54.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66239CF /* 198.98.57.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66239CF /* 198.98.57.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623A42 /* 198.98.58.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623C5A /* 198.98.60.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623D10 /* 198.98.61.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623D83 /* 198.98.61.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623E38 /* 198.98.62.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623E78 /* 198.98.62.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC664900B /* 198.100.144.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649014 /* 198.100.144.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC664910D /* 198.100.145.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649159 /* 198.100.145.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66492B3 /* 198.100.146.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649331 /* 198.100.147.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC664933B /* 198.100.147.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649463 /* 198.100.148.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC664946A /* 198.100.148.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC664948C /* 198.100.148.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66494AD /* 198.100.148.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66494CD /* 198.100.148.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66494DE /* 198.100.148.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC66494E5 /* 198.100.148.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC664954D /* 198.100.149.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC690795D /* 198.144.121.93/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC69465C5 /* 198.148.101.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7C234 /* 198.167.194.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7CEAE /* 198.167.206.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6B49609 /* 198.180.150.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C75CD9 /* 198.199.92.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C7640A /* 198.199.100.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77079 /* 198.199.112.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77686 /* 198.199.118.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77E2D /* 198.199.126.45/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6CCF86A /* 198.204.248.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D3224D /* 198.211.34.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D36767 /* 198.211.103.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53106 /* 198.245.49.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F5310A /* 198.245.49.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53112 /* 198.245.49.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F5311F /* 198.245.49.31/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F5318D /* 198.245.49.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F531BF /* 198.245.49.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F5328E /* 198.245.50.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F5328F /* 198.245.50.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F532AF /* 198.245.50.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F532D0 /* 198.245.50.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C15 /* 198.245.60.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C5B /* 198.245.60.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C68 /* 198.245.60.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C6D /* 198.245.60.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C8D /* 198.245.60.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D4D /* 198.245.61.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D4F /* 198.245.61.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D6D /* 198.245.61.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D75 /* 198.245.61.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D84 /* 198.245.61.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53D8F /* 198.245.61.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53DAB /* 198.245.61.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53DC4 /* 198.245.61.196/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53E7A /* 198.245.62.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53E99 /* 198.245.62.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53F41 /* 198.245.63.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB4490 /* 198.251.68.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB509D /* 198.251.80.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB50D5 /* 198.251.80.213/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB53C1 /* 198.251.83.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB53F8 /* 198.251.83.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB544A /* 198.251.84.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB57E2 /* 198.251.87.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FB5950 /* 198.251.89.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FF1502 /* 198.255.21.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FF700A /* 198.255.112.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC70FFAD2 /* 199.15.250.210/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC73A518C /* 199.58.81.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7737246 /* 199.115.114.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7A73B5F /* 199.167.59.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7B8D70B /* 199.184.215.11/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7B8F6FA /* 199.184.246.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3F913 /* 199.195.249.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FA4D /* 199.195.250.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FA94 /* 199.195.250.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FB54 /* 199.195.251.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FD1A /* 199.195.253.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FE51 /* 199.195.254.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FE51 /* 199.195.254.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3FEFE /* 199.195.254.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E640 /* 199.249.230.64/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E641 /* 199.249.230.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E642 /* 199.249.230.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E643 /* 199.249.230.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E644 /* 199.249.230.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E645 /* 199.249.230.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E646 /* 199.249.230.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E647 /* 199.249.230.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E648 /* 199.249.230.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E649 /* 199.249.230.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E64A /* 199.249.230.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E64B /* 199.249.230.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E64C /* 199.249.230.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E64D /* 199.249.230.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E64E /* 199.249.230.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E64F /* 199.249.230.79/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E650 /* 199.249.230.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E651 /* 199.249.230.81/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E652 /* 199.249.230.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E653 /* 199.249.230.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E654 /* 199.249.230.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E655 /* 199.249.230.85/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E656 /* 199.249.230.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E657 /* 199.249.230.87/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E658 /* 199.249.230.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E659 /* 199.249.230.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E664 /* 199.249.230.100/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E665 /* 199.249.230.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E666 /* 199.249.230.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E667 /* 199.249.230.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E668 /* 199.249.230.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E669 /* 199.249.230.105/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E66A /* 199.249.230.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E66B /* 199.249.230.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E66C /* 199.249.230.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E66D /* 199.249.230.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E66E /* 199.249.230.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E66F /* 199.249.230.111/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E670 /* 199.249.230.112/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E671 /* 199.249.230.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E672 /* 199.249.230.114/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E673 /* 199.249.230.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E674 /* 199.249.230.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E675 /* 199.249.230.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E676 /* 199.249.230.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E677 /* 199.249.230.119/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E678 /* 199.249.230.120/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E679 /* 199.249.230.121/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E67A /* 199.249.230.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E67B /* 199.249.230.123/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E68C /* 199.249.230.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E68D /* 199.249.230.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E68E /* 199.249.230.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E68F /* 199.249.230.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E690 /* 199.249.230.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E691 /* 199.249.230.145/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E692 /* 199.249.230.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E693 /* 199.249.230.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E694 /* 199.249.230.148/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E695 /* 199.249.230.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E696 /* 199.249.230.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E697 /* 199.249.230.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E698 /* 199.249.230.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E699 /* 199.249.230.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E69A /* 199.249.230.154/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E69B /* 199.249.230.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E69C /* 199.249.230.156/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E69D /* 199.249.230.157/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E69E /* 199.249.230.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E69F /* 199.249.230.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A0 /* 199.249.230.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A1 /* 199.249.230.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A2 /* 199.249.230.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A3 /* 199.249.230.163/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A4 /* 199.249.230.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A5 /* 199.249.230.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A6 /* 199.249.230.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A7 /* 199.249.230.167/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A8 /* 199.249.230.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6A9 /* 199.249.230.169/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6AA /* 199.249.230.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6AB /* 199.249.230.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6AC /* 199.249.230.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6AD /* 199.249.230.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6AE /* 199.249.230.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6AF /* 199.249.230.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B0 /* 199.249.230.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B1 /* 199.249.230.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B2 /* 199.249.230.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B3 /* 199.249.230.179/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B4 /* 199.249.230.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B5 /* 199.249.230.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B6 /* 199.249.230.182/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B7 /* 199.249.230.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B8 /* 199.249.230.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6B9 /* 199.249.230.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6BA /* 199.249.230.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6BB /* 199.249.230.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6BC /* 199.249.230.188/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC7F9E6BD /* 199.249.230.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC80E5183 /* 200.14.81.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC826E8F8 /* 200.38.232.248/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC862861B /* 200.98.134.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC862874D /* 200.98.135.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC862884C /* 200.98.136.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC87AB502 /* 200.122.181.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC87AB54E /* 200.122.181.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC87AB565 /* 200.122.181.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC9C41196 /* 201.196.17.150/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC9CB732F /* 201.203.115.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC9CDF2F7 /* 201.205.242.247/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xC9EBD73F /* 201.235.215.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCA57A347 /* 202.87.163.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCA57DDE7 /* 202.87.221.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCA57DDED /* 202.87.221.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCA9DB1E0 /* 202.157.177.224/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCAA5E4A1 /* 202.165.228.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCAA5E4E1 /* 202.165.228.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCAB462B0 /* 202.180.98.176/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCAB67B25 /* 202.182.123.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCAB67F7F /* 202.182.127.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCAEF26F9 /* 202.239.38.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCB331B6C /* 203.51.27.108/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCB3BD327 /* 203.59.211.39/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCB7AC273 /* 203.122.194.115/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCB7B6FF4 /* 203.123.111.244/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCBBA4562 /* 203.186.69.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCBDCEB7F /* 203.220.235.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC089C8E /* 204.8.156.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0B3283 /* 204.11.50.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0DA46B /* 204.13.164.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0DA476 /* 204.13.164.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0F4EF9 /* 204.15.78.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC11382A /* 204.17.56.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC11382A /* 204.17.56.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC1B3C93 /* 204.27.60.147/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC2C519E /* 204.44.81.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC53CC8F /* 204.83.204.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC55BF08 /* 204.85.191.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCC55BF09 /* 204.85.191.9/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCCC21D04 /* 204.194.29.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97510 /* 205.185.117.16/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97595 /* 205.185.117.149/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB977DE /* 205.185.119.222/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB978AD /* 205.185.120.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB978CE /* 205.185.120.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97B13 /* 205.185.123.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97C04 /* 205.185.124.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97CA4 /* 205.185.124.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97CC8 /* 205.185.124.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97F23 /* 205.185.127.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97F23 /* 205.185.127.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97F43 /* 205.185.127.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97FCF /* 205.185.127.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97FD9 /* 205.185.127.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDC93F30 /* 205.201.63.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCDFA9987 /* 205.250.153.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE2876E5 /* 206.40.118.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE3FE590 /* 206.63.229.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCE7D2CCC /* 206.125.44.204/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEAE76CF /* 206.174.118.207/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEBD14B7 /* 206.189.20.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEBD7A87 /* 206.189.122.135/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCEBD950D /* 206.189.149.13/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF058D22 /* 207.5.141.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF62C7D9 /* 207.98.199.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF664035 /* 207.102.64.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF940DBB /* 207.148.13.187/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF944DB9 /* 207.148.77.185/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF9463A0 /* 207.148.99.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF9AC0B7 /* 207.154.192.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCF9AD903 /* 207.154.217.3/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4C6CD /* 207.180.198.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4D892 /* 207.180.216.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4DD49 /* 207.180.221.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4DDDC /* 207.180.221.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4E011 /* 207.180.224.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4E66D /* 207.180.230.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFB4EAE7 /* 207.180.234.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFC046FA /* 207.192.70.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFE5419B /* 207.229.65.155/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF44623 /* 207.244.70.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF44BC6 /* 207.244.75.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF45B5E /* 207.244.91.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF4EEE6 /* 207.244.238.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF4EEE6 /* 207.244.238.230/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF4F202 /* 207.244.242.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF658D6 /* 207.246.88.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0013EF0 /* 208.1.62.240/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD026E468 /* 208.38.228.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD026F371 /* 208.38.243.113/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD040E568 /* 208.64.229.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0440481 /* 208.68.4.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0440781 /* 208.68.7.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD059D3D0 /* 208.89.211.208/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD05EF21A /* 208.94.242.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0618D08 /* 208.97.141.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD06B19A5 /* 208.107.25.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0718154 /* 208.113.129.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD0737BDA /* 208.115.123.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD12C72B2 /* 209.44.114.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD133BC30 /* 209.51.188.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD13AA08A /* 209.58.160.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD13AB43E /* 209.58.180.62/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD13AB45A /* 209.58.180.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD13B90AF /* 209.59.144.175/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD15AE005 /* 209.90.224.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1618F35 /* 209.97.143.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD17E678C /* 209.126.103.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD17F11EA /* 209.127.17.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD17F11F2 /* 209.127.17.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D225F /* 209.141.34.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2441 /* 209.141.36.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2675 /* 209.141.38.117/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D26C0 /* 209.141.38.192/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D27D1 /* 209.141.39.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D282E /* 209.141.40.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2967 /* 209.141.41.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D29D6 /* 209.141.41.214/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D29E1 /* 209.141.41.225/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2A23 /* 209.141.42.35/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2DBD /* 209.141.45.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2DBD /* 209.141.45.189/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2E26 /* 209.141.46.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2E2F /* 209.141.46.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D32B2 /* 209.141.50.178/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D32FD /* 209.141.50.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D350A /* 209.141.53.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3514 /* 209.141.53.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3549 /* 209.141.53.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D35B8 /* 209.141.53.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D36A8 /* 209.141.54.168/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D36C3 /* 209.141.54.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D36C3 /* 209.141.54.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D36C5 /* 209.141.54.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D371A /* 209.141.55.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3860 /* 209.141.56.96/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3A32 /* 209.141.58.50/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3BB4 /* 209.141.59.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3D81 /* 209.141.61.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D3EB8 /* 209.141.62.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1942E53 /* 209.148.46.83/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1B6D912 /* 209.182.217.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1B6EFCD /* 209.182.239.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1FA02FE /* 209.250.2.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1FAEBC5 /* 209.250.235.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD1FAEE12 /* 209.250.238.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD27201AC /* 210.114.1.172/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD28C0A18 /* 210.140.10.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD407D934 /* 212.7.217.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD408F3E5 /* 212.8.243.229/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD410AA9E /* 212.16.170.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD41161A6 /* 212.17.97.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD411664D /* 212.17.102.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4154206 /* 212.21.66.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4164B67 /* 212.22.75.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD418648A /* 212.24.100.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD420F0A5 /* 212.32.240.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4277366 /* 212.39.115.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4284CE3 /* 212.40.76.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42C673B /* 212.44.103.59/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE347 /* 212.47.227.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE502 /* 212.47.229.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE504 /* 212.47.229.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE956 /* 212.47.233.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE956 /* 212.47.233.86/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEAD4 /* 212.47.234.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEC5F /* 212.47.236.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FED7F /* 212.47.237.127/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEDBF /* 212.47.237.191/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FF426 /* 212.47.244.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FFEEC /* 212.47.254.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD433890A /* 212.51.137.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4338D5C /* 212.51.141.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4338D5C /* 212.51.141.92/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43395C1 /* 212.51.149.193/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43397FA /* 212.51.151.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339982 /* 212.51.153.130/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339B84 /* 212.51.155.132/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43C05DC /* 212.60.5.220/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD43C7BA1 /* 212.60.123.161/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447EB29 /* 212.71.235.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FAFD /* 212.71.250.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FC86 /* 212.71.252.134/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FD4E /* 212.71.253.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FE61 /* 212.71.254.97/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD44AE912 /* 212.74.233.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD44AE913 /* 212.74.233.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD44AE914 /* 212.74.233.20/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD44AE916 /* 212.74.233.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD450DB25 /* 212.80.219.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4533DDA /* 212.83.61.218/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539A21 /* 212.83.154.33/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD456206A /* 212.86.32.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD459E1F2 /* 212.89.225.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD460228F /* 212.96.34.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4673D11 /* 212.103.61.17/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46DC501 /* 212.109.197.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46F28B1 /* 212.111.40.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD46F298F /* 212.111.41.143/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4745B0A /* 212.116.91.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4810454 /* 212.129.4.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD481208E /* 212.129.32.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4813EE8 /* 212.129.62.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4930D5A /* 212.147.13.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD495C249 /* 212.149.194.73/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD495D305 /* 212.149.211.5/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD49FB1C6 /* 212.159.177.198/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4A2099E /* 212.162.9.158/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BADA4A /* 212.186.218.74/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E30889 /* 212.227.8.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E3A4C5 /* 212.227.164.197/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E3A5FB /* 212.227.165.251/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E3C885 /* 212.227.200.133/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E3CC52 /* 212.227.204.82/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E81D65 /* 212.232.29.101/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E8231D /* 212.232.35.29/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD4ED64FA /* 212.237.100.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5031868 /* 213.3.24.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5205A0F /* 213.32.90.15/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD531D0D1 /* 213.49.208.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD541C42F /* 213.65.196.47/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5426BFA /* 213.66.107.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5496083 /* 213.73.96.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD550661B /* 213.80.102.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD55E3097 /* 213.94.48.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD55F9516 /* 213.95.149.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD56C6C88 /* 213.108.108.136/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD56DA030 /* 213.109.160.48/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD571048E /* 213.113.4.142/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD57177BA /* 213.113.119.186/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58845ED /* 213.136.69.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885159 /* 213.136.81.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885E0A /* 213.136.94.10/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A66D1 /* 213.138.102.209/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58C4258 /* 213.140.66.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D81F6 /* 213.141.129.246/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D8AAE /* 213.141.138.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5908E18 /* 213.144.142.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5908E1C /* 213.144.142.28/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD598A81B /* 213.152.168.27/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A346EA /* 213.163.70.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC08 /* 213.164.204.8/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC12 /* 213.164.204.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC26 /* 213.164.204.38/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC31 /* 213.164.204.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC59 /* 213.164.204.89/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC5A /* 213.164.204.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC5E /* 213.164.204.94/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC66 /* 213.164.204.102/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC74 /* 213.164.204.116/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC92 /* 213.164.204.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CC98 /* 213.164.204.152/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CCA0 /* 213.164.204.160/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CCA5 /* 213.164.204.165/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CCAB /* 213.164.204.171/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A4CD01 /* 213.164.205.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A7F2B7 /* 213.167.242.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A99497 /* 213.169.148.151/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B21A29 /* 213.178.26.41/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B73054 /* 213.183.48.84/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B7308B /* 213.183.48.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B7388C /* 213.183.56.140/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B73C15 /* 213.183.60.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B73F24 /* 213.183.63.36/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C37BF2 /* 213.195.123.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C6432E /* 213.198.67.46/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5CAE6DB /* 213.202.230.219/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5CEB84B /* 213.206.184.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5D32B8B /* 213.211.43.139/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5D7CAEA /* 213.215.202.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5D7CAEA /* 213.215.202.234/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5DB25CD /* 213.219.37.205/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5DCDC3C /* 213.220.220.60/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E2444D /* 213.226.68.77/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E247A4 /* 213.226.71.164/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E38581 /* 213.227.133.129/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFCE7D /* 213.239.206.125/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD5BE /* 213.239.213.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD7DD /* 213.239.215.221/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD944 /* 213.239.217.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFDAC3 /* 213.239.218.195/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F38A13 /* 213.243.138.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F3B51A /* 213.243.181.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FCF5CA /* 213.252.245.202/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD80900E7 /* 216.9.0.231/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD80AF792 /* 216.10.247.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD80F630E /* 216.15.99.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8116390 /* 216.17.99.144/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD818F222 /* 216.24.242.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD847C7E8 /* 216.71.199.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD847C7E8 /* 216.71.199.232/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD847D847 /* 216.71.216.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD87FAD4E /* 216.127.173.78/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8C54CED /* 216.197.76.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DA860C /* 216.218.134.12/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DD647A /* 216.221.100.122/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8EF5A13 /* 216.239.90.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F44A2A /* 216.244.74.42/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F44AF2 /* 216.244.74.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F44CE2 /* 216.244.76.226/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F44FA2 /* 216.244.79.162/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F4551A /* 216.244.85.26/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCBF2 /* 217.12.203.242/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CDD4B /* 217.12.221.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CDD6E /* 217.12.221.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CDD83 /* 217.12.221.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CDFC8 /* 217.12.223.200/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9131304 /* 217.19.19.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9170802 /* 217.23.8.2/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD918E876 /* 217.24.232.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9450E63 /* 217.69.14.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94E1C25 /* 217.78.28.37/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94F0506 /* 217.79.5.6/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB235 /* 217.79.178.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB235 /* 217.79.178.53/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB3B1 /* 217.79.179.177/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB517 /* 217.79.181.23/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB55A /* 217.79.181.90/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB848 /* 217.79.184.72/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FBE19 /* 217.79.190.25/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9526316 /* 217.82.99.22/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD956E768 /* 217.86.231.104/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD95CAF58 /* 217.92.175.88/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD960AF2C /* 217.96.175.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9708307 /* 217.112.131.7/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9708318 /* 217.112.131.24/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9708362 /* 217.112.131.98/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9737F22 /* 217.115.127.34/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9853B89 /* 217.133.59.137/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9886138 /* 217.136.97.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9908AF9 /* 217.144.138.249/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD996E701 /* 217.150.231.1/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD99B03F5 /* 217.155.3.245/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD99B2876 /* 217.155.40.118/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A00DAD /* 217.160.13.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A01D50 /* 217.160.29.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A01DD4 /* 217.160.29.212/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A028C2 /* 217.160.40.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A039C2 /* 217.160.57.194/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A08D34 /* 217.160.141.52/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0AB13 /* 217.160.171.19/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0FB3F /* 217.160.251.63/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0FE45 /* 217.160.254.69/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0FEAA /* 217.160.254.170/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0FFD9 /* 217.160.255.217/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AACC7E /* 217.170.204.126/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AACD0E /* 217.170.205.14/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AACE8A /* 217.170.206.138/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AACE92 /* 217.170.206.146/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9ACB404 /* 217.172.180.4/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B64BB5 /* 217.182.75.181/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B64C42 /* 217.182.76.66/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B64C63 /* 217.182.76.99/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B65E3A /* 217.182.94.58/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C441 /* 217.182.196.65/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C443 /* 217.182.196.67/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C444 /* 217.182.196.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C446 /* 217.182.196.70/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C447 /* 217.182.196.71/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C64C /* 217.182.198.76/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C650 /* 217.182.198.80/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9B6C65F /* 217.182.198.95/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C556AD /* 217.197.86.173/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C5A2EC /* 217.197.162.236/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C5A2ED /* 217.197.162.237/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C5A2EF /* 217.197.162.239/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C7CFFA /* 217.199.207.250/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D240FE /* 217.210.64.254/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E04731 /* 217.224.71.49/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E1D99F /* 217.225.217.159/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E94BEB /* 217.233.75.235/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E9EA2C /* 217.233.234.44/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9EB1F44 /* 217.235.31.68/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9EED5B7 /* 217.238.213.183/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F05E15 /* 217.240.94.21/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F5C9B8 /* 217.245.201.184/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F6094B /* 217.246.9.75/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F68BB4 /* 217.246.139.180/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FCB299 /* 217.252.178.153/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FDDFE3 /* 217.253.223.227/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDA6E906D /* 218.110.144.109/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDAFA5D6E /* 218.250.93.110/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB494B6B /* 219.73.75.107/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB5B6E83 /* 219.91.110.131/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDB792B8D /* 219.121.43.141/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDBA788AE /* 219.167.136.174/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDC47076A /* 220.71.7.106/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDC8463A6 /* 220.132.99.166/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDC86E112 /* 220.134.225.18/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCE9B2C7 /* 220.233.178.199/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDCF086FD /* 220.240.134.253/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDD71325B /* 221.113.50.91/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDEEFFA38 /* 222.239.250.56/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF1050BE /* 223.16.80.190/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF107567 /* 223.16.117.103/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF1945CE /* 223.25.69.206/32 */, 32, NDPI_PROTOCOL_TOR },
  { 0xDF1945CE /* 223.25.69.206/32 */, 32, NDPI_PROTOCOL_TOR },

  /*
    Twitch Interactive Inc.
    origin AS46489
  */

  { 0x17A00000 /* 23.160.0.0/24 */, 24, NDPI_PROTOCOL_TWITCH },
  { 0x2D718000 /* 45.113.128.0/22 */, 22, NDPI_PROTOCOL_TWITCH },
  { 0x34DFC000 /* 52.223.192.0/20 */, 20, NDPI_PROTOCOL_TWITCH },
  { 0x34DFD000 /* 52.223.208.0/21 */, 21, NDPI_PROTOCOL_TWITCH },
  { 0x34DFD800 /* 52.223.216.0/21 */, 21, NDPI_PROTOCOL_TWITCH },
  { 0x34DFE000 /* 52.223.224.0/20 */, 20, NDPI_PROTOCOL_TWITCH },
  { 0x34DFF000 /* 52.223.240.0/20 */, 20, NDPI_PROTOCOL_TWITCH },
  { 0x67353000 /* 103.53.48.0/22 */, 22, NDPI_PROTOCOL_TWITCH },
  { 0xB92ACC00 /* 185.42.204.0/22 */, 22, NDPI_PROTOCOL_TWITCH },
  { 0xC0104000 /* 192.16.64.0/21 */, 21, NDPI_PROTOCOL_TWITCH },
  { 0xC06CEF00 /* 192.108.239.0/24*/, 24, NDPI_PROTOCOL_TWITCH },
  { 0xC709F800 /* 199.9.248.0/21 */, 21, NDPI_PROTOCOL_TWITCH },

  /*
    AnchorFree, Inc. (Hotspot Shield)
    origin AS26642
  */

  { 0x2E102200 /* 46.16.34.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x2E102300 /* 46.16.35.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x32752D00 /* 50.117.45.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x3F8DC600 /* 63.141.198.0/23 */, 23, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x4A730100 /* 74.115.1.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x4A730500 /* 74.115.5.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x4A730600 /* 74.115.6.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x55EDC500 /* 85.237.197.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0x55EDDE00 /* 85.237.222.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xC62F7300 /* 198.47.115.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xC6906800 /* 198.144.104.0/24*/, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xC7FFD700 /* 199.255.215.0/24*/, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4A00 /* 204.14.74.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4C00 /* 204.14.76.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4D00 /* 204.14.77.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCC0E4E00 /* 204.14.78.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xCDA42000 /* 205.164.32.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xD1498400 /* 209.73.132.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xD1499700 /* 209.73.151.0/24 */, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },
  { 0xD8AC8E00 /* 216.172.142.0/24*/, 24, NDPI_PROTOCOL_HOTSPOT_SHIELD },

  /*
    GitHub, Inc.
    origin AS36459
  */

  { 0xC01EFC00 /* 192.30.252.0/22 */, 22, NDPI_PROTOCOL_GITHUB },

  /*
    Valve Corporation (Steam)
    origin AS32590
  */

  { 0x2D79B800 /* 45.121.184.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0x670A7C00 /* 103.10.124.0/23 */, 23, NDPI_PROTOCOL_STEAM },
  { 0x671C3600 /* 103.28.54.0/23 */, 23, NDPI_PROTOCOL_STEAM },
  { 0x8F899200 /* 143.137.146.0/24*/, 24, NDPI_PROTOCOL_STEAM },
  { 0x92429800 /* 146.66.152.0/21 */, 21, NDPI_PROTOCOL_STEAM },
  { 0x99FE5600 /* 153.254.86.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0x9B85E000 /* 155.133.224.0/19*/, 19, NDPI_PROTOCOL_STEAM },
  { 0xA2FEC000 /* 162.254.192.0/21*/, 21, NDPI_PROTOCOL_STEAM },
  { 0xB919B400 /* 185.25.180.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0xBED87900 /* 190.216.121.0/24*/, 24, NDPI_PROTOCOL_STEAM },
  { 0xBED92100 /* 190.217.33.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xC0456000 /* 192.69.96.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0xCDB9C200 /* 205.185.194.0/24*/, 24, NDPI_PROTOCOL_STEAM },
  { 0xCDC40600 /* 205.196.6.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xD040C800 /* 208.64.200.0/24 */, 24, NDPI_PROTOCOL_STEAM },
  { 0xD040C900 /* 208.64.201.0/22 */, 22, NDPI_PROTOCOL_STEAM },
  { 0xD04EA400 /* 208.78.164.0/22 */, 22, NDPI_PROTOCOL_STEAM },

  /* Zoom video conference app. */
  { 0x03501480 /* 3.80.20.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x03787900 /* 3.120.121.0/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x03682280 /* 3.104.34.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x03D04800 /* 3.208.72.0/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x03D3F100 /* 3.211.241.0/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x04227D80 /* 4.34.125.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x04234080 /* 4.35.64.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x08058000 /* 8.5.128.0/23 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x0D340680 /* 13.52.6.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x0D349200 /* 13.52.146.0/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x0D726AA6 /* 13.114.106.166/32 */, 32, NDPI_PROTOCOL_ZOOM },
  { 0x12CD5D80 /* 18.205.93.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x32EFCA00 /* 50.239.202.0/23 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x32EFCC00 /* 50.239.204.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x343D6480 /* 52.61.100.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x34519780 /* 52.81.151.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x34C56115 /* 52.197.97.21/32 */, 32, NDPI_PROTOCOL_ZOOM },
  { 0x34CA3EC0 /* 52.202.62.192/26 */, 26, NDPI_PROTOCOL_ZOOM },
  { 0x34D7A800 /* 52.215.168.0/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x40454A00 /* 64.69.74.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x407D3E00 /* 64.125.62.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x40D39000 /* 64.211.144.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x41279800 /* 65.39.152.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x45AE3900 /* 69.174.57.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x45AE6C00 /* 69.174.108.0/22 */, 22, NDPI_PROTOCOL_ZOOM },
  { 0x634F1400 /* 99.79.20.0/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0x677AA600 /* 103.122.166.0/23 */, 23, NDPI_PROTOCOL_ZOOM },
  { 0x6D5EA000 /* 109.94.160.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0x736E9AC0 /* 115.110.154.192/26*/, 26, NDPI_PROTOCOL_ZOOM },
  { 0x737238C0 /* 115.114.56.192/26 */, 26, NDPI_PROTOCOL_ZOOM },
  { 0x73727300 /* 115.114.115.0/26 */, 26, NDPI_PROTOCOL_ZOOM },
  { 0x73728300 /* 115.114.131.0/26 */, 26, NDPI_PROTOCOL_ZOOM },
  { 0x781D9400 /* 120.29.148.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xA0013880 /* 160.1.56.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0xA1C78800 /* 161.199.136.0/22 */, 22, NDPI_PROTOCOL_ZOOM },
  { 0xA20CE800 /* 162.12.232.0/22 */, 22, NDPI_PROTOCOL_ZOOM },
  { 0xA2FF2400 /* 162.255.36.0/22 */, 22, NDPI_PROTOCOL_ZOOM },
  { 0xA5FE5800 /* 165.254.88.0/23 */, 23, NDPI_PROTOCOL_ZOOM },
  { 0xC0CC0C00 /* 192.204.12.0/22 */, 22, NDPI_PROTOCOL_ZOOM },
  { 0xCAB1CF80 /* 202.177.207.128/27*/, 27, NDPI_PROTOCOL_ZOOM },
  { 0xCAB1D560 /* 202.177.213.96/27 */, 27, NDPI_PROTOCOL_ZOOM },
  { 0xCC506800 /* 204.80.104.0/21 */, 21, NDPI_PROTOCOL_ZOOM },
  { 0xCC8D1C00 /* 204.141.28.0/22 */, 22, NDPI_PROTOCOL_ZOOM },
  { 0xCFE28400 /* 207.226.132.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xD109D300 /* 209.9.211.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xD109D700 /* 209.9.215.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xD2393700 /* 210.57.55.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xD5139000 /* 213.19.144.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xD5139900 /* 213.19.153.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xD5F48C00 /* 213.244.140.0/24 */, 24, NDPI_PROTOCOL_ZOOM },
  { 0xDD7A5840 /* 221.122.88.64/27 */, 27, NDPI_PROTOCOL_ZOOM },
  { 0xDD7A5880 /* 221.122.88.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  { 0xDD7A5980 /* 221.122.89.128/25 */, 25, NDPI_PROTOCOL_ZOOM },
  /* 2620:123:2000::/44 IPV6 */

  /* PS_VUE IP address */
  { 0x08F8DA14 /* 8.248.218.20/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FA6E14 /* 8.250.110.20/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FC028B /* 8.252.2.139/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FD6803 /* 8.253.104.3/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FE6813 /* 8.253.104.19/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FE8C0F /* 8.253.140.15/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FE8C10 /* 8.253.140.16/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FE8C77 /* 8.253.140.119/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FC8CA8 /* 8.253.140.168/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x08FC8CA9 /* 8.253.140.169/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x4318881E /* 67.24.136.30/32   */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x431889FE /* 67.24.137.254/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x43188DFE /* 67.24.141.254/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x43188E1E /* 67.24.142.30/32   */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x4318901E /* 67.24.144.30/32   */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x4318921E /* 67.24.146.30/32   */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0x43189630 /* 67.24.150.30/32   */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA2D83A20 /* 162.216.58.32/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA2D83A2B /* 162.216.58.43/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA2D83A39 /* 162.216.58.57/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA2D83A40 /* 162.216.58.64/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA2D83A48 /* 162.216.58.72/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA2D83A51 /* 162.216.58.81/32  */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA7CE74AA /* 167.206.116.170/32*/, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA7CEDA60 /* 167.206.218.96/32 */, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA7CEDA72 /* 167.206.218.114/32*/, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA7CEDA7B /* 167.206.218.123/32*/, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA7CEDA82 /* 167.206.218.130/32*/, 32, NDPI_PROTOCOL_PS_VUE },
  { 0xA7CEDA8A /* 167.206.218.138/32*/, 32, NDPI_PROTOCOL_PS_VUE },

  /* Bloomberg */
  { 0xD086A100 /* 208.134.161.0/24 */, 24, NDPI_PROTOCOL_BLOOMBERG },
  { 0xCDB7F600 /* 205.183.246.0/24 */, 24, NDPI_PROTOCOL_BLOOMBERG },
  { 0xC769B000 /* 199.105.176.0/21 */, 21, NDPI_PROTOCOL_BLOOMBERG },
  { 0xC769B800 /* 199.105.184.0/23 */, 23, NDPI_PROTOCOL_BLOOMBERG },
  { 0x45B80000 /* 69.184.0.0/13 */,    13, NDPI_PROTOCOL_BLOOMBERG },
  { 0xA02B0000 /* 160.43.0.0/16 */,    24, NDPI_PROTOCOL_BLOOMBERG },
  { 0xCE9C3500 /* 206.156.53.0/24 */,  24, NDPI_PROTOCOL_BLOOMBERG },
  { 0xCDD87000 /* 205.216.112.0/24 */, 24, NDPI_PROTOCOL_BLOOMBERG },
  { 0xD0163800 /* 208.22.56.0/24 */,   24, NDPI_PROTOCOL_BLOOMBERG },
  { 0xD0163900 /* 208.22.57.0/24 */,   24, NDPI_PROTOCOL_BLOOMBERG },
  { 0x45BFC000 /* 69.191.192.0/18 */,  18, NDPI_PROTOCOL_BLOOMBERG },

  /* AnyDesk */
  { 0x3353EF8E /* 51.83.239.142/31 */, 31, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EF90 /* 51.83.239.144/31 */, 31, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EEC8 /* 51.83.238.200/29 */, 29, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EED0 /* 51.83.238.208/29 */, 29, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EED8 /* 51.83.238.216/30 */, 30, NDPI_PROTOCOL_ANYDESK },
  { 0x3353EEDC /* 51.83.238.220/31 */, 31, NDPI_PROTOCOL_ANYDESK },

  /*
     Microsoft

     [JSON] https://endpoints.office.com/endpoints/worldwide?clientrequestid=b10c5ed1-bad1-445f-b386-b919946339a7
     [HTML] https://docs.microsoft.com/en-us/office365/enterprise/urls-and-ip-address-ranges
  */
 { 0x0D6B0698 /* 13.107.6.152/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B120A /* 13.107.18.10/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B8000 /* 13.107.128.0/22 */, 22, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x1767A000 /* 23.103.160.0/20 */, 20, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x28600000 /* 40.96.0.0/13 */, 13, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x28680000 /* 40.104.0.0/15 */, 15, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34600000 /* 52.96.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x83FD21D7 /* 131.253.33.215/32*/, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x84F50000 /* 132.245.0.0/16 */, 16, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x96AB2000 /* 150.171.32.0/22 */, 22, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0xBFEA8C00 /* 191.234.140.0/22 */, 22, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0xCC4FC5D7 /* 204.79.197.215/32*/, 32, NDPI_PROTOCOL_MICROSOFT_365 },

 { 0x285C0000 /* 40.92.0.0/15 */, 15, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x286B0000 /* 40.107.0.0/16 */, 16, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34640000 /* 52.100.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34EE4E58 /* 52.238.78.88/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682F0000 /* 104.47.0.0/17 */, 17, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x285C0000 /* 40.92.0.0/15 */, 15, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x286B0000 /* 40.107.0.0/16 */, 16, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34640000 /* 52.100.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682F0000 /* 104.47.0.0/17 */, 17, NDPI_PROTOCOL_MICROSOFT_365 },
  /* ** */
 { 0x0D6B8800 /* 13.107.136.0/22 */, 22, NDPI_PROTOCOL_MS_ONE_DRIVE },
 { 0x286C8000 /* 40.108.128.0/17 */, 17, NDPI_PROTOCOL_MS_ONE_DRIVE },
 { 0x34680000 /* 52.104.0.0/14 */, 14, NDPI_PROTOCOL_MS_ONE_DRIVE },
 { 0x68928000 /* 104.146.128.0/17 */, 17, NDPI_PROTOCOL_MS_ONE_DRIVE },
 { 0x96AB2800 /* 150.171.40.0/22 */, 22, NDPI_PROTOCOL_MS_ONE_DRIVE },
  /* ** */
 { 0x0D6B4000 /* 13.107.64.0/18 */, 18, NDPI_PROTOCOL_SKYPE_TEAMS },
 { 0x34700000 /* 52.112.0.0/14 */, 14, NDPI_PROTOCOL_SKYPE_TEAMS },
 { 0x34780000 /* 52.120.0.0/14 */, 14, NDPI_PROTOCOL_SKYPE_TEAMS },
 { 0x34EE778D /* 52.238.119.141/32 */, 32, NDPI_PROTOCOL_SKYPE_TEAMS },
 { 0x34F4A0CF /* 52.244.160.207/32 */, 32, NDPI_PROTOCOL_SKYPE_TEAMS },

  /* ** */
 { 0x0D6B06AB /* 13.107.6.171/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B8C06 /* 13.107.140.6/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x346C0000 /* 52.108.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34EE6A74 /* 52.238.106.116/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34F796BF /* 52.247.150.191/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6A0480 /* 13.106.4.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6A3800 /* 13.106.56.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x14BE8000 /* 20.190.128.0/18 */, 18, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x287E0000 /* 40.126.0.0/18 */, 18, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x4136AA80 /* 65.54.170.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682CDA80 /* 104.44.218.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682CFE80 /* 104.44.254.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682CFF00 /* 104.44.255.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x86AA4300 /* 134.170.67.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x86AAAC80 /* 134.170.172.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D372D80 /* 157.55.45.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D378200 /* 157.55.130.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D379100 /* 157.55.145.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D379B00 /* 157.55.155.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D37E3C0 /* 157.55.227.192/26 */, 26, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0xBFE80280 /* 191.232.2.128/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D507D16 /* 13.80.125.22/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D5B5BF3 /* 13.91.91.243/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B069C /* 13.107.6.156/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B07BE /* 13.107.7.190/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B099C /* 13.107.9.156/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x28519C9A /* 40.81.156.154/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x285ADAC6 /* 40.90.218.198/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x346C0000 /* 52.108.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34AE38B4 /* 52.174.56.180/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34B74B3E /* 52.183.75.62/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34B8A552 /* 52.184.165.82/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682AE65B /* 104.42.230.91/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D379100 /* 157.55.145.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D379B00 /* 157.55.155.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D37E3C0 /* 157.55.227.192/26 */, 26, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D507D16 /* 13.80.125.22/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D5B5BF3 /* 13.91.91.243/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B069C /* 13.107.6.156/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B07BE /* 13.107.7.190/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B099C /* 13.107.9.156/31 */, 31, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x28519C9A /* 40.81.156.154/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x285ADAC6 /* 40.90.218.198/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x346C0000 /* 52.108.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34AE38B4 /* 52.174.56.180/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34B74B3E /* 52.183.75.62/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34B8A552 /* 52.184.165.82/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x682AE65B /* 104.42.230.91/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D379100 /* 157.55.145.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D379B00 /* 157.55.155.0/25 */, 25, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x9D37E3C0 /* 157.55.227.192/26 */, 26, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B06AB /* 13.107.6.171/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x0D6B8C06 /* 13.107.140.6/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x346C0000 /* 52.108.0.0/14 */, 14, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34EE6A74 /* 52.238.106.116/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
 { 0x34F796BF /* 52.247.150.191/32 */, 32, NDPI_PROTOCOL_MICROSOFT_365 },
  /* ** */
  { 0x0D400000 /* 13.64.0.0 */, 11, NDPI_PROTOCOL_MICROSOFT },
  { 0x0D600000 /* 13.96.0.0 */, 13, NDPI_PROTOCOL_MICROSOFT },
  { 0x0D680000 /* 13.104.0.0 */, 14, NDPI_PROTOCOL_MICROSOFT },

  /* End */
  { 0x0, 0, 0 }
};


/* ****************************************************** */

/*
  Host-based match

  HTTP:  Server: field
  HTTPS: Server certificate name

  Risk classification criteria
  ----------------------------

  NDPI_PROTOCOL_SAFE
  - Web sites (and CDNs) which are not commonly used to host malicious activities.
  - OS update hosts.
  - App stores.
  - Commonly used services with passwords in encrypted channels (SMTPS, POPS, etc)

  NDPI_PROTOCOL_ACCEPTABLE
  - Cloud services may be used to host malware (e.g., https://www.fireeye.com/blog/threat-research/2015/11/china-based-threat.html),
  but it is mostly used for normal purposes.
  - Webmail sites, which can be used to phising.
  - Encrypted administrative protocols, such as SSH.
  - Text, voice or video communication (e.g., Skype, Slack, Whatsapp).
  - Ads services are commonly used to spread malware
  (https://www.tripwire.com/state-of-security/security-data-protection/crypto-ransomware-spreads-via-poisoned-ads-on-major-websites/)

  NDPI_PROTOCOL_FUN
  - Social media sites and services.
  - Communication used for fun purposes, like Snapchat, Tinder, etc.
  - Audio and videostreamming services (e.g., Netflix).
  - Game services.

  NDPI_PROTOCOL_UNSAFE
  - Unencrypted administrative protocols, such as Telnet.
  - Cloud hosted servers when accessed by default domains, such as *.amazonaws.com.
  - "AWS Supports 41% of Malware Hosting Sites, More than Any Other Web Host or ISP"
  http://www.thewhir.com/web-hosting-news/aws-supports-41-malware-hosting-sites-web-host-isp
  - https://www.scmagazine.com/600-plus-cloud-repositories-spotted-hosting-malware-and-malicious-files/article/572205/
  - https://howtoremove.guide/remove-s3-amazonaws-virus/
  - Torrents.
  - Commonly used services with passwords in unencrypted channels (SMTP, POP, etc)

  NDPI_PROTOCOL_POTENTIALLY_DANGEROUS
  - Tor and other anonymization access.
  - Sites commonly used to host malware and not as commonly used by "normal" users. (e.g., pastebin.com)
  https://isc.sans.edu/forums/diary/Many+Malware+Samples+Found+on+Pastebin/22036/

  NDPI_PROTOCOL_UNRATED
  - Avoid this class.

*/

/* ****************************************************** */

static ndpi_protocol_match host_match[] =
  {
   { "dmqdd6hw24ucf.cloudfront.net",                      "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "d25xi40x97liuc.cloudfront.net",                     "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".aiv-delivery.net",                                 "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".aiv-cdn.net",                                      "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "1s3.lvlt.dash.us.aiv-cdn.net.c.footprint.net",      "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { ".s.loris.llnwd.net",                                "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "atv-ext.amazon.com",                                "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "atv-ps.amazon.com",                                 "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".media-amazon.com",                                 "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".amazonvideo.com",                                  "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".primevideo.com",                                   "AmazonVideo",      NDPI_PROTOCOL_AMAZON_VIDEO, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

   { "amazon.",                                           "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "amazon.com",                                        "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "images-amazon.com",                                 "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "ssl-images-amazon.com",                             "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "amazonaws.com",                                     "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "amazon-adsystem.com",                               "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".aws.",                                             "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".cloudfront.net",                                   "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".us-west-2.compute.amazonaws.com",                  "Amazon",           NDPI_PROTOCOL_AMAZON, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".teamviewer.com",                                   "Teamviewer",           NDPI_PROTOCOL_TEAMVIEWER, NDPI_PROTOCOL_CATEGORY_REMOTE_ACCESS, NDPI_PROTOCOL_ACCEPTABLE },
   { ".bloombergvault.com",                               "Bloomberg",        NDPI_PROTOCOL_BLOOMBERG, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".bloomberg.com",                                    "Bloomberg",        NDPI_PROTOCOL_BLOOMBERG, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".apple-dns.net",                            "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "origin-apple.com.akadns.net",               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "e6858.dsce9.akamaiedge.net",                "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".mzstatic.com",                             "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "aaplimg.com",                               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { ".apple.com",                                "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".apple.news",                               "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".cdn-apple.com",                            "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".ls4-apple.com",                            "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".gc-apple.com",                             "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".ls-apple.com",                             "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".apple-cloudkit.com",                       "Apple",            NDPI_PROTOCOL_APPLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".push.apple.com",                           "ApplePush",        NDPI_PROTOCOL_APPLE_PUSH, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "push-apple.com",                            "ApplePush",        NDPI_PROTOCOL_APPLE_PUSH, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".icloud.com",                               "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".icloud.com.",                              "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE }, /* icloud.com.akadns.net */
   { ".me.com",                                   "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".icloud-content.com",                       "AppleiCloud",      NDPI_PROTOCOL_APPLE_ICLOUD, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "iosapps.itunes.apple.com",                  "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE }, /* iOS */
   { "osxapps.itunes.apple.com",                  "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE }, /* MacOS */
   { "buy.itunes.apple.com",                      "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { "su.itunes.apple.com",                       "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { "se.itunes.apple.com",                       "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { "myapp.itunes.apple.com",                    "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { "swscan.apple.com",                          "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { "itunes-apple.com",                          "AppleStore",       NDPI_PROTOCOL_APPLESTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { "itunes.apple.com",                          "AppleiTunes",      NDPI_PROTOCOL_APPLE_ITUNES, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "tlnk.io",         	                      "AppleiTunes",      NDPI_PROTOCOL_APPLE_ITUNES, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "guzzoni.apple.",         	   "AppleSiri",      NDPI_PROTOCOL_APPLE_SIRI, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { ".wbagora.com",                              "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_UNRATED },
   { ".wbplay.com",                                "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_UNRATED },
   { ".xbox.com",                                    "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".xboxlive.com",                            "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".xboxlive.com.akadns.net",                 "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".xboxlive.com.c.footprint.net",            "Xbox",             NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { "e13555.b.akamaiedge.net",   "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { "e1800.d.akamaiedge.net",     "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { "e1879.e7.akamaiedge.net",   "Playstation",      NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

   { ".cnn.com",           "CNN",              NDPI_PROTOCOL_CNN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".cnn.net",           "CNN",              NDPI_PROTOCOL_CNN, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

   { ".dropbox.com",             "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { ".dropboxstatic.com", "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { ".dropbox-dns.com",     "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { "log.getdropbox.com", "DropBox",          NDPI_PROTOCOL_DROPBOX, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

   { ".ebay.",                      "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },  /* or FUN */
   { ".ebay.com",                            "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
   { ".ebaystatic.com",       "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
   { ".ebaydesc.com",           "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
   { ".ebayrtm.com",             "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
   { ".ebaystratus.com",     "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },
   { ".ebayimg.com",             "eBay",             NDPI_PROTOCOL_EBAY, NDPI_PROTOCOL_CATEGORY_SHOPPING, NDPI_PROTOCOL_SAFE },

   /* Detected "instagram.c10r.facebook.com". Omitted "*amazonaws.com" and "*facebook.com" CDNs e.g. "ig-telegraph-shv-04-frc3.facebook.com" */
   { ".instagram.",            "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "instagram.",                "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN, 15 },
   { ".cdninstagram.com",   "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { "igcdn-photos-",          "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "instagramimages-",       "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "instagramstatic-",       "Instagram",        NDPI_PROTOCOL_INSTAGRAM, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { "facebook.com",            "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".facebook.net",           "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "fbstatic-a.akamaihd.net", "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".fbcdn.net",              "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "fbcdn-",                  "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".fbsbx.com",              "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".fbwat.ch",               "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".fb.com",                 "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".fb.gg",                  "Facebook",         NDPI_PROTOCOL_FACEBOOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { "speedtest.",                       "Ookla",            NDPI_PROTOCOL_OOKLA, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },
   { ".ooklaserver.net",         "Ookla",            NDPI_PROTOCOL_OOKLA, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },

   { "ntop.org",                     "ntop",         NDPI_PROTOCOL_NTOP, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },

   { "docs.googleusercontent.com",   "GoogleDocs",     NDPI_PROTOCOL_GOOGLE_DOCS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "docs.google.com",              "GoogleDocs",     NDPI_PROTOCOL_GOOGLE_DOCS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

   { "drive-thirdparty.googleusercontent.com",  "GoogleDrive",      NDPI_PROTOCOL_GOOGLE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { "drive.google.com",                          "GoogleDrive",      NDPI_PROTOCOL_GOOGLE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

   { "android.clients.google.com",   "PlayStore",    NDPI_PROTOCOL_PLAYSTORE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },

   /*
     https://www.fastvue.co/sophos/blog/google-data-saver-affect-security-confidentiality-reporting/
     Used by Google Chrome Lite Mode for Android

     This traffic will bypass checks and blocks as it will include all the communications from/to
     the browser instead of using the standard communication mechanisms SSL/HTTP(S)/DNS

     https://github.com/curl/curl/wiki/DNS-over-HTTPS
   */
   { ".googlezip.net",                       "DataSaver",     NDPI_PROTOCOL_DATASAVER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "datasaver.googleapis.com", "DataSaver",     NDPI_PROTOCOL_DATASAVER, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   /* http://check.googlezip.net/connect [check browser connectivity] */
   // { ".googlezip.net",                   "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

   /*
      https://github.com/bambenek/block-doh/blob/master/db.doh-redirect
      https://github.com/curl/curl/wiki/DNS-over-HTTPS
   */
   { "dns.google", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.google.com", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "mozilla.cloudflare-dns.com", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE }, /* Firefox */
   { "cloudflare-dns.com", "DoH_DoT",     NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "commons.host", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.libredns.gr", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns9.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.opendns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.dns.sb", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.netweaver.uk", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.dns-over-https.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "jp.tiarap.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.dnsoverhttps.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.powerdns.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "adblock.mydns.network", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "jp.tiar.app", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.crypto.sx", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.containerpi.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "ibksturm.synology.me", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.captnemo.in", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.rubyfish.cn", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.42l.fr", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns-family.adguard.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "appliedprivacy.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.cleanbrowsing.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns10.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh-ch.blahdns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.seby.io", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.adguard.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "ibuki.cgnat.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "jcdns.fun", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh-2.seby.io", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.tiar.app", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.dnswarden.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh-de.blahdns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh-jp.blahdns.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.appliedprivacy.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.tiarap.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.armadillodns.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns-nyc.aaflalo.me", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.aa.net.uk", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.aaflalo.me", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns11.quad9.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.nextdns.io", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.securedns.eu", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "rdns.faelix.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "captnemo.in", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.dnshome.de", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.dnslify.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "resolver-eu.lelux.fi", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.bortzmeyer.fr", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { ".doh.dns.snopyta.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "jarjar.meganerd.nl", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "rumpelsepp.org", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dnsnl.alekberg.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dnses.alekberg.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dnsse.alekberg.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "odvr.nic.cz", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.dnscrypt.ca", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns1.dnscrypt.ca", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns2.dnscrypt.ca", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.digitale-gesellschaft.ch", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns1.digitale-gesellschaft.ch", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "dns.cloudflare.com", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { "doh.ffmuc.net", "DoH_DoT", NDPI_PROTOCOL_DOH_DOT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },


   /*
     See https://better.fyi/trackers/

     DoubleClick by Google (2mdn.net)
     DoubleClick by Google (doubleclick.net)
     DoubleClick by Google
     Google AdSense by Google (google.com)
     Google AdSense by Google (google.se)
     Google AdSense by Google (googleadservices.com)
     Google Analytics by Google (google-analytics.com)
     Google APIs by Google (ajax.googleapis.com)
     Google Fonts by Google (fonts.googleapis.com)
     Google Interactive Media Ads (imasdk.googleapis.com)
     Google Syndication (googlesyndication.com)
     Google Tag Manager by Google (googletagmanager.com)
     Google Tag Manager by Google (googletagservices.com)
     Gstatic by Google (gstatic.com)
   */

   /* Google Advertisements */
   { ".googlesyndication.com",   "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { "googleads.",                           "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { ".doubleclick.net",               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { "googleadservices.",             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { ".2mdn.net",                             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { ".dmtry.com",                           "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { "google-analytics.",             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_TRACKER_ADS },
   { ".gvt1.com",                                 "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".gvt2.com",                                 "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "telephony.goog",                            "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   /* Google Hangout */
   { "images2-hangout-opensocial.googleusercontent.com", "GoogleHangout", NDPI_PROTOCOL_HANGOUT_DUO, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   /* Google Services */
   { "googleapis.com",                     "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".googletagservices.com",   "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "mtalk.google.com",               "GoogleServices",   NDPI_PROTOCOL_GOOGLE_SERVICES, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   { "plus.google.com",                 "GooglePlus",       NDPI_PROTOCOL_GOOGLE_PLUS, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "plus.url.google.com",       "GooglePlus",       NDPI_PROTOCOL_GOOGLE_PLUS, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { "googleusercontent.com",       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "1e100.net",                               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   { "maps.google.",                    "GoogleMaps",       NDPI_PROTOCOL_GOOGLE_MAPS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "maps.gstatic.com",               "GoogleMaps",       NDPI_PROTOCOL_GOOGLE_MAPS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

   { ".gmail.",                              "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE },
   { "mail.google.",                    "GMail",            NDPI_PROTOCOL_GMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE },

   { "google.com",                             "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "google.",                                "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".google.",                                       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".gstatic.com",                       "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "ggpht.com",                               "Google",           NDPI_PROTOCOL_GOOGLE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

   { "mail.outlook.com",               "Hotmail",          NDPI_PROTOCOL_HOTMAIL, NDPI_PROTOCOL_CATEGORY_MAIL, NDPI_PROTOCOL_ACCEPTABLE },

   { ".last.fm",                            "LastFM",           NDPI_PROTOCOL_LASTFM, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

   { "netflix.com",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "nflxext.com",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "nflximg.com",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "nflximg.net",                           "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "nflxvideo.net",                         "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "nflxso.net",                            "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "fast.com",                              "NetFlix",          NDPI_PROTOCOL_NETFLIX, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_SAFE },

   { ".skype.",                                    "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { ".skypeassets.",                              "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { ".skypedata.",                                "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { ".skypeecs-",                                 "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { ".skypeforbusiness.",                         "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { ".lync.com",                                  "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { "e7768.b.akamaiedge.net",                     "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { "e4593.dspg.akamaiedge.net",                  "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { "e4593.g.akamaiedge.net",                     "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { "*.gateway.messenger.live.com",               "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { "skype-calling-missedcallsregistrar-",        "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { "teams.cloudapp.net",                         "Skype_Teams",            NDPI_PROTOCOL_SKYPE_TEAMS, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },

   { ".tuenti.com",                              "Tuenti",           NDPI_PROTOCOL_TUENTI, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },

   { ".twttr.com",                                "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "twitter.",                                   "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "twimg.com",                                    "Twitter",          NDPI_PROTOCOL_TWITTER, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { ".viber.com",                                "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { ".cdn.viber.com",                                      "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { ".viber.it",                                           "Viber",            NDPI_PROTOCOL_VIBER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   { "wikipedia.",                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "wikimedia.",                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "mediawiki.",                               "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "wikimediafoundation.",           "Wikipedia",        NDPI_PROTOCOL_WIKIPEDIA, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

   { "mmg-fna.whatsapp.net",            "WhatsAppFiles",    NDPI_PROTOCOL_WHATSAPP_FILES, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_ACCEPTABLE },
   { ".whatsapp.",                             "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "g.whatsapp.net",                        "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "v.whatsapp.net",                        "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "mmg.whatsapp.net",                    "WhatsApp",         NDPI_PROTOCOL_WHATSAPP, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   { ".yahoo.",                                   "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".yimg.com",                                  "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "yahooapis.",                               "Yahoo",            NDPI_PROTOCOL_YAHOO, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   { "upload.youtube.com",                "YouTubeUpload",    NDPI_PROTOCOL_YOUTUBE_UPLOAD, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "upload.video.google.com",           "YouTubeUpload",    NDPI_PROTOCOL_YOUTUBE_UPLOAD, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "youtubei.googleapis.com",           "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "youtube.",                          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "youtu.be",                          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "yt3.ggpht.com",                     "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { ".googlevideo.com",                  "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { ".ytimg.com",                        "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "youtube-nocookie.",                 "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { ".youtube-ui.l.google.com",          "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { ".youtubeeducation.com",             "YouTube",          NDPI_PROTOCOL_YOUTUBE, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },

   { ".vevo.com",                                  "Vevo",             NDPI_PROTOCOL_VEVO,    NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

   { ".spotify.com",                            "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { ".scdn.co",                                "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { ".pscdn.co",                               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotifycdn.net",                          "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotifycdn.com",                          "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "audio4-ak-spotify-com.akamaized.net",     "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "audio-ak-spotify-com.akamaized.net",      "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "heads-ak-spotify-com.akamaized.net",      "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotify-com.akamaized.net",               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotify.com.edgesuite.net",               "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotify.map.fastly.net",                  "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotify.edgekey.net",                     "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "spotify.demdex.net",                      "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { ".spotilocal.com",                         "Spotify",          NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },


   { "edge-mqtt.facebook.com",        "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "mqtt-mini.facebook.com",        "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE }, /* Messenger Lite */
   { "messenger.com",                 "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { ".m.me",                         "Messenger",        NDPI_PROTOCOL_MESSENGER, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   { ".pandora.com",                            "Pandora",          NDPI_PROTOCOL_PANDORA,  NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

   { ".torproject.org",                   "Tor",              NDPI_PROTOCOL_TOR, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },

   { ".kakao.com",                                "KakaoTalk",        NDPI_PROTOCOL_KAKAOTALK, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   { "ttvnw.net",                       "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "jtvnw.net",                       "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "twitch.tv",                       "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "twitchcdn.net",                   "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { "twitchsvc.net",                   "Twitch",           NDPI_PROTOCOL_TWITCH, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

   { ".qq.com",                                      "QQ",               NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".gtimg.com",                                "QQ",               NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },

   { ".weibo.com",                                "Sina(Weibo)",      NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".weibo.cn",                                           "Sina(Weibo)",      NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sinaimg.cn",                             "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sinajs.cn",                               "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sina.cn",                                   "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sina.com.cn",                       "Sina",             NDPI_PROTOCOL_SINA, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   /* https://support.cipafilter.com/index.php?/Knowledgebase/Article/View/117/0/snapchat---how-to-block */
   { "feelinsonice.appspot.com",                     "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "feelinsonice-hrd.appspot.com", "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "feelinsonice.com",                          "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".snapchat.",                                  "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".snapads.",                                    "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sc-cdn.net",                             "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sc-prod.net",                           "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".sc-jpl.com",                             "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "sc-analytics.appspot.com",       "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "snap.api.mapbox.com",            "Snapchat",     NDPI_PROTOCOL_SNAPCHAT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { ".waze.com",                                  "Waze",             NDPI_PROTOCOL_WAZE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "wazespeechactiviation-pa.googleapis.com",    "Waze",             NDPI_PROTOCOL_WAZE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   { ".deezer.com",                              "Deezer",           NDPI_PROTOCOL_DEEZER, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

   /* Microsoft + Azure */
   { ".wpc.v0cdn.net",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".gfx.ms",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".aka.ms",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".sfx.ms",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".appcenter.ms",                                         "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "-msedge.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".microsoft.us",                                         "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".dynamics.com",                                         "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "msftncsi.com",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK, NDPI_PROTOCOL_SAFE },
   { ".azure.com",                                            "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".windows.net",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".windows.com",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".microsoft.com",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "msn.com",                                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".s-msft.com",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_ACCEPTABLE },
   { ".webtrends.com",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".msecnd.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "bing.com",                                              "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".visualstudio.com",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "login.live.com",                                        "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_SAFE },
   { "statics-marketingsites-wcus-ms-com.akamaized.net",      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "statics-marketingsites-eus-ms-com.akamaized.net",       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "img-prod-cms-rt-microsoft-com.akamaized.net",           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "onecollector.cloudapp.aria.akadns.net",                 "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "onecollector.akadns.net",                               "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "microsoft.akadns.net",                                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "e1723.dscd.akamaiedge.net",                             "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".microsofttranslator.com",                              "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { "sharepointonline.com",                                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".msftconnecttest.com",                                  "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK, NDPI_PROTOCOL_SAFE },
   { ".windowsmedia.com",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_SAFE },
   { ".windowsphone.com",                                     "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_SYSTEM_OS, NDPI_PROTOCOL_SAFE },
   { ".msa.akadns6.net",                                      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".s-microsoft.com",                                      "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".msidentity.com",                                       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".wac.phicdn.net",                                       "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".onestore.ms",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".msedge.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { ".mshome.net",                                           "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_SAFE },
   { "..msn-com.",                                            "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".-s-msn-com.",                                          "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },
   { ".s-msn.com",                                            "Microsoft",        NDPI_PROTOCOL_MICROSOFT, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_SAFE },

   { "teams.microsoft.com",              "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "teams.microsoft.us",               "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "teams.skype.com",                  "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "-teams.cloudapp.net",              "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "teams.trafficmanager.net",         "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "teams-msgapi.trafficmanager.net",  "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "teams.office.net",                 "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },
   { "teams.office.com",                 "Teams",         NDPI_PROTOCOL_MSTEAMS, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_SAFE },

   { ".storage.live.com",               "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE,NDPI_PROTOCOL_CATEGORY_CLOUD,  NDPI_PROTOCOL_ACCEPTABLE },
   { "skyapi.live.net",                 "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { "d.docs.live.net",                 "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { "onedrive.live.com",               "MS_OneDrive",  NDPI_PROTOCOL_MS_ONE_DRIVE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

   { "update.microsoft.com",            "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { ".windowsupdate.com",              "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { ".ntservicepack.microsoft.com",    "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },
   { ".wustat.windows.com",             "WindowsUpdate",    NDPI_PROTOCOL_WINDOWS_UPDATE, NDPI_PROTOCOL_CATEGORY_SW_UPDATE, NDPI_PROTOCOL_SAFE },

   { "worldofwarcraft.com",                "WorldOfWarcraft",  NDPI_PROTOCOL_WORLDOFWARCRAFT, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

   { ".anchorfree.",                         "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
   { "hotspotshield.com",                    "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
   { ".northghost.com",                      "HotspotShield",    NDPI_PROTOCOL_HOTSPOT_SHIELD, NDPI_PROTOCOL_CATEGORY_VPN, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },

   { ".webex.com",                           "Webex",            NDPI_PROTOCOL_WEBEX, NDPI_PROTOCOL_CATEGORY_VOIP, NDPI_PROTOCOL_ACCEPTABLE },
   { ".zoom.us",                            "Zoom",             NDPI_PROTOCOL_ZOOM,  NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_ACCEPTABLE },

   { ".ocsdomain.com",                        "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { "ocs.fr",                                         "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { ".ocs.fr",                                             "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },
   { ".labgency.ws",                             "OCS",              NDPI_PROTOCOL_OCS, NDPI_PROTOCOL_CATEGORY_MEDIA, NDPI_PROTOCOL_FUN },

   { ".iflix.com",                                "IFLIX",            NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".app.iflixcorp.com",              "IFLIX",            NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },
   { ".images.iflixassets.com",    "IFLIX",            NDPI_PROTOCOL_IFLIX, NDPI_PROTOCOL_CATEGORY_VIDEO, NDPI_PROTOCOL_FUN },

   { "crl.microsoft.com",                       "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "evsecure-ocsp.verisign.com",              "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "evsecure-aia.verisign.com",               "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "evsecure-crl.verisign.com",               "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".omniroot.com",                           "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".microsoftonline.com",                    "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".microsoftonline.us",                     "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".office365.com",                          "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".office.com",                             "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "office.net",                              "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".msocsp.com",                             "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".msocdn.com",                             "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "officeapps.live.com",                     "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "outlook.live.com",                        "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "mail.live.com",                           "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "office.live.com",                         "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".onenote.",                               "Microsoft365",    NDPI_PROTOCOL_MICROSOFT_365, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

   /* http://www.urlquery.net/report.php?id=1453233646161 */
   { "lifedom.top",                                "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "coby.ns.cloudflare.com",      "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { "amanda.ns.cloudflare.com",  "Cloudflare",       NDPI_PROTOCOL_CLOUDFLARE, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },

   { "d295hzzivaok4k.cloudfront.net","OpenDNS",      NDPI_PROTOCOL_OPENDNS, NDPI_PROTOCOL_CATEGORY_WEB, NDPI_PROTOCOL_ACCEPTABLE },
   { ".opendns.com",                                  "OpenDNS",      NDPI_PROTOCOL_OPENDNS, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },

   /* https://get.slack.help/hc/en-us/articles/205138367-Troubleshooting-Slack-connection-issues */
   { "slack.com",                                    "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".slack-msgs.com",                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "slack-files.com",                        "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "slack-imgs.com",                          "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".slack-edge.com",                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".slack-core.com",                      "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "slack-redir.net",                        "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   /* Detected "slack-assets2.s3-us-west-2.amazonaws.com.". Omitted "*amazonaws.com" CDN */
   { "slack-assets2.s3-",                  "Slack",            NDPI_PROTOCOL_SLACK, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

   { "github.com",                                  "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".github.com",                              "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "github.io",                                           "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".github.io",                                          "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "githubusercontent.com",            "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".githubusercontent.com",        "Github",           NDPI_PROTOCOL_GITHUB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

   { "gitlab.com",                                  "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".gitlab.com",                                 "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".gitlab-static.net",                          "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".gitlab.io",                                  "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { ".gitlab.net",                                 "GitLab",           NDPI_PROTOCOL_GITLAB, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

   { ".steampowered.com",                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { "steamcommunity.com",                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".steamcontent.com",                        "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".steamstatic.com",                          "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { "steamcommunity-a.akamaihd.net",             "Steam",        NDPI_PROTOCOL_STEAM, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

   { ".wechat.com",                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".wechat.org",                            "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".wechatapp.com",                        "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".we.chat",                                  "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".wx.",                                          "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".weixin.",                                  "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },
   { ".mmsns.qpic.cn",                     "WeChat",           NDPI_PROTOCOL_WECHAT, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_FUN },

   { "dnscrypt.org",                           "DNScrypt",         NDPI_PROTOCOL_DNSCRYPT, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },

   { "torrent.",                                   "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE },
   { "torrents.",                                 "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE },
   { "torrentz.",                                 "BitTorrent",       NDPI_PROTOCOL_BITTORRENT, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_UNSAFE },

   { ".nintendo.net",                          "Nintendo",         NDPI_PROTOCOL_NINTENDO, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".nintendo.com",                                       "Nintendo",         NDPI_PROTOCOL_NINTENDO, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

   { ".playstation.net",                          "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".playstation.com",                                          "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".sonyentertainmentnetwork.com",            "Playstation",  NDPI_PROTOCOL_PLAYSTATION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },

   { ".linkedin.com",                          "LinkedIn",         NDPI_PROTOCOL_LINKEDIN, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".licdn.com",                                "LinkedIn",         NDPI_PROTOCOL_LINKEDIN, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { ".sndcdn.com",                              "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { ".soundcloud.com",                      "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },
   { "getrockerbox.com",                      "SoundCloud",       NDPI_PROTOCOL_SOUNDCLOUD, NDPI_PROTOCOL_CATEGORY_MUSIC, NDPI_PROTOCOL_FUN },

   { "web.telegram.org",                    "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "tdesktop.com",                              "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "tupdate.com",                                "Telegram",         NDPI_PROTOCOL_TELEGRAM, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   { ".pastebin.com",                          "Pastebin",         NDPI_PROTOCOL_PASTEBIN, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
   { "pastebin.com",                             "Pastebin",         NDPI_PROTOCOL_PASTEBIN, NDPI_PROTOCOL_CATEGORY_DOWNLOAD_FT, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },

   { ".ppstream.com",                          "PPStream",         NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { ".pps.tv",                                   "PPStream",         NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

   { ".hulustream.com",                                 "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "hulu.com",                                        "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "assetshuluimcom-a.akamaihd.net",                  "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "ibhuluimcom-a.akamaihd.net",                      "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { ".huluad.com",                                     "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { ".huluim.com",                                     "Hulu",            NDPI_PROTOCOL_HULU, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

   /*
     VidTO streaming service
   */
   { ".vidto.me",                                 "VidTO",            NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { ".vidto.se",                                           "VidTO",            NDPI_PROTOCOL_PPSTREAM, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

   { "snapcraft.io",                        "UbuntuONE",        NDPI_PROTOCOL_UBUNTUONE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },
   { "ubuntu.com",                            "UbuntuONE",        NDPI_PROTOCOL_UBUNTUONE, NDPI_PROTOCOL_CATEGORY_CLOUD, NDPI_PROTOCOL_ACCEPTABLE },

   { "signal.org",                            "Signal",           NDPI_PROTOCOL_SIGNAL, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },
   { "whispersystems.org",            "Signal",           NDPI_PROTOCOL_SIGNAL, NDPI_PROTOCOL_CATEGORY_CHAT, NDPI_PROTOCOL_ACCEPTABLE },

   { "musical.ly",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "byteoversea.com",                       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-tiktok-sign-va-h2.ibyteimg.com",    "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-tiktok-sg.ibyteimg.com",            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-tiktok-va.ibyteimg.com",            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-va-tiktok.ibyteimg.com",            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-ad-sg.ibyteimg.com",                "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p21-ad-sg.ibyteimg.com",                "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "tiktokcdn.com",                         "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-tiktok-va-h2.ibyteimg.com",         "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "p16-tiktokcdn-com.akamaized.net",       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "tiktokcdn.liveplay.myqcloud.com",       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "musemuse.cn",                           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "tiktokv.com",                           "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "bytecdn.cn",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "muscdn.com",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "tiktok.com",                            "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "byted.org",                             "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".tik-tokcdn.com",                       "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "v19.byteicdn.com",                      "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "v16m.byteicdn.com",                     "TikTok",           NDPI_PROTOCOL_TIKTOK, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   { "brasilbandalarga.com.br",     "EAQ",              NDPI_PROTOCOL_EAQ, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },
   { ".eaqbr.com.br",                       "EAQ",              NDPI_PROTOCOL_EAQ, NDPI_PROTOCOL_CATEGORY_NETWORK, NDPI_PROTOCOL_ACCEPTABLE },

   { ".net.anydesk.com",              "AnyDesk",        NDPI_PROTOCOL_ANYDESK, NDPI_PROTOCOL_CATEGORY_REMOTE_ACCESS, NDPI_PROTOCOL_ACCEPTABLE },

   { "discordapp.com",               "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "discordapp.net",               "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "discord.com",                  "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "discord.gg",                   "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },
   { "discord.media",                "Discord",        NDPI_PROTOCOL_DISCORD, NDPI_PROTOCOL_CATEGORY_COLLABORATIVE, NDPI_PROTOCOL_ACCEPTABLE },

   /*
     Amazon Alexa services
   */
   { "alexa.amazon.com",             "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "amazonalexa.com",              "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-1-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-2-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-3-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-4-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-5-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-6-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-7-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-8-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-9-na.amazon.com",    "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-10-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-11-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-12-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-13-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-14-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-15-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-16-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-17-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-18-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },
   { "avs-alexa-19-na.amazon.com",   "AmazonAlexa",        NDPI_PROTOCOL_AMAZON_ALEXA, NDPI_PROTOCOL_CATEGORY_VIRTUAL_ASSISTANT, NDPI_PROTOCOL_ACCEPTABLE },

   /*
     Tumblr social network service
   */
   { "tumblr.com",                   "Tumblr",        NDPI_PROTOCOL_TUMBLR, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   /*
     Reddit social network service
   */
   { ".redd.it",                   "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".reddit.com",                "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".redditmedia.com",           "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".redditstatic.com",          "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".reddit.map.fastly.net",          "Reddit",        NDPI_PROTOCOL_REDDIT, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   /*
     Pinterest social network service
   */
   { ".pinimg.com",                      "Pinterest",      NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "pinterest.global.map.fastly.net",  "Pinterest",      NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "pinterest.map.fastly.net",         "Pinterest",      NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "pinterest.",                     "Pinterest",        NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "pinterest.co.",                  "Pinterest",        NDPI_PROTOCOL_PINTEREST, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   /*
     Disney's DisneyPlus streaming service
   */
   { "dssott.com.akamaized.net",               "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "disney-plus.com",                        "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "disney-plus.net",                        "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "disneyplus.com",                         "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "disneyplus.net",                         "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "dssott.com",                             "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "disneyplus.com.ssl.sc.omtrdc.net",       "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },
   { "search-api-disney.bamgrid.com",          "DisneyPlus",        NDPI_PROTOCOL_DISNEYPLUS, NDPI_PROTOCOL_CATEGORY_STREAMING, NDPI_PROTOCOL_FUN },

   /*
     Likee app
   */
   { ".like.video",               "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".likee.video",              "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".likeevideo.com",           "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".like-video.com",           "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".likeimo.tech",             "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { ".liketech.tech",            "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },
   { "bstream.hzmklvdieo.com",    "Likee",     NDPI_PROTOCOL_LIKEE, NDPI_PROTOCOL_CATEGORY_SOCIAL_NETWORK, NDPI_PROTOCOL_FUN },

   /*
     Activision
    */
   { "activision.",           "Activision",        NDPI_PROTOCOL_ACTIVISION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { ".activision.com",       "Activision",        NDPI_PROTOCOL_ACTIVISION, NDPI_PROTOCOL_CATEGORY_GAME, NDPI_PROTOCOL_FUN },
   { NULL, NULL, NDPI_PROTOCOL_UNKNOWN, NDPI_PROTOCOL_CATEGORY_UNSPECIFIED, NDPI_PROTOCOL_SAFE }
  };

/* ******************************************************************** */

static ndpi_tls_cert_name_match tls_certificate_match [] = {
  { "CN=AnyDesk Client",               NDPI_PROTOCOL_ANYDESK     },
  { "O=Kakao",                         NDPI_PROTOCOL_KAKAOTALK   },
  { "O=ntop.org",                      NDPI_PROTOCOL_NTOP        },
  { "O=Netflix",                       NDPI_PROTOCOL_NETFLIX     },
  { "O=Cloudflare",                    NDPI_PROTOCOL_CLOUDFLARE  },
  { "CN=simplednscrypt.org",           NDPI_PROTOCOL_DNSCRYPT    },
  { "CN=*.gateway.messenger.live.com", NDPI_PROTOCOL_SKYPE_TEAMS },
  { "OU=FortiGate",                    NDPI_PROTOCOL_FORTICLIENT },

  { NULL, 0 }
};

/* ******************************************************************** */

/*
   IMPORTANT

   Do NOT pur here strings that overlap with string in host_match[]
   specified above
*/

static ndpi_category_match category_match[] = {
   { ".edgecastcdn.net",                 NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".hwcdn.net",                       NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".llnwd.net",                       NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".llns.net",                        NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".fastly.net",                      NDPI_PROTOCOL_CATEGORY_MEDIA },
   { ".vultr.com",                       NDPI_PROTOCOL_CATEGORY_CLOUD },
   { "baidu.com",                        NDPI_PROTOCOL_CATEGORY_WEB },
   { "icq.com",                          NDPI_PROTOCOL_CATEGORY_CHAT },
   { "quickplay.com",                    NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".iqiyi.com",                       NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".qiyi.com",                        NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".71.am",                           NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".qiyipic.com",                     NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".1kxun.",                          NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "tcad.wedolook.com",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".rapidvideo.com",                  NDPI_PROTOCOL_CATEGORY_STREAMING },
   { ".playercdn.net",                   NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "showmax.com",                      NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "showmax.akamaized.net",            NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "skyq.sky.com",                     NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "iptv.sky.",                        NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "pcdn.skycdn.",                     NDPI_PROTOCOL_CATEGORY_STREAMING },

   /* https://success.tanaza.com/s/article/How-Automatic-Detection-of-Captive-Portal-works */
   { "captive.apple.com",                NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "captive.apple.com.",               NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK }, /* apple.com.edgekey.net */
   { "thinkdifferent.us",                NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "airport.us",                       NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "gsp1.apple.com",                   NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "testconnectivity.microsoft.com",   NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "teredo.ipv6.microsoft.com",        NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "teredo.ipv6.microsoft.com.nsatc.net",   NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "detectportal.firefox.com",         NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "connectivitycheck.android.com",    NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },
   { "connectivitycheck.gstatic.com",    NDPI_PROTOCOL_CATEGORY_CONNECTIVITY_CHECK },

   /* Hulu Streaming services AS23286 */
   { "8.28.124.0/24",                   NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "8.28.125.0/24",                   NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "199.200.50.0/23",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "199.200.51.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "199.60.116.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "208.91.158.0/23",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "209.249.186.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },

   /* Disney Streaming services AS11251 */
   { "8.4.4.0/24",                      NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "8.5.5.0/24",                      NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "8.33.30.0/24",                    NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "63.116.222.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "63.116.223.0/24",                 NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.192.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.193.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.200.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.201.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.202.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.203.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.204.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.205.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.206.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.207.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.208.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.209.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.212.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.216.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },
   { "139.104.217.0/24",                NDPI_PROTOCOL_CATEGORY_STREAMING },

   { NULL, 0 }
};

/* ******************************************************************** */

/*
  Tor
  The tor protocol uses SSL to contact peers so it could be exchanged with
  standard SSL. However the host names such as

  - www.fgd2iwya7vinfutj5wq5we.com
  - www.qbtxzhetq4s2f.com
  - www.fgd2iwya7vinfutj5wq5we.net

  See also DGA (Domain Generation Algorithm)

  In essence www.<name>.com|net

  To do things properly we should check if host name in the certificate
  exists or if the IP address of the SSL peer resolves to a name. Unfortunately
  for performance reasons we can't afford to do a DNS lookup in nDPI (however apps
  can do it if possible) and thus we have created a heuristic algorithm that tries
  to check the host name (in the SSL certificate) to see if it looks like a
  random name or a real name. We cannot use a dictionary (how can the kernel read a file?)
  and this we use bigrams distribution to decide if the string looks like a
  word or just random chars.

  http://www3.nd.edu/~busiforc/handouts/cryptography/Letter%20Frequencies.html

  DGA Datasets
  - https://data.netlab.360.com/dga/
  - https://github.com/baderj/domain_generation_algorithms
*/

static const char *ndpi_en_bigrams[] = {
  "aa", "ba", "ca", "da", "ea", "fa", "ga", "ha", "ia", "ja", "ka", "la", "ma", "na", "oa", "pa", "qa",
  "ra", "sa", "ta", "ua", "va", "wa", "xa", "ya", "za", "ab", "bb", "db", "eb", "fb", "gb", "hb", "ib",
  "kb", "lb", "mb", "nb", "ob", "pb", "rb", "sb", "tb", "ub", "wb", "yb", "ac", "bc", "cc", "dc", "ec",
  "fc", "gc", "hc", "ic", "kc", "lc", "mc", "nc", "oc", "pc", "rc", "sc", "tc", "uc", "wc", "xc", "yc",
  "ad", "bd", "cd", "dd", "ed", "fd", "gd", "hd", "id", "kd", "ld", "md", "nd", "od", "pd", "rd", "sd",
  "td", "ud", "wd", "xd", "yd", "zd", "ae", "be", "ce", "de", "ee", "fe", "ge", "he", "ie", "je", "ke",
  "le", "me", "ne", "oe", "pe", "re", "se", "te", "ue", "ve", "we", "xe", "ye", "ze", "af", "bf", "df",
  "ef", "ff", "gf", "hf", "if", "kf", "lf", "mf", "nf", "of", "pf", "rf", "sf", "tf", "uf", "wf", "xf",
  "yf", "zf", "ag", "bg", "dg", "eg", "fg", "gg", "hg", "ig", "kg", "lg", "ng", "og", "pg", "rg", "sg",
  "tg", "ug", "wg", "yg", "ah", "bh", "ch", "dh", "eh", "fh", "gh", "hh", "ih", "kh", "lh", "mh", "nh",
  "oh", "ph", "rh", "sh", "th", "uh", "wh", "xh", "yh", "ai", "bi", "ci", "di", "ei", "fi", "gi", "hi",
  "ii", "ji", "ki", "li", "mi", "ni", "oi", "pi", "qi", "ri", "si", "ti", "ui", "vi", "wi", "xi", "yi",
  "zi", "aj", "bj", "dj", "ej", "fj", "gj", "hj", "ij", "jj", "kj", "lj", "nj", "oj", "pj", "rj", "sj",
  "tj", "uj", "wj", "yj", "ak", "ck", "dk", "ek", "gk", "ik", "kk", "lk", "mk", "nk", "ok", "pk", "rk",
  "sk", "tk", "uk", "wk", "yk", "zk", "al", "bl", "cl", "dl", "el", "fl", "gl", "hl", "il", "kl", "ll",
  "ml", "nl", "ol", "pl", "rl", "sl", "tl", "ul", "vl", "wl", "xl", "yl", "zl", "am", "bm", "cm", "dm",
  "em", "fm", "gm", "hm", "im", "km", "lm", "mm", "nm", "om", "pm", "rm", "sm", "tm", "um", "wm", "xm",
  "ym", "zm", "an", "bn", "cn", "dn", "en", "fn", "gn", "hn", "in", "kn", "ln", "mn", "nn", "on", "pn",
  "rn", "sn", "tn", "un", "wn", "xn", "yn", "ao", "bo", "co", "do", "eo", "fo", "go", "ho", "io", "jo",
  "ko", "lo", "mo", "no", "oo", "po", "ro", "so", "to", "uo", "vo", "wo", "xo", "yo", "zo", "ap", "bp",
  "dp", "ep", "fp", "gp", "hp", "ip", "kp", "lp", "mp", "np", "op", "pp", "rp", "sp", "tp", "up", "wp",
  "xp", "yp", "zp", "aq", "cq", "dq", "eq", "hq", "iq", "nq", "oq", "qq", "rq", "sq", "uq", "xq", "ar",
  "br", "cr", "dr", "er", "fr", "gr", "hr", "ir", "kr", "lr", "mr", "nr", "or", "pr", "rr", "sr", "tr",
  "ur", "vr", "wr", "xr", "yr", "as", "bs", "cs", "ds", "es", "fs", "gs", "hs", "is", "ks", "ls", "ms",
  "ns", "os", "ps", "rs", "ss", "ts", "us", "vs", "ws", "xs", "ys", "at", "bt", "ct", "dt", "et", "ft",
  "gt", "ht", "it", "kt", "lt", "mt", "nt", "ot", "pt", "rt", "st", "tt", "ut", "wt", "xt", "yt", "zt",
  "au", "bu", "cu", "du", "eu", "fu", "gu", "hu", "iu", "ju", "ku", "lu", "mu", "nu", "ou", "pu", "qu",
  "ru", "su", "tu", "uu", "vu", "wu", "xu", "yu", "zu", "av", "bv", "dv", "ev", "iv", "lv", "mv", "nv",
  "ov", "rv", "sv", "tv", "uv", "vv", "zv", "aw", "bw", "dw", "ew", "fw", "gw", "hw", "iw", "kw", "lw",
  "mw", "nw", "ow", "pw", "rw", "sw", "tw", "uw", "ww", "xw", "yw", "zw", "ax", "ex", "ix", "nx", "ox",
  "rx", "ux", /* "xx", */ "yx", "ay", "by", "cy", "dy", "ey", "fy", "gy", "hy", "ky", "ly", "my", "ny", "oy",
  "py", "ry", "sy", "ty", "uy", "vy", "wy", "xy", "yy", "zy", "az", "bz", "cz", "dz", "ez", "gz", "iz",
  "lz", "nz", "oz", "pz", "rz", "tz", "uz", "zz",
  NULL };

/* ******************************************************************** */

/* http://practicalcryptography.com/media/cryptanalysis/files/english_trigrams.txt.zip */
/* Top EN trigrams */
static const char *ndpi_en_trigrams[] = {
"the", "and", "ing", "ent", "ion", "her", "for", "tha", "nth", "int", "ere", "tio", "ter", "est", "ers", "ati", "hat", "ate", "all", "eth", "hes", "ver", "his", "oft", "ith", "fth", "sth", "oth", "res", "ont", "dth", "are", "rea", "ear", "was", "sin", "sto", "tth", "sta", "thi", "tin", "ted", "ons", "edt", "wit", "san", "din", "ort", "con", "rth", "eve", "eco", "era", "ist", "ngt", "ast", "ill", "com", "ore", "ive", "nce", "one", "edi", "pro", "ess", "out", "ein", "att", "men", "hec", "esa", "hen", "ina", "eri", "ert", "ame", "iti", "ome", "son", "art", "man", "ean", "ona", "eof", "tor", "hea", "ran", "rin", "ine", "eda", "nto", "ave", "nin", "ove", "oun", "ain", "ant", "str", "eto", "hem", "sof", "per", "nde", "ste", "nte", "eas", "dto", "our", "red", "rom", "tof", "ght", "tot", "ese", "cha", "ica", "hei", "hin", "ide", "ndt", "han", "tan", "lin", "not", "der", "ect", "tra", "igh", "fro", "eat", "sti", "hep", "ndi", "ins", "she", "nal", "pla", "als", "een", "nti", "you", "lan", "und", "nda", "rat", "lea", "can", "has", "nds", "nga", "hel", "hed", "inc", "use", "esi", "gth", "asa", "het", "nts", "hav", "hew", "tho", "but", "nan", "ass", "hef", "ies", "ret", "end", "par", "wer", "cti", "ren", "rec", "cal", "its", "ree", "ene", "rst", "eal", "ana", "nst", "cou", "tur", "min", "ity", "yth", "hey", "eca", "oul", "lle", "ard", "rou", "anc", "ost", "pre", "age", "efo", "les", "ssi", "ema", "eso", "tat", "ath", "wor", "ust", "heb", "ewa", "sho", "ind", "sed", "hou", "lly", "uld", "ase", "ure", "ono", "ele", "enc", "nat", "ead", "whe", "ell", "ble", "kin", "ans", "tic", "ali", "sco", "ero", "whi", "ces", "own", "nta", "act", "ber", "ven", "tim", "don", "dan", "ose", "ice", "isa", "ton", "den", "ngs", "ugh", "nes", "lat", "tal", "edo", "ten", "ime", "eme", "ack", "tes", "ple", "ous", "off", "tto", "chi", "ani", "orm", "ned", "ens", "sha", "mor", "iss", "ite", "nge", "tis", "ora", "lli", "ede", "sse", "ade", "rie", "aid", "emo", "ral", "sit", "oin", "hth", "tre", "any", "ake", "ern", "mer", "ric", "dis", "ish", "oug", "ini", "ong", "ntr", "eli", "wil", "led", "sar", "how", "edb", "ich", "spe", "sea", "lit", "yin", "sai", "ndo", "gin", "shi", "ord", "mon", "ena", "new", "por", "ser", "ial", "ori", "tte", "mar", "epr", "ach", "har", "yea", "tri", "che", "tea", "unt", "omp", "who", "tar", "owe", "rit", "ded", "ors", "day", "hee", "thr", "eir", "ond", "mes", "efi", "had", "ner", "ela", "let", "lso", "ris", "ire", "isi", "met", "ars", "hic", "cen", "ari", "fin", "tob", "nsi", "las", "ope", "lar", "des", "fte", "nit", "sen", "ang", "som", "abo", "sio", "two", "ian", "eis", "tsa", "ngi", "uni", "ses", "rep", "rac", "top", "abl", "eti", "ebe", "eha", "now", "oni", "ves", "fir", "erc", "ofa", "ace", "sal", "get", "app", "ane", "rsa", "nof", "heh", "gre", "win", "car", "ete", "mat", "cho", "lay", "swe", "esp", "pri", "tiv", "rof", "gra", "llo", "cor", "eac", "nis", "dit", "gan", "gto", "eno", "bou", "obe", "esh", "tos", "ery", "rma", "ngo", "ewi", "ara", "rto", "rel", "oma", "ala", "asi", "tst", "utt", "irs", "yan", "lla", "sfo", "ork", "ett", "lth", "sid", "aso", "swi", "ita", "set", "twa", "erm", "epa", "ron", "tit", "aft", "dre", "tle", "mil", "dby", "ale", "pen", "bec", "mbe", "toa", "heg", "sch", "sis", "rti", "heo", "low", "lis", "oll", "war", "alt", "elo", "tro", "cat", "med", "lic", "hil", "ile", "tht", "rem", "rre", "ays", "oli", "rso", "nsa", "omm", "old", "cre", "ata", "ise", "cia", "pos", "ger", "sma", "uti", "sts", "sec", "sbe", "eni", "sre", "lon", "isc", "nse", "nor", "bee", "ano", "nco", "fer", "itt", "sno", "epo", "eon", "eds", "eam", "esc", "fic", "ech", "way", "ved", "ike", "alo", "yof", "ash", "ote", "ook", "eta", "erf", "onc", "emi", "eci", "ats", "erv", "rsi", "sst", "ili", "eed", "ary", "sso", "mth", "vel", "dat", "mea", "esu", "uri", "pan", "rch", "uth", "spo", "wou", "ffe", "sel", "rei", "rge", "rse", "tom", "usi", "ega", "sas", "ssa", "ato", "erw", "ood", "ama", "sat", "ece", "mpl", "tso", "gen", "arr", "dea", "sca", "dof", "ual", "dbe", "ewo", "nso", "rte", "vin", "adi", "ndw", "ndh", "edf", "swh", "see", "toc", "tch", "ewh", "eba", "onl", "tem", "dwi", "err", "lec", "lac", "eop", "tel", "ami", "ehe", "dfo", "ien", "uch", "ndc", "ely", "dst", "ici", "edw", "aus", "nfo", "ntt", "nne", "ewe", "sur", "exp", "bet", "ket", "inf", "etr", "yto", "rde", "rce", "omt", "evi", "vet", "pec", "rai", "arl", "yst", "sou", "him", "ref", "lik", "ges", "cto", "urn", "fou", "lls", "rne", "wha", "tow", "ndr", "das", "ssu", "spr", "opl", "rad", "esw", "onf", "col", "omi", "duc", "mos", "ark", "tai", "ick", "hos", "ult", "emb", "ign", "hoo", "too", "nea", "itw", "ppe", "ffi", "ula", "nam", "mis", "ced", "los", "gam", "nas", "reg", "lie", "olo", "twe", "ann", "tod", "ail", "ota", "iso", "aye", "tco", "gro", "cam", "efe", "onw", "bea", "ngl", "wee", "edu", "rew", "aga", "til", "ode", "ory", "erb", "bac", "len", "nly", "imp", "aro", "ehi", "amp", "mpa", "spa", "ivi", "ict", "stt", "net", "rta", "hre", "erh", "eet", "row", "sor", "epe", "tie", "nch", "tru", "mal", "cte", "ndm", "atc", "fac", "twi", "orc", "dco", "ndp", "fre", "ofs", "arg", "ima", "dec", "eng", "ria", "owi", "eit", "pol", "ked", "inn", "bli", "dow", "etw", "clu", "hol", "air", "rri", "rig", "sla", "rop", "ofi", "toh", "non", "ool", "isp", "mak", "rev", "equ", "lyt", "jus", "lya", "ole", "cit", "pea", "vea", "kno", "oca", "tak", "acc", "cer", "ada", "sup", "ngw", "peo", "dso", "rdi", "tou", "cau", "rov", "tfo", "stu", "pin", "tly", "ied", "ues", "tsi", "awa", "ler", "wel", "epl", "hor", "erp", "hro", "ute", "oss", "tbe", "tyo", "tog", "heu", "byt", "ngf", "ngh", "hal", "ban", "ism", "rol", "atu", "sam", "hom", "dhi", "ild", "gai", "rds", "edh", "ino", "ego", "egi", "llt", "arc", "ram", "oto", "cle", "dhe", "aco", "orl", "cas", "riv", "ofc", "orn", "rna", "urs", "avi", "nar", "ubl", "tti", "mem", "amo", "rme", "qui", "que", "nee", "ndf", "inh", "ink", "eho", "ncl", "ock", "vic", "rts", "ets", "leg", "cla", "tse", "eor", "nci", "sli", "erg", "did", "rco", "bas", "loc", "ebu", "hig", "asp", "ext", "egr", "dia", "tab", "bri", "cei", "ras", "dal", "alc", "run", "ppo", "ofh", "cke", "atw", "cea", "ott", "bal", "nsh", "mai", "dar", "asb", "rfo", "vis", "owa", "ude", "rsh", "ifi", "loo", "hit", "uar", "cet", "ovi", "ndb", "tol", "uto", "lem", "bro", "vid", "rio", "uct", "try", "efr", "sde", "dha", "bel", "bil", "tas", "suc", "ebo", "oro", "sev", "mit", "yco", "nwh", "neo", "rvi", "dev", "eun", "wan", "sig", "ths", "asc", "dsa", "tac", "emp", "ank", "rke", "nhe", "nme", "nre", "ros", "ngc", "may", "unc", "nic", "nni", "ura", "ful", "oco", "osi", "def", "ngr", "tec", "say", "nbe", "yre", "ntl", "dge", "sac", "sfr", "tsh", "isn", "ldi", "arm", "cur", "eag", "ndl", "eld", "smo", "org", "llb", "del", "poi", "iat", "urt", "ker", "sol", "tma", "mus", "bei", "qua", "lys", "dwa", "nma", "hip", "rod", "efa", "inv", "isl", "pon", "yon", "pas", "lia", "reo", "lif", "tia", "cri", "nsu", "rly", "lbe", "oha", "ndd", "ham", "ept", "ebr", "bes", "ngp", "yha", "tme", "lef", "add", "ofm", "mad", "dma", "dur", "mme", "mas", "ize", "ics", "ybe", "dno", "ege", "gat", "dde", "cul", "uta", "meo", "lco", "val", "atr", "ecu", "ged", "ndu", "yar", "det", "isf", "ofp", "spi", "rot", "rob", "ped", "lde", "oti", "eek", "dem", "bef", "mov", "els", "iou", "swa", "erl", "imi", "fam", "nex", "lof", "fan", "oes", "scr", "isw", "ull", "erd", "inm", "soc", "rni", "eel", "apa", "mic", "dep", "rda", "pit", "ogr", "sun", "esf", "ida", "gar", "cks", "rag", "geo", "goo", "lud", "nhi", "ife", "bra", "ddi", "pat", "ceo", "ngb", "kes", "yer", "nwa", "dra", "lyi", "odu", "pub", "inu", "orr", "aya", "lor", "ttl", "hon", "sab", "nha", "ldb", "liv", "edr", "seo", "oad", "rmo", "dle", "ecr", "udi", "gon", "alf", "die", "rwa", "lst", "lig", "rid", "rmi", "ofe", "urc", "sic", "ape", "ayi", "bot", "eye", "fri", "ila", "ryo", "ado", "alm", "sag", "nwi", "wed", "nno", "abi", "rve", "ees", "aki", "fie", "bor", "dou", "eep", "dif", "tet", "orp", "ito", "ayt", "onh", "oba", "tud", "vie", "nyo", "sbu", "dic", "dri", "ofo", "oan", "rya", "rus", "xpe", "nca", "nve", "ily", "hot", "nag", "uts", "lre", "rap", "ecl", "dse", "oup", "leo", "upp", "roa", "nad", "bus", "ntw", "alp", "urr", "yfo", "omo", "onm", "ntu", "ows", "iff", "rsw", "asw", "asn", "hap", "cce", "cro", "ier", "cco", "cap", "lev", "tsw", "ken", "oke", "owt", "asm", "ngm", "cts", "nou", "put", "reb", "tta", "edm", "lio", "ney", "onb", "sfi", "tag", "eem", "umb", "cra", "anu", "swo", "wev", "eig", "ssh", "eus", "eyo", "sim", "gle", "roc", "cie", "log", "reh", "wth", "slo", "eer", "ift", "hev", "fit", "tua", "epu", "gov", "got", "cin", "inw", "inp", "wes", "ago", "ams", "sap", "itu", "oac", "opp", "etu", "wat", "sus", "lai", "arn", "eea", "itc", "isr", "tca", "rld", "alr", "ask", "ctu", "lto", "oge", "oot", "eap", "pti", "edp", "fea", "fil", "twh", "ngu", "ems", "veb", "uil", "mot", "roo", "rpr", "rli", "mpo", "isb", "elf", "dfr", "sei", "oon", "sle", "mou", "nev", "nec", "clo", "iel", "lot", "usa", "apr", "edc", "rer", "lei", "fra", "wea", "nen", "alw", "esb", "bar", "eya", "nei", "nsw", "elp", "ola", "eak", "fen", "esn", "ryt", "orh", "anb", "lsa", "far", "giv", "pic", "cep", "toe", "dpr", "rim", "eab", "pac", "lti", "hof", "asu", "saf", "ews", "stw", "eex", "atm", "mpe", "tba", "tee", "inb", "eav", "dwh", "nom", "mun", "enh", "rro", "pet", "nsp", "mto", "agr", "lew", "rha", "lve", "alb", "odo", "tun", "lwa", "gue", "dca", "rar", "rwh", "pai", "hop", "rog", "nfr", "fal", "onn", "inl", "sep", "bat", "smi", "vem", "cus", "epi", "wal", "dsh", "lab", "thc", "apo", "aan", "odi", "fol", "gof", "squ", "sfa", "bur", "nac", "rga", "vil", "ngd", "oci", "hir", "rhe", "uss", "efu", "ywi", "esm", "ywa", "npr", "ume", "oda", "osa", "dro", "ghe", "ghi", "opr", "van", "lds", "kan", "beg", "rpo", "orw", "isd", "dmi", "goi", "fun", "oar", "ofr", "onp", "rib", "idi", "rwi", "lop", "hto", "edd", "stp", "mag", "sne", "sem", "eru", "adt", "bui", "mmi", "alk", "gal", "ibl", "opu", "ald", "oal", "ysa", "tsc", "idt", "pli", "muc", "num", "sba", "nel", "nia", "enu", "ruc", "lyo", "stm", "bre", "toi", "esd", "dmo", "ryi", "ots", "sda", "vol", "dam", "aca", "rbe", "pul", "won", "exa", "yed", "lse", "aci", "stc", "ofw", "lim", "atl", "ais", "flo", "cel", "rno", "cht", "sty", "boo", "aug", "rys", "upt", "sex", "spl", "rty", "eva", "ysi", "ofb", "ldr", "uit", "cli", "mei", "ior", "doe", "ira", "lyw", "igi", "siv", "nab", "law", "tpr", "lda", "ayo", "rki", "idn", "nio", "iva", "tya", "pho", "coa", "ilt", "chr", "ndg", "phi", "eff", "eyw", "raf", "yis", "asr", "nov", "lyb", "aut", "nap", "fee", "ndn", "gfo", "sub", "ski", "nty", "asf", "oor", "aff", "enn", "sdi", "hur", "stl", "lyc", "dir", "cut", "wen", "afe", "dne", "kth", "plo", "rab", "nfi", "yma", "ofl", "ung", "anw", "tmo", "enw", "gas", "tss", "jec", "foo", "gis", "vat", "ley", "tne", "ush", "rnm", "tsp", "nsc", "gea", "div", "sad", "dsi", "fco", "opo", "fhi", "edl", "yor", "yca", "iev", "ywe", "omb", "ird", "big", "tif", "dli", "rhi", "rca", "gha", "pth", "sgo", "ywh", "ava", "sib", "gwi", "sum", "atp", "leb", "tsu", "cki", "fec", "ncr", "rle", "sme", "cis", "tdo", "olu", "kea", "iew", "yse", "mod", "uce", "fai", "nig", "tye", "tli", "tsf", "rba", "dor", "aba", "enb", "bla", "rsc", "thh", "mpi", "ads", "mmu", "pow", "lfo", "gst", "asd", "egu", "snt", "tno", "adv", "iet", "bya", "nvi", "aha", "ofd", "cov", "pop", "rra", "nli", "lte", "uca", "dwe", "tei", "nue", "fla", "sdo", "ril", "iro", "iam", "tev", "esl", "mpr", "edg", "mew", "ico", "yal", "yle", "ntf", "stb", "lyd", "eft", "orb", "hte", "cem", "ben", "yas", "kee", "ntc", "ntb", "une", "nem", "eou", "ouc", "ppl", "thu", "tex", "icu", "rdo", "sew", "sul", "osp", "exc", "otb", "gne", "ids", "kil", "lov", "sys", "ims", "niv", "oom", "stf", "irc", "ohi", "nmo", "asl", "onv", "tde", "oce", "ebi", "pto", "ldh", "ype", "nie", "nsf", "elt", "ibe", "fig", "npa", "fat", "lym", "tyt", "typ", "dnt", "lue", "uro", "owh", "ohe", "blo", "wri", "hts", "rks", "deo", "hri", "sot", "lyr", "dus", "ayb", "chu", "tfr", "wom", "yde", "bin", "req", "gge", "mel", "ffo", "arb", "sop", "uma", "vio", "inr", "rtu", "ror", "taf", "dab", "mee", "lee", "inj", "mse", "vei", "bed", "bit", "hek", "ury", "ppr", "tep", "dac", "mac", "acr", "mma", "enr", "utw", "onr", "nju", "eys", "fas", "kto", "orf", "pte", "cid", "ysh", "var", "saw", "eaf", "tla", "cka", "sia", "obl", "uen", "rsu", "oki", "uat", "uet", "ajo", "cos", "ckt", "chw", "oas", "llh", "sbo", "few", "mst", "scu", "boa", "rry", "eev", "lma", "lyf", "veh", "ido", "mid", "ois", "teo", "sci", "owo", "uck", "dch", "irt", "opa", "rss", "agu", "rsp", "ule", "eki", "beh", "oye", "nwe", "dom", "ady", "ypr", "nki", "fes", "git", "nfe", "ssp", "lou", "ymo", "urg", "pra", "dme", "sow", "edn", "sav", "icl", "opi", "lyp", "kof", "nla", "ldt", "rav", "tfi", "dot", "rfa", "eau", "nho", "dba", "nim", "cew", "ske", "enf", "rho", "nna", "tpa", "wis", "dfi", "anh", "api", "rpa", "llc", "ipa", "adm", "gla", "tap", "abe", "ety", "gco", "rms", "ldn", "lam", "tam", "yat", "anp", "dla", "iri", "nbu", "emu", "ntp", "uns", "ols", "dpa", "lmo", "gua", "irl", "nef", "rbo", "pal", "urd", "lyh", "sce", "anf", "gni", "rip", "urp", "ify", "nle", "eph", "efl", "woo", "mmo", "iga", "joh", "sra", "isg", "tir", "ttr", "thm", "ydi", "fel", "jor", "dpo", "rtr", "sue", "yso", "dho", "lpr", "rla", "opt", "ksa", "cta", "mpt", "yhe", "dup", "nol", "oso", "hej", "alu", "gli", "goa", "itl", "cko", "thw", "bly", "dsu", "hwa", "tsb", "ofg", "rfi", "otr", "wna", "ohn", "gio", "pur", "mec", "nfl", "zed", "ilm", "dbu", "dun", "ogi", "fli", "ucc", "nba", "fle", "raw", "eiv", "deb", "eot", "unn", "ntm", "evo", "mig", "hai", "ldo", "oat", "nfa", "ssc", "lus", "naf", "iwa", "eup", "cip", "pay", "chs", "atf", "amb", "ody", "agi", "yme", "exi", "tpe", "rpe", "imm", "lye", "tbu", "ctt", "llp", "lha", "tdi", "ils", "eur", "lbu", "tyi", "hun", "hie", "gsa", "nif", "nks", "wnt", "atb", "ddo", "gel", "lep", "msa", "enm", "oms", "ywo", "rye", "dap", "osh", "hco", "apt", "irm", "maj", "ait", "yfr", "ocr", "gho", "yli", "tys", "atd", "upa", "fyo", "nun", "afr", "avo", "adb", "eim", "usl", "tpo", "lad", "owl", "htt", "bod", "dwo", "ffa", "liz", "och", "thl", "lau", "scl", "anm", "vot", "npo", "vit", "rdt", "hti", "daf", "mof", "ief", "fiv", "kel", "pot", "isu", "olv", "enp", "key", "rsf", "rlo", "ncy", "rgi", "chn", "una", "ilo", "ghs", "ods", "ony", "afo", "mef", "oub", "lsi", "thp", "sna", "loy", "pir", "tlo", "hta", "lag", "ych", "dtr", "rns", "cef", "hum", "ofn", "lex", "sef", "ndy", "amm", "gui", "cil", "dpe", "vec", "hus", "kst", "llw", "sgr", "esr", "aph", "uir", "awi", "tmi", "tsm", "ocu", "dru", "jun", "tew", "niz", "osu", "uff", "six", "quo", "nke", "hhi", "dua", "chh", "dyo", "eju", "sil", "tok", "iha", "phe", "wne", "gso", "dsp", "dlo", "nss", "rfr", "eec", "hma", "oit", "dad", "ips", "nbo", "gor", "lta", "rtt", "yno", "eyc", "tig", "wns", "dav", "ray", "hhe", "nmi", "ump", "iza", "noc", "lut", "veo", "tef", "ccu", "aim", "kat", "alg", "dsc", "occ", "ldw", "idd", "job", "anr", "nlo", "fis", "nyt", "ryw", "fhe", "eyh", "upe", "doc", "oru", "ctr", "adu", "ngg", "rsd", "ops", "tus", "syo", "mul", "ogo", "ups", "eck", "fed", "rtm", "teg", "chm", "sby", "tgo", "upo", "tyl", "rbu", "pie", "cec", "sua", "lel", "dee", "nby", "rex", "ued", "lca", "yne", "coo", "meb", "rey", "leh", "ceb", "mbi", "nus", "pme", "gol", "dio", "ldc", "ubs", "aig", "lum", "llf", "ylo", "ibu", "rwo", "std", "gna", "oct", "lib", "lme", "cad", "seb", "utu", "eby", "asg", "ydo", "glo", "mso", "aho", "ayw", "nwo", "ebl", "vir", "ryc", "oof", "lsh", "doi", "uis", "sov", "hca", "tad", "ckl", "lun", "oop", "rva", "gei", "nut", "ntd", "gri", "gul", "thb", "rtw", "rsb", "nua", "ias", "ugg", "rci", "awh", "eei", "mep", "sfu", "hno", "dex", "abr", "pof", "gem", "fma", "tut", "sbr", "aul", "vep", "ayf", "usp", "dly", "oph", "kso", "enl", "smu", "abu", "umm", "npe", "soi", "seh", "spu", "xam", "ybu", "lfa", "ycl", "aun", "pha", "mba", "ngn", "reu", "obs", "oks", "nau", "phy", "wid", "alh", "llm", "ipp", "adr", "chc", "dag", "bys", "jan", "gab", "usc", "nop", "dte", "soa", "afi", "ppi", "kis", "bab", "dva", "imt", "dei", "isk", "gma", "eke", "etc", "hle", "lyn", "lfi", "ewy", "thf", "gun", "sye", "rgo", "rif", "pes", "xpl", "aty", "thd", "nvo", "lid", "emt", "neg", "tsn", "rwe", "dfa", "sfe", "tup", "nos", "afa", "oje", "loa", "ypa", "lwi", "urb", "arp", "bon", "rul", "sro", "ibi", "dsw", "pio", "arw", "utc", "ply", "wyo", "aps", "ejo", "igu", "sly", "dvi", "hst", "rka", "oud", "roj", "nav", "aly", "obi", "ddr", "hoc", "yes", "asy", "tax", "icc", "ybo", "fur", "pis", "why", "dgo", "rpl", "tov", "ssf", "ofu", "mfo", "hoi", "irp", "soo", "tyc", "ige", "gus", "ypo", "lpa", "sju", "lyl", "nep", "nro", "hoh", "dpl", "oyo", "cca", "tpl", "itm", "gou", "eyr", "kon", "xte", "nsb", "gic", "mpu", "yla", "ium", "awe", "ryb", "fus", "ndj", "nsl", "fto", "oka", "zin", "ahe", "udg", "neb", "rum", "dol", "opm", "llr", "roy", "itr", "rbi", "kei", "tby", "lub", "ipl", "oil", "usu", "nct", "tay", "ysu", "ogy", "bam", "yhi", "ova", "hab", "upi", "due", "cop", "lpe", "exe", "oww", "nya", "ael", "dve", "esy", "dul", "joi", "ysc", "oen", "imo", "cru", "ygo", "rug", "uin", "rcu", "tyw", "vew", "bru", "hha", "svi", "pee", "fst", "dbo", "anl", "vef", "ntg", "nsm", "veg", "jac", "tsl", "lap", "sob", "thy", "oho", "gpr", "gag", "atn", "rsm", "zat", "eol", "rfe", "npl", "meh", "hsc", "weh", "idh", "iaa", "dta", "njo", "apl", "dbr", "utf", "env", "rgr", "ltu", "hod", "gfr", "lln", "nja", "mbl", "nbr", "cot", "dda", "ysp", "icr", "isy", "neu", "adc", "eny", "obo", "rsq", "gno", "sod", "eyd", "ssw", "teh", "gsi", "lhe", "dau", "fwh", "etb", "omh", "vai", "eyt", "lld", "nai", "aud", "lip", "yfi", "omy", "wro", "hfo", "rsl", "idg", "eaw", "lsc", "naw", "irf", "yac", "erk", "yit", "ayn", "tge", "oga", "yba", "dgr", "onj", "ryf", "ryp", "emy", "xis", "hme", "tsr", "uan", "itb", "pst", "nys", "lch", "bad", "sos", "boy", "oos", "vor", "oic", "uel", "ahi", "tfa", "ewr", "obu", "elv", "eov", "tbo", "flu", "ceh", "ssm", "dju", "riz", "ifo", "tau", "ayh", "cee", "urf", "wai", "utm", "uso", "xtr", "stg", "urv", "sve", "bul", "tsd", "acl", "yho", "eef", "moc", "tda", "ipt", "lts", "pap", "gir", "usb", "vey", "uic", "ekn", "yet", "psa", "lba", "rgu", "fse", "iod", "owd", "web", "dai", "dim", "sau", "yaf", "azi", "igg", "noo", "itf", "tga", "uli", "ltr", "osc", "lne", "chd", "xce", "oua", "eai", "stn", "iol", "gwa", "rcr", "gur", "utr", "lal", "eks", "aym", "soh", "llu", "jul", "iqu", "wew", "lsw", "utb", "kne", "shu", "voi", "teb", "pel", "uly", "kid", "bse", "iar", "hbo", "lpo", "rbr", "hmo", "fft", "ddl", "dqu", "hwe", "wst", "ytr", "yun", "omu", "hso", "pta", "sri", "oya", "sui", "sge", "utp", "yfa", "rcl", "gse", "adl", "sey", "uge", "kfo", "ryd", "rdw", "poo", "jur", "gwh", "rfu", "pus", "rnt", "itd", "atg", "lak", "fti", "dop", "lyg", "esk", "fpr", "pwi", "lwh", "upl", "doo", "fca", "awo", "icp", "tfe", "ndv", "arf", "gca", "eid", "erj", "onu", "ehu", "nka", "gew", "ymi", "pil", "cum", "edy", "ugu", "vee", "nra", "mys", "rmy", "irr", "tgr", "rup", "kep", "gmo", "gup", "cup", "ldm", "hsa", "ctl", "ndk", "fso", "ouw", "tbr", "keo", "kar", "utl", "sdu", "oex", "imb", "gbe", "obr", "nye", "ttw", "ewt", "ffs", "hwi", "neh", "chb", "lki", "gef", "fav", "oid", "rdr", "gme", "yda", "sga", "gac", "amt", "gia", "ghl", "ryl", "kha", "jam", "bir", "dov", "htw", "haw", "mwi", "noi", "chf", "aur", "gba", "fet", "bje", "fut", "llg", "otw", "kit", "enj", "gsh", "thn", "wif", "lob", "wei", "esg", "fde", "blu", "gav", "hys", "ckw", "fpe", "chp", "kle", "amu", "zon", "ngy", "lll", "sht", "seq", "byc", "jud", "god", "tyf", "rah", "guy", "wto", "dna", "nkt", "uha", "daw", "sdr", "bym", "yte", "bep", "rby", "utd", "nva", "oly", "ftw", "nob", "rym", "gdo", "lfr", "acu", "deg", "olt", "cif", "tty", "pag", "dtw", "fch", "byh", "via", "lph", "yab", "gap", "byp", "otc", "pse", "mco", "hpr", "sss", "hoa", "tcl", "zen", "owm", "dcr", "pou", "hac", "buy", "hse", "rtf", "nyw", "oap", "shm", "bum", "ums", "alv", "chl", "eja", "tju", "wle", "iec", "dcl", "dga", "lyu", "abs", "omf", "nri", "ryh", "bow", "yra", "ofj", "bst", "umi", "yen", "rok", "mur", "gly", "mwa", "wof", "sif", "rui", "yro", "imu", "iag", "lbo", "lsu", "lsp", "mps", "gec", "fmo", "elc", "msi", "sbi", "hni", "unl", "yex", "uty", "seu", "utn", "ouh", "lno", "htb", "lmi", "aln", "ofv", "idu", "ska", "bud", "sug", "mwh", "eew", "odr", "thg", "ksh", "ldl", "rtl", "wre", "tkn", "pso", "acy", "bsi", "gde", "iab", "dig", "ypl", "oys", "aka", "foc", "lga", "ghb", "adw", "rko", "ldp", "dsf", "iny", "upw", "eka", "omc", "ksi", "feb", "ssl", "cab", "lhi", "isv", "heq", "seg", "lty", "ilw", "ffr", "hce", "mbo", "nny", "wni", "hwh", "oxi", "aof", "mir", "fof", "lgo", "nym", "cir", "sru", "wec", "unk", "rsr", "lke", "wsa", "ayl", "gpo", "ybr", "hli", "geb", "mom", "yna", "edv", "sah", "aws", "eyb", "dew", "wic", "lho", "kem", "fmi", "ldf", "yap", "taw", "cth", "rgy", "dti", "gte", "viv", "ypi", "arv", "ipe", "yta", "kly", "kwi", "lav", "umo", "ofy", "rmu", "pun", "eym", "luc", "otl", "fta", "tna", "nyc", "mno", "tsg", "cyc", "olf", "fwa", "psi", "bol", "ddu", "dpu", "dsl", "adn", "siz", "djo", "lwo", "vas", "bis", "jap", "bem", "nqu", "gbu", "yri", "dfe", "haf", "eps", "nyp", "sie", "tue", "elm", "nnu", "npu", "dos", "fon", "amw", "dye", "tip", "arh", "wno", "fpo", "suf", "tts", "xpa", "kwa", "agg", "lvi", "toy", "nah", "mha", "mbu", "dmu", "hae", "ocl", "dog", "meg", "box", "usw", "eil", "rik", "lss", "dss", "bia", "rue", "ckb", "plu", "yad", "ewc", "aru", "rej", "bos", "uea", "nsd", "rjo", "ppa", "hla", "eyf", "nfu", "moo", "hbe", "hra", "dsm", "omw", "csa", "fpa", "idw", "fsa", "gad", "yss", "ewm", "mph", "toj", "ofk", "zer", "ayc", "ygr", "kab", "rtn", "tcr", "yge", "owc", "mhe", "tvi", "yus", "ysw", "sgi", "udo", "igr", "tyb", "tpu", "eje", "rdf", "odt", "gpa", "rut", "xec", "kas", "ifa", "urm", "yam", "owb", "lro", "rdl", "roi", "keh", "yot", "fly", "yti", "yby", "adh", "iwo", "lpl", "url", "ibr", "dah", "ctw", "eif", "cio", "ios", "otp", "ryr", "fem", "map", "hly", "tyh", "iot", "uid", "uag", "icy", "unf", "rau", "lwe", "nko", "ldg", "eah", "msw", "mie", "eyi", "hug", "usf", "tmu", "sir", "hsi", "fbe", "rae", "gyo", "mcc", "hsh", "dya", "fme", "joy", "ydr", "wso", "pau", "nsr", "cai", "gpe", "jer", "jou", "civ", "irb", "fab", "ncu", "gep", "ymp", "hio", "eeo", "obb", "owr", "ftr", "pok", "etf", "rkt", "udy", "fho", "dcu", "kor", "yag", "abb", "etm", "fne", "elb", "hdo", "skn", "tym", "aqu", "otm", "nyi", "irw", "msh", "rru", "gch", "lsf", "sph", "wwh", "ksw", "fno", "mbr", "sjo", "yel", "udd", "ntn", "odd", "goe", "beo", "ckh", "htr", "itn", "cog", "uer", "naa", "ogn", "hns", "hau", "irg", "eyl", "mre", "bay", "cof", "jon", "byr", "adf", "ptu", "kie", "hia", "fsu", "gsw", "ixt", "tyr", "yni", "dgi", "ggl", "oui", "okn", "hde", "icf", "mca", "nup", "hpo", "ldd", "cod", "avy", "gsu", "deh", "icd", "wnf", "uos", "otf", "wma", "eob", "ltt", "yfe", "fap", "byb", "ngv", "pfo", "hpa", "uls", "ckf", "mhi", "ulo", "fwe", "otu", "hag", "ptt", "wco", "cst", "emw", "ggr", "agn", "dys", "ipo", "edj", "elu", "kla", "ipi", "cky", "hoe", "bbe", "rdc", "ysl", "wos", "oko", "nmy", "adp", "fha", "tiz", "eyp", "ghw", "hyo", "ebs", "fsh", "lgr", "tjo", "uga", "ssr", "yev", "gfi", "iai", "usm", "okt", "rek", "tfu", "ngj", "rdu", "kew", "ggi", "egl", "aon", "bio", "shr", "gdi", "oea", "dki", "hmi", "lks", "bov", "kma", "xin", "asv", "gsc", "ysb", "uci", "rua", "tid", "shs", "icb", "xan", "rkw", "onk", "eeh", "iac", "lva", "dfu", "bso", "anj", "dja", "idl", "lpi", "ewp", "afu", "eww", "fif", "nmu", "hne", "tni", "gwe", "upf", "nsy", "kou", "byd", "cci", "ysm", "ymu", "etp", "ycr", "yye", "ius", "tah", "lom", "jos", "gwo", "sym", "ahu", "rls", "ayp", "fdi", "aar", "fid", "gtr", "cqu", "rdp", "beb", "pts", "pid", "mex", "coc", "fwi", "myo", "usd", "diu", "kec", "sky", "gti", "fru", "htf", "kup", "xim", "hdi", "elw", "kal", "irh", "byf", "oam", "hib", "kic", "rdb", "htl", "tqu", "otg", "eut", "ftt", "ube", "bun", "isj", "niq", "igo", "icm", "byi", "ueo", "dyi", "shc", "ssb", "tki", "xpo", "dsb", "xpr", "mob", "wye", "nru", "vac", "ntk", "wsp", "gaz", "kco", "tce", "dyt", "lah", "itp", "gns", "ghh", "bey", "tdr", "lft", "aks", "hch", "hda", "ngk", "geh", "ewb", "upr", "fba", "gsp", "beu", "dbl", "sbl", "fts", "tum", "lur", "rqu", "awn", "eum", "dbi", "mya", "icw", "ckn", "dil", "gos", "dut", "gil", "apu", "dpi", "doa", "rhu", "urh", "fad", "cag", "rtb", "orv", "gbo", "mam", "cow", "mol", "gaf", "axi", "raz", "mik", "dvo", "dfl", "atk", "lge", "msu", "pco", "kwh", "rph", "noa", "eoc", "fau", "uad", "asj", "sgu", "aby", "fgo", "enk", "htn", "rpu", "bai", "xic", "rtc", "hut", "mah", "eey", "ssy", "ckm", "rsn", "idb", "yim", "bye", "lfe", "oim", "voc", "sfl", "oml", "kli", "leu", "acq", "hid", "bag", "swr", "uno", "mab", "byl", "uve", "fei", "yga", "uee", "yve", "hwo", "xas", "hlo", "msc", "jew", "mix", "nyb", "ppy", "iki", "idf", "orj", "uys", "uei", "veu", "ckc", "mfr", "wnw", "pab", "adj", "rpi", "hba", "teu", "ubt", "gie", "yyo", "ckp", "owf", "ypu", "lka", "amc", "nir", "iaw", "wsh", "wol", "otd", "fwo", "kag", "ixe", "lms", "nkn", "ryg", "uke", "tbi", "eao", "lsb", "uba", "yee", "odf", "ayd", "byw", "xes", "ayr", "iph", "mia", "psh", "agl", "khe", "gga", "bew", "gee", "nod", "aas", "laf", "ogu", "urk", "gpl", "zes", "edk", "doy", "stv", "ifh", "ffl", "odw", "fix", "rdm", "ldu", "wot", "hgr", "tpm", "meu", "oum", "raa", "yju", "hfr", "myf", "ewl", "gya", "fsi", "oab", "sni", "xth", "hbu", "wnb", "ubj", "idm", "nid", "wca", "usr", "bom", "oaf", "oev", "xed", "myt", "obj", "hsp", "urw", "woy", "kre", "nbi", "ulf", "hpe", "gev", "jum", "uot", "emc", "htc", "eyg", "tpi", "umn", "shw", "rmt", "tve", "epp", "tsy", "rdh", "nsn", "egy", "tdu", "zet", "etl", "gim", "kyo", "fbo", "sva", "fsp", "idc", "rsy", "iea", "eow", "jim", "byo", "gfa", "mss", "yvi", "omd", "hho", "ubb", "olk", "nur", "yce", "tva", "afl", "bid", "dce", "pma", "tav", "wow", "ysf", "iba", "rox", "ogs", "oou", "hsu", "hyd", "zar", "omn", "odg", "ykn", "omr", "fbu", "rsg", "fex", "ufa", "cku", "nil", "tyd", "hya", "caa", "pbe", "lra", "dob", "zea", "lcl", "uwa", "joe", "ghp", "wet", "aza", "buc", "yop", "amh", "wnp", "bob", "lri", "ako", "hak", "hob", "ipm", "owp", "eeu", "hex", "hfi", "auc", "wop", "nyd", "dke", "fsc", "fag", "lbr", "ilh", "rak", "wwe", "ewf", "sks", "eeb", "pad", "max", "psw", "izi", "ksf", "gop", "rnc", "dgu", "psy", "uip", "egg", "tgi", "oqu", "ntv", "deu", "raq", "axe", "kra", "maa", "iin", "fgr", "dhu", "npi", "exh", "osl", "cac", "rju", "fbr", "ipw", "adg", "eaa", "ieg", "ivo", "mli", "itz", "chy", "osw", "rkc", "eyn", "xac", "cav", "kni", "yjo", "osm", "wag", "mde", "myc", "rvo", "ydu", "etn", "izo", "esv", "ewd", "nbl", "mne", "llk", "wsi", "gaw", "syn", "wnc", "yov", "kef", "tfl", "mwe", "gob", "iwi", "shl", "tuc", "ctf", "ssd", "gmi", "ttu", "eic", "nns", "shf", "dmy", "hyt", "mut", "tgu", "msf", "hpl", "uph", "rfl", "mda", "hif", "nsk", "aze", "wde", "dni", "fdo", "kbe", "idr", "lcr", "imw", "mmy", "rbl", "nkl", "msp", "ikn", "cya", "gru", "keb", "ckd", "nuf", "ovo", "wfo", "tmy", "elh", "wav", "odc", "svo", "xch", "lsm", "cso", "ilb", "kev", "dtu", "byg", "emm", "mum", "tcu", "iis", "htm", "ojo", "rtp", "wse", "gda", "oem", "poe", "mev", "uco", "shb", "tib", "dyw", "tbl", "byn", "gow", "aat", "kse", "gby", "nyf", "atv", "ouv", "iah", "rtg", "bbi", "coi", "olb", "upb", "nyr", "vou", "faf", "fue", "thk", "zan", "okl", "nyh", "ogl", "utg", "ryn", "bsa", "awt", "woc", "taa", "nhu", "ueb", "ouk", "lyk", "kss", "cpr", "csc", "gex", "mle", "ctc", "ggo", "oav", "rdd", "kho", "bvi", "idp", "syc", "hov", "rkn", "sak", "odb", "coh", "anv", "fda", "rud", "ebt", "eko", "upd", "stj", "atj", "aor", "wnh", "chg", "ilr", "wwi", "aal", "lcu", "irn", "jes", "hna", "mey", "pwa", "stk", "amf", "obt", "ytw", "dci", "ilv", "ksc", "ybi", "rja", "obv", "shp", "eeg", "uda", "daa", "keu", "unb", "aja", "fvi", "eos", "upc", "yki", "gif", "oze", "oym", "uew", "olc", "lpu", "csi", "wdo", "wod", "nsg", "lpt", "ilu", "oet", "kir", "lua", "exu", "rkf", "fev", "etd", "ksb", "lod", "lce", "ckr", "pia", "igs", "ckg", "thj", "yru", "tke", "dph", "ubi", "nak", "ucl", "maz", "ubm", "tci", "tiw", "elr", "ghc", "yaw", "gcl", "maf", "awk", "soe", "cob", "elg", "wsc", "oog", "hay", "tyg", "ugs", "cry", "wli", "gta", "lfu", "oir", "odp", "iap", "hyp", "nip", "lps", "byj", "wmo", "icg", "ulp", "rkh", "imf", "oak", "rub", "saa", "fmy", "xtt", "fbi", "lna", "hbr", "usn", "esj", "wir", "fna", "gsf", "uef", "nuc", "cch", "slu", "rsk", "emf", "unw", "kov", "wsw", "wim", "ygi", "olm", "ubu", "tsk", "nry", "itg", "bta", "hqu", "hdr", "oel", "unr", "sja", "sud", "mho", "kwe", "bie", "lgi", "mla", "unp", "fge", "oju", "ltw", "ifu", "riu", "dyn", "ipr", "yfu", "uec", "nje", "esq", "bby", "hah", "imn", "kim", "oag", "thv", "oob", "dsr", "wly", "ksl", "xer", "olw", "roe", "cse", "weg", "ctm", "lsl", "lmu", "pef", "dry", "rnh", "kfr", "ulu", "oty", "cue", "ssn", "wnl", "fga", "ifs", "khi", "smy", "hgo", "ilf", "kgr", "dum", "iju", "lsy", "myb", "ilc", "maw", "myh", "hfa", "pup", "wsu", "oov", "fpl", "gau", "kri", "dib", "ceg", "mwo", "dip", "ghf", "yah", "gib", "bak", "olp", "tuf", "ika", "rtd", "wak", "hog", "nyl", "ioc", "nkw", "iru", "ghm", "syl", "hru", "myw", "efs", "wup", "aml", "ybl", "nph", "iad", "loi", "kam", "hye", "jef", "iao", "xua", "gss", "ntj", "lkn", "dsd", "pda", "fcr", "kbu", "ioa", "gbr", "cyo", "nui", "amn", "eeq", "rps", "rii", "cub", "kba", "bic", "sko", "tsj", "lyv", "yqu", "pfr", "ndq", "xci", "htp", "alj", "iii", "laa", "rnf", "pov", "ilk", "rao", "ags", "usg", "dyb", "imh", "inq", "mok", "bev", "mlo", "kdo", "omg", "mch", "ukn", "gay", "fmu", "wwa", "ycu", "ksp", "fju", "wab", "wem", "amr", "cma", "xhi", "awr", "kca", "lby", "wpr", "wmu", "iem", "fcl", "lsd", "tsv", "cyt", "yem", "pwh", "ouf", "wbe", "ifw", "dwr", "cde", "nay", "gum", "lfw", "tja", "fyi", "aju", "pak", "ieb", "lek", "rgh", "eog", "kro", "ixi", "dje", "gsb", "oyi", "ugo", "rnb", "myp", "sya", "hty", "vad", "dod", "iow", "ysd", "rmc", "yif", "asq", "mym", "ctb", "jen", "ekt", "msb", "mgo", "mdo", "sok", "mau", "shh", "lfl", "kpa", "akt", "pei", "bsc", "ysr", "psc", "fgh", "mdi", "tub", "nwr", "fox", "xcl", "enz", "uwi", "nkr", "umt", "dsn", "ilp", "tyn", "iho", "uyi", "rnw", "laz", "opy", "aer", "yja", "raj", "gye", "wme", "gsy", "wbu", "iof", "hez", "oja", "owu", "ayg", "odl", "amd", "noh", "ecy", "otn", "afg", "jai", "noe", "cdo", "iaf", "eyv", "dyh", "lju", "ekl", "nky", "gyp", "lci", "okp", "eze", "ypt", "yhu", "rnp", "idy", "ogg", "uru", "bbl", "msl", "ffw", "woa", "xto", "umw", "jas", "lil", "wra", "poc", "gcr", "hyi", "ebb", "hvi", "ceu", "tph", "usy", "nrs", "htu", "euk", "myl", "xty", "lsr", "xts", "cfo", "wob", "dnu", "caf", "dka", "myi", "ddy", "odh", "jet", "rnu", "pca", "nkh", "okf", "owy", "fpu", "ibb", "pyo", "nza", "dyc", "sog", "awy", "gsl", "www", "ryu", "nik", "rkb", "cyi", "wbo", "irk", "yow", "yfl", "mra", "niw", "cey", "pgr", "dyf", "dsy", "mye", "azz", "wnm", "diw", "mfi", "ghr", "roh", "pss", "ghd", "hga", "hcl", "dub", "hbi", "eip", "dsk", "fot", "ftb", "lfc", "ghn", "sip", "onz", "nmc", "icn", "htd", "tvo", "eoi", "msm", "fhu", "oah", "xon", "wad", "nog", "kmo", "mna", "pew", "mif", "yup", "uou", "hul", "usk", "osb", "wep", "aku", "yav", "tul", "jin", "ffu", "otj", "pmo", "aac", "gnt", "doz", "mek", "wnr", "yke", "niu", "tnu", "yva", "gfu", "mrs", "hiv", "eiw", "gmu", "ysg", "yph", "gah", "geg", "anz", "iei", "dkn", "dds", "ixo", "yau", "akn", "lbi", "ccl", "rmw", "fye", "xof", "woh", "thq", "ipu", "rur", "gsm", "lej", "jea", "kad", "ctp", "upg", "jay", "imc", "uds", "mcl", "psp", "ayu", "gvi", "ygu", "bha", "uab", "oln", "yvo", "ulc", "snu", "kpr", "kai", "ldq", "igb", "rdn", "cev", "wla", "lru", "vev", "von", "kya", "amy", "uep", "unu", "bth", "zil", "bmi", "pip", "fja", "feo", "llv", "kpl", "buf", "wog", "syt", "hmu", "cui", "ghu", "mni", "icv", "ymb", "ftf", "mtr", "ssk", "ytu", "hfu", "ecc", "gfe", "fos", "myd", "oed", "gdr", "awf", "kia", "nyg", "yll", "cpa", "vig", "fjo", "wss", "lfs", "hfe", "etv", "sms", "emh", "kru", "lug", "cdi", "hcr", "jar", "cwa", "izz", "odm", "gce", "unh", "eez", "irv", "shn", "gbi", "deq", "psf", "hua", "kun", "rkm", "agh", "pep", "lyy", "pbu", "phr", "ysn", "kay", "img", "rje", "egs", "ahm", "ksu", "iwh", "hik", "mro", "duk", "myr", "ulm", "tze", "ewu", "awl", "xit", "rdg", "ewg", "opf", "oaw", "bik", "yci", "wlo", "ewj", "zab", "iog", "ksm", "cys", "ueh", "gpi", "olh", "tih", "kur", "shy", "hok", "wpo", "ieu", "igt", "emn", "oby", "nek", "klo", "ywr", "rnd", "isq", "ulg", "kaw", "psu", "kpo", "ysy", "fia", "gyi", "wba", "lbl", "pfi", "skt", "uie", "byu", "oyt", "sje", "nix", "gnu", "emr", "ohu", "lyj", "csp", "kos", "rez", "ryv", "fdr", "opc", "csh", "ljo", "wsf", "jok", "bof", "wdi", "onq", "bba", "kob", "rkp", "ulb", "hfl", "rkl", "wac", "okh", "pod", "gtw", "iry", "mby", "ooc", "lko", "iwe", "dak", "rwr", "akh", "fce", "uzz", "uwo", "liq", "mbs", "uya", "ldy", "rkr", "lkt", "psb", "rdy", "emd", "ylv", "bib", "eee", "kap", "xti", "gju", "ipb", "ugl", "gpu", "miz", "keg", "doh", "umu", "aes", "xfo", "dlu", "erq", "faw", "odn", "gnm", "hyw", "lax", "hby", "mte", "kac", "ifn", "nyn", "cpo", "oku", "owg", "pru", "twr", "neq", "kwo", "aic", "tvs", "kfa", "nao", "rcy", "nsv", "csw", "phs", "fim", "ixm", "paw", "kme", "wfr", "vag", "gyt", "gom", "osn", "iop", "eod", "sek", "wnd", "lqu", "hup", "msd", "ffb", "kna", "ksd", "ieh", "bco", "bry", "fah", "oau", "fop", "oow", "egm", "ifl", "iko", "dgl", "ffh", "ryy", "kde", "pam", "vej", "fki", "ubo", "hge", "uka", "ltd", "rgl", "eza", "gym", "otk", "lup", "nze", "omj", "wda", "upm", "azo", "shd", "css", "gjo", "syr", "oyd", "kaf", "uas", "igm", "nkf", "wpa", "awm", "umc", "eyu", "moi", "ngq", "ihe", "wam", "eyk", "yai", "pby", "aad", "aii", "gqu", "zeo", "wap", "cgr", "ezo", "hjo", "yid", "hju", "etg", "oue", "lgu", "trs", "cwi", "ctd", "imd", "ptf", "llj", "mta", "iya", "fbl", "mju", "uem", "tej", "wwo", "xha", "oxe", "bap", "egn", "axp", "kci", "kfi", "toq", "naz", "lvo", "kbo", "rmf", "ggs", "tka", "pde", "rml", "exo", "lnu", "utk", "wek", "haz", "ayy", "ptr", "ssg", "kti", "fva", "ffm", "msr", "gry", "dyp", "lux", "pga", "mfa", "ccr", "xco", "fff", "kby", "dsg", "abd", "yob", "byk", "uln", "adq", "oei", "ibo", "hao", "bma", "iml", "gbl", "rsv", "uor", "feu", "kch", "dyl", "fty", "bbo", "ltf", "bca", "bau", "alq", "unm", "pum", "ayj", "eoa", "tey", "cyb", "sox", "eml", "soy", "eia", "wmi", "ekw", "ltb", "epm", "boi", "osf", "myg", "xtu", "oer", "hko", "ulk", "zza", "nkb", "stq", "fci", "ipc", "mgr", "dym", "uki", "lfb", "uye", "kot", "bek", "htg", "wef", "tje", "wfa", "hmy", "pav", "akf", "mfe", "rbs", "yie", "hsw", "fpi", "ftc", "mup", "lja", "ync", "opw", "nlu", "axa", "osy", "iji", "utj", "bto", "cme", "okw", "hyb", "byv", "rmb", "fve", "ezi", "cwh", "ewz", "yoc", "jua", "gmy", "wsm", "uwe", "ysk", "imr", "caw", "goc", "mcg", "fug", "abc", "sut", "kyl", "jaz", "wze", "csu", "cyw", "sgl", "hsl", "gko", "fcu", "lsn", "fyt", "fph", "lui", "ahs", "lry", "zzl", "bah", "okc", "nyy", "rsj", "xmo", "ulw", "cej", "lhu", "haa", "kip", "aum", "wpe", "cbo", "aje", "lsk", "tug", "okm", "aia", "coe", "ptw", "cun", "nez", "ilg", "dvd", "mri", "rnr", "ftu", "hki", "ugi", "cmo", "pyt", "smc", "cyr", "ehy", "ynd", "zei", "saj", "nbc", "cne", "wch", "wje", "nae", "siw", "gve", "geu", "iia", "ldv", "xtd", "cba", "rhy", "rlu", "gdu", "ixa", "tox", "cyp", "skm", "eul", "ufo", "epc", "tao", "wte", "cwo", "bbc", "ndz", "akl", "hva", "ddh", "omv", "amg", "hud", "hub", "mpb", "mud", "hpi", "gsd", "ptc", "ciz", "psm", "azy", "ioi", "zle", "idj", "umf", "shg", "vek", "ggu", "liu", "xtm", "rmp", "zel", "rmr", "dyr", "pty", "skf", "nii", "xcu", "vul", "gwr", "mve", "goh", "lfh", "mge", "ipf", "pmt", "ldj", "cbe", "elk", "huc", "rkd", "mej", "peg", "gey", "eom", "oxf", "mim", "ofq", "aaf", "syd", "wig", "rir", "ixs", "pik", "kta", "hsm", "fef", "dih", "nib", "ksr", "nok", "nej", "mcd", "dty", "fdu", "hpu", "hve", "iae", "eyj", "ewn", "gcu", "iom", "iln", "chj", "wsb", "kol", "opb", "zie", "naj", "lfd", "woe", "ynt", "uez", "chk", "cbu", "igl", "ekh", "pps", "kpe", "dyd", "nih", "lir", "luk", "lpf", "gys", "cmi", "fje", "edq", "itj", "ryj", "iit", "woi", "yak", "fqu", "gut", "igp", "lff", "wks", "wnu", "oxa", "bwa", "ffc", "wsk", "ekr", "kus", "fgu", "vre", "uiv", "hnm", "vik", "osk", "xre", "pyr", "pba", "iep", "upu", "nzi", "okb", "cfi", "mog", "lsg", "cly", "aos", "fke", "moh", "wfi", "hja", "omk", "axo", "zha", "ktr", "ltc", "kda", "rgs", "mao", "ouo", "pya", "kgo", "tyu", "aub", "fka", "kys", "kaa", "smt", "mcr", "xtw", "tek", "hbl", "cvi", "rnl", "pne", "feh", "aap", "cfa", "lao", "nkm", "ioo", "fak", "eih", "gid", "ltl", "zal", "aen", "dmc", "aea", "nyu", "fya", "mop", "tiq", "oyc", "ija", "xtf", "pig", "acs", "pdo", "gki", "pch", "kah", "ieo", "dey", "rmh", "aiw", "ooh", "cim", "mav", "chv", "riw", "tlu", "bug", "nuo", "osd", "gsr", "hyh", "mti", "oai", "dox", "tmc", "hym", "ylu", "vab", "fsw", "olr", "dae", "eln", "cpl", "sej", "eiz", "gaa", "cna", "ksg", "apy", "gfl", "zec", "eij", "eud", "aqi", "ghg", "bdu", "orq", "ueg", "zis", "yef", "roz", "yol", "akr", "wbr", "glu", "ryk", "kdi", "uak", "paf", "yei", "gci", "ifr", "aww", "voy", "mce", "cek", "erz", "ldk", "bog", "ttp", "olg", "arj", "vam", "bsw", "ydn", "zoo", "pmi", "fsm", "zac", "gig", "nji", "dyg", "myn", "yos", "uyt", "ubw", "hss", "cyl", "ubc", "hdu", "ecs", "kbr", "wtr", "osq", "osr", "exs", "smr", "xta", "agm", "mga", "ynn", "lni", "rix", "fib", "wie", "bcs", "ehr", "tyy", "fni", "ymc", "nkc", "gnw", "wng", "kmi", "aji", "tcy", "wau", "pki", "fay", "gyc", "gva", "iau", "tgl", "oec", "cym", "akw", "wsr", "irj", "ulr", "miu", "axc", "shv", "ddt", "ekm", "awb", "oky", "uof", "msn", "leq", "usv", "igc", "epb", "egh", "rku", "ftp", "hsb", "dmr", "oyl", "gnc", "nox", "jak", "hcu", "oif", "rlf", "fvo", "ctn", "lmc", "eay", "csf", "aab", "hke", "lul", "mdu", "nul", "hci", "pno", "mug", "epw", "dao", "oxy", "dez", "psl", "wun", "cak", "xil", "pem", "kiw", "yka", "wex", "uev", "cah", "oef", "anx", "epf", "oza", "cua", "lfp", "kow", "uwh", "arq", "vau", "ubr", "tsq", "auk", "mae", "ahl", "otv", "bsh", "nzo", "utv", "sih", "lol", "wsl", "ffy", "mck", "fov", "peb", "waf", "gog", "aam", "bub", "yje", "mpm", "kul", "wfu", "ulh", "boe", "arz", "kdr", "noy", "ecd", "siu", "lmt", "ugb", "wgo", "eik", "ooo", "fum", "tyv", "hhu", "aed", "ymy", "ynu", "tui", "suk", "aik", "eae", "tww", "vow", "ezs", "csb", "baa", "kif", "oyf", "tii", "cda", "psd", "ovs", "uon", "inz", "xwi", "mci", "iob", "opd", "dek", "xca", "diz", "ekb", "vok", "fsy", "anq", "rnn", "ihi", "nsj", "sku", "wov", "exw", "jav", "oxs", "hyl", "moa", "igd", "xem", "lih", "hnn", "gvo", "ooa", "joa", "cpe", "gph", "cao", "eib", "gnp", "dej", "yil", "mvi", "hyc", "oyw", "nsq", "epd", "ucr", "umh", "zew", "wnn", "ahn", "ibs", "axr", "ikh", "aaa", "ahr", "rmm", "cga", "kte", "taj", "cfr", "gnf", "psr", "teq", "lwr", "hyn", "rmd", "cno", "ssq", "gyw", "foi", "liw", "ckj", "bss", "gja", "ukr", "nxi", "ixw", "zem", "aux", "wpl", "aht", "cex", "bbs", "avr", "wgr", "itv", "xia", "yrs", "gsk", "lmy", "kii", "ltm", "kfu", "rky", "rdq", "xie", "dgm", "pwo", "hry", "rtv", "yeo", "tik", "cyf", "mja", "nhl", "nku", "ooi", "ixy", "abh", "akd", "eku", "nkp", "ttt", "osg", "ffp", "fgl", "ahw", "fsl", "ifp", "ttc", "apm", "pdi", "pfu", "hph", "efc", "gae", "eoh", "eii", "kex", "elj", "gsn", "xat", "hgu", "lyz", "tiu", "xye", "dji", "bte", "etz", "drs", "zas", "rrs", "kop", "ksn", "aag", "ubd", "xpi", "cbs", "tza", "zim", "upy", "fep", "lmw", "gsg", "umd", "daj", "fup", "zsa", "ftm", "bfo", "rih", "epy", "ixp", "igf", "yze", "xma", "ouj", "pwe", "bwi", "lfm", "wip", "eoo", "pms", "bts", "tae", "jia", "ftl", "pbo", "kcl", "mly", "peh", "sik", "rza", "smw", "ayv", "rij", "wcl", "msg", "udl", "ufi", "alz", "wki", "cnn", "pyw", "ewv", "kom", "dzo", "umr", "aiv", "hvo", "skr", "obw", "rtz", "owj", "fob", "zzi", "uxu", "giu", "zam", "pev", "uai", "kyt", "yaa", "sao", "fby", "atz", "mjo", "idk", "cwe", "rdj", "sps", "oeu", "iak", "loh", "yec", "sii", "ooe", "hgi", "bdi", "mdr", "uyo", "pom", "cae", "xid", "coy", "zor", "lpm", "buz", "hsf", "uju", "uyw", "sbn", "fgi", "gyf", "nyk", "mue", "owk", "atq", "iun", "rng", "bej", "eji", "exm", "hii", "hka", "ghy", "eug", "adk", "ifm", "okr", "lii", "euc", "ifc", "xib", "aup", "mki", "aem", "obc", "aue", "mow", "dyk", "nyv", "kau", "aex", "sax", "oxo", "xur", "bwe", "rpm", "mcn", "wej", "jag", "jab", "mru", "rze", "tmr", "awc", "upn", "giz", "ofz", "dko", "feg", "enq", "mfu", "abw", "xio", "ssv", "spy", "gtu", "kum", "wti", "kke", "igw", "etj", "uml", "cze", "yya", "shk", "aeo", "xwe", "ioh", "pcl", "vib", "uac", "vaa", "acd", "ttm", "ubh", "ntq", "cyh", "zak", "cgo", "ekc", "ipg", "hnc", "hms", "lez", "axt", "kvi", "nnw", "smd", "kpi", "ffd", "btt", "xst", "lmm", "rtj", "evs", "ctg", "kej", "gao", "ebc", "yir", "kmu", "rkg", "ttb", "apb", "boc", "pfa", "ekf", "ixc", "saq", "mpf", "wta", "eaj", "ubp", "bho", "lae", "dpm", "lyq", "baf", "wsd", "yiw", "mrb", "wah", "wls", "oeb", "wok", "duo", "cbr", "hnb", "ffg", "ahy", "hyf", "kyw", "kaz", "kki", "xtb", "lkw", "ezw", "daq", "rlw", "dug", "imj", "tyj", "dik", "pyi", "rpt", "csm", "wjo", "uhe", "xwa", "mcm", "udr", "pbr", "fnu", "oia", "mns", "bwh", "eie", "efb", "kok", "cty", "itk", "ymn", "hje", "ufe", "mtu", "lpp", "syi", "cyn", "ptl", "nux", "rdv", "dud", "luf", "mrm", "vyw", "hnu", "paa", "eej", "eio", "ctv", "exf", "awp", "kka", "loe", "msy", "hnw", "uji", "avs", "hiw", "zai", "cig", "mio", "pue", "oxt", "rct", "uko", "agt", "xbo", "apc", "hnh", "wus", "ggy", "mpw", "rlt", "vak", "srs", "ckv", "pah", "emg", "ilj", "tko", "bde", "iov", "vap", "iks", "pey", "waw", "ugt", "ncs", "zwa", "odj", "nnc", "sae", "afs", "kek", "xra", "bsp", "udt", "zio", "rgw", "uva", "awd", "hih", "cic", "wfe", "csl", "vii", "ptb", "ekd", "nkd", "vya", "csd", "ckk", "cfe", "aky", "xor", "spn", "ngz", "euv", "dii", "udb", "ruf", "fwr", "oig", "nnb", "epg", "uia", "btr", "bsu", "byy", "wii", "oxc", "puc", "ygl", "pgo", "usj", "aev", "tzi", "cyd", "eok", "rdk", "bpr", "ayk", "cay", "ezu", "aip", "skh", "ueu", "wke", "gyb", "apw", "ucu", "kyr", "ttf", "ftd", "pez", "hsy", "syw", "ltp", "xwh", "aet", "mhu", "dix", "zef", "aou", "nnh", "bsf", "yog", "jol", "xse", "ipd", "dsv", "cfl", "tzs", "cpu", "geq", "tyk", "iex", "opk", "smf", "aol", "jad", "phd", "iee", "bpa", "mva", "hyr", "vst", "bti", "dps", "aif", "mfl", "gej", "bbr", "ikk", "yty", "dok", "etk", "oxw", "ysv", "dhy", "dsq", "vsh", "vsk", "ghv", "skw", "edz", "yuk", "aeu", "lmf", "axb", "zaa", "icj", "wdr", "akb", "ogh", "cdr", "ntz", "rji", "pex", "auf", "hoy", "kcr", "urj", "nug", "evr", "lmb", "bsb", "scs", "iav", "lix", "cox", "oyh", "nkg", "kav", "ozo", "hiz", "ahp", "wik", "kyi", "uvi", "ixf", "ltz", "ecb", "evy", "opg", "kga", "piz", "nnf", "uoi", "exr", "jui", "zeb", "meq", "weo", "csr", "ehm", "owv", "nmr", "mtw", "wsn", "oiw", "pim", "vys", "unj", "yps", "ogt", "wbi", "aua", "amj", "exb", "udw", "vla", "kak", "uja", "ruz", "iiw", "smb", "efd", "xle", "aqa", "gnb", "ghj", "aop", "xme", "cye", "dyu", "lpb", "vos", "juv", "tll", "hue", "ssj", "drm", "psn", "okd", "htv", "unv", "oyb", "fiw", "kye", "zhe", "wds", "huf", "zma", "yom", "boh", "wge", "khu", "wsy", "azu", "obh", "vez", "mih", "cmu", "ekp", "aib", "fax", "bdo", "cge", "acm", "nnt", "rgt", "ppu", "vse", "axw", "ecp", "fow", "yua", "akp", "kfe", "fkn", "apf", "wiz", "efm", "gke", "suz", "ezh", "mcu", "fry", "idv", "xtp", "waa", "uay", "wcr", "haj", "lsq", "ysj", "ixd", "udh", "xel", "lok", "kjo", "evu", "lje", "bme", "zep", "vth", "oey", "muh", "iej", "yur", "mke", "vro", "fsk", "iek", "xtg", "kdu", "hnd", "zeh", "ahb", "gka", "eaq", "puz", "zur", "nnd", "ifb", "lpc", "ixh", "spm", "faa", "syf", "fio", "koo", "ebp", "tzo", "nuk", "fuc", "lkh", "zth", "gyr", "vsa", "lpw", "wga", "naq", "uks", "dzi", "yza", "aai", "jaw", "ouu", "msk", "xar", "csy", "bch", "biz", "rrh", "yok", "yay", "uza", "uom", "jal", "pmu", "mpc", "zia", "yew", "orz", "rny", "mrc", "iku", "egt", "iim", "btl", "ovt", "ewk", "yko", "abt", "wiv", "usq", "xen", "ogw", "oji", "lmd", "uxi", "wby", "amv", "uku", "fae", "scy", "kja", "pmf", "yep", "weu", "axs", "xtc", "npm", "fkm", "efw", "mez", "zho", "ucs", "drh", "myk", "qin", "qan", "jah", "foa", "kyb", "yeq", "ibm", "uqu", "lsv", "fey", "zzo", "dtv", "toz", "pfe", "cib", "uej", "byz", "dze", "koh", "mii", "ioe", "gek", "ymr", "bcr", "vyc", "mbt", "mqu", "wve", "efp", "miw", "gak", "yic", "uho", "luo", "wyn", "jug", "lqa", "hnt", "oeh", "mgu", "bno", "mgl", "ypm", "oew", "tkm", "bhi", "ahh", "amk", "fko", "wnv", "rnj", "bue", "dsj", "zip", "beq", "jee", "hsd", "gje", "phu", "izu", "aot", "myv", "iio", "xvi", "dts", "yug", "opn", "dnr", "wvi", "hlu", "mka", "pix", "pdr", "hmc", "dui", "gyd", "ulv", "pfl", "smm", "ysq", "acb", "cgu", "gnh", "rlb", "kib", "hnf", "oep", "pht", "bbu", "obd", "xde", "jit", "udu", "cds", "syb", "drb", "hnp", "pcr", "snr", "pmm", "ttd", "zwh", "akm", "rlh", "kpu", "cph", "zag", "fls", "psg", "ubf", "utz", "fsn", "rzo", "akk", "sze", "fog", "aau", "mvp", "cpi", "xbu", "kih", "ksy", "zee", "nyj", "cve", "ffn", "ixg", "pge", "ohy", "apd", "sji", "afc", "nud", "zig", "zad", "acp", "daz", "kut", "tuo", "xcr", "aoi", "aav", "akc", "wru", "yns", "koc", "lfg", "mgi", "eue", "hsr", "smp", "hwr", "yia", "ugm", "bct", "lpy", "cni", "oxb", "baw", "agw", "kfl", "ruk", "ymm", "gps", "aio", "okg", "ahc", "bhe", "oyn", "hui", "gkn", "xne", "koa", "ptp", "fmr", "ciu", "bsd", "kju", "iic", "zli", "xyg", "rtk", "duf", "rpc", "drd", "bip", "ttg", "zap", "ozi", "ukh", "pdu", "gdp", "iby", "sfy", "fyf", "pke", "lmp", "gnd", "rmg", "joc", "uiz", "tvc", "pqu", "odv", "hyg", "myu", "arx", "qwh", "eox", "otq", "ugr", "ghq", "jil", "mmc", "xsa", "kyp", "hnl", "vco", "pmw", "dza", "kva", "foe", "wpi", "nhy", "hkn", "ixr", "dkr", "ixb", "soj", "veq", "sny", "fcc", "gyh", "ptm", "peu", "myj", "kbl", "xho", "mpp", "xga", "aov", "riy", "koi", "wbl", "smh", "obm", "lkl", "gnl", "sza", "wkn", "eaz", "hsn", "huk", "kve", "auo", "yig", "moz", "ryq", "qis", "kod", "lbs", "dcy", "nps", "ogb", "ktw", "cgi", "mrp", "ohl", "emv", "ijo", "xal", "taq", "kmy", "zze", "mtv", "noj", "htj", "onx", "wce", "mrh", "egw", "yeb", "vwa", "ddw", "zto", "kym", "kio", "aaw", "syp", "ecw", "zaw", "tds", "kyh", "iwr", "pci", "mib", "lkr", "pcs", "bne", "rgm", "aoc", "whu", "ksv", "xli", "axy", "yut", "lmr", "imk", "wfl", "fss", "rcs", "lsj", "uus", "hnr", "uum", "lgl", "wqu", "hij", "giw", "egb", "fmc", "kyc", "iyo", "agp", "uby", "klu", "yeu", "bna", "moe", "pog", "lmh", "uow", "bpo", "zue", "urq", "hoj", "sdy", "axl", "rgc", "iaz", "jel", "uex", "vyi", "cbc", "imv", "pys", "kje", "yao", "nub", "exl", "laq", "llq", "ezt", "cby", "umg", "dku", "zom", "rnv", "bop", "lcy", "ltg", "ksk", "tji", "imy", "rmn", "eky", "xot", "kmm", "zum", "haq", "ifd", "ocs", "kua", "mms", "uov", "ivy", "uhi", "lkm", "jra", "htk", "laj", "ltv", "kmh", "rax", "fsd", "uam", "kbi", "kik", "yih", "gmc", "ezb", "snd", "uny", "bwo", "yey", "cbi", "mkn", "pbi", "pcu", "shj", "xfi", "nrb", "oeg", "gnr", "yrd", "gyl", "ufr", "vaw", "zco", "kub", "uol", "mwr", "ctj", "aih", "obf", "jis", "kge", "vyt", "ocy", "ogd", "mip", "gaj", "cdu", "lkb", "pna", "eub", "bhu", "bsm", "xmi", "efj", "xag", "pye", "kyd", "mpd", "agd", "xus", "cva", "ooz", "yoa", "roq", "hsk", "hng", "vra", "yod", "aui", "ozz", "ohm", "zbe", "acw", "kgi", "zuk", "zah", "wey", "oaa", "pjo", "piv", "uxe", "xbr", "cfu", "odk", "zzy", "ceq", "pju", "hls", "gms", "ahd", "xbe", "vod", "egp", "abn", "pif", "kao", "pvi", "ucy", "tml", "gyu", "cuf", "buk", "oxh", "ecf", "axd", "moy", "bcn", "mnu", "tms", "nfc", "fih", "tzw", "ecm", "aec", "eax", "asz", "ftg", "drc", "ogm", "bae", "wny", "ukt", "tuk", "eua", "rkk", "guo", "ekk", "kms", "wju", "wva", "suv", "axm", "ebm", "aeg", "osv", "ugc", "bce", "pek", "ttv", "tzg", "aie", "nzy", "udc", "bsl", "auw", "aow", "fps", "wpu", "sgt", "ndx", "ehn", "knu", "ccs", "agb", "isz", "vah", "hnk", "nnm", "emk", "ecz", "rxi", "pph", "kkn", "ibn", "phw", "wya", "pao", "feq", "poa", "wkw", "ogc", "lkc", "csn", "nck", "aqw", "xwo", "pud", "tct", "rzi", "psk", "ohs", "ncc", "btw", "zwi", "ftn", "hgl", "fsf", "iih", "kqu", "bda", "ogf", "xso", "aoa", "yds", "ktu", "cjo", "jed", "pmc", "pmy", "ltn", "kcu", "oxn", "wsg", "bok", "jib", "ehl", "bsr", "cok", "wnj", "iaj", "vto", "dms", "skb", "lkf", "ngx", "phl", "aoh", "spc", "wgu", "aef", "spt", "rgb", "tez", "muk", "faj", "utq", "fsb", "xdi", "rkj", "exd", "rkv", "mrr", "esz", "nrh", "kce", "zge", "oay", "fhy", "wci", "mpg", "lza", "ihu", "tij", "ifg", "kyf", "xav", "yms", "ccc", "wiw", "irq", "rgp", "lky", "zhi", "okk", "ncb", "ikm", "mrd", "wmy", "bav", "zst", "yum", "xsp", "rpg", "mje", "gok", "wcu", "ugd", "wja", "noq", "inx", "oih", "suh", "bcc", "szo", "uze", "doj", "cud", "ncw", "gyn", "zca", "xii", "dcc", "sbc", "bao", "icz", "iid", "tvt", "ytv", "iye", "mrg", "msv", "vyr", "bgr", "rnk", "ehs", "cyg", "ekg", "eht", "ebh", "xfr", "vip", "bci", "umv", "aak", "kud", "axf", "mpy", "xdo", "tpw", "slt", "uim", "ogp", "skl", "bmo", "egf", "jev", "hji", "iib", "mmm", "oyu", "rfs", "bif", "xba", "lns", "goj", "tmp", "hyu", "hmr", "ddc", "jat", "wax", "uig", "ddm", "yoh", "yaj", "ttn", "khs", "pyf", "iox", "lzo", "spp", "dcs", "efh", "ikt", "upk", "mpk", "cuu", "uyb", "srh", "mrt", "xsh", "acf", "obp", "svs", "aqs", "vds", "miy", "nnp", "aij", "oyp", "mlb", "cuo", "lpd", "aiz", "dtd", "soq", "cdc", "vsc", "lij", "wdu", "rgf", "jeo", "agy", "bmw", "euf", "vyd", "mvo", "ovw", "xro", "uxo", "ofx", "uap", "ezz", "uaw", "yiv", "zya", "xfa", "rbt", "vha", "hrs", "cvo", "uod", "ezc", "mrk", "kko", "zre", "jub", "tku", "ghk", "exg", "mrw", "uyh", "nnr", "yeg", "zym", "pry", "uxa", "dkm", "ugp", "upj", "rgn", "csg", "uzu", "kae", "pyc", "chq", "scb", "tps", "vym", "aah", "ugw", "vpr", "vli", "hsg", "ksj", "scc", "egc", "zof", "vpa", "flc", "ftv", "kmc", "exy", "rbc", "yly", "cbl", "ipn", "lpg", "awg", "aei", "aob", "oux", "ptd", "kiv", "qae", "oeq", "gsq", "iif", "vyl", "uft", "zhu", "pug", "aok", "baz", "mcs", "pce", "yoi", "fld", "zbo", "bfr", "mcf", "eui", "goy", "mrl", "xsc", "nms", "loq", "tzh", "fuk", "bsn", "mnt", "pae", "ecn", "iip", "dij", "nzh", "yzi", "jig", "aom", "fsq", "ncd", "vch", "bcl", "apn", "yrn", "tcs", "vda", "avu", "noz", "xtl", "zol", "ohr", "rbh", "ozy", "acn", "njr", "oxl", "xda", "drj", "kaj", "ebn", "wia", "tvw", "dyj", "fcs", "vca", "piu", "pww", "lmg", "vwh", "uoa", "yji", "nmd", "ipy", "vyo", "kuw", "bim", "ppt", "bcw", "yip", "pgi", "ruh", "hiu", "gji", "vma", "nng", "frs", "oxp", "zir", "ahf", "ezr", "oyr", "hyy", "wlt", "lml", "vyb", "qwa", "uoy", "nyq", "zos", "rck", "phc", "kry", "drp", "wtw", "iir", "thz", "sxi", "bps", "baj", "eoe", "riq", "tvp", "sft", "tzk", "ixl", "koz", "rlc", "nax", "fsr", "uaa", "ujo", "eyy", "wgi", "zun", "snb", "ezd", "ebd", "ydw", "pmp", "pyl", "cnu", "epn", "oaq", "xla", "dkh", "fuj", "lku", "skp", "rgd", "agf", "wry", "oax", "ije", "xop", "btf", "pbl", "fys", "skc", "uah", "oaj", "dwy", "upv", "ouy", "iul", "bih", "npp", "fod", "ubg", "cza", "uey", "uun", "kgu", "dnd", "axh", "obg", "fej", "rll", "uyl", "rpp", "drr", "uop", "koe", "oxm", "wtu", "yng", "pyb", "vyf", "cuc", "vae", "ddv", "zde", "flt", "vri", "rcm", "vne", "faq", "sds", "pdf", "orx", "kmf", "fyw", "egd", "vog", "fcy", "mlu", "taz", "dhr", "zba", "mbh", "wvo", "gih", "rlm", "pyh", "auh", "auv", "itq", "pob", "zul", "tkr", "jih", "lhy", "oht", "lfy", "ykr", "drw", "fom", "zaf", "wnk", "jaf", "vsp", "kph", "lcd", "bpl", "woj", "uif", "sry", "obn", "drg", "scd", "evl", "caj", "gyg", "biw", "wsv", "ruv", "buo", "qur", "mbw", "suw", "zit", "gmr", "jod", "tzt", "dct", "syu", "ugf", "jir", "dgy", "uyf", "mrf", "mui", "vss", "ulj", "erx", "bcu", "ycy", "plc", "lkp", "myy", "skd", "bii", "zeg", "yls", "ukw", "msj", "mls", "dcb", "olj", "scm", "ebw", "gdy", "uaf", "uob", "oip", "cct", "dyv", "xfe", "zsc", "ffj", "apg", "oiv", "mua", "jaa", "lvd", "eux", "evw", "sbs", "csk", "adz", "xhe", "kvo", "pwr", "nnl", "ikr", "avv", "olz", "yeh", "vof", "xsu", "vaj", "ddb", "mko", "kmn", "nmp", "wph", "zbu", "elz", "uyc", "jha", "faz", "pja", "rcc", "btc", "opj", "abm", "sct", "ohw", "nhs", "sdw", "voo", "uzi", "sml", "nkj", "fku", "hmm", "pym", "zys", "zek", "avl", "ybc", "wlw", "uxt", "afp", "bez", "ovc", "gip", "jut", "ncn", "mcb", "jpm", "bni", "oii", "pbs", "ncp", "ctk", "gsv", "cja", "agc", "yhy", "srd", "vao", "vaf", "pej", "kwr", "ydb", "vue", "syh", "bfi", "fms", "vde", "lze", "yul", "drt", "srb", "osj", "npc", "phb", "ttk", "mcp", "udm", "fji", "lrs", "lfn", "viz", "vdi", "mbc", "tdw", "blv", "fyh", "ncm", "yaq", "ezm", "zra", "ezf", "exx", "bjo", "jup", "yku", "bex", "kig", "owq", "uvr", "awu", "cdp", "xpu", "pyd", "fok", "phm", "tmd", "oxv", "pii", "kuk", "vdr", "uym", "ynb", "oie", "mgm", "aep", "zte", "fij", "dax", "xab", "oxr", "icq", "luv", "tcc", "pgu", "pve", "gzh", "euw", "ruw", "php", "lkd", "kog", "trh", "hps", "lcs", "akg", "kuc", "mbb", "tvn", "osx", "hza", "upq", "rlp", "uyu", "wwf", "tcb", "tzp", "bfa", "wwr", "bpe", "wih", "sjr", "abf", "azt", "saz", "uoc", "yii", "zeu", "zfo", "udf", "pua", "xsi", "rmv", "ddn", "tcw", "spd", "zoi", "dbc", "skg", "ahg", "rhp", "gng", "xlo", "puf", "zwe", "mhz", "gub", "pyp", "luz", "wsj", "cii", "prs", "guc", "liy", "dky", "zpa", "scf", "vwi", "pni", "emj", "rfc", "ufc", "iey", "kyn", "pmd", "vom", "dcd", "nwy", "izh", "sgm", "jma", "sll", "biq", "vso", "isx", "uzh", "udp", "tvm", "ynm", "efn", "ynh", "dpc", "lzh", "ukc", "kiy", "tvr", "phn", "ahj", "aew", "iur", "cju", "okv", "vfo", "muf", "tzc", "tzm", "dpt", "yaz", "evc", "dmp", "tdy", "ikw", "pva", "zic", "nmt", "sgh", "pmj", "wws", "ymd", "ynw", "kmt", "rlr", "vex", "euo", "oyg", "snp", "izs", "wdw", "sld", "ptg", "snc", "cmp", "wka", "ixn", "xei", "vsi", "byq", "yzo", "sdc", "fze", "xex", "phk", "vyp", "hkm", "msq", "sgs", "yae", "rff", "zla", "cps", "xxx", "vyh", "gsj", "ezp", "pcc", "ppp", "gmt", "eiu", "nij", "huh", "tpc", "diy", "syg", "pvo", "ivs", "szi", "mmr", "evt", "kuh", "ufl", "khm", "ekj", "ebf", "acg", "qth", "yuc", "omq", "phh", "abp", "tyq", "yrh", "frh", "vvy", "tcm", "mts", "gty", "cwr", "ejr", "voa", "swu", "fmp", "fek", "iyu", "ehw", "dnc", "fuz", "scw", "tnd", "zmi", "wwc", "qia", "zda", "ddf", "ehd", "fiz", "mbp", "rpw", "scp", "dpp", "fyu", "ncf", "bve", "wlc", "wdt", "iay", "psv", "aiy", "ufu", "mrj", "oik", "muz", "hsq", "xet", "tcp", "iil", "phf", "spb", "svu", "aek", "drf", "fip", "flp", "duv", "oek", "efy", "nmm", "sfc", "nrd", "ipv", "edx", "ifj", "unq", "ddp", "niy", "yoo", "iig", "xya", "mbd", "tmt", "zwo", "ipk", "drk", "vpo", "ffk", "mmt", "ttj", "bcp", "ftk", "eix", "xun", "vsw", "ydy", "npt", "nbb", "uyn", "suo", "tdp", "rcb", "jog", "kgl", "kui", "zmo", "dmd", "xgo", "hiy", "vmo", "rrb", "bju", "azh", "rpd", "bua", "uzo", "jrw", "pmb", "ypn", "nvs", "afb", "ppm", "dcp", "vij", "azd", "tkh", "fza", "drl", "ovr", "miv", "jrs", "rpf", "zpr", "oeo", "ouz", "fkr", "waz", "uoh", "ikl", "exn", "lnc", "xad", "tiy", "tvb", "oib", "foh", "fud", "gts", "rbb", "kyu", "djs", "lbc", "usz", "iez", "rcd", "uek", "rft", "ubn", "iie", "ooy", "dld", "igy", "vdo", "coz", "uxs", "ppc", "gcy", "ewq", "aod", "evp", "kez", "zop", "qat", "ddj", "nkv", "gxi", "ahk", "qai", "wul", "ylt", "bax", "biu", "huy", "aqt", "maq", "ovp", "aeb", "oxd", "rjr", "dmm", "fmt", "eyq", "zyn", "ovd", "zyt", "yjr", "tgm", "ddd", "vim", "yry", "uvo", "bdr", "bcb", "ppw", "moj", "fao", "fcw", "boj", "nnn", "ovb", "hpm", "ugn", "tdb", "dcn", "nnj", "tcd", "afw", "epj", "xxi", "fkh", "bsg", "gnn", "vga", "bnp", "gud", "rvs", "jik", "stz", "sez", "rzy", "jst", "yny", "xno", "yrt", "joo", "zoa", "ajp", "rrd", "rpb", "hnj", "yib", "dny", "mft", "sfs", "azm", "xiv", "uav", "nzu", "umk", "zuc", "udn", "zlo", "vsm", "ehp", "opv", "hny", "zey", "xhu", "guj", "odz", "umy", "rrw", "xna", "dgh", "uyg", "nww", "keq", "ppg", "sls", "tzb", "vus", "gtv", "tfs", "lmv", "guz", "izm", "urz", "zsh", "efg", "jro", "rgg", "xsy", "kyg", "iok", "uzb", "rww", "dgw", "oao", "jax", "tzl", "zvo", "xap", "ovm", "gny", "sdn", "poh", "azl", "ubv", "foy", "zoe", "mrn", "omz", "ptn", "hrh", "paj", "kht", "rrt", "dcm", "xbi", "uoo", "lox", "pmn", "fii", "epk", "aiu", "hku", "zne", "piw", "ayz", "vye", "tvg", "ivu", "cms", "oio", "mnw", "wlg", "qas", "biv", "kmw", "jau", "sxa", "boz", "pmr", "idz", "mnc", "aay", "nll", "ciw", "ffv", "yio", "mry", "hmp", "btb", "kuo", "dtc", "gaq", "uhl", "esx", "sbp", "cmc", "evd", "duh", "czy", "smg", "hrm", "odq", "gzo", "vbe", "ocm", "ggw", "evm", "zao", "ouq", "xgr", "pct", "zki", "bmc", "ydh", "rlg", "nht", "zod", "tvu", "loz", "eqi", "mpn", "jwa", "ixu", "gii", "ukb", "mml", "ifk", "prc", "krs", "vsu", "trp", "wwt", "zqu", "uxb", "cyu", "lji", "flh", "dhs", "ayq", "hnv", "ozh", "jem", "paz", "xml", "lnw", "xxo", "bga", "bms", "bgo", "ukk", "sbb", "ekv", "vna", "pka", "bge", "tlt", "juk", "ghz", "wwm", "ocd", "rzh", "jov", "eoj", "dtt", "snf", "xod", "wgl", "nvu", "zse", "tvf", "sgy", "vle", "gmp", "vaz", "avn", "ajs", "qho", "dkl", "hcy", "unz", "tnt", "euh", "zdi", "puj", "bja", "ezl", "sqm", "ggh", "dls", "tbs", "pyg", "otz", "fcb", "ltj", "paq", "wao", "xby", "wur", "tpt", "sww", "ydc", "okj", "rbm", "hhy", "vlo", "tvd", "ajr", "tmm", "psj", "atx", "rrr", "dcw", "smn", "cgl", "fzi", "wdy", "bsy", "zsi", "rln", "rbp", "zko", "iiv", "dnb", "rcp", "tcf", "vvi", "luh", "lgh", "gku", "fct", "xru", "zot", "dzh", "izt", "bcd", "tls", "uyp", "ecg", "huo", "tsx", "zzs", "ivt", "woq", "zou", "pax", "buh", "hlt", "evf", "dll", "dns", "gwy", "khr", "aeh", "tdt", "tvl", "uwr", "kku", "pox", "tpp", "rbw", "uib", "ezv", "dbs", "tzr", "azs", "mox", "tbc", "ykm", "ukl", "cyy", "dcf", "pnc", "ccp", "hhh", "hrt", "buq", "spf", "jiw", "nlc", "nhd", "ruo", "yts", "qmi", "ydd", "pkn", "ccw", "dgs", "bpi", "luw", "tnc", "spw", "izw", "bcf", "pcm", "uyd", "pkw", "csv", "nkk", "apk", "zow", "kug", "uup", "uhu", "lmn", "sij", "kij", "sql", "mbf", "tdc", "uxw", "cpc", "vsb", "uae", "wlb", "yik", "hkh", "gmd", "xev", "srt", "nlt", "zzb", "ovh", "yub", "yld", "hpk", "dbh", "nfs", "hdt", "xqu", "ehb", "sdm", "tny", "acz", "wmc", "fdy", "epv", "cdt", "zni", "rcw", "tjr", "ypp", "ibh", "fgd", "bup", "mdc", "drn", "vmi", "jsa", "tlb", "tvh", "scn", "dpg", "ykh", "mty", "src", "ukp", "fyc", "lnd", "awv", "ryz", "nmb", "abk", "qar", "ovn", "yue", "jid", "tzu", "jot", "zyb", "tft", "awj", "nxa", "zev", "dmt", "bki", "hdd", "gza", "uzm", "tnb", "bns", "dlt", "ygh", "mnf", "pje", "aoz", "mct", "koy", "pns", "zyi", "evh", "zid", "yrg", "jii", "fyb", "flw", "rmj", "rsz", "nbh", "nuw", "ydm", "waj", "bsk", "xtn", "mnd", "jri", "vhs", "ksq", "sdv", "dfs", "zna", "ylc", "wlu", "bhp", "zzf", "ocw", "trm", "dfc", "fyp", "hsv", "cpm", "fcp", "nls", "gug", "zus", "crs", "ivr", "evg", "ibd", "obk", "spg", "vsf", "nvy", "rfw", "ynf", "zyo", "yyi", "ufm", "nml", "szt", "zri", "ydl", "jop", "ptv", "rmk", "zzw", "mmw", "jth", "hkr", "fsg", "smv", "sdh", "ovu", "eqa", "dxi", "xri", "nzs", "wty", "xfu", "flr", "grs", "pgs", "jow", "fik", "ddg", "lcc", "zog", "afn", "nlv", "ppf", "ebj", "bnt", "rfb", "vte", "hrb", "mds", "asx", "fzo", "zzt", "ymt", "srp", "kuz", "mku", "ipj", "dbb", "knr", "zyw", "zfe", "mbm", "ggp", "nsz", "amz", "dhd", "nhc", "muj", "uio", "xyo", "huw", "zsp", "oxg", "ohd", "gik", "zik", "kmr", "qwe", "pnu", "pcb", "ncz", "viw", "dzu", "izb", "ccd", "aoy", "nft", "hds", "zro", "hzo", "sbh", "zav", "sdp", "pml", "ggm", "uyr", "bcm", "hwy", "goz", "vwo", "djr", "ocb", "azr", "eiy", "zmu", "ymf", "tcn", "ukm", "hlc", "dhp", "oix", "wwb", "mmd", "eoz", "uiw", "tgh", "nld", "stx", "jja", "yyu", "tzf", "sxp", "hmt", "dyy", "xaf", "mza", "qco", "slr", "bbw", "vdc", "uvs", "ozu", "vni", "yud", "lpk", "vge", "tsz", "wyc", "ezg", "hrd", "aqb", "duw", "yuu", "dpw", "gmb", "enx", "rrc", "fcd", "ioj", "sdb", "dvs", "uhr", "trb", "ibc", "iut", "ovy", "mnb", "afm", "myq", "jie", "dmb", "tmb", "zme", "fmm", "ohc", "lzi", "qha", "ovl", "uky", "nfm", "crt", "avc", "wlx", "iuc", "jae", "sns", "aqc", "vbu", "tdm", "ohb", "xdr", "gbt", "syk", "kuy", "dft", "sdt", "ezn", "ckq", "ieq", "uxc", "jiv", "jeh", "xys", "ivp", "hyj", "exv", "vsd", "igv", "kml", "ftj", "akv", "jpa", "gpm", "bij", "thx", "tdh", "gze", "pyn", "cfs", "ynr", "ovg", "hlb", "fyd", "ziz", "yui", "zyg", "vta", "vno", "mcq", "irz", "cyv", "vsn", "dux", "tuw", "wwp", "trd", "ulz", "vfr", "ziw", "yvs", "vay", "zno", "ovf", "lfk", "ggt", "ixv", "tnf", "txi", "iud", "qub", "tlc", "nzl", "lgy", "vgu", "oae", "wcw", "nfk", "ifv", "mkh", "uhn", "twy", "pmh", "srw", "mji", "oej", "ctq", "rrm", "rcf", "slc", "umj", "bmu", "ygm", "mll", "hyk", "zzc", "bjp", "igj", "ozn", "uii", "yuw", "pzi", "xif", "lpn", "wdc", "rfm", "btu", "jre", "nrc", "hyv", "gjr", "dlb", "bke", "zso", "vsr", "npd", "hze", "hoq", "ydt", "flf", "xtv", "viu", "svp", "yvu", "fcn", "kty", "hdf", "ajm", "xea", "lbf", "idq", "ccf", "zfa", "osz", "jca", "ikb", "slb", "zch", "jic", "cyj", "syv", "vwe", "fym", "siq", "xsl", "diq", "puk", "hrl", "vav", "tld", "ohh", "mmp", "iup", "ipz", "gyz", "dnf", "oxx", "lng", "etq", "vhe", "jrt", "bfl", "dtb", "aao", "ecv", "ruj", "tky", "snl", "kuf", "zfi", "mcw", "cdm", "vun", "hld", "ibw", "soz", "uxd", "qyo", "tmw", "usx", "iaq", "hpc", "zzm", "cvs", "uxf", "aae", "elq", "rwy", "ruy", "rcn", "pdt", "oyk", "bpm", "zub", "txa", "ppd", "nwu", "aee", "zyc", "piq", "tbp", "vtr", "zfr", "hdy", "gcs", "aog", "jpu", "hdm", "xve", "vsl", "pcw", "rbf", "ynp", "ahv", "luj", "ukf", "hlw", "ydg", "vdp", "yks", "lrh", "ucf", "vih", "lnb", "koj", "hlp", "xou", "fll", "uik", "pcp", "nhr", "ltk", "kue", "vbr", "mhy", "tzd", "tuh", "ajj", "pui", "rpk", "bkh", "llz", "ykl", "btp", "yxi", "rht", "wwn", "ccb", "yck", "crc", "mij", "rlj", "dvu", "ovj", "pls", "nnk", "lfv", "rbn", "zov", "nbs", "wae", "mbn", "bfe", "fcf", "jco", "hox", "rdz", "ppb", "vyn", "dlc", "rxa", "nxm", "csq", "xva", "tng", "uok", "mmg", "jna", "exk", "ezy", "lnt", "ejs", "zdo", "tkl", "lfj", "zob", "lgb", "rrp", "evb", "kgb", "hpt", "dbp", "flb", "xgi", "hzi", "evj", "coj", "wrt", "gmm", "fcm", "yrr", "tmh", "ehc", "wsx", "nuu", "xki", "dff", "foz", "mkr", "lvs", "uxh", "ivc", "afd", "poz", "mmb", "rzu", "cez", "cje", "ihs", "gkr", "ajg", "xfl", "ohp", "zky", "hlh", "sbt", "nuh", "tux", "sbm", "phg", "fmb", "ntx", "cuy", "fua", "nnv", "dvr", "rbd", "cik", "ztr", "xyl", "hlg", "cdw", "lct", "oee", "weq", "tfc", "wbc", "rvl", "ctx", "lnh", "jge", "snh", "amq", "mmf", "hpp", "jda", "lbt", "ukg", "bbb", "yoy", "cmt", "gmw", "izc", "dxa", "vti", "ivw", "hpb", "pih", "shq", "efk", "wlf", "tns", "ysz", "vba", "prt", "ajd", "qif", "ooq", "wys", "ypc", "brc", "ibt", "zib", "hdc", "rpn", "btm", "nqi", "zii", "exq", "ccm", "gcc", "zyd", "vcr", "ejm", "dtm", "pmg", "jho", "ypd", "fyr", "csj", "fgm", "avp", "wll", "wyl", "dbm", "wlr", "tbh", "rvu", "bty", "xsm", "xmu", "nzw", "bbt", "chz", "afh", "peq", "glb", "fmw", "jao", "dht", "htq", "sng", "nxb", "abj", "nrt", "rhs", "igk", "pkr", "rqa", "yek", "nhb", "mhs", "vbo", "vjo", "jde", "npb", "xup", "ooj", "dpy", "qal", "bjr", "dtj", "qdo", "hlm", "slp", "zau", "zyk", "npy", "eqb", "qwi", "hdw", "aqh", "ptj", "uau", "hrc", "dng", "apj", "ocp", "psq", "kmd", "sws", "ktv", "ggc", "ikp", "sdf", "jrh", "suy", "uyy", "oyj", "pds", "rvy", "mmh", "nfb", "wdb", "swc", "qip", "vka", "mub", "zbr", "fhr", "zta", "sdl", "wut", "rwu", "grh", "qto", "qba", "hll", "bph", "ikc", "gkh", "xos", "yuh", "tnw", "wwd", "iuk", "rgv", "wwg", "sxv", "dww", "rnq", "ijk", "caz", "oaz", "ocf", "ejp", "sxs", "fbh", "aix", "ukd", "fbc", "vgo", "trn", "zgr", "loj", "oij", "wnq", "wlp", "pdp", "zyp", "lwy", "srm", "cyk", "xsw", "khz", "gij", "nlp", "iqa", "wrs", "mhm", "zay", "ycb", "evn", "azp", "lny", "jeb", "vob", "oyy", "sgp", "pgl", "htz", "kyk", "hsj", "iyi", "lkg", "hmd", "fxi", "puy", "djp", "hkl", "auz", "vyg", "cih", "kza", "guk", "gww", "mws", "ocn", "tix", "aqo", "igq", "avt", "sxm", "mnh", "frd", "acv", "avg", "zoh", "wsq", "vpe", "zga", "vho", "ynx", "crd", "vfi", "huj", "ebv", "iik", "zvi", "xyc", "uog", "azw", "dbt", "hgh", "jof", "xge", "ydp", "ymw", "zyh", "ucd", "szk", "nrw", "flg", "cml", "tmf", "rpy", "tbb", "fpm", "prp", "abg", "ijs", "drv", "xyt", "scg", "rrf", "szu", "cmd", "ejc", "iub", "jom", "vyu", "lbw", "dpd", "rfp", "duq", "skq", "twc", "sfm", "sdj", "alx", "uxl", "nqa", "zpi", "tuv", "gnv", "vsg", "jsi", "vop", "dpf", "grd", "ytt", "gbs", "zif", "skj", "sdd", "euz", "ruu", "dyq", "kkr", "iky", "fbs", "gtt", "trc", "hcc", "oxu", "opq", "nhw", "lnf", "pib", "czo", "vme", "rtq", "mpj", "avk", "nrp", "wlh", "tzv", "siy", "evv", "suu", "dlp", "jaj", "yzs", "brs", "yuz", "sbd", "wdh", "eoy", "tvv", "azn", "zgo", "bpu", "ebg", "oxj", "xbl", "gzi", "tdn", "iua", "zka", "lhp", "gyv", "gpp", "bva", "axn", "ggb", "gbp", "gbh", "zaz", "wcc", "dtp", "rfd", "mze", "zpo", "mtc", "nbn", "cuz", "uxp", "ivn", "swy", "ehh", "zae", "rcz", "zyl", "trt", "rbj", "plt", "crm", "mrv", "fdn", "lbh", "jto", "dml", "nlw", "jek", "frm", "nhp", "ylm", "wko", "gtc", "wij", "wwl", "nws", "azq", "nxs", "npg", "gmf", "ynl", "yky", "biy", "ajk", "kyv", "vpi", "uhs", "ijn", "ezk", "coq", "lnp", "fln", "xju", "vdt", "fpc", "qad", "sgd", "lcw", "njs", "exj", "cnb", "gqi", "axx", "bmp", "mdw", "gez", "ylb", "wtv", "apv", "oox", "nff", "uih", "dpb", "owz", "mdb", "fnb", "xdu", "mtp", "jfk", "bdy", "nyx", "iyy", "lkv", "qso", "cls", "pko", "wlm", "srf", "nbp", "brn", "cgw", "szc", "khw", "hjr", "pcg", "nxt", "jrg", "dgb", "dhm", "bka", "jpe", "zyf", "zuz", "nuv", "jwh", "yoj", "vpl", "mwc", "gwu", "xiw", "zoc", "zsu", "dfm", "jiu", "woz", "khy", "hcm", "ojr", "jrr", "jba", "fez", "ncg", "imq", "vdw", "zss", "qsa", "zly", "axg", "mnp", "ikf", "sqb", "ylp", "uoe", "xub", "tnh", "uzs", "fky", "zcl", "etx", "tfm", "ygy", "lbb", "jhe", "cfc", "fyl", "dtf", "aoo", "zej", "mcv", "ejt", "cdd", "sgw", "tpg", "hhs", "aaj", "nvl", "hmb", "ccy", "ssz", "buj", "mgs", "tpb", "jwi", "dgp", "ycs", "ebk", "ixk", "hcs", "tpd", "nzb", "izr", "dmv", "khl", "nlb", "vif", "uuk", "voe", "bnf", "skv", "zke", "nrm", "hfc", "aqf", "zpe", "vix", "ejd", "tyz", "tdf", "rnz", "grt", "vfa", "jeu", "fiu", "rux", "mcy", "hrw", "zjo", "wmd", "aez", "ydj", "fdh", "ajn", "bfu", "ylw", "qit", "mng", "rhm", "ozs", "cdb", "cbn", "wdf", "ajb", "wib", "lvy", "ueq", "lcm", "ljr", "clc", "xss", "hmw", "nhm", "nuy", "vps", "nwc", "efv", "afy", "szh", "gpc", "mzo", "kny", "mnm", "lcp", "jrb", "yml", "snm", "bgi", "mnl", "fww", "ckz", "auj", "ibf", "huv", "jrn", "vve", "aaz", "gmg", "nwt", "egk", "swt", "xir", "kiu", "lzb", "fdc", "cmy", "udv", "ajw", "xov", "lck", "zpl", "hwb", "rxs", "npf", "dgn", "wmr", "vja", "hdh", "ynj", "jfo", "muo", "qbs", "emq", "mzi", "ydf", "zdu", "vov", "pcf", "mnr", "jrc", "jka", "frb", "kyj", "cdf", "ajc", "avm", "gax", "tnm", "bnw", "jla", "dhc", "mld", "nrl", "jif", "lnm", "qic", "vyy", "swb", "ncv", "krz", "gmh", "fny", "avd", "scj", "gtd", "bmx", "ypy", "cbd", "mlt", "vyv", "axu", "zzp", "qig", "poy", "qma", "mny", "hlf", "yox", "jmo", "bsj", "vut", "hcb", "sgn", "tuy", "tgw", "mpv", "akj", "fpt", "lxx", "wvu", "mww", "mdy", "ybb", "xke", "dfb", "rzb", "ecj", "vva", "rhd", "fds", "cpp", "ajh", "ryx", "swp", "oxk", "fkl", "lbp", "mtb", "nxp", "izd", "avh", "yij", "ufs", "mfs", "fml", "bnc", "lcb", "fxa", "vgr", "fmf", "tgy", "cnc", "nbt", "gml", "pgt", "tdv", "nxe", "jsh", "bbh", "rfh", "ikd", "fmd", "ydv", "xym", "bnb", "ozl", "fbp", "ycm", "iqi", "dgt", "wyt", "nbm", "snw", "frc", "dwu", "cws", "tzy", "dbn", "vdb", "uur", "mlc", "dks", "vfw", "tgs", "xiu", "njc", "muw", "uzc", "xyi", "suj", "fwy", "sgc", "kmb", "cuw", "ycd", "rlk", "jsc", "jbu", "ivf", "rcg", "lxl", "iax", "dnh", "jio", "olq", "bnh", "uje", "ggd", "zbi", "zva", "tzn", "tws", "jue", "dtn", "ynk", "nmh", "guf", "jpr", "wkr", "sqf", "flm", "nzf", "jse", "rrn", "kts", "omx", "ylg", "ylr", "tbm", "nfd", "tlp", "nuz", "ivl", "yrm", "fyn", "cfm", "zex", "jme", "aeq", "mvs", "gls", "rrl", "yoe", "rbg", "qfo", "sxt", "jci", "ucb", "huz", "hlr", "jsp", "vfl", "kji", "kiz", "ahz", "kuj", "zcz", "ivd", "fsv", "xai", "twt", "jmi", "cpt", "vox", "hmg", "bux", "fdw", "dpn", "uhf", "bcg", "zhn", "afk", "zye", "vts", "yct", "vcl", "wym", "ycn", "kkh", "jdi", "sgb", "fnm", "hdv", "buw", "njh", "tpy", "hcp", "rvp", "dsz", "tdd", "tpf", "ovk", "grb", "rvt", "ldz", "iiu", "rgk", "gld", "cft", "lsz", "bnd", "jrm", "qir", "fbb", "cdy", "szy", "qca", "hix", "ohk", "xjo", "hax", "crp", "azb", "zzu", "ycc", "ubk", "tbn", "avw", "oiz", "kmp", "twu", "tdj", "svr", "wld", "njt", "dvl", "xtj", "hbh", "sbw", "mdt", "ajt", "egj", "dqa", "mgh", "grn", "ylh", "dfw", "ezj", "vci", "uxm", "hpd", "gnj", "gbc", "pdc", "vpc", "hky", "fuh", "yrc", "fnc", "azc", "joj", "uws", "mrz", "bnm", "vcs", "jta", "bhs", "mvc", "fzh", "jli", "hiq", "zyr", "uao", "njp", "fgw", "xxv", "uzt", "trk", "kpm", "nrf", "kcy", "szl", "jrd", "nmf", "kjr", "bpc", "xmm", "wdl", "rkz", "ohg", "zcr", "jko", "mtt", "tks", "yfc", "pfc", "dfd", "crh", "wyd", "xxa", "djd", "voh", "nvh", "qvi", "zih", "djc", "yax", "xyf", "mtm", "wdp", "vhi", "tgt", "ppn", "lbj", "fub", "fcz", "bgu", "bsv", "qun", "hdb", "fnf", "syj", "fnd", "dkw", "fyy", "cns", "tgd", "qft", "dtl", "ulq", "svt", "jux", "fyg", "dmg", "wts", "wua", "vph", "igz", "drz", "dmh", "dhb", "hdp", "sbf", "lmk", "lmj", "jbe", "xvo", "oyv", "izp", "mlp", "tbt", "yuj", "rgj", "rhr", "wps", "dkg", "mdh", "nzr", "ygn", "nfy", "mht", "clt", "ivb", "pfs", "bdp", "axv", "oyz", "dnm", "vuk", "fgt", "sdk", "izn", "nmw", "pnp", "fns", "nxr", "hoz", "hrp", "btd", "jch", "xol", "rlv", "phj", "pcd", "png", "uyv", "npw", "vrs", "xob", "pyv", "jep", "ihy", "pnt", "jle", "brt", "ggf", "duz", "hux", "ptk", "rxe", "lbk", "bls", "ioz", "byx", "lrt", "yrb", "wcs", "qst", "zaj", "vdf", "zdr", "vtu", "bsq", "wrc", "nmn", "hbc", "bpp", "tkg", "xgu", "uxk", "lrd", "grp", "dmw", "txv", "xje", "prd", "dmf", "zut", "xau", "lyx", "nwv", "nbj", "obz", "svc", "pvc", "scv", "lbd", "djm", "ikg", "rzw", "vpt", "nzc", "nsx", "egv", "dwt", "guw", "uzw", "tuz", "ywy", "dhw", "pyk", "jcp", "hcd", "bqu", "pji", "aqd", "mfm", "bpw", "cmw", "dhl", "twp", "xnu", "tnp", "sfb", "pgc", "qim", "sfw", "fhs", "xyw", "qab", "tmn", "aaq", "zsf", "udk",

#if 0
"glt", "gtm", "iij", "hfs", "uht", "pll", "srr", "tmg", "gyj", "zui", "vce", "qre", "izf", "nzm", "fpp", "zzr", "voj", "jip", "bbq", "trl", "nrn", "ehf", "uut", "rxb", "nmv", "sqa", "qpr", "vmw", "jhi", "xsf", "xip", "hbb", "mtl", "lhs", "ejb", "cfb", "dvc", "swf", "spx", "fws", "wum", "ozm", "ocq", "djt", "fpy", "pyu", "nxw", "khn", "bmt", "zuo", "zve", "tcg", "smk", "dcz", "frp", "sfd", "nzt", "mxi", "fpg", "nfp", "nrr", "lbm", "zuh", "sxr", "qbe", "fui", "gcd", "aqm", "gpt", "ytl", "cbm", "kcs", "ybp", "svy", "vje", "ykw", "sfp", "mdm", "sff", "kuu", "gtp", "duj", "btv", "wcd", "prf", "ivh", "hpw", "qaw", "xoc", "nmg", "hgm", "uij", "vur", "wdg", "pgw", "yzh", "izl", "zua", "wdm", "udz", "prm", "ilz", "evk", "vwr", "eyz", "spv", "djb", "trw", "bpt", "udj", "qbu", "ixj", "hvs", "izk", "xep", "slf", "mbg", "gbm", "fks", "rqi", "xix", "jbl", "ogj", "hbp", "ggn", "qor", "ylk", "zsl", "hct", "ybm", "huu", "zzh", "vnd", "uhy", "lcf", "aej", "frt", "vru", "twm", "wyr", "ivv", "aoj", "pyj", "ilq", "bds", "uzn", "prb", "ncj", "kzo", "bnu", "kaq", "buu", "swm", "fiq", "ppv", "qam", "jdu", "ojs", "slm", "nwf", "ikv", "czi", "vms", "gkm", "fzu", "pgf", "fgs", "qon", "iuw", "ejl", "nlr", "juj", "jgr", "mgt", "ccn", "zby", "prw", "czs", "pgp", "lrb", "cpd", "wkm", "aoe", "abv", "xps", "epq", "ybs", "rzs", "jrf", "tlh", "svl", "fuf", "yxa", "lrc", "cmb", "bix", "lxi", "lpv", "lcz", "lww", "dtk", "rsx", "lcn", "juc", "lnr", "quh", "rvr", "dbj", "ibp", "dlw", "wkh", "xig", "uoj", "ioy", "wrd", "fck", "knd", "dlr", "oiu", "jcr", "dmk", "xud", "xlu", "djh", "ypg", "iuj", "xph", "ehk", "umq", "sxc", "rkq", "baq", "bft", "xyb", "rcv", "njw", "aey", "ybh", "zpu", "dxm", "skk", "kvs", "wlv", "mlf", "xeg", "xom", "uzy", "ozt", "cnt", "ylf", "lgd", "imz", "tgb", "sxb", "mdp", "dws", "jrp", "iuy", "gvs", "pvs", "txt", "tfw", "qbt", "cji", "yiu", "ycz", "zyz", "tqb", "fuw", "auq", "nlh", "nhh", "ejv", "bkn", "uxr", "kyy", "hml", "hcn", "wgs", "uvu", "lbn", "nvr", "pnd", "dfg", "mfc", "wuh", "rws", "tgn", "kky", "wms", "hbs", "cwt", "pnr", "jdo", "rfg", "dnp", "ycp", "nxc", "miq", "dlm", "aqp", "wuc", "rrv", "glc", "yww", "yff", "dcg", "hdl", "fvu", "fhp", "qdi", "jbo", "gyk", "blt", "prr", "lvu", "rxu", "tuu", "jjo", "cmm", "bko", "dmn", "hmf", "bnx", "guh", "dfp", "ozw", "nwb", "fpn", "dqi", "gcm", "fkw", "rvc", "ufk", "hpf", "sjs", "dnw", "fdm", "ywc", "gox", "nyz", "lgm", "bvo", "wfc", "mmn", "grc", "dlh", "mkm", "ipq", "ocz", "vbi", "vdu", "hmh", "wkt", "prn", "grm", "ggg", "yxm", "ajl", "fdp", "ejh", "dxe", "dtg", "tkw", "tgp", "jez", "fqa", "uix", "vui", "fqi", "nrg", "jso", "fhm", "hpv", "dwb", "bbf", "mnn", "bmg", "zsm", "jyo", "hks", "uoz", "brd", "nhk", "gtz", "dbw", "lnn", "tjp", "zzg", "qbj", "pzo", "zsr", "ozc", "cmr", "ioq", "bbm", "nxf", "prh", "mdn", "eiq", "sjp", "kbp", "jaq", "dbd", "cmh", "gll", "yej", "luy", "kps", "xkm", "hpj", "jbr", "cnr", "ihl", "elx", "ijr", "bnr", "dxb", "twb", "hrr", "dgc", "cww", "sxe", "tdl", "tdg", "pcv", "btn", "kzi", "aox", "xyz", "nfh", "vsy", "slw", "ccg", "xsb", "wdd", "fwu", "avb", "tpn", "smj", "qaf", "czw", "rpv", "mhw", "vdd", "zgi", "dcv", "ztu", "pgm", "lzs", "gcp", "ejj", "nwm", "nbd", "uaj", "jpo", "cmf", "xja", "lnl", "crb", "zti", "sjc", "ojp", "gcb", "cdv", "rqb", "slv", "vpu", "vko", "nlm", "ejn", "rjp", "nxu", "mgp", "wfp", "wdn", "pdw", "lgs", "vki", "gtb", "tfd", "rjd", "caq", "wcy", "cdn", "dgk", "rhb", "fgy", "cgh", "avf", "jni", "bbd", "khc", "fbn", "bng", "uhh", "nzd", "wkc", "waq", "jga", "aqr", "zug", "hqa", "ytc", "hdn", "xsd", "xee", "txe", "lpj", "wcb", "djw", "ykj", "fwp", "srn", "uqi", "ymh", "pff", "fgc", "jsm", "mkl", "dwp", "tmv", "yrw", "vtw", "pvt", "jno", "wwk", "wtc", "ehg", "xtq", "mtn", "jss", "ltq", "jtw", "nlf", "mdd", "uxn", "sln", "pnw", "djj", "hgy", "bmd", "zru", "ygw", "xaw", "njd", "yuv", "blm", "ygg", "sbj", "cfd", "bwr", "puw", "bkg", "oqi", "wwu", "vcu", "iuf", "mtd", "dwc", "iqb", "kll", "qsh", "jru", "dbf", "phv", "mxa", "sfg", "jpl", "cuh", "tjs", "ocg", "cmg", "hgw", "fmh", "dkc", "krd", "kox", "dqb", "goq", "emx", "vhf", "iue", "srg", "rrg", "fbm", "yhr", "vpm", "llx", "yez", "ivk", "bbg", "vcc", "kfc", "acj", "trg", "nxo", "rhn", "yuf", "uaz", "krh", "ohf", "srl", "slg", "fdd", "ctz", "zij", "ymg", "vdv", "nxx", "cbb", "xue", "vua", "ohj", "aqe", "qut", "yfs", "iht", "lkj", "iui", "pgh", "ivm", "svm", "azk", "qus", "wio", "ihr", "iuh", "tnr", "nhn", "xey", "kpp", "wyi", "bpd", "vfe", "jne", "hdj", "zok", "rhc", "rfy", "hrn", "gdc", "uuu", "uqa", "jtr", "dcj", "trf", "ewx", "dnj", "gtj", "wwj", "ojc", "nkz", "wwv", "ukv", "vpw", "ucn", "vsv", "mtf", "ugy", "slh", "kkk", "jmu", "wgm", "ssx", "svh", "mlw", "fpd", "ogv", "npn", "yft", "mdf", "gds", "hht", "jsw", "ffq", "cpw", "jei", "gbb", "ckx", "gky", "fpf", "qof", "fng", "okq", "qla", "opz", "nwn", "dgd", "tbw", "wct", "pcy", "hnq", "dvp", "cuk", "cgt", "qiw", "fmn", "njb", "mhc", "fbt", "bbp", "yrf", "tln", "xwr", "utx", "rvn", "csx", "xry", "mgw", "juw", "yzu", "kls", "ozd", "jiy", "dvt", "vmu", "juh", "fmg", "zgu", "xyp", "dkb", "hft", "rjs", "pnm", "pfw", "dxr", "yyy", "mks", "jpi", "fkg", "xni", "jsu", "cwc", "prz", "prk", "sxx", "zsw", "trr", "ojt", "cjs", "uyj", "kze", "ivg", "vax", "fwc", "uhw", "nbf", "lht", "dlg", "aql", "ugk", "gnk", "vdm", "qbr", "hpg", "cgs", "nvp", "blc", "cnd", "kww", "zsd", "wpm", "rcj", "ypf", "uua", "syy", "nvt", "lzu", "klm", "yht", "rwc", "sxo", "crw", "wfs", "fyv", "crr", "xmr", "rxt", "vpn", "qls", "bnl", "amx", "ziv", "tbd", "rxm", "rrj", "zny", "ovv", "wuw", "wmt", "sjd", "ubz", "dlf", "sdg", "wpc", "tcz", "nwp", "mhl", "duy", "rjc", "txs", "gxu", "cij", "bza", "krt", "krp", "ybd", "uhm", "srv", "qse", "azg", "bmr", "yrp", "scz", "hzw", "djf", "cll", "vpp", "swl", "nuj", "njm", "cfp", "lgp", "tjh", "ogk", "dwm", "cdh", "spk", "nzp", "jmc", "frn", "ypb", "fdl", "qbc", "hzu", "kcn", "cax", "gtl", "mgb", "fgn", "brz", "bfc", "tnl", "tfb", "lhc", "jlo", "clw", "zsb", "qde", "lzw", "fsj", "hrf", "fjr", "uzd", "ixx", "fgp", "dkt", "bze", "kkl", "pnb", "hzt", "giy", "tgc", "kgm", "yoz", "dhn", "zja", "pvp", "izg", "bfs", "khb", "frf", "fdv", "doq", "plp", "wcp", "qsi", "sxw", "pgb", "nmk", "yfm", "shz", "gkl", "iys", "jsk", "sfh", "qbm", "zzd", "rvw", "khp", "frr", "nbw", "ejf", "wbs", "jke", "qio", "joz", "ejw", "whp", "oez", "gdn", "wtf", "pld", "tlw", "gyy", "kwu", "gtk", "plm", "nnz", "idx", "fvl", "xcy", "wpt", "qaa", "mln", "cgy", "xsr", "rdx", "fdt", "qii", "pft", "hln", "cbt", "kgt", "kcb", "yuo", "gcn", "gfc", "bhd", "kgw", "zcu", "xaa", "sck", "uyk", "gdv", "vsj", "vby", "qta", "ksz", "clb", "wfm", "tyx", "tjm", "msz", "ycf", "jcc", "rbk", "mhr", "tqa", "pxi", "ozb", "jwe", "plw", "nvc", "tfp", "lgw", "cpb", "szw", "jfr", "gdw", "wpp", "vrt", "pmv", "gqb", "hgs", "lkk", "khh", "wox", "crn", "uwm", "mwt", "hkd", "pyy", "lhd", "jij", "trz", "agk", "dhh", "yhs", "dvb", "hhp", "ykc", "tbf", "jds", "cbw", "ajf", "gpw", "wrm", "hww", "flq", "puh", "jva", "jya", "qli", "lgt", "gwb", "sxf", "zju", "ziy", "xah", "mvu", "qsc", "lgn", "gct", "ucp", "mmv", "tzj", "fpb", "zup", "gtf", "pku", "nqb", "qhe", "tuj", "qil", "pdl", "xkl", "rwb", "mgc", "iuz", "dkp", "wku", "jfi", "bnn", "rvm", "svg", "pcn", "ijd", "wud", "kdj", "czu", "afj", "cny", "xeo", "qib", "fvs", "fdj", "eqw", "ywu", "ymk", "xyr", "qte", "sqi", "ybn", "jrk", "vum", "zzz", "agv", "mdl", "hpy", "frw", "cdl", "uud", "mhb", "fcg", "ytm", "rvd", "mgd", "jji", "quy", "mxm", "wft", "svw", "fuu", "zuy", "tkt", "fnh", "dxp", "zfu", "ojm", "txr", "rhw", "fxs", "dxs", "wmp", "rwm", "mwm", "mwy", "yln", "wcf", "kns", "jrl", "zbl", "xow", "vtt", "knj", "jvo", "zce", "jki", "aqg", "xew", "bmh", "tff", "btg", "rwt", "hgp", "cvc", "swd", "ugv", "qid", "lrp", "nxh", "wkb", "tkb", "wiy", "ufw", "mky", "fnt", "tlm", "ddk", "jte", "iqs", "ykt", "mbk", "kcc", "hcf", "klt", "dnl", "bhr", "azf", "nxn", "szs", "iuo", "hzh", "fxe", "dvf", "hbf", "brg", "auu", "aqq", "zyu", "cng", "xef", "wzi", "wji", "pnh", "lhr", "kgh", "jcl", "efx", "xmc", "txm", "rpj", "syx", "cbp", "fxm", "bpb", "xxs", "wiu", "nhg", "dfh", "tjc", "rwd", "fhn", "cwm", "vyj", "hpn", "cgc", "lwu", "lvc", "jsf", "gvu", "djv", "ziu", "eqs", "mfy", "ijm", "dqv", "tjd", "sgf", "mhp", "lvt", "rzl", "wyf", "cvt", "yrk", "qsp", "yvl", "ejk", "ygd", "frg", "xul", "xsn", "rvh", "mgy", "pmk", "nlg", "hxi", "fuo", "tjb", "ftq", "gkg", "yhm", "jbi", "ytb", "pij", "gfs", "wkl", "qbb", "tvy", "mlm", "dvh", "khk", "tck", "plf", "dvm", "whs", "vct", "pdh", "jhu", "snj", "qah", "eqt", "clr", "wln", "iww", "wnz", "vji", "nhf", "mdg", "npv", "aqn", "njf", "gtg", "cpn", "wbb", "tkc", "qum", "xih", "wgc", "pfp", "rfn", "bzu", "bld", "agj", "txb", "jps", "iwu", "nwl", "bvr", "wzo", "luu", "ehv", "jwo", "ajy", "yhd", "lxa", "gpd", "wwy", "qld", "flv", "dln", "xms", "wgn", "tkp", "rfk", "snv", "clp", "nrv", "hgt", "axk", "sjh", "qwo", "qbd", "nvm", "fgb", "dpj", "rbv", "yym", "kcd", "wyb", "vry", "mlk", "qih", "hrg", "uul", "sjb", "gbd", "whl", "pdy", "hnz", "fdb", "afv", "kuv", "wuk", "uzl", "lvr", "yrl", "vuz", "jjh", "kgs", "yjp", "jdd", "vdh", "bjs", "yfy", "plb", "xgl", "wza", "snn", "rhl", "bny", "qiu", "gmj", "ktm", "kld", "hzb", "dxt", "kpt", "khd", "vpb", "rmq", "msx", "gmn", "tlr", "svd", "wrp", "pdb", "snk", "oqa", "tcv", "wgh", "xxc", "kbs", "jti", "dxc", "dbg", "vgi", "rxw", "wrb", "swg", "rrk", "pfm", "cfw", "vpf", "rjh", "pdd", "hhd", "gpy", "tnk", "tcj", "spj", "mjr", "cgm", "uxg", "qbi", "bzo", "grr", "bck", "lgc", "prl", "jgo", "hbt", "sxl", "wue", "gzu", "poj", "ojv", "kvd", "jpg", "fiy", "ygp", "wyw", "eoq", "wui", "wcm", "hmv", "dhg", "wtg", "vuv", "jku", "jeg", "aiq", "vbl", "rxr", "zez", "xka", "pnf", "grf", "fht", "vju", "emz", "lws", "krc", "hgb", "grw", "dwl", "xkn", "njn", "dkf", "nzn", "cuv", "azv", "iug", "vuo", "tbj", "tlg", "nkq", "pvr", "ptq", "iux", "vbs", "tmz", "rxp", "kbb", "xht", "cff", "fkp", "vud", "puo", "bcj", "rjj", "ocv", "gft", "euu", "vup", "jbs", "mfw", "hzs", "hhm", "gpg", "uuc", "svf", "hbm", "clm", "nln", "bgl", "gdh", "cpg", "wtt", "szp", "piy", "ifq", "pks", "jej", "fvr", "bmb", "zwr", "ucm", "ljs", "pjs", "yhp", "lzm", "jsb", "gpf", "tjf", "tfg", "prg", "wrz", "lsx", "mkt", "fkb", "unx", "pdm", "wub", "ikj", "xeu",
#endif

NULL
};

/* ******************************************************************** */

static const char *ndpi_en_impossible_bigrams[] = {
  "bk", "bq", "bx", "cb", "cf", "cg", "cj", "cp", "cv", "cw", "cx", "dx", "fk", "fq", "fv", "fx", /* "ee", removed it can be found in 'meeting' */
  "fz", "gq", "gv", "gx", "hh", "hk", "hv", "hx", "hz", "iy", "jb", /* "jc", jcrew.com */ "jd", "jf", "jg", "jh", "jk",
  "jl", "jm", "jn", "jp", "jq", /* "jr",*/  /* "js", */ "jt", "jv", "jw", "jx", "jy", "jz", /* "kg", */ "kq", "kv", "kx",
  "kz", "lq", "lx", /* "mg" tamgrt.com , */ "mj", /* "mq", mqtt */  "mx", "mz", "pq", "pv", "px", "qb", "qc", "qd", "qe", "qf", "ii",
  "qg", "qh", "qj", "qk", "ql", "qm", "qn", "qo", "qp", "qr", "qs", "qt", "qv", "qw", "qx", "qy", "uu",
  "qz", "sx", "sz", "tq", "tx", "vb", "vc", "vd", "vf", "vg", "vh", "vj", "vm", "vn", /* "vp", Removed for vpbank.com */ "bw", /* "vk", "zr" Removed for kavkazr */
  "vq", /* "vt", gvt1.com, gvt2.com */ "vw", "vx", "vz", "wq", "wv", "wx", "wz", /* "xb", foxbusiness.com */
  "xg", "xj", "xk", "xv", "xz", "xw", "yd", /*"yp", Removed for paypal */
  "yj", "yq", "yv", "yz", "yw", "zb", "zc", "zg", "zh", "zj", "zn", "zq", "zs", "zx", /* "wh", e.g. why */ "wk",
  "wb", "zk", "kp", "zk", "xy", "xx",
  NULL };
