/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Nemerle.Extensions;
 
namespace Nemerle.Internal
{
  public interface Func0 : Func1
  {
    apply () : object;
  }

  public interface Func1
  {
    apply (_ : object) : object;
  }

  public interface Func2 : Func1
  {
    apply (_ : object, _ : object) : object;
  }

  public interface Func3 : Func1
  {
    apply (_ : object, _ : object, _ : object) : object;
  }

  public interface Func4 : Func1
  {
    apply (_ : object, _ : object, _ : object, _ : object) : object;
  }

  public interface Func5 : Func1
  {
    apply (_ : object, _ : object, _ : object, _ : object, _ : object) : object;
  }

  public interface Func6 : Func1
  {
    apply (_ : object, _ : object, _ : object, _ : object, _ : object,
           _ : object) : object;
  }

  public interface Func7 : Func1
  {
    apply (_ : object, _ : object, _ : object, _ : object, _ : object,
           _ : object, _ : object) : object;
  }

  public interface Func8 : Func1
  {
    apply (_ : object, _ : object, _ : object, _ : object, _ : object,
           _ : object, _ : object, _ : object) : object;
  }

  public interface Func9 : Func1
  {
    apply (_ : object, _ : object, _ : object, _ : object, _ : object,
           _ : object, _ : object, _ : object, _ : object) : object;
  }

  // note that the fact that Tuple2 and 3 are structs
  // is also needed in MType.IsValueType

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode]
  public struct Tuple2
  {
    public field1 : object;
    public field2 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode]
  public struct Tuple3
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple4
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
    public field4 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple5
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
    public field4 : object;
    public field5 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple6
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
    public field4 : object;
    public field5 : object;
    public field6 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple7
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
    public field4 : object;
    public field5 : object;
    public field6 : object;
    public field7 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode, 
   DisableImplicitConstructor]
  public sealed class Tuple8
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
    public field4 : object;
    public field5 : object;
    public field6 : object;
    public field7 : object;
    public field8 : object;
  }

  [System.Serializable,
   Record,
   StructuralEquality,
   TupleToString,
   StructuralHashCode,
   DisableImplicitConstructor]
  public sealed class Tuple9
  {
    public field1 : object;
    public field2 : object;
    public field3 : object;
    public field4 : object;
    public field5 : object;
    public field6 : object;
    public field7 : object;
    public field8 : object;
    public field9 : object;
  }
}
