/*
 * Copyright (c) 2003-2005 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Nemerle.Collections;

using Nemerle.Compiler.Typedtree;

using System.Reflection;

namespace Nemerle.Compiler {

module CompileTypedMethod
{
  do_compile_method (meth : NemerleMethod) : void
  {
    match (meth.GetHeader ().body) {
      | FunBody.Parsed => 
        _ = Typer (meth)
      | _ => ()
    };
    def current_type = meth.DeclaringType :> TypeBuilder;

    def im = ImplementsWrapperMaker (meth);
    im.Run ();

    // Message.Debug (meth.Location, $ "compile: $meth");
    
    Util.locate (meth.Location, {
      match (meth.GetHeader ().body) {
        | FunBody.ILed => Util.ice ()
        | FunBody.Parsed => Util.ice ()

        | FunBody.Typed when Message.SeenError =>
          // just skip it
          meth.GetHeader ().body = FunBody.ILed ()
          
        | FunBody.Typed =>
          if (meth.GetFunKind () is FunKind.Constructor)
            Passes.Emitter.EmitConstructor (current_type, meth)
          else
            Passes.Emitter.EmitMethod (current_type, meth);

        | FunBody.Abstract => ()
      }
    });
    
    when (Options.EarlyExit)
      Message.MaybeBailout ();
  }

  internal CompileMethodImmediately (meth : NemerleMethod) : void
  {
    match (meth.GetHeader ().body) {
      | FunBody.ILed => {}
      | _ =>
        do_compile_method (meth);
    }
  }
} // end module
} // end ns
