// Testing the default value expressions (14.5.13)

using System;

class Foo[T]
{
	 mutable  t :  array [T];

	public this ( n : int)
	{
		t =  array(n);
		for (mutable  i = 0; i < n; i++)
			t [i] =Nemerle.Extensions.DefaultValue (T); // W: using the `null' literal as a value of generic type T
	}

	public Test () :  void
	{
		X.Print (t [0]);
	}
}

class Bar[T]
{
	public Test () :  void
	{
		X.Print (Nemerle.Extensions.DefaultValue (X));
		X.Print (Nemerle.Extensions.DefaultValue (T));// W: using the `null' literal as a value of generic type T
		X.Print (Nemerle.Extensions.DefaultValue (S));
	}
}

struct S
{
	public  Hello : string;

	this ( hello : string)
	{
		this.Hello = hello;
	}

	public override ToString () :  string
	{
		 String.Format ("S({0})", Hello);
	}

}

class X
{
	public static Print ( obj : object) :  void
	{
	{
		if (obj == null)
			Console.WriteLine ("NULL");
		else
			Console.WriteLine ("OBJECT: {0} {1}", obj, obj.GetType ());
	}
	}

	static Main () :  void
	{
		mutable  a =  Foo (4);
		a.Test ();

		mutable  b =  Bar ();
		b.Test ();
		mutable  c =  Bar ();
		c.Test ();
	}
}
/*
FIXME: after we have generics third NULL should be
OBJECT: 0 System.Int32

BEGIN-OUTPUT
NULL
NULL
NULL
OBJECT: S() S
NULL
NULL
OBJECT: S() S
END-OUTPUT
*/
