//
// Another important test: nested generic types.
//

using System;

class Queue[T]
{
	public this (mutable  first : T,mutable  second :  T)
	{
		head =  Node (null, second);
		head =  Node (head, first);
	}

	protected  mutable  head : Node[T];

	protected GetFoo () :  Node[T]
	{
		 head;
	}

	protected Foo : Node[T] {
		get {
			 GetFoo ();
		}
	}

	protected Test (mutable  t : T) :  void
	{
		Console.WriteLine (t);
	}

	public Test () :  void
	{
		Test (head.Item);
		Test (head.Next.Item);
		Test (GetFoo ().Item);
		Test (Foo.Item);
	}

	protected class Node[U]
	{
		public  Item : U;
		public  Next : Node[U];

		public this (mutable  next : Node[U],mutable  item :  U)
		{
			this.Next = next;
			this.Item = item;
		}
	}
}

class X
{
	static Main () :  void
	{
		mutable  queue =  Queue (5, 9);
		queue.Test ();
	}
}
/*
BEGIN-OUTPUT
5
9
5
5
END-OUTPUT
*/
