//
// This test probes that we treat events differently than fields
// This used to cause a compiler crash.
//
using System;

delegate PersonArrivedHandler ( source : object, args :  PersonArrivedArgs) :  void;

class PersonArrivedArgs /*: EventArgs*/ {
    public  mutable  name : string;
    public this ( name : string) {
	this.name = name;
    }
}

class Greeter {
     mutable  greeting : string;

    public this ( greeting : string) {
	this.greeting = greeting;
    }

    public HandlePersonArrived ( _source : object, args :  PersonArrivedArgs) :  void {
	Console.WriteLine(greeting, args.name);
    }
}

class Room { event PersonArrived :  PersonArrivedHandler;

    public this () {
	    // Assign a value to it, this also used to crash the compiler.
	    PersonArrived = null;
    }

    public AddPerson ( _name : string) :  void {
	PersonArrived(this, null); //(this, PersonArrivedArgs(name));
    }
}

class DelegateTest {
    static Main () :  int {
	 0;
    }
}
/*
BEGIN-OUTPUT
END-OUTPUT
*/
