using Nemerle.IO;
using Nemerle.Concurrency;

module Test
{
    class A
    {
        mutable i : int = 0;
        
        [Async]
        public M () : void
        {
            while (i == 0) ();
            printf ("OK\n")
        }

        public N () : void
        {
            i = 1;
        }
    }

    private volatile mutable x : int;
    
    Main () : void
    {
        def a = A ();
        a.M ();

        x = 0;

        async 
        {
            while (x == 0) ();
            assert (x == 1);
            x = 2
        }

        async 
        {
            3 // W: ignored
        }

        x = 1;
        while (x == 1) ();
        assert (x == 2);

        printf ("%d\n", x);
        a.N ()
    }
}
/*
BEGIN-OUTPUT
2
OK
END-OUTPUT
*/
