namespace NoDelegateProxy
{
  using Nemerle.IO;
  using Nemerle.Collections;
  
  delegate Foo (x : string) : void;

  class Test {
    event boom1 : Foo;
    static event boom : Foo;
    
    static doo (x : string) : void
    {
      print (x);
    }

    daa (x : string) : void
    {
      print (x);
    }

    Do () : void {
      this.boom1 += this.daa;
      this.boom1 ("event instance\n");
    }
    
    public static Run () : void
    {
      def f = Foo (doo);
      f ("bla\n");
      def g = doo : Foo;
      g ("blu\n");
      boom += doo;
      boom ("event\n");
      Test ().Do ();
      CheckReflection ();
    }

    static CheckReflection () : void
    {
      mutable count = 0;
      foreach (x in List.FromArray (typeof (Test).Assembly.GetTypes ()))
        when (x.FullName.StartsWith ("NoDelegateProxy"))
          ++count;
      assert (count == 2);
    }
  }
}


module M {
  Main () : void {
    NoDelegateProxy.Test.Run ();
  }
}

/*
BEGIN-OUTPUT
bla
blu
event
event instance
END-OUTPUT
*/
