using Nemerle.IO;

delegate Foo () : void;

delegate MultiParm (h : object, b : A1) : void;

class A1 {

public event Bar : Foo;

public static m1 () : void { }

public static run () : void {
    def a = A1();
    a.Bar += Foo (m1);
    a.Bar -= Foo (m1);
    if (a.Bar == null) Nemerle.IO.printf ("ok\n") else Nemerle.IO.printf ("bad\n");
  }
}

// Test for covariance support in delegates
//

using System;

 public class A {
         protected  mutable  name : string;

         public this ( name : string)
         {
                 this.name = "A::" + name;
         }

         public this ()
         {
         }

         public Name : string {
                 get {
                          name;
                 }
         }
 }

 public class B : A {
         public this ( name : string)
         {
                 this.name = "B::" + name;
         }

         public this ()
         {
         }
 }

 public class C : B {
         public this ( name : string)
         {
                 this.name = "C::" + name;
         }
 }

 public class Tester {

         delegate MethodHandler ( name : string) :  A;

         static MethodSampleA ( name : string) :  A
         {
                   A (name);
         }

         static MethodSampleB ( name : string) :  B
         {
                   B (name);
         }

         static MethodSampleC ( name : string) :  C
         {
                   C (name);
         }

         public static Mai () :  void
         {
                 mutable  a = MethodSampleA;
                 mutable  b = MethodSampleB;
                 mutable  c = MethodSampleC;

                 mutable  instance1 = a ("Hello");
                 mutable  instance2 = b ("World");
                 mutable  instance3 = c ("!");

                 Console.WriteLine (instance1.Name);
                 Console.WriteLine (instance2.Name);
                 Console.WriteLine (instance3.Name);
         }
 }


class MyClass {
        delegate IsAnything ( c : Char) : bool;
        delegate Foo () : int;

        public static Run () : void {
                mutable validDigit = Nemerle.Extensions.DefaultValue (IsAnything);
                validDigit = IsAnything (Char.IsDigit);
                assert (validDigit ('9'));
                assert (!validDigit ('a'));
                _ = Foo (System.Console.Read);
        }
}

public delegate GenDel[X] (x : X) : int;

public module M {

  public delegate MyPrintDelegate (s : string) : void;
  private delegate MySprintDelegate (s : string) : string;
  delegate MyIntReturningDelegate () : int;

  run_my_delegate (s : string, msd : MyPrintDelegate) : void
  {
    msd.Invoke (s)
  }

  run_my_non_void_delegate (s : string, mpd : MySprintDelegate) : string
  {
    mpd.Invoke (s)
  }
  
  run_delegate (ts : System.Threading.ThreadStart) : void
  {
    ts.Invoke ()
  }
  
  run_delegate (s : string, ts : System.Threading.WaitOrTimerCallback) : void
  {
    ts.Invoke (s, true);
    ts.Invoke (s, false)
  }
  
  static_meth () : void
  {
    printf ("static_meth\n")
  }

  string_static_meth (s : string) : void
  {
    printf ("string_static_meth: %s\n", s)
  }
  
  sprint_static_meth (s : string) : string
  {
    sprintf ("sprint_static_meth: %s\n", s)
  }

  static_timer_meth (o : object, b : bool) : void
  {
    printf ("s: %s:%s\n", (o :> string), if (b) "t" else "f")
  }

  class C1 {
    name : string;
    public this (n : string) { name = n }
    public m1 () : void
    {
      printf ("%s C.m1\n", name)
    }
    public m2 (o : object, b : bool) : void
    {
      printf ("%s: %s:%s\n", name, (o :> string), if (b) "t" else "f")
    }
  }

  gen_fun [T] (x : T) : int { 
    printf ("%s\n", x.GetType ().ToString ()); 1 
  }
  
  Main () : void 
  {
    def str = "local_meth";
    def local_meth () {
      printf ("%s\n", str)
    };
    def local_timer_meth (o : object, b : bool) : void {
      printf ("l: %s:%s\n", (o :> string), if (b) "t" else "f")
    };
    
    run_delegate (System.Threading.ThreadStart (static_meth));
    run_delegate (System.Threading.ThreadStart (local_meth));
    run_delegate ("foo", System.Threading.WaitOrTimerCallback (local_timer_meth));
    run_delegate ("foo", System.Threading.WaitOrTimerCallback (static_timer_meth));
    run_delegate ("bar", System.Threading.WaitOrTimerCallback (static_timer_meth));

    run_my_delegate ("foobarized", M.MyPrintDelegate (string_static_meth));
    
    printf ("non-void: %s",
            run_my_non_void_delegate ("foobarized", M.MySprintDelegate (sprint_static_meth)));

    def c1 = C1 ("c1");
    def c2 = C1 ("c2");
    run_delegate (System.Threading.ThreadStart (c1.m1));
    run_delegate (System.Threading.ThreadStart (c2.m1));
    run_delegate ("qux", System.Threading.WaitOrTimerCallback (c1.m2));
    run_delegate ("qux", System.Threading.WaitOrTimerCallback (c2.m2));
    A1.run ();
    def _gen_d = GenDel (gen_fun);
//  FIXME: problem with generic type in delegates
//    assert (gen_d (2) == 1);
    Tester.Mai ();    
    MyClass.Run ();
  }
}

/*
BEGIN-OUTPUT
static_meth
local_meth
l: foo:t
l: foo:f
s: foo:t
s: foo:f
s: bar:t
s: bar:f
string_static_meth: foobarized
non-void: sprint_static_meth: foobarized
c1 C.m1
c2 C.m1
c1: qux:t
c1: qux:f
c2: qux:t
c2: qux:f
ok
A::Hello
B::World
C::!
END-OUTPUT
*/
