using Nemerle.IO;
using Nemerle.Collections.List;

module M {
  /** Entry point */
  Main () : void {
    def _ = ([] : list [list [list [int]]]);
    def l = ["foo", "bar", "baz"];
    mutable acc = ":" ;
    def prt (s : string) : void {
        acc = acc + ":" + s;
        printf ("%s\n", s) 
    };
    Iter (l, prt);
    printf ("%s\n", acc);
    def concat (s : string, acc : string) : string { acc + "." + s };
    printf ("%s\n", FoldLeft (l, "", concat));
    def l = [["a", "b"], ["c"], ["d", "e", "f"]];
    printf ("%s\n", FoldLeft (Flatten (l), "", concat));
    def l = [1,2,3,4] + [5,6,7];
    foreach (x in l) {
      printf ("%d ", x);
    };
    printf (".\n");
  }
}

/*
BEGIN-OUTPUT
foo
bar
baz
::foo:bar:baz
.foo.bar.baz
.a.b.c.d.e.f
1 2 3 4 5 6 7 .
END-OUTPUT
*/
