// REFERENCE: Nemerle.Compiler

using Nemerle.Collections;
using Nemerle.Compiler;
using Nemerle.IO;
using System;
using System.Xml;

public interface IFoo
{
  Foo () : void;
}

macro generateIFoo ()
{
  def tb = Nemerle.Macros.ImplicitCTX ().Env.Define (<[ decl:
    public class BlahBle : IFoo
    {
      public Foo () : void
      {
        print ("Hello!\n");
      }
    }
  ]>);
  tb.Compile ();
  <[ BlahBle () ]>
}

macro forp (i, n : int, m : int, body)
syntax ("forpermutation", "(", i, "in", n, "to", m, ")", body)
{
  def a = array (m - n + 1);
  for (mutable j = 0; j < m - n + 1; j = j + 1)
    a[j] = j + n;
  mutable p = [];
  def r = System.Random ();
  for (mutable k = m - n; k >= 0; k = k - 1) {
    def rand = r.Next (k + 1);
    p = <[ $(a[rand] : int) ]> :: p;
    a[rand] <-> a[k];
  };
  <[
    def p = array [..$p];
    for (mutable j = 0; j < $(m - n + 1 : int); j = j + 1) {
      $i = p[j];
      $body
    }
  ]>
}

macro generate_power (n : int) {
  def sqr (x) { <[ def y = $x; y * y ]> };
  
  def pow (n, x) {
    if (n == 0)
      <[ 1.0 ]>
    else
      if (n % 2 == 0) // even
        sqr (pow (n / 2, x))
      else
        <[ $x * $(pow (n - 1, x)) ]>
  }
  <[ fun (x) { $(pow (n, <[ x ]>)) } ]>
}

namespace A {
  macro gg (a)
  syntax ("g_gg", a) { a  }
}

macro ala()
{
  def tb = Nemerle.Macros.ImplicitCTX ().Env.Define (<[ decl:
    public class haha {
      x : int;
      public this(){
        Console.WriteLine ("creating haha");
      }
    }
  ]>);

  /// test for <[ ]> matching
  match (<[ def (1,2) = 3; ]>) {
    | <[ def $_ = $_ ]> => ()
    | _ => assert (false)
  }
  
  tb.Compile ();
  <[ Console.WriteLine ("proba") ]>;
}

public interface ISerializable {
  Serialize () : void;
}

[Nemerle.MacroUsage (Nemerle.MacroPhase.BeforeInheritance, Nemerle.MacroTargets.Class,
                     Inherited = true)]
macro Serializable (t : TypeBuilder)
{
  t.AddImplementedInterface (<[ ISerializable ]>)
}


[Nemerle.MacroUsage (Nemerle.MacroPhase.WithTypedMembers, Nemerle.MacroTargets.Class,
                     Inherited = true)]
macro Serializable (t : TypeBuilder)
{
  def bla = t.DefineNestedType (<[ decl:
    public class Bla {
      public this () { }
      public f () : string { "f()" }

      public static Bla () : void  { Console.WriteLine ("from Bla.Bla") } 
    }
  ]>);
  bla.Compile ();

  /// here we list its fields and choose only those, which are not derived
  /// or static
  def fields = t.GetFields (BindingFlags.Instance | BindingFlags.Public %|
                            BindingFlags.NonPublic | BindingFlags.DeclaredOnly);

  /// now create list of expressions which will print object's data  
  mutable serializers = [];

  /// traverse through fields, taking their type constructors  
  foreach (x : IField in fields) {
    def tc = x.GetMemType ().TypeInfo;
    def nm = Macros.UseSiteSymbol (x.Name);
    if (tc != null)
      if (tc.IsValueType)
        /// we can safely print value types as strings        
        serializers = <[
                         printf ("<%s>", $(x.Name : string));
                         System.Console.Write ($(nm : name));
                         printf ("</%s>\n", $(x.Name : string));
                       ]>
                       :: serializers
      else
        /// we can try to check, if type of given field also implements ISerializable
        if (x.GetMemType ().Require (<[ ttype: ISerializable ]>))
          serializers = <[
                           printf ("<%s>\n", $(x.Name : string));      
                           if ($(nm : name) != null)
                             $(nm : name).Serialize ()
                           else
                             printf ("<null/>\n");
                           printf ("</%s>\n", $(x.Name : string));
                         ]>
                         :: serializers
        else
          /// and finally, we encounter case when there is no easy way to serialize 
          /// given field
          Message.FatalError ("field `" + x.Name + "' cannot be serialized")
    else
      Message.FatalError ("field `" + x.Name + "' cannot be serialized")
  };
  // after analyzing fields, we create method in our type, to execute created
  // expressions
  t.Define (<[ decl: public Serialize () : void
                     implements ISerializable.Serialize {
                       .. $serializers
                     }
            ]>);

  t.Define (<[ decl: public foo : int = 5; ]>);
}

macro myif1 (cond, then, el) 
syntax ("mif", "(", cond, ")", then, Optional (";"), "else", el) {
  <[ if ($cond) $then else $el ]>
}

macro myif2 (cond, then) 
syntax ("mif", "(", cond, ")", then, Optional (";")) {
  <[ when ($cond) $then ]>
}

macro thr (exc = null) 
syntax ("_throw", Optional (exc)) {
  <[ throw $exc ]>
}

macro arr1_macro (params inits : list [PExpr])
syntax ("arrr", "[", inits, "]") {
  <[ array [..$inits] ]>
} 

macro arr2_macro (rank, params inits : list [PExpr])
syntax ("arrr", ".", "[", rank, "]", "[", inits, "]") {
  <[ array .[$rank] [..$inits] ]>
} 

macro arr3_macro (params dims : list [PExpr])
syntax ("arrr", "(", dims, ")") {
  <[ array (..$dims) ]>
}

macro tokenizer (tok : Token) 
syntax ("xml", tok) 
{
  def buf = Text.StringBuilder ();
  foreach (t in tok)
    ignore (buf.Append (t.ToString ()));
  <[ 
     def document = XmlDocument ();
     def frag = document.CreateDocumentFragment ();
     frag.InnerXml = $(buf.ToString () : string);
     _ = document.AppendChild (frag);
     document
  ]>
}

macro oper (o)
syntax ("%%", o) {
  def x = o.ToString ();
  <[ System.Console.WriteLine ($(x : string));
     $o
  ]>
}

macro permute' (data, p_expr)
{
  def expr_to_array (expr) {
    // we must convert syntax tree of array into array itself
    | <[ array [..$p_list] ]> =>
      def permutation = array (p_list.Length);
      mutable count = 0;
      foreach (<[ $(x : int) ]> in p_list) {
        permutation [count] = x;
        count++;
      }
      permutation

    | _ => throw System.ArgumentException ("only constant arrays are allowed")
  }

  def permutation = expr_to_array (p_expr);
  def visited = array (permutation.Length);
  mutable result = [];

  for (mutable i = 0; i < permutation.Length; i++) {
    mutable pos = i;
    while (!visited [pos]) {
      visited [pos] = true;
      def next_pos = permutation [pos];
      unless (visited [next_pos]) {
        result = <[ $data [$(pos : int)] <-> $data [$(next_pos : int)] ]> :: result;
        pos = next_pos;
      }
    }
  }
  <[ {..$result } ]>
}


[Nemerle.MacroUsage (Nemerle.MacroPhase.BeforeInheritance, Nemerle.MacroTargets.Method,
                     Inherited = true)]
macro MyRequire (_ : TypeBuilder, m : ParsedMethod, expr, thor = null)
syntax ("requ", expr, Optional ("otherwise", thor))
{
  m.Body = <[ assert ($expr, "requ"); $(if (thor != null) <[ $thor ]> else m.Body) ]>
}

[Nemerle.MacroUsage (Nemerle.MacroPhase.BeforeInheritance, Nemerle.MacroTargets.Method,
                     Inherited = true)]
macro MyAsync (_ : TypeBuilder, m : ParsedMethod)
syntax ("asyn")
{
  m.Body = <[ System.Console.WriteLine ("I could be asynced");
              $(m.Body); ]>
}

[Nemerle.MacroUsage (Nemerle.MacroPhase.WithTypedMembers, Nemerle.MacroTargets.Method,
                     Inherited = true)]
macro MyAsync (_ : TypeBuilder, m : MethodBuilder)
syntax ("asyn")
{
  m.Body = <[ System.Console.WriteLine ("I could be asynced with members");
              $(m.Body); ]>
}

macro MyExprAsync (expr)
syntax ("asyn", expr)
{
  <[ System.Console.WriteLine ("my precious asyn"); $expr ]>
}


[Nemerle.MacroUsage (Nemerle.MacroPhase.BeforeInheritance, Nemerle.MacroTargets.Assembly)]
macro AssemblyMac (x) {
  match (x) {
    | <[ $_.$_ ]> => ()
    | _ => assert (false)
  }
}
  
macro @myfor (_init, _cond, _change, _retval, _body)
syntax ("myfor", "(", Optional (_init), ";", Optional (_cond),
        ";", Optional (_change), Optional(";", _retval), ")", _body)
{
  <[ () ]>
}

namespace Ops
{
  [assembly: Nemerle.Internal.OperatorAttribute ("Ops", "and", false, 160, 161)]

  macro @and (e1, e2) {
    <[ $e1 && $e2 ]>
  }

  [assembly: Nemerle.Internal.OperatorAttribute ("Ops", "not", true , 281, 280)]

  macro @not (e) {
    <[ ! $e ]>
  }
  
}
