using Nemerle.IO;

module ArrayTest
{
  f (a : object) : void
  {
    if (a == null) 
      printf ("null\n");
    else
      printf ("not null\n");
  }

  g (a : array [2, int]) : void
  {
      printf ("%d\n", a [2, 1]);
  }

  addr (a : ref int) : void
  {
    ++a;
  }

  Main () : void 
  {
    printf ("Multidimensional Array test.\n");

    def a = array (3, 2);
    for (mutable i = 0; i < 3; ++i)
      for (mutable j = 0; j < 2; ++j)
        a [i, j] = (i + 1) * (j + 1);

    printf ("%s\n", typeof (array [2, int]).ToString ());
    printf ("%s\n", a.GetType ().ToString ());

    for (mutable i1 = 0; i1 < 3; ++i1)
    {
      for (mutable j = 0; j < 2; ++j)
        printf ("%d ", a [i1, j]);
      printf ("\n");
    }

    def b = array (3, 4, 5);
    b [1, 2, 3] = "b123";
    printf ("%s\n", b [1, 2, 3]);

    // arays of arrays don't work, this also happens also for one dimension
    def c = array (6, 7, 8, 9, 10);
    c [3, 4, 5, 6, 7] = (b : object); // should be just b
    printf ("%d\n", if (c [3, 4, 5, 6, 7] == null) 1 else 0);
    printf ("%d\n", if (c [3, 4, 5, 6, 8] == null) 1 else 0);
    
    mutable x = a [2, 1];
    a [2, 1] = x + 1;
    mutable y = a [2, 1];
    printf ("%d\n%d\n", x, y);

    mutable a1 = a;
    mutable x1 = a1 [2, 1];
    a1 [2, 1] = x1 + 1;
    mutable y1 = a1 [2, 1];
    printf ("%d\n%d\n", x1, y1);

    def b = a1;

    printf ("%d\n", if (a1 == null) 1 else 0);
    a1 = null;
    printf ("%d\n", if (a1 == null) 1 else 0);

    f (b);

    def h (a : array [int])
    {
      printf ("%d\n", a[1]);
    }
    def a2 = array (10);
    h (a2);

    g (b);

    def q = Q ();
    printf ("%d\n", q.a2 [1, 2]);

    def _mya = array .[2] [ [ [1,2], []], [ [], [] ] ];

    def a3 = array .[3] [[[" 1", " 2"], [" 3", " 4"], [" 5", " 6"]],
                        [["11", "12"], ["13", "14"], ["15", "16"]],
                        [["21", "12"], ["23", "14"], ["25", "26"]],
                        [["31", "12"], ["33", "14"], ["35", "36"]]];
    printf ("%s\n", a3 [1, 2, 0]); 

    def a3 = array .[3] [[[ 1.5,  2.5], [ 3.5,  4.5], [ 5.5,  6.5]],
                        [[11.5, 12.5], [13.5, 14.5], [15.5, 16.5]],
                        [[21.5, 12.5], [23.5, 14.5], [25.5, 26.5]],
                        [[31.5, 12.5], [33.5, 14.5], [35.5, 36.5]]];
    printf ("%lf\n", a3 [1, 2, 0]); 

    def t = array .[1] [5, 6, 7, 8];
    t [3] = t [1] + 4;
    printf ("%d %d\n", t [2], t [3]);

    addr (ref t [3]);
    printf ("%d\n", t [3]);

    def a = array .[3] [];
    printf ("%s\n", a.GetType ().ToString ());
  }

  class Q
  {
    public this ()
    {
      a1 = array [1, 2, 3];
      a2 = array .[2] [[1, 2, 3], [4, 5, 6]];
    }
    public a1 : array [int];
    public a2 : array [2, int];
  }
}

// FIXME: disable verification, because of PEVerify.exe bug with arrays creation
// NO-VERIFY

/*
BEGIN-OUTPUT
Multidimensional Array test.
System.Int32[,]
System.Int32[,]
1 2 
2 4 
3 6 
b123
0
1
6
7
7
8
0
1
not null
0
8
6
15
15.5
7 10
11
System.Object[,,]
END-OUTPUT
*/
