
using Nemerle.IO;
using Nemerle.Utility;

public class NArrayTest
{
  public static Main () : void 
  {
    printf ("NArray test.\n");

    mutable a = array ["a", "b", "abcde", "d", "e"];

#if TODO_FIX_A_BOXING_BUG
    mutable b = array [4, 6, 8, 10, 12, 14, 16, 18];
#endif

    if (NArray.Exists (a, fun (x : string) { x.Length > 1 }))
      printf ("Exists!\n")
    else
      printf ("Does not exist!\n");

    if (NArray.Exists (a, fun (x : string) { x.Length > 12 }))
      printf ("Exists!\n")
    else
      printf ("Does not exist!\n");

#if TODO_FIX_A_BOXING_BUG
    if (NArray.ForAll (b, fun (x : int) { x % 2 == 0 }))
      printf ("For all!\n")
    else
      printf ("Not quite for all!\n");

    if (NArray.ForAll (b, fun (x : int) { x % 2 == 1 }))
      printf ("For all!\n")
    else
      printf ("Not quite for all!\n")
#endif
  }
}

/*
BEGIN-OUTPUT
NArray test.
Exists!
Does not exist!
END-OUTPUT
*/

#if TODO_FIX_A_BOXING_BUG
/*
For all!
Not quite for all!
*/
#endif
