using Nemerle.IO;
class A {}
class B : A {}
class C : B { public this () {} }

class StaticOverride {
    static new ToString () : string {
        "bla"
    }

    public static Run () : void { 
        System.Console.WriteLine (StaticOverride.ToString ());
//        def x = StaticOverride ();
//        printf ("%s\n", x.ToString ());
    }
}

namespace CtorVsMethodOut {
  using System;

  enum AEnum { | a | b }

  public class T {
       private static Convert ( a : out AEnum) : void
        {
                a = AEnum.a;
                printf ("called Convert\n");
        }
        public static Run () : void
        {
                mutable a = ( 0 :> AEnum);
                Convert (out a);
        }
  }
}

namespace PolymorphicPlusFunctionals {
  using Nemerle.Collections;

  module M {
    f (x : int) : int { x }
    f (_x : string) : int { 1 }
    g['a] (l : list['a], f : 'a -> int) : void {
      Nemerle.IO.printf ("%s\n", List.Map (l, f).ToString ())
    }

    public Run () : void {
      def l = [1,2,3];
      g (l, f);
      def l = ["a","b","c"];
      g (l, f)
    }
  }
}

namespace AssignmentLValue {
  using System;

  class X {
      static mutable Int32 : Int32;

      public static Run () : void
      {
         Int32 = ( 0 : Int32);
      }
  }
}

module M {
  foo (_ : array [string]) : void { }
  foo (_ : array [object]) : void { assert (false) }

  bar (s : string, i : int) : void {
    _ = s;
    _ = i;
  }
  
  bar (i : int, s : object) : void {
    _ = s;
    _ = i;
    assert (false);
  }
  
  f (_ : A, _ : B) : void {}
  f (_ : B, _ : B) : void { printf ("OK\n") }

  public Main () : void {
    f (C (), C ());
    StaticOverride.Run ();
    CtorVsMethodOut.T.Run ();
    PolymorphicPlusFunctionals.M.Run ();
    AssignmentLValue.X.Run ();

    bar (s = "foo", i = 42);
    bar (i = 42, s = "foo");
    foo (array ["foo"]);
  }

  public Main (_args : string) : void // W: has the wrong signature to be an entry point
  {  }
}

/*
BEGIN-OUTPUT
OK
bla
called Convert
[1, 2, 3]
[1, 1, 1]
END-OUTPUT
*/
