
using Nemerle.IO;

namespace Attributes {
  partial class A {
    public class I { }
    public B : int = 1;
  }

  [System.Xml.Serialization.XmlTypeAttribute]
  partial class A {
    public class J { }
    public H : int = 2;
  }
}

namespace N {
  partial class A {
    class I { }
    public B : int = 3;
  }

  [System.Xml.Serialization.XmlTypeAttribute]
  partial class A {
    class J { }
    public H : int = 4;
  }
}

namespace PartialParts {
  namespace Foo
  {
    public class Hello
    {
      public static mutable World : int = 8;
    }
  }

  namespace Bar
  {
    public class Hello
    {
      public static mutable World : int = 9;
    }
  }

  namespace X
  {
    using PartialParts.Foo;

    public partial class Test
    {
      public static FooWorld () : int
      {
        Hello.World;
      }
    }
  }

  namespace X
  {
    using PartialParts.Bar;
    
    public partial class Test
    {
      public static BarWorld () : int
      {
        Hello.World;
      }
    }
  }
}

namespace MergingInfaceAndTyparms {
  namespace A
  {
      interface IFoo
      {
           Hello (mutable  foo : IFoo) : void;
      }
  }

  namespace B
  {
    partial class Test [T] : IDoo, A.IFoo where T : A.IFoo
      {
        public Add (x : T) : void {
          x.Hello (x);
        }
      }
  }

  namespace B
  {
      using A;

      partial class Test [T] : Y, IFoo where T : IFoo
      {
           IFoo_Hello (mutable  _foo : IFoo) : void implements IFoo.Hello
          { }

          public Add1 (x : T) : void {
            System.Console.WriteLine ("add1");
            x.Hello (x);
          }
      }
  }

  interface IDoo { }

  class Foo : A.IFoo {
    public Hello (_ : A.IFoo) : void {
      System.Console.WriteLine ("hello");
    }
  }

  class Y { }

  class X
  {
      public static Run () :  void
      {
        printf ("--------- test ifaces -----------\n");
        def x = B.Test ();
        _ = x : IDoo;
        _ = x : A.IFoo;
        _ = x : Y;
        x.Add (Foo ());
        x.Add1 (Foo ());
      }
  }
}

namespace OtherTypes
{
  partial variant AVar {
    | B
    | C
  }

  partial variant AVar {
    | D
    | E
  }

  partial interface IN {
    foo () : void;
  }
  partial interface IN {
    faa () : void;
  }
  

  public class Test
  {
          public static Run () : void
          {
            def x = AVar.B() : AVar;
            match (x) {
              | AVar.B => ()
              | AVar.C => ()              
              | AVar.D => ()
              | AVar.E => ()              
            }
          }
  }
}


class U {
  static TestParts () : void
  {
    printf ("--------- test parts ------------\n");
    if (PartialParts.X.Test.FooWorld () != 8)
      System.Console.WriteLine ( 1);
    else  {
      if (PartialParts.X.Test.BarWorld () != 9)
        System.Console.WriteLine ( 2);
      else
        System.Console.WriteLine ( 0);
    }
  }
  
  static Main () : void {
    def x = Attributes.A ();
    print ($"$(x.B)\n");
    print ($"$(x.H)\n");
    def x = N.A ();
    print ($"$(x.B)\n");
    print ($"$(x.H)\n");
    def f = typeof (Attributes.A).GetCustomAttributes (true);
    foreach (a in f) 
      when (a.ToString ().IndexOf ("Serialization") != -1)
            print ("Serialization\n");

    print ($"$(typeof(Attributes.A.I)) $(typeof(Attributes.A.J))\n");
    TestParts ();
    MergingInfaceAndTyparms.X.Run ();
    OtherTypes.Test.Run ();
  }
}

/*
BEGIN-OUTPUT
1
2
3
4
Serialization
Attributes.A+I Attributes.A+J
--------- test parts ------------
0
--------- test ifaces -----------
hello
add1
hello
END-OUTPUT
*/
