using Nemerle.IO;

class A { public this () {} }
class B : A {
  public this () {}
  public b () : void { printf ("b\n"); }
}
class C : A {
  public this () {}
  public c () : void { printf ("c\n"); }
}

module M {
  f (a : A) : void
  {
    match (a) {
      | (x is B) => x.b ()
      | (x is C) => x.c ()
      | _ => printf ("miss\n")
    }
  }

  g (c : C) : void
  {
    match (c) {
      | (_ : A) => ()
      | _ => () // W: unused
    }
  }

variant KU {
  | KA
  | KB { x : int; }
}
  
  public Main () : void
  {
    f (A ());
    f (B ());
    f (C ());

/*
//FIXME: it doesn't work!
    match (KA ()) {
      | KB (x) : KB => ()
      | _ => ()
    } 
*/    
    match (System.Exception ("d")) {
      | _ is System.SystemException => printf ("wrong!\n")
      | _ : System.Exception  => printf ("good!\n")
    }

    when (A () is A) // W: redundant
      printf ("ok\n");

    match (A()) {
      | _ : B => printf ("oops\n"); // W: deprecated
      | _ : C => printf ("oops\n"); // W: deprecated
      | _  => printf ("ok2\n");
    }
  }
}

/*
BEGIN-OUTPUT
miss
b
c
good!
ok
ok2
END-OUTPUT
*/
