/*
 * Initially these ants select a random direction. Then they will zig-zag in that 
 * direction until they find food. They will be marking their way home until the 
 * first rock they encounter. After they find food, they will roam randomly until 
 * they find the base or the home direction marker.
 */

module M {
  public Main () : void {
    def stmts = ants 
    {
      /* ------------------------------------------------------------------- */
      /* -- ANT ROLE DECIDER ----------------------------------------------- */
      /* ------------------------------------------------------------------- */
    
      /* check if this ant is one of the ants on the anthill's corners */
      vars (neighbours (6), {
        vars (rotations (6), {        
          label (ant_role_decider);

          if (rotations == 5)
            if (neighbours == 3)
              goto (corner_scout_ant);
            else
              if (neighbours == 4)
                goto (scout_ant);
              else
                goto (worker_ant);
          else
          {
            turn (right);
                    
            if (friend ^ front)
            {
              goto (neighbours = neighbours + 1, 
                    rotations = rotations + 1, 
                    ant_role_decider);
            }
            else
            {
              goto (rotations = rotations + 1, 
                    ant_role_decider);        
            }
          }
        })
      });

  
      /* ------------------------------------------------------------------- */
      /* -- CORNER SCOUT ANT ----------------------------------------------- */
      /* ------------------------------------------------------------------- */
      
      label (corner_scout_ant);      

      if (friend ^ front)
        goto (corner_scout_ant_initialize);
      else
      {
        turn (right);
        goto (corner_scout_ant);
      };


      /* -- CORNER SCOUT ANT: INITIALIZATION ------------------------------- */

      label (corner_scout_ant_initialize);
      
      turn (right);
      
      if (friend ^ front)
      {
        goto (corner_scout_ant_initialize);
      }
      else
      {
        turn (right);
        turn (right);
        goto (corner_scout_ant_mark_border);
      };


      /* -- CORNER SCOUT ANT: MARKING THE BORDER --------------------------- */

      vars (current_marker (3), {
        label (corner_scout_ant_mark_border);

        if (move) {
          if (current_marker == 0) {
            mark (0);
          } else if (current_marker == 1) {
            mark (1);
          } else {
            mark (2);
          };
          
          goto (current_marker = current_marker + 1, corner_scout_ant_mark_border);
        }
        else
          goto (corner_scout_ant_mark_border);      
      });


      /* ------------------------------------------------------------------- */
      /* -- SCOUT ANT ------------------------------------------------------ */
      /* ------------------------------------------------------------------- */

      label (scout_ant);

      if (friend ^ front)
        goto (scout_ant_initialize);
      else
      {
        turn (right);
        goto (scout_ant);
      };


      /* -- SCOUT ANT: INITIALIZATION -------------------------------------- */

      label (scout_ant_initialize);
      
      turn (right);
      
      if (friend ^ front)
      {
        goto (scout_ant_initialize);
      }
      else
      {
        turn (right);
        goto (scout_ant_kamikaze_run);
      };
      


      /* -- SCOUT ANT: KAMIKAZE RUN ---------------------------------------- */

      label (scout_ant_kamikaze_run);

      move;  // whenever move succeeeds jump
      goto (scout_ant_kamikaze_run);
      

      /* ------------------------------------------------------------------- */
      /* -- WORKER ANT ----------------------------------------------------- */
      /* ------------------------------------------------------------------- */
      
      label (worker_ant);
      
      /* store the approximate bearing to the anthill */
      vars (bearing (6), {
        label (initialize);

        /* this will divide the ants into a few armies, each marching
          in one of the six directions off from the anthill */

        if (move) {
          goto (scout_for_resources)
        }
        else {
          turn (right);
          goto (bearing = bearing + 1, initialize);
        };
              
        
        /* -- SCOUT FOR RESOURCES -------------------------------------------- */
        label (scout_for_resources);
        
        /* see if there's any food where we're standing */
        if (home ^ here)
        {
          // choose random direction
          if (rand (2)) turn (right) else turn (left);

          move;
          goto (scout_for_resources);
        }
        else {
          if (pickup) {
            /* if so, turn around and try getting home */
            turn (left);
            turn (left);
            turn (left);
                            
            goto (carry_food_home);
          }
          else {
            if (rock ^ front)
              turn (left);
            else
              if (food ^ left)
                turn (left);
              else
                if (food ^ right)
                  turn (right);
                else
                  if (rand (2))
                    turn (right)
                  else
                    turn (left);
            move;
            goto (scout_for_resources);
          }
        };
        
        
        /* -- CARRY FOOD HOME ------------------------------------------------ */
        
        label (carry_food_home);

        if (home ^ here)
        {
          drop;
          turn (right);
          turn (right);
          turn (right);
          goto (scout_for_resources);
        }
        else {
          when (rock ^ front)
            turn (right);
          move;
          goto (carry_food_home);
        };
      })
    };

    def cc = StmtCompiler (stmts);
    cc.Compile ();
    cc.Optimize ();
    cc.Output ();
  }
}
