/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: events.c,v 1.18 2009-08-01 09:23:55 anton Exp $ */

#include "netams.h"

const char *events[]= { "SYSTEM","ACCESS","LOGIN","QUOTA","BILLING","RADIUS",NULL };
pthread_mutex_t event_lock = PTHREAD_MUTEX_INITIALIZER;
FILE *event_file=NULL;
time_t event_load=0;

#define EVENT_DELAY   60      //delay between load into sql

void LogEvent(event_type event, oid uid, oid usid, oid aid, char const *fmt, ...){

	#if !defined(USE_MYSQL) && !defined(USE_POSTGRES) && !defined(USE_ORACLE)
                
//		aLog(D_ERR, "SQL feature is not compiled in!\n");
		return;
	#endif

	// find if we can write this event to somewhere
	// it must be first registered storage at processor
	Service *st=aStorageGetAccepted(ST_CONN_EVENTS);
	if (!st) return; // there are no suitable storages here

	char *filename="events.0";
	time_t now=time(NULL);
	va_list ap;

	netams_mutex_lock(&event_lock);

	if(!event_file) {
		event_file=fopen(filename,"a");
		if(!event_file) {
			aLog(D_ERR, "Can't create temporary file %s: %s\n", filename, strerror(errno));
			goto END;
		}
		setlinebuf(event_file);
	}

	//NOTE! There is should not be commas in fmt and aps
	va_start(ap, fmt);
	fprintf(event_file, "%lu,%s,%u,%u,%u,", now, events[event], uid, usid, aid);
	vfprintf(event_file, fmt, ap);
	fprintf(event_file, "\n");
	va_end(ap);

	if(event_file && event_load < now) {
		event_load+=EVENT_DELAY;
		fclose(event_file);
		((Service_Storage_Interface*)st)->SaveFile(filename,ST_CONN_EVENTS);
		event_file=NULL;
	}

END:
	netams_mutex_unlock(&event_lock);
}

