/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************
**/
/* $Id: layer7.c,v 1.18 2008-02-23 08:35:02 anton Exp $ */

#ifdef LAYER7_FILTER

#include "netams.h"
#include "ds_any.h"

/////////////////////////////////////////////////////////////////////////
void layer7_addinfo(u_int16_t port, entry *flow_entry){
		
	switch (htons(port)){
		case 80: 
		case 81: 
		case 8080: 
		case 8000: 
		case 3128: 
			{
			struct layer7_info_value *layer7_info = (struct layer7_info_value*)flow_entry->flow->put(ATTR_LAYER7_INFO);
			layer7_info->type= 1;
			layer7_info->value=NULL;
			flow_entry->layer7_info = layer7_info;
			}
	}
}
/////////////////////////////////////////////////////////////////////////
void layer7_checkinfo(u_int16_t port, entry *flow_entry, struct ip *ip){
	struct layer7_info_value *layer7_info = flow_entry->layer7_info;
	if (layer7_info && !layer7_info->value && ntohs(ip->ip_len)>50){
		struct tcphdr *th = (struct tcphdr *)((u_char *)ip + ip->ip_hl*4);
		int j=ip->ip_hl*4+th->th_off*4;
		char *http_data = j+(char*)ip;
			
		char *q1=strcasestr(http_data, "Host:");
		if (q1!=NULL) {
			char *q2=strchr(q1, '\n');
			if (q2!=NULL) {
				char q3[LAYER7_MAX_URL];
				j=q2-q1-6;
				if (j>LAYER7_MAX_URL) j=LAYER7_MAX_URL;
				else if (j<1) return;
				snprintf(q3, j, "%s", q1+6);
				layer7_info->value=set_string(q3);
			}
	
			q1=strcasestr(http_data, "GET ");
			if (q1!=NULL) {
				q2=strchr(q1+5, ' ');
				if (q2!=NULL) {
					char q3[LAYER7_MAX_URL];
					j=q2-q1-3;
					if (layer7_info->value) j+=strlen(layer7_info->value);
					if (j>LAYER7_MAX_URL) j=LAYER7_MAX_URL;
					else if (j<1) return;
					if (strncasecmp(q1, "GET http://", 11)) snprintf(q3, j, "%s%s",
						layer7_info->value?layer7_info->value:"", q1+4);
					else snprintf(q3, j>21?j-20:1, "%s", q1+11);
					if(layer7_info->value) aFree(layer7_info->value);
					layer7_info->value=set_string(q3);
				}
			}
		}
	}
}
/////////////////////////////////////////////////////////////////////////
void layer7_freeinfo(Flow *flow) {
	struct layer7_info_value *layer7_info = (struct layer7_info_value*)flow->get(ATTR_LAYER7_INFO);
	
	if(layer7_info && layer7_info->value) {
		aFree(layer7_info->value);
		layer7_info->value=NULL;
	}
}
/////////////////////////////////////////////////////////////////////////
#endif
