/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: security.c,v 1.59 2009-08-01 09:23:54 anton Exp $ */

#include "netams.h"
#include "ds_raw.h"

#ifdef HAVE_PAM
extern "C" {
	#include <security/pam_appl.h>
//	#include <security/pam_modules.h>
}
#endif

/////////////////////////////////////////////////////////////////////////////////////////
// Permissions Management ///////////////////////////////////////////////////////////////////

const char *permissions_list[256]; 

void aPermissionsInit(){

	for (unsigned i=0; i<=255; i++) permissions_list[i]=NULL;
	permissions_list[UPERM_NONE]="none";              
	permissions_list[UPERM_LOGIN_WEB]="weblogin";          
	permissions_list[UPERM_SHOWSTAT_HIS]="showstat_his";
	permissions_list[UPERM_SHOWOBJ_HIS]="showobj_his";      
	permissions_list[UPERM_MODIFYOBJ_HIS]="modifyobj_his";    
	permissions_list[UPERM_SHOWSTAT_ALL]="showstat";
	permissions_list[UPERM_SHOWOBJ_ALL]="showobj";          
	permissions_list[UPERM_SHOWCONFIG]="showconfig";       
	permissions_list[UPERM_RADIUS]="radius";       
	permissions_list[UPERM_MODIFYOBJ_ALL]="modifyobj";
	permissions_list[UPERM_MODIFYCONFIG]="modifyconfig";     
	permissions_list[UPERM_LOGIN_INT]="intlogin";        
	permissions_list[UPERM_SYSACTION]="sysaction";
	permissions_list[UPERM_ALL]="all";

#ifdef FREEBSD
#if defined (NETBSD)  || defined (MACOS)
#else
	crypt_set_format("md5");
#endif
#endif
}
//////////////////////////////////////////////////////////////////////////
char* CryptWord(char *s) {
	char *crypted;
	crypted = crypt(s, "$1$");
	return set_string(crypted);
}	
//////////////////////////////////////////////////////////////////////////
char *enable_password = NULL;

int cEnable		(struct cli_def *cli, const char *cmd, char **argv, int argc) {
	u_char no_flag;
	u_char i=0;
		
	no_flag = CLI_CHECK_NO(argv[i]);
	if(no_flag) {
		if(enable_password) aFree(enable_password);
		enable_password=NULL;
		return CLI_OK;
	}
 	i++;
 	
 	if (STRARG(argv[i], "crypted")) { 
		if(enable_password) aFree(enable_password);
		enable_password=set_string(argv[i+1]);
 	} else if (STRARG(argv[i], "password")) {
		if(enable_password) aFree(enable_password);
		enable_password=CryptWord(argv[i+1]);
	} else 
		return CLI_ERROR;
		
	cli_error(cli, "enable crypted set: %s", enable_password);
				
	return CLI_OK;		
}

int aEnable(char *s) {
	if(enable_password == NULL) return 1;
	int res=0;
	
	char *crypted=CryptWord(s);
	if (STREQ(enable_password, crypted))
		res = 1;
	aFree(crypted);
	
	return res;
}

//////////////////////////////////////////////////////////////////////////		
u_char aCheckPerm(Connection *conn, u_char perm){
	if (conn->permissions < perm) {
		aLog(D_WARN, "connection %u: not enough permissions\n", conn->id);
		return 1;
	}
	return 0;
}
//////////////////////////////////////////////////////////////////////////
int aAuth(char *login, char *password){
	User *u;
		
	if (!login || !password) return -1;
	
	u=Users->getUser(login);
	
	if (!u) return 0;
	
	int res=0;

#ifdef HAVE_PAM
	if (u->pam_auth) {
	    if ( aAuthPam(login,password) )
			res = u->permissions;
	    return res;
	}
#endif

	if (u->password) {
		char *c=CryptWord(password);
		if (STREQ(c, u->password))
			res = u->permissions;
		aFree(c);
	}

	return res;
}

#ifdef HAVE_PAM

static int password_conversation(int num_msg, const struct pam_message **msg, struct pam_response **resp, void *appdata_ptr)
{
    if (num_msg != 1 || msg[0]->msg_style != PAM_PROMPT_ECHO_OFF) 
	return PAM_CONV_ERR;

    if (!appdata_ptr) 
	return PAM_CONV_ERR;

    *resp = (pam_response*)calloc(num_msg, sizeof(struct pam_response));
    if (!*resp)
	return PAM_CONV_ERR;

    (*resp)[0].resp = strdup((char *) appdata_ptr);
    (*resp)[0].resp_retcode = 0;

    return ((*resp)[0].resp ? PAM_SUCCESS : PAM_CONV_ERR);
}

int aAuthPam(char *username, char *password){
	u_char permissions=0;

	if ( !username || !password )
	    return 0;
	    
	static struct pam_conv conv = {
		&password_conversation,
		NULL
	};
	conv.appdata_ptr = (char *) password;
	pam_handle_t *pamh=NULL;
	int retval;
    
	retval = pam_start("netams", username, &conv, &pamh);
	if (retval == PAM_SUCCESS)
		retval = pam_authenticate(pamh, 0);    /*   ? */
	else { aLog(D_INFO, "aAuthPam: pam_start fail\n"); goto END;}
	if (retval == PAM_SUCCESS)
		retval = pam_acct_mgmt(pamh, 0);       /*  ? */
	else {aLog(D_INFO, "aAuthPam: Auth for %s fail\n",username); goto END;}

	if (retval == PAM_SUCCESS)
		permissions=1;
	else
		aLog(D_INFO, "aAuthPam: Account for %s fail\n",username);
END:
	pam_end(pamh,retval);
	
    return permissions;
}
#endif

//////////////////////////////////////////////////////////////////////////
u_char cGetUnitAndPass(char *login,int b_login,NetUnit *&u,char *&password) {
	//if b_login password - account pasword u - first attached unit
	//	return 0 if account not found
	//else password - unit password u - unit
	//	return 0 if unit not found
#ifdef HAVE_BILLING
	if (b_login){
		Account *ac;
		ac = bAccounts->Get(login);
		if (ac) {
			u = ac -> bUroot -> u;
			password = ac -> password;
			return 1;
		}
	} else 
#endif	
	{
		u = Units -> getUnit(login);
		if (u){
			password = u -> password;
			return 1;
		}
	}
	return 0;	
}
//////////////////////////////////////////////////////////////////////////
int cRadius(struct cli_def *cli, const char *cmd, char **argv, int argc) {
	u_char i=1;

	char *login=NULL, *password=NULL, *nas_id=NULL, *callback_id=NULL;
	int billing_login=0;
	struct in_addr nas_ip; nas_ip.s_addr=INADDR_ANY;
	struct in_addr framed_ip; framed_ip.s_addr=INADDR_ANY;
	char *options=NULL;
	char buffer[32];
	
	for(i++; i< argc; i+=2)  {
		if (STRARG(argv[i],"account")) {
				billing_login=1;
				login=set_string(argv[i+1]);
 			} else if (STRARG(argv[i], "login")) { 
				billing_login=0;
				login=set_string(argv[i+1]);
			} else if (STRARG(argv[i], "password")) {
				password=set_string(argv[i+1]);
			} else if (STRARG(argv[i], "nas-id")) {
				nas_id=set_string(argv[i+1]);
			} else if (STRARG(argv[i], "nas-ip")) {
				inet_aton(argv[i+1], &nas_ip);
			} else if (STRARG(argv[i], "framed-ip")) {
				inet_aton(argv[i+1], &framed_ip);
			} else if (STRARG(argv[i], "callback-id")) {
				callback_id=set_string(argv[i+1]);
 			} else i--;
		}

	if (STRARG(argv[1], "auth")) {

		if (STREQ(argv[2], "nas") && login) {
			//NetUnit *u = Units->getUnit(login);
			NetUnit *u=NULL;
			char *u_pass=NULL;
			int fail=0; // can fail during callback_id checking
			if (cGetUnitAndPass(login, billing_login, u, u_pass)) {
			 if (u){
				if ( (u_pass==NULL && password==NULL ) ||
					STREQ(u_pass, password) ||
					(u_pass!=NULL && password==NULL ) ) {
						int num_options=0;
						struct ether_addr *ether_callback=NULL;
						if (callback_id) ether_callback=ether_aton(callback_id);
						 
						if (u->type==NETUNIT_USER) {
							NetUnit_user *us = (NetUnit_user*)u;
							if (us->ip.s_addr!=0) {
								num_options++;
								print_to_string(&options, "Framed-IP-Address: %s\n", inet_ntop(AF_INET, &(us->ip), buffer, 32));
							}
							if (callback_id && us->mac && ether_callback)
								if (memcmp(ether_callback, us->mac, sizeof(ether_addr))) fail=1;
							if (us->ip.s_addr!=0 && nas_ip.s_addr!=INADDR_ANY) {
								if ((nas_ip.s_addr&0x0000ffff) != (us->ip.s_addr&0x0000ffff)) fail=1;
							}
								
						}
						else if (u->type==NETUNIT_HOST) {
							NetUnit_host *uh = (NetUnit_host*)u;
							if (uh->ip.s_addr!=0) {
								num_options++;
								print_to_string(&options, "Framed-IP-Address: %s\n", inet_ntop(AF_INET, &(uh->ip), buffer, 32));
							}
							if (callback_id && uh->mac && ether_callback)
								if (memcmp(ether_callback, uh->mac, sizeof(ether_addr))) fail=1;
						}
						if (u->sys_policy != SP_NONE) fail = 1; /* http://www.netams.com/ubb/cgi-bin/ultimatebb.cgi?ubb=get_topic&f=3&t=000155 */
						if (u->fp!=NULL) {
							policy_data *cpd;
							for (cpd=u->fp->root; cpd!=NULL; cpd=cpd->next) {
								num_options++;
								print_to_string(&options, "Filter-ID: %06X %s\n", cpd->policy->id, cpd->policy->name?cpd->policy->name:"<\?\?>");
							}
						}
						if (u_pass!=NULL && password==NULL) {
							num_options++;
							print_to_string(&options, "User-Password: %s\n", u_pass);
						}
						// add Session-Timeout handler here
						
						if (fail) {
							cli_error(cli, "0 callback check failed for %s", login);
							LogEvent(RADIUS, u->id, 0, 0, "FAIL callback check for %s, nas-id %s callback-id %s", login, nas_id?nas_id:"<none>", callback_id?callback_id:"<none>");
							aLog(D_INFO, "RADIUS FAIL callback check for %s, nas-id %s callback-id %s\n", login, nas_id?nas_id:"<none>", callback_id?callback_id:"<none>");
						} else {
							cli_error(cli, "1 %d\n%s", num_options, options?options:"");
							LogEvent(RADIUS, u->id, 0, 0, "SUCCESS login %s nas-id %s callback-id %s", login, nas_id?nas_id:"<none>", callback_id?callback_id:"<none>");
							aLog(D_INFO, "RADIUS SUCCESS login %s nas-id %s callback-id %s\n", login, nas_id?nas_id:"<none>", callback_id?callback_id:"<none>");
						}
					} else { 
						cli_error(cli, "0 password incorrect for %s", login);
						LogEvent(RADIUS, u->id, 0, 0, "FAIL password incorrect for %s, nas-id %s callback-id %s", login, nas_id?nas_id:"<none>", callback_id?callback_id:"<none>");
						aLog(D_INFO, "RADIUS FAIL password incorrect for %s, nas-id %s callback-id %s\n", login, nas_id?nas_id:"<none>", callback_id?callback_id:"<none>");
					}
			 } else {
				cli_error(cli, "0 not units attached with account: %s", login);
				LogEvent(RADIUS, 0, 0, 0, "FAIL not units attached with account: %s", login);
				aLog(D_INFO, "RADIUS FAIL not units attached with account: %s\n", login);
			 }
			} else  {
				cli_error(cli, "0 login unknown: %s", login);
				LogEvent(RADIUS, 0, 0, 0, "FAIL login unknown: %s", login);
				aLog(D_INFO, "RADIUS FAIL login unknown: %s\n", login);
			}
		}
		else if (STREQ(argv[2], "web") && login) {
			User *uu = Users->getUser(login);
			char *u_pass=NULL;
			NetUnit *u=NULL;
			if (cGetUnitAndPass(login, billing_login, u, u_pass)) {
			//NetUnit *u = Units->getUnit(login);		
				if (u) {
					if ( (u_pass==NULL && (password==NULL) ) ||
						STREQ(u_pass, password)) {
							cli_error(cli, "1 0 pass unit %s", login);
						} else
							cli_error(cli, "0 web authorization password incorrect for unit: %s", login);
				} else cli_error(cli, "0 not units attached with account: %s", login);
			} else if (uu) {
				if ( aAuth(login, password)!=-1) {
					if (!uu->hidden && uu->permissions >= UPERM_SHOWSTAT_HIS)
						cli_error(cli, "1 0 pass user %s", login);
					else
						cli_error(cli, "0 user %s insufficient rights", login);
				}
				else
					cli_error(cli, "0 web authorization password incorrect for user: %s", login);
			}
			else
				cli_error(cli, "0 web authorization login is unknown: %s", login);
		}
		else
			cli_error(cli, "0 radius authorization source is unknown: %s", argv[2]);

	} 
	else if (STREQ(argv[1], "acct") && login) {
		pstat data; 
		Policy *p=NULL;
		i=3;
		bzero(&data, sizeof (pstat));
		NetUnit *u = Units->getUnit(login);
		if (!u) cli_error(cli, "0 radius accounting login is unknown: %s", login);
		else {
			for(i++; i< argc; i+=2)  {
		 		if (STRARG(argv[i], "in")) 
					data.in=bytesT2Q(argv[i+1]);
		 		else if (STRARG(argv[i], "out"))  
					data.out=bytesT2Q(argv[i+1]);
		 		else if (STRARG(argv[i], "policy"))  {
		 			i++;
					p=aParsePolicy(argv, &i);
		 			i-=2;
		 			}
		 		else i--;
			}
	
			aLog(D_INFO, "RADIUS ACCT (%s) for %s(%s)/%06X, nas-id %s, in %llu, out %llu\n", argv[2], login, framed_ip.s_addr!=INADDR_ANY?inet_ntoa(framed_ip):"no IP given", u->id, nas_id?nas_id:"<none>", data.in, data.out);
 			if (u->type==NETUNIT_USER) {
				if (STREQ(argv[2], "start") && framed_ip.s_addr!=INADDR_ANY) {
					aLog(D_INFO, "RADIUS ACCT (start) is setting IP for unit %s\n", login);
					// setting
					u->unit2trees(REMOVE);
					NetUnit_user *us = (NetUnit_user*)u;
					us->ip.s_addr=framed_ip.s_addr;
					u->unit2trees(ADD);
					}
				if (STREQ(argv[2], "stop")) {
					aLog(D_INFO, "RADIUS ACCT (stop) is clearing IP for unit %s\n", login);
					// clearing
					NetUnit_user *us = (NetUnit_user*)u;
					u->unit2trees(REMOVE);
					us->ip.s_addr=0;
				}
			}

			if (data.in>=0 && data.out>=0) {
				// update counters - send rawdata
				struct ds_raw_data raw;
				bzero(&raw, sizeof (struct ds_raw_data));
				raw.data_type=STREQ(argv[2], "start")?RAW_DATA_ASIS:RAW_DATA_INCREMENTAL;
				raw.u=u;
				raw.p=p;
				memcpy(&raw.data, &data, sizeof(pstat));
				cRawData_prepared(cli, &raw);
			}
		cli_error(cli, "1 radius accounting"); 
		}
	} 

	aFree(login); aFree(password); aFree(nas_id); aFree(callback_id); aFree(options);
	return CLI_OK;
}
//////////////////////////////////////////////////////////////////////////
int cPam(struct cli_def *cli, const char *cmd, char **param, int argc){

#ifndef HAVE_PAM
	cli_error(cli, "0 PAM not supported. Make NeTAMS with -HAVE_PAM");
#else
	char *password=NULL;
	char *p_password=NULL;
	char *p_name=NULL;
	char *p_resp=NULL;
	u_char i=2;
	u_char check_of_whom=0; // 1-unit; 2-user; 3-account; 4-login
	u_char check_ok=0;
	u_char syspolicy=0;


	for(;i<argc;i++){

		if (STREQ(param[i], "unit")){
			check_of_whom=1;
		}
		else if (STREQ(param[i], "user")){
			check_of_whom=2;
		}
		else if (STREQ(param[i], "account")){
			check_of_whom=3;
		}
		else if (STREQ(param[i], "login")){
			check_of_whom=4;
		}
		else if (STREQ(param[i], "syspolicy")){
			syspolicy=1;
		}
		else if (STREQ(param[i], "name")){
			p_name=set_string(param[i+1]);
			i++;
		}
		else if (STREQ(param[i], "password")){
			p_password=set_string(param[i+1]);
			i++;
		}
	}

#ifndef HAVE_BILLING
	if ( check_of_whom == 3 ) {
		cli_error(cli, "-1 Service Billing not supported. Make NeTAMS with -HAVE_BILLING");
		return CLI_OK;
	}
#endif

	if ( !p_name || !check_of_whom || 
		    !( STREQ(param[1], "auth") || STREQ(param[1], "acct")) ||
		     ( STREQ(param[1], "auth") && !p_password ) ) {

		cli_error(cli, "-1 Cmd error, use: PAM {auth | acct} {unit | user | account | login} name NAME [password PASS] [syspolicy]");
		return CLI_OK;
	}

	if ( check_of_whom == 1 || check_of_whom == 4 ) {	// unit or login

		NetUnit *u=NULL;
		u=Units -> getUnit(p_name);

		if ( u ) {
			if ( !syspolicy || u->sys_policy == SP_NONE  ) {
				if ( check_of_whom == 1 ) {
					check_ok=1;
					if ( STREQ(param[1], "auth") )
						password = u -> password;
				} else {			//login
					if( !Login )
						cli_error(cli, "-1 Service Login not active");
					else {
						if ( u->logindata ) {
							check_ok=1;
							if ( STREQ(param[1], "auth") )
								password = u -> logindata -> password;
						} else
							cli_error(cli, "0 login service is not running for that unit: %s", p_name);
					}
				}
			} else
				cli_error(cli, "-1 unit %s blocked sys_policy", p_name);
		} else
			cli_error(cli, "%d unit not exist: %s", check_of_whom==1?0:-1, p_name );
	}

	if ( check_of_whom == 2 ) {				//user
		User *u = Users->getUser(p_name);
		if (u) {
			check_ok=1;
			if ( STREQ(param[1], "auth") && u -> password )
				if ( STREQ(u -> password, CryptWord(p_password)) )
    				    password = p_password;
		} else
			cli_error(cli, "0 user not exist: %s", p_name);
	}

#ifdef HAVE_BILLING

	if ( check_of_whom == 3 ) {				//account

		Account *ac=NULL;
		ac = bAccounts->Get(p_name);

		if (ac) {

    		    if (ac->status&ACCOUNT_DELETED) //this account deleted
			cli_error(cli, "-1 PAM: account %s deleted", p_name);
		    else if ( syspolicy && ac->status&ACCOUNT_BLOCKED )
			cli_error(cli, "-1 PAM: account %s blocked", p_name);
		    else if ( syspolicy && ac->status&ACCOUNT_BEBLOCKED )
			cli_error(cli, "-1 PAM: account %s beblocked", p_name);
		    else {
			    check_ok=1;
			    if ( STREQ(param[1], "auth" ) ) 
				password = ac -> password;
		    }

		} else
			cli_error(cli, "0 account not exist: %s", p_name);
	}

#endif // BILLING

	aLog(D_INFO, "PAM_netams check %s %s %s\n",check_ok?"Ok":"Fail",param[2],p_name);
	
	if ( check_ok ) {

		if (STREQ(param[1], "acct"))
			cli_error(cli, "1 PAM: check Ok for %s %s",param[2],p_name);

		if (STREQ(param[1], "auth")) {

			if ( password && STREQ(password, p_password)) {
				cli_error(cli, "1 PAM: pass Ok for %s %s",param[2],p_name);
				aLog(D_INFO, "PAM_netams auth Ok: %s %s\n",param[2],p_name);
			} else {
				cli_error(cli, "0 PAM: pass Fail for %s %s",param[2],p_name);
				aLog(D_INFO, "PAM_netams auth Fail: %s name %s pass %s\n",param[2],p_name,p_password);
			}
		}
	}	

#endif // HAVE_PAM

return CLI_OK;

}
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
