/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 *
 * @author Jan Horvath
 */
@Entity
@Table(name = "issue")
@NamedQueries({@NamedQuery(name = "Issue.findByIssueId", query = "SELECT i FROM Issue i WHERE i.issueId = :issueId"), @NamedQuery(name = "Issue.findByIssueStatus", query = "SELECT i FROM Issue i WHERE i.issueStatus = :issueStatus"), @NamedQuery(name = "Issue.findByPriority", query = "SELECT i FROM Issue i WHERE i.priority = :priority"), @NamedQuery(name = "Issue.findByResolution", query = "SELECT i FROM Issue i WHERE i.resolution = :resolution"), @NamedQuery(name = "Issue.findByComponent", query = "SELECT i FROM Issue i WHERE i.component = :component"), @NamedQuery(name = "Issue.findByVersion", query = "SELECT i FROM Issue i WHERE i.version = :version"), @NamedQuery(name = "Issue.findByRepPlatform", query = "SELECT i FROM Issue i WHERE i.repPlatform = :repPlatform"), @NamedQuery(name = "Issue.findByAssignedTo", query = "SELECT i FROM Issue i WHERE i.assignedTo = :assignedTo"), @NamedQuery(name = "Issue.findByDeltaTs", query = "SELECT i FROM Issue i WHERE i.deltaTs = :deltaTs"), @NamedQuery(name = "Issue.findBySubcomponent", query = "SELECT i FROM Issue i WHERE i.subcomponent = :subcomponent"), @NamedQuery(name = "Issue.findByReporter", query = "SELECT i FROM Issue i WHERE i.reporter = :reporter"), @NamedQuery(name = "Issue.findByTargetMilestone", query = "SELECT i FROM Issue i WHERE i.targetMilestone = :targetMilestone"), @NamedQuery(name = "Issue.findByIssueType", query = "SELECT i FROM Issue i WHERE i.issueType = :issueType"), @NamedQuery(name = "Issue.findByCreationTs", query = "SELECT i FROM Issue i WHERE i.creationTs = :creationTs"), @NamedQuery(name = "Issue.findByQaContact", query = "SELECT i FROM Issue i WHERE i.qaContact = :qaContact"), @NamedQuery(name = "Issue.findByStatusWhiteboard", query = "SELECT i FROM Issue i WHERE i.statusWhiteboard = :statusWhiteboard"), @NamedQuery(name = "Issue.findByVotes", query = "SELECT i FROM Issue i WHERE i.votes = :votes"), @NamedQuery(name = "Issue.findByOpSys", query = "SELECT i FROM Issue i WHERE i.opSys = :opSys"), @NamedQuery(name = "Issue.findByShortDesc", query = "SELECT i FROM Issue i WHERE i.shortDesc = :shortDesc"), @NamedQuery(name = "Issue.findByKeyword", query = "SELECT i FROM Issue i WHERE i.keyword = :keyword"), @NamedQuery(name = "Issue.findByIssueFileLoc", query = "SELECT i FROM Issue i WHERE i.issueFileLoc = :issueFileLoc")})
public class Issue implements Serializable {
    @Id
    @Column(name = "ISSUE_ID", nullable = false)
    private Integer issueId;
    @Column(name = "ISSUE_STATUS")
    private String issueStatus;
    @Column(name = "PRIORITY")
    private String priority;
    @Column(name = "RESOLUTION")
    private String resolution;
    @Column(name = "COMPONENT")
    private String component;
    @Column(name = "VERSION")
    private String version;
    @Column(name = "REP_PLATFORM")
    private String repPlatform;
    @Column(name = "ASSIGNED_TO")
    private String assignedTo;
    @Column(name = "DELTA_TS")
    @Temporal(TemporalType.TIMESTAMP)
    private Date deltaTs;
    @Column(name = "SUBCOMPONENT")
    private String subcomponent;
    @Column(name = "REPORTER")
    private String reporter;
    @Column(name = "TARGET_MILESTONE")
    private String targetMilestone;
    @Column(name = "ISSUE_TYPE")
    private String issueType;
    @Column(name = "CREATION_TS")
    @Temporal(TemporalType.TIMESTAMP)
    private Date creationTs;
    @Column(name = "QA_CONTACT")
    private String qaContact;
    @Column(name = "STATUS_WHITEBOARD")
    private String statusWhiteboard;
    @Column(name = "VOTES")
    private Integer votes;
    @Column(name = "OP_SYS")
    private String opSys;
    @Column(name = "SHORT_DESC")
    private String shortDesc;
    @Column(name = "KEYWORD")
    private String keyword;
    @Column(name = "ISSUE_FILE_LOC")
    private String issueFileLoc;

    public Issue() {
    }

    public Issue(Integer issueId) {
        this.issueId = issueId;
    }

    public Integer getIssueId() {
        return issueId;
    }

    public void setIssueId(Integer issueId) {
        this.issueId = issueId;
    }

    public String getIssueStatus() {
        return issueStatus;
    }

    public void setIssueStatus(String issueStatus) {
        this.issueStatus = issueStatus;
    }

    public String getPriority() {
        return priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getResolution() {
        return resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getComponent() {
        return component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRepPlatform() {
        return repPlatform;
    }

    public void setRepPlatform(String repPlatform) {
        this.repPlatform = repPlatform;
    }

    public String getAssignedTo() {
        return assignedTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    public Date getDeltaTs() {
        return deltaTs;
    }

    public void setDeltaTs(Date deltaTs) {
        this.deltaTs = deltaTs;
    }

    public String getSubcomponent() {
        return subcomponent;
    }

    public void setSubcomponent(String subcomponent) {
        this.subcomponent = subcomponent;
    }

    public String getReporter() {
        return reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getTargetMilestone() {
        return targetMilestone;
    }

    public void setTargetMilestone(String targetMilestone) {
        this.targetMilestone = targetMilestone;
    }

    public String getIssueType() {
        return issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public Date getCreationTs() {
        return creationTs;
    }

    public void setCreationTs(Date creationTs) {
        this.creationTs = creationTs;
    }

    public String getQaContact() {
        return qaContact;
    }

    public void setQaContact(String qaContact) {
        this.qaContact = qaContact;
    }

    public String getStatusWhiteboard() {
        return statusWhiteboard;
    }

    public void setStatusWhiteboard(String statusWhiteboard) {
        this.statusWhiteboard = statusWhiteboard;
    }

    public Integer getVotes() {
        return votes;
    }

    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    public String getOpSys() {
        return opSys;
    }

    public void setOpSys(String opSys) {
        this.opSys = opSys;
    }

    public String getShortDesc() {
        return shortDesc;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getIssueFileLoc() {
        return issueFileLoc;
    }

    public void setIssueFileLoc(String issueFileLoc) {
        this.issueFileLoc = issueFileLoc;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (issueId != null
                  ? issueId.hashCode(): 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        /*
         * TODO: Warning - this method won't work in the case the id fields are not set
         */
        if (!(object instanceof Issue)) {
            return false;
        }
        Issue other = (Issue) object;
        if (this.issueId != other.issueId && (this.issueId == null || !this.issueId.equals(other.issueId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "test.Issue[issueId=" + issueId + "]";
    }

}
