/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.exceptions.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostPersist;
import javax.persistence.Table;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;

/**
 *
 * @author Jindrich Sedek
 */
@Entity
@Table(name = "MAPPING")
@NamedQueries({@NamedQuery(name = "Mapping.findByOldComponent", query = "SELECT m FROM Mapping m WHERE m.mappingPK.oldComponent = :oldComponent"),
@NamedQuery(name = "Mapping.findByOldSubcomponent", query = "SELECT m FROM Mapping m WHERE m.mappingPK.oldSubcomponent = :oldSubcomponent"),
@NamedQuery(name = "Mapping.findByOld", query = "SELECT m FROM Mapping m WHERE m.mappingPK.oldSubcomponent = :oldSubcomponent AND m.mappingPK.oldComponent = :oldComponent"),
@NamedQuery(name = "Mapping.findByNewComponent", query = "SELECT m FROM Mapping m WHERE m.newComponent = :newComponent"),
@NamedQuery(name = "Mapping.findByNewSubcomponent", query = "SELECT m FROM Mapping m WHERE m.newSubcomponent = :newSubcomponent")
})
public class Mapping implements Serializable {
    @EmbeddedId
    protected MappingPK mappingPK;
    @Column(name = "NEW_COMPONENT")
    private String newComponent;
    @Column(name = "NEW_SUBCOMPONENT")
    private String newSubcomponent;
    
    public Mapping() {
    }
    
    public Mapping(MappingPK mappingPK) {
        this.mappingPK = mappingPK;
    }
    
    public Mapping(String oldComponent, String oldSubcomponent) {
        this.mappingPK = new MappingPK(oldComponent, oldSubcomponent);
    }
    
    public MappingPK getMappingPK() {
        return mappingPK;
    }
    
    public void setMappingPK(MappingPK mappingPK) {
        this.mappingPK = mappingPK;
    }
    
    public String getNewComponent() {
        return newComponent;
    }
    
    public void setNewComponent(String newComponent) {
        this.newComponent = newComponent;
    }
    
    public String getNewSubcomponent() {
        return newSubcomponent;
    }
    
    public void setNewSubcomponent(String newSubcomponent) {
        this.newSubcomponent = newSubcomponent;
    }
    
    @Override
    public int hashCode() {
        int hash = 0;
        hash += (mappingPK != null ? mappingPK.hashCode() : 0);
        return hash;
    }
    
    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping) object;
        if (this.mappingPK != other.mappingPK && (this.mappingPK == null || !this.mappingPK.equals(other.mappingPK))) {
            return false;
        }
        return true;
    }
    
    @Override
    public String toString() {
        return "org.netbeans.modules.exceptions.entity.Mapping[mappingPK=" + mappingPK + "]";
    }
    
    @PostPersist
    public void updateComponents(){
        new Thread(new Runnable(){
            public void run() {
                PersistenceUtils utils = PersistenceUtils.getInstance();
                Map<String, Object> params = new HashMap<String, Object>(6);
                params.put("component", getNewComponent());
                params.put("subcomponent", getNewSubcomponent());
                params.put("oldcomponent", mappingPK.getOldComponent());
                params.put("oldsubcomponent", mappingPK.getOldSubcomponent());
                utils.updateComponents(params); 
                Logger.getLogger(Mapping.class.getName()).info("COMPONENTS CHANGED TO NEW MAPPING");//NOIA18
            }
        }).start();
    }
   
}
