/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.entity.Line;

/**
 *
 * @author Jan Horvath
 */
public class Utils {
    private static final String EXP = "[^0-9]*([0-9][0-9][0-9][0-9]*)[^0-9].*";
    private static final Pattern p = Pattern.compile(EXP);
    
    /**
     * 
     * @param line 
     * @return 
     */
    public static String formatStacktraceLine(Line line) {
        String methodName = line.getMethod().getName();
        Pattern pat = Pattern.compile("\\.");
        String[] items = pat.split(methodName);
        int i = items.length-2;
        if (i<0) i=0;
        StringBuffer fileName = new StringBuffer();
        int s = items[i].indexOf("$");
        if (s >= 0) {
            fileName.append(items[i].substring(0, s));
        } else {
            fileName.append(items[i]);
        }
        fileName.append(".java");     
        return "        at " + methodName + "(" + fileName + ":" + line.getLinePK().getLinenumber() + ")";
    }
    
    public static String getBuildNumber(String line) {        
        Matcher m = p.matcher(line);
        if (m.find()) return m.group(1);
        else return "0";
    }
    
    public static String getCustomBuildFormat(String line) {        
        if (line.length() == 12) return line.substring(2, 8);//daily build
        if (line.length() == 14) return line.substring(2, 8);//strange build number
        if (line.length() == 8) return line.substring(2);//continous build
        return line;
    }
    
    public static String getLatestBuildNumber(Exceptions e) {
        Collection<Exceptions> col = e.getExceptionsCollection();
        
        if ((col ==null) || (col.size() == 0)) return getBuildNumber(e.getProductversion());
        
        String max = getCustomBuildFormat(getBuildNumber(e.getProductversion()));
        for (Iterator<Exceptions> it = col.iterator(); it.hasNext();) {
            Exceptions dup = it.next();
            String dupBuild = getCustomBuildFormat(getBuildNumber(dup.getProductversion()));
            if (max.compareTo(dupBuild) < 0) {
                max = dupBuild;
            }
        }
        return max;
    }

}
