/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.php.rt.providers.impl.local;

import org.netbeans.modules.php.rt.providers.impl.*;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.netbeans.modules.php.rt.spi.providers.ProjectWizardComponent;
import org.openide.WizardDescriptor;

public class LocalWebServerPanel extends ProjectWizardComponent {

    private static final long serialVersionUID = -6833157747219113301L;

    public LocalWebServerPanel(Host host) {
        myHost = host;
        initComponents();

        init();
    }

    public void store(WizardDescriptor descriptor) {
        descriptor.putProperty(PROP_CONTEXT, myContextPath.getText());
    }

    public void read(WizardDescriptor settings) {
        String context = (String) settings.getProperty( PROP_CONTEXT );
        setDefaults(context);
    }

    public boolean isContentValid() {
        return true;
    }


    protected void contextUpdated() {
        if (getHost() instanceof HostImpl) {
            HostImpl host = (HostImpl) getHost();
            Object obj = host.getProperty(HostImpl.DOCUMENT_PATH);
            if (!(obj instanceof String)) {
                return;
            }
            String path = (String) obj;
            path = path.replace('/', File.separatorChar);
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - 1);
            }
            String context = myContextPath.getText();
            if (context != null) {
                context = context.replace('/', File.separatorChar);
            }
            if (!context.startsWith(File.separator)) {
                context = File.separator + context;
            }
            myDocumentPath.setText(path + context);
            myDocumentPath.setToolTipText(path + context);
        }
    }

    private void setDefaults(String context) {
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        myContextPath.setText(context);

        contextUpdated();
    }

    protected Host getHost() {
        return myHost;
    }

    protected JTextField getContextPath() {
        return myContextPath;
    }

    protected JTextField getDocumentPath() {
        return myDocumentPath;
    }

    protected JLabel getDocumentLabel() {
        return myDocumentPathLbl;
    }

    protected void init() {
        setDefaults(null);
        DocumentListener listener = new ContextListener();
        myContextPath.getDocument().addDocumentListener(listener);
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        myContextPathLbl = new javax.swing.JLabel();
        myContextPath = new javax.swing.JTextField();
        myDocumentPathLbl = new javax.swing.JLabel();
        myDocumentPath = new javax.swing.JTextField();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/php/rt/providers/impl/local/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(myContextPathLbl, bundle.getString("LBL_Context_Path")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myDocumentPathLbl, bundle.getString("LBL_Destination")); // NOI18N

        myDocumentPath.setEditable(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(myContextPathLbl)
                    .add(myDocumentPathLbl))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(myDocumentPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE)
                    .add(myContextPath, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myContextPathLbl)
                    .add(myContextPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myDocumentPathLbl)
                    .add(myDocumentPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        myContextPathLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalWebServerPanel.class, "A11_Context_PathLbl")); // NOI18N
        myContextPath.getAccessibleContext().setAccessibleDescription(bundle.getString("A11_Context_Path")); // NOI18N
        myDocumentPathLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalWebServerPanel.class, "A11_DestinationLbl")); // NOI18N
        myDocumentPath.getAccessibleContext().setAccessibleDescription(bundle.getString("A11_Destination")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    /*static boolean isValidName(String fileName){
    try {
    boolean bValid = true;
    File tempFile =  new File(fileName);
    String tempFileName =0+fileName;
    File actualTempFile = File.createTempFile(tempFileName, null);
    if (!FileUtil.normalizeFile(tempFile).equals(tempFile.getCanonicalFile())) {
    bValid = false;
    }
    actualTempFile.delete();
    actualTempFile = null;
    tempFile = null;
    return bValid;
    }catch (Exception e) {
    return false;
    }
    }*/

    private class ContextListener implements DocumentListener {

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
         */
        public void changedUpdate(DocumentEvent arg0) {
            contextUpdated();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
         */
        public void insertUpdate(DocumentEvent arg0) {
            contextUpdated();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
         */
        public void removeUpdate(DocumentEvent arg0) {
            contextUpdated();
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField myContextPath;
    private javax.swing.JLabel myContextPathLbl;
    private javax.swing.JTextField myDocumentPath;
    private javax.swing.JLabel myDocumentPathLbl;
    // End of variables declaration//GEN-END:variables

    private Host myHost;
}
