/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.project;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.netbeans.modules.php.rt.spi.providers.WebServerProvider;
import org.netbeans.modules.php.rt.utils.PhpProjectUtils;
import org.openide.filesystems.FileObject;


/**
 * @author ads
 *
 */
public final class Utils {

    // avoid instantiation
    private Utils() {
    }

    public static SourceGroup[] getSourceGroups(Project phpProject) {
        return PhpProjectUtils.getSourceGroups(phpProject);
    }
    public static FileObject[] getSourceObjects(Project phpProject) {
        return PhpProjectUtils.getSourceObjects(phpProject);
    }

    /*
     * TODO : realize command line execution property as fake WebServerProvider.
     * This provider should not appear as registered service ( so
     * method WebServerProvider.ServerFactory.getProviders() doesn't get
     * it as member of array ). Only this method #getProvider() knows
     * about existance additional "command line provider".
     * It will allow to  have common approach with actions execution
     * and other aspects of project.
     */
    public static WebServerProvider getProvider(PhpProject project) {
        String provider = project.getEvaluator().getProperty(PhpProject.PROVIDER_ID);
        if (provider == null) {
            return null;
        }
        WebServerProvider[] providers = WebServerProvider.ServerFactory.getProviders();
        for (WebServerProvider prov : providers) {
            if (prov.getClass().getCanonicalName().equals(provider)) {
                return prov;
            }
        }
        return null;
    }

    public static Host findHostById(String hostId) {
        Host host = null;
        WebServerProvider[] providers = WebServerProvider.ServerFactory.getProviders();
        List<Host> ret = new LinkedList<Host>();
        for (WebServerProvider provider : providers) {
            host = provider.findHost(hostId);
            if (host != null) {
                break;
            }
        }
        return host;
    }
}