/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model;


/**
 * <pre>
 * &lt;xs:element name="result-document" substitutionGroup="xsl:instruction">
 *      &lt;xs:complexType>
 *          &lt;xs:complexContent mixed="true">
 *              &lt;xs:extension base="xsl:sequence-constructor">
 *                  &lt;xs:attribute name="format" type="xsl:avt"/>
 *                  &lt;xs:attribute name="href" type="xsl:avt"/>
 *                  &lt;xs:attribute name="type" type="xsl:QName"/>
 *                  &lt;xs:attribute name="validation" type="xsl:validation-type"/>
 *                  &lt;xs:attribute name="method" type="xsl:avt"/>
 *                  &lt;xs:attribute name="byte-order-mark" type="xsl:avt"/>
 *                  &lt;xs:attribute name="cdata-section-elements" type="xsl:avt"/>
 *                  &lt;xs:attribute name="doctype-public" type="xsl:avt"/>
 *                  &lt;xs:attribute name="doctype-system" type="xsl:avt"/>
 *                  &lt;xs:attribute name="encoding" type="xsl:avt"/>
 *                  &lt;xs:attribute name="escape-uri-attributes" type="xsl:avt"/>
 *                  &lt;xs:attribute name="include-content-type" type="xsl:avt"/>
 *                  &lt;xs:attribute name="indent" type="xsl:avt"/>
 *                  &lt;xs:attribute name="media-type" type="xsl:avt"/>
 *                  &lt;xs:attribute name="normalization-form" type="xsl:avt"/>
 *                  &lt;xs:attribute name="omit-xml-declaration" type="xsl:avt"/>
 *                  &lt;xs:attribute name="standalone" type="xsl:avt"/>
 *                  &lt;xs:attribute name="undeclare-prefixes" type="xsl:avt"/>
 *                  &lt;xs:attribute name="use-character-maps" type="xsl:QNames"/>
 *                  &lt;xs:attribute name="output-version" type="xsl:avt"/>
 *              &lt;/xs:extension>
 *          &lt;/xs:complexContent>
 *      &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 * @author ads
 *
 */
public interface ResultDocument extends Instruction, SequenceConstructor, TypeSpec, 
    ValidationSpec, UseCharacterMapsSpec, FormatSpec
{
    String STANDALONE                   = Output.STANDALONE;
    
    String UNDECLARE_PREFIXES           = Output.UNDECLARE_PREFIXES; 
    
    String HREF                         = XslModelReference.HREF;
    
    String METHOD                       = Output.METHOD;
    
    String INDENT                       = Output.INDENT;
    
    String ENCODING                     = Output.ENCODING;
    
    String BYTE_ORDER_MARK              = Output.BYTE_ORDER_MARK;
    
    String CDATA_SECTION_ELEMENTS       = Output.CDATA_SECTION_ELEMENTS;
    
    String DOCTYPE_PUBLIC               = Output.DOCTYPE_PUBLIC;
    
    String DOCTYPE_SYSTEM               = Output.DOCTYPE_SYSTEM;
    
    String ESCAPE_URI_ATTRIBUTES        = Output.ESCAPE_URI_ATTRIBUTES; 
    
    String INCLUDE_CONTENT_TYPE         = Output.INCLUDE_CONTENT_TYPE;
    
    String MEDIA_TYPE                   = Output.MEDIA_TYPE;
    
    String NORMALIZATION_FORM           = Output.NORMALIZATION_FORM;
    
    String OMIT_XML_DECLARATION         = Output.OMIT_XML_DECLARATION;
    
    String OUTPUT_VERSION               = "output-version";          // NOI18N
    
    /**
     * @return "standalone" attribute value
     */
    AttributeValueTemplate getStandalone();
    
    /**
     * Set "standalone" attribute value.
     * @param avt new value
     */
    void setStandalone( AttributeValueTemplate avt );
    
    /**
     * @return "undeclare-prefixes" attribute value
     */
    AttributeValueTemplate getUndeclarePrefixes();
    
    /**
     * Set "undeclare-prefixes" attribute value. 
     * @param avt new value
     */
    void setUndeclarePrefixes( AttributeValueTemplate avt );
    
    /**
     * @return "href" attribute value
     */
    AttributeValueTemplate getHref();
    
    /**
     * Set "href" attribute value. 
     * @param avt new value
     */
    void setHref( AttributeValueTemplate avt );
    
    /**
     * @return "method" attribute value
     */
    AttributeValueTemplate getMethod();
    
    /**
     * Set "method" attribute value. 
     * @param avt new value
     */
    void setMethod( AttributeValueTemplate avt );
    
    /**
     * @return "indent" attribute value
     */
    AttributeValueTemplate getIndent();
    
    /**
     * Set "indent" attribute value. 
     * @param avt new value
     */
    void setIndent( AttributeValueTemplate avt );
    
    /**
     * @return "encoding" attribute value
     */
    AttributeValueTemplate getEncoding();
    
    /**
     * Set "encoding" attribute value. 
     * @param avt new value
     */
    void setEncoding( AttributeValueTemplate avt );
    
}
