/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.qa.form;

import javax.swing.JDialog;
import org.netbeans.jemmy.operators.*;

/**
 * Class implementing all necessary methods for handling "Select Palette Category" NbDialog.
 * Most parts of code are generated by jelly tools.* 
 *
 * @author Jiri Vagner
 */
public class SelectPaletteCategoryOperator extends JDialogOperator {

    private JLabelOperator _lblPaletteCategories;
    private JListOperator _lstPaletteCategories;
    public static final String ITEM_SWINGCONTAINERS = "Swing Containers"; // NOI18N
    public static final String ITEM_SWINGCONTROLS = "Swing Controls"; // NOI18N
    public static final String ITEM_SWINGMENUS = "Swing Menus"; // NOI18N
    public static final String ITEM_SWINGWINDOWS = "Swing Windows"; // NOI18N
    public static final String ITEM_AWT = "AWT"; // NOI18N
    public static final String ITEM_BORDERS = "Borders"; // NOI18N
    public static final String ITEM_BEANS = "Beans"; // NOI18N
    public static final String ITEM_LOOKANDFEELS = "Look and Feels"; // NOI18N
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;

    /** Creates new SelectPaletteCategory that can handle it.
     */
    public SelectPaletteCategoryOperator() {
        super("Select Palette Category"); // NOI18N
    }
    
    /**
     * Creates new SelectPaletteCategory using title name
     * @param title
     */
    public SelectPaletteCategoryOperator(String title) {
        super(title);
    }
    
    /**
     * Creates new instance using existing JDialog operator
     * @param wrapper 
     */
    public SelectPaletteCategoryOperator(JDialogOperator wrapper) {
        super((JDialog)wrapper.getSource());
    }

    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Palette Categories:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblPaletteCategories() {
        if (_lblPaletteCategories==null) {
            _lblPaletteCategories = new JLabelOperator(this, "Palette Categories:");  // NOI18N
        }
        return _lblPaletteCategories;
    }

    /** Tries to find null ListView$NbList in this dialog.
     * @return JListOperator
     */
    public JListOperator lstPaletteCategories() {
        if (_lstPaletteCategories==null) {
            _lstPaletteCategories = new JListOperator(this);
        }
        return _lstPaletteCategories;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, "OK"); // NOI18N
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, "Cancel"); // NOI18N
        }
        return _btCancel;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** clicks on "OK" JButton
     */
    public void ok() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of SelectPaletteCategory by accessing all its components.
     */
    public void verify() {
        lblPaletteCategories();
        lstPaletteCategories();
        btOK();
        btCancel();
    }
}

