/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.openide.text.CloneableEditorSupport;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBConnectionFactory;
import org.netbeans.modules.db.dataview.meta.DBMetaDataFactory;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

/**
 *
 * @author Nithya Radhakrishanan
 * @author Ahimanikya Satapathy
 *
 */
class InsertRecordDialog extends javax.swing.JDialog {

    private final DataView dataView;

    /** Creates new form InsertRecordDialog */
    public InsertRecordDialog(DataView dataView) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.dataView = dataView;
        initComponents();
        addInputFields();

        colValueTextField[0].requestFocus();

        jSplitPane1.setBottomComponent(null);

        KeyStroke escape = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
        Action escapeAction = new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        };
        getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE"); // NOI18N
        getRootPane().getActionMap().put("ESCAPE", escapeAction); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked") // NOI18N
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jTextArea1 = new javax.swing.JTextArea();
        jPanel4 = new javax.swing.JPanel();
        executeBtn = new javax.swing.JButton();
        previewBtn = new javax.swing.JButton();
        clearBtn = new javax.swing.JButton();
        cancelBtn = new javax.swing.JButton();
        jSplitPane1 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jEditorPane1 = new javax.swing.JEditorPane();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.title")); // NOI18N
        setModal(true);
        setResizable(false);

        jPanel1.setFont(jPanel1.getFont());
        jPanel1.setPreferredSize(new java.awt.Dimension(550, 450));
        jPanel1.setRequestFocusEnabled(false);
        jPanel1.setLayout(new java.awt.BorderLayout());

        jTextArea1.setBackground(javax.swing.UIManager.getDefaults().getColor("Label.background"));
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setFont(jTextArea1.getFont());
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(3);
        jTextArea1.setText(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.jTextArea1.text")); // NOI18N
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setAutoscrolls(false);
        jTextArea1.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel1.add(jTextArea1, java.awt.BorderLayout.NORTH);
        jTextArea1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "insertRecodrDialog.jTextArea")); // NOI18N
        jTextArea1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "insertRecord.textarea.desc")); // NOI18N

        jPanel4.setFont(jPanel4.getFont());
        jPanel4.setPreferredSize(new java.awt.Dimension(520, 33));
        jPanel4.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        executeBtn.setFont(executeBtn.getFont());
        executeBtn.setMnemonic('O');
        executeBtn.setText(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.executeBtn.text")); // NOI18N
        executeBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                executeBtnActionPerformed(evt);
            }
        });
        jPanel4.add(executeBtn);
        executeBtn.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.executeBtn.text")); // NOI18N
        executeBtn.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.executeBtn.text")); // NOI18N

        previewBtn.setFont(previewBtn.getFont());
        previewBtn.setMnemonic('S');
        previewBtn.setText(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.previewBtn.text")); // NOI18N
        previewBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                previewBtnActionPerformed(evt);
            }
        });
        jPanel4.add(previewBtn);
        previewBtn.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.previewBtn.text")); // NOI18N
        previewBtn.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.previewBtn.text")); // NOI18N

        clearBtn.setFont(clearBtn.getFont());
        clearBtn.setMnemonic('L');
        clearBtn.setText(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.clearBtn.text")); // NOI18N
        clearBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearBtnActionPerformed(evt);
            }
        });
        jPanel4.add(clearBtn);
        clearBtn.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.clearBtn.text")); // NOI18N
        clearBtn.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.clearBtn.text")); // NOI18N

        cancelBtn.setFont(cancelBtn.getFont());
        cancelBtn.setMnemonic('C');
        cancelBtn.setText(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.cancelBtn.text")); // NOI18N
        cancelBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBtnActionPerformed(evt);
            }
        });
        jPanel4.add(cancelBtn);
        cancelBtn.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.cancelBtn.text")); // NOI18N
        cancelBtn.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.cancelBtn.text")); // NOI18N

        jPanel1.add(jPanel4, java.awt.BorderLayout.SOUTH);

        jSplitPane1.setDividerLocation(250);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setLastDividerLocation(250);
        jSplitPane1.setRequestFocusEnabled(false);

        jScrollPane1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(204, 204, 255)));
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setFont(jScrollPane1.getFont());

        jPanel3.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setForeground(new java.awt.Color(204, 204, 255));
        jPanel3.setFont(jPanel3.getFont().deriveFont(jPanel3.getFont().getSize()+1f));
        jPanel3.setLayout(new java.awt.GridBagLayout());
        jScrollPane1.setViewportView(jPanel3);

        jSplitPane1.setTopComponent(jScrollPane1);

        jScrollPane2.setFont(jScrollPane2.getFont());

        jEditorPane1.setContentType(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.jEditorPane1.contentType")); // NOI18N
        jEditorPane1.setEditable(false);
        jEditorPane1.setEditorKit(CloneableEditorSupport.getEditorKit("text/x-sql"));
        jEditorPane1.setFont(jEditorPane1.getFont());
        jEditorPane1.setToolTipText(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.jEditorPane1.toolTipText")); // NOI18N
        jEditorPane1.setOpaque(false);
        jScrollPane2.setViewportView(jEditorPane1);
        jEditorPane1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecord.JEditorpane.AccessibleName")); // NOI18N
        jEditorPane1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.jEditorPane1.AccessibleContext.accessibleDescription")); // NOI18N

        jSplitPane1.setBottomComponent(jScrollPane2);

        jPanel1.add(jSplitPane1, java.awt.BorderLayout.CENTER);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.AccessibleContext.accessibleDescription")); // NOI18N
        getAccessibleContext().setAccessibleParent(null);

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void cancelBtnActionPerformed(java.awt.event.ActionEvent evt) {
    dispose();
}

private void executeBtnActionPerformed(java.awt.event.ActionEvent evt) {
    String[] insertSQL = null;
    try {
        Object[] insertedRow = getInsertValues();

        SQLStatementGenerator stmtBldr = dataView.getSQLStatementGenerator();
        insertSQL = stmtBldr.generateInsertStatement(insertedRow);
        SQLExecutionHelper execHelper = dataView.getSQLExecutionHelper();
        execHelper.executeInsertRow(insertSQL, insertedRow);
    } catch (DBException ex) {
        if (jSplitPane1.getBottomComponent() == null) {
            jSplitPane1.setDividerLocation(250);
            jSplitPane1.setBottomComponent(jScrollPane2);
            previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class,"LBL_hide_sql"));
        }
        jEditorPane1.setForeground(Color.red);
        jEditorPane1.setContentType("text/plain"); // NOI18N
        jEditorPane1.setText(ex.getMessage());

        return;
    }
    dispose();
}

private void clearBtnActionPerformed(java.awt.event.ActionEvent evt) {
    int rows = dataView.getDataViewDBTable().getColumnCount();
    for (int i = 0; i < rows; i++) {
        if (dataView.getDataViewDBTable().getColumn(i).isGenerated()) {
            colValueTextField[i].setText("<GENERATED>"); // NOI18N
            colValueTextField[i].setEditable(false);
        } else {
            colValueTextField[i].setText(""); // NOI18N
            colValueTextField[i].setEditable(true);
        }
    }
    refreshSQL();
}

private void previewBtnActionPerformed(java.awt.event.ActionEvent evt) {
    if (evt.getActionCommand().equalsIgnoreCase(NbBundle.getMessage(InsertRecordDialog.class,"LBL_show_sql"))) {
        jSplitPane1.setDividerLocation(250);
        jSplitPane1.setBottomComponent(jScrollPane2);
        refreshSQL();
        previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class,"LBL_hide_sql"));
    } else {
        jSplitPane1.setBottomComponent(null);
        previewBtn.setText(NbBundle.getMessage(InsertRecordDialog.class,"LBL_show_sql"));
    }
}

    private void refreshSQL() {
        try {
            if (jSplitPane1.getBottomComponent() != null) {
                SQLStatementGenerator stmtBldr = dataView.getSQLStatementGenerator();
                String sql = stmtBldr.generateInsertStatement(getInsertValues())[1];
                jEditorPane1.setContentType("text/x-sql"); // NOI18N
                jEditorPane1.setText(sql);
            }
        } catch (DBException ex) {
            jEditorPane1.setContentType("text/plain"); // NOI18N
            jEditorPane1.setForeground(Color.red);
            jEditorPane1.setText(ex.getMessage());
            return;
        }
    }
    JTextField[] colValueTextField;

    private void addInputFields() {
        Connection conn = DBConnectionFactory.getInstance().getConnection(dataView.getDatabaseConnection());
        Map<Integer, String> typeInfo = Collections.emptyMap();
        try {
            if(conn != null) {
                DBMetaDataFactory dbMeta = new DBMetaDataFactory(conn);
                typeInfo = dbMeta.buildDBSpecificDatatypeMap();
            } 
        } catch (SQLException ex) {
            // ignore
        }
        
        int rows = dataView.getDataViewDBTable().getColumnCount();
        JLabel[] colNameLabel = new JLabel[rows];
        JLabel[] colDataType = new JLabel[rows];
        colValueTextField = new JTextField[rows];
        GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        int gridx = 0;
        int gridy = 0;
        int bottom = 5;
        int right = 10;
        for (int i = 0; i < rows; i++) {
            final DBColumn col = dataView.getDataViewDBTable().getColumn(i);
            colNameLabel[i] = new JLabel();
            colNameLabel[i].setText(col.getName());

            colNameLabel[i].setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
            colNameLabel[i].setPreferredSize(new java.awt.Dimension(120, 20));
            colNameLabel[i].setFont(colNameLabel[i].getFont()); // NOI18N
            colNameLabel[i].getAccessibleContext().setAccessibleName(colNameLabel[i].getName());
            colNameLabel[i].getAccessibleContext().setAccessibleDescription(colNameLabel[i].getName());
            
            gridBagConstraints.gridx = gridx;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, bottom, right);
            jPanel3.add(colNameLabel[i], gridBagConstraints);

            colValueTextField[i] = new JTextField();

            addColValueChangeListeners(i, col);

            colValueTextField[i].setText("");
            colValueTextField[i].setToolTipText(DataViewUtils.getColumnToolTip(col));
            colValueTextField[i].setHorizontalAlignment(javax.swing.JTextField.LEFT);
            colValueTextField[i].setMinimumSize(new java.awt.Dimension(250, 20));
            colValueTextField[i].setPreferredSize(new java.awt.Dimension(250, 20));
            colValueTextField[i].getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecordDialog.AccessibleContext.accessibleName"));
            colValueTextField[i].getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(InsertRecordDialog.class, "InsertRecord.JTextField.AccessibleDescription"));

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = gridx + 2;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, bottom, right);
            jPanel3.add(colValueTextField[i], gridBagConstraints);

            if (col.isGenerated()) {
                colValueTextField[i].setText("<GENERATED>"); // NOI18N
                colValueTextField[i].setEditable(false);
            }

            colDataType[i] = new JLabel();
            colDataType[i].setPreferredSize(new java.awt.Dimension(90, 20));
            colDataType[i].setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
            colDataType[i].setFont(colDataType[i].getFont()); // NOI18N
            colDataType[i].getAccessibleContext().setAccessibleName(colDataType[i].getName());
            colDataType[i].getAccessibleContext().setAccessibleDescription(colDataType[i].getName());
            Integer typeInt = new Integer(col.getJdbcType());
            String typeName = typeInfo.containsKey(typeInt) ? typeInfo.get(typeInt) : DataViewUtils.getStdSqlType(col.getJdbcType());

            colDataType[i].setText(typeName);
            colDataType[i].setDisplayedMnemonicIndex(-1);
           
            colNameLabel[i].setLabelFor(colValueTextField[i]);
            colDataType[i].setLabelFor(colValueTextField[i]);

            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = gridx + 4;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, bottom, right);
            jPanel3.add(colDataType[i], gridBagConstraints);

            gridy = gridy + 2;
        }
    }

    private void addColValueChangeListeners(int i, final DBColumn col) {
        final int index = i;
        colValueTextField[i].addKeyListener(new KeyListener() {

            public void keyTyped(KeyEvent ke) {
            }

            public void keyPressed(KeyEvent ke) {
                if (ke.isControlDown() && ke.getKeyChar() == KeyEvent.VK_0) {
                    if (col.isGenerated() || !col.isNullable()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (colValueTextField[index].isEditable()) {
                        colValueTextField[index].setText("<NULL>"); // NOI18N
                        colValueTextField[index].setEditable(false);
                    } else if (!colValueTextField[index].isEditable()) {
                        colValueTextField[index].setText(""); // NOI18N
                        colValueTextField[index].setEditable(true);
                    }
                }
            }

            public void keyReleased(KeyEvent ke) {
                refreshSQL();
            }
        });

        colValueTextField[i].addMouseListener(new MouseListener() {

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    if (col.isGenerated() || !col.isNullable()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else if (!colValueTextField[index].isEditable()) {
                        colValueTextField[index].setText(""); // NOI18N
                        colValueTextField[index].setEditable(true);
                        colValueTextField[index].requestFocus();
                    }
                }
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }
        });
    }

    private Object[] getInsertValues() throws DBException {
        Object[] insertData = new Object[colValueTextField.length];
        for (int i = 0; i < colValueTextField.length; i++) {
            JTextField textField = colValueTextField[i];
            DBColumn col = dataView.getDataViewDBTable().getColumn(i);
            Object val;
            if ((col.isNullable() || col.isGenerated()) && !textField.isEditable()) {
                val = null;
            } else {
                val = DBReadWriteHelper.validate(textField.getText(), col);
            }
            insertData[i] = val;
        }
        return insertData;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelBtn;
    private javax.swing.JButton clearBtn;
    private javax.swing.JButton executeBtn;
    private javax.swing.JEditorPane jEditorPane1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JButton previewBtn;
    // End of variables declaration//GEN-END:variables
}
