/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2008 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.junit.output;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.actions.SystemAction;

/**
 *
 * @author Marian Petras
 */
final class CallstackFrameNode extends AbstractNode {

    /** */
    private Report.Trouble trouble;
    /** */
    private String frameInfo;
    
    /**
     * Creates a node for a call stack frame.
     * @param  frameInfo  string specifying the call stack frame
     */
    CallstackFrameNode(String frameInfo) {
        this(null, frameInfo, "at " + frameInfo);                       //NOI18N
    }
    
    /**
     * Creates a node representing a failure/error or its message.
     * @param  trouble  the failure or error
     * @param  displayName  requested display name of this node
     */
    CallstackFrameNode(Report.Trouble trouble,
                       String displayName) {
        this(trouble, null, displayName);
    }

    /**
     * Creates a new instance of CallstackFrameNode
     *
     * @param  frameInfo  line of a callstack, e.g. <code>foo.bar.Baz:314</code>
     * @param  displayName  display name for the node, or <code>null</code>
     *                      to use the default display name for the given
     *                      callstack frame info
     */
    private CallstackFrameNode(final Report.Trouble trouble,
                               final String frameInfo,
                               final String displayName) {
        super(Children.LEAF);
        setDisplayName(displayName);
        setIconBaseWithExtension(
                "org/netbeans/modules/junit/output/res/empty.gif");     //NOI18N

        this.trouble = trouble;
        this.frameInfo = frameInfo;
    }

    /**
     */
    @Override
    public Action getPreferredAction() {
        if (frameInfo != null) {
            return new JumpAction(this, frameInfo);
        } else {
            assert trouble != null;
            return new JumpAction(this, trouble);
        }
    }
    
    @Override
    public SystemAction[] getActions(boolean context) {
        return new SystemAction[0];
    }
}
