# Why Netdata

> Any performance monitoring solution that does not go down to per second
> collection and visualization of the data, is useless.
> It will make you happy to have it, but it will not help you more than that. 

Netdata is built around 4 principles:

1. **[Per second data collection for all metrics.](1s-granularity.md)**

    *It is impossible to monitor a 2 second SLA, with 10 second metrics.*

2. **[Collect and visualize all the metrics from all possible sources.](unlimited-metrics.md)**

    *To troubleshoot slowdowns, we need all the available metrics. The console should not provide more metrics.*

3. **[Meaningful presentation, optimized for visual anomaly detection.](meaningful-presentation.md)**

    *Metrics are a lot more than name-value pairs over time. The monitoring tool should know all the metrics. Users should not!*

4. **[Immediate results, just install and use.](immediate-results.md)**

    *Most of our infrastructure is standardized. There is no point to configure everything metric by metric.*

Unlike other monitoring solutions that focus on metrics visualization,
Netdata's helps us troubleshoot slowdowns without touching the console.

So, everything is a bit different.

[![analytics](https://www.google-analytics.com/collect?v=1&aip=1&t=pageview&_s=1&ds=github&dr=https%3A%2F%2Fgithub.com%2Fnetdata%2Fnetdata&dl=https%3A%2F%2Fmy-netdata.io%2Fgithub%2Fdocs%2FWhy-Netdata&_u=MAC~&cid=5792dfd7-8dc4-476b-af31-da2fdb9f93d2&tid=UA-64295674-3)]()
