/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_snap_h
#define __nd_snap_h

#include <netdude/nd_types.h>
#include <netdude/nd_gettext.h>
#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_protocol.h>
#include <netdude/nd_gui.h>

#include "nd_proto_snap.h"

extern ND_MenuData snap_menu_type_data[]; /* See nd_snap.c */

/* These are the implementations for Ethernet of ND_Protocol's callbacks: */
GtkWidget *nd_snap_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
void       nd_snap_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
void       nd_snap_init_packet(ND_Packet *packet, guchar *data, guchar *data_end);
gboolean   nd_snap_header_complete(const ND_Packet *packet, guint nesting);

/* Generic accessor function for the Ethernet Protocol implementation: */
ND_Protocol *nd_snap_get(void);

/* Helper functions to set a trace's Ethernet GUI table to a packet's content: */
void       nd_snap_set_gui_ssap(ND_ProtoInfo *pinf, struct nd_snap_header *sh);
void       nd_snap_set_gui_dsap(ND_ProtoInfo *pinf, struct nd_snap_header *sh);
void       nd_snap_set_gui_ctrl(ND_ProtoInfo *pinf, struct nd_snap_header *sh);
void       nd_snap_set_gui_oui(ND_ProtoInfo *pinf, struct nd_snap_header *sh);
void       nd_snap_set_gui_proto(ND_ProtoInfo *pinf, struct nd_snap_header *sh);

#endif
