/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_tcb_h
#define __nd_tcb_h

#include <netdude/nd.h>
#include <netdude/nd_packet.h>

#include <netinet/ip.h>
#include <netinet/tcp.h>

/* Transmission control buffers for TCP connections,
 * a.k.a. takin' care of businnes :o)
 */

typedef struct nd_tcb ND_TCB;
typedef struct nd_tcb_conn ND_TCBConn;

ND_TCB         *nd_tcb_new(void);
void            nd_tcb_free(ND_TCB *tcb);

ND_TCBConn     *nd_tcb_lookup(ND_TCB *tcb,
			      const ND_Packet *packet,
			      gboolean *is_reverse);

void            nd_tcb_update(ND_TCB *tcb,
			      const ND_Packet *packet,
			      int index);
  

gboolean        nd_tcb_is_match(const ND_TCBConn *conn,
				const ND_Packet *packet);

gboolean        nd_tcb_conn_reverse(const ND_TCBConn *conn);

/* Returns TRUE when the cb knows the receiver,
 * FALSE otherwise.
 */
gboolean        nd_tcb_conn_recv_known(ND_TCBConn *tcbc);

/* Returns the starting and ending sequence numbers of the given
   packet through SEQ_START and SEQ_END, trying to calculate relative
   numbers to the given TCB. If this was possible, TRUE is returned,
   FALSE otherwise. */
gboolean        nd_tcb_conn_get_rel_seq(const ND_TCBConn *tcbc,
					const struct ip *iphdr, const struct tcphdr *tcphdr,
					guint32 *seq_start, guint32 *seq_end);

/* Returns the ack sequence number of the given packet through ACK,
   trying to calculate relative numbers to the given TCB. If this
   was possible, TRUE is returned, FALSE otherwise. */
gboolean        nd_tcb_conn_get_rel_ack(const ND_TCBConn *tcbc,
					const struct ip *iphdr, const struct tcphdr *tcphdr,
					gboolean force_rel, guint32 *ack);

#endif
     
