// ng_teststle

// loads triangles and edge from file


#include <iostream.h>
#include <fstream.h>

#include "../libsrc/interface/nglib.h"




int main (int argc, char ** argv)
{
  cout << "Testing Netgen: STL with edges" << endl;

  if (argc < 2)
    {
      cerr << "use: ngcore filename" << endl;
      return 1;
    }

  int i, j;

  Ng_Mesh * mesh;
  Ng_STL_Geometry * geom;


  Ng_Meshing_Parameters mp;
  mp.maxh=100000;
  mp.fineness = 0.5;
  mp.secondorder = 0;



  Ng_Init();


  geom = Ng_STL_NewGeometry ();

  ifstream inf (argv[1]);

  int ntrig, nedge;
  double p1[3], p2[3], p3[3];
  inf >> ntrig;
  for (i = 1; i <= ntrig; i++)
    {
      inf >> p1[0] >> p1[1] >> p1[2];
      inf >> p2[0] >> p2[1] >> p2[2];
      inf >> p3[0] >> p3[1] >> p3[2];
      Ng_STL_AddTriangle (geom, p1, p2, p3);
    }

  inf >> nedge;
  for (i = 1; i <= nedge; i++)
    {
      inf >> p1[0] >> p1[1] >> p1[2];
      inf >> p2[0] >> p2[1] >> p2[2];
      Ng_STL_AddEdge (geom, p1, p2);
    }


  int rv;  
  rv = Ng_STL_InitSTLGeometry(geom);
  cout << "InitSTLGeometry: NG_result=" << rv << endl;
  
  mesh = Ng_NewMesh ();

  rv = Ng_STL_MakeEdges (geom, mesh, &mp);
  cout << "Generate Surface Mesh: Ng_result=" << rv << endl;

  rv = Ng_STL_GenerateSurfaceMesh (geom, mesh, &mp);
  cout << "Generate Surface Mesh: Ng_result=" << rv << endl;
	
  Ng_SaveMesh (mesh, "surface.vol");

  
  rv = Ng_GenerateVolumeMesh(mesh,&mp);
  cout << "Generate Volume Mesh: Ng_result=" << rv << endl;

  Ng_SaveMesh (mesh, "volume.vol");

  
  Ng_Exit();
}
