#ifndef FILE_LINEARFORM
#define FILE_LINEARFORM

/*********************************************************************/
/* File:   linearform.hh                                             */
/* Author: Joachim Schoeberl                                         */
/* Date:   25. Mar. 2000                                             */
/*********************************************************************/

/** 
   Linearform
*/

class LinearForm : public NGS_Object
{
protected:
  ///
  const FESpace & fespace;
  ///
  ARRAY<LinearFormIntegrator*> parts;
  
  /// do the integration on independent meshes
  bool independent;

  bool printelvec;
public:
  ///
  LinearForm (const FESpace & afespace, 
	      const string & aname, const Flags & flags);

  ///
  virtual ~LinearForm ();
  
  ///
  const FESpace & GetFESpace() const
  { return fespace; }


  ///
  virtual void AddIntegrator (LinearFormIntegrator * lfi)
  {
    parts.Append (lfi);
  }

  ///
  virtual const LinearFormIntegrator * GetIntegrator (int i) const
  {
    return parts[i]; 
  }

  ///
  virtual int NumIntegrators () const
  {
    return parts.Size(); 
  }


  void SetIndependent (int aindependent = true)
  { independent = aindependent; }


  ///
  virtual void Assemble (LocalHeap & lh) = 0;

  ///
  virtual BaseVector & GetVector () const = 0;
  ///
  virtual string GetClassName () const
  {
    return "LinearForm";
  }
  ///
  virtual void PrintReport (ostream & ost);
  ///
  virtual void MemoryUsage (ARRAY<MemoryUsageStruct*> & mu) const;
};


template <class SCAL>
class S_LinearForm : public LinearForm
{
public:
  typedef SCAL TSCAL;

  ///
  S_LinearForm (const FESpace & afespace, 
		const string & aname,
		const Flags & flags)
    : LinearForm (afespace, aname, flags)
  {
    ;
  }
  
  ///
  virtual void AllocateVector () = 0;

  ///
  virtual void AddElementVector (const ARRAY<int> & dnums,
				 const FlatVector<SCAL> & elvec) = 0;
  virtual void SetElementVector (const ARRAY<int> & dnums,
				 const FlatVector<SCAL> & elvec) = 0;
  virtual void GetElementVector (const ARRAY<int> & dnums,
				 FlatVector<SCAL> & elvec) const = 0;

  ///
  virtual void Assemble (LocalHeap & lh);
  void AssembleIndependent (LocalHeap & lh);
};






/// Template argument specifies vector type
template <class TV>
class T_LinearForm : public S_LinearForm<typename mat_traits<TV>::TSCAL>
{
  ///
  ngla::VVector<TV> * vec;

public:

  typedef typename mat_traits<TV>::TSCAL TSCAL;
  enum { HEIGHT = mat_traits<TV>::HEIGHT };

  ///
  T_LinearForm (const FESpace & afespace, const string & aname,
		const Flags & flags);

  ///
  virtual ~T_LinearForm ();

  ///
  virtual BaseVector & GetVector () const 
  { return *vec; }

  ///
  virtual void AllocateVector ();

  ///
  virtual void AddElementVector (const ARRAY<int> & dnums,
				 const FlatVector<TSCAL> & elvec);
  virtual void SetElementVector (const ARRAY<int> & dnums,
				 const FlatVector<TSCAL> & elvec);
  virtual void GetElementVector (const ARRAY<int> & dnums,
				 FlatVector<TSCAL> & elvec) const;
};


extern LinearForm * CreateLinearForm (const FESpace * space,
				      const string & name,
				      const Flags & flags);


#endif


