/*
                                  NETWOX
                             Network toolbox
                Copyright(c) 1999-2005 Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
                   http://laurentconstantin.free.fr/
                   http://membres.lycos.fr/lauconstantin/
  [my current email address is on the web servers]

                                  -----
  This file is part of Netwox.

  Netwox is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  version 2 as published by the Free Software Foundation.

  Netwox is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details (http://www.gnu.org/).

------------------------------------------------------------------------
*/

/*-------------------------------------------------------------*/
#include "../netwox.h"

/*-------------------------------------------------------------*/
#define NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN 24
#define NETWOX_SMBCMDTSC2_VOLUME_LEN 12

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_init(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->shortfilename));
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->longfilename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_setdefault(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem)
{
  pitem->fileindex = 0;
  netwox__smbcmdcmn_time1601_initdefault(pitem->creationtime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->changetime);
  netwox__smbcmdcmn_uint64_initdefault(pitem->filesize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);
  netwox__smbcmdcmn_fileattr32_initdefault(pitem->fileattributes);
  pitem->easize = 0;

  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->shortfilename));
  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->longfilename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_close(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->shortfilename));
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->longfilename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, longfilenamesize, shortfilenamesize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 66) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->fileindex);
  netwox__smbcmdcmn_time1601_decode(data, pitem->creationtime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->changetime);
  netwox__smbcmdcmn_uint64_decode(data, pitem->filesize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  netwox__smbcmdcmn_fileattr32_decode(data, pitem->fileattributes);
  netwib__data_decode_uint32_le(data, longfilenamesize);
  netwib__data_decode_uint32_le(data, pitem->easize);
  netwib__data_decode_uint8_le(data, shortfilenamesize);
  data++; /* reserved */
  datasize -= 66;

  /* short file name */
  if (shortfilenamesize > NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN) {
    return(NETWIB_ERR_NOTCONVERTED);
  }
  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize,
                                            NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN, &pitem->shortfilename));
  pitem->shortfilename.endoffset = pitem->shortfilename.beginoffset + shortfilenamesize;

  /* long file name */
  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, longfilenamesize,
                                            &pitem->longfilename));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_size(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem,
                                                         netwib_uint32 *psize)
{
  *psize = 66 + NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN + netwib__buf_ref_data_size(&pitem->longfilename);
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_append(const netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 66 + NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN, &data));
  netwib__data_append_uint32_le(data, pitem->fileindex);
  netwox__smbcmdcmn_time1601_append(data, pitem->creationtime);
  netwox__smbcmdcmn_time1601_append(data, pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_append(data, pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_append(data, pitem->changetime);
  netwox__smbcmdcmn_uint64_append(data, pitem->filesize);
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  netwox__smbcmdcmn_fileattr32_append(data, pitem->fileattributes);
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->longfilename));
  netwib__data_append_uint32_le(data, pitem->easize);
  netwib__data_append_uint8_le(data, netwib__buf_ref_data_size(&pitem->shortfilename));
  netwib_c_memset(data, 0, 1); data++; /* reserved */
  netwib_c_memset(data, 0, NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN);
  if (netwib__buf_ref_data_size(&pitem->shortfilename) > NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN) {
    return(NETWIB_ERR_PATOOHIGH);
  }
  netwib_c_memcpy(data, netwib__buf_ref_data_ptr(&pitem->shortfilename),
                  netwib__buf_ref_data_size(&pitem->shortfilename));
  pbuf->endoffset += 66 + NETWOX_SMBCMDTSC2_SHORTFILENAME_ULEN;
  netwib_er(netwib_buf_append_buf(&pitem->longfilename, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_show(const netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  fileindex=%{uint32}", pitem->fileindex));
  netwib_er(netwox_smbcmdcmn_time1601_show("  creationtime", pitem->creationtime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  lastaccesstime", pitem->lastaccesstime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  lastwritetime", pitem->lastwritetime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  changetime", pitem->changetime, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  filesize", pitem->filesize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_fileattr32_show("  fileattributes", pitem->fileattributes, pbuf));
  netwib_er(netwib_show_array_fmt32(pbuf, "  easize=%{uint32}", pitem->easize));
  netwib_er(netwox_smbcmdcmn_data_show("  shortfilename", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->shortfilename, pbuf));
  netwib_er(netwox_smbcmdcmn_data_show("  longfilename", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->longfilename, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_init(netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_setdefault(netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem)
{
  pitem->fsid = 0;
  pitem->sectorsperunit = 0;
  pitem->totalunits = 0;
  pitem->availableunits = 0;
  pitem->bytespersector = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_close(netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_decode(netwib_data *pdata,
                                       netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 18) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->fsid);
  netwib__data_decode_uint32_le(data, pitem->sectorsperunit);
  netwib__data_decode_uint32_le(data, pitem->totalunits);
  netwib__data_decode_uint32_le(data, pitem->availableunits);
  netwib__data_decode_uint16_le(data, pitem->bytespersector);
  datasize -= 18;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_append(const netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 18, &data));
  netwib__data_append_uint32_le(data, pitem->fsid);
  netwib__data_append_uint32_le(data, pitem->sectorsperunit);
  netwib__data_append_uint32_le(data, pitem->totalunits);
  netwib__data_append_uint32_le(data, pitem->availableunits);
  netwib__data_append_uint16_le(data, pitem->bytespersector);
  pbuf->endoffset += 18;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_show(const netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  fsid=%{uint32}", pitem->fsid));
  netwib_er(netwib_show_array_fmt32(pbuf, "  sectorsperunit=%{uint32}", pitem->sectorsperunit));
  netwib_er(netwib_show_array_fmt32(pbuf, "  totalunits=%{uint32}", pitem->totalunits));
  netwib_er(netwib_show_array_fmt32(pbuf, "  availableunits=%{uint32}", pitem->availableunits));
  netwib_er(netwib_show_array_fmt32(pbuf, "  bytespersector=%{uint16}", pitem->bytespersector));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_init(netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->label));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_setdefault(netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem)
{
  pitem->serialnumber = 0;
  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->label));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_close(netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->label));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_decode(netwib_data *pdata,
                                                  netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, labelsize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 5) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->serialnumber);
  netwib__data_decode_uint8_le(data, labelsize);
  datasize -= 5;

  if (labelsize > NETWOX_SMBCMDTSC2_VOLUME_LEN) {
    return(NETWIB_ERR_NOTCONVERTED);
  }
  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize,
                                            NETWOX_SMBCMDTSC2_VOLUME_LEN,
                                            &pitem->label));
  pitem->label.endoffset = pitem->label.beginoffset + labelsize;


  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_append(const netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 5+NETWOX_SMBCMDTSC2_VOLUME_LEN, &data));
  netwib__data_append_uint32_le(data, pitem->serialnumber);
  netwib__data_append_uint8_le(data, netwib__buf_ref_data_size(&pitem->label));
  netwib_c_memset(data, 0, NETWOX_SMBCMDTSC2_VOLUME_LEN);
  if (netwib__buf_ref_data_size(&pitem->label) >NETWOX_SMBCMDTSC2_VOLUME_LEN) {
    return(NETWIB_ERR_PATOOHIGH);
  }
  netwib_c_memcpy(data, netwib__buf_ref_data_ptr(&pitem->label),
                  netwib__buf_ref_data_size(&pitem->label));
  pbuf->endoffset += 5 + NETWOX_SMBCMDTSC2_VOLUME_LEN;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_show(const netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  serialnumber=%{uint32:#08X}", pitem->serialnumber));
  netwib_er(netwox_smbcmdcmn_data_show("  label", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->label, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_init(netwox_smbcmdtsc2_fmt_fs_volume *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->label));
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_setdefault(netwox_smbcmdtsc2_fmt_fs_volume *pitem)
{
  netwox__smbcmdcmn_time1601_initdefault(pitem->creationtime);
  pitem->serialnumber = 0;

  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->label));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_close(netwox_smbcmdtsc2_fmt_fs_volume *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->label));
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_decode(netwib_data *pdata,
                                                  netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_fs_volume *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, labelsize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 18) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_time1601_decode(data, pitem->creationtime);
  netwib__data_decode_uint32_le(data, pitem->serialnumber);
  netwib__data_decode_uint32_le(data, labelsize);
  data += 2; /* reserved */
  datasize -= 18;

  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, labelsize,
                                            &pitem->label));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_append(const netwox_smbcmdtsc2_fmt_fs_volume *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 18, &data));
  netwox__smbcmdcmn_time1601_append(data, pitem->creationtime);
  netwib__data_append_uint32_le(data, pitem->serialnumber);
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->label));
  netwib_c_memset(data, 0, 2); data += 2; /* reserved */
  pbuf->endoffset += 18;
  netwib_er(netwib_buf_append_buf(&pitem->label, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_show(const netwox_smbcmdtsc2_fmt_fs_volume *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_time1601_show("  creationtime", pitem->creationtime, pbuf));
  netwib_er(netwib_show_array_fmt32(pbuf, "  serialnumber=%{uint32:#08X}", pitem->serialnumber));
  netwib_er(netwox_smbcmdcmn_data_show("  label", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->label, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_size_init(netwox_smbcmdtsc2_fmt_fs_size *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_size_setdefault(netwox_smbcmdtsc2_fmt_fs_size *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->freeunits);
  pitem->sectorsperunit = 0;
  pitem->bytespersector = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_size_close(netwox_smbcmdtsc2_fmt_fs_size *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_size_decode(netwib_data *pdata,
                                                netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_fs_size *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 24) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->freeunits);
  netwib__data_decode_uint32_le(data, pitem->sectorsperunit);
  netwib__data_decode_uint32_le(data, pitem->bytespersector);
  datasize -= 24;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_size_append(const netwox_smbcmdtsc2_fmt_fs_size *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 24, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_append(data, pitem->freeunits);
  netwib__data_append_uint32_le(data, pitem->sectorsperunit);
  netwib__data_append_uint32_le(data, pitem->bytespersector);
  pbuf->endoffset += 24;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_size_show(const netwox_smbcmdtsc2_fmt_fs_size *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  freeunits", pitem->freeunits, pbuf));
  netwib_er(netwib_show_array_fmt32(pbuf, "  sectorsperunit=%{uint32}", pitem->sectorsperunit));
  netwib_er(netwib_show_array_fmt32(pbuf, "  bytespersector=%{uint32}", pitem->bytespersector));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_init(netwox_smbcmdtsc2_fmt_fs_attribute *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->fsname));
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_setdefault(netwox_smbcmdtsc2_fmt_fs_attribute *pitem)
{
  pitem->fsattributes = 0;
  pitem->maxnamesize = 0;

  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->fsname));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_close(netwox_smbcmdtsc2_fmt_fs_attribute *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->fsname));
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_fs_attribute *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, fsnamesize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 12) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->fsattributes);
  netwib__data_decode_uint32_le(data, pitem->maxnamesize);
  netwib__data_decode_uint32_le(data, fsnamesize);
  datasize -= 12;

  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, fsnamesize,
                                            &pitem->fsname));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_append(const netwox_smbcmdtsc2_fmt_fs_attribute *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 12, &data));
  netwib__data_append_uint32_le(data, pitem->fsattributes);
  netwib__data_append_uint32_le(data, pitem->maxnamesize);
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->fsname));
  pbuf->endoffset += 12;
  netwib_er(netwib_buf_append_buf(&pitem->fsname, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_show(const netwox_smbcmdtsc2_fmt_fs_attribute *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  fsattributes=%{uint32:#32b}", pitem->fsattributes));
  netwib_er(netwib_show_array_fmt32(pbuf, "  maxnamesize=%{uint32}", pitem->maxnamesize));
  netwib_er(netwox_smbcmdcmn_data_show("  fsname", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->fsname, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_init(netwox_smbcmdtsc2_fmt_fs_efullsize *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_setdefault(netwox_smbcmdtsc2_fmt_fs_efullsize *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->callerfreeunits);
  netwox__smbcmdcmn_uint64_initdefault(pitem->actualfreeunits);
  pitem->sectorsperunit = 0;
  pitem->bytespersector = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_close(netwox_smbcmdtsc2_fmt_fs_efullsize *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_decode(netwib_data *pdata,
                                                netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_fs_efullsize *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 32) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->callerfreeunits);
  netwox__smbcmdcmn_uint64_decode(data, pitem->actualfreeunits);
  netwib__data_decode_uint32_le(data, pitem->sectorsperunit);
  netwib__data_decode_uint32_le(data, pitem->bytespersector);
  datasize -= 32;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_append(const netwox_smbcmdtsc2_fmt_fs_efullsize *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 32, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_append(data, pitem->callerfreeunits);
  netwox__smbcmdcmn_uint64_append(data, pitem->actualfreeunits);
  netwib__data_append_uint32_le(data, pitem->sectorsperunit);
  netwib__data_append_uint32_le(data, pitem->bytespersector);
  pbuf->endoffset += 32;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_show(const netwox_smbcmdtsc2_fmt_fs_efullsize *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  callerfreeunits", pitem->callerfreeunits, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  actualfreeunits", pitem->actualfreeunits, pbuf));
  netwib_er(netwib_show_array_fmt32(pbuf, "  sectorsperunit=%{uint32}", pitem->sectorsperunit));
  netwib_er(netwib_show_array_fmt32(pbuf, "  bytespersector=%{uint32}", pitem->bytespersector));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_init(netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->guid));
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->unknown));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_setdefault(netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->guid));
  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->unknown));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_close(netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->guid));
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->unknown));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_decode(netwib_data *pdata,
                                                     netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, 16,
                                            &pitem->guid));
  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, datasize,
                                            &pitem->unknown));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_append(const netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem,
                                                           netwib_buf *pbuf)
{
  netwib_er(netwib_buf_append_buf(&pitem->guid, pbuf));
  netwib_er(netwib_buf_append_buf(&pitem->unknown, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_show(const netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_data_show("  guid", NETWOX_SMBCMDCMN_DATATYPE_BUFEXTSIZE, &pitem->guid, pbuf));
  netwib_er(netwox_smbcmdcmn_data_show("  unknown", NETWOX_SMBCMDCMN_DATATYPE_BUFEXTSIZE, &pitem->unknown, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_basic_init(netwox_smbcmdtsc2_fmt_file_basic *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_basic_setdefault(netwox_smbcmdtsc2_fmt_file_basic *pitem)
{
  netwox__smbcmdcmn_time1601_initdefault(pitem->creationtime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->changetime);
  netwox__smbcmdcmn_fileattr16_initdefault(pitem->fileattributes);

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_basic_close(netwox_smbcmdtsc2_fmt_file_basic *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_basic_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_basic *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 34) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_time1601_decode(data, pitem->creationtime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->changetime);
  netwox__smbcmdcmn_fileattr16_decode(data, pitem->fileattributes);
  datasize -= 34;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_basic_append(const netwox_smbcmdtsc2_fmt_file_basic *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 34, &data));
  netwox__smbcmdcmn_time1601_append(data, pitem->creationtime);
  netwox__smbcmdcmn_time1601_append(data, pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_append(data, pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_append(data, pitem->changetime);
  netwox__smbcmdcmn_fileattr16_append(data, pitem->fileattributes);
  pbuf->endoffset += 34;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_basic_show(const netwox_smbcmdtsc2_fmt_file_basic *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_time1601_show("  creationtime", pitem->creationtime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  lastaccesstime", pitem->lastaccesstime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  lastwritetime", pitem->lastwritetime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  changetime", pitem->changetime, pbuf));
  netwib_er(netwox_smbcmdcmn_fileattr16_show("  fileattributes", pitem->fileattributes, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_standard_init(netwox_smbcmdtsc2_fmt_file_standard *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_standard_setdefault(netwox_smbcmdtsc2_fmt_file_standard *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->filesize);
  pitem->linkcount = 0;
  pitem->deletepending = 0;
  pitem->isdirectory = NETWIB_FALSE;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_standard_close(netwox_smbcmdtsc2_fmt_file_standard *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_standard_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_standard *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 24) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->filesize);
  netwib__data_decode_uint32_le(data, pitem->linkcount);
  netwib__data_decode_uint16_le(data, pitem->deletepending);
  netwib__data_decode_uint8_le(data, pitem->isdirectory);
  data++; /* reserved */
  datasize -= 24;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_standard_append(const netwox_smbcmdtsc2_fmt_file_standard *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 24, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_append(data, pitem->filesize);
  netwib__data_append_uint32_le(data, pitem->linkcount);
  netwib__data_append_uint16_le(data, pitem->deletepending);
  if (pitem->isdirectory) {
    netwib__data_append_uint8_le(data, 1);
  } else {
    netwib__data_append_uint8_le(data, 0);
  }
  netwib_c_memset(data, 0, 1); /* reserved */
  pbuf->endoffset += 24;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_standard_show(const netwox_smbcmdtsc2_fmt_file_standard *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  filesize", pitem->filesize, pbuf));
  netwib_er(netwib_show_array_fmt32(pbuf, "  linkcount=%{uint32}", pitem->linkcount));
  netwib_er(netwib_show_array_fmt32(pbuf, "  deletepending=%{uint16}", pitem->deletepending));
  netwib_er(netwib_show_array_fmt32(pbuf, "  isdirectory=%{bool}", pitem->isdirectory));


  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ea_init(netwox_smbcmdtsc2_fmt_file_ea *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ea_setdefault(netwox_smbcmdtsc2_fmt_file_ea *pitem)
{
  pitem->easize = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ea_close(netwox_smbcmdtsc2_fmt_file_ea *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ea_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_ea *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 4) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->easize);
  datasize -= 4;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ea_append(const netwox_smbcmdtsc2_fmt_file_ea *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 4, &data));
  netwib__data_append_uint32_le(data, pitem->easize);
  pbuf->endoffset += 4;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ea_show(const netwox_smbcmdtsc2_fmt_file_ea *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  easize=%{uint32}", pitem->easize));


  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_name_init(netwox_smbcmdtsc2_fmt_file_name *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->filename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_name_setdefault(netwox_smbcmdtsc2_fmt_file_name *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->filename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_name_close(netwox_smbcmdtsc2_fmt_file_name *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->filename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_name_decode(netwib_data *pdata,
                                                     netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_file_name *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, filenamesize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 4) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, filenamesize);
  datasize -= 4;

  if (datasize == 4 && filenamesize == 1089) {
    /* SETFILEINFO sometimes uses an empty name. Correct it. */
    data += 2;
    datasize -= 2;
    netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->filename));
  } else {
    netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, filenamesize,
                                              &pitem->filename));
  }

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_name_append(const netwox_smbcmdtsc2_fmt_file_name *pitem,
                                                     netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 4, &data));
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->filename));
  pbuf->endoffset += 4;
  netwib_er(netwib_buf_append_buf(&pitem->filename, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_name_show(const netwox_smbcmdtsc2_fmt_file_name *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_data_show("  filename", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->filename, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
#if 0
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_init(netwox_smbcmdtsc2_fmt_file_allocation *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_setdefault(netwox_smbcmdtsc2_fmt_file_allocation *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_close(netwox_smbcmdtsc2_fmt_file_allocation *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_allocation *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 8) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  datasize -= 8;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_append(const netwox_smbcmdtsc2_fmt_file_allocation *pitem,
                                                        netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 8, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  pbuf->endoffset += 8;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_show(const netwox_smbcmdtsc2_fmt_file_allocation *pitem,
                                                      netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));

  return(NETWIB_ERR_OK);
}
#endif

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_altname_init(netwox_smbcmdtsc2_fmt_file_altname *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->filename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_altname_setdefault(netwox_smbcmdtsc2_fmt_file_altname *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->filename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_altname_close(netwox_smbcmdtsc2_fmt_file_altname *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->filename));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_altname_decode(netwib_data *pdata,
                                                     netwib_uint32 *pdatasize,
                                       netwox_smbcmdtsc2_fmt_file_altname *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, filenamesize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 4) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, filenamesize);
  datasize -= 4;

  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, filenamesize,
                                            &pitem->filename));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_altname_append(const netwox_smbcmdtsc2_fmt_file_altname *pitem,
                                                     netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 4, &data));
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->filename));
  pbuf->endoffset += 4;
  netwib_er(netwib_buf_append_buf(&pitem->filename, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_altname_show(const netwox_smbcmdtsc2_fmt_file_altname *pitem,
                                                         netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_data_show("  filename", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->filename, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_init(netwox_smbcmdtsc2_fmt_file_stream *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->name));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_setdefault(netwox_smbcmdtsc2_fmt_file_stream *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->streamsize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);

  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->name));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_close(netwox_smbcmdtsc2_fmt_file_stream *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->name));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_stream *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, namesize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 20) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, namesize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->streamsize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  datasize -= 20;

  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, namesize,
                                            &pitem->name));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_size(netwox_smbcmdtsc2_fmt_file_stream *pitem,
                                                         netwib_uint32 *psize)
{
  *psize = 20 + netwib__buf_ref_data_size(&pitem->name);
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_append(const netwox_smbcmdtsc2_fmt_file_stream *pitem,
                                                     netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 20, &data));
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->name));
  netwox__smbcmdcmn_uint64_append(data, pitem->streamsize);
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  pbuf->endoffset += 20;
  netwib_er(netwib_buf_append_buf(&pitem->name, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_stream_show(const netwox_smbcmdtsc2_fmt_file_stream *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  streamsize", pitem->streamsize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_data_show("  name", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->name, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_init(netwox_smbcmdtsc2_fmt_file_ebasic *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_setdefault(netwox_smbcmdtsc2_fmt_file_ebasic *pitem)
{
  netwox__smbcmdcmn_time1601_initdefault(pitem->creationtime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_initdefault(pitem->changetime);
  netwox__smbcmdcmn_fileattr16_initdefault(pitem->fileattributes);

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_close(netwox_smbcmdtsc2_fmt_file_ebasic *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_ebasic *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 34) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_time1601_decode(data, pitem->creationtime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_decode(data, pitem->changetime);
  netwox__smbcmdcmn_fileattr16_decode(data, pitem->fileattributes);
  datasize -= 34;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_append(const netwox_smbcmdtsc2_fmt_file_ebasic *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 34, &data));
  netwox__smbcmdcmn_time1601_append(data, pitem->creationtime);
  netwox__smbcmdcmn_time1601_append(data, pitem->lastaccesstime);
  netwox__smbcmdcmn_time1601_append(data, pitem->lastwritetime);
  netwox__smbcmdcmn_time1601_append(data, pitem->changetime);
  netwox__smbcmdcmn_fileattr16_append(data, pitem->fileattributes);
  pbuf->endoffset += 34;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_show(const netwox_smbcmdtsc2_fmt_file_ebasic *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_time1601_show("  creationtime", pitem->creationtime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  lastaccesstime", pitem->lastaccesstime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  lastwritetime", pitem->lastwritetime, pbuf));
  netwib_er(netwox_smbcmdcmn_time1601_show("  changetime", pitem->changetime, pbuf));
  netwib_er(netwox_smbcmdcmn_fileattr16_show("  fileattributes", pitem->fileattributes, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_init(netwox_smbcmdtsc2_fmt_file_estandard *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_setdefault(netwox_smbcmdtsc2_fmt_file_estandard *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->filesize);
  pitem->linkcount = 0;
  pitem->deletepending = 0;
  pitem->isdirectory = NETWIB_FALSE;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_close(netwox_smbcmdtsc2_fmt_file_estandard *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_estandard *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 24) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->filesize);
  netwib__data_decode_uint32_le(data, pitem->linkcount);
  netwib__data_decode_uint16_le(data, pitem->deletepending);
  netwib__data_decode_uint8_le(data, pitem->isdirectory);
  data++; /* reserved */
  datasize -= 24;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_append(const netwox_smbcmdtsc2_fmt_file_estandard *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 24, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  netwox__smbcmdcmn_uint64_append(data, pitem->filesize);
  netwib__data_append_uint32_le(data, pitem->linkcount);
  netwib__data_append_uint16_le(data, pitem->deletepending);
  if (pitem->isdirectory) {
    netwib__data_append_uint8_le(data, 1);
  } else {
    netwib__data_append_uint8_le(data, 0);
  }
  netwib_c_memset(data, 0, 1); /* reserved */
  pbuf->endoffset += 24;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_show(const netwox_smbcmdtsc2_fmt_file_estandard *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  filesize", pitem->filesize, pbuf));
  netwib_er(netwib_show_array_fmt32(pbuf, "  linkcount=%{uint32}", pitem->linkcount));
  netwib_er(netwib_show_array_fmt32(pbuf, "  deletepending=%{uint16}", pitem->deletepending));
  netwib_er(netwib_show_array_fmt32(pbuf, "  isdirectory=%{bool}", pitem->isdirectory));


  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_init(netwox_smbcmdtsc2_fmt_file_einternal *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_setdefault(netwox_smbcmdtsc2_fmt_file_einternal *pitem)
{
  pitem->dev = 0;
  pitem->ino = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_close(netwox_smbcmdtsc2_fmt_file_einternal *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_einternal *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 8) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->dev);
  netwib__data_decode_uint32_le(data, pitem->ino);
  datasize -= 8;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_append(const netwox_smbcmdtsc2_fmt_file_einternal *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 8, &data));
  netwib__data_append_uint32_le(data, pitem->dev);
  netwib__data_append_uint32_le(data, pitem->ino);
  pbuf->endoffset += 8;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_show(const netwox_smbcmdtsc2_fmt_file_einternal *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  dev=%{uint32}", pitem->dev));
  netwib_er(netwib_show_array_fmt32(pbuf, "  ino=%{uint32}", pitem->ino));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eea_init(netwox_smbcmdtsc2_fmt_file_eea *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eea_setdefault(netwox_smbcmdtsc2_fmt_file_eea *pitem)
{
  pitem->easize = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eea_close(netwox_smbcmdtsc2_fmt_file_eea *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eea_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eea *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 4) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->easize);
  datasize -= 4;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eea_append(const netwox_smbcmdtsc2_fmt_file_eea *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 4, &data));
  netwib__data_append_uint32_le(data, pitem->easize);
  pbuf->endoffset += 4;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eea_show(const netwox_smbcmdtsc2_fmt_file_eea *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  easize=%{uint32}", pitem->easize));


  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_init(netwox_smbcmdtsc2_fmt_file_eallocation *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_setdefault(netwox_smbcmdtsc2_fmt_file_eallocation *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_close(netwox_smbcmdtsc2_fmt_file_eallocation *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eallocation *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 8) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  datasize -= 8;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_append(const netwox_smbcmdtsc2_fmt_file_eallocation *pitem,
                                                        netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 8, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  pbuf->endoffset += 8;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_show(const netwox_smbcmdtsc2_fmt_file_eallocation *pitem,
                                                      netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_init(netwox_smbcmdtsc2_fmt_file_eeof *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_setdefault(netwox_smbcmdtsc2_fmt_file_eeof *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->filesize);

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_close(netwox_smbcmdtsc2_fmt_file_eeof *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eeof *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 8) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwox__smbcmdcmn_uint64_decode(data, pitem->filesize);
  datasize -= 8;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_append(const netwox_smbcmdtsc2_fmt_file_eeof *pitem,
                                                        netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 8, &data));
  netwox__smbcmdcmn_uint64_append(data, pitem->filesize);
  pbuf->endoffset += 8;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_show(const netwox_smbcmdtsc2_fmt_file_eeof *pitem,
                                                      netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  filesize", pitem->filesize, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_init(netwox_smbcmdtsc2_fmt_file_estream *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_initdefault(&pitem->name));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_setdefault(netwox_smbcmdtsc2_fmt_file_estream *pitem)
{
  netwox__smbcmdcmn_uint64_initdefault(pitem->streamsize);
  netwox__smbcmdcmn_uint64_initdefault(pitem->allocationsize);

  netwib_er(netwox_smbcmdcmn_data_setdefault(&pitem->name));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_close(netwox_smbcmdtsc2_fmt_file_estream *pitem)
{
  netwib_er(netwox_smbcmdcmn_data_close(&pitem->name));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_estream *pitem)
{
  netwib_data data;
  netwib_uint32 datasize, namesize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 20) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, namesize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->streamsize);
  netwox__smbcmdcmn_uint64_decode(data, pitem->allocationsize);
  datasize -= 20;

  netwib_er(netwox_smbcmdcmn_data_decodeext(&data, &datasize, namesize,
                                            &pitem->name));

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_size(netwox_smbcmdtsc2_fmt_file_estream *pitem,
                                                         netwib_uint32 *psize)
{
  *psize = 20 + netwib__buf_ref_data_size(&pitem->name);
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_append(const netwox_smbcmdtsc2_fmt_file_estream *pitem,
                                                     netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 20, &data));
  netwib__data_append_uint32_le(data, netwib__buf_ref_data_size(&pitem->name));
  netwox__smbcmdcmn_uint64_append(data, pitem->streamsize);
  netwox__smbcmdcmn_uint64_append(data, pitem->allocationsize);
  pbuf->endoffset += 20;
  netwib_er(netwib_buf_append_buf(&pitem->name, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_estream_show(const netwox_smbcmdtsc2_fmt_file_estream *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_er(netwox_smbcmdcmn_uint64_show("  streamsize", pitem->streamsize, pbuf));
  netwib_er(netwox_smbcmdcmn_uint64_show("  allocationsize", pitem->allocationsize, pbuf));
  netwib_er(netwox_smbcmdcmn_data_show("  name", NETWOX_SMBCMDCMN_DATATYPE_STRINGONLY, &pitem->name, pbuf));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_init(netwox_smbcmdtsc2_fmt_file_eattributetag *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_setdefault(netwox_smbcmdtsc2_fmt_file_eattributetag *pitem)
{
  pitem->mode = 0;
  pitem->unknown = 0;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_close(netwox_smbcmdtsc2_fmt_file_eattributetag *pitem)
{
  return(NETWIB_ERR_OK);
  pitem = pitem;
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eattributetag *pitem)
{
  netwib_data data;
  netwib_uint32 datasize;

  data = *pdata;
  datasize = *pdatasize;

  if (datasize < 8) {
    return(NETWIB_ERR_DATAMISSING);
  }
  netwib__data_decode_uint32_le(data, pitem->mode);
  netwib__data_decode_uint32_le(data, pitem->unknown);
  datasize -= 8;

  *pdata = data;
  *pdatasize = datasize;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_append(const netwox_smbcmdtsc2_fmt_file_eattributetag *pitem,
                                                   netwib_buf *pbuf)
{
  netwib_data data;

  netwib_er(netwib_buf_wantspace(pbuf, 8, &data));
  netwib__data_append_uint32_le(data, pitem->mode);
  netwib__data_append_uint32_le(data, pitem->unknown);
  pbuf->endoffset += 8;

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_show(const netwox_smbcmdtsc2_fmt_file_eattributetag *pitem,
                                                 netwib_buf *pbuf)
{
  netwib_er(netwib_show_array_fmt32(pbuf, "  mode=%{uint32}", pitem->mode));
  netwib_er(netwib_show_array_fmt32(pbuf, "  unknown=%{uint32}", pitem->unknown));

  return(NETWIB_ERR_OK);
}
