
/*-------------------------------------------------------------*/
/* information related to a thread */
typedef struct {
  netwox_constsmbserver *pcommon; /* shared info */
  netwib_io *pio;
  /* internal */
  netwib_buf *pbufrecv; /* receiving buffer storage */
  netwox_smberr smberrtosend; /* to send back an error */
  /* values defined by client, by server or negotiated */
  netwib_uint16 cmn_treeid;
  netwib_uint32 cmn_processid;
  netwib_uint16 cmn_userid;
  netwib_uint16 cmn_multiplexid;
  netwib_uint8 cmn_secumode;
  netwib_uint32 cmn_maxmsgsize;
  netwib_uint32 cmn_vcsessionid;
  netwox_smbcmdcmn_negocapa cmn_capabilities;
  netwib_buf *pcmn_challenge;
} netwox_smbser;
typedef const netwox_smbser netwox_constsmbser;

netwib_err netwox_smbser_init(netwox_constsmbserver *pcommon,
                              netwib_io *pio,
                              netwox_smbser *psmbser);
netwib_err netwox_smbser_close(netwox_smbser *psmbser);

/*-------------------------------------------------------------*/
netwib_err netwox_smbser_smbmsg_setdefault(netwox_smbser *psmbser,
                                           netwox_smbmsg *psmbmsg);
netwib_err netwox_smbser_smbmsg_send(netwox_smbser *psmbser,
                                     netwox_smbmsg *psmbmsg);
netwib_err netwox_smbser_smbmsg_recv(netwox_smbser *psmbser,
                                     netwox_smbmsg *psmbmsg);

/*-------------------------------------------------------------*/
netwib_err netwox_smbser_smberr_send(netwox_smbser *psmbser,
                                     netwox_smbmsg_cmd smbcmd,
                                     netwox_smberr smberr);

/*-------------------------------------------------------------*/
netwib_err netwox_smbser_negotiate(netwox_smbser *psmbser,
                                   netwox_constsmbcmd *psmbcmdq);
