
/*
Error ranges :
  0          : OK
  1000..1999 : frequent errors
  2000..2999 : parameter errors
  3000..3999 : logical errors
  4000..9999 : function errors
  10000..end : user errors codes
*/
#define NETWIB_ERRZONE_USER_BEGIN 10000

typedef enum {
  /* no error */
  NETWIB_ERR_OK = 0,
  /* frequent errors */
  NETWIB_ERR_DATAEND = 1000,
  NETWIB_ERR_DATANOTAVAIL,
  NETWIB_ERR_DATANOSPACE,
  NETWIB_ERR_DATAOTHERTYPE,
  NETWIB_ERR_DATAMISSING,
  NETWIB_ERR_NOTFOUND,
  NETWIB_ERR_NOTCONVERTED,
  NETWIB_ERR_ROUTELOCALDEV,
  NETWIB_ERR_ROUTENOTFOUND,
  NETWIB_ERR_ROUTENOTETHER,
  NETWIB_ERR_PLEASETRYNEXT,
  NETWIB_ERR_PLEASECONSTRUCT,
  NETWIB_ERR_PLEASELOOPTIME,
  /* parameter errors */
  NETWIB_ERR_PAINVALIDTYPE = 2000,
  NETWIB_ERR_PAINVALIDPOS,
  NETWIB_ERR_PAINVALIDRANGE,
  NETWIB_ERR_PAINVALIDDEFAULT,
  NETWIB_ERR_PANULLPTR,
  NETWIB_ERR_PANULLPTRSIZE,
  NETWIB_ERR_PATOOLOW,
  NETWIB_ERR_PATOOHIGH,
  NETWIB_ERR_PAHEXACHAR,
  NETWIB_ERR_PAHEXAODD,
  NETWIB_ERR_PAMIXED,
  NETWIB_ERR_PABASE64CHAR,
  NETWIB_ERR_PABASE64X4,
  NETWIB_ERR_PABASE64LO,
  NETWIB_ERR_PAFMT,
  NETWIB_ERR_PAINT,
  NETWIB_ERR_PARINGFULL,
  NETWIB_ERR_PATLVINVALID,
  NETWIB_ERR_PATIMEDIFFNEG,
  NETWIB_ERR_PAPATHROOTDOTDOT,
  NETWIB_ERR_PAPATHNOTCANON,
  NETWIB_ERR_PAPATHCANTINIT,
  NETWIB_ERR_PAFILE2G,
  NETWIB_ERR_PAFILENOTREG,
  NETWIB_ERR_PAINDEXNODATA,
  NETWIB_ERR_PATOOBIGFORHDR,
  NETWIB_ERR_PAIP4OPTSNOTX4,
  NETWIB_ERR_PAIP4OPTSMAX10,
  NETWIB_ERR_PAIP6EXTSNOTX4,
  NETWIB_ERR_PATCPOPTSNOTX4,
  NETWIB_ERR_PATCPOPTSMAX10,
  NETWIB_ERR_PAIPTYPE,
  NETWIB_ERR_PAIPTYPENOT4,
  NETWIB_ERR_PAIPTYPENOT6,
  /* logical errors */
  NETWIB_ERR_LOINTERNALERROR = 3000,
  NETWIB_ERR_LONOTIMPLEMENTED,
  NETWIB_ERR_LONOTSUPPORTED,
  NETWIB_ERR_LOERROROKKO,
  NETWIB_ERR_LOOBJINITALREADYINIT,
  NETWIB_ERR_LOOBJUSENOTINITIALIZED,
  NETWIB_ERR_LOOBJUSECLOSED,
  NETWIB_ERR_LOOBJUSECORRUPT,
  NETWIB_ERR_LOOBJCLOSENOTINITIALIZED,
  NETWIB_ERR_LOOBJCLOSEALREADYCLOSED,
  NETWIB_ERR_LOOBJCLOSECORRUPT,
  NETWIB_ERR_LOOBJREADNOTSUPPORTED,
  NETWIB_ERR_LOOBJREADNOTALLOWED,
  NETWIB_ERR_LOOBJWRITENOTSUPPORTED,
  NETWIB_ERR_LOOBJWRITENOTALLOWED,
  NETWIB_ERR_LOOBJRDWRCONFLICT,
  NETWIB_ERR_LOCANTEXEC,
  NETWIB_ERR_LOUDPSERREADBEFWRITE,
  /* system functions errors */
  NETWIB_ERR_FUACCEPT = 4000,
  NETWIB_ERR_FUBIND,
  NETWIB_ERR_FUCLOCKGETTIME,
  NETWIB_ERR_FUCLOSE,
  NETWIB_ERR_FUCLOSEDIR,
  NETWIB_ERR_FUCLOSEHANDLE,
  NETWIB_ERR_FUCONNECT,
  NETWIB_ERR_FUCREATEEVENT,
  NETWIB_ERR_FUCREATEFILE,
  NETWIB_ERR_FUCREATEMUTEX,
  NETWIB_ERR_FUCREATEPIPE,
  NETWIB_ERR_FUCREATETHREAD,
  NETWIB_ERR_FUDUP2,
  NETWIB_ERR_FUDUPLICATEHANDLE,
  NETWIB_ERR_FUEXECLE,
  NETWIB_ERR_FUFCLOSE,
  NETWIB_ERR_FUFCNTL,
  NETWIB_ERR_FUFFLUSH,
  NETWIB_ERR_FUFILENO,
  NETWIB_ERR_FUFINDCLOSE,
  NETWIB_ERR_FUFOPEN,
  NETWIB_ERR_FUFORK,
  NETWIB_ERR_FUFREAD,
  NETWIB_ERR_FUFREELIBRARY,
  NETWIB_ERR_FUFSYNC,
  NETWIB_ERR_FUFTRUNCATE,
  NETWIB_ERR_FUFWRITE,
  NETWIB_ERR_FUGENERATECONSOLECTRLEVENT,
  NETWIB_ERR_FUGETCONSOLEMODE,
  NETWIB_ERR_FUGETEXITCODEPROCESS,
  NETWIB_ERR_FUGETEXITCODETHREAD,
  NETWIB_ERR_FUGETGRGIDR,
  NETWIB_ERR_FUGETGRNAMR,
  NETWIB_ERR_FUGETIFTABLE,
  NETWIB_ERR_FUGETIPADDRTABLE,
  NETWIB_ERR_FUGETIPFORWARDTABLE,
  NETWIB_ERR_FUGETIPNETTABLE,
  NETWIB_ERR_FUGETMSG,
  NETWIB_ERR_FUGETPEERNAME,
  NETWIB_ERR_FUGETPROCADDRESS,
  NETWIB_ERR_FUGETPWNAMR,
  NETWIB_ERR_FUGETRLIMIT,
  NETWIB_ERR_FUGETSOCKNAME,
  NETWIB_ERR_FUGETTIMEOFDAY,
  NETWIB_ERR_FUGLOBALALLOC,
  NETWIB_ERR_FUGLOBALFREE,
  NETWIB_ERR_FULOCALTIMER,
  NETWIB_ERR_FUIOCTL,
  NETWIB_ERR_FUKILL,
  NETWIB_ERR_FULIBNETCLOSELINKINT,
  NETWIB_ERR_FULIBNETCLOSERAWSOCK,
  NETWIB_ERR_FULIBNETINIT,
  NETWIB_ERR_FULIBNETOPENRAWSOCK,
  NETWIB_ERR_FULIBNETWRITEIP,
  NETWIB_ERR_FULIBNETWRITELINK,
  NETWIB_ERR_FULIBNETWRITELL,
  NETWIB_ERR_FULIBNETWRITERAWIPV4,
  NETWIB_ERR_FULIBNETWRITERAWIPV6,
  NETWIB_ERR_FULISTEN,
  NETWIB_ERR_FULOADLIBRARY,
  NETWIB_ERR_FULSEEK,
  NETWIB_ERR_FULSTAT,
  NETWIB_ERR_FUMALLOC,
  NETWIB_ERR_FUMKDIR,
  NETWIB_ERR_FUMPROTECT,
  NETWIB_ERR_FUNANOSLEEP,
  NETWIB_ERR_FUOPEN,
  NETWIB_ERR_FUOPENDIR,
  NETWIB_ERR_FUOPENPROCESS,
  NETWIB_ERR_FUPACKETALLOCATEPACKET,
  NETWIB_ERR_FUPACKETGETNETTYPE,
  NETWIB_ERR_FUPACKETOPENADAPTER,
  NETWIB_ERR_FUPACKETREQUEST,
  NETWIB_ERR_FUPACKETSENDPACKET,
  NETWIB_ERR_FUPACKETSETBUFF,
  NETWIB_ERR_FUPCAPCOMPILE,
  NETWIB_ERR_FUPCAPDUMPOPEN,
  NETWIB_ERR_FUPCAPFINDALLDEVS,
  NETWIB_ERR_FUPCAPGETEVENT,
  NETWIB_ERR_FUPCAPOPENDEAD,
  NETWIB_ERR_FUPCAPOPENOFFLINE,
  NETWIB_ERR_FUPCAPSETFILTER,
  NETWIB_ERR_FUPEEKCONSOLEINPUT,
  NETWIB_ERR_FUPIPE,
  NETWIB_ERR_FUPOLL,
  NETWIB_ERR_FUPTHREADATTRINIT,
  NETWIB_ERR_FUPTHREADATTRDESTROY,
  NETWIB_ERR_FUPTHREADATTRSETDETACHSTATE,
  NETWIB_ERR_FUPTHREADCONDINIT,
  NETWIB_ERR_FUPTHREADCONDBROADCAST,
  NETWIB_ERR_FUPTHREADCONDDESTROY,
  NETWIB_ERR_FUPTHREADCONDTIMEDWAIT,
  NETWIB_ERR_FUPTHREADCONDWAIT,
  NETWIB_ERR_FUPTHREADCREATE,
  NETWIB_ERR_FUPTHREADDELAYNP,
  NETWIB_ERR_FUPTHREADGETEXPIRATIONNP,
  NETWIB_ERR_FUPTHREADGETSPECIFIC,
  NETWIB_ERR_FUPTHREADJOIN,
  NETWIB_ERR_FUPTHREADKEYCREATE,
  NETWIB_ERR_FUPTHREADKEYDELETE,
  NETWIB_ERR_FUPTHREADMUTEXINIT,
  NETWIB_ERR_FUPTHREADMUTEXDESTROY,
  NETWIB_ERR_FUPTHREADMUTEXLOCK,
  NETWIB_ERR_FUPTHREADMUTEXTIMEDLOCK,
  NETWIB_ERR_FUPTHREADMUTEXTRYLOCK,
  NETWIB_ERR_FUPTHREADMUTEXUNLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKINIT,
  NETWIB_ERR_FUPTHREADRWLOCKDESTROY,
  NETWIB_ERR_FUPTHREADRWLOCKRDLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKWRLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKTIMEDRDLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKTIMEDWRLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKTRYRDLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKTRYWRLOCK,
  NETWIB_ERR_FUPTHREADRWLOCKUNLOCK,
  NETWIB_ERR_FUPTHREADSETSPECIFIC,
  NETWIB_ERR_FUPUTMSG,
  NETWIB_ERR_FUREAD,
  NETWIB_ERR_FUREADDIRR,
  NETWIB_ERR_FUREADLINK,
  NETWIB_ERR_FUREALLOC,
  NETWIB_ERR_FURECV,
  NETWIB_ERR_FURECVFROM,
  NETWIB_ERR_FUREGCLOSEKEY,
  NETWIB_ERR_FUREGCOMP,
  NETWIB_ERR_FUREGENUMKEY,
  NETWIB_ERR_FUREGENUMVALUE,
  NETWIB_ERR_FUREGOPENKEYEX,
  NETWIB_ERR_FUREGQUERYINFOKEY,
  NETWIB_ERR_FUREGQUERYVALUEEX,
  NETWIB_ERR_FURELEASEMUTEX,
  NETWIB_ERR_FURENAME,
  NETWIB_ERR_FURESETEVENT,
  NETWIB_ERR_FURMDIR,
  NETWIB_ERR_FUSELECT,
  NETWIB_ERR_FUSEND,
  NETWIB_ERR_FUSENDTO,
  NETWIB_ERR_FUSETEVENT,
  NETWIB_ERR_FUSETSOCKOPT,
  NETWIB_ERR_FUSIGNAL,
  NETWIB_ERR_FUSNMPEXTENSIONINIT,
  NETWIB_ERR_FUSNMPEXTENSIONQUERY,
  NETWIB_ERR_FUSOCKET,
  NETWIB_ERR_FUSYMLINK,
  NETWIB_ERR_FUSYSCTL,
  NETWIB_ERR_FUTCGETATTR,
  NETWIB_ERR_FUTCSETATTR,
  NETWIB_ERR_FUTERMINATEPROCESS,
  NETWIB_ERR_FUTLSALLOC,
  NETWIB_ERR_FUTLSFREE,
  NETWIB_ERR_FUTLSSETVALUE,
  NETWIB_ERR_FUUNLINK,
  NETWIB_ERR_FUVIRTUALALLOC,
  NETWIB_ERR_FUVIRTUALFREE,
  NETWIB_ERR_FUVIRTUALPROTECT,
  NETWIB_ERR_FUWAITFORSINGLEOBJECT,
  NETWIB_ERR_FUWAITPID,
  NETWIB_ERR_FUWRITE,
  NETWIB_ERR_FUWRITEFILE,
  NETWIB_ERR_FUWSACLEANUP,
  NETWIB_ERR_FUWSASTARTUP
} netwib_err;
