#ifndef NEUTRINO_SHELL_H
#define NEUTRINO_SHELL_H

#include "nomad-jukebox.h"

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct NeutrinoShellClass NeutrinoShellClass;
typedef struct NeutrinoShell NeutrinoShell;
typedef struct NeutrinoShellPrivate NeutrinoShellPrivate;

#define NEUTRINO_SHELL_TYPE	(neutrino_shell_get_type())
#define NEUTRINO_SHELL(obj)	(G_TYPE_CHECK_INSTANCE_CAST( (obj), NEUTRINO_SHELL_TYPE, NeutrinoShell))
#define NEUTRINO_SHELL_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST( (klass), NEUTRINO_SHELL_TYPE, NeutrinoShellClass))
#define NEUTRINO_IS_SHELL(obj)	(G_TYPE_CHECK_INSTANCE_TYPE( (obj), NEUTRINO_SHELL_TYPE ))

extern NeutrinoShell *neutrino_shell;

#ifndef NEUTRINO_WINDOW_DEFINED
#define NEUTRINO_WINDOW_DEFINED
typedef struct NeutrinoWindow NeutrinoWindow;
#endif

struct NeutrinoShell
{
	GObject parent;

	NeutrinoShellPrivate *priv;
};

struct NeutrinoShellClass
{
	GObjectClass parent_class;
	
};

GType neutrino_shell_get_type( void );

NeutrinoShell *neutrino_shell_new( void );

gboolean neutrino_shell_scan_jukeboxes( NeutrinoShell *shell );
guint neutrino_shell_get_jukeboxes( NeutrinoShell *shell );
NomadJukebox *neutrino_shell_get_nth_jukebox( NeutrinoShell *shell,
						 guint index );
NomadJukebox *neutrino_shell_get_jukebox_by_id( NeutrinoShell *shell,
						const gchar *id );

GList *neutrino_shell_get_window_list( NeutrinoShell *shell );
void neutrino_shell_close_all_windows( NeutrinoShell *shell );
NeutrinoWindow *neutrino_shell_create_window( NeutrinoShell *shell );

G_END_DECLS

#endif
