#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

njb_t njbs[ NJB_MAX_DEVICES ];

static void scanning( NomadJukebox *jukebox, guint jobid,
		gpointer data )
{
	printf( "Beginning track scan.....\n" );
}

static void track_add( NomadJukebox *jukebox, guint jobid,
		guint total_tracks, NomadTrack *track,
		gpointer data )
{
	gchar *artist;
	gchar *album;
	gchar *title;

	nomad_track_get( track, &artist, &title, &album,
			NULL, NULL, NULL, NULL, NULL, NULL,
			NULL, NULL );
	printf( "%s By %s on %s\n", title, artist, album );

	g_free( artist );
	g_free( album );
	g_free( title );
}

static void scanned( NomadJukebox *jukebox, guint jobid,
		guint total, gpointer data )
{
	gboolean *done;
	
	done = (gboolean *)data;
	printf( "\n\nScanned: %i Tracks\n", total );
	*done = TRUE;
}

int main()
{
	guint number;
	gboolean done;
	NomadJukebox *jukebox;

	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	
	jukebox = nomad_jukebox_new( &njbs[ 0 ] );
	if( ! nomad_jukebox_acquire( jukebox ) ) {
		fprintf( stderr, "failed to acquire jukebox" );
		return 0;
	}

	done = FALSE;
	g_signal_connect( G_OBJECT( jukebox ), "scanning_tracks",
			G_CALLBACK( scanning ), NULL );
	g_signal_connect( G_OBJECT( jukebox ), "track_add",
			G_CALLBACK( track_add ), NULL );
	g_signal_connect( G_OBJECT( jukebox ), "scanned_tracks",
			G_CALLBACK( scanned ), &done );
	
	nomad_jukebox_build_tracklist( jukebox );
	while( ! done ) {
		usleep( 100 );
	}
	nomad_jukebox_release( jukebox );

	return 0;
}
