/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddMatchValue.cpp: implementation of the DlgAddMatchValue class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddMatchValue.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddMatchValue, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddMatchValue::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddMatchValue::OnCancel)
END_EVENT_TABLE()

DlgAddMatchValue::DlgAddMatchValue(wxWindow * wParent, const mString & Value):wxDialog(wParent, (wxWindowID)-1, (Value.size()?_("Modify match value"):_("Add match value")), wxDefaultPosition)
{
	DlgAddMatchValue_SetWindow(this);
	if(Value.size())
		((wxTextCtrl *)FindWindow(IDC_VALUE))->SetValue(Value.c_str());
	CenterOnScreen();
	ShowModal();
}


DlgAddMatchValue::~DlgAddMatchValue()
{
}

const mString & DlgAddMatchValue::GetValue()
{
	return m_Value;
}

void DlgAddMatchValue::OnOk(wxCommandEvent& event)
{
	m_Value = ((wxTextCtrl *)FindWindow(IDC_VALUE))->GetValue().GetData();
	if(!m_Value.size()) return;
	Close(TRUE);
}
void DlgAddMatchValue::OnCancel(wxCommandEvent& event)
{
	Close(TRUE);
}
